define("core/local/reactive/statemanager",["exports"],(function(_exports){Object.defineProperty(_exports,"__esModule",{value:!0}),_exports.default=void 0;_exports.default=
/**
   * Reactive simple state manager.
   *
   * The state manager contains the state data, trigger update events and
   * can lock and unlock the state data.
   *
   * This file contains the three main elements of the state manager:
   * - State manager: the public class to alter the state, dispatch events and process update messages.
   * - Proxy handler: a private class to keep track of the state object changes.
   * - StateMap class: a private class extending Map class that triggers event when a state list is modifed.
   *
   * @module     core/local/reactive/stateManager
   * @class     core/local/reactive/stateManager
   * @copyright  2021 Ferran Recio <ferran@moodle.com>
   * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
   */
class{constructor(dispatchEvent,target){this.dispatchEvent=dispatchEvent,this.target=null!=target?target:document,this.readonly=!1,this.eventsToPublish=[],this.updateTypes={create:this.defaultCreate.bind(this),update:this.defaultUpdate.bind(this),delete:this.defaultDelete.bind(this),put:this.defaultPut.bind(this),override:this.defaultOverride.bind(this),remove:this.defaultRemove.bind(this),prepareFields:this.defaultPrepareFields.bind(this)},this.initialPromise=new Promise((resolve=>{this.target.addEventListener("state:loaded",(event=>{resolve(event.detail.state)}))}))}setInitialState(initialState){if(void 0!==this.state)throw Error("Initial state can only be initialized ones");const state=new Proxy({},new Handler("state",this,!0));for(const[prop,propValue]of Object.entries(initialState))state[prop]=propValue;this.state=state,this.readonly=!0,this.dispatchEvent({action:"state:loaded",state:this.state},this.target)}getInitialPromise(){return this.initialPromise}setReadOnly(readonly){this.readonly=readonly;let mode="off";this.readonly&&(mode="on",this._publishEvents()),this.dispatchEvent({action:"readmode:".concat(mode),state:this.state,element:null},this.target)}addUpdateTypes(newFunctions){for(const[updateType,updateFunction]of Object.entries(newFunctions))"function"==typeof updateFunction&&(this.updateTypes[updateType]=updateFunction.bind(newFunctions))}processUpdates(updates,updateTypes){if(!Array.isArray(updates))throw Error("State updates must be an array");this.setReadOnly(!1),updates.forEach((update=>{if(void 0===update.name)throw Error("Missing state update name");this.processUpdate(update.name,update.action,update.fields,updateTypes)})),this.setReadOnly(!0)}processUpdate(updateName,action,fields,updateTypes){var _action,_updateTypes$action,_updateTypes$prepareF;if(!fields)throw Error("Missing state update fields");void 0===updateTypes&&(updateTypes={});const method=null!==(_updateTypes$action=updateTypes[action=null!==(_action=action)&&void 0!==_action?_action:"update"])&&void 0!==_updateTypes$action?_updateTypes$action:this.updateTypes[action];if(void 0===method)throw Error("Unkown update action ".concat(action));method(this,updateName,(null!==(_updateTypes$prepareF=updateTypes.prepareFields)&&void 0!==_updateTypes$prepareF?_updateTypes$prepareF:this.updateTypes.prepareFields)(this,updateName,fields))}defaultPrepareFields(stateManager,updateName,fields){return fields}defaultCreate(stateManager,updateName,fields){let state=stateManager.state;state[updateName]instanceof StateMap?state[updateName].add(fields):state[updateName]=fields}defaultDelete(stateManager,updateName,fields){if(!stateManager.get(updateName,fields.id))throw Error("Inexistent ".concat(updateName," ").concat(fields.id));let state=stateManager.state;state[updateName]instanceof StateMap?state[updateName].delete(fields.id):delete state[updateName]}defaultRemove(stateManager,updateName,fields){if(!stateManager.get(updateName,fields.id))return;let state=stateManager.state;state[updateName]instanceof StateMap?state[updateName].delete(fields.id):delete state[updateName]}defaultUpdate(stateManager,updateName,fields){let current=stateManager.get(updateName,fields.id);if(!current)throw Error("Inexistent ".concat(updateName," ").concat(fields.id));for(const[fieldName,fieldValue]of Object.entries(fields))current[fieldName]=fieldValue}defaultPut(stateManager,updateName,fields){let current=stateManager.get(updateName,fields.id);if(current)for(const[fieldName,fieldValue]of Object.entries(fields))current[fieldName]=fieldValue;else{let state=stateManager.state;if(state[updateName]instanceof StateMap)return void state[updateName].add(fields);state[updateName]=fields}}defaultOverride(stateManager,updateName,fields){let current=stateManager.get(updateName,fields.id);if(current){for(const[fieldName]of Object.entries(current))void 0===fields[fieldName]&&delete current[fieldName];for(const[fieldName,fieldValue]of Object.entries(fields))current[fieldName]=fieldValue}else{let state=stateManager.state;if(state[updateName]instanceof StateMap)return void state[updateName].add(fields);state[updateName]=fields}}get(name,id){const state=this.state;let current=state[name];if(current instanceof StateMap){if(void 0===id)throw Error("Missing id for ".concat(name," state update"));current=state[name].get(id)}return current}registerStateAction(field,prop,action,data){let parentAction="updated";null!==prop?this.eventsToPublish.push({eventName:"".concat(field,".").concat(prop,":").concat(action),eventData:data,action:action}):parentAction=action,void 0!==data.id&&(null!==prop&&this.eventsToPublish.push({eventName:"".concat(field,"[").concat(data.id,"].").concat(prop,":").concat(action),eventData:data,action:action}),this.eventsToPublish.push({eventName:"".concat(field,"[").concat(data.id,"]:").concat(parentAction),eventData:data,action:parentAction})),this.eventsToPublish.push({eventName:"".concat(field,":").concat(parentAction),eventData:data,action:parentAction}),this.eventsToPublish.push({eventName:"state:updated",eventData:data,action:"updated"})}_publishEvents(){const fieldChanges=this.eventsToPublish;this.eventsToPublish=[],this.dispatchEvent({action:"transaction:start",state:this.state,element:null,changes:fieldChanges},this.target),fieldChanges.sort(((a,b)=>{var _weights$a$action,_weights$b$action;const weights={created:0,updated:1,deleted:2},aweight=null!==(_weights$a$action=weights[a.action])&&void 0!==_weights$a$action?_weights$a$action:0,bweight=null!==(_weights$b$action=weights[b.action])&&void 0!==_weights$b$action?_weights$b$action:0;return aweight===bweight?a.eventName.length-b.eventName.length:aweight-bweight}));let publishedEvents=new Set;fieldChanges.forEach((event=>{var _event$eventData$id;const eventkey="".concat(event.eventName,".").concat(null!==(_event$eventData$id=event.eventData.id)&&void 0!==_event$eventData$id?_event$eventData$id:0);publishedEvents.has(eventkey)||(this.dispatchEvent({action:event.eventName,state:this.state,element:event.eventData},this.target),publishedEvents.add(eventkey))})),this.dispatchEvent({action:"transaction:end",state:this.state,element:null},this.target)}};class Handler{constructor(name,stateManager,proxyValues){this.name=name,this.stateManager=stateManager,this.proxyValues=null!=proxyValues&&proxyValues}set(obj,prop,value,receiver){if(this.stateManager.readonly)throw new Error("State locked. Use mutations to change ".concat(prop," value in ").concat(this.name,"."));if(JSON.stringify(obj[prop])===JSON.stringify(value))return!0;const action=void 0!==obj[prop]?"updated":"created";return this.proxyValues?Array.isArray(value)?obj[prop]=new StateMap(prop,this.stateManager).loadValues(value):obj[prop]=new Proxy(value,new Handler(prop,this.stateManager)):obj[prop]=value,void 0===this.stateManager.state||this.stateManager.registerStateAction(this.name,prop,action,receiver),!0}deleteProperty(obj,prop){if(this.stateManager.readonly)throw new Error("State locked. Use mutations to delete ".concat(prop," in ").concat(this.name,"."));return prop in obj&&(delete obj[prop],this.stateManager.registerStateAction(this.name,prop,"deleted",obj)),!0}}class StateMap extends Map{constructor(name,stateManager,iterable){super(iterable),this.name=name,this.stateManager=stateManager}set(key,value){if(this.stateManager.readonly)throw new Error("State locked. Use mutations to change ".concat(key," value in ").concat(this.name,"."));if(key=this.normalizeKey(key),this.checkValue(value),null==key)throw Error("State lists keys cannot be null or undefined");if(this.normalizeKey(value.id)!==key)throw new Error("State error: ".concat(this.name," list element ID (").concat(value.id,") and key (").concat(key,") mismatch"));const action=super.has(key)?"updated":"created",result=super.set(key,new Proxy(value,new Handler(this.name,this.stateManager)));return void 0===this.stateManager.state||this.stateManager.registerStateAction(this.name,null,action,super.get(key)),result}checkValue(value){if(void 0===value.id)throw Error("State lists elements must contain at least an id attribute")}normalizeKey(key){return String(key).valueOf()}add(value){return this.checkValue(value),this.set(value.id,value)}get(key){return super.get(this.normalizeKey(key))}has(key){return super.has(this.normalizeKey(key))}delete(key){if(key=this.normalizeKey(key),this.stateManager.readonly)throw new Error("State locked. Use mutations to change ".concat(key," value in ").concat(this.name,"."));const previous=super.get(key),result=super.delete(key);return result?(this.stateManager.registerStateAction(this.name,null,"deleted",previous),result):result}toJSON(){let result=[];return this.forEach((value=>{result.push(value)})),result}loadValues(values){return values.forEach((data=>{this.checkValue(data);let key=data.id,newvalue=new Proxy(data,new Handler(this.name,this.stateManager));this.set(key,newvalue)})),this}}return _exports.default}));

//# sourceMappingURL=statemanager.min.js.map