/**
 * @license
 * Video.js 7.17.0 <http://videojs.com/>
 * Copyright Brightcove, Inc. <https://www.brightcove.com/>
 * Available under Apache License Version 2.0
 * <https://github.com/videojs/video.js/blob/main/LICENSE>
 *
 * Includes vtt.js <https://github.com/mozilla/vtt.js>
 * Available under Apache License Version 2.0
 * <https://github.com/mozilla/vtt.js/blob/main/LICENSE>
 */
!function(global,factory){"object"==typeof exports&&"undefined"!=typeof module?module.exports=factory():"function"==typeof define&&define.amd?define("media_videojs/video-lazy",factory):(global="undefined"!=typeof globalThis?globalThis:global||self).videojs=factory()}(window,(function(){for(var browserApi,hooks_={},hooks=function(type,fn){return hooks_[type]=hooks_[type]||[],fn&&(hooks_[type]=hooks_[type].concat(fn)),hooks_[type]},removeHook=function(type,fn){var index=hooks(type).indexOf(fn);return!(index<=-1)&&(hooks_[type]=hooks_[type].slice(),hooks_[type].splice(index,1),!0)},FullscreenApi={prefixed:!0},apiMap=[["requestFullscreen","exitFullscreen","fullscreenElement","fullscreenEnabled","fullscreenchange","fullscreenerror","fullscreen"],["webkitRequestFullscreen","webkitExitFullscreen","webkitFullscreenElement","webkitFullscreenEnabled","webkitfullscreenchange","webkitfullscreenerror","-webkit-full-screen"],["mozRequestFullScreen","mozCancelFullScreen","mozFullScreenElement","mozFullScreenEnabled","mozfullscreenchange","mozfullscreenerror","-moz-full-screen"],["msRequestFullscreen","msExitFullscreen","msFullscreenElement","msFullscreenEnabled","MSFullscreenChange","MSFullscreenError","-ms-fullscreen"]],specApi=apiMap[0],i=0;i<apiMap.length;i++)if(apiMap[i][1]in document){browserApi=apiMap[i];break}if(browserApi){for(var _i=0;_i<browserApi.length;_i++)FullscreenApi[specApi[_i]]=browserApi[_i];FullscreenApi.prefixed=browserApi[0]!==specApi[0]}var history=[];var log$1=function createLogger$1(name){var logByType,level="info",log=function(){for(var _len=arguments.length,args=new Array(_len),_key=0;_key<_len;_key++)args[_key]=arguments[_key];logByType("log",level,args)};return logByType=function(name,log){return function(type,level,args){var lvl=log.levels[level],lvlRegExp=new RegExp("^("+lvl+")$");if("log"!==type&&args.unshift(type.toUpperCase()+":"),args.unshift(name+":"),history){history.push([].concat(args));var splice=history.length-1e3;history.splice(0,splice>0?splice:0)}if(window.console){var fn=window.console[type];fn||"debug"!==type||(fn=window.console.info||window.console.log),fn&&lvl&&lvlRegExp.test(type)&&fn[Array.isArray(args)?"apply":"call"](window.console,args)}}}(name,log),log.createLogger=function(subname){return createLogger$1(name+": "+subname)},log.levels={all:"debug|log|warn|error",off:"",debug:"debug|log|warn|error",info:"log|warn|error",warn:"warn|error",error:"error",DEFAULT:level},log.level=function(lvl){if("string"==typeof lvl){if(!log.levels.hasOwnProperty(lvl))throw new Error('"'+lvl+'" in not a valid log level');level=lvl}return level},(log.history=function(){return history?[].concat(history):[]}).filter=function(fname){return(history||[]).filter((function(historyItem){return new RegExp(".*"+fname+".*").test(historyItem[0])}))},log.history.clear=function(){history&&(history.length=0)},log.history.disable=function(){null!==history&&(history.length=0,history=null)},log.history.enable=function(){null===history&&(history=[])},log.error=function(){for(var _len2=arguments.length,args=new Array(_len2),_key2=0;_key2<_len2;_key2++)args[_key2]=arguments[_key2];return logByType("error",level,args)},log.warn=function(){for(var _len3=arguments.length,args=new Array(_len3),_key3=0;_key3<_len3;_key3++)args[_key3]=arguments[_key3];return logByType("warn",level,args)},log.debug=function(){for(var _len4=arguments.length,args=new Array(_len4),_key4=0;_key4<_len4;_key4++)args[_key4]=arguments[_key4];return logByType("debug",level,args)},log}("VIDEOJS"),createLogger=log$1.createLogger,commonjsGlobal="undefined"!=typeof globalThis?globalThis:"undefined"!=typeof window?window:"undefined"!=typeof global?global:"undefined"!=typeof self?self:{};function createCommonjsModule(fn,module){return fn(module={exports:{}},module.exports),module.exports}var _extends_1=createCommonjsModule((function(module){function _extends(){return module.exports=_extends=Object.assign||function(target){for(var i=1;i<arguments.length;i++){var source=arguments[i];for(var key in source)Object.prototype.hasOwnProperty.call(source,key)&&(target[key]=source[key])}return target},_extends.apply(this,arguments)}module.exports=_extends})),toString$1=Object.prototype.toString,keys=function(object){return isObject$1(object)?Object.keys(object):[]};function each(object,fn){keys(object).forEach((function(key){return fn(object[key],key)}))}function assign(target){for(var _len=arguments.length,sources=new Array(_len>1?_len-1:0),_key=1;_key<_len;_key++)sources[_key-1]=arguments[_key];return Object.assign?_extends_1.apply(void 0,[target].concat(sources)):(sources.forEach((function(source){source&&each(source,(function(value,key){target[key]=value}))})),target)}function isObject$1(value){return!!value&&"object"==typeof value}function isPlain(value){return isObject$1(value)&&"[object Object]"===toString$1.call(value)&&value.constructor===Object}function computedStyle(el,prop){if(!el||!prop)return"";if("function"==typeof window.getComputedStyle){var computedStyleValue;try{computedStyleValue=window.getComputedStyle(el)}catch(e){return""}return computedStyleValue?computedStyleValue.getPropertyValue(prop)||computedStyleValue[prop]:""}return""}var match,USER_AGENT=window.navigator&&window.navigator.userAgent||"",webkitVersionMap=/AppleWebKit\/([\d.]+)/i.exec(USER_AGENT),appleWebkitVersion=webkitVersionMap?parseFloat(webkitVersionMap.pop()):null,IS_IPOD=/iPod/i.test(USER_AGENT),IOS_VERSION=(match=USER_AGENT.match(/OS (\d+)_/i))&&match[1]?match[1]:null,IS_ANDROID=/Android/i.test(USER_AGENT),ANDROID_VERSION=function(){var match=USER_AGENT.match(/Android (\d+)(?:\.(\d+))?(?:\.(\d+))*/i);if(!match)return null;var major=match[1]&&parseFloat(match[1]),minor=match[2]&&parseFloat(match[2]);return major&&minor?parseFloat(match[1]+"."+match[2]):major||null}(),IS_NATIVE_ANDROID=IS_ANDROID&&ANDROID_VERSION<5&&appleWebkitVersion<537,IS_FIREFOX=/Firefox/i.test(USER_AGENT),IS_EDGE=/Edg/i.test(USER_AGENT),IS_CHROME=!IS_EDGE&&(/Chrome/i.test(USER_AGENT)||/CriOS/i.test(USER_AGENT)),CHROME_VERSION=function(){var match=USER_AGENT.match(/(Chrome|CriOS)\/(\d+)/);return match&&match[2]?parseFloat(match[2]):null}(),IE_VERSION=function(){var result=/MSIE\s(\d+)\.\d/.exec(USER_AGENT),version=result&&parseFloat(result[1]);return!version&&/Trident\/7.0/i.test(USER_AGENT)&&/rv:11.0/.test(USER_AGENT)&&(version=11),version}(),IS_SAFARI=/Safari/i.test(USER_AGENT)&&!IS_CHROME&&!IS_ANDROID&&!IS_EDGE,IS_WINDOWS=/Windows/i.test(USER_AGENT),TOUCH_ENABLED=Boolean(isReal()&&("ontouchstart"in window||window.navigator.maxTouchPoints||window.DocumentTouch&&window.document instanceof window.DocumentTouch)),IS_IPAD=/iPad/i.test(USER_AGENT)||IS_SAFARI&&TOUCH_ENABLED&&!/iPhone/i.test(USER_AGENT),IS_IPHONE=/iPhone/i.test(USER_AGENT)&&!IS_IPAD,IS_IOS=IS_IPHONE||IS_IPAD||IS_IPOD,IS_ANY_SAFARI=(IS_SAFARI||IS_IOS)&&!IS_CHROME,browser=Object.freeze({__proto__:null,IS_IPOD:IS_IPOD,IOS_VERSION:IOS_VERSION,IS_ANDROID:IS_ANDROID,ANDROID_VERSION:ANDROID_VERSION,IS_NATIVE_ANDROID:IS_NATIVE_ANDROID,IS_FIREFOX:IS_FIREFOX,IS_EDGE:IS_EDGE,IS_CHROME:IS_CHROME,CHROME_VERSION:CHROME_VERSION,IE_VERSION:IE_VERSION,IS_SAFARI:IS_SAFARI,IS_WINDOWS:IS_WINDOWS,TOUCH_ENABLED:TOUCH_ENABLED,IS_IPAD:IS_IPAD,IS_IPHONE:IS_IPHONE,IS_IOS:IS_IOS,IS_ANY_SAFARI:IS_ANY_SAFARI});function isNonBlankString(str){return"string"==typeof str&&Boolean(str.trim())}function throwIfWhitespace(str){if(str.indexOf(" ")>=0)throw new Error("class has illegal whitespace characters")}function isReal(){return document===window.document}function isEl(value){return isObject$1(value)&&1===value.nodeType}function isInFrame(){try{return window.parent!==window.self}catch(x){return!0}}function createQuerier(method){return function(selector,context){if(!isNonBlankString(selector))return document[method](null);isNonBlankString(context)&&(context=document.querySelector(context));var ctx=isEl(context)?context:document;return ctx[method]&&ctx[method](selector)}}function createEl(tagName,properties,attributes,content){void 0===tagName&&(tagName="div"),void 0===properties&&(properties={}),void 0===attributes&&(attributes={});var el=document.createElement(tagName);return Object.getOwnPropertyNames(properties).forEach((function(propName){var val=properties[propName];-1!==propName.indexOf("aria-")||"role"===propName||"type"===propName?(log$1.warn("Setting attributes in the second argument of createEl()\nhas been deprecated. Use the third argument instead.\ncreateEl(type, properties, attributes). Attempting to set "+propName+" to "+val+"."),el.setAttribute(propName,val)):"textContent"===propName?textContent(el,val):el[propName]===val&&"tabIndex"!==propName||(el[propName]=val)})),Object.getOwnPropertyNames(attributes).forEach((function(attrName){el.setAttribute(attrName,attributes[attrName])})),content&&appendContent(el,content),el}function textContent(el,text){return void 0===el.textContent?el.innerText=text:el.textContent=text,el}function prependTo(child,parent){parent.firstChild?parent.insertBefore(child,parent.firstChild):parent.appendChild(child)}function hasClass(element,classToCheck){return throwIfWhitespace(classToCheck),element.classList?element.classList.contains(classToCheck):(className=classToCheck,new RegExp("(^|\\s)"+className+"($|\\s)")).test(element.className);var className}function addClass(element,classToAdd){return element.classList?element.classList.add(classToAdd):hasClass(element,classToAdd)||(element.className=(element.className+" "+classToAdd).trim()),element}function removeClass(element,classToRemove){return element?(element.classList?element.classList.remove(classToRemove):(throwIfWhitespace(classToRemove),element.className=element.className.split(/\s+/).filter((function(c){return c!==classToRemove})).join(" ")),element):(log$1.warn("removeClass was called with an element that doesn't exist"),null)}function toggleClass(element,classToToggle,predicate){var has=hasClass(element,classToToggle);if("function"==typeof predicate&&(predicate=predicate(element,classToToggle)),"boolean"!=typeof predicate&&(predicate=!has),predicate!==has)return predicate?addClass(element,classToToggle):removeClass(element,classToToggle),element}function setAttributes(el,attributes){Object.getOwnPropertyNames(attributes).forEach((function(attrName){var attrValue=attributes[attrName];null==attrValue||!1===attrValue?el.removeAttribute(attrName):el.setAttribute(attrName,!0===attrValue?"":attrValue)}))}function getAttributes(tag){var obj={},knownBooleans=",autoplay,controls,playsinline,loop,muted,default,defaultMuted,";if(tag&&tag.attributes&&tag.attributes.length>0)for(var attrs=tag.attributes,i=attrs.length-1;i>=0;i--){var attrName=attrs[i].name,attrVal=attrs[i].value;"boolean"!=typeof tag[attrName]&&-1===knownBooleans.indexOf(","+attrName+",")||(attrVal=null!==attrVal),obj[attrName]=attrVal}return obj}function getAttribute(el,attribute){return el.getAttribute(attribute)}function setAttribute(el,attribute,value){el.setAttribute(attribute,value)}function removeAttribute(el,attribute){el.removeAttribute(attribute)}function blockTextSelection(){document.body.focus(),document.onselectstart=function(){return!1}}function unblockTextSelection(){document.onselectstart=function(){return!0}}function getBoundingClientRect(el){if(el&&el.getBoundingClientRect&&el.parentNode){var rect=el.getBoundingClientRect(),result={};return["bottom","height","left","right","top","width"].forEach((function(k){void 0!==rect[k]&&(result[k]=rect[k])})),result.height||(result.height=parseFloat(computedStyle(el,"height"))),result.width||(result.width=parseFloat(computedStyle(el,"width"))),result}}function findPosition(el){if(!el||el&&!el.offsetParent)return{left:0,top:0,width:0,height:0};for(var width=el.offsetWidth,height=el.offsetHeight,left=0,top=0;el.offsetParent&&el!==document[FullscreenApi.fullscreenElement];)left+=el.offsetLeft,top+=el.offsetTop,el=el.offsetParent;return{left:left,top:top,width:width,height:height}}function getPointerPosition(el,event){var translated={x:0,y:0};if(IS_IOS)for(var item=el;item&&"html"!==item.nodeName.toLowerCase();){var transform=computedStyle(item,"transform");if(/^matrix/.test(transform)){var values=transform.slice(7,-1).split(/,\s/).map(Number);translated.x+=values[4],translated.y+=values[5]}else if(/^matrix3d/.test(transform)){var _values=transform.slice(9,-1).split(/,\s/).map(Number);translated.x+=_values[12],translated.y+=_values[13]}item=item.parentNode}var position={},boxTarget=findPosition(event.target),box=findPosition(el),boxW=box.width,boxH=box.height,offsetY=event.offsetY-(box.top-boxTarget.top),offsetX=event.offsetX-(box.left-boxTarget.left);return event.changedTouches&&(offsetX=event.changedTouches[0].pageX-box.left,offsetY=event.changedTouches[0].pageY+box.top,IS_IOS&&(offsetX-=translated.x,offsetY-=translated.y)),position.y=1-Math.max(0,Math.min(1,offsetY/boxH)),position.x=Math.max(0,Math.min(1,offsetX/boxW)),position}function isTextNode(value){return isObject$1(value)&&3===value.nodeType}function emptyEl(el){for(;el.firstChild;)el.removeChild(el.firstChild);return el}function normalizeContent(content){return"function"==typeof content&&(content=content()),(Array.isArray(content)?content:[content]).map((function(value){return"function"==typeof value&&(value=value()),isEl(value)||isTextNode(value)?value:"string"==typeof value&&/\S/.test(value)?document.createTextNode(value):void 0})).filter((function(value){return value}))}function appendContent(el,content){return normalizeContent(content).forEach((function(node){return el.appendChild(node)})),el}function insertContent(el,content){return appendContent(emptyEl(el),content)}function isSingleLeftClick(event){return void 0===event.button&&void 0===event.buttons||(0===event.button&&void 0===event.buttons||("mouseup"===event.type&&0===event.button&&0===event.buttons||0===event.button&&1===event.buttons))}var videojs$1,$=createQuerier("querySelector"),$$=createQuerier("querySelectorAll"),Dom=Object.freeze({__proto__:null,isReal:isReal,isEl:isEl,isInFrame:isInFrame,createEl:createEl,textContent:textContent,prependTo:prependTo,hasClass:hasClass,addClass:addClass,removeClass:removeClass,toggleClass:toggleClass,setAttributes:setAttributes,getAttributes:getAttributes,getAttribute:getAttribute,setAttribute:setAttribute,removeAttribute:removeAttribute,blockTextSelection:blockTextSelection,unblockTextSelection:unblockTextSelection,getBoundingClientRect:getBoundingClientRect,findPosition:findPosition,getPointerPosition:getPointerPosition,isTextNode:isTextNode,emptyEl:emptyEl,normalizeContent:normalizeContent,appendContent:appendContent,insertContent:insertContent,isSingleLeftClick:isSingleLeftClick,$:$,$$:$$}),_windowLoaded=!1,autoSetup=function(){if(!1!==videojs$1.options.autoSetup){var vids=Array.prototype.slice.call(document.getElementsByTagName("video")),audios=Array.prototype.slice.call(document.getElementsByTagName("audio")),divs=Array.prototype.slice.call(document.getElementsByTagName("video-js")),mediaEls=vids.concat(audios,divs);if(mediaEls&&mediaEls.length>0)for(var i=0,e=mediaEls.length;i<e;i++){var mediaEl=mediaEls[i];if(!mediaEl||!mediaEl.getAttribute){autoSetupTimeout(1);break}void 0===mediaEl.player&&null!==mediaEl.getAttribute("data-setup")&&videojs$1(mediaEl)}else _windowLoaded||autoSetupTimeout(1)}};function autoSetupTimeout(wait,vjs){isReal()&&(vjs&&(videojs$1=vjs),window.setTimeout(autoSetup,wait))}function setWindowLoaded(){_windowLoaded=!0,window.removeEventListener("load",setWindowLoaded)}isReal()&&("complete"===document.readyState?setWindowLoaded():window.addEventListener("load",setWindowLoaded));var FakeWeakMap,createStyleElement=function(className){var style=document.createElement("style");return style.className=className,style},setTextContent=function(el,content){el.styleSheet?el.styleSheet.cssText=content:el.textContent=content},_guid=3;function newGUID(){return _guid++}window.WeakMap||(FakeWeakMap=function(){function FakeWeakMap(){this.vdata="vdata"+Math.floor(window.performance&&window.performance.now()||Date.now()),this.data={}}var _proto=FakeWeakMap.prototype;return _proto.set=function(key,value){var access=key[this.vdata]||newGUID();return key[this.vdata]||(key[this.vdata]=access),this.data[access]=value,this},_proto.get=function(key){var access=key[this.vdata];if(access)return this.data[access];log$1("We have no data for this element",key)},_proto.has=function(key){return key[this.vdata]in this.data},_proto.delete=function(key){var access=key[this.vdata];access&&(delete this.data[access],delete key[this.vdata])},FakeWeakMap}());var _supportsPassive,DomData=window.WeakMap?new WeakMap:new FakeWeakMap;function _cleanUpEvents(elem,type){if(DomData.has(elem)){var data=DomData.get(elem);0===data.handlers[type].length&&(delete data.handlers[type],elem.removeEventListener?elem.removeEventListener(type,data.dispatcher,!1):elem.detachEvent&&elem.detachEvent("on"+type,data.dispatcher)),Object.getOwnPropertyNames(data.handlers).length<=0&&(delete data.handlers,delete data.dispatcher,delete data.disabled),0===Object.getOwnPropertyNames(data).length&&DomData.delete(elem)}}function _handleMultipleEvents(fn,elem,types,callback){types.forEach((function(type){fn(elem,type,callback)}))}function fixEvent(event){if(event.fixed_)return event;function returnTrue(){return!0}function returnFalse(){return!1}if(!event||!event.isPropagationStopped||!event.isImmediatePropagationStopped){var old=event||window.event;for(var key in event={},old)"layerX"!==key&&"layerY"!==key&&"keyLocation"!==key&&"webkitMovementX"!==key&&"webkitMovementY"!==key&&("returnValue"===key&&old.preventDefault||(event[key]=old[key]));if(event.target||(event.target=event.srcElement||document),event.relatedTarget||(event.relatedTarget=event.fromElement===event.target?event.toElement:event.fromElement),event.preventDefault=function(){old.preventDefault&&old.preventDefault(),event.returnValue=!1,old.returnValue=!1,event.defaultPrevented=!0},event.defaultPrevented=!1,event.stopPropagation=function(){old.stopPropagation&&old.stopPropagation(),event.cancelBubble=!0,old.cancelBubble=!0,event.isPropagationStopped=returnTrue},event.isPropagationStopped=returnFalse,event.stopImmediatePropagation=function(){old.stopImmediatePropagation&&old.stopImmediatePropagation(),event.isImmediatePropagationStopped=returnTrue,event.stopPropagation()},event.isImmediatePropagationStopped=returnFalse,null!==event.clientX&&void 0!==event.clientX){var doc=document.documentElement,body=document.body;event.pageX=event.clientX+(doc&&doc.scrollLeft||body&&body.scrollLeft||0)-(doc&&doc.clientLeft||body&&body.clientLeft||0),event.pageY=event.clientY+(doc&&doc.scrollTop||body&&body.scrollTop||0)-(doc&&doc.clientTop||body&&body.clientTop||0)}event.which=event.charCode||event.keyCode,null!==event.button&&void 0!==event.button&&(event.button=1&event.button?0:4&event.button?1:2&event.button?2:0)}return event.fixed_=!0,event}var passiveEvents=["touchstart","touchmove"];function on(elem,type,fn){if(Array.isArray(type))return _handleMultipleEvents(on,elem,type,fn);DomData.has(elem)||DomData.set(elem,{});var data=DomData.get(elem);if(data.handlers||(data.handlers={}),data.handlers[type]||(data.handlers[type]=[]),fn.guid||(fn.guid=newGUID()),data.handlers[type].push(fn),data.dispatcher||(data.disabled=!1,data.dispatcher=function(event,hash){if(!data.disabled){event=fixEvent(event);var handlers=data.handlers[event.type];if(handlers)for(var handlersCopy=handlers.slice(0),m=0,n=handlersCopy.length;m<n&&!event.isImmediatePropagationStopped();m++)try{handlersCopy[m].call(elem,event,hash)}catch(e){log$1.error(e)}}}),1===data.handlers[type].length)if(elem.addEventListener){var options=!1;(function(){if("boolean"!=typeof _supportsPassive){_supportsPassive=!1;try{var opts=Object.defineProperty({},"passive",{get:function(){_supportsPassive=!0}});window.addEventListener("test",null,opts),window.removeEventListener("test",null,opts)}catch(e){}}return _supportsPassive})()&&passiveEvents.indexOf(type)>-1&&(options={passive:!0}),elem.addEventListener(type,data.dispatcher,options)}else elem.attachEvent&&elem.attachEvent("on"+type,data.dispatcher)}function off(elem,type,fn){if(DomData.has(elem)){var data=DomData.get(elem);if(data.handlers){if(Array.isArray(type))return _handleMultipleEvents(off,elem,type,fn);var removeType=function(el,t){data.handlers[t]=[],_cleanUpEvents(el,t)};if(void 0!==type){var handlers=data.handlers[type];if(handlers)if(fn){if(fn.guid)for(var n=0;n<handlers.length;n++)handlers[n].guid===fn.guid&&handlers.splice(n--,1);_cleanUpEvents(elem,type)}else removeType(elem,type)}else for(var t in data.handlers)Object.prototype.hasOwnProperty.call(data.handlers||{},t)&&removeType(elem,t)}}}function trigger(elem,event,hash){var elemData=DomData.has(elem)?DomData.get(elem):{},parent=elem.parentNode||elem.ownerDocument;if("string"==typeof event?event={type:event,target:elem}:event.target||(event.target=elem),event=fixEvent(event),elemData.dispatcher&&elemData.dispatcher.call(elem,event,hash),parent&&!event.isPropagationStopped()&&!0===event.bubbles)trigger.call(null,parent,event,hash);else if(!parent&&!event.defaultPrevented&&event.target&&event.target[event.type]){DomData.has(event.target)||DomData.set(event.target,{});var targetData=DomData.get(event.target);event.target[event.type]&&(targetData.disabled=!0,"function"==typeof event.target[event.type]&&event.target[event.type](),targetData.disabled=!1)}return!event.defaultPrevented}function one(elem,type,fn){if(Array.isArray(type))return _handleMultipleEvents(one,elem,type,fn);var func=function func(){off(elem,type,func),fn.apply(this,arguments)};func.guid=fn.guid=fn.guid||newGUID(),on(elem,type,func)}function any(elem,type,fn){var func=function func(){off(elem,type,func),fn.apply(this,arguments)};func.guid=fn.guid=fn.guid||newGUID(),on(elem,type,func)}var EVENT_MAP,Events=Object.freeze({__proto__:null,fixEvent:fixEvent,on:on,off:off,trigger:trigger,one:one,any:any}),bind=function(context,fn,uid){fn.guid||(fn.guid=newGUID());var bound=fn.bind(context);return bound.guid=uid?uid+"_"+fn.guid:fn.guid,bound},throttle=function(fn,wait){var last=window.performance.now();return function(){var now=window.performance.now();now-last>=wait&&(fn.apply(void 0,arguments),last=now)}},EventTarget$2=function(){};EventTarget$2.prototype.allowedEvents_={},EventTarget$2.prototype.on=function(type,fn){var ael=this.addEventListener;this.addEventListener=function(){},on(this,type,fn),this.addEventListener=ael},EventTarget$2.prototype.addEventListener=EventTarget$2.prototype.on,EventTarget$2.prototype.off=function(type,fn){off(this,type,fn)},EventTarget$2.prototype.removeEventListener=EventTarget$2.prototype.off,EventTarget$2.prototype.one=function(type,fn){var ael=this.addEventListener;this.addEventListener=function(){},one(this,type,fn),this.addEventListener=ael},EventTarget$2.prototype.any=function(type,fn){var ael=this.addEventListener;this.addEventListener=function(){},any(this,type,fn),this.addEventListener=ael},EventTarget$2.prototype.trigger=function(event){var type=event.type||event;"string"==typeof event&&(event={type:type}),event=fixEvent(event),this.allowedEvents_[type]&&this["on"+type]&&this["on"+type](event),trigger(this,event)},EventTarget$2.prototype.dispatchEvent=EventTarget$2.prototype.trigger,EventTarget$2.prototype.queueTrigger=function(event){var _this=this;EVENT_MAP||(EVENT_MAP=new Map);var type=event.type||event,map=EVENT_MAP.get(this);map||(map=new Map,EVENT_MAP.set(this,map));var oldTimeout=map.get(type);map.delete(type),window.clearTimeout(oldTimeout);var timeout=window.setTimeout((function(){0===map.size&&(map=null,EVENT_MAP.delete(_this)),_this.trigger(event)}),0);map.set(type,timeout)};var objName=function(obj){return"function"==typeof obj.name?obj.name():"string"==typeof obj.name?obj.name:obj.name_?obj.name_:obj.constructor&&obj.constructor.name?obj.constructor.name:typeof obj},isEvented=function(object){return object instanceof EventTarget$2||!!object.eventBusEl_&&["on","one","off","trigger"].every((function(k){return"function"==typeof object[k]}))},isValidEventType=function(type){return"string"==typeof type&&/\S/.test(type)||Array.isArray(type)&&!!type.length},validateTarget=function(target,obj,fnName){if(!target||!target.nodeName&&!isEvented(target))throw new Error("Invalid target for "+objName(obj)+"#"+fnName+"; must be a DOM node or evented object.")},validateEventType=function(type,obj,fnName){if(!isValidEventType(type))throw new Error("Invalid event type for "+objName(obj)+"#"+fnName+"; must be a non-empty string or array.")},validateListener=function(listener,obj,fnName){if("function"!=typeof listener)throw new Error("Invalid listener for "+objName(obj)+"#"+fnName+"; must be a function.")},normalizeListenArgs=function(self,args,fnName){var target,type,listener,isTargetingSelf=args.length<3||args[0]===self||args[0]===self.eventBusEl_;return isTargetingSelf?(target=self.eventBusEl_,args.length>=3&&args.shift(),type=args[0],listener=args[1]):(target=args[0],type=args[1],listener=args[2]),validateTarget(target,self,fnName),validateEventType(type,self,fnName),validateListener(listener,self,fnName),{isTargetingSelf:isTargetingSelf,target:target,type:type,listener:listener=bind(self,listener)}},listen=function(target,method,type,listener){validateTarget(target,target,method),target.nodeName?Events[method](target,type,listener):target[method](type,listener)},EventedMixin={on:function(){for(var _this=this,_len=arguments.length,args=new Array(_len),_key=0;_key<_len;_key++)args[_key]=arguments[_key];var _normalizeListenArgs=normalizeListenArgs(this,args,"on"),isTargetingSelf=_normalizeListenArgs.isTargetingSelf,target=_normalizeListenArgs.target,type=_normalizeListenArgs.type,listener=_normalizeListenArgs.listener;if(listen(target,"on",type,listener),!isTargetingSelf){var removeListenerOnDispose=function(){return _this.off(target,type,listener)};removeListenerOnDispose.guid=listener.guid;var removeRemoverOnTargetDispose=function(){return _this.off("dispose",removeListenerOnDispose)};removeRemoverOnTargetDispose.guid=listener.guid,listen(this,"on","dispose",removeListenerOnDispose),listen(target,"on","dispose",removeRemoverOnTargetDispose)}},one:function(){for(var _this2=this,_len2=arguments.length,args=new Array(_len2),_key2=0;_key2<_len2;_key2++)args[_key2]=arguments[_key2];var _normalizeListenArgs2=normalizeListenArgs(this,args,"one"),isTargetingSelf=_normalizeListenArgs2.isTargetingSelf,target=_normalizeListenArgs2.target,type=_normalizeListenArgs2.type,listener=_normalizeListenArgs2.listener;if(isTargetingSelf)listen(target,"one",type,listener);else{var wrapper=function wrapper(){_this2.off(target,type,wrapper);for(var _len3=arguments.length,largs=new Array(_len3),_key3=0;_key3<_len3;_key3++)largs[_key3]=arguments[_key3];listener.apply(null,largs)};wrapper.guid=listener.guid,listen(target,"one",type,wrapper)}},any:function(){for(var _this3=this,_len4=arguments.length,args=new Array(_len4),_key4=0;_key4<_len4;_key4++)args[_key4]=arguments[_key4];var _normalizeListenArgs3=normalizeListenArgs(this,args,"any"),isTargetingSelf=_normalizeListenArgs3.isTargetingSelf,target=_normalizeListenArgs3.target,type=_normalizeListenArgs3.type,listener=_normalizeListenArgs3.listener;if(isTargetingSelf)listen(target,"any",type,listener);else{var wrapper=function wrapper(){_this3.off(target,type,wrapper);for(var _len5=arguments.length,largs=new Array(_len5),_key5=0;_key5<_len5;_key5++)largs[_key5]=arguments[_key5];listener.apply(null,largs)};wrapper.guid=listener.guid,listen(target,"any",type,wrapper)}},off:function(targetOrType,typeOrListener,listener){if(!targetOrType||isValidEventType(targetOrType))off(this.eventBusEl_,targetOrType,typeOrListener);else{var target=targetOrType,type=typeOrListener;validateTarget(target,this,"off"),validateEventType(type,this,"off"),validateListener(listener,this,"off"),listener=bind(this,listener),this.off("dispose",listener),target.nodeName?(off(target,type,listener),off(target,"dispose",listener)):isEvented(target)&&(target.off(type,listener),target.off("dispose",listener))}},trigger:function(event,hash){validateTarget(this.eventBusEl_,this,"trigger");var type=event&&"string"!=typeof event?event.type:event;if(!isValidEventType(type)){var error="Invalid event type for "+objName(this)+"#trigger; must be a non-empty string or object with a type key that has a non-empty value.";if(!event)throw new Error(error);(this.log||log$1).error(error)}return trigger(this.eventBusEl_,event,hash)}};function evented(target,options){void 0===options&&(options={});var eventBusKey=options.eventBusKey;if(eventBusKey){if(!target[eventBusKey].nodeName)throw new Error('The eventBusKey "'+eventBusKey+'" does not refer to an element.');target.eventBusEl_=target[eventBusKey]}else target.eventBusEl_=createEl("span",{className:"vjs-event-bus"});return assign(target,EventedMixin),target.eventedCallbacks&&target.eventedCallbacks.forEach((function(callback){callback()})),target.on("dispose",(function(){target.off(),[target,target.el_,target.eventBusEl_].forEach((function(val){val&&DomData.has(val)&&DomData.delete(val)})),window.setTimeout((function(){target.eventBusEl_=null}),0)})),target}var StatefulMixin={state:{},setState:function(stateUpdates){var changes,_this=this;return"function"==typeof stateUpdates&&(stateUpdates=stateUpdates()),each(stateUpdates,(function(value,key){_this.state[key]!==value&&((changes=changes||{})[key]={from:_this.state[key],to:value}),_this.state[key]=value})),changes&&isEvented(this)&&this.trigger({changes:changes,type:"statechanged"}),changes}};function stateful(target,defaultState){return assign(target,StatefulMixin),target.state=assign({},target.state,defaultState),"function"==typeof target.handleStateChanged&&isEvented(target)&&target.on("statechanged",target.handleStateChanged),target}var toLowerCase=function(string){return"string"!=typeof string?string:string.replace(/./,(function(w){return w.toLowerCase()}))},toTitleCase$1=function(string){return"string"!=typeof string?string:string.replace(/./,(function(w){return w.toUpperCase()}))};function mergeOptions$3(){for(var result={},_len=arguments.length,sources=new Array(_len),_key=0;_key<_len;_key++)sources[_key]=arguments[_key];return sources.forEach((function(source){source&&each(source,(function(value,key){isPlain(value)?(isPlain(result[key])||(result[key]={}),result[key]=mergeOptions$3(result[key],value)):result[key]=value}))})),result}var MapSham=function(){function MapSham(){this.map_={}}var _proto=MapSham.prototype;return _proto.has=function(key){return key in this.map_},_proto.delete=function(key){var has=this.has(key);return delete this.map_[key],has},_proto.set=function(key,value){return this.map_[key]=value,this},_proto.forEach=function(callback,thisArg){for(var key in this.map_)callback.call(thisArg,this.map_[key],key,this)},MapSham}(),Map$1=window.Map?window.Map:MapSham,SetSham=function(){function SetSham(){this.set_={}}var _proto=SetSham.prototype;return _proto.has=function(key){return key in this.set_},_proto.delete=function(key){var has=this.has(key);return delete this.set_[key],has},_proto.add=function(key){return this.set_[key]=1,this},_proto.forEach=function(callback,thisArg){for(var key in this.set_)callback.call(thisArg,key,key,this)},SetSham}(),Set=window.Set?window.Set:SetSham,Component$1=function(){function Component(player,options,ready){if(!player&&this.play?this.player_=player=this:this.player_=player,this.isDisposed_=!1,this.parentComponent_=null,this.options_=mergeOptions$3({},this.options_),options=this.options_=mergeOptions$3(this.options_,options),this.id_=options.id||options.el&&options.el.id,!this.id_){var id=player&&player.id&&player.id()||"no_player";this.id_=id+"_component_"+newGUID()}this.name_=options.name||null,options.el?this.el_=options.el:!1!==options.createEl&&(this.el_=this.createEl()),!1!==options.evented&&(evented(this,{eventBusKey:this.el_?"el_":null}),this.handleLanguagechange=this.handleLanguagechange.bind(this),this.on(this.player_,"languagechange",this.handleLanguagechange)),stateful(this,this.constructor.defaultState),this.children_=[],this.childIndex_={},this.childNameIndex_={},this.setTimeoutIds_=new Set,this.setIntervalIds_=new Set,this.rafIds_=new Set,this.namedRafs_=new Map$1,this.clearingTimersOnDispose_=!1,!1!==options.initChildren&&this.initChildren(),this.ready(ready),!1!==options.reportTouchActivity&&this.enableTouchActivity()}var _proto=Component.prototype;return _proto.dispose=function(){if(!this.isDisposed_){if(this.readyQueue_&&(this.readyQueue_.length=0),this.trigger({type:"dispose",bubbles:!1}),this.isDisposed_=!0,this.children_)for(var i=this.children_.length-1;i>=0;i--)this.children_[i].dispose&&this.children_[i].dispose();this.children_=null,this.childIndex_=null,this.childNameIndex_=null,this.parentComponent_=null,this.el_&&(this.el_.parentNode&&this.el_.parentNode.removeChild(this.el_),this.el_=null),this.player_=null}},_proto.isDisposed=function(){return Boolean(this.isDisposed_)},_proto.player=function(){return this.player_},_proto.options=function(obj){return obj?(this.options_=mergeOptions$3(this.options_,obj),this.options_):this.options_},_proto.el=function(){return this.el_},_proto.createEl=function(tagName,properties,attributes){return createEl(tagName,properties,attributes)},_proto.localize=function(string,tokens,defaultValue){void 0===defaultValue&&(defaultValue=string);var code=this.player_.language&&this.player_.language(),languages=this.player_.languages&&this.player_.languages(),language=languages&&languages[code],primaryCode=code&&code.split("-")[0],primaryLang=languages&&languages[primaryCode],localizedString=defaultValue;return language&&language[string]?localizedString=language[string]:primaryLang&&primaryLang[string]&&(localizedString=primaryLang[string]),tokens&&(localizedString=localizedString.replace(/\{(\d+)\}/g,(function(match,index){var value=tokens[index-1],ret=value;return void 0===value&&(ret=match),ret}))),localizedString},_proto.handleLanguagechange=function(){},_proto.contentEl=function(){return this.contentEl_||this.el_},_proto.id=function(){return this.id_},_proto.name=function(){return this.name_},_proto.children=function(){return this.children_},_proto.getChildById=function(id){return this.childIndex_[id]},_proto.getChild=function(name){if(name)return this.childNameIndex_[name]},_proto.getDescendant=function(){for(var _len=arguments.length,names=new Array(_len),_key=0;_key<_len;_key++)names[_key]=arguments[_key];names=names.reduce((function(acc,n){return acc.concat(n)}),[]);for(var currentChild=this,i=0;i<names.length;i++)if(!(currentChild=currentChild.getChild(names[i]))||!currentChild.getChild)return;return currentChild},_proto.addChild=function(child,options,index){var component,componentName;if(void 0===options&&(options={}),void 0===index&&(index=this.children_.length),"string"==typeof child){componentName=toTitleCase$1(child);var componentClassName=options.componentClass||componentName;options.name=componentName;var ComponentClass=Component.getComponent(componentClassName);if(!ComponentClass)throw new Error("Component "+componentClassName+" does not exist");if("function"!=typeof ComponentClass)return null;component=new ComponentClass(this.player_||this,options)}else component=child;if(component.parentComponent_&&component.parentComponent_.removeChild(component),this.children_.splice(index,0,component),component.parentComponent_=this,"function"==typeof component.id&&(this.childIndex_[component.id()]=component),(componentName=componentName||component.name&&toTitleCase$1(component.name()))&&(this.childNameIndex_[componentName]=component,this.childNameIndex_[toLowerCase(componentName)]=component),"function"==typeof component.el&&component.el()){var refNode=null;this.children_[index+1]&&(this.children_[index+1].el_?refNode=this.children_[index+1].el_:isEl(this.children_[index+1])&&(refNode=this.children_[index+1])),this.contentEl().insertBefore(component.el(),refNode)}return component},_proto.removeChild=function(component){if("string"==typeof component&&(component=this.getChild(component)),component&&this.children_){for(var childFound=!1,i=this.children_.length-1;i>=0;i--)if(this.children_[i]===component){childFound=!0,this.children_.splice(i,1);break}if(childFound){component.parentComponent_=null,this.childIndex_[component.id()]=null,this.childNameIndex_[toTitleCase$1(component.name())]=null,this.childNameIndex_[toLowerCase(component.name())]=null;var compEl=component.el();compEl&&compEl.parentNode===this.contentEl()&&this.contentEl().removeChild(component.el())}}},_proto.initChildren=function(){var _this=this,children=this.options_.children;if(children){var workingChildren,parentOptions=this.options_,Tech=Component.getComponent("Tech");(workingChildren=Array.isArray(children)?children:Object.keys(children)).concat(Object.keys(this.options_).filter((function(child){return!workingChildren.some((function(wchild){return"string"==typeof wchild?child===wchild:child===wchild.name}))}))).map((function(child){var name,opts;return"string"==typeof child?opts=children[name=child]||_this.options_[name]||{}:(name=child.name,opts=child),{name:name,opts:opts}})).filter((function(child){var c=Component.getComponent(child.opts.componentClass||toTitleCase$1(child.name));return c&&!Tech.isTech(c)})).forEach((function(child){var name=child.name,opts=child.opts;if(void 0!==parentOptions[name]&&(opts=parentOptions[name]),!1!==opts){!0===opts&&(opts={}),opts.playerOptions=_this.options_.playerOptions;var newChild=_this.addChild(name,opts);newChild&&(_this[name]=newChild)}}))}},_proto.buildCSSClass=function(){return""},_proto.ready=function(fn,sync){if(void 0===sync&&(sync=!1),fn)return this.isReady_?void(sync?fn.call(this):this.setTimeout(fn,1)):(this.readyQueue_=this.readyQueue_||[],void this.readyQueue_.push(fn))},_proto.triggerReady=function(){this.isReady_=!0,this.setTimeout((function(){var readyQueue=this.readyQueue_;this.readyQueue_=[],readyQueue&&readyQueue.length>0&&readyQueue.forEach((function(fn){fn.call(this)}),this),this.trigger("ready")}),1)},_proto.$=function(selector,context){return $(selector,context||this.contentEl())},_proto.$$=function(selector,context){return $$(selector,context||this.contentEl())},_proto.hasClass=function(classToCheck){return hasClass(this.el_,classToCheck)},_proto.addClass=function(classToAdd){addClass(this.el_,classToAdd)},_proto.removeClass=function(classToRemove){removeClass(this.el_,classToRemove)},_proto.toggleClass=function(classToToggle,predicate){toggleClass(this.el_,classToToggle,predicate)},_proto.show=function(){this.removeClass("vjs-hidden")},_proto.hide=function(){this.addClass("vjs-hidden")},_proto.lockShowing=function(){this.addClass("vjs-lock-showing")},_proto.unlockShowing=function(){this.removeClass("vjs-lock-showing")},_proto.getAttribute=function(attribute){return getAttribute(this.el_,attribute)},_proto.setAttribute=function(attribute,value){setAttribute(this.el_,attribute,value)},_proto.removeAttribute=function(attribute){removeAttribute(this.el_,attribute)},_proto.width=function(num,skipListeners){return this.dimension("width",num,skipListeners)},_proto.height=function(num,skipListeners){return this.dimension("height",num,skipListeners)},_proto.dimensions=function(width,height){this.width(width,!0),this.height(height)},_proto.dimension=function(widthOrHeight,num,skipListeners){if(void 0!==num)return null!==num&&num==num||(num=0),-1!==(""+num).indexOf("%")||-1!==(""+num).indexOf("px")?this.el_.style[widthOrHeight]=num:this.el_.style[widthOrHeight]="auto"===num?"":num+"px",void(skipListeners||this.trigger("componentresize"));if(!this.el_)return 0;var val=this.el_.style[widthOrHeight],pxIndex=val.indexOf("px");return-1!==pxIndex?parseInt(val.slice(0,pxIndex),10):parseInt(this.el_["offset"+toTitleCase$1(widthOrHeight)],10)},_proto.currentDimension=function(widthOrHeight){var computedWidthOrHeight=0;if("width"!==widthOrHeight&&"height"!==widthOrHeight)throw new Error("currentDimension only accepts width or height value");if(computedWidthOrHeight=computedStyle(this.el_,widthOrHeight),0===(computedWidthOrHeight=parseFloat(computedWidthOrHeight))||isNaN(computedWidthOrHeight)){var rule="offset"+toTitleCase$1(widthOrHeight);computedWidthOrHeight=this.el_[rule]}return computedWidthOrHeight},_proto.currentDimensions=function(){return{width:this.currentDimension("width"),height:this.currentDimension("height")}},_proto.currentWidth=function(){return this.currentDimension("width")},_proto.currentHeight=function(){return this.currentDimension("height")},_proto.focus=function(){this.el_.focus()},_proto.blur=function(){this.el_.blur()},_proto.handleKeyDown=function(event){this.player_&&(event.stopPropagation(),this.player_.handleKeyDown(event))},_proto.handleKeyPress=function(event){this.handleKeyDown(event)},_proto.emitTapEvents=function(){var couldBeTap,touchStart=0,firstTouch=null;this.on("touchstart",(function(event){1===event.touches.length&&(firstTouch={pageX:event.touches[0].pageX,pageY:event.touches[0].pageY},touchStart=window.performance.now(),couldBeTap=!0)})),this.on("touchmove",(function(event){if(event.touches.length>1)couldBeTap=!1;else if(firstTouch){var xdiff=event.touches[0].pageX-firstTouch.pageX,ydiff=event.touches[0].pageY-firstTouch.pageY;Math.sqrt(xdiff*xdiff+ydiff*ydiff)>10&&(couldBeTap=!1)}}));var noTap=function(){couldBeTap=!1};this.on("touchleave",noTap),this.on("touchcancel",noTap),this.on("touchend",(function(event){(firstTouch=null,!0===couldBeTap)&&(window.performance.now()-touchStart<200&&(event.preventDefault(),this.trigger("tap")))}))},_proto.enableTouchActivity=function(){if(this.player()&&this.player().reportUserActivity){var touchHolding,report=bind(this.player(),this.player().reportUserActivity);this.on("touchstart",(function(){report(),this.clearInterval(touchHolding),touchHolding=this.setInterval(report,250)}));var touchEnd=function(event){report(),this.clearInterval(touchHolding)};this.on("touchmove",report),this.on("touchend",touchEnd),this.on("touchcancel",touchEnd)}},_proto.setTimeout=function(fn,timeout){var timeoutId,_this2=this;return fn=bind(this,fn),this.clearTimersOnDispose_(),timeoutId=window.setTimeout((function(){_this2.setTimeoutIds_.has(timeoutId)&&_this2.setTimeoutIds_.delete(timeoutId),fn()}),timeout),this.setTimeoutIds_.add(timeoutId),timeoutId},_proto.clearTimeout=function(timeoutId){return this.setTimeoutIds_.has(timeoutId)&&(this.setTimeoutIds_.delete(timeoutId),window.clearTimeout(timeoutId)),timeoutId},_proto.setInterval=function(fn,interval){fn=bind(this,fn),this.clearTimersOnDispose_();var intervalId=window.setInterval(fn,interval);return this.setIntervalIds_.add(intervalId),intervalId},_proto.clearInterval=function(intervalId){return this.setIntervalIds_.has(intervalId)&&(this.setIntervalIds_.delete(intervalId),window.clearInterval(intervalId)),intervalId},_proto.requestAnimationFrame=function(fn){var id,_this3=this;return this.supportsRaf_?(this.clearTimersOnDispose_(),fn=bind(this,fn),id=window.requestAnimationFrame((function(){_this3.rafIds_.has(id)&&_this3.rafIds_.delete(id),fn()})),this.rafIds_.add(id),id):this.setTimeout(fn,1e3/60)},_proto.requestNamedAnimationFrame=function(name,fn){var _this4=this;if(!this.namedRafs_.has(name)){this.clearTimersOnDispose_(),fn=bind(this,fn);var id=this.requestAnimationFrame((function(){fn(),_this4.namedRafs_.has(name)&&_this4.namedRafs_.delete(name)}));return this.namedRafs_.set(name,id),name}},_proto.cancelNamedAnimationFrame=function(name){this.namedRafs_.has(name)&&(this.cancelAnimationFrame(this.namedRafs_.get(name)),this.namedRafs_.delete(name))},_proto.cancelAnimationFrame=function(id){return this.supportsRaf_?(this.rafIds_.has(id)&&(this.rafIds_.delete(id),window.cancelAnimationFrame(id)),id):this.clearTimeout(id)},_proto.clearTimersOnDispose_=function(){var _this5=this;this.clearingTimersOnDispose_||(this.clearingTimersOnDispose_=!0,this.one("dispose",(function(){[["namedRafs_","cancelNamedAnimationFrame"],["rafIds_","cancelAnimationFrame"],["setTimeoutIds_","clearTimeout"],["setIntervalIds_","clearInterval"]].forEach((function(_ref){var idName=_ref[0],cancelName=_ref[1];_this5[idName].forEach((function(val,key){return _this5[cancelName](key)}))})),_this5.clearingTimersOnDispose_=!1})))},Component.registerComponent=function(name,ComponentToRegister){if("string"!=typeof name||!name)throw new Error('Illegal component name, "'+name+'"; must be a non-empty string.');var reason,Tech=Component.getComponent("Tech"),isTech=Tech&&Tech.isTech(ComponentToRegister),isComp=Component===ComponentToRegister||Component.prototype.isPrototypeOf(ComponentToRegister.prototype);if(isTech||!isComp)throw reason=isTech?"techs must be registered using Tech.registerTech()":"must be a Component subclass",new Error('Illegal component, "'+name+'"; '+reason+".");name=toTitleCase$1(name),Component.components_||(Component.components_={});var Player=Component.getComponent("Player");if("Player"===name&&Player&&Player.players){var players=Player.players,playerNames=Object.keys(players);if(players&&playerNames.length>0&&playerNames.map((function(pname){return players[pname]})).every(Boolean))throw new Error("Can not register Player component after player has been created.")}return Component.components_[name]=ComponentToRegister,Component.components_[toLowerCase(name)]=ComponentToRegister,ComponentToRegister},Component.getComponent=function(name){if(name&&Component.components_)return Component.components_[name]},Component}();Component$1.prototype.supportsRaf_="function"==typeof window.requestAnimationFrame&&"function"==typeof window.cancelAnimationFrame,Component$1.registerComponent("Component",Component$1);var assertThisInitialized=function(self){if(void 0===self)throw new ReferenceError("this hasn't been initialised - super() hasn't been called");return self};var inheritsLoose=function(subClass,superClass){subClass.prototype=Object.create(superClass.prototype),subClass.prototype.constructor=subClass,subClass.__proto__=superClass};function getRange(fnName,valueIndex,ranges,rangeIndex){return function(fnName,index,maxIndex){if("number"!=typeof index||index<0||index>maxIndex)throw new Error("Failed to execute '"+fnName+"' on 'TimeRanges': The index provided ("+index+") is non-numeric or out of bounds (0-"+maxIndex+").")}(fnName,rangeIndex,ranges.length-1),ranges[rangeIndex][valueIndex]}function createTimeRangesObj(ranges){var timeRangesObj;return timeRangesObj=void 0===ranges||0===ranges.length?{length:0,start:function(){throw new Error("This TimeRanges object is empty")},end:function(){throw new Error("This TimeRanges object is empty")}}:{length:ranges.length,start:getRange.bind(null,"start",0,ranges),end:getRange.bind(null,"end",1,ranges)},window.Symbol&&window.Symbol.iterator&&(timeRangesObj[window.Symbol.iterator]=function(){return(ranges||[]).values()}),timeRangesObj}function createTimeRanges(start,end){return Array.isArray(start)?createTimeRangesObj(start):void 0===start||void 0===end?createTimeRangesObj():createTimeRangesObj([[start,end]])}function bufferedPercent(buffered,duration){var start,end,bufferedDuration=0;if(!duration)return 0;buffered&&buffered.length||(buffered=createTimeRanges(0,0));for(var i=0;i<buffered.length;i++)start=buffered.start(i),(end=buffered.end(i))>duration&&(end=duration),bufferedDuration+=end-start;return bufferedDuration/duration}function MediaError(value){if(value instanceof MediaError)return value;"number"==typeof value?this.code=value:"string"==typeof value?this.message=value:isObject$1(value)&&("number"==typeof value.code&&(this.code=value.code),assign(this,value)),this.message||(this.message=MediaError.defaultMessages[this.code]||"")}MediaError.prototype.code=0,MediaError.prototype.message="",MediaError.prototype.status=null,MediaError.errorTypes=["MEDIA_ERR_CUSTOM","MEDIA_ERR_ABORTED","MEDIA_ERR_NETWORK","MEDIA_ERR_DECODE","MEDIA_ERR_SRC_NOT_SUPPORTED","MEDIA_ERR_ENCRYPTED"],MediaError.defaultMessages={1:"You aborted the media playback",2:"A network error caused the media download to fail part-way.",3:"The media playback was aborted due to a corruption problem or because the media used features your browser did not support.",4:"The media could not be loaded, either because the server or network failed or because the format is not supported.",5:"The media is encrypted and we do not have the keys to decrypt it."};for(var errNum=0;errNum<MediaError.errorTypes.length;errNum++)MediaError[MediaError.errorTypes[errNum]]=errNum,MediaError.prototype[MediaError.errorTypes[errNum]]=errNum;var tuple=function(obj,reviver){var json,error=null;try{json=JSON.parse(obj,reviver)}catch(err){error=err}return[error,json]};function isPromise(value){return null!=value&&"function"==typeof value.then}function silencePromise(value){isPromise(value)&&value.then(null,(function(e){}))}var trackToJson_=function(track){return["kind","label","language","id","inBandMetadataTrackDispatchType","mode","src"].reduce((function(acc,prop,i){return track[prop]&&(acc[prop]=track[prop]),acc}),{cues:track.cues&&Array.prototype.map.call(track.cues,(function(cue){return{startTime:cue.startTime,endTime:cue.endTime,text:cue.text,id:cue.id}}))})},textTrackConverter_textTracksToJson=function(tech){var trackEls=tech.$$("track"),trackObjs=Array.prototype.map.call(trackEls,(function(t){return t.track}));return Array.prototype.map.call(trackEls,(function(trackEl){var json=trackToJson_(trackEl.track);return trackEl.src&&(json.src=trackEl.src),json})).concat(Array.prototype.filter.call(tech.textTracks(),(function(track){return-1===trackObjs.indexOf(track)})).map(trackToJson_))},textTrackConverter_jsonToTextTracks=function(json,tech){return json.forEach((function(track){var addedTrack=tech.addRemoteTextTrack(track).track;!track.src&&track.cues&&track.cues.forEach((function(cue){return addedTrack.addCue(cue)}))})),tech.textTracks()},keycode=createCommonjsModule((function(module,exports){function keyCode(searchInput){if(searchInput&&"object"==typeof searchInput){var hasKeyCode=searchInput.which||searchInput.keyCode||searchInput.charCode;hasKeyCode&&(searchInput=hasKeyCode)}if("number"==typeof searchInput)return names[searchInput];var foundNamedKey,search=String(searchInput);return(foundNamedKey=codes[search.toLowerCase()])?foundNamedKey:(foundNamedKey=aliases[search.toLowerCase()])||(1===search.length?search.charCodeAt(0):void 0)}keyCode.isEventKey=function(event,nameOrCode){if(event&&"object"==typeof event){var keyCode=event.which||event.keyCode||event.charCode;if(null==keyCode)return!1;if("string"==typeof nameOrCode){var foundNamedKey;if(foundNamedKey=codes[nameOrCode.toLowerCase()])return foundNamedKey===keyCode;if(foundNamedKey=aliases[nameOrCode.toLowerCase()])return foundNamedKey===keyCode}else if("number"==typeof nameOrCode)return nameOrCode===keyCode;return!1}};var codes=(exports=module.exports=keyCode).code=exports.codes={backspace:8,tab:9,enter:13,shift:16,ctrl:17,alt:18,"pause/break":19,"caps lock":20,esc:27,space:32,"page up":33,"page down":34,end:35,home:36,left:37,up:38,right:39,down:40,insert:45,delete:46,command:91,"left command":91,"right command":93,"numpad *":106,"numpad +":107,"numpad -":109,"numpad .":110,"numpad /":111,"num lock":144,"scroll lock":145,"my computer":182,"my calculator":183,";":186,"=":187,",":188,"-":189,".":190,"/":191,"`":192,"[":219,"\\":220,"]":221,"'":222},aliases=exports.aliases={windows:91,"⇧":16,"⌥":18,"⌃":17,"⌘":91,ctl:17,control:17,option:18,pause:19,break:19,caps:20,return:13,escape:27,spc:32,spacebar:32,pgup:33,pgdn:34,ins:45,del:46,cmd:91};for(i=97;i<123;i++)codes[String.fromCharCode(i)]=i-32;for(var i=48;i<58;i++)codes[i-48]=i;for(i=1;i<13;i++)codes["f"+i]=i+111;for(i=0;i<10;i++)codes["numpad "+i]=i+96;var names=exports.names=exports.title={};for(i in codes)names[codes[i]]=i;for(var alias in aliases)codes[alias]=aliases[alias]}));keycode.code,keycode.codes,keycode.aliases,keycode.names,keycode.title;var ModalDialog=function(_Component){function ModalDialog(player,options){var _this;return(_this=_Component.call(this,player,options)||this).handleKeyDown_=function(e){return _this.handleKeyDown(e)},_this.close_=function(e){return _this.close(e)},_this.opened_=_this.hasBeenOpened_=_this.hasBeenFilled_=!1,_this.closeable(!_this.options_.uncloseable),_this.content(_this.options_.content),_this.contentEl_=createEl("div",{className:"vjs-modal-dialog-content"},{role:"document"}),_this.descEl_=createEl("p",{className:"vjs-modal-dialog-description vjs-control-text",id:_this.el().getAttribute("aria-describedby")}),textContent(_this.descEl_,_this.description()),_this.el_.appendChild(_this.descEl_),_this.el_.appendChild(_this.contentEl_),_this}inheritsLoose(ModalDialog,_Component);var _proto=ModalDialog.prototype;return _proto.createEl=function(){return _Component.prototype.createEl.call(this,"div",{className:this.buildCSSClass(),tabIndex:-1},{"aria-describedby":this.id()+"_description","aria-hidden":"true","aria-label":this.label(),role:"dialog"})},_proto.dispose=function(){this.contentEl_=null,this.descEl_=null,this.previouslyActiveEl_=null,_Component.prototype.dispose.call(this)},_proto.buildCSSClass=function(){return"vjs-modal-dialog vjs-hidden "+_Component.prototype.buildCSSClass.call(this)},_proto.label=function(){return this.localize(this.options_.label||"Modal Window")},_proto.description=function(){var desc=this.options_.description||this.localize("This is a modal window.");return this.closeable()&&(desc+=" "+this.localize("This modal can be closed by pressing the Escape key or activating the close button.")),desc},_proto.open=function(){if(!this.opened_){var player=this.player();this.trigger("beforemodalopen"),this.opened_=!0,(this.options_.fillAlways||!this.hasBeenOpened_&&!this.hasBeenFilled_)&&this.fill(),this.wasPlaying_=!player.paused(),this.options_.pauseOnOpen&&this.wasPlaying_&&player.pause(),this.on("keydown",this.handleKeyDown_),this.hadControls_=player.controls(),player.controls(!1),this.show(),this.conditionalFocus_(),this.el().setAttribute("aria-hidden","false"),this.trigger("modalopen"),this.hasBeenOpened_=!0}},_proto.opened=function(value){return"boolean"==typeof value&&this[value?"open":"close"](),this.opened_},_proto.close=function(){if(this.opened_){var player=this.player();this.trigger("beforemodalclose"),this.opened_=!1,this.wasPlaying_&&this.options_.pauseOnOpen&&player.play(),this.off("keydown",this.handleKeyDown_),this.hadControls_&&player.controls(!0),this.hide(),this.el().setAttribute("aria-hidden","true"),this.trigger("modalclose"),this.conditionalBlur_(),this.options_.temporary&&this.dispose()}},_proto.closeable=function(value){if("boolean"==typeof value){var closeable=this.closeable_=!!value,close=this.getChild("closeButton");if(closeable&&!close){var temp=this.contentEl_;this.contentEl_=this.el_,close=this.addChild("closeButton",{controlText:"Close Modal Dialog"}),this.contentEl_=temp,this.on(close,"close",this.close_)}!closeable&&close&&(this.off(close,"close",this.close_),this.removeChild(close),close.dispose())}return this.closeable_},_proto.fill=function(){this.fillWith(this.content())},_proto.fillWith=function(content){var contentEl=this.contentEl(),parentEl=contentEl.parentNode,nextSiblingEl=contentEl.nextSibling;this.trigger("beforemodalfill"),this.hasBeenFilled_=!0,parentEl.removeChild(contentEl),this.empty(),insertContent(contentEl,content),this.trigger("modalfill"),nextSiblingEl?parentEl.insertBefore(contentEl,nextSiblingEl):parentEl.appendChild(contentEl);var closeButton=this.getChild("closeButton");closeButton&&parentEl.appendChild(closeButton.el_)},_proto.empty=function(){this.trigger("beforemodalempty"),emptyEl(this.contentEl()),this.trigger("modalempty")},_proto.content=function(value){return void 0!==value&&(this.content_=value),this.content_},_proto.conditionalFocus_=function(){var activeEl=document.activeElement,playerEl=this.player_.el_;this.previouslyActiveEl_=null,(playerEl.contains(activeEl)||playerEl===activeEl)&&(this.previouslyActiveEl_=activeEl,this.focus())},_proto.conditionalBlur_=function(){this.previouslyActiveEl_&&(this.previouslyActiveEl_.focus(),this.previouslyActiveEl_=null)},_proto.handleKeyDown=function(event){if(event.stopPropagation(),keycode.isEventKey(event,"Escape")&&this.closeable())return event.preventDefault(),void this.close();if(keycode.isEventKey(event,"Tab")){for(var focusIndex,focusableEls=this.focusableEls_(),activeEl=this.el_.querySelector(":focus"),i=0;i<focusableEls.length;i++)if(activeEl===focusableEls[i]){focusIndex=i;break}document.activeElement===this.el_&&(focusIndex=0),event.shiftKey&&0===focusIndex?(focusableEls[focusableEls.length-1].focus(),event.preventDefault()):event.shiftKey||focusIndex!==focusableEls.length-1||(focusableEls[0].focus(),event.preventDefault())}},_proto.focusableEls_=function(){var allChildren=this.el_.querySelectorAll("*");return Array.prototype.filter.call(allChildren,(function(child){return(child instanceof window.HTMLAnchorElement||child instanceof window.HTMLAreaElement)&&child.hasAttribute("href")||(child instanceof window.HTMLInputElement||child instanceof window.HTMLSelectElement||child instanceof window.HTMLTextAreaElement||child instanceof window.HTMLButtonElement)&&!child.hasAttribute("disabled")||child instanceof window.HTMLIFrameElement||child instanceof window.HTMLObjectElement||child instanceof window.HTMLEmbedElement||child.hasAttribute("tabindex")&&-1!==child.getAttribute("tabindex")||child.hasAttribute("contenteditable")}))},ModalDialog}(Component$1);ModalDialog.prototype.options_={pauseOnOpen:!0,temporary:!0},Component$1.registerComponent("ModalDialog",ModalDialog);var TrackList=function(_EventTarget){function TrackList(tracks){var _this;void 0===tracks&&(tracks=[]),(_this=_EventTarget.call(this)||this).tracks_=[],Object.defineProperty(assertThisInitialized(_this),"length",{get:function(){return this.tracks_.length}});for(var i=0;i<tracks.length;i++)_this.addTrack(tracks[i]);return _this}inheritsLoose(TrackList,_EventTarget);var _proto=TrackList.prototype;return _proto.addTrack=function(track){var _this2=this,index=this.tracks_.length;""+index in this||Object.defineProperty(this,index,{get:function(){return this.tracks_[index]}}),-1===this.tracks_.indexOf(track)&&(this.tracks_.push(track),this.trigger({track:track,type:"addtrack",target:this})),track.labelchange_=function(){_this2.trigger({track:track,type:"labelchange",target:_this2})},isEvented(track)&&track.addEventListener("labelchange",track.labelchange_)},_proto.removeTrack=function(rtrack){for(var track,i=0,l=this.length;i<l;i++)if(this[i]===rtrack){(track=this[i]).off&&track.off(),this.tracks_.splice(i,1);break}track&&this.trigger({track:track,type:"removetrack",target:this})},_proto.getTrackById=function(id){for(var result=null,i=0,l=this.length;i<l;i++){var track=this[i];if(track.id===id){result=track;break}}return result},TrackList}(EventTarget$2);for(var event in TrackList.prototype.allowedEvents_={change:"change",addtrack:"addtrack",removetrack:"removetrack",labelchange:"labelchange"},TrackList.prototype.allowedEvents_)TrackList.prototype["on"+event]=null;var disableOthers$1=function(list,track){for(var i=0;i<list.length;i++)Object.keys(list[i]).length&&track.id!==list[i].id&&(list[i].enabled=!1)},AudioTrackList=function(_TrackList){function AudioTrackList(tracks){var _this;void 0===tracks&&(tracks=[]);for(var i=tracks.length-1;i>=0;i--)if(tracks[i].enabled){disableOthers$1(tracks,tracks[i]);break}return(_this=_TrackList.call(this,tracks)||this).changing_=!1,_this}inheritsLoose(AudioTrackList,_TrackList);var _proto=AudioTrackList.prototype;return _proto.addTrack=function(track){var _this2=this;track.enabled&&disableOthers$1(this,track),_TrackList.prototype.addTrack.call(this,track),track.addEventListener&&(track.enabledChange_=function(){_this2.changing_||(_this2.changing_=!0,disableOthers$1(_this2,track),_this2.changing_=!1,_this2.trigger("change"))},track.addEventListener("enabledchange",track.enabledChange_))},_proto.removeTrack=function(rtrack){_TrackList.prototype.removeTrack.call(this,rtrack),rtrack.removeEventListener&&rtrack.enabledChange_&&(rtrack.removeEventListener("enabledchange",rtrack.enabledChange_),rtrack.enabledChange_=null)},AudioTrackList}(TrackList),disableOthers=function(list,track){for(var i=0;i<list.length;i++)Object.keys(list[i]).length&&track.id!==list[i].id&&(list[i].selected=!1)},VideoTrackList=function(_TrackList){function VideoTrackList(tracks){var _this;void 0===tracks&&(tracks=[]);for(var i=tracks.length-1;i>=0;i--)if(tracks[i].selected){disableOthers(tracks,tracks[i]);break}return(_this=_TrackList.call(this,tracks)||this).changing_=!1,Object.defineProperty(assertThisInitialized(_this),"selectedIndex",{get:function(){for(var _i=0;_i<this.length;_i++)if(this[_i].selected)return _i;return-1},set:function(){}}),_this}inheritsLoose(VideoTrackList,_TrackList);var _proto=VideoTrackList.prototype;return _proto.addTrack=function(track){var _this2=this;track.selected&&disableOthers(this,track),_TrackList.prototype.addTrack.call(this,track),track.addEventListener&&(track.selectedChange_=function(){_this2.changing_||(_this2.changing_=!0,disableOthers(_this2,track),_this2.changing_=!1,_this2.trigger("change"))},track.addEventListener("selectedchange",track.selectedChange_))},_proto.removeTrack=function(rtrack){_TrackList.prototype.removeTrack.call(this,rtrack),rtrack.removeEventListener&&rtrack.selectedChange_&&(rtrack.removeEventListener("selectedchange",rtrack.selectedChange_),rtrack.selectedChange_=null)},VideoTrackList}(TrackList),TextTrackList=function(_TrackList){function TextTrackList(){return _TrackList.apply(this,arguments)||this}inheritsLoose(TextTrackList,_TrackList);var _proto=TextTrackList.prototype;return _proto.addTrack=function(track){var _this=this;_TrackList.prototype.addTrack.call(this,track),this.queueChange_||(this.queueChange_=function(){return _this.queueTrigger("change")}),this.triggerSelectedlanguagechange||(this.triggerSelectedlanguagechange_=function(){return _this.trigger("selectedlanguagechange")}),track.addEventListener("modechange",this.queueChange_);-1===["metadata","chapters"].indexOf(track.kind)&&track.addEventListener("modechange",this.triggerSelectedlanguagechange_)},_proto.removeTrack=function(rtrack){_TrackList.prototype.removeTrack.call(this,rtrack),rtrack.removeEventListener&&(this.queueChange_&&rtrack.removeEventListener("modechange",this.queueChange_),this.selectedlanguagechange_&&rtrack.removeEventListener("modechange",this.triggerSelectedlanguagechange_))},TextTrackList}(TrackList),HtmlTrackElementList=function(){function HtmlTrackElementList(trackElements){void 0===trackElements&&(trackElements=[]),this.trackElements_=[],Object.defineProperty(this,"length",{get:function(){return this.trackElements_.length}});for(var i=0,length=trackElements.length;i<length;i++)this.addTrackElement_(trackElements[i])}var _proto=HtmlTrackElementList.prototype;return _proto.addTrackElement_=function(trackElement){var index=this.trackElements_.length;""+index in this||Object.defineProperty(this,index,{get:function(){return this.trackElements_[index]}}),-1===this.trackElements_.indexOf(trackElement)&&this.trackElements_.push(trackElement)},_proto.getTrackElementByTrack_=function(track){for(var trackElement_,i=0,length=this.trackElements_.length;i<length;i++)if(track===this.trackElements_[i].track){trackElement_=this.trackElements_[i];break}return trackElement_},_proto.removeTrackElement_=function(trackElement){for(var i=0,length=this.trackElements_.length;i<length;i++)if(trackElement===this.trackElements_[i]){this.trackElements_[i].track&&"function"==typeof this.trackElements_[i].track.off&&this.trackElements_[i].track.off(),"function"==typeof this.trackElements_[i].off&&this.trackElements_[i].off(),this.trackElements_.splice(i,1);break}},HtmlTrackElementList}(),TextTrackCueList=function(){function TextTrackCueList(cues){TextTrackCueList.prototype.setCues_.call(this,cues),Object.defineProperty(this,"length",{get:function(){return this.length_}})}var _proto=TextTrackCueList.prototype;return _proto.setCues_=function(cues){var oldLength=this.length||0,i=0,l=cues.length;this.cues_=cues,this.length_=cues.length;var defineProp=function(index){""+index in this||Object.defineProperty(this,""+index,{get:function(){return this.cues_[index]}})};if(oldLength<l)for(i=oldLength;i<l;i++)defineProp.call(this,i)},_proto.getCueById=function(id){for(var result=null,i=0,l=this.length;i<l;i++){var cue=this[i];if(cue.id===id){result=cue;break}}return result},TextTrackCueList}(),VideoTrackKind={alternative:"alternative",captions:"captions",main:"main",sign:"sign",subtitles:"subtitles",commentary:"commentary"},AudioTrackKind={alternative:"alternative",descriptions:"descriptions",main:"main","main-desc":"main-desc",translation:"translation",commentary:"commentary"},TextTrackKind={subtitles:"subtitles",captions:"captions",descriptions:"descriptions",chapters:"chapters",metadata:"metadata"},TextTrackMode={disabled:"disabled",hidden:"hidden",showing:"showing"},Track=function(_EventTarget){function Track(options){var _this;void 0===options&&(options={}),_this=_EventTarget.call(this)||this;var trackProps={id:options.id||"vjs_track_"+newGUID(),kind:options.kind||"",language:options.language||""},label=options.label||"",_loop=function(key){Object.defineProperty(assertThisInitialized(_this),key,{get:function(){return trackProps[key]},set:function(){}})};for(var key in trackProps)_loop(key);return Object.defineProperty(assertThisInitialized(_this),"label",{get:function(){return label},set:function(newLabel){newLabel!==label&&(label=newLabel,this.trigger("labelchange"))}}),_this}return inheritsLoose(Track,_EventTarget),Track}(EventTarget$2),parseUrl=function(url){var props=["protocol","hostname","port","pathname","search","hash","host"],a=document.createElement("a");a.href=url;for(var details={},i=0;i<props.length;i++)details[props[i]]=a[props[i]];return"http:"===details.protocol&&(details.host=details.host.replace(/:80$/,"")),"https:"===details.protocol&&(details.host=details.host.replace(/:443$/,"")),details.protocol||(details.protocol=window.location.protocol),details.host||(details.host=window.location.host),details},getAbsoluteURL=function(url){if(!url.match(/^https?:\/\//)){var a=document.createElement("a");a.href=url,url=a.href}return url},getFileExtension=function(path){if("string"==typeof path){var pathParts=/^(\/?)([\s\S]*?)((?:\.{1,2}|[^\/]+?)(\.([^\.\/\?]+)))(?:[\/]*|[\?].*)$/.exec(path);if(pathParts)return pathParts.pop().toLowerCase()}return""},isCrossOrigin=function(url,winLoc){void 0===winLoc&&(winLoc=window.location);var urlInfo=parseUrl(url);return(":"===urlInfo.protocol?winLoc.protocol:urlInfo.protocol)+urlInfo.host!==winLoc.protocol+winLoc.host},Url=Object.freeze({__proto__:null,parseUrl:parseUrl,getAbsoluteURL:getAbsoluteURL,getFileExtension:getFileExtension,isCrossOrigin:isCrossOrigin}),window_1="undefined"!=typeof window?window:void 0!==commonjsGlobal?commonjsGlobal:"undefined"!=typeof self?self:{},isFunction_1=function(fn){if(!fn)return!1;var string=toString.call(fn);return"[object Function]"===string||"function"==typeof fn&&"[object RegExp]"!==string||"undefined"!=typeof window&&(fn===window.setTimeout||fn===window.alert||fn===window.confirm||fn===window.prompt)},toString=Object.prototype.toString;var httpHandler=function(callback,decodeResponseBody){return void 0===decodeResponseBody&&(decodeResponseBody=!1),function(err,response,responseBody){if(err)callback(err);else if(response.statusCode>=400&&response.statusCode<=599){var cause=responseBody;if(decodeResponseBody)if(window_1.TextDecoder){var charset=function(contentTypeHeader){void 0===contentTypeHeader&&(contentTypeHeader="");return contentTypeHeader.toLowerCase().split(";").reduce((function(charset,contentType){var _contentType$split=contentType.split("="),type=_contentType$split[0],value=_contentType$split[1];return"charset"===type.trim()?value.trim():charset}),"utf-8")}(response.headers&&response.headers["content-type"]);try{cause=new TextDecoder(charset).decode(responseBody)}catch(e){}}else cause=String.fromCharCode.apply(null,new Uint8Array(responseBody));callback({cause:cause})}else callback(null,responseBody)}};createXHR.httpHandler=httpHandler;
/**
   * @license
   * slighly modified parse-headers 2.0.2 <https://github.com/kesla/parse-headers/>
   * Copyright (c) 2014 David Björklund
   * Available under the MIT license
   * <https://github.com/kesla/parse-headers/blob/master/LICENCE>
   */
var lib=createXHR,default_1=createXHR;function initParams(uri,options,callback){var params=uri;return isFunction_1(options)?(callback=options,"string"==typeof uri&&(params={uri:uri})):params=_extends_1({},options,{uri:uri}),params.callback=callback,params}function createXHR(uri,options,callback){return _createXHR(options=initParams(uri,options,callback))}function _createXHR(options){if(void 0===options.callback)throw new Error("callback argument missing");var called=!1,callback=function(err,response,body){called||(called=!0,options.callback(err,response,body))};function getBody(){var body=void 0;if(body=xhr.response?xhr.response:xhr.responseText||function(xhr){try{if("document"===xhr.responseType)return xhr.responseXML;var firefoxBugTakenEffect=xhr.responseXML&&"parsererror"===xhr.responseXML.documentElement.nodeName;if(""===xhr.responseType&&!firefoxBugTakenEffect)return xhr.responseXML}catch(e){}return null}(xhr),isJson)try{body=JSON.parse(body)}catch(e){}return body}function errorFunc(evt){return clearTimeout(timeoutTimer),evt instanceof Error||(evt=new Error(""+(evt||"Unknown XMLHttpRequest Error"))),evt.statusCode=0,callback(evt,failureResponse)}function loadFunc(){if(!aborted){var status;clearTimeout(timeoutTimer),status=options.useXDR&&void 0===xhr.status?200:1223===xhr.status?204:xhr.status;var response=failureResponse,err=null;return 0!==status?(response={body:getBody(),statusCode:status,method:method,headers:{},url:uri,rawRequest:xhr},xhr.getAllResponseHeaders&&(response.headers=function(headers){var result={};return headers?(headers.trim().split("\n").forEach((function(row){var index=row.indexOf(":"),key=row.slice(0,index).trim().toLowerCase(),value=row.slice(index+1).trim();void 0===result[key]?result[key]=value:Array.isArray(result[key])?result[key].push(value):result[key]=[result[key],value]})),result):result}(xhr.getAllResponseHeaders()))):err=new Error("Internal XMLHttpRequest Error"),callback(err,response,response.body)}}var key,aborted,xhr=options.xhr||null;xhr||(xhr=options.cors||options.useXDR?new createXHR.XDomainRequest:new createXHR.XMLHttpRequest);var timeoutTimer,uri=xhr.url=options.uri||options.url,method=xhr.method=options.method||"GET",body=options.body||options.data,headers=xhr.headers=options.headers||{},sync=!!options.sync,isJson=!1,failureResponse={body:void 0,headers:{},statusCode:0,method:method,url:uri,rawRequest:xhr};if("json"in options&&!1!==options.json&&(isJson=!0,headers.accept||headers.Accept||(headers.Accept="application/json"),"GET"!==method&&"HEAD"!==method&&(headers["content-type"]||headers["Content-Type"]||(headers["Content-Type"]="application/json"),body=JSON.stringify(!0===options.json?body:options.json))),xhr.onreadystatechange=function(){4===xhr.readyState&&setTimeout(loadFunc,0)},xhr.onload=loadFunc,xhr.onerror=errorFunc,xhr.onprogress=function(){},xhr.onabort=function(){aborted=!0},xhr.ontimeout=errorFunc,xhr.open(method,uri,!sync,options.username,options.password),sync||(xhr.withCredentials=!!options.withCredentials),!sync&&options.timeout>0&&(timeoutTimer=setTimeout((function(){if(!aborted){aborted=!0,xhr.abort("timeout");var e=new Error("XMLHttpRequest timeout");e.code="ETIMEDOUT",errorFunc(e)}}),options.timeout)),xhr.setRequestHeader)for(key in headers)headers.hasOwnProperty(key)&&xhr.setRequestHeader(key,headers[key]);else if(options.headers&&!function(obj){for(var i in obj)if(obj.hasOwnProperty(i))return!1;return!0}(options.headers))throw new Error("Headers cannot be set on an XDomainRequest object");return"responseType"in options&&(xhr.responseType=options.responseType),"beforeSend"in options&&"function"==typeof options.beforeSend&&options.beforeSend(xhr),xhr.send(body||null),xhr}createXHR.XMLHttpRequest=window_1.XMLHttpRequest||function(){},createXHR.XDomainRequest="withCredentials"in new createXHR.XMLHttpRequest?createXHR.XMLHttpRequest:window_1.XDomainRequest,function(array,iterator){for(var i=0;i<array.length;i++)iterator(array[i])}(["get","put","post","patch","head","delete"],(function(method){createXHR["delete"===method?"del":method]=function(uri,options,callback){return(options=initParams(uri,options,callback)).method=method.toUpperCase(),_createXHR(options)}})),lib.default=default_1;var parseCues=function(srcContent,track){var parser=new window.WebVTT.Parser(window,window.vttjs,window.WebVTT.StringDecoder()),errors=[];parser.oncue=function(cue){track.addCue(cue)},parser.onparsingerror=function(error){errors.push(error)},parser.onflush=function(){track.trigger({type:"loadeddata",target:track})},parser.parse(srcContent),errors.length>0&&(window.console&&window.console.groupCollapsed&&window.console.groupCollapsed("Text Track parsing errors for "+track.src),errors.forEach((function(error){return log$1.error(error)})),window.console&&window.console.groupEnd&&window.console.groupEnd()),parser.flush()},loadTrack=function(src,track){var opts={uri:src},crossOrigin=isCrossOrigin(src);crossOrigin&&(opts.cors=crossOrigin);var withCredentials="use-credentials"===track.tech_.crossOrigin();withCredentials&&(opts.withCredentials=withCredentials),lib(opts,bind(this,(function(err,response,responseBody){if(err)return log$1.error(err,response);track.loaded_=!0,"function"!=typeof window.WebVTT?track.tech_&&track.tech_.any(["vttjsloaded","vttjserror"],(function(event){if("vttjserror"!==event.type)return parseCues(responseBody,track);log$1.error("vttjs failed to load, stopping trying to process "+track.src)})):parseCues(responseBody,track)})))},TextTrack=function(_Track){function TextTrack(options){var _this;if(void 0===options&&(options={}),!options.tech)throw new Error("A tech was not provided.");var settings=mergeOptions$3(options,{kind:TextTrackKind[options.kind]||"subtitles",language:options.language||options.srclang||""}),mode=TextTrackMode[settings.mode]||"disabled",default_=settings.default;"metadata"!==settings.kind&&"chapters"!==settings.kind||(mode="hidden"),(_this=_Track.call(this,settings)||this).tech_=settings.tech,_this.cues_=[],_this.activeCues_=[],_this.preload_=!1!==_this.tech_.preloadTextTracks;var cues=new TextTrackCueList(_this.cues_),activeCues=new TextTrackCueList(_this.activeCues_),changed=!1,timeupdateHandler=bind(assertThisInitialized(_this),(function(){this.tech_.isReady_&&!this.tech_.isDisposed()&&(this.activeCues=this.activeCues,changed&&(this.trigger("cuechange"),changed=!1))}));return _this.tech_.one("dispose",(function(){_this.tech_.off("timeupdate",timeupdateHandler)})),"disabled"!==mode&&_this.tech_.on("timeupdate",timeupdateHandler),Object.defineProperties(assertThisInitialized(_this),{default:{get:function(){return default_},set:function(){}},mode:{get:function(){return mode},set:function(newMode){TextTrackMode[newMode]&&mode!==newMode&&(mode=newMode,this.preload_||"disabled"===mode||0!==this.cues.length||loadTrack(this.src,this),this.tech_.off("timeupdate",timeupdateHandler),"disabled"!==mode&&this.tech_.on("timeupdate",timeupdateHandler),this.trigger("modechange"))}},cues:{get:function(){return this.loaded_?cues:null},set:function(){}},activeCues:{get:function(){if(!this.loaded_)return null;if(0===this.cues.length)return activeCues;for(var ct=this.tech_.currentTime(),active=[],i=0,l=this.cues.length;i<l;i++){var cue=this.cues[i];(cue.startTime<=ct&&cue.endTime>=ct||cue.startTime===cue.endTime&&cue.startTime<=ct&&cue.startTime+.5>=ct)&&active.push(cue)}if(changed=!1,active.length!==this.activeCues_.length)changed=!0;else for(var _i=0;_i<active.length;_i++)-1===this.activeCues_.indexOf(active[_i])&&(changed=!0);return this.activeCues_=active,activeCues.setCues_(this.activeCues_),activeCues},set:function(){}}}),settings.src?(_this.src=settings.src,_this.preload_||(_this.loaded_=!0),(_this.preload_||"subtitles"!==settings.kind&&"captions"!==settings.kind)&&loadTrack(_this.src,assertThisInitialized(_this))):_this.loaded_=!0,_this}inheritsLoose(TextTrack,_Track);var _proto=TextTrack.prototype;return _proto.addCue=function(originalCue){var cue=originalCue;if(window.vttjs&&!(originalCue instanceof window.vttjs.VTTCue)){for(var prop in cue=new window.vttjs.VTTCue(originalCue.startTime,originalCue.endTime,originalCue.text),originalCue)prop in cue||(cue[prop]=originalCue[prop]);cue.id=originalCue.id,cue.originalCue_=originalCue}for(var tracks=this.tech_.textTracks(),i=0;i<tracks.length;i++)tracks[i]!==this&&tracks[i].removeCue(cue);this.cues_.push(cue),this.cues.setCues_(this.cues_)},_proto.removeCue=function(_removeCue){for(var i=this.cues_.length;i--;){var cue=this.cues_[i];if(cue===_removeCue||cue.originalCue_&&cue.originalCue_===_removeCue){this.cues_.splice(i,1),this.cues.setCues_(this.cues_);break}}},TextTrack}(Track);TextTrack.prototype.allowedEvents_={cuechange:"cuechange"};var AudioTrack=function(_Track){function AudioTrack(options){var _this;void 0===options&&(options={});var settings=mergeOptions$3(options,{kind:AudioTrackKind[options.kind]||""});_this=_Track.call(this,settings)||this;var enabled=!1;return Object.defineProperty(assertThisInitialized(_this),"enabled",{get:function(){return enabled},set:function(newEnabled){"boolean"==typeof newEnabled&&newEnabled!==enabled&&(enabled=newEnabled,this.trigger("enabledchange"))}}),settings.enabled&&(_this.enabled=settings.enabled),_this.loaded_=!0,_this}return inheritsLoose(AudioTrack,_Track),AudioTrack}(Track),VideoTrack=function(_Track){function VideoTrack(options){var _this;void 0===options&&(options={});var settings=mergeOptions$3(options,{kind:VideoTrackKind[options.kind]||""});_this=_Track.call(this,settings)||this;var selected=!1;return Object.defineProperty(assertThisInitialized(_this),"selected",{get:function(){return selected},set:function(newSelected){"boolean"==typeof newSelected&&newSelected!==selected&&(selected=newSelected,this.trigger("selectedchange"))}}),settings.selected&&(_this.selected=settings.selected),_this}return inheritsLoose(VideoTrack,_Track),VideoTrack}(Track),HTMLTrackElement=function(_EventTarget){function HTMLTrackElement(options){var _this,readyState;void 0===options&&(options={}),_this=_EventTarget.call(this)||this;var track=new TextTrack(options);return _this.kind=track.kind,_this.src=track.src,_this.srclang=track.language,_this.label=track.label,_this.default=track.default,Object.defineProperties(assertThisInitialized(_this),{readyState:{get:function(){return readyState}},track:{get:function(){return track}}}),readyState=0,track.addEventListener("loadeddata",(function(){readyState=2,_this.trigger({type:"load",target:assertThisInitialized(_this)})})),_this}return inheritsLoose(HTMLTrackElement,_EventTarget),HTMLTrackElement}(EventTarget$2);HTMLTrackElement.prototype.allowedEvents_={load:"load"},HTMLTrackElement.NONE=0,HTMLTrackElement.LOADING=1,HTMLTrackElement.LOADED=2,HTMLTrackElement.ERROR=3;var NORMAL={audio:{ListClass:AudioTrackList,TrackClass:AudioTrack,capitalName:"Audio"},video:{ListClass:VideoTrackList,TrackClass:VideoTrack,capitalName:"Video"},text:{ListClass:TextTrackList,TrackClass:TextTrack,capitalName:"Text"}};Object.keys(NORMAL).forEach((function(type){NORMAL[type].getterName=type+"Tracks",NORMAL[type].privateName=type+"Tracks_"}));var REMOTE={remoteText:{ListClass:TextTrackList,TrackClass:TextTrack,capitalName:"RemoteText",getterName:"remoteTextTracks",privateName:"remoteTextTracks_"},remoteTextEl:{ListClass:HtmlTrackElementList,TrackClass:HTMLTrackElement,capitalName:"RemoteTextTrackEls",getterName:"remoteTextTrackEls",privateName:"remoteTextTrackEls_"}},ALL=_extends_1({},NORMAL,REMOTE);REMOTE.names=Object.keys(REMOTE),NORMAL.names=Object.keys(NORMAL),ALL.names=[].concat(REMOTE.names).concat(NORMAL.names);var doccy,topLevel=void 0!==commonjsGlobal?commonjsGlobal:"undefined"!=typeof window?window:{};"undefined"!=typeof document?doccy=document:(doccy=topLevel["__GLOBAL_DOCUMENT_CACHE@4"])||(doccy=topLevel["__GLOBAL_DOCUMENT_CACHE@4"]={});var document_1=doccy,_objCreate=Object.create||function(){function F(){}return function(o){if(1!==arguments.length)throw new Error("Object.create shim only accepts one parameter.");return F.prototype=o,new F}}();function ParsingError(errorData,message){this.name="ParsingError",this.code=errorData.code,this.message=message||errorData.message}function parseTimeStamp(input){function computeSeconds(h,m,s,f){return 3600*(0|h)+60*(0|m)+(0|s)+(0|f)/1e3}var m=input.match(/^(\d+):(\d{1,2})(:\d{1,2})?\.(\d{3})/);return m?m[3]?computeSeconds(m[1],m[2],m[3].replace(":",""),m[4]):m[1]>59?computeSeconds(m[1],m[2],0,m[4]):computeSeconds(0,m[1],m[2],m[4]):null}function Settings(){this.values=_objCreate(null)}function parseOptions(input,callback,keyValueDelim,groupDelim){var groups=groupDelim?input.split(groupDelim):[input];for(var i in groups)if("string"==typeof groups[i]){var kv=groups[i].split(keyValueDelim);if(2===kv.length)callback(kv[0],kv[1])}}function parseCue(input,cue,regionList){var oInput=input;function consumeTimeStamp(){var ts=parseTimeStamp(input);if(null===ts)throw new ParsingError(ParsingError.Errors.BadTimeStamp,"Malformed timestamp: "+oInput);return input=input.replace(/^[^\sa-zA-Z-]+/,""),ts}function skipWhitespace(){input=input.replace(/^\s+/,"")}if(skipWhitespace(),cue.startTime=consumeTimeStamp(),skipWhitespace(),"--\x3e"!==input.substr(0,3))throw new ParsingError(ParsingError.Errors.BadTimeStamp,"Malformed time stamp (time stamps must be separated by '--\x3e'): "+oInput);input=input.substr(3),skipWhitespace(),cue.endTime=consumeTimeStamp(),skipWhitespace(),function(input,cue){var settings=new Settings;parseOptions(input,(function(k,v){switch(k){case"region":for(var i=regionList.length-1;i>=0;i--)if(regionList[i].id===v){settings.set(k,regionList[i].region);break}break;case"vertical":settings.alt(k,v,["rl","lr"]);break;case"line":var vals=v.split(","),vals0=vals[0];settings.integer(k,vals0),settings.percent(k,vals0)&&settings.set("snapToLines",!1),settings.alt(k,vals0,["auto"]),2===vals.length&&settings.alt("lineAlign",vals[1],["start","center","end"]);break;case"position":vals=v.split(","),settings.percent(k,vals[0]),2===vals.length&&settings.alt("positionAlign",vals[1],["start","center","end"]);break;case"size":settings.percent(k,v);break;case"align":settings.alt(k,v,["start","center","end","left","right"])}}),/:/,/\s/),cue.region=settings.get("region",null),cue.vertical=settings.get("vertical","");try{cue.line=settings.get("line","auto")}catch(e){}cue.lineAlign=settings.get("lineAlign","start"),cue.snapToLines=settings.get("snapToLines",!0),cue.size=settings.get("size",100);try{cue.align=settings.get("align","center")}catch(e){cue.align=settings.get("align","middle")}try{cue.position=settings.get("position","auto")}catch(e){cue.position=settings.get("position",{start:0,left:0,center:50,middle:50,end:100,right:100},cue.align)}cue.positionAlign=settings.get("positionAlign",{start:"start",left:"start",center:"center",middle:"center",end:"end",right:"end"},cue.align)}(input,cue)}ParsingError.prototype=_objCreate(Error.prototype),ParsingError.prototype.constructor=ParsingError,ParsingError.Errors={BadSignature:{code:0,message:"Malformed WebVTT signature."},BadTimeStamp:{code:1,message:"Malformed time stamp."}},Settings.prototype={set:function(k,v){this.get(k)||""===v||(this.values[k]=v)},get:function(k,dflt,defaultKey){return defaultKey?this.has(k)?this.values[k]:dflt[defaultKey]:this.has(k)?this.values[k]:dflt},has:function(k){return k in this.values},alt:function(k,v,a){for(var n=0;n<a.length;++n)if(v===a[n]){this.set(k,v);break}},integer:function(k,v){/^-?\d+$/.test(v)&&this.set(k,parseInt(v,10))},percent:function(k,v){return!!(v.match(/^([\d]{1,3})(\.[\d]*)?%$/)&&(v=parseFloat(v))>=0&&v<=100)&&(this.set(k,v),!0)}};var TEXTAREA_ELEMENT=document_1.createElement&&document_1.createElement("textarea"),TAG_NAME={c:"span",i:"i",b:"b",u:"u",ruby:"ruby",rt:"rt",v:"span",lang:"span"},DEFAULT_COLOR_CLASS={white:"rgba(255,255,255,1)",lime:"rgba(0,255,0,1)",cyan:"rgba(0,255,255,1)",red:"rgba(255,0,0,1)",yellow:"rgba(255,255,0,1)",magenta:"rgba(255,0,255,1)",blue:"rgba(0,0,255,1)",black:"rgba(0,0,0,1)"},TAG_ANNOTATION={v:"title",lang:"lang"},NEEDS_PARENT={rt:"ruby"};function parseContent(window,input){function nextToken(){if(!input)return null;var result,m=input.match(/^([^<]*)(<[^>]*>?)?/);return result=m[1]?m[1]:m[2],input=input.substr(result.length),result}function shouldAdd(current,element){return!NEEDS_PARENT[element.localName]||NEEDS_PARENT[element.localName]===current.localName}function createElement(type,annotation){var tagName=TAG_NAME[type];if(!tagName)return null;var element=window.document.createElement(tagName),name=TAG_ANNOTATION[type];return name&&annotation&&(element[name]=annotation.trim()),element}for(var t,s,rootDiv=window.document.createElement("div"),current=rootDiv,tagStack=[];null!==(t=nextToken());)if("<"!==t[0])current.appendChild(window.document.createTextNode((s=t,TEXTAREA_ELEMENT.innerHTML=s,s=TEXTAREA_ELEMENT.textContent,TEXTAREA_ELEMENT.textContent="",s)));else{if("/"===t[1]){tagStack.length&&tagStack[tagStack.length-1]===t.substr(2).replace(">","")&&(tagStack.pop(),current=current.parentNode);continue}var node,ts=parseTimeStamp(t.substr(1,t.length-2));if(ts){node=window.document.createProcessingInstruction("timestamp",ts),current.appendChild(node);continue}var m=t.match(/^<([^.\s/0-9>]+)(\.[^\s\\>]+)?([^>\\]+)?(\\?)>?$/);if(!m)continue;if(!(node=createElement(m[1],m[3])))continue;if(!shouldAdd(current,node))continue;if(m[2]){var classes=m[2].split(".");classes.forEach((function(cl){var bgColor=/^bg_/.test(cl),colorName=bgColor?cl.slice(3):cl;if(DEFAULT_COLOR_CLASS.hasOwnProperty(colorName)){var propName=bgColor?"background-color":"color",propValue=DEFAULT_COLOR_CLASS[colorName];node.style[propName]=propValue}})),node.className=classes.join(" ")}tagStack.push(m[1]),current.appendChild(node),current=node}return rootDiv}var strongRTLRanges=[[1470,1470],[1472,1472],[1475,1475],[1478,1478],[1488,1514],[1520,1524],[1544,1544],[1547,1547],[1549,1549],[1563,1563],[1566,1610],[1645,1647],[1649,1749],[1765,1766],[1774,1775],[1786,1805],[1807,1808],[1810,1839],[1869,1957],[1969,1969],[1984,2026],[2036,2037],[2042,2042],[2048,2069],[2074,2074],[2084,2084],[2088,2088],[2096,2110],[2112,2136],[2142,2142],[2208,2208],[2210,2220],[8207,8207],[64285,64285],[64287,64296],[64298,64310],[64312,64316],[64318,64318],[64320,64321],[64323,64324],[64326,64449],[64467,64829],[64848,64911],[64914,64967],[65008,65020],[65136,65140],[65142,65276],[67584,67589],[67592,67592],[67594,67637],[67639,67640],[67644,67644],[67647,67669],[67671,67679],[67840,67867],[67872,67897],[67903,67903],[67968,68023],[68030,68031],[68096,68096],[68112,68115],[68117,68119],[68121,68147],[68160,68167],[68176,68184],[68192,68223],[68352,68405],[68416,68437],[68440,68466],[68472,68479],[68608,68680],[126464,126467],[126469,126495],[126497,126498],[126500,126500],[126503,126503],[126505,126514],[126516,126519],[126521,126521],[126523,126523],[126530,126530],[126535,126535],[126537,126537],[126539,126539],[126541,126543],[126545,126546],[126548,126548],[126551,126551],[126553,126553],[126555,126555],[126557,126557],[126559,126559],[126561,126562],[126564,126564],[126567,126570],[126572,126578],[126580,126583],[126585,126588],[126590,126590],[126592,126601],[126603,126619],[126625,126627],[126629,126633],[126635,126651],[1114109,1114109]];function isStrongRTLChar(charCode){for(var i=0;i<strongRTLRanges.length;i++){var currentRange=strongRTLRanges[i];if(charCode>=currentRange[0]&&charCode<=currentRange[1])return!0}return!1}function determineBidi(cueDiv){var nodeStack=[],text="";if(!cueDiv||!cueDiv.childNodes)return"ltr";function pushNodes(nodeStack,node){for(var i=node.childNodes.length-1;i>=0;i--)nodeStack.push(node.childNodes[i])}function nextTextNode(nodeStack){if(!nodeStack||!nodeStack.length)return null;var node=nodeStack.pop(),text=node.textContent||node.innerText;if(text){var m=text.match(/^.*(\n|\r)/);return m?(nodeStack.length=0,m[0]):text}return"ruby"===node.tagName?nextTextNode(nodeStack):node.childNodes?(pushNodes(nodeStack,node),nextTextNode(nodeStack)):void 0}for(pushNodes(nodeStack,cueDiv);text=nextTextNode(nodeStack);)for(var i=0;i<text.length;i++)if(isStrongRTLChar(text.charCodeAt(i)))return"rtl";return"ltr"}function StyleBox(){}function CueStyleBox(window,cue,styleOptions){StyleBox.call(this),this.cue=cue,this.cueDiv=parseContent(window,cue.text);var styles={color:"rgba(255, 255, 255, 1)",backgroundColor:"rgba(0, 0, 0, 0.8)",position:"relative",left:0,right:0,top:0,bottom:0,display:"inline",writingMode:""===cue.vertical?"horizontal-tb":"lr"===cue.vertical?"vertical-lr":"vertical-rl",unicodeBidi:"plaintext"};this.applyStyles(styles,this.cueDiv),this.div=window.document.createElement("div"),styles={direction:determineBidi(this.cueDiv),writingMode:""===cue.vertical?"horizontal-tb":"lr"===cue.vertical?"vertical-lr":"vertical-rl",unicodeBidi:"plaintext",textAlign:"middle"===cue.align?"center":cue.align,font:styleOptions.font,whiteSpace:"pre-line",position:"absolute"},this.applyStyles(styles),this.div.appendChild(this.cueDiv);var textPos=0;switch(cue.positionAlign){case"start":textPos=cue.position;break;case"center":textPos=cue.position-cue.size/2;break;case"end":textPos=cue.position-cue.size}""===cue.vertical?this.applyStyles({left:this.formatStyle(textPos,"%"),width:this.formatStyle(cue.size,"%")}):this.applyStyles({top:this.formatStyle(textPos,"%"),height:this.formatStyle(cue.size,"%")}),this.move=function(box){this.applyStyles({top:this.formatStyle(box.top,"px"),bottom:this.formatStyle(box.bottom,"px"),left:this.formatStyle(box.left,"px"),right:this.formatStyle(box.right,"px"),height:this.formatStyle(box.height,"px"),width:this.formatStyle(box.width,"px")})}}function BoxPosition(obj){var lh,height,width,top;if(obj.div){height=obj.div.offsetHeight,width=obj.div.offsetWidth,top=obj.div.offsetTop;var rects=(rects=obj.div.childNodes)&&(rects=rects[0])&&rects.getClientRects&&rects.getClientRects();obj=obj.div.getBoundingClientRect(),lh=rects?Math.max(rects[0]&&rects[0].height||0,obj.height/rects.length):0}this.left=obj.left,this.right=obj.right,this.top=obj.top||top,this.height=obj.height||height,this.bottom=obj.bottom||top+(obj.height||height),this.width=obj.width||width,this.lineHeight=void 0!==lh?lh:obj.lineHeight}function moveBoxToLinePosition(window,styleBox,containerBox,boxPositions){var boxPosition=new BoxPosition(styleBox),cue=styleBox.cue,linePos=function(cue){if("number"==typeof cue.line&&(cue.snapToLines||cue.line>=0&&cue.line<=100))return cue.line;if(!cue.track||!cue.track.textTrackList||!cue.track.textTrackList.mediaElement)return-1;for(var track=cue.track,trackList=track.textTrackList,count=0,i=0;i<trackList.length&&trackList[i]!==track;i++)"showing"===trackList[i].mode&&count++;return-1*++count}(cue),axis=[];if(cue.snapToLines){var size;switch(cue.vertical){case"":axis=["+y","-y"],size="height";break;case"rl":axis=["+x","-x"],size="width";break;case"lr":axis=["-x","+x"],size="width"}var step=boxPosition.lineHeight,position=step*Math.round(linePos),maxPosition=containerBox[size]+step,initialAxis=axis[0];Math.abs(position)>maxPosition&&(position=position<0?-1:1,position*=Math.ceil(maxPosition/step)*step),linePos<0&&(position+=""===cue.vertical?containerBox.height:containerBox.width,axis=axis.reverse()),boxPosition.move(initialAxis,position)}else{var calculatedPercentage=boxPosition.lineHeight/containerBox.height*100;switch(cue.lineAlign){case"center":linePos-=calculatedPercentage/2;break;case"end":linePos-=calculatedPercentage}switch(cue.vertical){case"":styleBox.applyStyles({top:styleBox.formatStyle(linePos,"%")});break;case"rl":styleBox.applyStyles({left:styleBox.formatStyle(linePos,"%")});break;case"lr":styleBox.applyStyles({right:styleBox.formatStyle(linePos,"%")})}axis=["+y","-x","+x","-y"],boxPosition=new BoxPosition(styleBox)}var bestPosition=function(b,axis){for(var bestPosition,specifiedPosition=new BoxPosition(b),percentage=1,i=0;i<axis.length;i++){for(;b.overlapsOppositeAxis(containerBox,axis[i])||b.within(containerBox)&&b.overlapsAny(boxPositions);)b.move(axis[i]);if(b.within(containerBox))return b;var p=b.intersectPercentage(containerBox);percentage>p&&(bestPosition=new BoxPosition(b),percentage=p),b=new BoxPosition(specifiedPosition)}return bestPosition||specifiedPosition}(boxPosition,axis);styleBox.move(bestPosition.toCSSCompatValues(containerBox))}function WebVTT$1(){}StyleBox.prototype.applyStyles=function(styles,div){for(var prop in div=div||this.div,styles)styles.hasOwnProperty(prop)&&(div.style[prop]=styles[prop])},StyleBox.prototype.formatStyle=function(val,unit){return 0===val?0:val+unit},CueStyleBox.prototype=_objCreate(StyleBox.prototype),CueStyleBox.prototype.constructor=CueStyleBox,BoxPosition.prototype.move=function(axis,toMove){switch(toMove=void 0!==toMove?toMove:this.lineHeight,axis){case"+x":this.left+=toMove,this.right+=toMove;break;case"-x":this.left-=toMove,this.right-=toMove;break;case"+y":this.top+=toMove,this.bottom+=toMove;break;case"-y":this.top-=toMove,this.bottom-=toMove}},BoxPosition.prototype.overlaps=function(b2){return this.left<b2.right&&this.right>b2.left&&this.top<b2.bottom&&this.bottom>b2.top},BoxPosition.prototype.overlapsAny=function(boxes){for(var i=0;i<boxes.length;i++)if(this.overlaps(boxes[i]))return!0;return!1},BoxPosition.prototype.within=function(container){return this.top>=container.top&&this.bottom<=container.bottom&&this.left>=container.left&&this.right<=container.right},BoxPosition.prototype.overlapsOppositeAxis=function(container,axis){switch(axis){case"+x":return this.left<container.left;case"-x":return this.right>container.right;case"+y":return this.top<container.top;case"-y":return this.bottom>container.bottom}},BoxPosition.prototype.intersectPercentage=function(b2){return Math.max(0,Math.min(this.right,b2.right)-Math.max(this.left,b2.left))*Math.max(0,Math.min(this.bottom,b2.bottom)-Math.max(this.top,b2.top))/(this.height*this.width)},BoxPosition.prototype.toCSSCompatValues=function(reference){return{top:this.top-reference.top,bottom:reference.bottom-this.bottom,left:this.left-reference.left,right:reference.right-this.right,height:this.height,width:this.width}},BoxPosition.getSimpleBoxPosition=function(obj){var height=obj.div?obj.div.offsetHeight:obj.tagName?obj.offsetHeight:0,width=obj.div?obj.div.offsetWidth:obj.tagName?obj.offsetWidth:0,top=obj.div?obj.div.offsetTop:obj.tagName?obj.offsetTop:0;return{left:(obj=obj.div?obj.div.getBoundingClientRect():obj.tagName?obj.getBoundingClientRect():obj).left,right:obj.right,top:obj.top||top,height:obj.height||height,bottom:obj.bottom||top+(obj.height||height),width:obj.width||width}},WebVTT$1.StringDecoder=function(){return{decode:function(data){if(!data)return"";if("string"!=typeof data)throw new Error("Error - expected string data.");return decodeURIComponent(encodeURIComponent(data))}}},WebVTT$1.convertCueToDOMTree=function(window,cuetext){return window&&cuetext?parseContent(window,cuetext):null};WebVTT$1.processCues=function(window,cues,overlay){if(!window||!cues||!overlay)return null;for(;overlay.firstChild;)overlay.removeChild(overlay.firstChild);var paddedOverlay=window.document.createElement("div");if(paddedOverlay.style.position="absolute",paddedOverlay.style.left="0",paddedOverlay.style.right="0",paddedOverlay.style.top="0",paddedOverlay.style.bottom="0",paddedOverlay.style.margin="1.5%",overlay.appendChild(paddedOverlay),function(cues){for(var i=0;i<cues.length;i++)if(cues[i].hasBeenReset||!cues[i].displayState)return!0;return!1}(cues)){var boxPositions=[],containerBox=BoxPosition.getSimpleBoxPosition(paddedOverlay),styleOptions={font:Math.round(.05*containerBox.height*100)/100+"px sans-serif"};!function(){for(var styleBox,cue,i=0;i<cues.length;i++)cue=cues[i],styleBox=new CueStyleBox(window,cue,styleOptions),paddedOverlay.appendChild(styleBox.div),moveBoxToLinePosition(0,styleBox,containerBox,boxPositions),cue.displayState=styleBox.div,boxPositions.push(BoxPosition.getSimpleBoxPosition(styleBox))}()}else for(var i=0;i<cues.length;i++)paddedOverlay.appendChild(cues[i].displayState)},WebVTT$1.Parser=function(window,vttjs,decoder){decoder||(decoder=vttjs,vttjs={}),vttjs||(vttjs={}),this.window=window,this.vttjs=vttjs,this.state="INITIAL",this.buffer="",this.decoder=decoder||new TextDecoder("utf8"),this.regionList=[]},WebVTT$1.Parser.prototype={reportOrThrowError:function(e){if(!(e instanceof ParsingError))throw e;this.onparsingerror&&this.onparsingerror(e)},parse:function(data){var self=this;function collectNextLine(){for(var buffer=self.buffer,pos=0;pos<buffer.length&&"\r"!==buffer[pos]&&"\n"!==buffer[pos];)++pos;var line=buffer.substr(0,pos);return"\r"===buffer[pos]&&++pos,"\n"===buffer[pos]&&++pos,self.buffer=buffer.substr(pos),line}function parseHeader(input){input.match(/X-TIMESTAMP-MAP/)?parseOptions(input,(function(k,v){if("X-TIMESTAMP-MAP"===k)!function(input){var settings=new Settings;parseOptions(input,(function(k,v){switch(k){case"MPEGT":settings.integer(k+"S",v);break;case"LOCA":settings.set(k+"L",parseTimeStamp(v))}}),/[^\d]:/,/,/),self.ontimestampmap&&self.ontimestampmap({MPEGTS:settings.get("MPEGTS"),LOCAL:settings.get("LOCAL")})}(v)}),/=/):parseOptions(input,(function(k,v){if("Region"===k)!function(input){var settings=new Settings;if(parseOptions(input,(function(k,v){switch(k){case"id":settings.set(k,v);break;case"width":settings.percent(k,v);break;case"lines":settings.integer(k,v);break;case"regionanchor":case"viewportanchor":var xy=v.split(",");if(2!==xy.length)break;var anchor=new Settings;if(anchor.percent("x",xy[0]),anchor.percent("y",xy[1]),!anchor.has("x")||!anchor.has("y"))break;settings.set(k+"X",anchor.get("x")),settings.set(k+"Y",anchor.get("y"));break;case"scroll":settings.alt(k,v,["up"])}}),/=/,/\s/),settings.has("id")){var region=new(self.vttjs.VTTRegion||self.window.VTTRegion);region.width=settings.get("width",100),region.lines=settings.get("lines",3),region.regionAnchorX=settings.get("regionanchorX",0),region.regionAnchorY=settings.get("regionanchorY",100),region.viewportAnchorX=settings.get("viewportanchorX",0),region.viewportAnchorY=settings.get("viewportanchorY",100),region.scroll=settings.get("scroll",""),self.onregion&&self.onregion(region),self.regionList.push({id:settings.get("id"),region:region})}}(v)}),/:/)}data&&(self.buffer+=self.decoder.decode(data,{stream:!0}));try{var line;if("INITIAL"===self.state){if(!/\r\n|\n/.test(self.buffer))return this;var m=(line=collectNextLine()).match(/^WEBVTT([ \t].*)?$/);if(!m||!m[0])throw new ParsingError(ParsingError.Errors.BadSignature);self.state="HEADER"}for(var alreadyCollectedLine=!1;self.buffer;){if(!/\r\n|\n/.test(self.buffer))return this;switch(alreadyCollectedLine?alreadyCollectedLine=!1:line=collectNextLine(),self.state){case"HEADER":/:/.test(line)?parseHeader(line):line||(self.state="ID");continue;case"NOTE":line||(self.state="ID");continue;case"ID":if(/^NOTE($|[ \t])/.test(line)){self.state="NOTE";break}if(!line)continue;self.cue=new(self.vttjs.VTTCue||self.window.VTTCue)(0,0,"");try{self.cue.align="center"}catch(e){self.cue.align="middle"}if(self.state="CUE",-1===line.indexOf("--\x3e")){self.cue.id=line;continue}case"CUE":try{parseCue(line,self.cue,self.regionList)}catch(e){self.reportOrThrowError(e),self.cue=null,self.state="BADCUE";continue}self.state="CUETEXT";continue;case"CUETEXT":var hasSubstring=-1!==line.indexOf("--\x3e");if(!line||hasSubstring&&(alreadyCollectedLine=!0)){self.oncue&&self.oncue(self.cue),self.cue=null,self.state="ID";continue}self.cue.text&&(self.cue.text+="\n"),self.cue.text+=line.replace(/\u2028/g,"\n").replace(/u2029/g,"\n");continue;case"BADCUE":line||(self.state="ID");continue}}}catch(e){self.reportOrThrowError(e),"CUETEXT"===self.state&&self.cue&&self.oncue&&self.oncue(self.cue),self.cue=null,self.state="INITIAL"===self.state?"BADWEBVTT":"BADCUE"}return this},flush:function(){try{if(this.buffer+=this.decoder.decode(),(this.cue||"HEADER"===this.state)&&(this.buffer+="\n\n",this.parse()),"INITIAL"===this.state)throw new ParsingError(ParsingError.Errors.BadSignature)}catch(e){this.reportOrThrowError(e)}return this.onflush&&this.onflush(),this}};var vtt=WebVTT$1,directionSetting={"":1,lr:1,rl:1},alignSetting={start:1,center:1,end:1,left:1,right:1,auto:1,"line-left":1,"line-right":1};function findAlignSetting(value){return"string"==typeof value&&(!!alignSetting[value.toLowerCase()]&&value.toLowerCase())}function VTTCue(startTime,endTime,text){this.hasBeenReset=!1;var _id="",_pauseOnExit=!1,_startTime=startTime,_endTime=endTime,_text=text,_region=null,_vertical="",_snapToLines=!0,_line="auto",_lineAlign="start",_position="auto",_positionAlign="auto",_size=100,_align="center";Object.defineProperties(this,{id:{enumerable:!0,get:function(){return _id},set:function(value){_id=""+value}},pauseOnExit:{enumerable:!0,get:function(){return _pauseOnExit},set:function(value){_pauseOnExit=!!value}},startTime:{enumerable:!0,get:function(){return _startTime},set:function(value){if("number"!=typeof value)throw new TypeError("Start time must be set to a number.");_startTime=value,this.hasBeenReset=!0}},endTime:{enumerable:!0,get:function(){return _endTime},set:function(value){if("number"!=typeof value)throw new TypeError("End time must be set to a number.");_endTime=value,this.hasBeenReset=!0}},text:{enumerable:!0,get:function(){return _text},set:function(value){_text=""+value,this.hasBeenReset=!0}},region:{enumerable:!0,get:function(){return _region},set:function(value){_region=value,this.hasBeenReset=!0}},vertical:{enumerable:!0,get:function(){return _vertical},set:function(value){var setting=function(value){return"string"==typeof value&&!!directionSetting[value.toLowerCase()]&&value.toLowerCase()}(value);if(!1===setting)throw new SyntaxError("Vertical: an invalid or illegal direction string was specified.");_vertical=setting,this.hasBeenReset=!0}},snapToLines:{enumerable:!0,get:function(){return _snapToLines},set:function(value){_snapToLines=!!value,this.hasBeenReset=!0}},line:{enumerable:!0,get:function(){return _line},set:function(value){if("number"!=typeof value&&"auto"!==value)throw new SyntaxError("Line: an invalid number or illegal string was specified.");_line=value,this.hasBeenReset=!0}},lineAlign:{enumerable:!0,get:function(){return _lineAlign},set:function(value){var setting=findAlignSetting(value);setting?(_lineAlign=setting,this.hasBeenReset=!0):console.warn("lineAlign: an invalid or illegal string was specified.")}},position:{enumerable:!0,get:function(){return _position},set:function(value){if(value<0||value>100)throw new Error("Position must be between 0 and 100.");_position=value,this.hasBeenReset=!0}},positionAlign:{enumerable:!0,get:function(){return _positionAlign},set:function(value){var setting=findAlignSetting(value);setting?(_positionAlign=setting,this.hasBeenReset=!0):console.warn("positionAlign: an invalid or illegal string was specified.")}},size:{enumerable:!0,get:function(){return _size},set:function(value){if(value<0||value>100)throw new Error("Size must be between 0 and 100.");_size=value,this.hasBeenReset=!0}},align:{enumerable:!0,get:function(){return _align},set:function(value){var setting=findAlignSetting(value);if(!setting)throw new SyntaxError("align: an invalid or illegal alignment string was specified.");_align=setting,this.hasBeenReset=!0}}}),this.displayState=void 0}VTTCue.prototype.getCueAsHTML=function(){return WebVTT.convertCueToDOMTree(window,this.text)};var vttcue=VTTCue,scrollSetting={"":!0,up:!0};function isValidPercentValue(value){return"number"==typeof value&&value>=0&&value<=100}var vttregion=function(){var _width=100,_lines=3,_regionAnchorX=0,_regionAnchorY=100,_viewportAnchorX=0,_viewportAnchorY=100,_scroll="";Object.defineProperties(this,{width:{enumerable:!0,get:function(){return _width},set:function(value){if(!isValidPercentValue(value))throw new Error("Width must be between 0 and 100.");_width=value}},lines:{enumerable:!0,get:function(){return _lines},set:function(value){if("number"!=typeof value)throw new TypeError("Lines must be set to a number.");_lines=value}},regionAnchorY:{enumerable:!0,get:function(){return _regionAnchorY},set:function(value){if(!isValidPercentValue(value))throw new Error("RegionAnchorX must be between 0 and 100.");_regionAnchorY=value}},regionAnchorX:{enumerable:!0,get:function(){return _regionAnchorX},set:function(value){if(!isValidPercentValue(value))throw new Error("RegionAnchorY must be between 0 and 100.");_regionAnchorX=value}},viewportAnchorY:{enumerable:!0,get:function(){return _viewportAnchorY},set:function(value){if(!isValidPercentValue(value))throw new Error("ViewportAnchorY must be between 0 and 100.");_viewportAnchorY=value}},viewportAnchorX:{enumerable:!0,get:function(){return _viewportAnchorX},set:function(value){if(!isValidPercentValue(value))throw new Error("ViewportAnchorX must be between 0 and 100.");_viewportAnchorX=value}},scroll:{enumerable:!0,get:function(){return _scroll},set:function(value){var setting=function(value){return"string"==typeof value&&!!scrollSetting[value.toLowerCase()]&&value.toLowerCase()}(value);!1===setting?console.warn("Scroll: an invalid or illegal string was specified."):_scroll=setting}}})},browserIndex=createCommonjsModule((function(module){var vttjs=module.exports={WebVTT:vtt,VTTCue:vttcue,VTTRegion:vttregion};window_1.vttjs=vttjs,window_1.WebVTT=vttjs.WebVTT;var cueShim=vttjs.VTTCue,regionShim=vttjs.VTTRegion,nativeVTTCue=window_1.VTTCue,nativeVTTRegion=window_1.VTTRegion;vttjs.shim=function(){window_1.VTTCue=cueShim,window_1.VTTRegion=regionShim},vttjs.restore=function(){window_1.VTTCue=nativeVTTCue,window_1.VTTRegion=nativeVTTRegion},window_1.VTTCue||vttjs.shim()}));browserIndex.WebVTT,browserIndex.VTTCue,browserIndex.VTTRegion;var Tech=function(_Component){function Tech(options,ready){var _this;return void 0===options&&(options={}),void 0===ready&&(ready=function(){}),options.reportTouchActivity=!1,(_this=_Component.call(this,null,options,ready)||this).onDurationChange_=function(e){return _this.onDurationChange(e)},_this.trackProgress_=function(e){return _this.trackProgress(e)},_this.trackCurrentTime_=function(e){return _this.trackCurrentTime(e)},_this.stopTrackingCurrentTime_=function(e){return _this.stopTrackingCurrentTime(e)},_this.disposeSourceHandler_=function(e){return _this.disposeSourceHandler(e)},_this.hasStarted_=!1,_this.on("playing",(function(){this.hasStarted_=!0})),_this.on("loadstart",(function(){this.hasStarted_=!1})),ALL.names.forEach((function(name){var props=ALL[name];options&&options[props.getterName]&&(_this[props.privateName]=options[props.getterName])})),_this.featuresProgressEvents||_this.manualProgressOn(),_this.featuresTimeupdateEvents||_this.manualTimeUpdatesOn(),["Text","Audio","Video"].forEach((function(track){!1===options["native"+track+"Tracks"]&&(_this["featuresNative"+track+"Tracks"]=!1)})),!1===options.nativeCaptions||!1===options.nativeTextTracks?_this.featuresNativeTextTracks=!1:!0!==options.nativeCaptions&&!0!==options.nativeTextTracks||(_this.featuresNativeTextTracks=!0),_this.featuresNativeTextTracks||_this.emulateTextTracks(),_this.preloadTextTracks=!1!==options.preloadTextTracks,_this.autoRemoteTextTracks_=new ALL.text.ListClass,_this.initTrackListeners(),options.nativeControlsForTouch||_this.emitTapEvents(),_this.constructor&&(_this.name_=_this.constructor.name||"Unknown Tech"),_this}inheritsLoose(Tech,_Component);var _proto=Tech.prototype;return _proto.triggerSourceset=function(src){var _this2=this;this.isReady_||this.one("ready",(function(){return _this2.setTimeout((function(){return _this2.triggerSourceset(src)}),1)})),this.trigger({src:src,type:"sourceset"})},_proto.manualProgressOn=function(){this.on("durationchange",this.onDurationChange_),this.manualProgress=!0,this.one("ready",this.trackProgress_)},_proto.manualProgressOff=function(){this.manualProgress=!1,this.stopTrackingProgress(),this.off("durationchange",this.onDurationChange_)},_proto.trackProgress=function(event){this.stopTrackingProgress(),this.progressInterval=this.setInterval(bind(this,(function(){var numBufferedPercent=this.bufferedPercent();this.bufferedPercent_!==numBufferedPercent&&this.trigger("progress"),this.bufferedPercent_=numBufferedPercent,1===numBufferedPercent&&this.stopTrackingProgress()})),500)},_proto.onDurationChange=function(event){this.duration_=this.duration()},_proto.buffered=function(){return createTimeRanges(0,0)},_proto.bufferedPercent=function(){return bufferedPercent(this.buffered(),this.duration_)},_proto.stopTrackingProgress=function(){this.clearInterval(this.progressInterval)},_proto.manualTimeUpdatesOn=function(){this.manualTimeUpdates=!0,this.on("play",this.trackCurrentTime_),this.on("pause",this.stopTrackingCurrentTime_)},_proto.manualTimeUpdatesOff=function(){this.manualTimeUpdates=!1,this.stopTrackingCurrentTime(),this.off("play",this.trackCurrentTime_),this.off("pause",this.stopTrackingCurrentTime_)},_proto.trackCurrentTime=function(){this.currentTimeInterval&&this.stopTrackingCurrentTime(),this.currentTimeInterval=this.setInterval((function(){this.trigger({type:"timeupdate",target:this,manuallyTriggered:!0})}),250)},_proto.stopTrackingCurrentTime=function(){this.clearInterval(this.currentTimeInterval),this.trigger({type:"timeupdate",target:this,manuallyTriggered:!0})},_proto.dispose=function(){this.clearTracks(NORMAL.names),this.manualProgress&&this.manualProgressOff(),this.manualTimeUpdates&&this.manualTimeUpdatesOff(),_Component.prototype.dispose.call(this)},_proto.clearTracks=function(types){var _this3=this;(types=[].concat(types)).forEach((function(type){for(var list=_this3[type+"Tracks"]()||[],i=list.length;i--;){var track=list[i];"text"===type&&_this3.removeRemoteTextTrack(track),list.removeTrack(track)}}))},_proto.cleanupAutoTextTracks=function(){for(var list=this.autoRemoteTextTracks_||[],i=list.length;i--;){var track=list[i];this.removeRemoteTextTrack(track)}},_proto.reset=function(){},_proto.crossOrigin=function(){},_proto.setCrossOrigin=function(){},_proto.error=function(err){return void 0!==err&&(this.error_=new MediaError(err),this.trigger("error")),this.error_},_proto.played=function(){return this.hasStarted_?createTimeRanges(0,0):createTimeRanges()},_proto.play=function(){},_proto.setScrubbing=function(){},_proto.scrubbing=function(){},_proto.setCurrentTime=function(){this.manualTimeUpdates&&this.trigger({type:"timeupdate",target:this,manuallyTriggered:!0})},_proto.initTrackListeners=function(){var _this4=this;NORMAL.names.forEach((function(name){var props=NORMAL[name],trackListChanges=function(){_this4.trigger(name+"trackchange")},tracks=_this4[props.getterName]();tracks.addEventListener("removetrack",trackListChanges),tracks.addEventListener("addtrack",trackListChanges),_this4.on("dispose",(function(){tracks.removeEventListener("removetrack",trackListChanges),tracks.removeEventListener("addtrack",trackListChanges)}))}))},_proto.addWebVttScript_=function(){var _this5=this;if(!window.WebVTT)if(document.body.contains(this.el())){if(!this.options_["vtt.js"]&&isPlain(browserIndex)&&Object.keys(browserIndex).length>0)return void this.trigger("vttjsloaded");var script=document.createElement("script");script.src=this.options_["vtt.js"]||"https://vjs.zencdn.net/vttjs/0.14.1/vtt.min.js",script.onload=function(){_this5.trigger("vttjsloaded")},script.onerror=function(){_this5.trigger("vttjserror")},this.on("dispose",(function(){script.onload=null,script.onerror=null})),window.WebVTT=!0,this.el().parentNode.appendChild(script)}else this.ready(this.addWebVttScript_)},_proto.emulateTextTracks=function(){var _this6=this,tracks=this.textTracks(),remoteTracks=this.remoteTextTracks(),handleAddTrack=function(e){return tracks.addTrack(e.track)},handleRemoveTrack=function(e){return tracks.removeTrack(e.track)};remoteTracks.on("addtrack",handleAddTrack),remoteTracks.on("removetrack",handleRemoveTrack),this.addWebVttScript_();var updateDisplay=function(){return _this6.trigger("texttrackchange")},textTracksChanges=function(){updateDisplay();for(var i=0;i<tracks.length;i++){var track=tracks[i];track.removeEventListener("cuechange",updateDisplay),"showing"===track.mode&&track.addEventListener("cuechange",updateDisplay)}};textTracksChanges(),tracks.addEventListener("change",textTracksChanges),tracks.addEventListener("addtrack",textTracksChanges),tracks.addEventListener("removetrack",textTracksChanges),this.on("dispose",(function(){remoteTracks.off("addtrack",handleAddTrack),remoteTracks.off("removetrack",handleRemoveTrack),tracks.removeEventListener("change",textTracksChanges),tracks.removeEventListener("addtrack",textTracksChanges),tracks.removeEventListener("removetrack",textTracksChanges);for(var i=0;i<tracks.length;i++){tracks[i].removeEventListener("cuechange",updateDisplay)}}))},_proto.addTextTrack=function(kind,label,language){if(!kind)throw new Error("TextTrack kind is required but was not provided");return function(self,kind,label,language,options){void 0===options&&(options={});var tracks=self.textTracks();options.kind=kind,label&&(options.label=label),language&&(options.language=language),options.tech=self;var track=new ALL.text.TrackClass(options);return tracks.addTrack(track),track}(this,kind,label,language)},_proto.createRemoteTextTrack=function(options){var track=mergeOptions$3(options,{tech:this});return new REMOTE.remoteTextEl.TrackClass(track)},_proto.addRemoteTextTrack=function(options,manualCleanup){var _this7=this;void 0===options&&(options={});var htmlTrackElement=this.createRemoteTextTrack(options);return!0!==manualCleanup&&!1!==manualCleanup&&(log$1.warn('Calling addRemoteTextTrack without explicitly setting the "manualCleanup" parameter to `true` is deprecated and default to `false` in future version of video.js'),manualCleanup=!0),this.remoteTextTrackEls().addTrackElement_(htmlTrackElement),this.remoteTextTracks().addTrack(htmlTrackElement.track),!0!==manualCleanup&&this.ready((function(){return _this7.autoRemoteTextTracks_.addTrack(htmlTrackElement.track)})),htmlTrackElement},_proto.removeRemoteTextTrack=function(track){var trackElement=this.remoteTextTrackEls().getTrackElementByTrack_(track);this.remoteTextTrackEls().removeTrackElement_(trackElement),this.remoteTextTracks().removeTrack(track),this.autoRemoteTextTracks_.removeTrack(track)},_proto.getVideoPlaybackQuality=function(){return{}},_proto.requestPictureInPicture=function(){var PromiseClass=this.options_.Promise||window.Promise;if(PromiseClass)return PromiseClass.reject()},_proto.disablePictureInPicture=function(){return!0},_proto.setDisablePictureInPicture=function(){},_proto.setPoster=function(){},_proto.playsinline=function(){},_proto.setPlaysinline=function(){},_proto.overrideNativeAudioTracks=function(){},_proto.overrideNativeVideoTracks=function(){},_proto.canPlayType=function(){return""},Tech.canPlayType=function(){return""},Tech.canPlaySource=function(srcObj,options){return Tech.canPlayType(srcObj.type)},Tech.isTech=function(component){return component.prototype instanceof Tech||component instanceof Tech||component===Tech},Tech.registerTech=function(name,tech){if(Tech.techs_||(Tech.techs_={}),!Tech.isTech(tech))throw new Error("Tech "+name+" must be a Tech");if(!Tech.canPlayType)throw new Error("Techs must have a static canPlayType method on them");if(!Tech.canPlaySource)throw new Error("Techs must have a static canPlaySource method on them");return name=toTitleCase$1(name),Tech.techs_[name]=tech,Tech.techs_[toLowerCase(name)]=tech,"Tech"!==name&&Tech.defaultTechOrder_.push(name),tech},Tech.getTech=function(name){if(name)return Tech.techs_&&Tech.techs_[name]?Tech.techs_[name]:(name=toTitleCase$1(name),window&&window.videojs&&window.videojs[name]?(log$1.warn("The "+name+" tech was added to the videojs object when it should be registered using videojs.registerTech(name, tech)"),window.videojs[name]):void 0)},Tech}(Component$1);ALL.names.forEach((function(name){var props=ALL[name];Tech.prototype[props.getterName]=function(){return this[props.privateName]=this[props.privateName]||new props.ListClass,this[props.privateName]}})),Tech.prototype.featuresVolumeControl=!0,Tech.prototype.featuresMuteControl=!0,Tech.prototype.featuresFullscreenResize=!1,Tech.prototype.featuresPlaybackRate=!1,Tech.prototype.featuresProgressEvents=!1,Tech.prototype.featuresSourceset=!1,Tech.prototype.featuresTimeupdateEvents=!1,Tech.prototype.featuresNativeTextTracks=!1,Tech.withSourceHandlers=function(_Tech){_Tech.registerSourceHandler=function(handler,index){var handlers=_Tech.sourceHandlers;handlers||(handlers=_Tech.sourceHandlers=[]),void 0===index&&(index=handlers.length),handlers.splice(index,0,handler)},_Tech.canPlayType=function(type){for(var can,handlers=_Tech.sourceHandlers||[],i=0;i<handlers.length;i++)if(can=handlers[i].canPlayType(type))return can;return""},_Tech.selectSourceHandler=function(source,options){for(var handlers=_Tech.sourceHandlers||[],i=0;i<handlers.length;i++)if(handlers[i].canHandleSource(source,options))return handlers[i];return null},_Tech.canPlaySource=function(srcObj,options){var sh=_Tech.selectSourceHandler(srcObj,options);return sh?sh.canHandleSource(srcObj,options):""};["seekable","seeking","duration"].forEach((function(fnName){var originalFn=this[fnName];"function"==typeof originalFn&&(this[fnName]=function(){return this.sourceHandler_&&this.sourceHandler_[fnName]?this.sourceHandler_[fnName].apply(this.sourceHandler_,arguments):originalFn.apply(this,arguments)})}),_Tech.prototype),_Tech.prototype.setSource=function(source){var sh=_Tech.selectSourceHandler(source,this.options_);sh||(_Tech.nativeSourceHandler?sh=_Tech.nativeSourceHandler:log$1.error("No source handler found for the current source.")),this.disposeSourceHandler(),this.off("dispose",this.disposeSourceHandler_),sh!==_Tech.nativeSourceHandler&&(this.currentSource_=source),this.sourceHandler_=sh.handleSource(source,this,this.options_),this.one("dispose",this.disposeSourceHandler_)},_Tech.prototype.disposeSourceHandler=function(){this.currentSource_&&(this.clearTracks(["audio","video"]),this.currentSource_=null),this.cleanupAutoTextTracks(),this.sourceHandler_&&(this.sourceHandler_.dispose&&this.sourceHandler_.dispose(),this.sourceHandler_=null)}},Component$1.registerComponent("Tech",Tech),Tech.registerTech("Tech",Tech),Tech.defaultTechOrder_=[];var middlewares={},middlewareInstances={},TERMINATOR={};function setSource(player,src,next){player.setTimeout((function(){return setSourceHelper(src,middlewares[src.type],next,player)}),1)}function mediate(middleware,tech,method,arg){void 0===arg&&(arg=null);var callMethod="call"+toTitleCase$1(method),middlewareValue=middleware.reduce(middlewareIterator(callMethod),arg),terminated=middlewareValue===TERMINATOR,returnValue=terminated?null:tech[method](middlewareValue);return function(mws,method,value,terminated){for(var i=mws.length-1;i>=0;i--){var mw=mws[i];mw[method]&&mw[method](terminated,value)}}(middleware,method,returnValue,terminated),returnValue}var allowedGetters={buffered:1,currentTime:1,duration:1,muted:1,played:1,paused:1,seekable:1,volume:1,ended:1},allowedSetters={setCurrentTime:1,setMuted:1,setVolume:1},allowedMediators={play:1,pause:1};function middlewareIterator(method){return function(value,mw){return value===TERMINATOR?TERMINATOR:mw[method]?mw[method](value):value}}function setSourceHelper(src,middleware,next,player,acc,lastRun){void 0===src&&(src={}),void 0===middleware&&(middleware=[]),void 0===acc&&(acc=[]),void 0===lastRun&&(lastRun=!1);var _middleware=middleware,mwFactory=_middleware[0],mwrest=_middleware.slice(1);if("string"==typeof mwFactory)setSourceHelper(src,middlewares[mwFactory],next,player,acc,lastRun);else if(mwFactory){var mw=function(player,mwFactory){var mws=middlewareInstances[player.id()],mw=null;if(null==mws)return mw=mwFactory(player),middlewareInstances[player.id()]=[[mwFactory,mw]],mw;for(var i=0;i<mws.length;i++){var _mws$i=mws[i],mwf=_mws$i[0],mwi=_mws$i[1];mwf===mwFactory&&(mw=mwi)}return null===mw&&(mw=mwFactory(player),mws.push([mwFactory,mw])),mw}(player,mwFactory);if(!mw.setSource)return acc.push(mw),setSourceHelper(src,mwrest,next,player,acc,lastRun);mw.setSource(assign({},src),(function(err,_src){if(err)return setSourceHelper(src,mwrest,next,player,acc,lastRun);acc.push(mw),setSourceHelper(_src,src.type===_src.type?mwrest:middlewares[_src.type],next,player,acc,lastRun)}))}else mwrest.length?setSourceHelper(src,mwrest,next,player,acc,lastRun):lastRun?next(src,acc):setSourceHelper(src,middlewares["*"],next,player,acc,!0)}var MimetypesKind={opus:"video/ogg",ogv:"video/ogg",mp4:"video/mp4",mov:"video/mp4",m4v:"video/mp4",mkv:"video/x-matroska",m4a:"audio/mp4",mp3:"audio/mpeg",aac:"audio/aac",caf:"audio/x-caf",flac:"audio/flac",oga:"audio/ogg",wav:"audio/wav",m3u8:"application/x-mpegURL",jpg:"image/jpeg",jpeg:"image/jpeg",gif:"image/gif",png:"image/png",svg:"image/svg+xml",webp:"image/webp"},getMimetype=function(src){void 0===src&&(src="");var ext=getFileExtension(src);return MimetypesKind[ext.toLowerCase()]||""},filterSource=function filterSource(src){if(Array.isArray(src)){var newsrc=[];src.forEach((function(srcobj){srcobj=filterSource(srcobj),Array.isArray(srcobj)?newsrc=newsrc.concat(srcobj):isObject$1(srcobj)&&newsrc.push(srcobj)})),src=newsrc}else src="string"==typeof src&&src.trim()?[fixSource({src:src})]:isObject$1(src)&&"string"==typeof src.src&&src.src&&src.src.trim()?[fixSource(src)]:[];return src};function fixSource(src){if(!src.type){var mimetype=getMimetype(src.src);mimetype&&(src.type=mimetype)}return src}var MediaLoader=function(_Component){function MediaLoader(player,options,ready){var _this,options_=mergeOptions$3({createEl:!1},options);if(_this=_Component.call(this,player,options_,ready)||this,options.playerOptions.sources&&0!==options.playerOptions.sources.length)player.src(options.playerOptions.sources);else for(var i=0,j=options.playerOptions.techOrder;i<j.length;i++){var techName=toTitleCase$1(j[i]),tech=Tech.getTech(techName);if(techName||(tech=Component$1.getComponent(techName)),tech&&tech.isSupported()){player.loadTech_(techName);break}}return _this}return inheritsLoose(MediaLoader,_Component),MediaLoader}(Component$1);Component$1.registerComponent("MediaLoader",MediaLoader);var ClickableComponent=function(_Component){function ClickableComponent(player,options){var _this;return(_this=_Component.call(this,player,options)||this).handleMouseOver_=function(e){return _this.handleMouseOver(e)},_this.handleMouseOut_=function(e){return _this.handleMouseOut(e)},_this.handleClick_=function(e){return _this.handleClick(e)},_this.handleKeyDown_=function(e){return _this.handleKeyDown(e)},_this.emitTapEvents(),_this.enable(),_this}inheritsLoose(ClickableComponent,_Component);var _proto=ClickableComponent.prototype;return _proto.createEl=function(tag,props,attributes){void 0===tag&&(tag="div"),void 0===props&&(props={}),void 0===attributes&&(attributes={}),props=assign({className:this.buildCSSClass(),tabIndex:0},props),"button"===tag&&log$1.error("Creating a ClickableComponent with an HTML element of "+tag+" is not supported; use a Button instead."),attributes=assign({role:"button"},attributes),this.tabIndex_=props.tabIndex;var el=createEl(tag,props,attributes);return el.appendChild(createEl("span",{className:"vjs-icon-placeholder"},{"aria-hidden":!0})),this.createControlTextEl(el),el},_proto.dispose=function(){this.controlTextEl_=null,_Component.prototype.dispose.call(this)},_proto.createControlTextEl=function(el){return this.controlTextEl_=createEl("span",{className:"vjs-control-text"},{"aria-live":"polite"}),el&&el.appendChild(this.controlTextEl_),this.controlText(this.controlText_,el),this.controlTextEl_},_proto.controlText=function(text,el){if(void 0===el&&(el=this.el()),void 0===text)return this.controlText_||"Need Text";var localizedText=this.localize(text);this.controlText_=text,textContent(this.controlTextEl_,localizedText),this.nonIconControl||this.player_.options_.noUITitleAttributes||el.setAttribute("title",localizedText)},_proto.buildCSSClass=function(){return"vjs-control vjs-button "+_Component.prototype.buildCSSClass.call(this)},_proto.enable=function(){this.enabled_||(this.enabled_=!0,this.removeClass("vjs-disabled"),this.el_.setAttribute("aria-disabled","false"),void 0!==this.tabIndex_&&this.el_.setAttribute("tabIndex",this.tabIndex_),this.on(["tap","click"],this.handleClick_),this.on("keydown",this.handleKeyDown_))},_proto.disable=function(){this.enabled_=!1,this.addClass("vjs-disabled"),this.el_.setAttribute("aria-disabled","true"),void 0!==this.tabIndex_&&this.el_.removeAttribute("tabIndex"),this.off("mouseover",this.handleMouseOver_),this.off("mouseout",this.handleMouseOut_),this.off(["tap","click"],this.handleClick_),this.off("keydown",this.handleKeyDown_)},_proto.handleLanguagechange=function(){this.controlText(this.controlText_)},_proto.handleClick=function(event){this.options_.clickHandler&&this.options_.clickHandler.call(this,arguments)},_proto.handleKeyDown=function(event){keycode.isEventKey(event,"Space")||keycode.isEventKey(event,"Enter")?(event.preventDefault(),event.stopPropagation(),this.trigger("click")):_Component.prototype.handleKeyDown.call(this,event)},ClickableComponent}(Component$1);Component$1.registerComponent("ClickableComponent",ClickableComponent);var PosterImage=function(_ClickableComponent){function PosterImage(player,options){var _this;return(_this=_ClickableComponent.call(this,player,options)||this).update(),_this.update_=function(e){return _this.update(e)},player.on("posterchange",_this.update_),_this}inheritsLoose(PosterImage,_ClickableComponent);var _proto=PosterImage.prototype;return _proto.dispose=function(){this.player().off("posterchange",this.update_),_ClickableComponent.prototype.dispose.call(this)},_proto.createEl=function(){return createEl("div",{className:"vjs-poster",tabIndex:-1})},_proto.update=function(event){var url=this.player().poster();this.setSrc(url),url?this.show():this.hide()},_proto.setSrc=function(url){var backgroundImage="";url&&(backgroundImage='url("'+url+'")'),this.el_.style.backgroundImage=backgroundImage},_proto.handleClick=function(event){if(this.player_.controls()){var sourceIsEncrypted=this.player_.usingPlugin("eme")&&this.player_.eme.sessions&&this.player_.eme.sessions.length>0;!this.player_.tech(!0)||(IE_VERSION||IS_EDGE)&&sourceIsEncrypted||this.player_.tech(!0).focus(),this.player_.paused()?silencePromise(this.player_.play()):this.player_.pause()}},PosterImage}(ClickableComponent);Component$1.registerComponent("PosterImage",PosterImage);var fontMap={monospace:"monospace",sansSerif:"sans-serif",serif:"serif",monospaceSansSerif:'"Andale Mono", "Lucida Console", monospace',monospaceSerif:'"Courier New", monospace',proportionalSansSerif:"sans-serif",proportionalSerif:"serif",casual:'"Comic Sans MS", Impact, fantasy',script:'"Monotype Corsiva", cursive',smallcaps:'"Andale Mono", "Lucida Console", monospace, sans-serif'};function constructColor(color,opacity){var hex;if(4===color.length)hex=color[1]+color[1]+color[2]+color[2]+color[3]+color[3];else{if(7!==color.length)throw new Error("Invalid color code provided, "+color+"; must be formatted as e.g. #f0e or #f604e2.");hex=color.slice(1)}return"rgba("+parseInt(hex.slice(0,2),16)+","+parseInt(hex.slice(2,4),16)+","+parseInt(hex.slice(4,6),16)+","+opacity+")"}function tryUpdateStyle(el,style,rule){try{el.style[style]=rule}catch(e){return}}var TextTrackDisplay=function(_Component){function TextTrackDisplay(player,options,ready){var _this;_this=_Component.call(this,player,options,ready)||this;var updateDisplayHandler=function(e){return _this.updateDisplay(e)};return player.on("loadstart",(function(e){return _this.toggleDisplay(e)})),player.on("texttrackchange",updateDisplayHandler),player.on("loadedmetadata",(function(e){return _this.preselectTrack(e)})),player.ready(bind(assertThisInitialized(_this),(function(){if(player.tech_&&player.tech_.featuresNativeTextTracks)this.hide();else{player.on("fullscreenchange",updateDisplayHandler),player.on("playerresize",updateDisplayHandler),window.addEventListener("orientationchange",updateDisplayHandler),player.on("dispose",(function(){return window.removeEventListener("orientationchange",updateDisplayHandler)}));for(var tracks=this.options_.playerOptions.tracks||[],i=0;i<tracks.length;i++)this.player_.addRemoteTextTrack(tracks[i],!0);this.preselectTrack()}}))),_this}inheritsLoose(TextTrackDisplay,_Component);var _proto=TextTrackDisplay.prototype;return _proto.preselectTrack=function(){for(var firstDesc,firstCaptions,preferredTrack,modes={captions:1,subtitles:1},trackList=this.player_.textTracks(),userPref=this.player_.cache_.selectedLanguage,i=0;i<trackList.length;i++){var track=trackList[i];userPref&&userPref.enabled&&userPref.language&&userPref.language===track.language&&track.kind in modes?track.kind===userPref.kind?preferredTrack=track:preferredTrack||(preferredTrack=track):userPref&&!userPref.enabled?(preferredTrack=null,firstDesc=null,firstCaptions=null):track.default&&("descriptions"!==track.kind||firstDesc?track.kind in modes&&!firstCaptions&&(firstCaptions=track):firstDesc=track)}preferredTrack?preferredTrack.mode="showing":firstCaptions?firstCaptions.mode="showing":firstDesc&&(firstDesc.mode="showing")},_proto.toggleDisplay=function(){this.player_.tech_&&this.player_.tech_.featuresNativeTextTracks?this.hide():this.show()},_proto.createEl=function(){return _Component.prototype.createEl.call(this,"div",{className:"vjs-text-track-display"},{translate:"yes","aria-live":"off","aria-atomic":"true"})},_proto.clearDisplay=function(){"function"==typeof window.WebVTT&&window.WebVTT.processCues(window,[],this.el_)},_proto.updateDisplay=function(){var tracks=this.player_.textTracks(),allowMultipleShowingTracks=this.options_.allowMultipleShowingTracks;if(this.clearDisplay(),allowMultipleShowingTracks){for(var showingTracks=[],_i=0;_i<tracks.length;++_i){var track=tracks[_i];"showing"===track.mode&&showingTracks.push(track)}this.updateForTrack(showingTracks)}else{for(var descriptionsTrack=null,captionsSubtitlesTrack=null,i=tracks.length;i--;){var _track=tracks[i];"showing"===_track.mode&&("descriptions"===_track.kind?descriptionsTrack=_track:captionsSubtitlesTrack=_track)}captionsSubtitlesTrack?("off"!==this.getAttribute("aria-live")&&this.setAttribute("aria-live","off"),this.updateForTrack(captionsSubtitlesTrack)):descriptionsTrack&&("assertive"!==this.getAttribute("aria-live")&&this.setAttribute("aria-live","assertive"),this.updateForTrack(descriptionsTrack))}},_proto.updateDisplayState=function(track){for(var overrides=this.player_.textTrackSettings.getValues(),cues=track.activeCues,i=cues.length;i--;){var cue=cues[i];if(cue){var cueDiv=cue.displayState;if(overrides.color&&(cueDiv.firstChild.style.color=overrides.color),overrides.textOpacity&&tryUpdateStyle(cueDiv.firstChild,"color",constructColor(overrides.color||"#fff",overrides.textOpacity)),overrides.backgroundColor&&(cueDiv.firstChild.style.backgroundColor=overrides.backgroundColor),overrides.backgroundOpacity&&tryUpdateStyle(cueDiv.firstChild,"backgroundColor",constructColor(overrides.backgroundColor||"#000",overrides.backgroundOpacity)),overrides.windowColor&&(overrides.windowOpacity?tryUpdateStyle(cueDiv,"backgroundColor",constructColor(overrides.windowColor,overrides.windowOpacity)):cueDiv.style.backgroundColor=overrides.windowColor),overrides.edgeStyle&&("dropshadow"===overrides.edgeStyle?cueDiv.firstChild.style.textShadow="2px 2px 3px #222, 2px 2px 4px #222, 2px 2px 5px #222":"raised"===overrides.edgeStyle?cueDiv.firstChild.style.textShadow="1px 1px #222, 2px 2px #222, 3px 3px #222":"depressed"===overrides.edgeStyle?cueDiv.firstChild.style.textShadow="1px 1px #ccc, 0 1px #ccc, -1px -1px #222, 0 -1px #222":"uniform"===overrides.edgeStyle&&(cueDiv.firstChild.style.textShadow="0 0 4px #222, 0 0 4px #222, 0 0 4px #222, 0 0 4px #222")),overrides.fontPercent&&1!==overrides.fontPercent){var fontSize=window.parseFloat(cueDiv.style.fontSize);cueDiv.style.fontSize=fontSize*overrides.fontPercent+"px",cueDiv.style.height="auto",cueDiv.style.top="auto"}overrides.fontFamily&&"default"!==overrides.fontFamily&&("small-caps"===overrides.fontFamily?cueDiv.firstChild.style.fontVariant="small-caps":cueDiv.firstChild.style.fontFamily=fontMap[overrides.fontFamily])}}},_proto.updateForTrack=function(tracks){if(Array.isArray(tracks)||(tracks=[tracks]),"function"==typeof window.WebVTT&&!tracks.every((function(track){return!track.activeCues}))){for(var cues=[],i=0;i<tracks.length;++i)for(var track=tracks[i],j=0;j<track.activeCues.length;++j)cues.push(track.activeCues[j]);window.WebVTT.processCues(window,cues,this.el_);for(var _i2=0;_i2<tracks.length;++_i2){for(var _track2=tracks[_i2],_j=0;_j<_track2.activeCues.length;++_j){var cueEl=_track2.activeCues[_j].displayState;addClass(cueEl,"vjs-text-track-cue"),addClass(cueEl,"vjs-text-track-cue-"+(_track2.language?_track2.language:_i2)),_track2.language&&setAttribute(cueEl,"lang",_track2.language)}this.player_.textTrackSettings&&this.updateDisplayState(_track2)}}},TextTrackDisplay}(Component$1);Component$1.registerComponent("TextTrackDisplay",TextTrackDisplay);var LoadingSpinner=function(_Component){function LoadingSpinner(){return _Component.apply(this,arguments)||this}return inheritsLoose(LoadingSpinner,_Component),LoadingSpinner.prototype.createEl=function(){var isAudio=this.player_.isAudio(),playerType=this.localize(isAudio?"Audio Player":"Video Player"),controlText=createEl("span",{className:"vjs-control-text",textContent:this.localize("{1} is loading.",[playerType])}),el=_Component.prototype.createEl.call(this,"div",{className:"vjs-loading-spinner",dir:"ltr"});return el.appendChild(controlText),el},LoadingSpinner}(Component$1);Component$1.registerComponent("LoadingSpinner",LoadingSpinner);var Button=function(_ClickableComponent){function Button(){return _ClickableComponent.apply(this,arguments)||this}inheritsLoose(Button,_ClickableComponent);var _proto=Button.prototype;return _proto.createEl=function(tag,props,attributes){void 0===props&&(props={}),void 0===attributes&&(attributes={});var el=createEl("button",props=assign({className:this.buildCSSClass()},props),attributes=assign({type:"button"},attributes));return el.appendChild(createEl("span",{className:"vjs-icon-placeholder"},{"aria-hidden":!0})),this.createControlTextEl(el),el},_proto.addChild=function(child,options){void 0===options&&(options={});var className=this.constructor.name;return log$1.warn("Adding an actionable (user controllable) child to a Button ("+className+") is not supported; use a ClickableComponent instead."),Component$1.prototype.addChild.call(this,child,options)},_proto.enable=function(){_ClickableComponent.prototype.enable.call(this),this.el_.removeAttribute("disabled")},_proto.disable=function(){_ClickableComponent.prototype.disable.call(this),this.el_.setAttribute("disabled","disabled")},_proto.handleKeyDown=function(event){keycode.isEventKey(event,"Space")||keycode.isEventKey(event,"Enter")?event.stopPropagation():_ClickableComponent.prototype.handleKeyDown.call(this,event)},Button}(ClickableComponent);Component$1.registerComponent("Button",Button);var BigPlayButton=function(_Button){function BigPlayButton(player,options){var _this;return(_this=_Button.call(this,player,options)||this).mouseused_=!1,_this.on("mousedown",(function(e){return _this.handleMouseDown(e)})),_this}inheritsLoose(BigPlayButton,_Button);var _proto=BigPlayButton.prototype;return _proto.buildCSSClass=function(){return"vjs-big-play-button"},_proto.handleClick=function(event){var playPromise=this.player_.play();if(this.mouseused_&&event.clientX&&event.clientY){var sourceIsEncrypted=this.player_.usingPlugin("eme")&&this.player_.eme.sessions&&this.player_.eme.sessions.length>0;return silencePromise(playPromise),void(!this.player_.tech(!0)||(IE_VERSION||IS_EDGE)&&sourceIsEncrypted||this.player_.tech(!0).focus())}var cb=this.player_.getChild("controlBar"),playToggle=cb&&cb.getChild("playToggle");if(playToggle){var playFocus=function(){return playToggle.focus()};isPromise(playPromise)?playPromise.then(playFocus,(function(){})):this.setTimeout(playFocus,1)}else this.player_.tech(!0).focus()},_proto.handleKeyDown=function(event){this.mouseused_=!1,_Button.prototype.handleKeyDown.call(this,event)},_proto.handleMouseDown=function(event){this.mouseused_=!0},BigPlayButton}(Button);BigPlayButton.prototype.controlText_="Play Video",Component$1.registerComponent("BigPlayButton",BigPlayButton);var CloseButton=function(_Button){function CloseButton(player,options){var _this;return(_this=_Button.call(this,player,options)||this).controlText(options&&options.controlText||_this.localize("Close")),_this}inheritsLoose(CloseButton,_Button);var _proto=CloseButton.prototype;return _proto.buildCSSClass=function(){return"vjs-close-button "+_Button.prototype.buildCSSClass.call(this)},_proto.handleClick=function(event){this.trigger({type:"close",bubbles:!1})},_proto.handleKeyDown=function(event){keycode.isEventKey(event,"Esc")?(event.preventDefault(),event.stopPropagation(),this.trigger("click")):_Button.prototype.handleKeyDown.call(this,event)},CloseButton}(Button);Component$1.registerComponent("CloseButton",CloseButton);var PlayToggle=function(_Button){function PlayToggle(player,options){var _this;return void 0===options&&(options={}),_this=_Button.call(this,player,options)||this,options.replay=void 0===options.replay||options.replay,_this.on(player,"play",(function(e){return _this.handlePlay(e)})),_this.on(player,"pause",(function(e){return _this.handlePause(e)})),options.replay&&_this.on(player,"ended",(function(e){return _this.handleEnded(e)})),_this}inheritsLoose(PlayToggle,_Button);var _proto=PlayToggle.prototype;return _proto.buildCSSClass=function(){return"vjs-play-control "+_Button.prototype.buildCSSClass.call(this)},_proto.handleClick=function(event){this.player_.paused()?silencePromise(this.player_.play()):this.player_.pause()},_proto.handleSeeked=function(event){this.removeClass("vjs-ended"),this.player_.paused()?this.handlePause(event):this.handlePlay(event)},_proto.handlePlay=function(event){this.removeClass("vjs-ended"),this.removeClass("vjs-paused"),this.addClass("vjs-playing"),this.controlText("Pause")},_proto.handlePause=function(event){this.removeClass("vjs-playing"),this.addClass("vjs-paused"),this.controlText("Play")},_proto.handleEnded=function(event){var _this2=this;this.removeClass("vjs-playing"),this.addClass("vjs-ended"),this.controlText("Replay"),this.one(this.player_,"seeked",(function(e){return _this2.handleSeeked(e)}))},PlayToggle}(Button);PlayToggle.prototype.controlText_="Play",Component$1.registerComponent("PlayToggle",PlayToggle);var defaultImplementation=function(seconds,guide){seconds=seconds<0?0:seconds;var s=Math.floor(seconds%60),m=Math.floor(seconds/60%60),h=Math.floor(seconds/3600),gm=Math.floor(guide/60%60),gh=Math.floor(guide/3600);return(isNaN(seconds)||seconds===1/0)&&(h=m=s="-"),(h=h>0||gh>0?h+":":"")+(m=((h||gm>=10)&&m<10?"0"+m:m)+":")+(s=s<10?"0"+s:s)},implementation=defaultImplementation;function formatTime(seconds,guide){return void 0===guide&&(guide=seconds),implementation(seconds,guide)}var TimeDisplay=function(_Component){function TimeDisplay(player,options){var _this;return(_this=_Component.call(this,player,options)||this).on(player,["timeupdate","ended"],(function(e){return _this.updateContent(e)})),_this.updateTextNode_(),_this}inheritsLoose(TimeDisplay,_Component);var _proto=TimeDisplay.prototype;return _proto.createEl=function(){var className=this.buildCSSClass(),el=_Component.prototype.createEl.call(this,"div",{className:className+" vjs-time-control vjs-control"}),span=createEl("span",{className:"vjs-control-text",textContent:this.localize(this.labelText_)+" "},{role:"presentation"});return el.appendChild(span),this.contentEl_=createEl("span",{className:className+"-display"},{"aria-live":"off",role:"presentation"}),el.appendChild(this.contentEl_),el},_proto.dispose=function(){this.contentEl_=null,this.textNode_=null,_Component.prototype.dispose.call(this)},_proto.updateTextNode_=function(time){var _this2=this;void 0===time&&(time=0),time=formatTime(time),this.formattedTime_!==time&&(this.formattedTime_=time,this.requestNamedAnimationFrame("TimeDisplay#updateTextNode_",(function(){if(_this2.contentEl_){var oldNode=_this2.textNode_;oldNode&&_this2.contentEl_.firstChild!==oldNode&&(oldNode=null,log$1.warn("TimeDisplay#updateTextnode_: Prevented replacement of text node element since it was no longer a child of this node. Appending a new node instead.")),_this2.textNode_=document.createTextNode(_this2.formattedTime_),_this2.textNode_&&(oldNode?_this2.contentEl_.replaceChild(_this2.textNode_,oldNode):_this2.contentEl_.appendChild(_this2.textNode_))}})))},_proto.updateContent=function(event){},TimeDisplay}(Component$1);TimeDisplay.prototype.labelText_="Time",TimeDisplay.prototype.controlText_="Time",Component$1.registerComponent("TimeDisplay",TimeDisplay);var CurrentTimeDisplay=function(_TimeDisplay){function CurrentTimeDisplay(){return _TimeDisplay.apply(this,arguments)||this}inheritsLoose(CurrentTimeDisplay,_TimeDisplay);var _proto=CurrentTimeDisplay.prototype;return _proto.buildCSSClass=function(){return"vjs-current-time"},_proto.updateContent=function(event){var time;time=this.player_.ended()?this.player_.duration():this.player_.scrubbing()?this.player_.getCache().currentTime:this.player_.currentTime(),this.updateTextNode_(time)},CurrentTimeDisplay}(TimeDisplay);CurrentTimeDisplay.prototype.labelText_="Current Time",CurrentTimeDisplay.prototype.controlText_="Current Time",Component$1.registerComponent("CurrentTimeDisplay",CurrentTimeDisplay);var DurationDisplay=function(_TimeDisplay){function DurationDisplay(player,options){var _this,updateContent=function(e){return _this.updateContent(e)};return(_this=_TimeDisplay.call(this,player,options)||this).on(player,"durationchange",updateContent),_this.on(player,"loadstart",updateContent),_this.on(player,"loadedmetadata",updateContent),_this}inheritsLoose(DurationDisplay,_TimeDisplay);var _proto=DurationDisplay.prototype;return _proto.buildCSSClass=function(){return"vjs-duration"},_proto.updateContent=function(event){var duration=this.player_.duration();this.updateTextNode_(duration)},DurationDisplay}(TimeDisplay);DurationDisplay.prototype.labelText_="Duration",DurationDisplay.prototype.controlText_="Duration",Component$1.registerComponent("DurationDisplay",DurationDisplay);var TimeDivider=function(_Component){function TimeDivider(){return _Component.apply(this,arguments)||this}return inheritsLoose(TimeDivider,_Component),TimeDivider.prototype.createEl=function(){var el=_Component.prototype.createEl.call(this,"div",{className:"vjs-time-control vjs-time-divider"},{"aria-hidden":!0}),div=_Component.prototype.createEl.call(this,"div"),span=_Component.prototype.createEl.call(this,"span",{textContent:"/"});return div.appendChild(span),el.appendChild(div),el},TimeDivider}(Component$1);Component$1.registerComponent("TimeDivider",TimeDivider);var RemainingTimeDisplay=function(_TimeDisplay){function RemainingTimeDisplay(player,options){var _this;return(_this=_TimeDisplay.call(this,player,options)||this).on(player,"durationchange",(function(e){return _this.updateContent(e)})),_this}inheritsLoose(RemainingTimeDisplay,_TimeDisplay);var _proto=RemainingTimeDisplay.prototype;return _proto.buildCSSClass=function(){return"vjs-remaining-time"},_proto.createEl=function(){var el=_TimeDisplay.prototype.createEl.call(this);return el.insertBefore(createEl("span",{},{"aria-hidden":!0},"-"),this.contentEl_),el},_proto.updateContent=function(event){var time;"number"==typeof this.player_.duration()&&(time=this.player_.ended()?0:this.player_.remainingTimeDisplay?this.player_.remainingTimeDisplay():this.player_.remainingTime(),this.updateTextNode_(time))},RemainingTimeDisplay}(TimeDisplay);RemainingTimeDisplay.prototype.labelText_="Remaining Time",RemainingTimeDisplay.prototype.controlText_="Remaining Time",Component$1.registerComponent("RemainingTimeDisplay",RemainingTimeDisplay);var LiveDisplay=function(_Component){function LiveDisplay(player,options){var _this;return(_this=_Component.call(this,player,options)||this).updateShowing(),_this.on(_this.player(),"durationchange",(function(e){return _this.updateShowing(e)})),_this}inheritsLoose(LiveDisplay,_Component);var _proto=LiveDisplay.prototype;return _proto.createEl=function(){var el=_Component.prototype.createEl.call(this,"div",{className:"vjs-live-control vjs-control"});return this.contentEl_=createEl("div",{className:"vjs-live-display"},{"aria-live":"off"}),this.contentEl_.appendChild(createEl("span",{className:"vjs-control-text",textContent:this.localize("Stream Type")+" "})),this.contentEl_.appendChild(document.createTextNode(this.localize("LIVE"))),el.appendChild(this.contentEl_),el},_proto.dispose=function(){this.contentEl_=null,_Component.prototype.dispose.call(this)},_proto.updateShowing=function(event){this.player().duration()===1/0?this.show():this.hide()},LiveDisplay}(Component$1);Component$1.registerComponent("LiveDisplay",LiveDisplay);var SeekToLive=function(_Button){function SeekToLive(player,options){var _this;return(_this=_Button.call(this,player,options)||this).updateLiveEdgeStatus(),_this.player_.liveTracker&&(_this.updateLiveEdgeStatusHandler_=function(e){return _this.updateLiveEdgeStatus(e)},_this.on(_this.player_.liveTracker,"liveedgechange",_this.updateLiveEdgeStatusHandler_)),_this}inheritsLoose(SeekToLive,_Button);var _proto=SeekToLive.prototype;return _proto.createEl=function(){var el=_Button.prototype.createEl.call(this,"button",{className:"vjs-seek-to-live-control vjs-control"});return this.textEl_=createEl("span",{className:"vjs-seek-to-live-text",textContent:this.localize("LIVE")},{"aria-hidden":"true"}),el.appendChild(this.textEl_),el},_proto.updateLiveEdgeStatus=function(){!this.player_.liveTracker||this.player_.liveTracker.atLiveEdge()?(this.setAttribute("aria-disabled",!0),this.addClass("vjs-at-live-edge"),this.controlText("Seek to live, currently playing live")):(this.setAttribute("aria-disabled",!1),this.removeClass("vjs-at-live-edge"),this.controlText("Seek to live, currently behind live"))},_proto.handleClick=function(){this.player_.liveTracker.seekToLiveEdge()},_proto.dispose=function(){this.player_.liveTracker&&this.off(this.player_.liveTracker,"liveedgechange",this.updateLiveEdgeStatusHandler_),this.textEl_=null,_Button.prototype.dispose.call(this)},SeekToLive}(Button);SeekToLive.prototype.controlText_="Seek to live, currently playing live",Component$1.registerComponent("SeekToLive",SeekToLive);var clamp=function(number,min,max){return number=Number(number),Math.min(max,Math.max(min,isNaN(number)?min:number))},Slider=function(_Component){function Slider(player,options){var _this;return(_this=_Component.call(this,player,options)||this).handleMouseDown_=function(e){return _this.handleMouseDown(e)},_this.handleMouseUp_=function(e){return _this.handleMouseUp(e)},_this.handleKeyDown_=function(e){return _this.handleKeyDown(e)},_this.handleClick_=function(e){return _this.handleClick(e)},_this.handleMouseMove_=function(e){return _this.handleMouseMove(e)},_this.update_=function(e){return _this.update(e)},_this.bar=_this.getChild(_this.options_.barName),_this.vertical(!!_this.options_.vertical),_this.enable(),_this}inheritsLoose(Slider,_Component);var _proto=Slider.prototype;return _proto.enabled=function(){return this.enabled_},_proto.enable=function(){this.enabled()||(this.on("mousedown",this.handleMouseDown_),this.on("touchstart",this.handleMouseDown_),this.on("keydown",this.handleKeyDown_),this.on("click",this.handleClick_),this.on(this.player_,"controlsvisible",this.update),this.playerEvent&&this.on(this.player_,this.playerEvent,this.update),this.removeClass("disabled"),this.setAttribute("tabindex",0),this.enabled_=!0)},_proto.disable=function(){if(this.enabled()){var doc=this.bar.el_.ownerDocument;this.off("mousedown",this.handleMouseDown_),this.off("touchstart",this.handleMouseDown_),this.off("keydown",this.handleKeyDown_),this.off("click",this.handleClick_),this.off(this.player_,"controlsvisible",this.update_),this.off(doc,"mousemove",this.handleMouseMove_),this.off(doc,"mouseup",this.handleMouseUp_),this.off(doc,"touchmove",this.handleMouseMove_),this.off(doc,"touchend",this.handleMouseUp_),this.removeAttribute("tabindex"),this.addClass("disabled"),this.playerEvent&&this.off(this.player_,this.playerEvent,this.update),this.enabled_=!1}},_proto.createEl=function(type,props,attributes){return void 0===props&&(props={}),void 0===attributes&&(attributes={}),props.className=props.className+" vjs-slider",props=assign({tabIndex:0},props),attributes=assign({role:"slider","aria-valuenow":0,"aria-valuemin":0,"aria-valuemax":100,tabIndex:0},attributes),_Component.prototype.createEl.call(this,type,props,attributes)},_proto.handleMouseDown=function(event){var doc=this.bar.el_.ownerDocument;"mousedown"===event.type&&event.preventDefault(),"touchstart"!==event.type||IS_CHROME||event.preventDefault(),blockTextSelection(),this.addClass("vjs-sliding"),this.trigger("slideractive"),this.on(doc,"mousemove",this.handleMouseMove_),this.on(doc,"mouseup",this.handleMouseUp_),this.on(doc,"touchmove",this.handleMouseMove_),this.on(doc,"touchend",this.handleMouseUp_),this.handleMouseMove(event)},_proto.handleMouseMove=function(event){},_proto.handleMouseUp=function(){var doc=this.bar.el_.ownerDocument;unblockTextSelection(),this.removeClass("vjs-sliding"),this.trigger("sliderinactive"),this.off(doc,"mousemove",this.handleMouseMove_),this.off(doc,"mouseup",this.handleMouseUp_),this.off(doc,"touchmove",this.handleMouseMove_),this.off(doc,"touchend",this.handleMouseUp_),this.update()},_proto.update=function(){var _this2=this;if(this.el_&&this.bar){var progress=this.getProgress();return progress===this.progress_||(this.progress_=progress,this.requestNamedAnimationFrame("Slider#update",(function(){var sizeKey=_this2.vertical()?"height":"width";_this2.bar.el().style[sizeKey]=(100*progress).toFixed(2)+"%"}))),progress}},_proto.getProgress=function(){return Number(clamp(this.getPercent(),0,1).toFixed(4))},_proto.calculateDistance=function(event){var position=getPointerPosition(this.el_,event);return this.vertical()?position.y:position.x},_proto.handleKeyDown=function(event){keycode.isEventKey(event,"Left")||keycode.isEventKey(event,"Down")?(event.preventDefault(),event.stopPropagation(),this.stepBack()):keycode.isEventKey(event,"Right")||keycode.isEventKey(event,"Up")?(event.preventDefault(),event.stopPropagation(),this.stepForward()):_Component.prototype.handleKeyDown.call(this,event)},_proto.handleClick=function(event){event.stopPropagation(),event.preventDefault()},_proto.vertical=function(bool){if(void 0===bool)return this.vertical_||!1;this.vertical_=!!bool,this.vertical_?this.addClass("vjs-slider-vertical"):this.addClass("vjs-slider-horizontal")},Slider}(Component$1);Component$1.registerComponent("Slider",Slider);var percentify=function(time,end){return clamp(time/end*100,0,100).toFixed(2)+"%"},LoadProgressBar=function(_Component){function LoadProgressBar(player,options){var _this;return(_this=_Component.call(this,player,options)||this).partEls_=[],_this.on(player,"progress",(function(e){return _this.update(e)})),_this}inheritsLoose(LoadProgressBar,_Component);var _proto=LoadProgressBar.prototype;return _proto.createEl=function(){var el=_Component.prototype.createEl.call(this,"div",{className:"vjs-load-progress"}),wrapper=createEl("span",{className:"vjs-control-text"}),loadedText=createEl("span",{textContent:this.localize("Loaded")}),separator=document.createTextNode(": ");return this.percentageEl_=createEl("span",{className:"vjs-control-text-loaded-percentage",textContent:"0%"}),el.appendChild(wrapper),wrapper.appendChild(loadedText),wrapper.appendChild(separator),wrapper.appendChild(this.percentageEl_),el},_proto.dispose=function(){this.partEls_=null,this.percentageEl_=null,_Component.prototype.dispose.call(this)},_proto.update=function(event){var _this2=this;this.requestNamedAnimationFrame("LoadProgressBar#update",(function(){var liveTracker=_this2.player_.liveTracker,buffered=_this2.player_.buffered(),duration=liveTracker&&liveTracker.isLive()?liveTracker.seekableEnd():_this2.player_.duration(),bufferedEnd=_this2.player_.bufferedEnd(),children=_this2.partEls_,percent=percentify(bufferedEnd,duration);_this2.percent_!==percent&&(_this2.el_.style.width=percent,textContent(_this2.percentageEl_,percent),_this2.percent_=percent);for(var i=0;i<buffered.length;i++){var start=buffered.start(i),end=buffered.end(i),part=children[i];part||(part=_this2.el_.appendChild(createEl()),children[i]=part),part.dataset.start===start&&part.dataset.end===end||(part.dataset.start=start,part.dataset.end=end,part.style.left=percentify(start,bufferedEnd),part.style.width=percentify(end-start,bufferedEnd))}for(var _i=children.length;_i>buffered.length;_i--)_this2.el_.removeChild(children[_i-1]);children.length=buffered.length}))},LoadProgressBar}(Component$1);Component$1.registerComponent("LoadProgressBar",LoadProgressBar);var TimeTooltip=function(_Component){function TimeTooltip(player,options){var _this;return(_this=_Component.call(this,player,options)||this).update=throttle(bind(assertThisInitialized(_this),_this.update),30),_this}inheritsLoose(TimeTooltip,_Component);var _proto=TimeTooltip.prototype;return _proto.createEl=function(){return _Component.prototype.createEl.call(this,"div",{className:"vjs-time-tooltip"},{"aria-hidden":"true"})},_proto.update=function(seekBarRect,seekBarPoint,content){var tooltipRect=findPosition(this.el_),playerRect=getBoundingClientRect(this.player_.el()),seekBarPointPx=seekBarRect.width*seekBarPoint;if(playerRect&&tooltipRect){var spaceLeftOfPoint=seekBarRect.left-playerRect.left+seekBarPointPx,spaceRightOfPoint=seekBarRect.width-seekBarPointPx+(playerRect.right-seekBarRect.right),pullTooltipBy=tooltipRect.width/2;spaceLeftOfPoint<pullTooltipBy?pullTooltipBy+=pullTooltipBy-spaceLeftOfPoint:spaceRightOfPoint<pullTooltipBy&&(pullTooltipBy=spaceRightOfPoint),pullTooltipBy<0?pullTooltipBy=0:pullTooltipBy>tooltipRect.width&&(pullTooltipBy=tooltipRect.width),pullTooltipBy=Math.round(pullTooltipBy),this.el_.style.right="-"+pullTooltipBy+"px",this.write(content)}},_proto.write=function(content){textContent(this.el_,content)},_proto.updateTime=function(seekBarRect,seekBarPoint,time,cb){var _this2=this;this.requestNamedAnimationFrame("TimeTooltip#updateTime",(function(){var content,duration=_this2.player_.duration();if(_this2.player_.liveTracker&&_this2.player_.liveTracker.isLive()){var liveWindow=_this2.player_.liveTracker.liveWindow(),secondsBehind=liveWindow-seekBarPoint*liveWindow;content=(secondsBehind<1?"":"-")+formatTime(secondsBehind,liveWindow)}else content=formatTime(time,duration);_this2.update(seekBarRect,seekBarPoint,content),cb&&cb()}))},TimeTooltip}(Component$1);Component$1.registerComponent("TimeTooltip",TimeTooltip);var PlayProgressBar=function(_Component){function PlayProgressBar(player,options){var _this;return(_this=_Component.call(this,player,options)||this).update=throttle(bind(assertThisInitialized(_this),_this.update),30),_this}inheritsLoose(PlayProgressBar,_Component);var _proto=PlayProgressBar.prototype;return _proto.createEl=function(){return _Component.prototype.createEl.call(this,"div",{className:"vjs-play-progress vjs-slider-bar"},{"aria-hidden":"true"})},_proto.update=function(seekBarRect,seekBarPoint){var timeTooltip=this.getChild("timeTooltip");if(timeTooltip){var time=this.player_.scrubbing()?this.player_.getCache().currentTime:this.player_.currentTime();timeTooltip.updateTime(seekBarRect,seekBarPoint,time)}},PlayProgressBar}(Component$1);PlayProgressBar.prototype.options_={children:[]},IS_IOS||IS_ANDROID||PlayProgressBar.prototype.options_.children.push("timeTooltip"),Component$1.registerComponent("PlayProgressBar",PlayProgressBar);var MouseTimeDisplay=function(_Component){function MouseTimeDisplay(player,options){var _this;return(_this=_Component.call(this,player,options)||this).update=throttle(bind(assertThisInitialized(_this),_this.update),30),_this}inheritsLoose(MouseTimeDisplay,_Component);var _proto=MouseTimeDisplay.prototype;return _proto.createEl=function(){return _Component.prototype.createEl.call(this,"div",{className:"vjs-mouse-display"})},_proto.update=function(seekBarRect,seekBarPoint){var _this2=this,time=seekBarPoint*this.player_.duration();this.getChild("timeTooltip").updateTime(seekBarRect,seekBarPoint,time,(function(){_this2.el_.style.left=seekBarRect.width*seekBarPoint+"px"}))},MouseTimeDisplay}(Component$1);MouseTimeDisplay.prototype.options_={children:["timeTooltip"]},Component$1.registerComponent("MouseTimeDisplay",MouseTimeDisplay);var SeekBar=function(_Slider){function SeekBar(player,options){var _this;return(_this=_Slider.call(this,player,options)||this).setEventHandlers_(),_this}inheritsLoose(SeekBar,_Slider);var _proto=SeekBar.prototype;return _proto.setEventHandlers_=function(){var _this2=this;this.update_=bind(this,this.update),this.update=throttle(this.update_,30),this.on(this.player_,["ended","durationchange","timeupdate"],this.update),this.player_.liveTracker&&this.on(this.player_.liveTracker,"liveedgechange",this.update),this.updateInterval=null,this.enableIntervalHandler_=function(e){return _this2.enableInterval_(e)},this.disableIntervalHandler_=function(e){return _this2.disableInterval_(e)},this.on(this.player_,["playing"],this.enableIntervalHandler_),this.on(this.player_,["ended","pause","waiting"],this.disableIntervalHandler_),"hidden"in document&&"visibilityState"in document&&this.on(document,"visibilitychange",this.toggleVisibility_)},_proto.toggleVisibility_=function(e){"hidden"===document.visibilityState?(this.cancelNamedAnimationFrame("SeekBar#update"),this.cancelNamedAnimationFrame("Slider#update"),this.disableInterval_(e)):(this.player_.ended()||this.player_.paused()||this.enableInterval_(),this.update())},_proto.enableInterval_=function(){this.updateInterval||(this.updateInterval=this.setInterval(this.update,30))},_proto.disableInterval_=function(e){this.player_.liveTracker&&this.player_.liveTracker.isLive()&&e&&"ended"!==e.type||this.updateInterval&&(this.clearInterval(this.updateInterval),this.updateInterval=null)},_proto.createEl=function(){return _Slider.prototype.createEl.call(this,"div",{className:"vjs-progress-holder"},{"aria-label":this.localize("Progress Bar")})},_proto.update=function(event){var _this3=this;if("hidden"!==document.visibilityState){var percent=_Slider.prototype.update.call(this);return this.requestNamedAnimationFrame("SeekBar#update",(function(){var currentTime=_this3.player_.ended()?_this3.player_.duration():_this3.getCurrentTime_(),liveTracker=_this3.player_.liveTracker,duration=_this3.player_.duration();liveTracker&&liveTracker.isLive()&&(duration=_this3.player_.liveTracker.liveCurrentTime()),_this3.percent_!==percent&&(_this3.el_.setAttribute("aria-valuenow",(100*percent).toFixed(2)),_this3.percent_=percent),_this3.currentTime_===currentTime&&_this3.duration_===duration||(_this3.el_.setAttribute("aria-valuetext",_this3.localize("progress bar timing: currentTime={1} duration={2}",[formatTime(currentTime,duration),formatTime(duration,duration)],"{1} of {2}")),_this3.currentTime_=currentTime,_this3.duration_=duration),_this3.bar&&_this3.bar.update(getBoundingClientRect(_this3.el()),_this3.getProgress())})),percent}},_proto.userSeek_=function(ct){this.player_.liveTracker&&this.player_.liveTracker.isLive()&&this.player_.liveTracker.nextSeekedFromUser(),this.player_.currentTime(ct)},_proto.getCurrentTime_=function(){return this.player_.scrubbing()?this.player_.getCache().currentTime:this.player_.currentTime()},_proto.getPercent=function(){var percent,currentTime=this.getCurrentTime_(),liveTracker=this.player_.liveTracker;return liveTracker&&liveTracker.isLive()?(percent=(currentTime-liveTracker.seekableStart())/liveTracker.liveWindow(),liveTracker.atLiveEdge()&&(percent=1)):percent=currentTime/this.player_.duration(),percent},_proto.handleMouseDown=function(event){isSingleLeftClick(event)&&(event.stopPropagation(),this.player_.scrubbing(!0),this.videoWasPlaying=!this.player_.paused(),this.player_.pause(),_Slider.prototype.handleMouseDown.call(this,event))},_proto.handleMouseMove=function(event){if(isSingleLeftClick(event)){var newTime,distance=this.calculateDistance(event),liveTracker=this.player_.liveTracker;if(liveTracker&&liveTracker.isLive()){if(distance>=.99)return void liveTracker.seekToLiveEdge();var seekableStart=liveTracker.seekableStart(),seekableEnd=liveTracker.liveCurrentTime();if((newTime=seekableStart+distance*liveTracker.liveWindow())>=seekableEnd&&(newTime=seekableEnd),newTime<=seekableStart&&(newTime=seekableStart+.1),newTime===1/0)return}else(newTime=distance*this.player_.duration())===this.player_.duration()&&(newTime-=.1);this.userSeek_(newTime)}},_proto.enable=function(){_Slider.prototype.enable.call(this);var mouseTimeDisplay=this.getChild("mouseTimeDisplay");mouseTimeDisplay&&mouseTimeDisplay.show()},_proto.disable=function(){_Slider.prototype.disable.call(this);var mouseTimeDisplay=this.getChild("mouseTimeDisplay");mouseTimeDisplay&&mouseTimeDisplay.hide()},_proto.handleMouseUp=function(event){_Slider.prototype.handleMouseUp.call(this,event),event&&event.stopPropagation(),this.player_.scrubbing(!1),this.player_.trigger({type:"timeupdate",target:this,manuallyTriggered:!0}),this.videoWasPlaying?silencePromise(this.player_.play()):this.update_()},_proto.stepForward=function(){this.userSeek_(this.player_.currentTime()+5)},_proto.stepBack=function(){this.userSeek_(this.player_.currentTime()-5)},_proto.handleAction=function(event){this.player_.paused()?this.player_.play():this.player_.pause()},_proto.handleKeyDown=function(event){var liveTracker=this.player_.liveTracker;if(keycode.isEventKey(event,"Space")||keycode.isEventKey(event,"Enter"))event.preventDefault(),event.stopPropagation(),this.handleAction(event);else if(keycode.isEventKey(event,"Home"))event.preventDefault(),event.stopPropagation(),this.userSeek_(0);else if(keycode.isEventKey(event,"End"))event.preventDefault(),event.stopPropagation(),liveTracker&&liveTracker.isLive()?this.userSeek_(liveTracker.liveCurrentTime()):this.userSeek_(this.player_.duration());else if(/^[0-9]$/.test(keycode(event))){event.preventDefault(),event.stopPropagation();var gotoFraction=10*(keycode.codes[keycode(event)]-keycode.codes[0])/100;liveTracker&&liveTracker.isLive()?this.userSeek_(liveTracker.seekableStart()+liveTracker.liveWindow()*gotoFraction):this.userSeek_(this.player_.duration()*gotoFraction)}else keycode.isEventKey(event,"PgDn")?(event.preventDefault(),event.stopPropagation(),this.userSeek_(this.player_.currentTime()-60)):keycode.isEventKey(event,"PgUp")?(event.preventDefault(),event.stopPropagation(),this.userSeek_(this.player_.currentTime()+60)):_Slider.prototype.handleKeyDown.call(this,event)},_proto.dispose=function(){this.disableInterval_(),this.off(this.player_,["ended","durationchange","timeupdate"],this.update),this.player_.liveTracker&&this.off(this.player_.liveTracker,"liveedgechange",this.update),this.off(this.player_,["playing"],this.enableIntervalHandler_),this.off(this.player_,["ended","pause","waiting"],this.disableIntervalHandler_),"hidden"in document&&"visibilityState"in document&&this.off(document,"visibilitychange",this.toggleVisibility_),_Slider.prototype.dispose.call(this)},SeekBar}(Slider);SeekBar.prototype.options_={children:["loadProgressBar","playProgressBar"],barName:"playProgressBar"},IS_IOS||IS_ANDROID||SeekBar.prototype.options_.children.splice(1,0,"mouseTimeDisplay"),Component$1.registerComponent("SeekBar",SeekBar);var ProgressControl=function(_Component){function ProgressControl(player,options){var _this;return(_this=_Component.call(this,player,options)||this).handleMouseMove=throttle(bind(assertThisInitialized(_this),_this.handleMouseMove),30),_this.throttledHandleMouseSeek=throttle(bind(assertThisInitialized(_this),_this.handleMouseSeek),30),_this.handleMouseUpHandler_=function(e){return _this.handleMouseUp(e)},_this.handleMouseDownHandler_=function(e){return _this.handleMouseDown(e)},_this.enable(),_this}inheritsLoose(ProgressControl,_Component);var _proto=ProgressControl.prototype;return _proto.createEl=function(){return _Component.prototype.createEl.call(this,"div",{className:"vjs-progress-control vjs-control"})},_proto.handleMouseMove=function(event){var seekBar=this.getChild("seekBar");if(seekBar){var playProgressBar=seekBar.getChild("playProgressBar"),mouseTimeDisplay=seekBar.getChild("mouseTimeDisplay");if(playProgressBar||mouseTimeDisplay){var seekBarEl=seekBar.el(),seekBarRect=findPosition(seekBarEl),seekBarPoint=getPointerPosition(seekBarEl,event).x;seekBarPoint=clamp(seekBarPoint,0,1),mouseTimeDisplay&&mouseTimeDisplay.update(seekBarRect,seekBarPoint),playProgressBar&&playProgressBar.update(seekBarRect,seekBar.getProgress())}}},_proto.handleMouseSeek=function(event){var seekBar=this.getChild("seekBar");seekBar&&seekBar.handleMouseMove(event)},_proto.enabled=function(){return this.enabled_},_proto.disable=function(){if(this.children().forEach((function(child){return child.disable&&child.disable()})),this.enabled()&&(this.off(["mousedown","touchstart"],this.handleMouseDownHandler_),this.off(this.el_,"mousemove",this.handleMouseMove),this.removeListenersAddedOnMousedownAndTouchstart(),this.addClass("disabled"),this.enabled_=!1,this.player_.scrubbing())){var seekBar=this.getChild("seekBar");this.player_.scrubbing(!1),seekBar.videoWasPlaying&&silencePromise(this.player_.play())}},_proto.enable=function(){this.children().forEach((function(child){return child.enable&&child.enable()})),this.enabled()||(this.on(["mousedown","touchstart"],this.handleMouseDownHandler_),this.on(this.el_,"mousemove",this.handleMouseMove),this.removeClass("disabled"),this.enabled_=!0)},_proto.removeListenersAddedOnMousedownAndTouchstart=function(){var doc=this.el_.ownerDocument;this.off(doc,"mousemove",this.throttledHandleMouseSeek),this.off(doc,"touchmove",this.throttledHandleMouseSeek),this.off(doc,"mouseup",this.handleMouseUpHandler_),this.off(doc,"touchend",this.handleMouseUpHandler_)},_proto.handleMouseDown=function(event){var doc=this.el_.ownerDocument,seekBar=this.getChild("seekBar");seekBar&&seekBar.handleMouseDown(event),this.on(doc,"mousemove",this.throttledHandleMouseSeek),this.on(doc,"touchmove",this.throttledHandleMouseSeek),this.on(doc,"mouseup",this.handleMouseUpHandler_),this.on(doc,"touchend",this.handleMouseUpHandler_)},_proto.handleMouseUp=function(event){var seekBar=this.getChild("seekBar");seekBar&&seekBar.handleMouseUp(event),this.removeListenersAddedOnMousedownAndTouchstart()},ProgressControl}(Component$1);ProgressControl.prototype.options_={children:["seekBar"]},Component$1.registerComponent("ProgressControl",ProgressControl);var PictureInPictureToggle=function(_Button){function PictureInPictureToggle(player,options){var _this;return(_this=_Button.call(this,player,options)||this).on(player,["enterpictureinpicture","leavepictureinpicture"],(function(e){return _this.handlePictureInPictureChange(e)})),_this.on(player,["disablepictureinpicturechanged","loadedmetadata"],(function(e){return _this.handlePictureInPictureEnabledChange(e)})),_this.disable(),_this}inheritsLoose(PictureInPictureToggle,_Button);var _proto=PictureInPictureToggle.prototype;return _proto.buildCSSClass=function(){return"vjs-picture-in-picture-control "+_Button.prototype.buildCSSClass.call(this)},_proto.handlePictureInPictureEnabledChange=function(){document.pictureInPictureEnabled&&!1===this.player_.disablePictureInPicture()?this.enable():this.disable()},_proto.handlePictureInPictureChange=function(event){this.player_.isInPictureInPicture()?this.controlText("Exit Picture-in-Picture"):this.controlText("Picture-in-Picture"),this.handlePictureInPictureEnabledChange()},_proto.handleClick=function(event){this.player_.isInPictureInPicture()?this.player_.exitPictureInPicture():this.player_.requestPictureInPicture()},PictureInPictureToggle}(Button);PictureInPictureToggle.prototype.controlText_="Picture-in-Picture",Component$1.registerComponent("PictureInPictureToggle",PictureInPictureToggle);var FullscreenToggle=function(_Button){function FullscreenToggle(player,options){var _this;return(_this=_Button.call(this,player,options)||this).on(player,"fullscreenchange",(function(e){return _this.handleFullscreenChange(e)})),!1===document[player.fsApi_.fullscreenEnabled]&&_this.disable(),_this}inheritsLoose(FullscreenToggle,_Button);var _proto=FullscreenToggle.prototype;return _proto.buildCSSClass=function(){return"vjs-fullscreen-control "+_Button.prototype.buildCSSClass.call(this)},_proto.handleFullscreenChange=function(event){this.player_.isFullscreen()?this.controlText("Non-Fullscreen"):this.controlText("Fullscreen")},_proto.handleClick=function(event){this.player_.isFullscreen()?this.player_.exitFullscreen():this.player_.requestFullscreen()},FullscreenToggle}(Button);FullscreenToggle.prototype.controlText_="Fullscreen",Component$1.registerComponent("FullscreenToggle",FullscreenToggle);var VolumeLevel=function(_Component){function VolumeLevel(){return _Component.apply(this,arguments)||this}return inheritsLoose(VolumeLevel,_Component),VolumeLevel.prototype.createEl=function(){var el=_Component.prototype.createEl.call(this,"div",{className:"vjs-volume-level"});return el.appendChild(_Component.prototype.createEl.call(this,"span",{className:"vjs-control-text"})),el},VolumeLevel}(Component$1);Component$1.registerComponent("VolumeLevel",VolumeLevel);var VolumeLevelTooltip=function(_Component){function VolumeLevelTooltip(player,options){var _this;return(_this=_Component.call(this,player,options)||this).update=throttle(bind(assertThisInitialized(_this),_this.update),30),_this}inheritsLoose(VolumeLevelTooltip,_Component);var _proto=VolumeLevelTooltip.prototype;return _proto.createEl=function(){return _Component.prototype.createEl.call(this,"div",{className:"vjs-volume-tooltip"},{"aria-hidden":"true"})},_proto.update=function(rangeBarRect,rangeBarPoint,vertical,content){if(!vertical){var tooltipRect=getBoundingClientRect(this.el_),playerRect=getBoundingClientRect(this.player_.el()),volumeBarPointPx=rangeBarRect.width*rangeBarPoint;if(!playerRect||!tooltipRect)return;var spaceLeftOfPoint=rangeBarRect.left-playerRect.left+volumeBarPointPx,spaceRightOfPoint=rangeBarRect.width-volumeBarPointPx+(playerRect.right-rangeBarRect.right),pullTooltipBy=tooltipRect.width/2;spaceLeftOfPoint<pullTooltipBy?pullTooltipBy+=pullTooltipBy-spaceLeftOfPoint:spaceRightOfPoint<pullTooltipBy&&(pullTooltipBy=spaceRightOfPoint),pullTooltipBy<0?pullTooltipBy=0:pullTooltipBy>tooltipRect.width&&(pullTooltipBy=tooltipRect.width),this.el_.style.right="-"+pullTooltipBy+"px"}this.write(content+"%")},_proto.write=function(content){textContent(this.el_,content)},_proto.updateVolume=function(rangeBarRect,rangeBarPoint,vertical,volume,cb){var _this2=this;this.requestNamedAnimationFrame("VolumeLevelTooltip#updateVolume",(function(){_this2.update(rangeBarRect,rangeBarPoint,vertical,volume.toFixed(0)),cb&&cb()}))},VolumeLevelTooltip}(Component$1);Component$1.registerComponent("VolumeLevelTooltip",VolumeLevelTooltip);var MouseVolumeLevelDisplay=function(_Component){function MouseVolumeLevelDisplay(player,options){var _this;return(_this=_Component.call(this,player,options)||this).update=throttle(bind(assertThisInitialized(_this),_this.update),30),_this}inheritsLoose(MouseVolumeLevelDisplay,_Component);var _proto=MouseVolumeLevelDisplay.prototype;return _proto.createEl=function(){return _Component.prototype.createEl.call(this,"div",{className:"vjs-mouse-display"})},_proto.update=function(rangeBarRect,rangeBarPoint,vertical){var _this2=this,volume=100*rangeBarPoint;this.getChild("volumeLevelTooltip").updateVolume(rangeBarRect,rangeBarPoint,vertical,volume,(function(){vertical?_this2.el_.style.bottom=rangeBarRect.height*rangeBarPoint+"px":_this2.el_.style.left=rangeBarRect.width*rangeBarPoint+"px"}))},MouseVolumeLevelDisplay}(Component$1);MouseVolumeLevelDisplay.prototype.options_={children:["volumeLevelTooltip"]},Component$1.registerComponent("MouseVolumeLevelDisplay",MouseVolumeLevelDisplay);var VolumeBar=function(_Slider){function VolumeBar(player,options){var _this;return(_this=_Slider.call(this,player,options)||this).on("slideractive",(function(e){return _this.updateLastVolume_(e)})),_this.on(player,"volumechange",(function(e){return _this.updateARIAAttributes(e)})),player.ready((function(){return _this.updateARIAAttributes()})),_this}inheritsLoose(VolumeBar,_Slider);var _proto=VolumeBar.prototype;return _proto.createEl=function(){return _Slider.prototype.createEl.call(this,"div",{className:"vjs-volume-bar vjs-slider-bar"},{"aria-label":this.localize("Volume Level"),"aria-live":"polite"})},_proto.handleMouseDown=function(event){isSingleLeftClick(event)&&_Slider.prototype.handleMouseDown.call(this,event)},_proto.handleMouseMove=function(event){var mouseVolumeLevelDisplay=this.getChild("mouseVolumeLevelDisplay");if(mouseVolumeLevelDisplay){var volumeBarEl=this.el(),volumeBarRect=getBoundingClientRect(volumeBarEl),vertical=this.vertical(),volumeBarPoint=getPointerPosition(volumeBarEl,event);volumeBarPoint=vertical?volumeBarPoint.y:volumeBarPoint.x,volumeBarPoint=clamp(volumeBarPoint,0,1),mouseVolumeLevelDisplay.update(volumeBarRect,volumeBarPoint,vertical)}isSingleLeftClick(event)&&(this.checkMuted(),this.player_.volume(this.calculateDistance(event)))},_proto.checkMuted=function(){this.player_.muted()&&this.player_.muted(!1)},_proto.getPercent=function(){return this.player_.muted()?0:this.player_.volume()},_proto.stepForward=function(){this.checkMuted(),this.player_.volume(this.player_.volume()+.1)},_proto.stepBack=function(){this.checkMuted(),this.player_.volume(this.player_.volume()-.1)},_proto.updateARIAAttributes=function(event){var ariaValue=this.player_.muted()?0:this.volumeAsPercentage_();this.el_.setAttribute("aria-valuenow",ariaValue),this.el_.setAttribute("aria-valuetext",ariaValue+"%")},_proto.volumeAsPercentage_=function(){return Math.round(100*this.player_.volume())},_proto.updateLastVolume_=function(){var _this2=this,volumeBeforeDrag=this.player_.volume();this.one("sliderinactive",(function(){0===_this2.player_.volume()&&_this2.player_.lastVolume_(volumeBeforeDrag)}))},VolumeBar}(Slider);VolumeBar.prototype.options_={children:["volumeLevel"],barName:"volumeLevel"},IS_IOS||IS_ANDROID||VolumeBar.prototype.options_.children.splice(0,0,"mouseVolumeLevelDisplay"),VolumeBar.prototype.playerEvent="volumechange",Component$1.registerComponent("VolumeBar",VolumeBar);var VolumeControl=function(_Component){function VolumeControl(player,options){var _this;return void 0===options&&(options={}),options.vertical=options.vertical||!1,(void 0===options.volumeBar||isPlain(options.volumeBar))&&(options.volumeBar=options.volumeBar||{},options.volumeBar.vertical=options.vertical),_this=_Component.call(this,player,options)||this,function(self,player){player.tech_&&!player.tech_.featuresVolumeControl&&self.addClass("vjs-hidden"),self.on(player,"loadstart",(function(){player.tech_.featuresVolumeControl?self.removeClass("vjs-hidden"):self.addClass("vjs-hidden")}))}(assertThisInitialized(_this),player),_this.throttledHandleMouseMove=throttle(bind(assertThisInitialized(_this),_this.handleMouseMove),30),_this.handleMouseUpHandler_=function(e){return _this.handleMouseUp(e)},_this.on("mousedown",(function(e){return _this.handleMouseDown(e)})),_this.on("touchstart",(function(e){return _this.handleMouseDown(e)})),_this.on("mousemove",(function(e){return _this.handleMouseMove(e)})),_this.on(_this.volumeBar,["focus","slideractive"],(function(){_this.volumeBar.addClass("vjs-slider-active"),_this.addClass("vjs-slider-active"),_this.trigger("slideractive")})),_this.on(_this.volumeBar,["blur","sliderinactive"],(function(){_this.volumeBar.removeClass("vjs-slider-active"),_this.removeClass("vjs-slider-active"),_this.trigger("sliderinactive")})),_this}inheritsLoose(VolumeControl,_Component);var _proto=VolumeControl.prototype;return _proto.createEl=function(){var orientationClass="vjs-volume-horizontal";return this.options_.vertical&&(orientationClass="vjs-volume-vertical"),_Component.prototype.createEl.call(this,"div",{className:"vjs-volume-control vjs-control "+orientationClass})},_proto.handleMouseDown=function(event){var doc=this.el_.ownerDocument;this.on(doc,"mousemove",this.throttledHandleMouseMove),this.on(doc,"touchmove",this.throttledHandleMouseMove),this.on(doc,"mouseup",this.handleMouseUpHandler_),this.on(doc,"touchend",this.handleMouseUpHandler_)},_proto.handleMouseUp=function(event){var doc=this.el_.ownerDocument;this.off(doc,"mousemove",this.throttledHandleMouseMove),this.off(doc,"touchmove",this.throttledHandleMouseMove),this.off(doc,"mouseup",this.handleMouseUpHandler_),this.off(doc,"touchend",this.handleMouseUpHandler_)},_proto.handleMouseMove=function(event){this.volumeBar.handleMouseMove(event)},VolumeControl}(Component$1);VolumeControl.prototype.options_={children:["volumeBar"]},Component$1.registerComponent("VolumeControl",VolumeControl);var MuteToggle=function(_Button){function MuteToggle(player,options){var _this;return _this=_Button.call(this,player,options)||this,function(self,player){player.tech_&&!player.tech_.featuresMuteControl&&self.addClass("vjs-hidden"),self.on(player,"loadstart",(function(){player.tech_.featuresMuteControl?self.removeClass("vjs-hidden"):self.addClass("vjs-hidden")}))}(assertThisInitialized(_this),player),_this.on(player,["loadstart","volumechange"],(function(e){return _this.update(e)})),_this}inheritsLoose(MuteToggle,_Button);var _proto=MuteToggle.prototype;return _proto.buildCSSClass=function(){return"vjs-mute-control "+_Button.prototype.buildCSSClass.call(this)},_proto.handleClick=function(event){var vol=this.player_.volume(),lastVolume=this.player_.lastVolume_();if(0===vol){var volumeToSet=lastVolume<.1?.1:lastVolume;this.player_.volume(volumeToSet),this.player_.muted(!1)}else this.player_.muted(!this.player_.muted())},_proto.update=function(event){this.updateIcon_(),this.updateControlText_()},_proto.updateIcon_=function(){var vol=this.player_.volume(),level=3;IS_IOS&&this.player_.tech_&&this.player_.tech_.el_&&this.player_.muted(this.player_.tech_.el_.muted),0===vol||this.player_.muted()?level=0:vol<.33?level=1:vol<.67&&(level=2);for(var i=0;i<4;i++)removeClass(this.el_,"vjs-vol-"+i);addClass(this.el_,"vjs-vol-"+level)},_proto.updateControlText_=function(){var text=this.player_.muted()||0===this.player_.volume()?"Unmute":"Mute";this.controlText()!==text&&this.controlText(text)},MuteToggle}(Button);MuteToggle.prototype.controlText_="Mute",Component$1.registerComponent("MuteToggle",MuteToggle);var VolumePanel=function(_Component){function VolumePanel(player,options){var _this;return void 0===options&&(options={}),void 0!==options.inline?options.inline=options.inline:options.inline=!0,(void 0===options.volumeControl||isPlain(options.volumeControl))&&(options.volumeControl=options.volumeControl||{},options.volumeControl.vertical=!options.inline),(_this=_Component.call(this,player,options)||this).handleKeyPressHandler_=function(e){return _this.handleKeyPress(e)},_this.on(player,["loadstart"],(function(e){return _this.volumePanelState_(e)})),_this.on(_this.muteToggle,"keyup",(function(e){return _this.handleKeyPress(e)})),_this.on(_this.volumeControl,"keyup",(function(e){return _this.handleVolumeControlKeyUp(e)})),_this.on("keydown",(function(e){return _this.handleKeyPress(e)})),_this.on("mouseover",(function(e){return _this.handleMouseOver(e)})),_this.on("mouseout",(function(e){return _this.handleMouseOut(e)})),_this.on(_this.volumeControl,["slideractive"],_this.sliderActive_),_this.on(_this.volumeControl,["sliderinactive"],_this.sliderInactive_),_this}inheritsLoose(VolumePanel,_Component);var _proto=VolumePanel.prototype;return _proto.sliderActive_=function(){this.addClass("vjs-slider-active")},_proto.sliderInactive_=function(){this.removeClass("vjs-slider-active")},_proto.volumePanelState_=function(){this.volumeControl.hasClass("vjs-hidden")&&this.muteToggle.hasClass("vjs-hidden")&&this.addClass("vjs-hidden"),this.volumeControl.hasClass("vjs-hidden")&&!this.muteToggle.hasClass("vjs-hidden")&&this.addClass("vjs-mute-toggle-only")},_proto.createEl=function(){var orientationClass="vjs-volume-panel-horizontal";return this.options_.inline||(orientationClass="vjs-volume-panel-vertical"),_Component.prototype.createEl.call(this,"div",{className:"vjs-volume-panel vjs-control "+orientationClass})},_proto.dispose=function(){this.handleMouseOut(),_Component.prototype.dispose.call(this)},_proto.handleVolumeControlKeyUp=function(event){keycode.isEventKey(event,"Esc")&&this.muteToggle.focus()},_proto.handleMouseOver=function(event){this.addClass("vjs-hover"),on(document,"keyup",this.handleKeyPressHandler_)},_proto.handleMouseOut=function(event){this.removeClass("vjs-hover"),off(document,"keyup",this.handleKeyPressHandler_)},_proto.handleKeyPress=function(event){keycode.isEventKey(event,"Esc")&&this.handleMouseOut()},VolumePanel}(Component$1);VolumePanel.prototype.options_={children:["muteToggle","volumeControl"]},Component$1.registerComponent("VolumePanel",VolumePanel);var Menu=function(_Component){function Menu(player,options){var _this;return _this=_Component.call(this,player,options)||this,options&&(_this.menuButton_=options.menuButton),_this.focusedChild_=-1,_this.on("keydown",(function(e){return _this.handleKeyDown(e)})),_this.boundHandleBlur_=function(e){return _this.handleBlur(e)},_this.boundHandleTapClick_=function(e){return _this.handleTapClick(e)},_this}inheritsLoose(Menu,_Component);var _proto=Menu.prototype;return _proto.addEventListenerForItem=function(component){component instanceof Component$1&&(this.on(component,"blur",this.boundHandleBlur_),this.on(component,["tap","click"],this.boundHandleTapClick_))},_proto.removeEventListenerForItem=function(component){component instanceof Component$1&&(this.off(component,"blur",this.boundHandleBlur_),this.off(component,["tap","click"],this.boundHandleTapClick_))},_proto.removeChild=function(component){"string"==typeof component&&(component=this.getChild(component)),this.removeEventListenerForItem(component),_Component.prototype.removeChild.call(this,component)},_proto.addItem=function(component){var childComponent=this.addChild(component);childComponent&&this.addEventListenerForItem(childComponent)},_proto.createEl=function(){var contentElType=this.options_.contentElType||"ul";this.contentEl_=createEl(contentElType,{className:"vjs-menu-content"}),this.contentEl_.setAttribute("role","menu");var el=_Component.prototype.createEl.call(this,"div",{append:this.contentEl_,className:"vjs-menu"});return el.appendChild(this.contentEl_),on(el,"click",(function(event){event.preventDefault(),event.stopImmediatePropagation()})),el},_proto.dispose=function(){this.contentEl_=null,this.boundHandleBlur_=null,this.boundHandleTapClick_=null,_Component.prototype.dispose.call(this)},_proto.handleBlur=function(event){var relatedTarget=event.relatedTarget||document.activeElement;if(!this.children().some((function(element){return element.el()===relatedTarget}))){var btn=this.menuButton_;btn&&btn.buttonPressed_&&relatedTarget!==btn.el().firstChild&&btn.unpressButton()}},_proto.handleTapClick=function(event){if(this.menuButton_){this.menuButton_.unpressButton();var childComponents=this.children();if(!Array.isArray(childComponents))return;var foundComponent=childComponents.filter((function(component){return component.el()===event.target}))[0];if(!foundComponent)return;"CaptionSettingsMenuItem"!==foundComponent.name()&&this.menuButton_.focus()}},_proto.handleKeyDown=function(event){keycode.isEventKey(event,"Left")||keycode.isEventKey(event,"Down")?(event.preventDefault(),event.stopPropagation(),this.stepForward()):(keycode.isEventKey(event,"Right")||keycode.isEventKey(event,"Up"))&&(event.preventDefault(),event.stopPropagation(),this.stepBack())},_proto.stepForward=function(){var stepChild=0;void 0!==this.focusedChild_&&(stepChild=this.focusedChild_+1),this.focus(stepChild)},_proto.stepBack=function(){var stepChild=0;void 0!==this.focusedChild_&&(stepChild=this.focusedChild_-1),this.focus(stepChild)},_proto.focus=function(item){void 0===item&&(item=0);var children=this.children().slice();children.length&&children[0].hasClass("vjs-menu-title")&&children.shift(),children.length>0&&(item<0?item=0:item>=children.length&&(item=children.length-1),this.focusedChild_=item,children[item].el_.focus())},Menu}(Component$1);Component$1.registerComponent("Menu",Menu);var MenuButton=function(_Component){function MenuButton(player,options){var _this;void 0===options&&(options={}),(_this=_Component.call(this,player,options)||this).menuButton_=new Button(player,options),_this.menuButton_.controlText(_this.controlText_),_this.menuButton_.el_.setAttribute("aria-haspopup","true");var buttonClass=Button.prototype.buildCSSClass();_this.menuButton_.el_.className=_this.buildCSSClass()+" "+buttonClass,_this.menuButton_.removeClass("vjs-control"),_this.addChild(_this.menuButton_),_this.update(),_this.enabled_=!0;var handleClick=function(e){return _this.handleClick(e)};return _this.handleMenuKeyUp_=function(e){return _this.handleMenuKeyUp(e)},_this.on(_this.menuButton_,"tap",handleClick),_this.on(_this.menuButton_,"click",handleClick),_this.on(_this.menuButton_,"keydown",(function(e){return _this.handleKeyDown(e)})),_this.on(_this.menuButton_,"mouseenter",(function(){_this.addClass("vjs-hover"),_this.menu.show(),on(document,"keyup",_this.handleMenuKeyUp_)})),_this.on("mouseleave",(function(e){return _this.handleMouseLeave(e)})),_this.on("keydown",(function(e){return _this.handleSubmenuKeyDown(e)})),_this}inheritsLoose(MenuButton,_Component);var _proto=MenuButton.prototype;return _proto.update=function(){var menu=this.createMenu();this.menu&&(this.menu.dispose(),this.removeChild(this.menu)),this.menu=menu,this.addChild(menu),this.buttonPressed_=!1,this.menuButton_.el_.setAttribute("aria-expanded","false"),this.items&&this.items.length<=this.hideThreshold_?this.hide():this.show()},_proto.createMenu=function(){var menu=new Menu(this.player_,{menuButton:this});if(this.hideThreshold_=0,this.options_.title){var titleEl=createEl("li",{className:"vjs-menu-title",textContent:toTitleCase$1(this.options_.title),tabIndex:-1}),titleComponent=new Component$1(this.player_,{el:titleEl});menu.addItem(titleComponent)}if(this.items=this.createItems(),this.items)for(var i=0;i<this.items.length;i++)menu.addItem(this.items[i]);return menu},_proto.createItems=function(){},_proto.createEl=function(){return _Component.prototype.createEl.call(this,"div",{className:this.buildWrapperCSSClass()},{})},_proto.buildWrapperCSSClass=function(){var menuButtonClass="vjs-menu-button";return!0===this.options_.inline?menuButtonClass+="-inline":menuButtonClass+="-popup","vjs-menu-button "+menuButtonClass+" "+Button.prototype.buildCSSClass()+" "+_Component.prototype.buildCSSClass.call(this)},_proto.buildCSSClass=function(){var menuButtonClass="vjs-menu-button";return!0===this.options_.inline?menuButtonClass+="-inline":menuButtonClass+="-popup","vjs-menu-button "+menuButtonClass+" "+_Component.prototype.buildCSSClass.call(this)},_proto.controlText=function(text,el){return void 0===el&&(el=this.menuButton_.el()),this.menuButton_.controlText(text,el)},_proto.dispose=function(){this.handleMouseLeave(),_Component.prototype.dispose.call(this)},_proto.handleClick=function(event){this.buttonPressed_?this.unpressButton():this.pressButton()},_proto.handleMouseLeave=function(event){this.removeClass("vjs-hover"),off(document,"keyup",this.handleMenuKeyUp_)},_proto.focus=function(){this.menuButton_.focus()},_proto.blur=function(){this.menuButton_.blur()},_proto.handleKeyDown=function(event){keycode.isEventKey(event,"Esc")||keycode.isEventKey(event,"Tab")?(this.buttonPressed_&&this.unpressButton(),keycode.isEventKey(event,"Tab")||(event.preventDefault(),this.menuButton_.focus())):(keycode.isEventKey(event,"Up")||keycode.isEventKey(event,"Down"))&&(this.buttonPressed_||(event.preventDefault(),this.pressButton()))},_proto.handleMenuKeyUp=function(event){(keycode.isEventKey(event,"Esc")||keycode.isEventKey(event,"Tab"))&&this.removeClass("vjs-hover")},_proto.handleSubmenuKeyPress=function(event){this.handleSubmenuKeyDown(event)},_proto.handleSubmenuKeyDown=function(event){(keycode.isEventKey(event,"Esc")||keycode.isEventKey(event,"Tab"))&&(this.buttonPressed_&&this.unpressButton(),keycode.isEventKey(event,"Tab")||(event.preventDefault(),this.menuButton_.focus()))},_proto.pressButton=function(){if(this.enabled_){if(this.buttonPressed_=!0,this.menu.show(),this.menu.lockShowing(),this.menuButton_.el_.setAttribute("aria-expanded","true"),IS_IOS&&isInFrame())return;this.menu.focus()}},_proto.unpressButton=function(){this.enabled_&&(this.buttonPressed_=!1,this.menu.unlockShowing(),this.menu.hide(),this.menuButton_.el_.setAttribute("aria-expanded","false"))},_proto.disable=function(){this.unpressButton(),this.enabled_=!1,this.addClass("vjs-disabled"),this.menuButton_.disable()},_proto.enable=function(){this.enabled_=!0,this.removeClass("vjs-disabled"),this.menuButton_.enable()},MenuButton}(Component$1);Component$1.registerComponent("MenuButton",MenuButton);var TrackButton=function(_MenuButton){function TrackButton(player,options){var _this,tracks=options.tracks;if((_this=_MenuButton.call(this,player,options)||this).items.length<=1&&_this.hide(),!tracks)return assertThisInitialized(_this);var updateHandler=bind(assertThisInitialized(_this),_this.update);return tracks.addEventListener("removetrack",updateHandler),tracks.addEventListener("addtrack",updateHandler),tracks.addEventListener("labelchange",updateHandler),_this.player_.on("ready",updateHandler),_this.player_.on("dispose",(function(){tracks.removeEventListener("removetrack",updateHandler),tracks.removeEventListener("addtrack",updateHandler),tracks.removeEventListener("labelchange",updateHandler)})),_this}return inheritsLoose(TrackButton,_MenuButton),TrackButton}(MenuButton);Component$1.registerComponent("TrackButton",TrackButton);var MenuKeys=["Tab","Esc","Up","Down","Right","Left"],MenuItem=function(_ClickableComponent){function MenuItem(player,options){var _this;return(_this=_ClickableComponent.call(this,player,options)||this).selectable=options.selectable,_this.isSelected_=options.selected||!1,_this.multiSelectable=options.multiSelectable,_this.selected(_this.isSelected_),_this.selectable?_this.multiSelectable?_this.el_.setAttribute("role","menuitemcheckbox"):_this.el_.setAttribute("role","menuitemradio"):_this.el_.setAttribute("role","menuitem"),_this}inheritsLoose(MenuItem,_ClickableComponent);var _proto=MenuItem.prototype;return _proto.createEl=function(type,props,attrs){this.nonIconControl=!0;var el=_ClickableComponent.prototype.createEl.call(this,"li",assign({className:"vjs-menu-item",tabIndex:-1},props),attrs);return el.replaceChild(createEl("span",{className:"vjs-menu-item-text",textContent:this.localize(this.options_.label)}),el.querySelector(".vjs-icon-placeholder")),el},_proto.handleKeyDown=function(event){MenuKeys.some((function(key){return keycode.isEventKey(event,key)}))||_ClickableComponent.prototype.handleKeyDown.call(this,event)},_proto.handleClick=function(event){this.selected(!0)},_proto.selected=function(_selected){this.selectable&&(_selected?(this.addClass("vjs-selected"),this.el_.setAttribute("aria-checked","true"),this.controlText(", selected"),this.isSelected_=!0):(this.removeClass("vjs-selected"),this.el_.setAttribute("aria-checked","false"),this.controlText(""),this.isSelected_=!1))},MenuItem}(ClickableComponent);Component$1.registerComponent("MenuItem",MenuItem);var TextTrackMenuItem=function(_MenuItem){function TextTrackMenuItem(player,options){var _this,track=options.track,tracks=player.textTracks();options.label=track.label||track.language||"Unknown",options.selected="showing"===track.mode,(_this=_MenuItem.call(this,player,options)||this).track=track,_this.kinds=(options.kinds||[options.kind||_this.track.kind]).filter(Boolean);var event,changeHandler=function(){for(var _len=arguments.length,args=new Array(_len),_key=0;_key<_len;_key++)args[_key]=arguments[_key];_this.handleTracksChange.apply(assertThisInitialized(_this),args)},selectedLanguageChangeHandler=function(){for(var _len2=arguments.length,args=new Array(_len2),_key2=0;_key2<_len2;_key2++)args[_key2]=arguments[_key2];_this.handleSelectedLanguageChange.apply(assertThisInitialized(_this),args)};(player.on(["loadstart","texttrackchange"],changeHandler),tracks.addEventListener("change",changeHandler),tracks.addEventListener("selectedlanguagechange",selectedLanguageChangeHandler),_this.on("dispose",(function(){player.off(["loadstart","texttrackchange"],changeHandler),tracks.removeEventListener("change",changeHandler),tracks.removeEventListener("selectedlanguagechange",selectedLanguageChangeHandler)})),void 0===tracks.onchange)&&_this.on(["tap","click"],(function(){if("object"!=typeof window.Event)try{event=new window.Event("change")}catch(err){}event||(event=document.createEvent("Event")).initEvent("change",!0,!0),tracks.dispatchEvent(event)}));return _this.handleTracksChange(),_this}inheritsLoose(TextTrackMenuItem,_MenuItem);var _proto=TextTrackMenuItem.prototype;return _proto.handleClick=function(event){var referenceTrack=this.track,tracks=this.player_.textTracks();if(_MenuItem.prototype.handleClick.call(this,event),tracks)for(var i=0;i<tracks.length;i++){var track=tracks[i];-1!==this.kinds.indexOf(track.kind)&&(track===referenceTrack?"showing"!==track.mode&&(track.mode="showing"):"disabled"!==track.mode&&(track.mode="disabled"))}},_proto.handleTracksChange=function(event){var shouldBeSelected="showing"===this.track.mode;shouldBeSelected!==this.isSelected_&&this.selected(shouldBeSelected)},_proto.handleSelectedLanguageChange=function(event){if("showing"===this.track.mode){var selectedLanguage=this.player_.cache_.selectedLanguage;if(selectedLanguage&&selectedLanguage.enabled&&selectedLanguage.language===this.track.language&&selectedLanguage.kind!==this.track.kind)return;this.player_.cache_.selectedLanguage={enabled:!0,language:this.track.language,kind:this.track.kind}}},_proto.dispose=function(){this.track=null,_MenuItem.prototype.dispose.call(this)},TextTrackMenuItem}(MenuItem);Component$1.registerComponent("TextTrackMenuItem",TextTrackMenuItem);var OffTextTrackMenuItem=function(_TextTrackMenuItem){function OffTextTrackMenuItem(player,options){return options.track={player:player,kind:options.kind,kinds:options.kinds,default:!1,mode:"disabled"},options.kinds||(options.kinds=[options.kind]),options.label?options.track.label=options.label:options.track.label=options.kinds.join(" and ")+" off",options.selectable=!0,options.multiSelectable=!1,_TextTrackMenuItem.call(this,player,options)||this}inheritsLoose(OffTextTrackMenuItem,_TextTrackMenuItem);var _proto=OffTextTrackMenuItem.prototype;return _proto.handleTracksChange=function(event){for(var tracks=this.player().textTracks(),shouldBeSelected=!0,i=0,l=tracks.length;i<l;i++){var track=tracks[i];if(this.options_.kinds.indexOf(track.kind)>-1&&"showing"===track.mode){shouldBeSelected=!1;break}}shouldBeSelected!==this.isSelected_&&this.selected(shouldBeSelected)},_proto.handleSelectedLanguageChange=function(event){for(var tracks=this.player().textTracks(),allHidden=!0,i=0,l=tracks.length;i<l;i++){var track=tracks[i];if(["captions","descriptions","subtitles"].indexOf(track.kind)>-1&&"showing"===track.mode){allHidden=!1;break}}allHidden&&(this.player_.cache_.selectedLanguage={enabled:!1})},OffTextTrackMenuItem}(TextTrackMenuItem);Component$1.registerComponent("OffTextTrackMenuItem",OffTextTrackMenuItem);var TextTrackButton=function(_TrackButton){function TextTrackButton(player,options){return void 0===options&&(options={}),options.tracks=player.textTracks(),_TrackButton.call(this,player,options)||this}return inheritsLoose(TextTrackButton,_TrackButton),TextTrackButton.prototype.createItems=function(items,TrackMenuItem){var label;void 0===items&&(items=[]),void 0===TrackMenuItem&&(TrackMenuItem=TextTrackMenuItem),this.label_&&(label=this.label_+" off"),items.push(new OffTextTrackMenuItem(this.player_,{kinds:this.kinds_,kind:this.kind_,label:label})),this.hideThreshold_+=1;var tracks=this.player_.textTracks();Array.isArray(this.kinds_)||(this.kinds_=[this.kind_]);for(var i=0;i<tracks.length;i++){var track=tracks[i];if(this.kinds_.indexOf(track.kind)>-1){var item=new TrackMenuItem(this.player_,{track:track,kinds:this.kinds_,kind:this.kind_,selectable:!0,multiSelectable:!1});item.addClass("vjs-"+track.kind+"-menu-item"),items.push(item)}}return items},TextTrackButton}(TrackButton);Component$1.registerComponent("TextTrackButton",TextTrackButton);var ChaptersTrackMenuItem=function(_MenuItem){function ChaptersTrackMenuItem(player,options){var _this,track=options.track,cue=options.cue,currentTime=player.currentTime();return options.selectable=!0,options.multiSelectable=!1,options.label=cue.text,options.selected=cue.startTime<=currentTime&&currentTime<cue.endTime,(_this=_MenuItem.call(this,player,options)||this).track=track,_this.cue=cue,track.addEventListener("cuechange",bind(assertThisInitialized(_this),_this.update)),_this}inheritsLoose(ChaptersTrackMenuItem,_MenuItem);var _proto=ChaptersTrackMenuItem.prototype;return _proto.handleClick=function(event){_MenuItem.prototype.handleClick.call(this),this.player_.currentTime(this.cue.startTime),this.update(this.cue.startTime)},_proto.update=function(event){var cue=this.cue,currentTime=this.player_.currentTime();this.selected(cue.startTime<=currentTime&&currentTime<cue.endTime)},ChaptersTrackMenuItem}(MenuItem);Component$1.registerComponent("ChaptersTrackMenuItem",ChaptersTrackMenuItem);var ChaptersButton=function(_TextTrackButton){function ChaptersButton(player,options,ready){return _TextTrackButton.call(this,player,options,ready)||this}inheritsLoose(ChaptersButton,_TextTrackButton);var _proto=ChaptersButton.prototype;return _proto.buildCSSClass=function(){return"vjs-chapters-button "+_TextTrackButton.prototype.buildCSSClass.call(this)},_proto.buildWrapperCSSClass=function(){return"vjs-chapters-button "+_TextTrackButton.prototype.buildWrapperCSSClass.call(this)},_proto.update=function(event){this.track_&&(!event||"addtrack"!==event.type&&"removetrack"!==event.type)||this.setTrack(this.findChaptersTrack()),_TextTrackButton.prototype.update.call(this)},_proto.setTrack=function(track){if(this.track_!==track){if(this.updateHandler_||(this.updateHandler_=this.update.bind(this)),this.track_){var remoteTextTrackEl=this.player_.remoteTextTrackEls().getTrackElementByTrack_(this.track_);remoteTextTrackEl&&remoteTextTrackEl.removeEventListener("load",this.updateHandler_),this.track_=null}if(this.track_=track,this.track_){this.track_.mode="hidden";var _remoteTextTrackEl=this.player_.remoteTextTrackEls().getTrackElementByTrack_(this.track_);_remoteTextTrackEl&&_remoteTextTrackEl.addEventListener("load",this.updateHandler_)}}},_proto.findChaptersTrack=function(){for(var tracks=this.player_.textTracks()||[],i=tracks.length-1;i>=0;i--){var track=tracks[i];if(track.kind===this.kind_)return track}},_proto.getMenuCaption=function(){return this.track_&&this.track_.label?this.track_.label:this.localize(toTitleCase$1(this.kind_))},_proto.createMenu=function(){return this.options_.title=this.getMenuCaption(),_TextTrackButton.prototype.createMenu.call(this)},_proto.createItems=function(){var items=[];if(!this.track_)return items;var cues=this.track_.cues;if(!cues)return items;for(var i=0,l=cues.length;i<l;i++){var cue=cues[i],mi=new ChaptersTrackMenuItem(this.player_,{track:this.track_,cue:cue});items.push(mi)}return items},ChaptersButton}(TextTrackButton);ChaptersButton.prototype.kind_="chapters",ChaptersButton.prototype.controlText_="Chapters",Component$1.registerComponent("ChaptersButton",ChaptersButton);var DescriptionsButton=function(_TextTrackButton){function DescriptionsButton(player,options,ready){var _this;_this=_TextTrackButton.call(this,player,options,ready)||this;var tracks=player.textTracks(),changeHandler=bind(assertThisInitialized(_this),_this.handleTracksChange);return tracks.addEventListener("change",changeHandler),_this.on("dispose",(function(){tracks.removeEventListener("change",changeHandler)})),_this}inheritsLoose(DescriptionsButton,_TextTrackButton);var _proto=DescriptionsButton.prototype;return _proto.handleTracksChange=function(event){for(var tracks=this.player().textTracks(),disabled=!1,i=0,l=tracks.length;i<l;i++){var track=tracks[i];if(track.kind!==this.kind_&&"showing"===track.mode){disabled=!0;break}}disabled?this.disable():this.enable()},_proto.buildCSSClass=function(){return"vjs-descriptions-button "+_TextTrackButton.prototype.buildCSSClass.call(this)},_proto.buildWrapperCSSClass=function(){return"vjs-descriptions-button "+_TextTrackButton.prototype.buildWrapperCSSClass.call(this)},DescriptionsButton}(TextTrackButton);DescriptionsButton.prototype.kind_="descriptions",DescriptionsButton.prototype.controlText_="Descriptions",Component$1.registerComponent("DescriptionsButton",DescriptionsButton);var SubtitlesButton=function(_TextTrackButton){function SubtitlesButton(player,options,ready){return _TextTrackButton.call(this,player,options,ready)||this}inheritsLoose(SubtitlesButton,_TextTrackButton);var _proto=SubtitlesButton.prototype;return _proto.buildCSSClass=function(){return"vjs-subtitles-button "+_TextTrackButton.prototype.buildCSSClass.call(this)},_proto.buildWrapperCSSClass=function(){return"vjs-subtitles-button "+_TextTrackButton.prototype.buildWrapperCSSClass.call(this)},SubtitlesButton}(TextTrackButton);SubtitlesButton.prototype.kind_="subtitles",SubtitlesButton.prototype.controlText_="Subtitles",Component$1.registerComponent("SubtitlesButton",SubtitlesButton);var CaptionSettingsMenuItem=function(_TextTrackMenuItem){function CaptionSettingsMenuItem(player,options){var _this;return options.track={player:player,kind:options.kind,label:options.kind+" settings",selectable:!1,default:!1,mode:"disabled"},options.selectable=!1,options.name="CaptionSettingsMenuItem",(_this=_TextTrackMenuItem.call(this,player,options)||this).addClass("vjs-texttrack-settings"),_this.controlText(", opens "+options.kind+" settings dialog"),_this}return inheritsLoose(CaptionSettingsMenuItem,_TextTrackMenuItem),CaptionSettingsMenuItem.prototype.handleClick=function(event){this.player().getChild("textTrackSettings").open()},CaptionSettingsMenuItem}(TextTrackMenuItem);Component$1.registerComponent("CaptionSettingsMenuItem",CaptionSettingsMenuItem);var CaptionsButton=function(_TextTrackButton){function CaptionsButton(player,options,ready){return _TextTrackButton.call(this,player,options,ready)||this}inheritsLoose(CaptionsButton,_TextTrackButton);var _proto=CaptionsButton.prototype;return _proto.buildCSSClass=function(){return"vjs-captions-button "+_TextTrackButton.prototype.buildCSSClass.call(this)},_proto.buildWrapperCSSClass=function(){return"vjs-captions-button "+_TextTrackButton.prototype.buildWrapperCSSClass.call(this)},_proto.createItems=function(){var items=[];return this.player().tech_&&this.player().tech_.featuresNativeTextTracks||!this.player().getChild("textTrackSettings")||(items.push(new CaptionSettingsMenuItem(this.player_,{kind:this.kind_})),this.hideThreshold_+=1),_TextTrackButton.prototype.createItems.call(this,items)},CaptionsButton}(TextTrackButton);CaptionsButton.prototype.kind_="captions",CaptionsButton.prototype.controlText_="Captions",Component$1.registerComponent("CaptionsButton",CaptionsButton);var SubsCapsMenuItem=function(_TextTrackMenuItem){function SubsCapsMenuItem(){return _TextTrackMenuItem.apply(this,arguments)||this}return inheritsLoose(SubsCapsMenuItem,_TextTrackMenuItem),SubsCapsMenuItem.prototype.createEl=function(type,props,attrs){var el=_TextTrackMenuItem.prototype.createEl.call(this,type,props,attrs),parentSpan=el.querySelector(".vjs-menu-item-text");return"captions"===this.options_.track.kind&&(parentSpan.appendChild(createEl("span",{className:"vjs-icon-placeholder"},{"aria-hidden":!0})),parentSpan.appendChild(createEl("span",{className:"vjs-control-text",textContent:" "+this.localize("Captions")}))),el},SubsCapsMenuItem}(TextTrackMenuItem);Component$1.registerComponent("SubsCapsMenuItem",SubsCapsMenuItem);var SubsCapsButton=function(_TextTrackButton){function SubsCapsButton(player,options){var _this;return void 0===options&&(options={}),(_this=_TextTrackButton.call(this,player,options)||this).label_="subtitles",["en","en-us","en-ca","fr-ca"].indexOf(_this.player_.language_)>-1&&(_this.label_="captions"),_this.menuButton_.controlText(toTitleCase$1(_this.label_)),_this}inheritsLoose(SubsCapsButton,_TextTrackButton);var _proto=SubsCapsButton.prototype;return _proto.buildCSSClass=function(){return"vjs-subs-caps-button "+_TextTrackButton.prototype.buildCSSClass.call(this)},_proto.buildWrapperCSSClass=function(){return"vjs-subs-caps-button "+_TextTrackButton.prototype.buildWrapperCSSClass.call(this)},_proto.createItems=function(){var items=[];return this.player().tech_&&this.player().tech_.featuresNativeTextTracks||!this.player().getChild("textTrackSettings")||(items.push(new CaptionSettingsMenuItem(this.player_,{kind:this.label_})),this.hideThreshold_+=1),items=_TextTrackButton.prototype.createItems.call(this,items,SubsCapsMenuItem)},SubsCapsButton}(TextTrackButton);SubsCapsButton.prototype.kinds_=["captions","subtitles"],SubsCapsButton.prototype.controlText_="Subtitles",Component$1.registerComponent("SubsCapsButton",SubsCapsButton);var AudioTrackMenuItem=function(_MenuItem){function AudioTrackMenuItem(player,options){var _this,track=options.track,tracks=player.audioTracks();options.label=track.label||track.language||"Unknown",options.selected=track.enabled,(_this=_MenuItem.call(this,player,options)||this).track=track,_this.addClass("vjs-"+track.kind+"-menu-item");var changeHandler=function(){for(var _len=arguments.length,args=new Array(_len),_key=0;_key<_len;_key++)args[_key]=arguments[_key];_this.handleTracksChange.apply(assertThisInitialized(_this),args)};return tracks.addEventListener("change",changeHandler),_this.on("dispose",(function(){tracks.removeEventListener("change",changeHandler)})),_this}inheritsLoose(AudioTrackMenuItem,_MenuItem);var _proto=AudioTrackMenuItem.prototype;return _proto.createEl=function(type,props,attrs){var el=_MenuItem.prototype.createEl.call(this,type,props,attrs),parentSpan=el.querySelector(".vjs-menu-item-text");return"main-desc"===this.options_.track.kind&&(parentSpan.appendChild(_MenuItem.prototype.createEl.call(this,"span",{className:"vjs-icon-placeholder"},{"aria-hidden":!0})),parentSpan.appendChild(_MenuItem.prototype.createEl.call(this,"span",{className:"vjs-control-text",textContent:this.localize("Descriptions")}))),el},_proto.handleClick=function(event){_MenuItem.prototype.handleClick.call(this,event),this.track.enabled=!0},_proto.handleTracksChange=function(event){this.selected(this.track.enabled)},AudioTrackMenuItem}(MenuItem);Component$1.registerComponent("AudioTrackMenuItem",AudioTrackMenuItem);var AudioTrackButton=function(_TrackButton){function AudioTrackButton(player,options){return void 0===options&&(options={}),options.tracks=player.audioTracks(),_TrackButton.call(this,player,options)||this}inheritsLoose(AudioTrackButton,_TrackButton);var _proto=AudioTrackButton.prototype;return _proto.buildCSSClass=function(){return"vjs-audio-button "+_TrackButton.prototype.buildCSSClass.call(this)},_proto.buildWrapperCSSClass=function(){return"vjs-audio-button "+_TrackButton.prototype.buildWrapperCSSClass.call(this)},_proto.createItems=function(items){void 0===items&&(items=[]),this.hideThreshold_=1;for(var tracks=this.player_.audioTracks(),i=0;i<tracks.length;i++){var track=tracks[i];items.push(new AudioTrackMenuItem(this.player_,{track:track,selectable:!0,multiSelectable:!1}))}return items},AudioTrackButton}(TrackButton);AudioTrackButton.prototype.controlText_="Audio Track",Component$1.registerComponent("AudioTrackButton",AudioTrackButton);var PlaybackRateMenuItem=function(_MenuItem){function PlaybackRateMenuItem(player,options){var _this,label=options.rate,rate=parseFloat(label,10);return options.label=label,options.selected=rate===player.playbackRate(),options.selectable=!0,options.multiSelectable=!1,(_this=_MenuItem.call(this,player,options)||this).label=label,_this.rate=rate,_this.on(player,"ratechange",(function(e){return _this.update(e)})),_this}inheritsLoose(PlaybackRateMenuItem,_MenuItem);var _proto=PlaybackRateMenuItem.prototype;return _proto.handleClick=function(event){_MenuItem.prototype.handleClick.call(this),this.player().playbackRate(this.rate)},_proto.update=function(event){this.selected(this.player().playbackRate()===this.rate)},PlaybackRateMenuItem}(MenuItem);PlaybackRateMenuItem.prototype.contentElType="button",Component$1.registerComponent("PlaybackRateMenuItem",PlaybackRateMenuItem);var PlaybackRateMenuButton=function(_MenuButton){function PlaybackRateMenuButton(player,options){var _this;return(_this=_MenuButton.call(this,player,options)||this).menuButton_.el_.setAttribute("aria-describedby",_this.labelElId_),_this.updateVisibility(),_this.updateLabel(),_this.on(player,"loadstart",(function(e){return _this.updateVisibility(e)})),_this.on(player,"ratechange",(function(e){return _this.updateLabel(e)})),_this.on(player,"playbackrateschange",(function(e){return _this.handlePlaybackRateschange(e)})),_this}inheritsLoose(PlaybackRateMenuButton,_MenuButton);var _proto=PlaybackRateMenuButton.prototype;return _proto.createEl=function(){var el=_MenuButton.prototype.createEl.call(this);return this.labelElId_="vjs-playback-rate-value-label-"+this.id_,this.labelEl_=createEl("div",{className:"vjs-playback-rate-value",id:this.labelElId_,textContent:"1x"}),el.appendChild(this.labelEl_),el},_proto.dispose=function(){this.labelEl_=null,_MenuButton.prototype.dispose.call(this)},_proto.buildCSSClass=function(){return"vjs-playback-rate "+_MenuButton.prototype.buildCSSClass.call(this)},_proto.buildWrapperCSSClass=function(){return"vjs-playback-rate "+_MenuButton.prototype.buildWrapperCSSClass.call(this)},_proto.createItems=function(){for(var rates=this.playbackRates(),items=[],i=rates.length-1;i>=0;i--)items.push(new PlaybackRateMenuItem(this.player(),{rate:rates[i]+"x"}));return items},_proto.updateARIAAttributes=function(){this.el().setAttribute("aria-valuenow",this.player().playbackRate())},_proto.handleClick=function(event){for(var currentRate=this.player().playbackRate(),rates=this.playbackRates(),newRate=rates[0],i=0;i<rates.length;i++)if(rates[i]>currentRate){newRate=rates[i];break}this.player().playbackRate(newRate)},_proto.handlePlaybackRateschange=function(event){this.update()},_proto.playbackRates=function(){var player=this.player();return player.playbackRates&&player.playbackRates()||[]},_proto.playbackRateSupported=function(){return this.player().tech_&&this.player().tech_.featuresPlaybackRate&&this.playbackRates()&&this.playbackRates().length>0},_proto.updateVisibility=function(event){this.playbackRateSupported()?this.removeClass("vjs-hidden"):this.addClass("vjs-hidden")},_proto.updateLabel=function(event){this.playbackRateSupported()&&(this.labelEl_.textContent=this.player().playbackRate()+"x")},PlaybackRateMenuButton}(MenuButton);PlaybackRateMenuButton.prototype.controlText_="Playback Rate",Component$1.registerComponent("PlaybackRateMenuButton",PlaybackRateMenuButton);var Spacer=function(_Component){function Spacer(){return _Component.apply(this,arguments)||this}inheritsLoose(Spacer,_Component);var _proto=Spacer.prototype;return _proto.buildCSSClass=function(){return"vjs-spacer "+_Component.prototype.buildCSSClass.call(this)},_proto.createEl=function(tag,props,attributes){return void 0===tag&&(tag="div"),void 0===props&&(props={}),void 0===attributes&&(attributes={}),props.className||(props.className=this.buildCSSClass()),_Component.prototype.createEl.call(this,tag,props,attributes)},Spacer}(Component$1);Component$1.registerComponent("Spacer",Spacer);var CustomControlSpacer=function(_Spacer){function CustomControlSpacer(){return _Spacer.apply(this,arguments)||this}inheritsLoose(CustomControlSpacer,_Spacer);var _proto=CustomControlSpacer.prototype;return _proto.buildCSSClass=function(){return"vjs-custom-control-spacer "+_Spacer.prototype.buildCSSClass.call(this)},_proto.createEl=function(){return _Spacer.prototype.createEl.call(this,"div",{className:this.buildCSSClass(),textContent:" "})},CustomControlSpacer}(Spacer);Component$1.registerComponent("CustomControlSpacer",CustomControlSpacer);var ControlBar=function(_Component){function ControlBar(){return _Component.apply(this,arguments)||this}return inheritsLoose(ControlBar,_Component),ControlBar.prototype.createEl=function(){return _Component.prototype.createEl.call(this,"div",{className:"vjs-control-bar",dir:"ltr"})},ControlBar}(Component$1);ControlBar.prototype.options_={children:["playToggle","volumePanel","currentTimeDisplay","timeDivider","durationDisplay","progressControl","liveDisplay","seekToLive","remainingTimeDisplay","customControlSpacer","playbackRateMenuButton","chaptersButton","descriptionsButton","subsCapsButton","audioTrackButton","fullscreenToggle"]},"exitPictureInPicture"in document&&ControlBar.prototype.options_.children.splice(ControlBar.prototype.options_.children.length-1,0,"pictureInPictureToggle"),Component$1.registerComponent("ControlBar",ControlBar);var ErrorDisplay=function(_ModalDialog){function ErrorDisplay(player,options){var _this;return(_this=_ModalDialog.call(this,player,options)||this).on(player,"error",(function(e){return _this.open(e)})),_this}inheritsLoose(ErrorDisplay,_ModalDialog);var _proto=ErrorDisplay.prototype;return _proto.buildCSSClass=function(){return"vjs-error-display "+_ModalDialog.prototype.buildCSSClass.call(this)},_proto.content=function(){var error=this.player().error();return error?this.localize(error.message):""},ErrorDisplay}(ModalDialog);ErrorDisplay.prototype.options_=_extends_1({},ModalDialog.prototype.options_,{pauseOnOpen:!1,fillAlways:!0,temporary:!1,uncloseable:!0}),Component$1.registerComponent("ErrorDisplay",ErrorDisplay);var COLOR_BLACK=["#000","Black"],COLOR_BLUE=["#00F","Blue"],COLOR_CYAN=["#0FF","Cyan"],COLOR_GREEN=["#0F0","Green"],COLOR_MAGENTA=["#F0F","Magenta"],COLOR_RED=["#F00","Red"],COLOR_WHITE=["#FFF","White"],COLOR_YELLOW=["#FF0","Yellow"],OPACITY_OPAQUE=["1","Opaque"],OPACITY_SEMI=["0.5","Semi-Transparent"],OPACITY_TRANS=["0","Transparent"],selectConfigs={backgroundColor:{selector:".vjs-bg-color > select",id:"captions-background-color-%s",label:"Color",options:[COLOR_BLACK,COLOR_WHITE,COLOR_RED,COLOR_GREEN,COLOR_BLUE,COLOR_YELLOW,COLOR_MAGENTA,COLOR_CYAN]},backgroundOpacity:{selector:".vjs-bg-opacity > select",id:"captions-background-opacity-%s",label:"Transparency",options:[OPACITY_OPAQUE,OPACITY_SEMI,OPACITY_TRANS]},color:{selector:".vjs-fg-color > select",id:"captions-foreground-color-%s",label:"Color",options:[COLOR_WHITE,COLOR_BLACK,COLOR_RED,COLOR_GREEN,COLOR_BLUE,COLOR_YELLOW,COLOR_MAGENTA,COLOR_CYAN]},edgeStyle:{selector:".vjs-edge-style > select",id:"%s",label:"Text Edge Style",options:[["none","None"],["raised","Raised"],["depressed","Depressed"],["uniform","Uniform"],["dropshadow","Dropshadow"]]},fontFamily:{selector:".vjs-font-family > select",id:"captions-font-family-%s",label:"Font Family",options:[["proportionalSansSerif","Proportional Sans-Serif"],["monospaceSansSerif","Monospace Sans-Serif"],["proportionalSerif","Proportional Serif"],["monospaceSerif","Monospace Serif"],["casual","Casual"],["script","Script"],["small-caps","Small Caps"]]},fontPercent:{selector:".vjs-font-percent > select",id:"captions-font-size-%s",label:"Font Size",options:[["0.50","50%"],["0.75","75%"],["1.00","100%"],["1.25","125%"],["1.50","150%"],["1.75","175%"],["2.00","200%"],["3.00","300%"],["4.00","400%"]],default:2,parser:function(v){return"1.00"===v?null:Number(v)}},textOpacity:{selector:".vjs-text-opacity > select",id:"captions-foreground-opacity-%s",label:"Transparency",options:[OPACITY_OPAQUE,OPACITY_SEMI]},windowColor:{selector:".vjs-window-color > select",id:"captions-window-color-%s",label:"Color"},windowOpacity:{selector:".vjs-window-opacity > select",id:"captions-window-opacity-%s",label:"Transparency",options:[OPACITY_TRANS,OPACITY_SEMI,OPACITY_OPAQUE]}};function parseOptionValue(value,parser){if(parser&&(value=parser(value)),value&&"none"!==value)return value}selectConfigs.windowColor.options=selectConfigs.backgroundColor.options;var TextTrackSettings=function(_ModalDialog){function TextTrackSettings(player,options){var _this;return options.temporary=!1,(_this=_ModalDialog.call(this,player,options)||this).updateDisplay=_this.updateDisplay.bind(assertThisInitialized(_this)),_this.fill(),_this.hasBeenOpened_=_this.hasBeenFilled_=!0,_this.endDialog=createEl("p",{className:"vjs-control-text",textContent:_this.localize("End of dialog window.")}),_this.el().appendChild(_this.endDialog),_this.setDefaults(),void 0===options.persistTextTrackSettings&&(_this.options_.persistTextTrackSettings=_this.options_.playerOptions.persistTextTrackSettings),_this.on(_this.$(".vjs-done-button"),"click",(function(){_this.saveSettings(),_this.close()})),_this.on(_this.$(".vjs-default-button"),"click",(function(){_this.setDefaults(),_this.updateDisplay()})),each(selectConfigs,(function(config){_this.on(_this.$(config.selector),"change",_this.updateDisplay)})),_this.options_.persistTextTrackSettings&&_this.restoreSettings(),_this}inheritsLoose(TextTrackSettings,_ModalDialog);var _proto=TextTrackSettings.prototype;return _proto.dispose=function(){this.endDialog=null,_ModalDialog.prototype.dispose.call(this)},_proto.createElSelect_=function(key,legendId,type){var _this2=this;void 0===legendId&&(legendId=""),void 0===type&&(type="label");var config=selectConfigs[key],id=config.id.replace("%s",this.id_),selectLabelledbyIds=[legendId,id].join(" ").trim();return["<"+type+' id="'+id+'" class="'+("label"===type?"vjs-label":"")+'">',this.localize(config.label),"</"+type+">",'<select aria-labelledby="'+selectLabelledbyIds+'">'].concat(config.options.map((function(o){var optionId=id+"-"+o[1].replace(/\W+/g,"");return['<option id="'+optionId+'" value="'+o[0]+'" ','aria-labelledby="'+selectLabelledbyIds+" "+optionId+'">',_this2.localize(o[1]),"</option>"].join("")}))).concat("</select>").join("")},_proto.createElFgColor_=function(){var legendId="captions-text-legend-"+this.id_;return['<fieldset class="vjs-fg-color vjs-track-setting">','<legend id="'+legendId+'">',this.localize("Text"),"</legend>",this.createElSelect_("color",legendId),'<span class="vjs-text-opacity vjs-opacity">',this.createElSelect_("textOpacity",legendId),"</span>","</fieldset>"].join("")},_proto.createElBgColor_=function(){var legendId="captions-background-"+this.id_;return['<fieldset class="vjs-bg-color vjs-track-setting">','<legend id="'+legendId+'">',this.localize("Background"),"</legend>",this.createElSelect_("backgroundColor",legendId),'<span class="vjs-bg-opacity vjs-opacity">',this.createElSelect_("backgroundOpacity",legendId),"</span>","</fieldset>"].join("")},_proto.createElWinColor_=function(){var legendId="captions-window-"+this.id_;return['<fieldset class="vjs-window-color vjs-track-setting">','<legend id="'+legendId+'">',this.localize("Window"),"</legend>",this.createElSelect_("windowColor",legendId),'<span class="vjs-window-opacity vjs-opacity">',this.createElSelect_("windowOpacity",legendId),"</span>","</fieldset>"].join("")},_proto.createElColors_=function(){return createEl("div",{className:"vjs-track-settings-colors",innerHTML:[this.createElFgColor_(),this.createElBgColor_(),this.createElWinColor_()].join("")})},_proto.createElFont_=function(){return createEl("div",{className:"vjs-track-settings-font",innerHTML:['<fieldset class="vjs-font-percent vjs-track-setting">',this.createElSelect_("fontPercent","","legend"),"</fieldset>",'<fieldset class="vjs-edge-style vjs-track-setting">',this.createElSelect_("edgeStyle","","legend"),"</fieldset>",'<fieldset class="vjs-font-family vjs-track-setting">',this.createElSelect_("fontFamily","","legend"),"</fieldset>"].join("")})},_proto.createElControls_=function(){var defaultsDescription=this.localize("restore all settings to the default values");return createEl("div",{className:"vjs-track-settings-controls",innerHTML:['<button type="button" class="vjs-default-button" title="'+defaultsDescription+'">',this.localize("Reset"),'<span class="vjs-control-text"> '+defaultsDescription+"</span>","</button>",'<button type="button" class="vjs-done-button">'+this.localize("Done")+"</button>"].join("")})},_proto.content=function(){return[this.createElColors_(),this.createElFont_(),this.createElControls_()]},_proto.label=function(){return this.localize("Caption Settings Dialog")},_proto.description=function(){return this.localize("Beginning of dialog window. Escape will cancel and close the window.")},_proto.buildCSSClass=function(){return _ModalDialog.prototype.buildCSSClass.call(this)+" vjs-text-track-settings"},_proto.getValues=function(){var object,fn,initial,_this3=this;return fn=function(accum,config,key){var el,parser,value=(el=_this3.$(config.selector),parser=config.parser,parseOptionValue(el.options[el.options.selectedIndex].value,parser));return void 0!==value&&(accum[key]=value),accum},void 0===(initial={})&&(initial=0),keys(object=selectConfigs).reduce((function(accum,key){return fn(accum,object[key],key)}),initial)},_proto.setValues=function(values){var _this4=this;each(selectConfigs,(function(config,key){!function(el,value,parser){if(value)for(var i=0;i<el.options.length;i++)if(parseOptionValue(el.options[i].value,parser)===value){el.selectedIndex=i;break}}(_this4.$(config.selector),values[key],config.parser)}))},_proto.setDefaults=function(){var _this5=this;each(selectConfigs,(function(config){var index=config.hasOwnProperty("default")?config.default:0;_this5.$(config.selector).selectedIndex=index}))},_proto.restoreSettings=function(){var values;try{values=JSON.parse(window.localStorage.getItem("vjs-text-track-settings"))}catch(err){log$1.warn(err)}values&&this.setValues(values)},_proto.saveSettings=function(){if(this.options_.persistTextTrackSettings){var values=this.getValues();try{Object.keys(values).length?window.localStorage.setItem("vjs-text-track-settings",JSON.stringify(values)):window.localStorage.removeItem("vjs-text-track-settings")}catch(err){log$1.warn(err)}}},_proto.updateDisplay=function(){var ttDisplay=this.player_.getChild("textTrackDisplay");ttDisplay&&ttDisplay.updateDisplay()},_proto.conditionalBlur_=function(){this.previouslyActiveEl_=null;var cb=this.player_.controlBar,subsCapsBtn=cb&&cb.subsCapsButton,ccBtn=cb&&cb.captionsButton;subsCapsBtn?subsCapsBtn.focus():ccBtn&&ccBtn.focus()},TextTrackSettings}(ModalDialog);Component$1.registerComponent("TextTrackSettings",TextTrackSettings);var ResizeManager=function(_Component){function ResizeManager(player,options){var _this,RESIZE_OBSERVER_AVAILABLE=options.ResizeObserver||window.ResizeObserver;null===options.ResizeObserver&&(RESIZE_OBSERVER_AVAILABLE=!1);var options_=mergeOptions$3({createEl:!RESIZE_OBSERVER_AVAILABLE,reportTouchActivity:!1},options);return(_this=_Component.call(this,player,options_)||this).ResizeObserver=options.ResizeObserver||window.ResizeObserver,_this.loadListener_=null,_this.resizeObserver_=null,_this.debouncedHandler_=function(func,wait,immediate,context){var timeout;void 0===context&&(context=window);var debounced=function(){var self=this,args=arguments,_later=function(){timeout=null,_later=null,immediate||func.apply(self,args)};!timeout&&immediate&&func.apply(self,args),context.clearTimeout(timeout),timeout=context.setTimeout(_later,wait)};return debounced.cancel=function(){context.clearTimeout(timeout),timeout=null},debounced}((function(){_this.resizeHandler()}),100,!1,assertThisInitialized(_this)),RESIZE_OBSERVER_AVAILABLE?(_this.resizeObserver_=new _this.ResizeObserver(_this.debouncedHandler_),_this.resizeObserver_.observe(player.el())):(_this.loadListener_=function(){if(_this.el_&&_this.el_.contentWindow){var debouncedHandler_=_this.debouncedHandler_,unloadListener_=_this.unloadListener_=function(){off(this,"resize",debouncedHandler_),off(this,"unload",unloadListener_),unloadListener_=null};on(_this.el_.contentWindow,"unload",unloadListener_),on(_this.el_.contentWindow,"resize",debouncedHandler_)}},_this.one("load",_this.loadListener_)),_this}inheritsLoose(ResizeManager,_Component);var _proto=ResizeManager.prototype;return _proto.createEl=function(){return _Component.prototype.createEl.call(this,"iframe",{className:"vjs-resize-manager",tabIndex:-1},{"aria-hidden":"true"})},_proto.resizeHandler=function(){this.player_&&this.player_.trigger&&this.player_.trigger("playerresize")},_proto.dispose=function(){this.debouncedHandler_&&this.debouncedHandler_.cancel(),this.resizeObserver_&&(this.player_.el()&&this.resizeObserver_.unobserve(this.player_.el()),this.resizeObserver_.disconnect()),this.loadListener_&&this.off("load",this.loadListener_),this.el_&&this.el_.contentWindow&&this.unloadListener_&&this.unloadListener_.call(this.el_.contentWindow),this.ResizeObserver=null,this.resizeObserver=null,this.debouncedHandler_=null,this.loadListener_=null,_Component.prototype.dispose.call(this)},ResizeManager}(Component$1);Component$1.registerComponent("ResizeManager",ResizeManager);var defaults={trackingThreshold:20,liveTolerance:15},LiveTracker=function(_Component){function LiveTracker(player,options){var _this,options_=mergeOptions$3(defaults,options,{createEl:!1});return(_this=_Component.call(this,player,options_)||this).handleVisibilityChange_=function(e){return _this.handleVisibilityChange(e)},_this.trackLiveHandler_=function(){return _this.trackLive_()},_this.handlePlay_=function(e){return _this.handlePlay(e)},_this.handleFirstTimeupdate_=function(e){return _this.handleFirstTimeupdate(e)},_this.handleSeeked_=function(e){return _this.handleSeeked(e)},_this.seekToLiveEdge_=function(e){return _this.seekToLiveEdge(e)},_this.reset_(),_this.on(_this.player_,"durationchange",(function(e){return _this.handleDurationchange(e)})),_this.one(_this.player_,"canplay",(function(){return _this.toggleTracking()})),IE_VERSION&&"hidden"in document&&"visibilityState"in document&&_this.on(document,"visibilitychange",_this.handleVisibilityChange_),_this}inheritsLoose(LiveTracker,_Component);var _proto=LiveTracker.prototype;return _proto.handleVisibilityChange=function(){this.player_.duration()===1/0&&(document.hidden?this.stopTracking():this.startTracking())},_proto.trackLive_=function(){var seekable=this.player_.seekable();if(seekable&&seekable.length){var newTime=Number(window.performance.now().toFixed(4)),deltaTime=-1===this.lastTime_?0:(newTime-this.lastTime_)/1e3;this.lastTime_=newTime,this.pastSeekEnd_=this.pastSeekEnd()+deltaTime;var liveCurrentTime=this.liveCurrentTime(),currentTime=this.player_.currentTime(),isBehind=this.player_.paused()||this.seekedBehindLive_||Math.abs(liveCurrentTime-currentTime)>this.options_.liveTolerance;this.timeupdateSeen_&&liveCurrentTime!==1/0||(isBehind=!1),isBehind!==this.behindLiveEdge_&&(this.behindLiveEdge_=isBehind,this.trigger("liveedgechange"))}},_proto.handleDurationchange=function(){this.toggleTracking()},_proto.toggleTracking=function(){this.player_.duration()===1/0&&this.liveWindow()>=this.options_.trackingThreshold?(this.player_.options_.liveui&&this.player_.addClass("vjs-liveui"),this.startTracking()):(this.player_.removeClass("vjs-liveui"),this.stopTracking())},_proto.startTracking=function(){this.isTracking()||(this.timeupdateSeen_||(this.timeupdateSeen_=this.player_.hasStarted()),this.trackingInterval_=this.setInterval(this.trackLiveHandler_,30),this.trackLive_(),this.on(this.player_,["play","pause"],this.trackLiveHandler_),this.timeupdateSeen_?this.on(this.player_,"seeked",this.handleSeeked_):(this.one(this.player_,"play",this.handlePlay_),this.one(this.player_,"timeupdate",this.handleFirstTimeupdate_)))},_proto.handleFirstTimeupdate=function(){this.timeupdateSeen_=!0,this.on(this.player_,"seeked",this.handleSeeked_)},_proto.handleSeeked=function(){var timeDiff=Math.abs(this.liveCurrentTime()-this.player_.currentTime());this.seekedBehindLive_=this.nextSeekedFromUser_&&timeDiff>2,this.nextSeekedFromUser_=!1,this.trackLive_()},_proto.handlePlay=function(){this.one(this.player_,"timeupdate",this.seekToLiveEdge_)},_proto.reset_=function(){this.lastTime_=-1,this.pastSeekEnd_=0,this.lastSeekEnd_=-1,this.behindLiveEdge_=!0,this.timeupdateSeen_=!1,this.seekedBehindLive_=!1,this.nextSeekedFromUser_=!1,this.clearInterval(this.trackingInterval_),this.trackingInterval_=null,this.off(this.player_,["play","pause"],this.trackLiveHandler_),this.off(this.player_,"seeked",this.handleSeeked_),this.off(this.player_,"play",this.handlePlay_),this.off(this.player_,"timeupdate",this.handleFirstTimeupdate_),this.off(this.player_,"timeupdate",this.seekToLiveEdge_)},_proto.nextSeekedFromUser=function(){this.nextSeekedFromUser_=!0},_proto.stopTracking=function(){this.isTracking()&&(this.reset_(),this.trigger("liveedgechange"))},_proto.seekableEnd=function(){for(var seekable=this.player_.seekable(),seekableEnds=[],i=seekable?seekable.length:0;i--;)seekableEnds.push(seekable.end(i));return seekableEnds.length?seekableEnds.sort()[seekableEnds.length-1]:1/0},_proto.seekableStart=function(){for(var seekable=this.player_.seekable(),seekableStarts=[],i=seekable?seekable.length:0;i--;)seekableStarts.push(seekable.start(i));return seekableStarts.length?seekableStarts.sort()[0]:0},_proto.liveWindow=function(){var liveCurrentTime=this.liveCurrentTime();return liveCurrentTime===1/0?0:liveCurrentTime-this.seekableStart()},_proto.isLive=function(){return this.isTracking()},_proto.atLiveEdge=function(){return!this.behindLiveEdge()},_proto.liveCurrentTime=function(){return this.pastSeekEnd()+this.seekableEnd()},_proto.pastSeekEnd=function(){var seekableEnd=this.seekableEnd();return-1!==this.lastSeekEnd_&&seekableEnd!==this.lastSeekEnd_&&(this.pastSeekEnd_=0),this.lastSeekEnd_=seekableEnd,this.pastSeekEnd_},_proto.behindLiveEdge=function(){return this.behindLiveEdge_},_proto.isTracking=function(){return"number"==typeof this.trackingInterval_},_proto.seekToLiveEdge=function(){this.seekedBehindLive_=!1,this.atLiveEdge()||(this.nextSeekedFromUser_=!1,this.player_.currentTime(this.liveCurrentTime()))},_proto.dispose=function(){this.off(document,"visibilitychange",this.handleVisibilityChange_),this.stopTracking(),_Component.prototype.dispose.call(this)},LiveTracker}(Component$1);Component$1.registerComponent("LiveTracker",LiveTracker);var canPlayType,sourcesetLoad=function(tech){var el=tech.el();if(el.hasAttribute("src"))return tech.triggerSourceset(el.src),!0;var sources=tech.$$("source"),srcUrls=[],src="";if(!sources.length)return!1;for(var i=0;i<sources.length;i++){var url=sources[i].src;url&&-1===srcUrls.indexOf(url)&&srcUrls.push(url)}return!!srcUrls.length&&(1===srcUrls.length&&(src=srcUrls[0]),tech.triggerSourceset(src),!0)},innerHTMLDescriptorPolyfill=Object.defineProperty({},"innerHTML",{get:function(){return this.cloneNode(!0).innerHTML},set:function(v){var dummy=document.createElement(this.nodeName.toLowerCase());dummy.innerHTML=v;for(var docFrag=document.createDocumentFragment();dummy.childNodes.length;)docFrag.appendChild(dummy.childNodes[0]);return this.innerText="",window.Element.prototype.appendChild.call(this,docFrag),this.innerHTML}}),getDescriptor=function(priority,prop){for(var descriptor={},i=0;i<priority.length&&!((descriptor=Object.getOwnPropertyDescriptor(priority[i],prop))&&descriptor.set&&descriptor.get);i++);return descriptor.enumerable=!0,descriptor.configurable=!0,descriptor},firstSourceWatch=function(tech){var el=tech.el();if(!el.resetSourceWatch_){var old={},innerDescriptor=function(tech){return getDescriptor([tech.el(),window.HTMLMediaElement.prototype,window.Element.prototype,innerHTMLDescriptorPolyfill],"innerHTML")}(tech),appendWrapper=function(appendFn){return function(){for(var _len=arguments.length,args=new Array(_len),_key=0;_key<_len;_key++)args[_key]=arguments[_key];var retval=appendFn.apply(el,args);return sourcesetLoad(tech),retval}};["append","appendChild","insertAdjacentHTML"].forEach((function(k){el[k]&&(old[k]=el[k],el[k]=appendWrapper(old[k]))})),Object.defineProperty(el,"innerHTML",mergeOptions$3(innerDescriptor,{set:appendWrapper(innerDescriptor.set)})),el.resetSourceWatch_=function(){el.resetSourceWatch_=null,Object.keys(old).forEach((function(k){el[k]=old[k]})),Object.defineProperty(el,"innerHTML",innerDescriptor)},tech.one("sourceset",el.resetSourceWatch_)}},srcDescriptorPolyfill=Object.defineProperty({},"src",{get:function(){return this.hasAttribute("src")?getAbsoluteURL(window.Element.prototype.getAttribute.call(this,"src")):""},set:function(v){return window.Element.prototype.setAttribute.call(this,"src",v),v}}),setupSourceset=function(tech){if(tech.featuresSourceset){var el=tech.el();if(!el.resetSourceset_){var srcDescriptor=function(tech){return getDescriptor([tech.el(),window.HTMLMediaElement.prototype,srcDescriptorPolyfill],"src")}(tech),oldSetAttribute=el.setAttribute,oldLoad=el.load;Object.defineProperty(el,"src",mergeOptions$3(srcDescriptor,{set:function(v){var retval=srcDescriptor.set.call(el,v);return tech.triggerSourceset(el.src),retval}})),el.setAttribute=function(n,v){var retval=oldSetAttribute.call(el,n,v);return/src/i.test(n)&&tech.triggerSourceset(el.src),retval},el.load=function(){var retval=oldLoad.call(el);return sourcesetLoad(tech)||(tech.triggerSourceset(""),firstSourceWatch(tech)),retval},el.currentSrc?tech.triggerSourceset(el.currentSrc):sourcesetLoad(tech)||firstSourceWatch(tech),el.resetSourceset_=function(){el.resetSourceset_=null,el.load=oldLoad,el.setAttribute=oldSetAttribute,Object.defineProperty(el,"src",srcDescriptor),el.resetSourceWatch_&&el.resetSourceWatch_()}}}},defineLazyProperty=function(obj,key,getValue,setter){void 0===setter&&(setter=!0);var set=function(value){return Object.defineProperty(obj,key,{value:value,enumerable:!0,writable:!0})},options={configurable:!0,enumerable:!0,get:function(){var value=getValue();return set(value),value}};return setter&&(options.set=set),Object.defineProperty(obj,key,options)},Html5=function(_Tech){function Html5(options,ready){var _this;_this=_Tech.call(this,options,ready)||this;var source=options.source,crossoriginTracks=!1;if(source&&(_this.el_.currentSrc!==source.src||options.tag&&3===options.tag.initNetworkState_)?_this.setSource(source):_this.handleLateInit_(_this.el_),options.enableSourceset&&_this.setupSourcesetHandling_(),_this.isScrubbing_=!1,_this.el_.hasChildNodes()){for(var nodes=_this.el_.childNodes,nodesLength=nodes.length,removeNodes=[];nodesLength--;){var node=nodes[nodesLength];"track"===node.nodeName.toLowerCase()&&(_this.featuresNativeTextTracks?(_this.remoteTextTrackEls().addTrackElement_(node),_this.remoteTextTracks().addTrack(node.track),_this.textTracks().addTrack(node.track),crossoriginTracks||_this.el_.hasAttribute("crossorigin")||!isCrossOrigin(node.src)||(crossoriginTracks=!0)):removeNodes.push(node))}for(var i=0;i<removeNodes.length;i++)_this.el_.removeChild(removeNodes[i])}return _this.proxyNativeTracks_(),_this.featuresNativeTextTracks&&crossoriginTracks&&log$1.warn("Text Tracks are being loaded from another origin but the crossorigin attribute isn't used.\nThis may prevent text tracks from loading."),_this.restoreMetadataTracksInIOSNativePlayer_(),(TOUCH_ENABLED||IS_IPHONE||IS_NATIVE_ANDROID)&&!0===options.nativeControlsForTouch&&_this.setControls(!0),_this.proxyWebkitFullscreen_(),_this.triggerReady(),_this}inheritsLoose(Html5,_Tech);var _proto=Html5.prototype;return _proto.dispose=function(){this.el_&&this.el_.resetSourceset_&&this.el_.resetSourceset_(),Html5.disposeMediaElement(this.el_),this.options_=null,_Tech.prototype.dispose.call(this)},_proto.setupSourcesetHandling_=function(){setupSourceset(this)},_proto.restoreMetadataTracksInIOSNativePlayer_=function(){var metadataTracksPreFullscreenState,textTracks=this.textTracks(),takeMetadataTrackSnapshot=function(){metadataTracksPreFullscreenState=[];for(var i=0;i<textTracks.length;i++){var track=textTracks[i];"metadata"===track.kind&&metadataTracksPreFullscreenState.push({track:track,storedMode:track.mode})}};takeMetadataTrackSnapshot(),textTracks.addEventListener("change",takeMetadataTrackSnapshot),this.on("dispose",(function(){return textTracks.removeEventListener("change",takeMetadataTrackSnapshot)}));var restoreTrackMode=function restoreTrackMode(){for(var i=0;i<metadataTracksPreFullscreenState.length;i++){var storedTrack=metadataTracksPreFullscreenState[i];"disabled"===storedTrack.track.mode&&storedTrack.track.mode!==storedTrack.storedMode&&(storedTrack.track.mode=storedTrack.storedMode)}textTracks.removeEventListener("change",restoreTrackMode)};this.on("webkitbeginfullscreen",(function(){textTracks.removeEventListener("change",takeMetadataTrackSnapshot),textTracks.removeEventListener("change",restoreTrackMode),textTracks.addEventListener("change",restoreTrackMode)})),this.on("webkitendfullscreen",(function(){textTracks.removeEventListener("change",takeMetadataTrackSnapshot),textTracks.addEventListener("change",takeMetadataTrackSnapshot),textTracks.removeEventListener("change",restoreTrackMode)}))},_proto.overrideNative_=function(type,override){var _this2=this;if(override===this["featuresNative"+type+"Tracks"]){var lowerCaseType=type.toLowerCase();this[lowerCaseType+"TracksListeners_"]&&Object.keys(this[lowerCaseType+"TracksListeners_"]).forEach((function(eventName){_this2.el()[lowerCaseType+"Tracks"].removeEventListener(eventName,_this2[lowerCaseType+"TracksListeners_"][eventName])})),this["featuresNative"+type+"Tracks"]=!override,this[lowerCaseType+"TracksListeners_"]=null,this.proxyNativeTracksForType_(lowerCaseType)}},_proto.overrideNativeAudioTracks=function(override){this.overrideNative_("Audio",override)},_proto.overrideNativeVideoTracks=function(override){this.overrideNative_("Video",override)},_proto.proxyNativeTracksForType_=function(name){var _this3=this,props=NORMAL[name],elTracks=this.el()[props.getterName],techTracks=this[props.getterName]();if(this["featuresNative"+props.capitalName+"Tracks"]&&elTracks&&elTracks.addEventListener){var listeners={change:function(e){var event={type:"change",target:techTracks,currentTarget:techTracks,srcElement:techTracks};techTracks.trigger(event),"text"===name&&_this3[REMOTE.remoteText.getterName]().trigger(event)},addtrack:function(e){techTracks.addTrack(e.track)},removetrack:function(e){techTracks.removeTrack(e.track)}},removeOldTracks=function(){for(var removeTracks=[],i=0;i<techTracks.length;i++){for(var found=!1,j=0;j<elTracks.length;j++)if(elTracks[j]===techTracks[i]){found=!0;break}found||removeTracks.push(techTracks[i])}for(;removeTracks.length;)techTracks.removeTrack(removeTracks.shift())};this[props.getterName+"Listeners_"]=listeners,Object.keys(listeners).forEach((function(eventName){var listener=listeners[eventName];elTracks.addEventListener(eventName,listener),_this3.on("dispose",(function(e){return elTracks.removeEventListener(eventName,listener)}))})),this.on("loadstart",removeOldTracks),this.on("dispose",(function(e){return _this3.off("loadstart",removeOldTracks)}))}},_proto.proxyNativeTracks_=function(){var _this4=this;NORMAL.names.forEach((function(name){_this4.proxyNativeTracksForType_(name)}))},_proto.createEl=function(){var el=this.options_.tag;if(!el||!this.options_.playerElIngest&&!this.movingMediaElementInDOM){if(el){var clone=el.cloneNode(!0);el.parentNode&&el.parentNode.insertBefore(clone,el),Html5.disposeMediaElement(el),el=clone}else{el=document.createElement("video");var attributes=mergeOptions$3({},this.options_.tag&&getAttributes(this.options_.tag));TOUCH_ENABLED&&!0===this.options_.nativeControlsForTouch||delete attributes.controls,setAttributes(el,assign(attributes,{id:this.options_.techId,class:"vjs-tech"}))}el.playerId=this.options_.playerId}void 0!==this.options_.preload&&setAttribute(el,"preload",this.options_.preload),void 0!==this.options_.disablePictureInPicture&&(el.disablePictureInPicture=this.options_.disablePictureInPicture);for(var settingsAttrs=["loop","muted","playsinline","autoplay"],i=0;i<settingsAttrs.length;i++){var attr=settingsAttrs[i],value=this.options_[attr];void 0!==value&&(value?setAttribute(el,attr,attr):removeAttribute(el,attr),el[attr]=value)}return el},_proto.handleLateInit_=function(el){if(0!==el.networkState&&3!==el.networkState){if(0===el.readyState){var loadstartFired=!1,setLoadstartFired=function(){loadstartFired=!0};this.on("loadstart",setLoadstartFired);var triggerLoadstart=function(){loadstartFired||this.trigger("loadstart")};return this.on("loadedmetadata",triggerLoadstart),void this.ready((function(){this.off("loadstart",setLoadstartFired),this.off("loadedmetadata",triggerLoadstart),loadstartFired||this.trigger("loadstart")}))}var eventsToTrigger=["loadstart"];eventsToTrigger.push("loadedmetadata"),el.readyState>=2&&eventsToTrigger.push("loadeddata"),el.readyState>=3&&eventsToTrigger.push("canplay"),el.readyState>=4&&eventsToTrigger.push("canplaythrough"),this.ready((function(){eventsToTrigger.forEach((function(type){this.trigger(type)}),this)}))}},_proto.setScrubbing=function(isScrubbing){this.isScrubbing_=isScrubbing},_proto.scrubbing=function(){return this.isScrubbing_},_proto.setCurrentTime=function(seconds){try{this.isScrubbing_&&this.el_.fastSeek&&IS_ANY_SAFARI?this.el_.fastSeek(seconds):this.el_.currentTime=seconds}catch(e){log$1(e,"Video is not ready. (Video.js)")}},_proto.duration=function(){var _this5=this;if(this.el_.duration===1/0&&IS_ANDROID&&IS_CHROME&&0===this.el_.currentTime){return this.on("timeupdate",(function checkProgress(){_this5.el_.currentTime>0&&(_this5.el_.duration===1/0&&_this5.trigger("durationchange"),_this5.off("timeupdate",checkProgress))})),NaN}return this.el_.duration||NaN},_proto.width=function(){return this.el_.offsetWidth},_proto.height=function(){return this.el_.offsetHeight},_proto.proxyWebkitFullscreen_=function(){var _this6=this;if("webkitDisplayingFullscreen"in this.el_){var endFn=function(){this.trigger("fullscreenchange",{isFullscreen:!1})},beginFn=function(){"webkitPresentationMode"in this.el_&&"picture-in-picture"!==this.el_.webkitPresentationMode&&(this.one("webkitendfullscreen",endFn),this.trigger("fullscreenchange",{isFullscreen:!0,nativeIOSFullscreen:!0}))};this.on("webkitbeginfullscreen",beginFn),this.on("dispose",(function(){_this6.off("webkitbeginfullscreen",beginFn),_this6.off("webkitendfullscreen",endFn)}))}},_proto.supportsFullScreen=function(){if("function"==typeof this.el_.webkitEnterFullScreen){var userAgent=window.navigator&&window.navigator.userAgent||"";if(/Android/.test(userAgent)||!/Chrome|Mac OS X 10.5/.test(userAgent))return!0}return!1},_proto.enterFullScreen=function(){var video=this.el_;if(video.paused&&video.networkState<=video.HAVE_METADATA)silencePromise(this.el_.play()),this.setTimeout((function(){video.pause();try{video.webkitEnterFullScreen()}catch(e){this.trigger("fullscreenerror",e)}}),0);else try{video.webkitEnterFullScreen()}catch(e){this.trigger("fullscreenerror",e)}},_proto.exitFullScreen=function(){this.el_.webkitDisplayingFullscreen?this.el_.webkitExitFullScreen():this.trigger("fullscreenerror",new Error("The video is not fullscreen"))},_proto.requestPictureInPicture=function(){return this.el_.requestPictureInPicture()},_proto.src=function(_src){if(void 0===_src)return this.el_.src;this.setSrc(_src)},_proto.reset=function(){Html5.resetMediaElement(this.el_)},_proto.currentSrc=function(){return this.currentSource_?this.currentSource_.src:this.el_.currentSrc},_proto.setControls=function(val){this.el_.controls=!!val},_proto.addTextTrack=function(kind,label,language){return this.featuresNativeTextTracks?this.el_.addTextTrack(kind,label,language):_Tech.prototype.addTextTrack.call(this,kind,label,language)},_proto.createRemoteTextTrack=function(options){if(!this.featuresNativeTextTracks)return _Tech.prototype.createRemoteTextTrack.call(this,options);var htmlTrackElement=document.createElement("track");return options.kind&&(htmlTrackElement.kind=options.kind),options.label&&(htmlTrackElement.label=options.label),(options.language||options.srclang)&&(htmlTrackElement.srclang=options.language||options.srclang),options.default&&(htmlTrackElement.default=options.default),options.id&&(htmlTrackElement.id=options.id),options.src&&(htmlTrackElement.src=options.src),htmlTrackElement},_proto.addRemoteTextTrack=function(options,manualCleanup){var htmlTrackElement=_Tech.prototype.addRemoteTextTrack.call(this,options,manualCleanup);return this.featuresNativeTextTracks&&this.el().appendChild(htmlTrackElement),htmlTrackElement},_proto.removeRemoteTextTrack=function(track){if(_Tech.prototype.removeRemoteTextTrack.call(this,track),this.featuresNativeTextTracks)for(var tracks=this.$$("track"),i=tracks.length;i--;)track!==tracks[i]&&track!==tracks[i].track||this.el().removeChild(tracks[i])},_proto.getVideoPlaybackQuality=function(){if("function"==typeof this.el().getVideoPlaybackQuality)return this.el().getVideoPlaybackQuality();var videoPlaybackQuality={};return void 0!==this.el().webkitDroppedFrameCount&&void 0!==this.el().webkitDecodedFrameCount&&(videoPlaybackQuality.droppedVideoFrames=this.el().webkitDroppedFrameCount,videoPlaybackQuality.totalVideoFrames=this.el().webkitDecodedFrameCount),window.performance&&"function"==typeof window.performance.now?videoPlaybackQuality.creationTime=window.performance.now():window.performance&&window.performance.timing&&"number"==typeof window.performance.timing.navigationStart&&(videoPlaybackQuality.creationTime=window.Date.now()-window.performance.timing.navigationStart),videoPlaybackQuality},Html5}(Tech);defineLazyProperty(Html5,"TEST_VID",(function(){if(isReal()){var video=document.createElement("video"),track=document.createElement("track");return track.kind="captions",track.srclang="en",track.label="English",video.appendChild(track),video}})),Html5.isSupported=function(){try{Html5.TEST_VID.volume=.5}catch(e){return!1}return!(!Html5.TEST_VID||!Html5.TEST_VID.canPlayType)},Html5.canPlayType=function(type){return Html5.TEST_VID.canPlayType(type)},Html5.canPlaySource=function(srcObj,options){return Html5.canPlayType(srcObj.type)},Html5.canControlVolume=function(){try{var volume=Html5.TEST_VID.volume;return Html5.TEST_VID.volume=volume/2+.1,volume!==Html5.TEST_VID.volume}catch(e){return!1}},Html5.canMuteVolume=function(){try{var muted=Html5.TEST_VID.muted;return Html5.TEST_VID.muted=!muted,Html5.TEST_VID.muted?setAttribute(Html5.TEST_VID,"muted","muted"):removeAttribute(Html5.TEST_VID,"muted"),muted!==Html5.TEST_VID.muted}catch(e){return!1}},Html5.canControlPlaybackRate=function(){if(IS_ANDROID&&IS_CHROME&&CHROME_VERSION<58)return!1;try{var playbackRate=Html5.TEST_VID.playbackRate;return Html5.TEST_VID.playbackRate=playbackRate/2+.1,playbackRate!==Html5.TEST_VID.playbackRate}catch(e){return!1}},Html5.canOverrideAttributes=function(){try{var noop=function(){};Object.defineProperty(document.createElement("video"),"src",{get:noop,set:noop}),Object.defineProperty(document.createElement("audio"),"src",{get:noop,set:noop}),Object.defineProperty(document.createElement("video"),"innerHTML",{get:noop,set:noop}),Object.defineProperty(document.createElement("audio"),"innerHTML",{get:noop,set:noop})}catch(e){return!1}return!0},Html5.supportsNativeTextTracks=function(){return IS_ANY_SAFARI||IS_IOS&&IS_CHROME},Html5.supportsNativeVideoTracks=function(){return!(!Html5.TEST_VID||!Html5.TEST_VID.videoTracks)},Html5.supportsNativeAudioTracks=function(){return!(!Html5.TEST_VID||!Html5.TEST_VID.audioTracks)},Html5.Events=["loadstart","suspend","abort","error","emptied","stalled","loadedmetadata","loadeddata","canplay","canplaythrough","playing","waiting","seeking","seeked","ended","durationchange","timeupdate","progress","play","pause","ratechange","resize","volumechange"],[["featuresVolumeControl","canControlVolume"],["featuresMuteControl","canMuteVolume"],["featuresPlaybackRate","canControlPlaybackRate"],["featuresSourceset","canOverrideAttributes"],["featuresNativeTextTracks","supportsNativeTextTracks"],["featuresNativeVideoTracks","supportsNativeVideoTracks"],["featuresNativeAudioTracks","supportsNativeAudioTracks"]].forEach((function(_ref){var key=_ref[0],fn=_ref[1];defineLazyProperty(Html5.prototype,key,(function(){return Html5[fn]()}),!0)})),Html5.prototype.movingMediaElementInDOM=!IS_IOS,Html5.prototype.featuresFullscreenResize=!0,Html5.prototype.featuresProgressEvents=!0,Html5.prototype.featuresTimeupdateEvents=!0,Html5.patchCanPlayType=function(){ANDROID_VERSION>=4&&!IS_FIREFOX&&!IS_CHROME&&(canPlayType=Html5.TEST_VID&&Html5.TEST_VID.constructor.prototype.canPlayType,Html5.TEST_VID.constructor.prototype.canPlayType=function(type){return type&&/^application\/(?:x-|vnd\.apple\.)mpegurl/i.test(type)?"maybe":canPlayType.call(this,type)})},Html5.unpatchCanPlayType=function(){var r=Html5.TEST_VID.constructor.prototype.canPlayType;return canPlayType&&(Html5.TEST_VID.constructor.prototype.canPlayType=canPlayType),r},Html5.patchCanPlayType(),Html5.disposeMediaElement=function(el){if(el){for(el.parentNode&&el.parentNode.removeChild(el);el.hasChildNodes();)el.removeChild(el.firstChild);el.removeAttribute("src"),"function"==typeof el.load&&function(){try{el.load()}catch(e){}}()}},Html5.resetMediaElement=function(el){if(el){for(var sources=el.querySelectorAll("source"),i=sources.length;i--;)el.removeChild(sources[i]);el.removeAttribute("src"),"function"==typeof el.load&&function(){try{el.load()}catch(e){}}()}},["muted","defaultMuted","autoplay","controls","loop","playsinline"].forEach((function(prop){Html5.prototype[prop]=function(){return this.el_[prop]||this.el_.hasAttribute(prop)}})),["muted","defaultMuted","autoplay","loop","playsinline"].forEach((function(prop){Html5.prototype["set"+toTitleCase$1(prop)]=function(v){this.el_[prop]=v,v?this.el_.setAttribute(prop,prop):this.el_.removeAttribute(prop)}})),["paused","currentTime","buffered","volume","poster","preload","error","seeking","seekable","ended","playbackRate","defaultPlaybackRate","disablePictureInPicture","played","networkState","readyState","videoWidth","videoHeight","crossOrigin"].forEach((function(prop){Html5.prototype[prop]=function(){return this.el_[prop]}})),["volume","src","poster","preload","playbackRate","defaultPlaybackRate","disablePictureInPicture","crossOrigin"].forEach((function(prop){Html5.prototype["set"+toTitleCase$1(prop)]=function(v){this.el_[prop]=v}})),["pause","load","play"].forEach((function(prop){Html5.prototype[prop]=function(){return this.el_[prop]()}})),Tech.withSourceHandlers(Html5),Html5.nativeSourceHandler={},Html5.nativeSourceHandler.canPlayType=function(type){try{return Html5.TEST_VID.canPlayType(type)}catch(e){return""}},Html5.nativeSourceHandler.canHandleSource=function(source,options){if(source.type)return Html5.nativeSourceHandler.canPlayType(source.type);if(source.src){var ext=getFileExtension(source.src);return Html5.nativeSourceHandler.canPlayType("video/"+ext)}return""},Html5.nativeSourceHandler.handleSource=function(source,tech,options){tech.setSrc(source.src)},Html5.nativeSourceHandler.dispose=function(){},Html5.registerSourceHandler(Html5.nativeSourceHandler),Tech.registerTech("Html5",Html5);var TECH_EVENTS_RETRIGGER=["progress","abort","suspend","emptied","stalled","loadedmetadata","loadeddata","timeupdate","resize","volumechange","texttrackchange"],TECH_EVENTS_QUEUE={canplay:"CanPlay",canplaythrough:"CanPlayThrough",playing:"Playing",seeked:"Seeked"},BREAKPOINT_ORDER=["tiny","xsmall","small","medium","large","xlarge","huge"],BREAKPOINT_CLASSES={};BREAKPOINT_ORDER.forEach((function(k){var v="x"===k.charAt(0)?"x-"+k.substring(1):k;BREAKPOINT_CLASSES[k]="vjs-layout-"+v}));var DEFAULT_BREAKPOINTS={tiny:210,xsmall:320,small:425,medium:768,large:1440,xlarge:2560,huge:1/0},Player=function(_Component){function Player(tag,options,ready){var _this;if(tag.id=tag.id||options.id||"vjs_video_"+newGUID(),(options=assign(Player.getTagSettings(tag),options)).initChildren=!1,options.createEl=!1,options.evented=!1,options.reportTouchActivity=!1,!options.language)if("function"==typeof tag.closest){var closest=tag.closest("[lang]");closest&&closest.getAttribute&&(options.language=closest.getAttribute("lang"))}else for(var element=tag;element&&1===element.nodeType;){if(getAttributes(element).hasOwnProperty("lang")){options.language=element.getAttribute("lang");break}element=element.parentNode}if((_this=_Component.call(this,null,options,ready)||this).boundDocumentFullscreenChange_=function(e){return _this.documentFullscreenChange_(e)},_this.boundFullWindowOnEscKey_=function(e){return _this.fullWindowOnEscKey(e)},_this.boundUpdateStyleEl_=function(e){return _this.updateStyleEl_(e)},_this.boundApplyInitTime_=function(e){return _this.applyInitTime_(e)},_this.boundUpdateCurrentBreakpoint_=function(e){return _this.updateCurrentBreakpoint_(e)},_this.boundHandleTechClick_=function(e){return _this.handleTechClick_(e)},_this.boundHandleTechDoubleClick_=function(e){return _this.handleTechDoubleClick_(e)},_this.boundHandleTechTouchStart_=function(e){return _this.handleTechTouchStart_(e)},_this.boundHandleTechTouchMove_=function(e){return _this.handleTechTouchMove_(e)},_this.boundHandleTechTouchEnd_=function(e){return _this.handleTechTouchEnd_(e)},_this.boundHandleTechTap_=function(e){return _this.handleTechTap_(e)},_this.isFullscreen_=!1,_this.log=createLogger(_this.id_),_this.fsApi_=FullscreenApi,_this.isPosterFromTech_=!1,_this.queuedCallbacks_=[],_this.isReady_=!1,_this.hasStarted_=!1,_this.userActive_=!1,_this.debugEnabled_=!1,!_this.options_||!_this.options_.techOrder||!_this.options_.techOrder.length)throw new Error("No techOrder specified. Did you overwrite videojs.options instead of just changing the properties you want to override?");if(_this.tag=tag,_this.tagAttributes=tag&&getAttributes(tag),_this.language(_this.options_.language),options.languages){var languagesToLower={};Object.getOwnPropertyNames(options.languages).forEach((function(name){languagesToLower[name.toLowerCase()]=options.languages[name]})),_this.languages_=languagesToLower}else _this.languages_=Player.prototype.options_.languages;_this.resetCache_(),_this.poster_=options.poster||"",_this.controls_=!!options.controls,tag.controls=!1,tag.removeAttribute("controls"),_this.changingSrc_=!1,_this.playCallbacks_=[],_this.playTerminatedQueue_=[],tag.hasAttribute("autoplay")?_this.autoplay(!0):_this.autoplay(_this.options_.autoplay),options.plugins&&Object.keys(options.plugins).forEach((function(name){if("function"!=typeof _this[name])throw new Error('plugin "'+name+'" does not exist')})),_this.scrubbing_=!1,_this.el_=_this.createEl(),evented(assertThisInitialized(_this),{eventBusKey:"el_"}),_this.fsApi_.requestFullscreen&&(on(document,_this.fsApi_.fullscreenchange,_this.boundDocumentFullscreenChange_),_this.on(_this.fsApi_.fullscreenchange,_this.boundDocumentFullscreenChange_)),_this.fluid_&&_this.on(["playerreset","resize"],_this.boundUpdateStyleEl_);var playerOptionsCopy=mergeOptions$3(_this.options_);options.plugins&&Object.keys(options.plugins).forEach((function(name){_this[name](options.plugins[name])})),options.debug&&_this.debug(!0),_this.options_.playerOptions=playerOptionsCopy,_this.middleware_=[],_this.playbackRates(options.playbackRates),_this.initChildren(),_this.isAudio("audio"===tag.nodeName.toLowerCase()),_this.controls()?_this.addClass("vjs-controls-enabled"):_this.addClass("vjs-controls-disabled"),_this.el_.setAttribute("role","region"),_this.isAudio()?_this.el_.setAttribute("aria-label",_this.localize("Audio Player")):_this.el_.setAttribute("aria-label",_this.localize("Video Player")),_this.isAudio()&&_this.addClass("vjs-audio"),_this.flexNotSupported_()&&_this.addClass("vjs-no-flex"),TOUCH_ENABLED&&_this.addClass("vjs-touch-enabled"),IS_IOS||_this.addClass("vjs-workinghover"),Player.players[_this.id_]=assertThisInitialized(_this);var majorVersion="7.17.0".split(".")[0];return _this.addClass("vjs-v"+majorVersion),_this.userActive(!0),_this.reportUserActivity(),_this.one("play",(function(e){return _this.listenForUserActivity_(e)})),_this.on("stageclick",(function(e){return _this.handleStageClick_(e)})),_this.on("keydown",(function(e){return _this.handleKeyDown(e)})),_this.on("languagechange",(function(e){return _this.handleLanguagechange(e)})),_this.breakpoints(_this.options_.breakpoints),_this.responsive(_this.options_.responsive),_this}inheritsLoose(Player,_Component);var _proto=Player.prototype;return _proto.dispose=function(){var _this2=this;this.trigger("dispose"),this.off("dispose"),off(document,this.fsApi_.fullscreenchange,this.boundDocumentFullscreenChange_),off(document,"keydown",this.boundFullWindowOnEscKey_),this.styleEl_&&this.styleEl_.parentNode&&(this.styleEl_.parentNode.removeChild(this.styleEl_),this.styleEl_=null),Player.players[this.id_]=null,this.tag&&this.tag.player&&(this.tag.player=null),this.el_&&this.el_.player&&(this.el_.player=null),this.tech_&&(this.tech_.dispose(),this.isPosterFromTech_=!1,this.poster_=""),this.playerElIngest_&&(this.playerElIngest_=null),this.tag&&(this.tag=null),middlewareInstances[this.id()]=null,ALL.names.forEach((function(name){var props=ALL[name],list=_this2[props.getterName]();list&&list.off&&list.off()})),_Component.prototype.dispose.call(this)},_proto.createEl=function(){var el,tag=this.tag,playerElIngest=this.playerElIngest_=tag.parentNode&&tag.parentNode.hasAttribute&&tag.parentNode.hasAttribute("data-vjs-player"),divEmbed="video-js"===this.tag.tagName.toLowerCase();playerElIngest?el=this.el_=tag.parentNode:divEmbed||(el=this.el_=_Component.prototype.createEl.call(this,"div"));var attrs=getAttributes(tag);if(divEmbed){for(el=this.el_=tag,tag=this.tag=document.createElement("video");el.children.length;)tag.appendChild(el.firstChild);hasClass(el,"video-js")||addClass(el,"video-js"),el.appendChild(tag),playerElIngest=this.playerElIngest_=el,Object.keys(el).forEach((function(k){try{tag[k]=el[k]}catch(e){}}))}if(tag.setAttribute("tabindex","-1"),attrs.tabindex="-1",(IE_VERSION||IS_CHROME&&IS_WINDOWS)&&(tag.setAttribute("role","application"),attrs.role="application"),tag.removeAttribute("width"),tag.removeAttribute("height"),"width"in attrs&&delete attrs.width,"height"in attrs&&delete attrs.height,Object.getOwnPropertyNames(attrs).forEach((function(attr){divEmbed&&"class"===attr||el.setAttribute(attr,attrs[attr]),divEmbed&&tag.setAttribute(attr,attrs[attr])})),tag.playerId=tag.id,tag.id+="_html5_api",tag.className="vjs-tech",tag.player=el.player=this,this.addClass("vjs-paused"),!0!==window.VIDEOJS_NO_DYNAMIC_STYLE){this.styleEl_=createStyleElement("vjs-styles-dimensions");var defaultsStyleEl=$(".vjs-styles-defaults"),head=$("head");head.insertBefore(this.styleEl_,defaultsStyleEl?defaultsStyleEl.nextSibling:head.firstChild)}this.fill_=!1,this.fluid_=!1,this.width(this.options_.width),this.height(this.options_.height),this.fill(this.options_.fill),this.fluid(this.options_.fluid),this.aspectRatio(this.options_.aspectRatio),this.crossOrigin(this.options_.crossOrigin||this.options_.crossorigin);for(var links=tag.getElementsByTagName("a"),i=0;i<links.length;i++){var linkEl=links.item(i);addClass(linkEl,"vjs-hidden"),linkEl.setAttribute("hidden","hidden")}return tag.initNetworkState_=tag.networkState,tag.parentNode&&!playerElIngest&&tag.parentNode.insertBefore(el,tag),prependTo(tag,el),this.children_.unshift(tag),this.el_.setAttribute("lang",this.language_),this.el_.setAttribute("translate","no"),this.el_=el,el},_proto.crossOrigin=function(value){if(!value)return this.techGet_("crossOrigin");"anonymous"===value||"use-credentials"===value?this.techCall_("setCrossOrigin",value):log$1.warn('crossOrigin must be "anonymous" or "use-credentials", given "'+value+'"')},_proto.width=function(value){return this.dimension("width",value)},_proto.height=function(value){return this.dimension("height",value)},_proto.dimension=function(_dimension,value){var privDimension=_dimension+"_";if(void 0===value)return this[privDimension]||0;if(""===value||"auto"===value)return this[privDimension]=void 0,void this.updateStyleEl_();var parsedVal=parseFloat(value);isNaN(parsedVal)?log$1.error('Improper value "'+value+'" supplied for for '+_dimension):(this[privDimension]=parsedVal,this.updateStyleEl_())},_proto.fluid=function(bool){var target,callback,_this3=this;if(void 0===bool)return!!this.fluid_;this.fluid_=!!bool,isEvented(this)&&this.off(["playerreset","resize"],this.boundUpdateStyleEl_),bool?(this.addClass("vjs-fluid"),this.fill(!1),callback=function(){_this3.on(["playerreset","resize"],_this3.boundUpdateStyleEl_)},isEvented(target=this)?callback():(target.eventedCallbacks||(target.eventedCallbacks=[]),target.eventedCallbacks.push(callback))):this.removeClass("vjs-fluid"),this.updateStyleEl_()},_proto.fill=function(bool){if(void 0===bool)return!!this.fill_;this.fill_=!!bool,bool?(this.addClass("vjs-fill"),this.fluid(!1)):this.removeClass("vjs-fill")},_proto.aspectRatio=function(ratio){if(void 0===ratio)return this.aspectRatio_;if(!/^\d+\:\d+$/.test(ratio))throw new Error("Improper value supplied for aspect ratio. The format should be width:height, for example 16:9.");this.aspectRatio_=ratio,this.fluid(!0),this.updateStyleEl_()},_proto.updateStyleEl_=function(){if(!0!==window.VIDEOJS_NO_DYNAMIC_STYLE){var width,height,idClass,ratioParts=(void 0!==this.aspectRatio_&&"auto"!==this.aspectRatio_?this.aspectRatio_:this.videoWidth()>0?this.videoWidth()+":"+this.videoHeight():"16:9").split(":"),ratioMultiplier=ratioParts[1]/ratioParts[0];width=void 0!==this.width_?this.width_:void 0!==this.height_?this.height_/ratioMultiplier:this.videoWidth()||300,height=void 0!==this.height_?this.height_:width*ratioMultiplier,idClass=/^[^a-zA-Z]/.test(this.id())?"dimensions-"+this.id():this.id()+"-dimensions",this.addClass(idClass),setTextContent(this.styleEl_,"\n      ."+idClass+" {\n        width: "+width+"px;\n        height: "+height+"px;\n      }\n\n      ."+idClass+".vjs-fluid {\n        padding-top: "+100*ratioMultiplier+"%;\n      }\n    ")}else{var _width="number"==typeof this.width_?this.width_:this.options_.width,_height="number"==typeof this.height_?this.height_:this.options_.height,techEl=this.tech_&&this.tech_.el();techEl&&(_width>=0&&(techEl.width=_width),_height>=0&&(techEl.height=_height))}},_proto.loadTech_=function(techName,source){var _this4=this;this.tech_&&this.unloadTech_();var titleTechName=toTitleCase$1(techName),camelTechName=techName.charAt(0).toLowerCase()+techName.slice(1);"Html5"!==titleTechName&&this.tag&&(Tech.getTech("Html5").disposeMediaElement(this.tag),this.tag.player=null,this.tag=null),this.techName_=titleTechName,this.isReady_=!1;var autoplay=this.autoplay();("string"==typeof this.autoplay()||!0===this.autoplay()&&this.options_.normalizeAutoplay)&&(autoplay=!1);var techOptions={source:source,autoplay:autoplay,nativeControlsForTouch:this.options_.nativeControlsForTouch,playerId:this.id(),techId:this.id()+"_"+camelTechName+"_api",playsinline:this.options_.playsinline,preload:this.options_.preload,loop:this.options_.loop,disablePictureInPicture:this.options_.disablePictureInPicture,muted:this.options_.muted,poster:this.poster(),language:this.language(),playerElIngest:this.playerElIngest_||!1,"vtt.js":this.options_["vtt.js"],canOverridePoster:!!this.options_.techCanOverridePoster,enableSourceset:this.options_.enableSourceset,Promise:this.options_.Promise};ALL.names.forEach((function(name){var props=ALL[name];techOptions[props.getterName]=_this4[props.privateName]})),assign(techOptions,this.options_[titleTechName]),assign(techOptions,this.options_[camelTechName]),assign(techOptions,this.options_[techName.toLowerCase()]),this.tag&&(techOptions.tag=this.tag),source&&source.src===this.cache_.src&&this.cache_.currentTime>0&&(techOptions.startTime=this.cache_.currentTime);var TechClass=Tech.getTech(techName);if(!TechClass)throw new Error("No Tech named '"+titleTechName+"' exists! '"+titleTechName+"' should be registered using videojs.registerTech()'");this.tech_=new TechClass(techOptions),this.tech_.ready(bind(this,this.handleTechReady_),!0),textTrackConverter_jsonToTextTracks(this.textTracksJson_||[],this.tech_),TECH_EVENTS_RETRIGGER.forEach((function(event){_this4.on(_this4.tech_,event,(function(e){return _this4["handleTech"+toTitleCase$1(event)+"_"](e)}))})),Object.keys(TECH_EVENTS_QUEUE).forEach((function(event){_this4.on(_this4.tech_,event,(function(eventObj){0===_this4.tech_.playbackRate()&&_this4.tech_.seeking()?_this4.queuedCallbacks_.push({callback:_this4["handleTech"+TECH_EVENTS_QUEUE[event]+"_"].bind(_this4),event:eventObj}):_this4["handleTech"+TECH_EVENTS_QUEUE[event]+"_"](eventObj)}))})),this.on(this.tech_,"loadstart",(function(e){return _this4.handleTechLoadStart_(e)})),this.on(this.tech_,"sourceset",(function(e){return _this4.handleTechSourceset_(e)})),this.on(this.tech_,"waiting",(function(e){return _this4.handleTechWaiting_(e)})),this.on(this.tech_,"ended",(function(e){return _this4.handleTechEnded_(e)})),this.on(this.tech_,"seeking",(function(e){return _this4.handleTechSeeking_(e)})),this.on(this.tech_,"play",(function(e){return _this4.handleTechPlay_(e)})),this.on(this.tech_,"firstplay",(function(e){return _this4.handleTechFirstPlay_(e)})),this.on(this.tech_,"pause",(function(e){return _this4.handleTechPause_(e)})),this.on(this.tech_,"durationchange",(function(e){return _this4.handleTechDurationChange_(e)})),this.on(this.tech_,"fullscreenchange",(function(e,data){return _this4.handleTechFullscreenChange_(e,data)})),this.on(this.tech_,"fullscreenerror",(function(e,err){return _this4.handleTechFullscreenError_(e,err)})),this.on(this.tech_,"enterpictureinpicture",(function(e){return _this4.handleTechEnterPictureInPicture_(e)})),this.on(this.tech_,"leavepictureinpicture",(function(e){return _this4.handleTechLeavePictureInPicture_(e)})),this.on(this.tech_,"error",(function(e){return _this4.handleTechError_(e)})),this.on(this.tech_,"posterchange",(function(e){return _this4.handleTechPosterChange_(e)})),this.on(this.tech_,"textdata",(function(e){return _this4.handleTechTextData_(e)})),this.on(this.tech_,"ratechange",(function(e){return _this4.handleTechRateChange_(e)})),this.on(this.tech_,"loadedmetadata",this.boundUpdateStyleEl_),this.usingNativeControls(this.techGet_("controls")),this.controls()&&!this.usingNativeControls()&&this.addTechControlsListeners_(),this.tech_.el().parentNode===this.el()||"Html5"===titleTechName&&this.tag||prependTo(this.tech_.el(),this.el()),this.tag&&(this.tag.player=null,this.tag=null)},_proto.unloadTech_=function(){var _this5=this;ALL.names.forEach((function(name){var props=ALL[name];_this5[props.privateName]=_this5[props.getterName]()})),this.textTracksJson_=textTrackConverter_textTracksToJson(this.tech_),this.isReady_=!1,this.tech_.dispose(),this.tech_=!1,this.isPosterFromTech_&&(this.poster_="",this.trigger("posterchange")),this.isPosterFromTech_=!1},_proto.tech=function(safety){return void 0===safety&&log$1.warn("Using the tech directly can be dangerous. I hope you know what you're doing.\nSee https://github.com/videojs/video.js/issues/2617 for more info.\n"),this.tech_},_proto.addTechControlsListeners_=function(){this.removeTechControlsListeners_(),this.on(this.tech_,"click",this.boundHandleTechClick_),this.on(this.tech_,"dblclick",this.boundHandleTechDoubleClick_),this.on(this.tech_,"touchstart",this.boundHandleTechTouchStart_),this.on(this.tech_,"touchmove",this.boundHandleTechTouchMove_),this.on(this.tech_,"touchend",this.boundHandleTechTouchEnd_),this.on(this.tech_,"tap",this.boundHandleTechTap_)},_proto.removeTechControlsListeners_=function(){this.off(this.tech_,"tap",this.boundHandleTechTap_),this.off(this.tech_,"touchstart",this.boundHandleTechTouchStart_),this.off(this.tech_,"touchmove",this.boundHandleTechTouchMove_),this.off(this.tech_,"touchend",this.boundHandleTechTouchEnd_),this.off(this.tech_,"click",this.boundHandleTechClick_),this.off(this.tech_,"dblclick",this.boundHandleTechDoubleClick_)},_proto.handleTechReady_=function(){this.triggerReady(),this.cache_.volume&&this.techCall_("setVolume",this.cache_.volume),this.handleTechPosterChange_(),this.handleTechDurationChange_()},_proto.handleTechLoadStart_=function(){this.removeClass("vjs-ended"),this.removeClass("vjs-seeking"),this.error(null),this.handleTechDurationChange_(),this.paused()?(this.hasStarted(!1),this.trigger("loadstart")):(this.trigger("loadstart"),this.trigger("firstplay")),this.manualAutoplay_(!0===this.autoplay()&&this.options_.normalizeAutoplay?"play":this.autoplay())},_proto.manualAutoplay_=function(type){var _this6=this;if(this.tech_&&"string"==typeof type){var promise,resolveMuted=function(){var previouslyMuted=_this6.muted();_this6.muted(!0);var restoreMuted=function(){_this6.muted(previouslyMuted)};_this6.playTerminatedQueue_.push(restoreMuted);var mutedPromise=_this6.play();if(isPromise(mutedPromise))return mutedPromise.catch((function(err){throw restoreMuted(),new Error("Rejection at manualAutoplay. Restoring muted value. "+(err||""))}))};if("any"!==type||this.muted()?promise="muted"!==type||this.muted()?this.play():resolveMuted():isPromise(promise=this.play())&&(promise=promise.catch(resolveMuted)),isPromise(promise))return promise.then((function(){_this6.trigger({type:"autoplay-success",autoplay:type})})).catch((function(){_this6.trigger({type:"autoplay-failure",autoplay:type})}))}},_proto.updateSourceCaches_=function(srcObj){void 0===srcObj&&(srcObj="");var src=srcObj,type="";"string"!=typeof src&&(src=srcObj.src,type=srcObj.type),this.cache_.source=this.cache_.source||{},this.cache_.sources=this.cache_.sources||[],src&&!type&&(type=function(player,src){if(!src)return"";if(player.cache_.source.src===src&&player.cache_.source.type)return player.cache_.source.type;var matchingSources=player.cache_.sources.filter((function(s){return s.src===src}));if(matchingSources.length)return matchingSources[0].type;for(var sources=player.$$("source"),i=0;i<sources.length;i++){var s=sources[i];if(s.type&&s.src&&s.src===src)return s.type}return getMimetype(src)}(this,src)),this.cache_.source=mergeOptions$3({},srcObj,{src:src,type:type});for(var matchingSources=this.cache_.sources.filter((function(s){return s.src&&s.src===src})),sourceElSources=[],sourceEls=this.$$("source"),matchingSourceEls=[],i=0;i<sourceEls.length;i++){var sourceObj=getAttributes(sourceEls[i]);sourceElSources.push(sourceObj),sourceObj.src&&sourceObj.src===src&&matchingSourceEls.push(sourceObj.src)}matchingSourceEls.length&&!matchingSources.length?this.cache_.sources=sourceElSources:matchingSources.length||(this.cache_.sources=[this.cache_.source]),this.cache_.src=src},_proto.handleTechSourceset_=function(event){var _this7=this;if(!this.changingSrc_){var updateSourceCaches=function(src){return _this7.updateSourceCaches_(src)},playerSrc=this.currentSource().src,eventSrc=event.src;playerSrc&&!/^blob:/.test(playerSrc)&&/^blob:/.test(eventSrc)&&(!this.lastSource_||this.lastSource_.tech!==eventSrc&&this.lastSource_.player!==playerSrc)&&(updateSourceCaches=function(){}),updateSourceCaches(eventSrc),event.src||this.tech_.any(["sourceset","loadstart"],(function(e){if("sourceset"!==e.type){var techSrc=_this7.techGet("currentSrc");_this7.lastSource_.tech=techSrc,_this7.updateSourceCaches_(techSrc)}}))}this.lastSource_={player:this.currentSource().src,tech:event.src},this.trigger({src:event.src,type:"sourceset"})},_proto.hasStarted=function(request){if(void 0===request)return this.hasStarted_;request!==this.hasStarted_&&(this.hasStarted_=request,this.hasStarted_?(this.addClass("vjs-has-started"),this.trigger("firstplay")):this.removeClass("vjs-has-started"))},_proto.handleTechPlay_=function(){this.removeClass("vjs-ended"),this.removeClass("vjs-paused"),this.addClass("vjs-playing"),this.hasStarted(!0),this.trigger("play")},_proto.handleTechRateChange_=function(){this.tech_.playbackRate()>0&&0===this.cache_.lastPlaybackRate&&(this.queuedCallbacks_.forEach((function(queued){return queued.callback(queued.event)})),this.queuedCallbacks_=[]),this.cache_.lastPlaybackRate=this.tech_.playbackRate(),this.trigger("ratechange")},_proto.handleTechWaiting_=function(){var _this8=this;this.addClass("vjs-waiting"),this.trigger("waiting");var timeWhenWaiting=this.currentTime();this.on("timeupdate",(function timeUpdateListener(){timeWhenWaiting!==_this8.currentTime()&&(_this8.removeClass("vjs-waiting"),_this8.off("timeupdate",timeUpdateListener))}))},_proto.handleTechCanPlay_=function(){this.removeClass("vjs-waiting"),this.trigger("canplay")},_proto.handleTechCanPlayThrough_=function(){this.removeClass("vjs-waiting"),this.trigger("canplaythrough")},_proto.handleTechPlaying_=function(){this.removeClass("vjs-waiting"),this.trigger("playing")},_proto.handleTechSeeking_=function(){this.addClass("vjs-seeking"),this.trigger("seeking")},_proto.handleTechSeeked_=function(){this.removeClass("vjs-seeking"),this.removeClass("vjs-ended"),this.trigger("seeked")},_proto.handleTechFirstPlay_=function(){this.options_.starttime&&(log$1.warn("Passing the `starttime` option to the player will be deprecated in 6.0"),this.currentTime(this.options_.starttime)),this.addClass("vjs-has-started"),this.trigger("firstplay")},_proto.handleTechPause_=function(){this.removeClass("vjs-playing"),this.addClass("vjs-paused"),this.trigger("pause")},_proto.handleTechEnded_=function(){this.addClass("vjs-ended"),this.removeClass("vjs-waiting"),this.options_.loop?(this.currentTime(0),this.play()):this.paused()||this.pause(),this.trigger("ended")},_proto.handleTechDurationChange_=function(){this.duration(this.techGet_("duration"))},_proto.handleTechClick_=function(event){this.controls_&&(void 0!==this.options_&&void 0!==this.options_.userActions&&void 0!==this.options_.userActions.click&&!1===this.options_.userActions.click||(void 0!==this.options_&&void 0!==this.options_.userActions&&"function"==typeof this.options_.userActions.click?this.options_.userActions.click.call(this,event):this.paused()?silencePromise(this.play()):this.pause()))},_proto.handleTechDoubleClick_=function(event){this.controls_&&(Array.prototype.some.call(this.$$(".vjs-control-bar, .vjs-modal-dialog"),(function(el){return el.contains(event.target)}))||void 0!==this.options_&&void 0!==this.options_.userActions&&void 0!==this.options_.userActions.doubleClick&&!1===this.options_.userActions.doubleClick||(void 0!==this.options_&&void 0!==this.options_.userActions&&"function"==typeof this.options_.userActions.doubleClick?this.options_.userActions.doubleClick.call(this,event):this.isFullscreen()?this.exitFullscreen():this.requestFullscreen()))},_proto.handleTechTap_=function(){this.userActive(!this.userActive())},_proto.handleTechTouchStart_=function(){this.userWasActive=this.userActive()},_proto.handleTechTouchMove_=function(){this.userWasActive&&this.reportUserActivity()},_proto.handleTechTouchEnd_=function(event){event.cancelable&&event.preventDefault()},_proto.handleStageClick_=function(){this.reportUserActivity()},_proto.toggleFullscreenClass_=function(){this.isFullscreen()?this.addClass("vjs-fullscreen"):this.removeClass("vjs-fullscreen")},_proto.documentFullscreenChange_=function(e){var targetPlayer=e.target.player;if(!targetPlayer||targetPlayer===this){var el=this.el(),isFs=document[this.fsApi_.fullscreenElement]===el;!isFs&&el.matches?isFs=el.matches(":"+this.fsApi_.fullscreen):!isFs&&el.msMatchesSelector&&(isFs=el.msMatchesSelector(":"+this.fsApi_.fullscreen)),this.isFullscreen(isFs)}},_proto.handleTechFullscreenChange_=function(event,data){data&&(data.nativeIOSFullscreen&&this.toggleClass("vjs-ios-native-fs"),this.isFullscreen(data.isFullscreen))},_proto.handleTechFullscreenError_=function(event,err){this.trigger("fullscreenerror",err)},_proto.togglePictureInPictureClass_=function(){this.isInPictureInPicture()?this.addClass("vjs-picture-in-picture"):this.removeClass("vjs-picture-in-picture")},_proto.handleTechEnterPictureInPicture_=function(event){this.isInPictureInPicture(!0)},_proto.handleTechLeavePictureInPicture_=function(event){this.isInPictureInPicture(!1)},_proto.handleTechError_=function(){var error=this.tech_.error();this.error(error)},_proto.handleTechTextData_=function(){var data=null;arguments.length>1&&(data=arguments[1]),this.trigger("textdata",data)},_proto.getCache=function(){return this.cache_},_proto.resetCache_=function(){this.cache_={currentTime:0,initTime:0,inactivityTimeout:this.options_.inactivityTimeout,duration:NaN,lastVolume:1,lastPlaybackRate:this.defaultPlaybackRate(),media:null,src:"",source:{},sources:[],playbackRates:[],volume:1}},_proto.techCall_=function(method,arg){this.ready((function(){if(method in allowedSetters)return function(middleware,tech,method,arg){return tech[method](middleware.reduce(middlewareIterator(method),arg))}(this.middleware_,this.tech_,method,arg);if(method in allowedMediators)return mediate(this.middleware_,this.tech_,method,arg);try{this.tech_&&this.tech_[method](arg)}catch(e){throw log$1(e),e}}),!0)},_proto.techGet_=function(method){if(this.tech_&&this.tech_.isReady_){if(method in allowedGetters)return function(middleware,tech,method){return middleware.reduceRight(middlewareIterator(method),tech[method]())}(this.middleware_,this.tech_,method);if(method in allowedMediators)return mediate(this.middleware_,this.tech_,method);try{return this.tech_[method]()}catch(e){if(void 0===this.tech_[method])throw log$1("Video.js: "+method+" method not defined for "+this.techName_+" playback technology.",e),e;if("TypeError"===e.name)throw log$1("Video.js: "+method+" unavailable on "+this.techName_+" playback technology element.",e),this.tech_.isReady_=!1,e;throw log$1(e),e}}},_proto.play=function(){var _this9=this,PromiseClass=this.options_.Promise||window.Promise;return PromiseClass?new PromiseClass((function(resolve){_this9.play_(resolve)})):this.play_()},_proto.play_=function(callback){var _this10=this;void 0===callback&&(callback=silencePromise),this.playCallbacks_.push(callback);var isSrcReady=Boolean(!this.changingSrc_&&(this.src()||this.currentSrc()));if(this.waitToPlay_&&(this.off(["ready","loadstart"],this.waitToPlay_),this.waitToPlay_=null),!this.isReady_||!isSrcReady)return this.waitToPlay_=function(e){_this10.play_()},this.one(["ready","loadstart"],this.waitToPlay_),void(isSrcReady||!IS_ANY_SAFARI&&!IS_IOS||this.load());var val=this.techGet_("play");null===val?this.runPlayTerminatedQueue_():this.runPlayCallbacks_(val)},_proto.runPlayTerminatedQueue_=function(){var queue=this.playTerminatedQueue_.slice(0);this.playTerminatedQueue_=[],queue.forEach((function(q){q()}))},_proto.runPlayCallbacks_=function(val){var callbacks=this.playCallbacks_.slice(0);this.playCallbacks_=[],this.playTerminatedQueue_=[],callbacks.forEach((function(cb){cb(val)}))},_proto.pause=function(){this.techCall_("pause")},_proto.paused=function(){return!1!==this.techGet_("paused")},_proto.played=function(){return this.techGet_("played")||createTimeRanges(0,0)},_proto.scrubbing=function(isScrubbing){if(void 0===isScrubbing)return this.scrubbing_;this.scrubbing_=!!isScrubbing,this.techCall_("setScrubbing",this.scrubbing_),isScrubbing?this.addClass("vjs-scrubbing"):this.removeClass("vjs-scrubbing")},_proto.currentTime=function(seconds){return void 0!==seconds?(seconds<0&&(seconds=0),this.isReady_&&!this.changingSrc_&&this.tech_&&this.tech_.isReady_?(this.techCall_("setCurrentTime",seconds),void(this.cache_.initTime=0)):(this.cache_.initTime=seconds,this.off("canplay",this.boundApplyInitTime_),void this.one("canplay",this.boundApplyInitTime_))):(this.cache_.currentTime=this.techGet_("currentTime")||0,this.cache_.currentTime)},_proto.applyInitTime_=function(){this.currentTime(this.cache_.initTime)},_proto.duration=function(seconds){if(void 0===seconds)return void 0!==this.cache_.duration?this.cache_.duration:NaN;(seconds=parseFloat(seconds))<0&&(seconds=1/0),seconds!==this.cache_.duration&&(this.cache_.duration=seconds,seconds===1/0?this.addClass("vjs-live"):this.removeClass("vjs-live"),isNaN(seconds)||this.trigger("durationchange"))},_proto.remainingTime=function(){return this.duration()-this.currentTime()},_proto.remainingTimeDisplay=function(){return Math.floor(this.duration())-Math.floor(this.currentTime())},_proto.buffered=function(){var buffered=this.techGet_("buffered");return buffered&&buffered.length||(buffered=createTimeRanges(0,0)),buffered},_proto.bufferedPercent=function(){return bufferedPercent(this.buffered(),this.duration())},_proto.bufferedEnd=function(){var buffered=this.buffered(),duration=this.duration(),end=buffered.end(buffered.length-1);return end>duration&&(end=duration),end},_proto.volume=function(percentAsDecimal){var vol;return void 0!==percentAsDecimal?(vol=Math.max(0,Math.min(1,parseFloat(percentAsDecimal))),this.cache_.volume=vol,this.techCall_("setVolume",vol),void(vol>0&&this.lastVolume_(vol))):(vol=parseFloat(this.techGet_("volume")),isNaN(vol)?1:vol)},_proto.muted=function(_muted){if(void 0===_muted)return this.techGet_("muted")||!1;this.techCall_("setMuted",_muted)},_proto.defaultMuted=function(_defaultMuted){return void 0!==_defaultMuted?this.techCall_("setDefaultMuted",_defaultMuted):this.techGet_("defaultMuted")||!1},_proto.lastVolume_=function(percentAsDecimal){if(void 0===percentAsDecimal||0===percentAsDecimal)return this.cache_.lastVolume;this.cache_.lastVolume=percentAsDecimal},_proto.supportsFullScreen=function(){return this.techGet_("supportsFullScreen")||!1},_proto.isFullscreen=function(isFS){if(void 0!==isFS){var oldValue=this.isFullscreen_;return this.isFullscreen_=Boolean(isFS),this.isFullscreen_!==oldValue&&this.fsApi_.prefixed&&this.trigger("fullscreenchange"),void this.toggleFullscreenClass_()}return this.isFullscreen_},_proto.requestFullscreen=function(fullscreenOptions){var PromiseClass=this.options_.Promise||window.Promise;if(PromiseClass){var self=this;return new PromiseClass((function(resolve,reject){function offHandler(){self.off("fullscreenerror",errorHandler),self.off("fullscreenchange",changeHandler)}function changeHandler(){offHandler(),resolve()}function errorHandler(e,err){offHandler(),reject(err)}self.one("fullscreenchange",changeHandler),self.one("fullscreenerror",errorHandler);var promise=self.requestFullscreenHelper_(fullscreenOptions);promise&&(promise.then(offHandler,offHandler),promise.then(resolve,reject))}))}return this.requestFullscreenHelper_()},_proto.requestFullscreenHelper_=function(fullscreenOptions){var fsOptions,_this11=this;if(this.fsApi_.prefixed||(fsOptions=this.options_.fullscreen&&this.options_.fullscreen.options||{},void 0!==fullscreenOptions&&(fsOptions=fullscreenOptions)),this.fsApi_.requestFullscreen){var promise=this.el_[this.fsApi_.requestFullscreen](fsOptions);return promise&&promise.then((function(){return _this11.isFullscreen(!0)}),(function(){return _this11.isFullscreen(!1)})),promise}this.tech_.supportsFullScreen()&&!0==!this.options_.preferFullWindow?this.techCall_("enterFullScreen"):this.enterFullWindow()},_proto.exitFullscreen=function(){var PromiseClass=this.options_.Promise||window.Promise;if(PromiseClass){var self=this;return new PromiseClass((function(resolve,reject){function offHandler(){self.off("fullscreenerror",errorHandler),self.off("fullscreenchange",changeHandler)}function changeHandler(){offHandler(),resolve()}function errorHandler(e,err){offHandler(),reject(err)}self.one("fullscreenchange",changeHandler),self.one("fullscreenerror",errorHandler);var promise=self.exitFullscreenHelper_();promise&&(promise.then(offHandler,offHandler),promise.then(resolve,reject))}))}return this.exitFullscreenHelper_()},_proto.exitFullscreenHelper_=function(){var _this12=this;if(this.fsApi_.requestFullscreen){var promise=document[this.fsApi_.exitFullscreen]();return promise&&silencePromise(promise.then((function(){return _this12.isFullscreen(!1)}))),promise}this.tech_.supportsFullScreen()&&!0==!this.options_.preferFullWindow?this.techCall_("exitFullScreen"):this.exitFullWindow()},_proto.enterFullWindow=function(){this.isFullscreen(!0),this.isFullWindow=!0,this.docOrigOverflow=document.documentElement.style.overflow,on(document,"keydown",this.boundFullWindowOnEscKey_),document.documentElement.style.overflow="hidden",addClass(document.body,"vjs-full-window"),this.trigger("enterFullWindow")},_proto.fullWindowOnEscKey=function(event){keycode.isEventKey(event,"Esc")&&!0===this.isFullscreen()&&(this.isFullWindow?this.exitFullWindow():this.exitFullscreen())},_proto.exitFullWindow=function(){this.isFullscreen(!1),this.isFullWindow=!1,off(document,"keydown",this.boundFullWindowOnEscKey_),document.documentElement.style.overflow=this.docOrigOverflow,removeClass(document.body,"vjs-full-window"),this.trigger("exitFullWindow")},_proto.disablePictureInPicture=function(value){if(void 0===value)return this.techGet_("disablePictureInPicture");this.techCall_("setDisablePictureInPicture",value),this.options_.disablePictureInPicture=value,this.trigger("disablepictureinpicturechanged")},_proto.isInPictureInPicture=function(isPiP){return void 0!==isPiP?(this.isInPictureInPicture_=!!isPiP,void this.togglePictureInPictureClass_()):!!this.isInPictureInPicture_},_proto.requestPictureInPicture=function(){if("pictureInPictureEnabled"in document&&!1===this.disablePictureInPicture())return this.techGet_("requestPictureInPicture")},_proto.exitPictureInPicture=function(){if("pictureInPictureEnabled"in document)return document.exitPictureInPicture()},_proto.handleKeyDown=function(event){var userActions=this.options_.userActions;if(userActions&&userActions.hotkeys){(function(el){var tagName=el.tagName.toLowerCase();if(el.isContentEditable)return!0;if("input"===tagName)return-1===["button","checkbox","hidden","radio","reset","submit"].indexOf(el.type);return-1!==["textarea"].indexOf(tagName)})(this.el_.ownerDocument.activeElement)||("function"==typeof userActions.hotkeys?userActions.hotkeys.call(this,event):this.handleHotkeys(event))}},_proto.handleHotkeys=function(event){var hotkeys=this.options_.userActions?this.options_.userActions.hotkeys:{},_hotkeys$fullscreenKe=hotkeys.fullscreenKey,fullscreenKey=void 0===_hotkeys$fullscreenKe?function(keydownEvent){return keycode.isEventKey(keydownEvent,"f")}:_hotkeys$fullscreenKe,_hotkeys$muteKey=hotkeys.muteKey,muteKey=void 0===_hotkeys$muteKey?function(keydownEvent){return keycode.isEventKey(keydownEvent,"m")}:_hotkeys$muteKey,_hotkeys$playPauseKey=hotkeys.playPauseKey,playPauseKey=void 0===_hotkeys$playPauseKey?function(keydownEvent){return keycode.isEventKey(keydownEvent,"k")||keycode.isEventKey(keydownEvent,"Space")}:_hotkeys$playPauseKey;if(fullscreenKey.call(this,event)){event.preventDefault(),event.stopPropagation();var FSToggle=Component$1.getComponent("FullscreenToggle");!1!==document[this.fsApi_.fullscreenEnabled]&&FSToggle.prototype.handleClick.call(this,event)}else if(muteKey.call(this,event)){event.preventDefault(),event.stopPropagation(),Component$1.getComponent("MuteToggle").prototype.handleClick.call(this,event)}else if(playPauseKey.call(this,event)){event.preventDefault(),event.stopPropagation(),Component$1.getComponent("PlayToggle").prototype.handleClick.call(this,event)}},_proto.canPlayType=function(type){for(var can,i=0,j=this.options_.techOrder;i<j.length;i++){var techName=j[i],tech=Tech.getTech(techName);if(tech||(tech=Component$1.getComponent(techName)),tech){if(tech.isSupported()&&(can=tech.canPlayType(type)))return can}else log$1.error('The "'+techName+'" tech is undefined. Skipped browser support check for that tech.')}return""},_proto.selectSource=function(sources){var fn,_this13=this,techs=this.options_.techOrder.map((function(techName){return[techName,Tech.getTech(techName)]})).filter((function(_ref){var techName=_ref[0],tech=_ref[1];return tech?tech.isSupported():(log$1.error('The "'+techName+'" tech is undefined. Skipped browser support check for that tech.'),!1)})),findFirstPassingTechSourcePair=function(outerArray,innerArray,tester){var found;return outerArray.some((function(outerChoice){return innerArray.some((function(innerChoice){if(found=tester(outerChoice,innerChoice))return!0}))})),found},finder=function(_ref2,source){var techName=_ref2[0];if(_ref2[1].canPlaySource(source,_this13.options_[techName.toLowerCase()]))return{source:source,tech:techName}};return(this.options_.sourceOrder?findFirstPassingTechSourcePair(sources,techs,(fn=finder,function(a,b){return fn(b,a)})):findFirstPassingTechSourcePair(techs,sources,finder))||!1},_proto.handleSrc_=function(source,isRetry){var _this14=this;if(void 0===source)return this.cache_.src||"";this.resetRetryOnError_&&this.resetRetryOnError_();var sources=filterSource(source);if(sources.length){if(this.changingSrc_=!0,isRetry||(this.cache_.sources=sources),this.updateSourceCaches_(sources[0]),setSource(this,sources[0],(function(middlewareSource,mws){var middleware,tech;if(_this14.middleware_=mws,isRetry||(_this14.cache_.sources=sources),_this14.updateSourceCaches_(middlewareSource),_this14.src_(middlewareSource))return sources.length>1?_this14.handleSrc_(sources.slice(1)):(_this14.changingSrc_=!1,_this14.setTimeout((function(){this.error({code:4,message:this.localize(this.options_.notSupportedMessage)})}),0),void _this14.triggerReady());middleware=mws,tech=_this14.tech_,middleware.forEach((function(mw){return mw.setTech&&mw.setTech(tech)}))})),this.options_.retryOnError&&sources.length>1){var retry=function(){_this14.error(null),_this14.handleSrc_(sources.slice(1),!0)},stopListeningForErrors=function(){_this14.off("error",retry)};this.one("error",retry),this.one("playing",stopListeningForErrors),this.resetRetryOnError_=function(){_this14.off("error",retry),_this14.off("playing",stopListeningForErrors)}}}else this.setTimeout((function(){this.error({code:4,message:this.localize(this.options_.notSupportedMessage)})}),0)},_proto.src=function(source){return this.handleSrc_(source,!1)},_proto.src_=function(source){var str1,str2,_this15=this,sourceTech=this.selectSource([source]);return!sourceTech||(str1=sourceTech.tech,str2=this.techName_,toTitleCase$1(str1)!==toTitleCase$1(str2)?(this.changingSrc_=!0,this.loadTech_(sourceTech.tech,sourceTech.source),this.tech_.ready((function(){_this15.changingSrc_=!1})),!1):(this.ready((function(){this.tech_.constructor.prototype.hasOwnProperty("setSource")?this.techCall_("setSource",source):this.techCall_("src",source.src),this.changingSrc_=!1}),!0),!1))},_proto.load=function(){this.techCall_("load")},_proto.reset=function(){var _this16=this,PromiseClass=this.options_.Promise||window.Promise;this.paused()||!PromiseClass?this.doReset_():silencePromise(this.play().then((function(){return _this16.doReset_()})))},_proto.doReset_=function(){this.tech_&&this.tech_.clearTracks("text"),this.resetCache_(),this.poster(""),this.loadTech_(this.options_.techOrder[0],null),this.techCall_("reset"),this.resetControlBarUI_(),isEvented(this)&&this.trigger("playerreset")},_proto.resetControlBarUI_=function(){this.resetProgressBar_(),this.resetPlaybackRate_(),this.resetVolumeBar_()},_proto.resetProgressBar_=function(){this.currentTime(0);var _this$controlBar=this.controlBar,durationDisplay=_this$controlBar.durationDisplay,remainingTimeDisplay=_this$controlBar.remainingTimeDisplay;durationDisplay&&durationDisplay.updateContent(),remainingTimeDisplay&&remainingTimeDisplay.updateContent()},_proto.resetPlaybackRate_=function(){this.playbackRate(this.defaultPlaybackRate()),this.handleTechRateChange_()},_proto.resetVolumeBar_=function(){this.volume(1),this.trigger("volumechange")},_proto.currentSources=function(){var source=this.currentSource(),sources=[];return 0!==Object.keys(source).length&&sources.push(source),this.cache_.sources||sources},_proto.currentSource=function(){return this.cache_.source||{}},_proto.currentSrc=function(){return this.currentSource()&&this.currentSource().src||""},_proto.currentType=function(){return this.currentSource()&&this.currentSource().type||""},_proto.preload=function(value){return void 0!==value?(this.techCall_("setPreload",value),void(this.options_.preload=value)):this.techGet_("preload")},_proto.autoplay=function(value){if(void 0===value)return this.options_.autoplay||!1;var techAutoplay;"string"==typeof value&&/(any|play|muted)/.test(value)||!0===value&&this.options_.normalizeAutoplay?(this.options_.autoplay=value,this.manualAutoplay_("string"==typeof value?value:"play"),techAutoplay=!1):this.options_.autoplay=!!value,techAutoplay=void 0===techAutoplay?this.options_.autoplay:techAutoplay,this.tech_&&this.techCall_("setAutoplay",techAutoplay)},_proto.playsinline=function(value){return void 0!==value?(this.techCall_("setPlaysinline",value),this.options_.playsinline=value,this):this.techGet_("playsinline")},_proto.loop=function(value){return void 0!==value?(this.techCall_("setLoop",value),void(this.options_.loop=value)):this.techGet_("loop")},_proto.poster=function(src){if(void 0===src)return this.poster_;src||(src=""),src!==this.poster_&&(this.poster_=src,this.techCall_("setPoster",src),this.isPosterFromTech_=!1,this.trigger("posterchange"))},_proto.handleTechPosterChange_=function(){if((!this.poster_||this.options_.techCanOverridePoster)&&this.tech_&&this.tech_.poster){var newPoster=this.tech_.poster()||"";newPoster!==this.poster_&&(this.poster_=newPoster,this.isPosterFromTech_=!0,this.trigger("posterchange"))}},_proto.controls=function(bool){if(void 0===bool)return!!this.controls_;bool=!!bool,this.controls_!==bool&&(this.controls_=bool,this.usingNativeControls()&&this.techCall_("setControls",bool),this.controls_?(this.removeClass("vjs-controls-disabled"),this.addClass("vjs-controls-enabled"),this.trigger("controlsenabled"),this.usingNativeControls()||this.addTechControlsListeners_()):(this.removeClass("vjs-controls-enabled"),this.addClass("vjs-controls-disabled"),this.trigger("controlsdisabled"),this.usingNativeControls()||this.removeTechControlsListeners_()))},_proto.usingNativeControls=function(bool){if(void 0===bool)return!!this.usingNativeControls_;bool=!!bool,this.usingNativeControls_!==bool&&(this.usingNativeControls_=bool,this.usingNativeControls_?(this.addClass("vjs-using-native-controls"),this.trigger("usingnativecontrols")):(this.removeClass("vjs-using-native-controls"),this.trigger("usingcustomcontrols")))},_proto.error=function(err){var _this17=this;if(void 0===err)return this.error_||null;if(hooks("beforeerror").forEach((function(hookFunction){var newErr=hookFunction(_this17,err);isObject$1(newErr)&&!Array.isArray(newErr)||"string"==typeof newErr||"number"==typeof newErr||null===newErr?err=newErr:_this17.log.error("please return a value that MediaError expects in beforeerror hooks")})),this.options_.suppressNotSupportedError&&err&&4===err.code){var triggerSuppressedError=function(){this.error(err)};return this.options_.suppressNotSupportedError=!1,this.any(["click","touchstart"],triggerSuppressedError),void this.one("loadstart",(function(){this.off(["click","touchstart"],triggerSuppressedError)}))}if(null===err)return this.error_=err,this.removeClass("vjs-error"),void(this.errorDisplay&&this.errorDisplay.close());this.error_=new MediaError(err),this.addClass("vjs-error"),log$1.error("(CODE:"+this.error_.code+" "+MediaError.errorTypes[this.error_.code]+")",this.error_.message,this.error_),this.trigger("error"),hooks("error").forEach((function(hookFunction){return hookFunction(_this17,_this17.error_)}))},_proto.reportUserActivity=function(event){this.userActivity_=!0},_proto.userActive=function(bool){if(void 0===bool)return this.userActive_;if((bool=!!bool)!==this.userActive_){if(this.userActive_=bool,this.userActive_)return this.userActivity_=!0,this.removeClass("vjs-user-inactive"),this.addClass("vjs-user-active"),void this.trigger("useractive");this.tech_&&this.tech_.one("mousemove",(function(e){e.stopPropagation(),e.preventDefault()})),this.userActivity_=!1,this.removeClass("vjs-user-active"),this.addClass("vjs-user-inactive"),this.trigger("userinactive")}},_proto.listenForUserActivity_=function(){var mouseInProgress,lastMoveX,lastMoveY,handleActivity=bind(this,this.reportUserActivity),handleMouseUpAndMouseLeave=function(event){handleActivity(),this.clearInterval(mouseInProgress)};this.on("mousedown",(function(){handleActivity(),this.clearInterval(mouseInProgress),mouseInProgress=this.setInterval(handleActivity,250)})),this.on("mousemove",(function(e){e.screenX===lastMoveX&&e.screenY===lastMoveY||(lastMoveX=e.screenX,lastMoveY=e.screenY,handleActivity())})),this.on("mouseup",handleMouseUpAndMouseLeave),this.on("mouseleave",handleMouseUpAndMouseLeave);var inactivityTimeout,controlBar=this.getChild("controlBar");!controlBar||IS_IOS||IS_ANDROID||(controlBar.on("mouseenter",(function(event){0!==this.player().options_.inactivityTimeout&&(this.player().cache_.inactivityTimeout=this.player().options_.inactivityTimeout),this.player().options_.inactivityTimeout=0})),controlBar.on("mouseleave",(function(event){this.player().options_.inactivityTimeout=this.player().cache_.inactivityTimeout}))),this.on("keydown",handleActivity),this.on("keyup",handleActivity),this.setInterval((function(){if(this.userActivity_){this.userActivity_=!1,this.userActive(!0),this.clearTimeout(inactivityTimeout);var timeout=this.options_.inactivityTimeout;timeout<=0||(inactivityTimeout=this.setTimeout((function(){this.userActivity_||this.userActive(!1)}),timeout))}}),250)},_proto.playbackRate=function(rate){if(void 0===rate)return this.tech_&&this.tech_.featuresPlaybackRate?this.cache_.lastPlaybackRate||this.techGet_("playbackRate"):1;this.techCall_("setPlaybackRate",rate)},_proto.defaultPlaybackRate=function(rate){return void 0!==rate?this.techCall_("setDefaultPlaybackRate",rate):this.tech_&&this.tech_.featuresPlaybackRate?this.techGet_("defaultPlaybackRate"):1},_proto.isAudio=function(bool){if(void 0===bool)return!!this.isAudio_;this.isAudio_=!!bool},_proto.addTextTrack=function(kind,label,language){if(this.tech_)return this.tech_.addTextTrack(kind,label,language)},_proto.addRemoteTextTrack=function(options,manualCleanup){if(this.tech_)return this.tech_.addRemoteTextTrack(options,manualCleanup)},_proto.removeRemoteTextTrack=function(obj){void 0===obj&&(obj={});var track=obj.track;if(track||(track=obj),this.tech_)return this.tech_.removeRemoteTextTrack(track)},_proto.getVideoPlaybackQuality=function(){return this.techGet_("getVideoPlaybackQuality")},_proto.videoWidth=function(){return this.tech_&&this.tech_.videoWidth&&this.tech_.videoWidth()||0},_proto.videoHeight=function(){return this.tech_&&this.tech_.videoHeight&&this.tech_.videoHeight()||0},_proto.language=function(code){if(void 0===code)return this.language_;this.language_!==String(code).toLowerCase()&&(this.language_=String(code).toLowerCase(),isEvented(this)&&this.trigger("languagechange"))},_proto.languages=function(){return mergeOptions$3(Player.prototype.options_.languages,this.languages_)},_proto.toJSON=function(){var options=mergeOptions$3(this.options_),tracks=options.tracks;options.tracks=[];for(var i=0;i<tracks.length;i++){var track=tracks[i];(track=mergeOptions$3(track)).player=void 0,options.tracks[i]=track}return options},_proto.createModal=function(content,options){var _this18=this;(options=options||{}).content=content||"";var modal=new ModalDialog(this,options);return this.addChild(modal),modal.on("dispose",(function(){_this18.removeChild(modal)})),modal.open(),modal},_proto.updateCurrentBreakpoint_=function(){if(this.responsive())for(var currentBreakpoint=this.currentBreakpoint(),currentWidth=this.currentWidth(),i=0;i<BREAKPOINT_ORDER.length;i++){var candidateBreakpoint=BREAKPOINT_ORDER[i];if(currentWidth<=this.breakpoints_[candidateBreakpoint]){if(currentBreakpoint===candidateBreakpoint)return;currentBreakpoint&&this.removeClass(BREAKPOINT_CLASSES[currentBreakpoint]),this.addClass(BREAKPOINT_CLASSES[candidateBreakpoint]),this.breakpoint_=candidateBreakpoint;break}}},_proto.removeCurrentBreakpoint_=function(){var className=this.currentBreakpointClass();this.breakpoint_="",className&&this.removeClass(className)},_proto.breakpoints=function(_breakpoints){return void 0===_breakpoints||(this.breakpoint_="",this.breakpoints_=assign({},DEFAULT_BREAKPOINTS,_breakpoints),this.updateCurrentBreakpoint_()),assign(this.breakpoints_)},_proto.responsive=function(value){return void 0===value?this.responsive_:(value=Boolean(value))!==this.responsive_?(this.responsive_=value,value?(this.on("playerresize",this.boundUpdateCurrentBreakpoint_),this.updateCurrentBreakpoint_()):(this.off("playerresize",this.boundUpdateCurrentBreakpoint_),this.removeCurrentBreakpoint_()),value):void 0},_proto.currentBreakpoint=function(){return this.breakpoint_},_proto.currentBreakpointClass=function(){return BREAKPOINT_CLASSES[this.breakpoint_]||""},_proto.loadMedia=function(media,ready){var _this19=this;if(media&&"object"==typeof media){this.reset(),this.cache_.media=mergeOptions$3(media);var _this$cache_$media=this.cache_.media,artwork=_this$cache_$media.artwork,poster=_this$cache_$media.poster,src=_this$cache_$media.src,textTracks=_this$cache_$media.textTracks;!artwork&&poster&&(this.cache_.media.artwork=[{src:poster,type:getMimetype(poster)}]),src&&this.src(src),poster&&this.poster(poster),Array.isArray(textTracks)&&textTracks.forEach((function(tt){return _this19.addRemoteTextTrack(tt,!1)})),this.ready(ready)}},_proto.getMedia=function(){if(!this.cache_.media){var poster=this.poster(),media={src:this.currentSources(),textTracks:Array.prototype.map.call(this.remoteTextTracks(),(function(tt){return{kind:tt.kind,label:tt.label,language:tt.language,src:tt.src}}))};return poster&&(media.poster=poster,media.artwork=[{src:media.poster,type:getMimetype(media.poster)}]),media}return mergeOptions$3(this.cache_.media)},Player.getTagSettings=function(tag){var baseOptions={sources:[],tracks:[]},tagOptions=getAttributes(tag),dataSetup=tagOptions["data-setup"];if(hasClass(tag,"vjs-fill")&&(tagOptions.fill=!0),hasClass(tag,"vjs-fluid")&&(tagOptions.fluid=!0),null!==dataSetup){var _safeParseTuple=tuple(dataSetup||"{}"),err=_safeParseTuple[0],data=_safeParseTuple[1];err&&log$1.error(err),assign(tagOptions,data)}if(assign(baseOptions,tagOptions),tag.hasChildNodes())for(var children=tag.childNodes,i=0,j=children.length;i<j;i++){var child=children[i],childName=child.nodeName.toLowerCase();"source"===childName?baseOptions.sources.push(getAttributes(child)):"track"===childName&&baseOptions.tracks.push(getAttributes(child))}return baseOptions},_proto.flexNotSupported_=function(){var elem=document.createElement("i");return!("flexBasis"in elem.style||"webkitFlexBasis"in elem.style||"mozFlexBasis"in elem.style||"msFlexBasis"in elem.style||"msFlexOrder"in elem.style)},_proto.debug=function(enabled){if(void 0===enabled)return this.debugEnabled_;enabled?(this.trigger("debugon"),this.previousLogLevel_=this.log.level,this.log.level("debug"),this.debugEnabled_=!0):(this.trigger("debugoff"),this.log.level(this.previousLogLevel_),this.previousLogLevel_=void 0,this.debugEnabled_=!1)},_proto.playbackRates=function(newRates){if(void 0===newRates)return this.cache_.playbackRates;Array.isArray(newRates)&&newRates.every((function(rate){return"number"==typeof rate}))&&(this.cache_.playbackRates=newRates,this.trigger("playbackrateschange"))},Player}(Component$1);ALL.names.forEach((function(name){var props=ALL[name];Player.prototype[props.getterName]=function(){return this.tech_?this.tech_[props.getterName]():(this[props.privateName]=this[props.privateName]||new props.ListClass,this[props.privateName])}})),Player.prototype.crossorigin=Player.prototype.crossOrigin,Player.players={};var navigator=window.navigator;Player.prototype.options_={techOrder:Tech.defaultTechOrder_,html5:{},inactivityTimeout:2e3,playbackRates:[],liveui:!1,children:["mediaLoader","posterImage","textTrackDisplay","loadingSpinner","bigPlayButton","liveTracker","controlBar","errorDisplay","textTrackSettings","resizeManager"],language:navigator&&(navigator.languages&&navigator.languages[0]||navigator.userLanguage||navigator.language)||"en",languages:{},notSupportedMessage:"No compatible source was found for this media.",normalizeAutoplay:!1,fullscreen:{options:{navigationUI:"hide"}},breakpoints:{},responsive:!1},["ended","seeking","seekable","networkState","readyState"].forEach((function(fn){Player.prototype[fn]=function(){return this.techGet_(fn)}})),TECH_EVENTS_RETRIGGER.forEach((function(event){Player.prototype["handleTech"+toTitleCase$1(event)+"_"]=function(){return this.trigger(event)}})),Component$1.registerComponent("Player",Player);var setPrototypeOf=createCommonjsModule((function(module){function _setPrototypeOf(o,p){return module.exports=_setPrototypeOf=Object.setPrototypeOf||function(o,p){return o.__proto__=p,o},_setPrototypeOf(o,p)}module.exports=_setPrototypeOf}));var isNativeReflectConstruct=function(){if("undefined"==typeof Reflect||!Reflect.construct)return!1;if(Reflect.construct.sham)return!1;if("function"==typeof Proxy)return!0;try{return Date.prototype.toString.call(Reflect.construct(Date,[],(function(){}))),!0}catch(e){return!1}},construct=createCommonjsModule((function(module){function _construct(Parent,args,Class){return isNativeReflectConstruct()?module.exports=_construct=Reflect.construct:module.exports=_construct=function(Parent,args,Class){var a=[null];a.push.apply(a,args);var instance=new(Function.bind.apply(Parent,a));return Class&&setPrototypeOf(instance,Class.prototype),instance},_construct.apply(null,arguments)}module.exports=_construct})),pluginStorage={},pluginExists=function(name){return pluginStorage.hasOwnProperty(name)},getPlugin=function(name){return pluginExists(name)?pluginStorage[name]:void 0},markPluginAsActive=function(player,name){player.activePlugins_=player.activePlugins_||{},player.activePlugins_[name]=!0},triggerSetupEvent=function(player,hash,before){var eventName=(before?"before":"")+"pluginsetup";player.trigger(eventName,hash),player.trigger(eventName+":"+hash.name,hash)},createPluginFactory=function(name,PluginSubClass){return PluginSubClass.prototype.name=name,function(){triggerSetupEvent(this,{name:name,plugin:PluginSubClass,instance:null},!0);for(var _len=arguments.length,args=new Array(_len),_key=0;_key<_len;_key++)args[_key]=arguments[_key];var instance=construct(PluginSubClass,[this].concat(args));return this[name]=function(){return instance},triggerSetupEvent(this,instance.getEventHash()),instance}},Plugin=function(){function Plugin(player){if(this.constructor===Plugin)throw new Error("Plugin must be sub-classed; not directly instantiated.");this.player=player,this.log||(this.log=this.player.log.createLogger(this.name)),evented(this),delete this.trigger,stateful(this,this.constructor.defaultState),markPluginAsActive(player,this.name),this.dispose=this.dispose.bind(this),player.on("dispose",this.dispose)}var _proto=Plugin.prototype;return _proto.version=function(){return this.constructor.VERSION},_proto.getEventHash=function(hash){return void 0===hash&&(hash={}),hash.name=this.name,hash.plugin=this.constructor,hash.instance=this,hash},_proto.trigger=function(event,hash){return void 0===hash&&(hash={}),trigger(this.eventBusEl_,event,this.getEventHash(hash))},_proto.handleStateChanged=function(e){},_proto.dispose=function(){var name=this.name,player=this.player;this.trigger("dispose"),this.off(),player.off("dispose",this.dispose),player.activePlugins_[name]=!1,this.player=this.state=null,player[name]=createPluginFactory(name,pluginStorage[name])},Plugin.isBasic=function(plugin){var p="string"==typeof plugin?getPlugin(plugin):plugin;return"function"==typeof p&&!Plugin.prototype.isPrototypeOf(p.prototype)},Plugin.registerPlugin=function(name,plugin){if("string"!=typeof name)throw new Error('Illegal plugin name, "'+name+'", must be a string, was '+typeof name+".");if(pluginExists(name))log$1.warn('A plugin named "'+name+'" already exists. You may want to avoid re-registering plugins!');else if(Player.prototype.hasOwnProperty(name))throw new Error('Illegal plugin name, "'+name+'", cannot share a name with an existing player method!');if("function"!=typeof plugin)throw new Error('Illegal plugin for "'+name+'", must be a function, was '+typeof plugin+".");return pluginStorage[name]=plugin,"plugin"!==name&&(Plugin.isBasic(plugin)?Player.prototype[name]=function(name,plugin){var basicPluginWrapper=function(){triggerSetupEvent(this,{name:name,plugin:plugin,instance:null},!0);var instance=plugin.apply(this,arguments);return markPluginAsActive(this,name),triggerSetupEvent(this,{name:name,plugin:plugin,instance:instance}),instance};return Object.keys(plugin).forEach((function(prop){basicPluginWrapper[prop]=plugin[prop]})),basicPluginWrapper}(name,plugin):Player.prototype[name]=createPluginFactory(name,plugin)),plugin},Plugin.deregisterPlugin=function(name){if("plugin"===name)throw new Error("Cannot de-register base plugin.");pluginExists(name)&&(delete pluginStorage[name],delete Player.prototype[name])},Plugin.getPlugins=function(names){var result;return void 0===names&&(names=Object.keys(pluginStorage)),names.forEach((function(name){var plugin=getPlugin(name);plugin&&((result=result||{})[name]=plugin)})),result},Plugin.getPluginVersion=function(name){var plugin=getPlugin(name);return plugin&&plugin.VERSION||""},Plugin}();Plugin.getPlugin=getPlugin,Plugin.BASE_PLUGIN_NAME="plugin",Plugin.registerPlugin("plugin",Plugin),Player.prototype.usingPlugin=function(name){return!!this.activePlugins_&&!0===this.activePlugins_[name]},Player.prototype.hasPlugin=function(name){return!!pluginExists(name)};var inherits=function(subClass,superClass){if("function"!=typeof superClass&&null!==superClass)throw new TypeError("Super expression must either be null or a function");subClass.prototype=Object.create(superClass&&superClass.prototype,{constructor:{value:subClass,writable:!0,configurable:!0}}),superClass&&setPrototypeOf(subClass,superClass)},normalizeId=function(id){return 0===id.indexOf("#")?id.slice(1):id};function videojs(id,options,ready){var player=videojs.getPlayer(id);if(player)return options&&log$1.warn('Player "'+id+'" is already initialised. Options will not be applied.'),ready&&player.ready(ready),player;var el="string"==typeof id?$("#"+normalizeId(id)):id;if(!isEl(el))throw new TypeError("The element or ID supplied is not valid. (videojs)");el.ownerDocument.defaultView&&el.ownerDocument.body.contains(el)||log$1.warn("The element supplied is not included in the DOM"),options=options||{},hooks("beforesetup").forEach((function(hookFunction){var opts=hookFunction(el,mergeOptions$3(options));isObject$1(opts)&&!Array.isArray(opts)?options=mergeOptions$3(options,opts):log$1.error("please return an object in beforesetup hooks")}));var PlayerComponent=Component$1.getComponent("Player");return player=new PlayerComponent(el,options,ready),hooks("setup").forEach((function(hookFunction){return hookFunction(player)})),player}if(videojs.hooks_=hooks_,videojs.hooks=hooks,videojs.hook=function(type,fn){hooks(type,fn)},videojs.hookOnce=function(type,fn){hooks(type,[].concat(fn).map((function(original){return function wrapper(){return removeHook(type,wrapper),original.apply(void 0,arguments)}})))},videojs.removeHook=removeHook,!0!==window.VIDEOJS_NO_DYNAMIC_STYLE&&isReal()){var style=$(".vjs-styles-defaults");if(!style){style=createStyleElement("vjs-styles-defaults");var head=$("head");head&&head.insertBefore(style,head.firstChild),setTextContent(style,"\n      .video-js {\n        width: 300px;\n        height: 150px;\n      }\n\n      .vjs-fluid {\n        padding-top: 56.25%\n      }\n    ")}}autoSetupTimeout(1,videojs),videojs.VERSION="7.17.0",videojs.options=Player.prototype.options_,videojs.getPlayers=function(){return Player.players},videojs.getPlayer=function(id){var tag,players=Player.players;if("string"==typeof id){var nId=normalizeId(id),player=players[nId];if(player)return player;tag=$("#"+nId)}else tag=id;if(isEl(tag)){var _tag=tag,_player=_tag.player,playerId=_tag.playerId;if(_player||players[playerId])return _player||players[playerId]}},videojs.getAllPlayers=function(){return Object.keys(Player.players).map((function(k){return Player.players[k]})).filter(Boolean)},videojs.players=Player.players,videojs.getComponent=Component$1.getComponent,videojs.registerComponent=function(name,comp){Tech.isTech(comp)&&log$1.warn("The "+name+" tech was registered as a component. It should instead be registered using videojs.registerTech(name, tech)"),Component$1.registerComponent.call(Component$1,name,comp)},videojs.getTech=Tech.getTech,videojs.registerTech=Tech.registerTech,videojs.use=function(type,middleware){middlewares[type]=middlewares[type]||[],middlewares[type].push(middleware)},Object.defineProperty(videojs,"middleware",{value:{},writeable:!1,enumerable:!0}),Object.defineProperty(videojs.middleware,"TERMINATOR",{value:TERMINATOR,writeable:!1,enumerable:!0}),videojs.browser=browser,videojs.TOUCH_ENABLED=TOUCH_ENABLED,videojs.extend=function(superClass,subClassMethods){void 0===subClassMethods&&(subClassMethods={});var subClass=function(){superClass.apply(this,arguments)},methods={};for(var name in"object"==typeof subClassMethods?(subClassMethods.constructor!==Object.prototype.constructor&&(subClass=subClassMethods.constructor),methods=subClassMethods):"function"==typeof subClassMethods&&(subClass=subClassMethods),inherits(subClass,superClass),superClass&&(subClass.super_=superClass),methods)methods.hasOwnProperty(name)&&(subClass.prototype[name]=methods[name]);return subClass},videojs.mergeOptions=mergeOptions$3,videojs.bind=bind,videojs.registerPlugin=Plugin.registerPlugin,videojs.deregisterPlugin=Plugin.deregisterPlugin,videojs.plugin=function(name,plugin){return log$1.warn("videojs.plugin() is deprecated; use videojs.registerPlugin() instead"),Plugin.registerPlugin(name,plugin)},videojs.getPlugins=Plugin.getPlugins,videojs.getPlugin=Plugin.getPlugin,videojs.getPluginVersion=Plugin.getPluginVersion,videojs.addLanguage=function(code,data){var _mergeOptions;return code=(""+code).toLowerCase(),videojs.options.languages=mergeOptions$3(videojs.options.languages,((_mergeOptions={})[code]=data,_mergeOptions)),videojs.options.languages[code]},videojs.log=log$1,videojs.createLogger=createLogger,videojs.createTimeRange=videojs.createTimeRanges=createTimeRanges,videojs.formatTime=formatTime,videojs.setFormatTime=function(customImplementation){implementation=customImplementation},videojs.resetFormatTime=function(){implementation=defaultImplementation},videojs.parseUrl=parseUrl,videojs.isCrossOrigin=isCrossOrigin,videojs.EventTarget=EventTarget$2,videojs.on=on,videojs.one=one,videojs.off=off,videojs.trigger=trigger,videojs.xhr=lib,videojs.TextTrack=TextTrack,videojs.AudioTrack=AudioTrack,videojs.VideoTrack=VideoTrack,["isEl","isTextNode","createEl","hasClass","addClass","removeClass","toggleClass","setAttributes","getAttributes","emptyEl","appendContent","insertContent"].forEach((function(k){videojs[k]=function(){return log$1.warn("videojs."+k+"() is deprecated; use videojs.dom."+k+"() instead"),Dom[k].apply(null,arguments)}})),videojs.computedStyle=computedStyle,videojs.dom=Dom,videojs.url=Url,videojs.defineLazyProperty=defineLazyProperty,videojs.addLanguage("en",{"Non-Fullscreen":"Exit Fullscreen"});var urlToolkit=createCommonjsModule((function(module,exports){var URL_REGEX,FIRST_SEGMENT_REGEX,SLASH_DOT_REGEX,SLASH_DOT_DOT_REGEX,URLToolkit;URL_REGEX=/^((?:[a-zA-Z0-9+\-.]+:)?)(\/\/[^\/?#]*)?((?:[^\/?#]*\/)*[^;?#]*)?(;[^?#]*)?(\?[^#]*)?(#[^]*)?$/,FIRST_SEGMENT_REGEX=/^([^\/?#]*)([^]*)$/,SLASH_DOT_REGEX=/(?:\/|^)\.(?=\/)/g,SLASH_DOT_DOT_REGEX=/(?:\/|^)\.\.\/(?!\.\.\/)[^\/]*(?=\/)/g,URLToolkit={buildAbsoluteURL:function(baseURL,relativeURL,opts){if(opts=opts||{},baseURL=baseURL.trim(),!(relativeURL=relativeURL.trim())){if(!opts.alwaysNormalize)return baseURL;var basePartsForNormalise=URLToolkit.parseURL(baseURL);if(!basePartsForNormalise)throw new Error("Error trying to parse base URL.");return basePartsForNormalise.path=URLToolkit.normalizePath(basePartsForNormalise.path),URLToolkit.buildURLFromParts(basePartsForNormalise)}var relativeParts=URLToolkit.parseURL(relativeURL);if(!relativeParts)throw new Error("Error trying to parse relative URL.");if(relativeParts.scheme)return opts.alwaysNormalize?(relativeParts.path=URLToolkit.normalizePath(relativeParts.path),URLToolkit.buildURLFromParts(relativeParts)):relativeURL;var baseParts=URLToolkit.parseURL(baseURL);if(!baseParts)throw new Error("Error trying to parse base URL.");if(!baseParts.netLoc&&baseParts.path&&"/"!==baseParts.path[0]){var pathParts=FIRST_SEGMENT_REGEX.exec(baseParts.path);baseParts.netLoc=pathParts[1],baseParts.path=pathParts[2]}baseParts.netLoc&&!baseParts.path&&(baseParts.path="/");var builtParts={scheme:baseParts.scheme,netLoc:relativeParts.netLoc,path:null,params:relativeParts.params,query:relativeParts.query,fragment:relativeParts.fragment};if(!relativeParts.netLoc&&(builtParts.netLoc=baseParts.netLoc,"/"!==relativeParts.path[0]))if(relativeParts.path){var baseURLPath=baseParts.path,newPath=baseURLPath.substring(0,baseURLPath.lastIndexOf("/")+1)+relativeParts.path;builtParts.path=URLToolkit.normalizePath(newPath)}else builtParts.path=baseParts.path,relativeParts.params||(builtParts.params=baseParts.params,relativeParts.query||(builtParts.query=baseParts.query));return null===builtParts.path&&(builtParts.path=opts.alwaysNormalize?URLToolkit.normalizePath(relativeParts.path):relativeParts.path),URLToolkit.buildURLFromParts(builtParts)},parseURL:function(url){var parts=URL_REGEX.exec(url);return parts?{scheme:parts[1]||"",netLoc:parts[2]||"",path:parts[3]||"",params:parts[4]||"",query:parts[5]||"",fragment:parts[6]||""}:null},normalizePath:function(path){for(path=path.split("").reverse().join("").replace(SLASH_DOT_REGEX,"");path.length!==(path=path.replace(SLASH_DOT_DOT_REGEX,"")).length;);return path.split("").reverse().join("")},buildURLFromParts:function(parts){return parts.scheme+parts.netLoc+parts.path+parts.params+parts.query+parts.fragment}},module.exports=URLToolkit})),Stream=function(){function Stream(){this.listeners={}}var _proto=Stream.prototype;return _proto.on=function(type,listener){this.listeners[type]||(this.listeners[type]=[]),this.listeners[type].push(listener)},_proto.off=function(type,listener){if(!this.listeners[type])return!1;var index=this.listeners[type].indexOf(listener);return this.listeners[type]=this.listeners[type].slice(0),this.listeners[type].splice(index,1),index>-1},_proto.trigger=function(type){var callbacks=this.listeners[type];if(callbacks)if(2===arguments.length)for(var length=callbacks.length,i=0;i<length;++i)callbacks[i].call(this,arguments[1]);else for(var args=Array.prototype.slice.call(arguments,1),_length=callbacks.length,_i=0;_i<_length;++_i)callbacks[_i].apply(this,args)},_proto.dispose=function(){this.listeners={}},_proto.pipe=function(destination){this.on("data",(function(data){destination.push(data)}))},Stream}();function decodeB64ToUint8Array(b64Text){for(var s,decodedString=(s=b64Text,window.atob?window.atob(s):Buffer.from(s,"base64").toString("binary")),array=new Uint8Array(decodedString.length),i=0;i<decodedString.length;i++)array[i]=decodedString.charCodeAt(i);return array}
/*! @name m3u8-parser @version 4.7.0 @license Apache-2.0 */var LineStream=function(_Stream){function LineStream(){var _this;return(_this=_Stream.call(this)||this).buffer="",_this}return inheritsLoose(LineStream,_Stream),LineStream.prototype.push=function(data){var nextNewline;for(this.buffer+=data,nextNewline=this.buffer.indexOf("\n");nextNewline>-1;nextNewline=this.buffer.indexOf("\n"))this.trigger("data",this.buffer.substring(0,nextNewline)),this.buffer=this.buffer.substring(nextNewline+1)},LineStream}(Stream),TAB=String.fromCharCode(9),parseByterange=function(byterangeString){var match=/([0-9.]*)?@?([0-9.]*)?/.exec(byterangeString||""),result={};return match[1]&&(result.length=parseInt(match[1],10)),match[2]&&(result.offset=parseInt(match[2],10)),result},parseAttributes$1=function(attributes){for(var attr,attrs=attributes.split(new RegExp('(?:^|,)((?:[^=]*)=(?:"[^"]*"|[^,]*))')),result={},i=attrs.length;i--;)""!==attrs[i]&&((attr=/([^=]*)=(.*)/.exec(attrs[i]).slice(1))[0]=attr[0].replace(/^\s+|\s+$/g,""),attr[1]=attr[1].replace(/^\s+|\s+$/g,""),attr[1]=attr[1].replace(/^['"](.*)['"]$/g,"$1"),result[attr[0]]=attr[1]);return result},ParseStream=function(_Stream){function ParseStream(){var _this;return(_this=_Stream.call(this)||this).customParsers=[],_this.tagMappers=[],_this}inheritsLoose(ParseStream,_Stream);var _proto=ParseStream.prototype;return _proto.push=function(line){var match,event,_this2=this;0!==(line=line.trim()).length&&("#"===line[0]?this.tagMappers.reduce((function(acc,mapper){var mappedLine=mapper(line);return mappedLine===line?acc:acc.concat([mappedLine])}),[line]).forEach((function(newLine){for(var i=0;i<_this2.customParsers.length;i++)if(_this2.customParsers[i].call(_this2,newLine))return;if(0===newLine.indexOf("#EXT"))if(newLine=newLine.replace("\r",""),match=/^#EXTM3U/.exec(newLine))_this2.trigger("data",{type:"tag",tagType:"m3u"});else{if(match=/^#EXTINF:?([0-9\.]*)?,?(.*)?$/.exec(newLine))return event={type:"tag",tagType:"inf"},match[1]&&(event.duration=parseFloat(match[1])),match[2]&&(event.title=match[2]),void _this2.trigger("data",event);if(match=/^#EXT-X-TARGETDURATION:?([0-9.]*)?/.exec(newLine))return event={type:"tag",tagType:"targetduration"},match[1]&&(event.duration=parseInt(match[1],10)),void _this2.trigger("data",event);if(match=/^#EXT-X-VERSION:?([0-9.]*)?/.exec(newLine))return event={type:"tag",tagType:"version"},match[1]&&(event.version=parseInt(match[1],10)),void _this2.trigger("data",event);if(match=/^#EXT-X-MEDIA-SEQUENCE:?(\-?[0-9.]*)?/.exec(newLine))return event={type:"tag",tagType:"media-sequence"},match[1]&&(event.number=parseInt(match[1],10)),void _this2.trigger("data",event);if(match=/^#EXT-X-DISCONTINUITY-SEQUENCE:?(\-?[0-9.]*)?/.exec(newLine))return event={type:"tag",tagType:"discontinuity-sequence"},match[1]&&(event.number=parseInt(match[1],10)),void _this2.trigger("data",event);if(match=/^#EXT-X-PLAYLIST-TYPE:?(.*)?$/.exec(newLine))return event={type:"tag",tagType:"playlist-type"},match[1]&&(event.playlistType=match[1]),void _this2.trigger("data",event);if(match=/^#EXT-X-BYTERANGE:?(.*)?$/.exec(newLine))return event=_extends_1(parseByterange(match[1]),{type:"tag",tagType:"byterange"}),void _this2.trigger("data",event);if(match=/^#EXT-X-ALLOW-CACHE:?(YES|NO)?/.exec(newLine))return event={type:"tag",tagType:"allow-cache"},match[1]&&(event.allowed=!/NO/.test(match[1])),void _this2.trigger("data",event);if(match=/^#EXT-X-MAP:?(.*)$/.exec(newLine)){if(event={type:"tag",tagType:"map"},match[1]){var attributes=parseAttributes$1(match[1]);attributes.URI&&(event.uri=attributes.URI),attributes.BYTERANGE&&(event.byterange=parseByterange(attributes.BYTERANGE))}_this2.trigger("data",event)}else if(match=/^#EXT-X-STREAM-INF:?(.*)$/.exec(newLine)){if(event={type:"tag",tagType:"stream-inf"},match[1]){if(event.attributes=parseAttributes$1(match[1]),event.attributes.RESOLUTION){var split=event.attributes.RESOLUTION.split("x"),resolution={};split[0]&&(resolution.width=parseInt(split[0],10)),split[1]&&(resolution.height=parseInt(split[1],10)),event.attributes.RESOLUTION=resolution}event.attributes.BANDWIDTH&&(event.attributes.BANDWIDTH=parseInt(event.attributes.BANDWIDTH,10)),event.attributes["PROGRAM-ID"]&&(event.attributes["PROGRAM-ID"]=parseInt(event.attributes["PROGRAM-ID"],10))}_this2.trigger("data",event)}else{if(match=/^#EXT-X-MEDIA:?(.*)$/.exec(newLine))return event={type:"tag",tagType:"media"},match[1]&&(event.attributes=parseAttributes$1(match[1])),void _this2.trigger("data",event);if(match=/^#EXT-X-ENDLIST/.exec(newLine))_this2.trigger("data",{type:"tag",tagType:"endlist"});else if(match=/^#EXT-X-DISCONTINUITY/.exec(newLine))_this2.trigger("data",{type:"tag",tagType:"discontinuity"});else{if(match=/^#EXT-X-PROGRAM-DATE-TIME:?(.*)$/.exec(newLine))return event={type:"tag",tagType:"program-date-time"},match[1]&&(event.dateTimeString=match[1],event.dateTimeObject=new Date(match[1])),void _this2.trigger("data",event);if(match=/^#EXT-X-KEY:?(.*)$/.exec(newLine))return event={type:"tag",tagType:"key"},match[1]&&(event.attributes=parseAttributes$1(match[1]),event.attributes.IV&&("0x"===event.attributes.IV.substring(0,2).toLowerCase()&&(event.attributes.IV=event.attributes.IV.substring(2)),event.attributes.IV=event.attributes.IV.match(/.{8}/g),event.attributes.IV[0]=parseInt(event.attributes.IV[0],16),event.attributes.IV[1]=parseInt(event.attributes.IV[1],16),event.attributes.IV[2]=parseInt(event.attributes.IV[2],16),event.attributes.IV[3]=parseInt(event.attributes.IV[3],16),event.attributes.IV=new Uint32Array(event.attributes.IV))),void _this2.trigger("data",event);if(match=/^#EXT-X-START:?(.*)$/.exec(newLine))return event={type:"tag",tagType:"start"},match[1]&&(event.attributes=parseAttributes$1(match[1]),event.attributes["TIME-OFFSET"]=parseFloat(event.attributes["TIME-OFFSET"]),event.attributes.PRECISE=/YES/.test(event.attributes.PRECISE)),void _this2.trigger("data",event);if(match=/^#EXT-X-CUE-OUT-CONT:?(.*)?$/.exec(newLine))return event={type:"tag",tagType:"cue-out-cont"},match[1]?event.data=match[1]:event.data="",void _this2.trigger("data",event);if(match=/^#EXT-X-CUE-OUT:?(.*)?$/.exec(newLine))return event={type:"tag",tagType:"cue-out"},match[1]?event.data=match[1]:event.data="",void _this2.trigger("data",event);if(match=/^#EXT-X-CUE-IN:?(.*)?$/.exec(newLine))return event={type:"tag",tagType:"cue-in"},match[1]?event.data=match[1]:event.data="",void _this2.trigger("data",event);if((match=/^#EXT-X-SKIP:(.*)$/.exec(newLine))&&match[1])return(event={type:"tag",tagType:"skip"}).attributes=parseAttributes$1(match[1]),event.attributes.hasOwnProperty("SKIPPED-SEGMENTS")&&(event.attributes["SKIPPED-SEGMENTS"]=parseInt(event.attributes["SKIPPED-SEGMENTS"],10)),event.attributes.hasOwnProperty("RECENTLY-REMOVED-DATERANGES")&&(event.attributes["RECENTLY-REMOVED-DATERANGES"]=event.attributes["RECENTLY-REMOVED-DATERANGES"].split(TAB)),void _this2.trigger("data",event);if((match=/^#EXT-X-PART:(.*)$/.exec(newLine))&&match[1])return(event={type:"tag",tagType:"part"}).attributes=parseAttributes$1(match[1]),["DURATION"].forEach((function(key){event.attributes.hasOwnProperty(key)&&(event.attributes[key]=parseFloat(event.attributes[key]))})),["INDEPENDENT","GAP"].forEach((function(key){event.attributes.hasOwnProperty(key)&&(event.attributes[key]=/YES/.test(event.attributes[key]))})),event.attributes.hasOwnProperty("BYTERANGE")&&(event.attributes.byterange=parseByterange(event.attributes.BYTERANGE)),void _this2.trigger("data",event);if((match=/^#EXT-X-SERVER-CONTROL:(.*)$/.exec(newLine))&&match[1])return(event={type:"tag",tagType:"server-control"}).attributes=parseAttributes$1(match[1]),["CAN-SKIP-UNTIL","PART-HOLD-BACK","HOLD-BACK"].forEach((function(key){event.attributes.hasOwnProperty(key)&&(event.attributes[key]=parseFloat(event.attributes[key]))})),["CAN-SKIP-DATERANGES","CAN-BLOCK-RELOAD"].forEach((function(key){event.attributes.hasOwnProperty(key)&&(event.attributes[key]=/YES/.test(event.attributes[key]))})),void _this2.trigger("data",event);if((match=/^#EXT-X-PART-INF:(.*)$/.exec(newLine))&&match[1])return(event={type:"tag",tagType:"part-inf"}).attributes=parseAttributes$1(match[1]),["PART-TARGET"].forEach((function(key){event.attributes.hasOwnProperty(key)&&(event.attributes[key]=parseFloat(event.attributes[key]))})),void _this2.trigger("data",event);if((match=/^#EXT-X-PRELOAD-HINT:(.*)$/.exec(newLine))&&match[1])return(event={type:"tag",tagType:"preload-hint"}).attributes=parseAttributes$1(match[1]),["BYTERANGE-START","BYTERANGE-LENGTH"].forEach((function(key){if(event.attributes.hasOwnProperty(key)){event.attributes[key]=parseInt(event.attributes[key],10);var subkey="BYTERANGE-LENGTH"===key?"length":"offset";event.attributes.byterange=event.attributes.byterange||{},event.attributes.byterange[subkey]=event.attributes[key],delete event.attributes[key]}})),void _this2.trigger("data",event);if((match=/^#EXT-X-RENDITION-REPORT:(.*)$/.exec(newLine))&&match[1])return(event={type:"tag",tagType:"rendition-report"}).attributes=parseAttributes$1(match[1]),["LAST-MSN","LAST-PART"].forEach((function(key){event.attributes.hasOwnProperty(key)&&(event.attributes[key]=parseInt(event.attributes[key],10))})),void _this2.trigger("data",event);_this2.trigger("data",{type:"tag",data:newLine.slice(4)})}}}else _this2.trigger("data",{type:"comment",text:newLine.slice(1)})})):this.trigger("data",{type:"uri",uri:line}))},_proto.addParser=function(_ref){var _this3=this,expression=_ref.expression,customType=_ref.customType,dataParser=_ref.dataParser,segment=_ref.segment;"function"!=typeof dataParser&&(dataParser=function(line){return line}),this.customParsers.push((function(line){if(expression.exec(line))return _this3.trigger("data",{type:"custom",data:dataParser(line),customType:customType,segment:segment}),!0}))},_proto.addTagMapper=function(_ref2){var expression=_ref2.expression,map=_ref2.map;this.tagMappers.push((function(line){return expression.test(line)?map(line):line}))},ParseStream}(Stream),camelCaseKeys=function(attributes){var result={};return Object.keys(attributes).forEach((function(key){var str;result[(str=key,str.toLowerCase().replace(/-(\w)/g,(function(a){return a[1].toUpperCase()})))]=attributes[key]})),result},setHoldBack=function(manifest){var serverControl=manifest.serverControl,targetDuration=manifest.targetDuration,partTargetDuration=manifest.partTargetDuration;if(serverControl){var tag="#EXT-X-SERVER-CONTROL",hb="holdBack",phb="partHoldBack",minTargetDuration=targetDuration&&3*targetDuration,minPartDuration=partTargetDuration&&2*partTargetDuration;targetDuration&&!serverControl.hasOwnProperty(hb)&&(serverControl[hb]=minTargetDuration,this.trigger("info",{message:tag+" defaulting HOLD-BACK to targetDuration * 3 ("+minTargetDuration+")."})),minTargetDuration&&serverControl[hb]<minTargetDuration&&(this.trigger("warn",{message:tag+" clamping HOLD-BACK ("+serverControl[hb]+") to targetDuration * 3 ("+minTargetDuration+")"}),serverControl[hb]=minTargetDuration),partTargetDuration&&!serverControl.hasOwnProperty(phb)&&(serverControl[phb]=3*partTargetDuration,this.trigger("info",{message:tag+" defaulting PART-HOLD-BACK to partTargetDuration * 3 ("+serverControl[phb]+")."})),partTargetDuration&&serverControl[phb]<minPartDuration&&(this.trigger("warn",{message:tag+" clamping PART-HOLD-BACK ("+serverControl[phb]+") to partTargetDuration * 2 ("+minPartDuration+")."}),serverControl[phb]=minPartDuration)}},Parser=function(_Stream){function Parser(){var _this;(_this=_Stream.call(this)||this).lineStream=new LineStream,_this.parseStream=new ParseStream,_this.lineStream.pipe(_this.parseStream);var currentMap,_key,self=assertThisInitialized(_this),uris=[],currentUri={},hasParts=!1,noop=function(){},defaultMediaGroups={AUDIO:{},VIDEO:{},"CLOSED-CAPTIONS":{},SUBTITLES:{}},currentTimeline=0;_this.manifest={allowCache:!0,discontinuityStarts:[],segments:[]};var lastByterangeEnd=0,lastPartByterangeEnd=0;return _this.on("end",(function(){currentUri.uri||!currentUri.parts&&!currentUri.preloadHints||(!currentUri.map&&currentMap&&(currentUri.map=currentMap),!currentUri.key&&_key&&(currentUri.key=_key),currentUri.timeline||"number"!=typeof currentTimeline||(currentUri.timeline=currentTimeline),_this.manifest.preloadSegment=currentUri)})),_this.parseStream.on("data",(function(entry){var mediaGroup,rendition;({tag:function(){({version:function(){entry.version&&(this.manifest.version=entry.version)},"allow-cache":function(){this.manifest.allowCache=entry.allowed,"allowed"in entry||(this.trigger("info",{message:"defaulting allowCache to YES"}),this.manifest.allowCache=!0)},byterange:function(){var byterange={};"length"in entry&&(currentUri.byterange=byterange,byterange.length=entry.length,"offset"in entry||(entry.offset=lastByterangeEnd)),"offset"in entry&&(currentUri.byterange=byterange,byterange.offset=entry.offset),lastByterangeEnd=byterange.offset+byterange.length},endlist:function(){this.manifest.endList=!0},inf:function(){"mediaSequence"in this.manifest||(this.manifest.mediaSequence=0,this.trigger("info",{message:"defaulting media sequence to zero"})),"discontinuitySequence"in this.manifest||(this.manifest.discontinuitySequence=0,this.trigger("info",{message:"defaulting discontinuity sequence to zero"})),entry.duration>0&&(currentUri.duration=entry.duration),0===entry.duration&&(currentUri.duration=.01,this.trigger("info",{message:"updating zero segment duration to a small value"})),this.manifest.segments=uris},key:function(){if(entry.attributes)if("NONE"!==entry.attributes.METHOD)if(entry.attributes.URI){if("com.apple.streamingkeydelivery"===entry.attributes.KEYFORMAT)return this.manifest.contentProtection=this.manifest.contentProtection||{},void(this.manifest.contentProtection["com.apple.fps.1_0"]={attributes:entry.attributes});if("urn:uuid:edef8ba9-79d6-4ace-a3c8-27dcd51d21ed"===entry.attributes.KEYFORMAT){return-1===["SAMPLE-AES","SAMPLE-AES-CTR","SAMPLE-AES-CENC"].indexOf(entry.attributes.METHOD)?void this.trigger("warn",{message:"invalid key method provided for Widevine"}):("SAMPLE-AES-CENC"===entry.attributes.METHOD&&this.trigger("warn",{message:"SAMPLE-AES-CENC is deprecated, please use SAMPLE-AES-CTR instead"}),"data:text/plain;base64,"!==entry.attributes.URI.substring(0,23)?void this.trigger("warn",{message:"invalid key URI provided for Widevine"}):entry.attributes.KEYID&&"0x"===entry.attributes.KEYID.substring(0,2)?(this.manifest.contentProtection=this.manifest.contentProtection||{},void(this.manifest.contentProtection["com.widevine.alpha"]={attributes:{schemeIdUri:entry.attributes.KEYFORMAT,keyId:entry.attributes.KEYID.substring(2)},pssh:decodeB64ToUint8Array(entry.attributes.URI.split(",")[1])})):void this.trigger("warn",{message:"invalid key ID provided for Widevine"}))}entry.attributes.METHOD||this.trigger("warn",{message:"defaulting key method to AES-128"}),_key={method:entry.attributes.METHOD||"AES-128",uri:entry.attributes.URI},void 0!==entry.attributes.IV&&(_key.iv=entry.attributes.IV)}else this.trigger("warn",{message:"ignoring key declaration without URI"});else _key=null;else this.trigger("warn",{message:"ignoring key declaration without attribute list"})},"media-sequence":function(){isFinite(entry.number)?this.manifest.mediaSequence=entry.number:this.trigger("warn",{message:"ignoring invalid media sequence: "+entry.number})},"discontinuity-sequence":function(){isFinite(entry.number)?(this.manifest.discontinuitySequence=entry.number,currentTimeline=entry.number):this.trigger("warn",{message:"ignoring invalid discontinuity sequence: "+entry.number})},"playlist-type":function(){/VOD|EVENT/.test(entry.playlistType)?this.manifest.playlistType=entry.playlistType:this.trigger("warn",{message:"ignoring unknown playlist type: "+entry.playlist})},map:function(){currentMap={},entry.uri&&(currentMap.uri=entry.uri),entry.byterange&&(currentMap.byterange=entry.byterange),_key&&(currentMap.key=_key)},"stream-inf":function(){this.manifest.playlists=uris,this.manifest.mediaGroups=this.manifest.mediaGroups||defaultMediaGroups,entry.attributes?(currentUri.attributes||(currentUri.attributes={}),_extends_1(currentUri.attributes,entry.attributes)):this.trigger("warn",{message:"ignoring empty stream-inf attributes"})},media:function(){if(this.manifest.mediaGroups=this.manifest.mediaGroups||defaultMediaGroups,entry.attributes&&entry.attributes.TYPE&&entry.attributes["GROUP-ID"]&&entry.attributes.NAME){var mediaGroupType=this.manifest.mediaGroups[entry.attributes.TYPE];mediaGroupType[entry.attributes["GROUP-ID"]]=mediaGroupType[entry.attributes["GROUP-ID"]]||{},mediaGroup=mediaGroupType[entry.attributes["GROUP-ID"]],(rendition={default:/yes/i.test(entry.attributes.DEFAULT)}).default?rendition.autoselect=!0:rendition.autoselect=/yes/i.test(entry.attributes.AUTOSELECT),entry.attributes.LANGUAGE&&(rendition.language=entry.attributes.LANGUAGE),entry.attributes.URI&&(rendition.uri=entry.attributes.URI),entry.attributes["INSTREAM-ID"]&&(rendition.instreamId=entry.attributes["INSTREAM-ID"]),entry.attributes.CHARACTERISTICS&&(rendition.characteristics=entry.attributes.CHARACTERISTICS),entry.attributes.FORCED&&(rendition.forced=/yes/i.test(entry.attributes.FORCED)),mediaGroup[entry.attributes.NAME]=rendition}else this.trigger("warn",{message:"ignoring incomplete or missing media group"})},discontinuity:function(){currentTimeline+=1,currentUri.discontinuity=!0,this.manifest.discontinuityStarts.push(uris.length)},"program-date-time":function(){void 0===this.manifest.dateTimeString&&(this.manifest.dateTimeString=entry.dateTimeString,this.manifest.dateTimeObject=entry.dateTimeObject),currentUri.dateTimeString=entry.dateTimeString,currentUri.dateTimeObject=entry.dateTimeObject},targetduration:function(){!isFinite(entry.duration)||entry.duration<0?this.trigger("warn",{message:"ignoring invalid target duration: "+entry.duration}):(this.manifest.targetDuration=entry.duration,setHoldBack.call(this,this.manifest))},start:function(){entry.attributes&&!isNaN(entry.attributes["TIME-OFFSET"])?this.manifest.start={timeOffset:entry.attributes["TIME-OFFSET"],precise:entry.attributes.PRECISE}:this.trigger("warn",{message:"ignoring start declaration without appropriate attribute list"})},"cue-out":function(){currentUri.cueOut=entry.data},"cue-out-cont":function(){currentUri.cueOutCont=entry.data},"cue-in":function(){currentUri.cueIn=entry.data},skip:function(){this.manifest.skip=camelCaseKeys(entry.attributes),this.warnOnMissingAttributes_("#EXT-X-SKIP",entry.attributes,["SKIPPED-SEGMENTS"])},part:function(){var _this2=this;hasParts=!0;var segmentIndex=this.manifest.segments.length,part=camelCaseKeys(entry.attributes);currentUri.parts=currentUri.parts||[],currentUri.parts.push(part),part.byterange&&(part.byterange.hasOwnProperty("offset")||(part.byterange.offset=lastPartByterangeEnd),lastPartByterangeEnd=part.byterange.offset+part.byterange.length);var partIndex=currentUri.parts.length-1;this.warnOnMissingAttributes_("#EXT-X-PART #"+partIndex+" for segment #"+segmentIndex,entry.attributes,["URI","DURATION"]),this.manifest.renditionReports&&this.manifest.renditionReports.forEach((function(r,i){r.hasOwnProperty("lastPart")||_this2.trigger("warn",{message:"#EXT-X-RENDITION-REPORT #"+i+" lacks required attribute(s): LAST-PART"})}))},"server-control":function(){var attrs=this.manifest.serverControl=camelCaseKeys(entry.attributes);attrs.hasOwnProperty("canBlockReload")||(attrs.canBlockReload=!1,this.trigger("info",{message:"#EXT-X-SERVER-CONTROL defaulting CAN-BLOCK-RELOAD to false"})),setHoldBack.call(this,this.manifest),attrs.canSkipDateranges&&!attrs.hasOwnProperty("canSkipUntil")&&this.trigger("warn",{message:"#EXT-X-SERVER-CONTROL lacks required attribute CAN-SKIP-UNTIL which is required when CAN-SKIP-DATERANGES is set"})},"preload-hint":function(){var segmentIndex=this.manifest.segments.length,hint=camelCaseKeys(entry.attributes),isPart=hint.type&&"PART"===hint.type;currentUri.preloadHints=currentUri.preloadHints||[],currentUri.preloadHints.push(hint),hint.byterange&&(hint.byterange.hasOwnProperty("offset")||(hint.byterange.offset=isPart?lastPartByterangeEnd:0,isPart&&(lastPartByterangeEnd=hint.byterange.offset+hint.byterange.length)));var index=currentUri.preloadHints.length-1;if(this.warnOnMissingAttributes_("#EXT-X-PRELOAD-HINT #"+index+" for segment #"+segmentIndex,entry.attributes,["TYPE","URI"]),hint.type)for(var i=0;i<currentUri.preloadHints.length-1;i++){var otherHint=currentUri.preloadHints[i];otherHint.type&&(otherHint.type===hint.type&&this.trigger("warn",{message:"#EXT-X-PRELOAD-HINT #"+index+" for segment #"+segmentIndex+" has the same TYPE "+hint.type+" as preload hint #"+i}))}},"rendition-report":function(){var report=camelCaseKeys(entry.attributes);this.manifest.renditionReports=this.manifest.renditionReports||[],this.manifest.renditionReports.push(report);var index=this.manifest.renditionReports.length-1,required=["LAST-MSN","URI"];hasParts&&required.push("LAST-PART"),this.warnOnMissingAttributes_("#EXT-X-RENDITION-REPORT #"+index,entry.attributes,required)},"part-inf":function(){this.manifest.partInf=camelCaseKeys(entry.attributes),this.warnOnMissingAttributes_("#EXT-X-PART-INF",entry.attributes,["PART-TARGET"]),this.manifest.partInf.partTarget&&(this.manifest.partTargetDuration=this.manifest.partInf.partTarget),setHoldBack.call(this,this.manifest)}}[entry.tagType]||noop).call(self)},uri:function(){currentUri.uri=entry.uri,uris.push(currentUri),this.manifest.targetDuration&&!("duration"in currentUri)&&(this.trigger("warn",{message:"defaulting segment duration to the target duration"}),currentUri.duration=this.manifest.targetDuration),_key&&(currentUri.key=_key),currentUri.timeline=currentTimeline,currentMap&&(currentUri.map=currentMap),lastPartByterangeEnd=0,currentUri={}},comment:function(){},custom:function(){entry.segment?(currentUri.custom=currentUri.custom||{},currentUri.custom[entry.customType]=entry.data):(this.manifest.custom=this.manifest.custom||{},this.manifest.custom[entry.customType]=entry.data)}})[entry.type].call(self)})),_this}inheritsLoose(Parser,_Stream);var _proto=Parser.prototype;return _proto.warnOnMissingAttributes_=function(identifier,attributes,required){var missing=[];required.forEach((function(key){attributes.hasOwnProperty(key)||missing.push(key)})),missing.length&&this.trigger("warn",{message:identifier+" lacks required attribute(s): "+missing.join(", ")})},_proto.push=function(chunk){this.lineStream.push(chunk)},_proto.end=function(){this.lineStream.push("\n"),this.trigger("end")},_proto.addParser=function(options){this.parseStream.addParser(options)},_proto.addTagMapper=function(options){this.parseStream.addTagMapper(options)},Parser}(Stream),regexs={mp4:/^(av0?1|avc0?[1234]|vp0?9|flac|opus|mp3|mp4a|mp4v|stpp.ttml.im1t)/,webm:/^(vp0?[89]|av0?1|opus|vorbis)/,ogg:/^(vp0?[89]|theora|flac|opus|vorbis)/,video:/^(av0?1|avc0?[1234]|vp0?[89]|hvc1|hev1|theora|mp4v)/,audio:/^(mp4a|flac|vorbis|opus|ac-[34]|ec-3|alac|mp3|speex|aac)/,text:/^(stpp.ttml.im1t)/,muxerVideo:/^(avc0?1)/,muxerAudio:/^(mp4a)/,muxerText:/a^/},mediaTypes=["video","audio","text"],upperMediaTypes=["Video","Audio","Text"],translateLegacyCodec=function(codec){return codec?codec.replace(/avc1\.(\d+)\.(\d+)/i,(function(orig,profile,avcLevel){return"avc1."+("00"+Number(profile).toString(16)).slice(-2)+"00"+("00"+Number(avcLevel).toString(16)).slice(-2)})):codec},parseCodecs=function(codecString){void 0===codecString&&(codecString="");var codecs=codecString.split(","),result=[];return codecs.forEach((function(codec){var codecType;codec=codec.trim(),mediaTypes.forEach((function(name){var match=regexs[name].exec(codec.toLowerCase());if(match&&!(match.length<=1)){codecType=name;var type=codec.substring(0,match[1].length),details=codec.replace(type,"");result.push({type:type,details:details,mediaType:name})}})),codecType||result.push({type:codec,details:"",mediaType:"unknown"})})),result},isAudioCodec=function(codec){return void 0===codec&&(codec=""),regexs.audio.test(codec.trim().toLowerCase())},getMimeForCodec=function(codecString){if(codecString&&"string"==typeof codecString){var codec,codecs=codecString.toLowerCase().split(",").map((function(c){return translateLegacyCodec(c.trim())})),type="video";1===codecs.length&&isAudioCodec(codecs[0])?type="audio":1===codecs.length&&(void 0===(codec=codecs[0])&&(codec=""),regexs.text.test(codec.trim().toLowerCase()))&&(type="application");var container="mp4";return codecs.every((function(c){return regexs.mp4.test(c)}))?container="mp4":codecs.every((function(c){return regexs.webm.test(c)}))?container="webm":codecs.every((function(c){return regexs.ogg.test(c)}))&&(container="ogg"),type+"/"+container+';codecs="'+codecString+'"'}},browserSupportsCodec=function(codecString){return void 0===codecString&&(codecString=""),window.MediaSource&&window.MediaSource.isTypeSupported&&window.MediaSource.isTypeSupported(getMimeForCodec(codecString))||!1},muxerSupportsCodec=function(codecString){return void 0===codecString&&(codecString=""),codecString.toLowerCase().split(",").every((function(codec){codec=codec.trim();for(var i=0;i<upperMediaTypes.length;i++){if(regexs["muxer"+upperMediaTypes[i]].test(codec))return!0}return!1}))},MPEGURL_REGEX=/^(audio|video|application)\/(x-|vnd\.apple\.)?mpegurl/i,DASH_REGEX=/^application\/dash\+xml/i,simpleTypeFromSourceType=function(type){return MPEGURL_REGEX.test(type)?"hls":DASH_REGEX.test(type)?"dash":"application/vnd.videojs.vhs+json"===type?"vhs-json":null},resolveUrl$1=function(baseUrl,relativeUrl){if(/^[a-z]+:/i.test(relativeUrl))return relativeUrl;/^data:/.test(baseUrl)&&(baseUrl=window.location&&window.location.href||"");var nativeURL="function"==typeof window.URL,protocolLess=/^\/\//.test(baseUrl),removeLocation=!window.location&&!/\/\//i.test(baseUrl);if(nativeURL?baseUrl=new window.URL(baseUrl,window.location||"http://example.com"):/\/\//i.test(baseUrl)||(baseUrl=urlToolkit.buildAbsoluteURL(window.location&&window.location.href||"",baseUrl)),nativeURL){var newUrl=new URL(relativeUrl,baseUrl);return removeLocation?newUrl.href.slice("http://example.com".length):protocolLess?newUrl.href.slice(newUrl.protocol.length):newUrl.href}return urlToolkit.buildAbsoluteURL(baseUrl,relativeUrl)};function freeze(object,oc){return void 0===oc&&(oc=Object),oc&&"function"==typeof oc.freeze?oc.freeze(object):object}var MIME_TYPE=freeze({HTML:"text/html",isHTML:function(value){return value===MIME_TYPE.HTML},XML_APPLICATION:"application/xml",XML_TEXT:"text/xml",XML_XHTML_APPLICATION:"application/xhtml+xml",XML_SVG_IMAGE:"image/svg+xml"}),NAMESPACE$3=freeze({HTML:"http://www.w3.org/1999/xhtml",isHTML:function(uri){return uri===NAMESPACE$3.HTML},SVG:"http://www.w3.org/2000/svg",XML:"http://www.w3.org/XML/1998/namespace",XMLNS:"http://www.w3.org/2000/xmlns/"}),conventions={freeze:freeze,MIME_TYPE:MIME_TYPE,NAMESPACE:NAMESPACE$3},NAMESPACE$2=conventions.NAMESPACE;function notEmptyString(input){return""!==input}function orderedSetReducer(current,element){return current.hasOwnProperty(element)||(current[element]=!0),current}function toOrderedSet(input){if(!input)return[];var list=function(input){return input?input.split(/[\t\n\f\r ]+/).filter(notEmptyString):[]}(input);return Object.keys(list.reduce(orderedSetReducer,{}))}function copy(src,dest){for(var p in src)dest[p]=src[p]}function _extends(Class,Super){var pt=Class.prototype;if(!(pt instanceof Super)){var t=function(){};t.prototype=Super.prototype,copy(pt,t=new t),Class.prototype=pt=t}pt.constructor!=Class&&("function"!=typeof Class&&console.error("unknown Class:"+Class),pt.constructor=Class)}var NodeType={},ELEMENT_NODE=NodeType.ELEMENT_NODE=1,ATTRIBUTE_NODE=NodeType.ATTRIBUTE_NODE=2,TEXT_NODE=NodeType.TEXT_NODE=3,CDATA_SECTION_NODE=NodeType.CDATA_SECTION_NODE=4,ENTITY_REFERENCE_NODE=NodeType.ENTITY_REFERENCE_NODE=5,ENTITY_NODE=NodeType.ENTITY_NODE=6,PROCESSING_INSTRUCTION_NODE=NodeType.PROCESSING_INSTRUCTION_NODE=7,COMMENT_NODE=NodeType.COMMENT_NODE=8,DOCUMENT_NODE=NodeType.DOCUMENT_NODE=9,DOCUMENT_TYPE_NODE=NodeType.DOCUMENT_TYPE_NODE=10,DOCUMENT_FRAGMENT_NODE=NodeType.DOCUMENT_FRAGMENT_NODE=11,NOTATION_NODE=NodeType.NOTATION_NODE=12,ExceptionCode={},ExceptionMessage={};ExceptionCode.INDEX_SIZE_ERR=(ExceptionMessage[1]="Index size error",1),ExceptionCode.DOMSTRING_SIZE_ERR=(ExceptionMessage[2]="DOMString size error",2);var HIERARCHY_REQUEST_ERR=ExceptionCode.HIERARCHY_REQUEST_ERR=(ExceptionMessage[3]="Hierarchy request error",3);ExceptionCode.WRONG_DOCUMENT_ERR=(ExceptionMessage[4]="Wrong document",4),ExceptionCode.INVALID_CHARACTER_ERR=(ExceptionMessage[5]="Invalid character",5),ExceptionCode.NO_DATA_ALLOWED_ERR=(ExceptionMessage[6]="No data allowed",6),ExceptionCode.NO_MODIFICATION_ALLOWED_ERR=(ExceptionMessage[7]="No modification allowed",7);var NOT_FOUND_ERR=ExceptionCode.NOT_FOUND_ERR=(ExceptionMessage[8]="Not found",8);ExceptionCode.NOT_SUPPORTED_ERR=(ExceptionMessage[9]="Not supported",9);var INUSE_ATTRIBUTE_ERR=ExceptionCode.INUSE_ATTRIBUTE_ERR=(ExceptionMessage[10]="Attribute in use",10);function DOMException(code,message){if(message instanceof Error)var error=message;else error=this,Error.call(this,ExceptionMessage[code]),this.message=ExceptionMessage[code],Error.captureStackTrace&&Error.captureStackTrace(this,DOMException);return error.code=code,message&&(this.message=this.message+": "+message),error}function NodeList(){}function LiveNodeList(node,refresh){this._node=node,this._refresh=refresh,_updateLiveList(this)}function _updateLiveList(list){var inc=list._node._inc||list._node.ownerDocument._inc;if(list._inc!=inc){var ls=list._refresh(list._node);__set__(list,"length",ls.length),copy(ls,list),list._inc=inc}}function NamedNodeMap(){}function _findNodeIndex(list,node){for(var i=list.length;i--;)if(list[i]===node)return i}function _addNamedNode(el,list,newAttr,oldAttr){if(oldAttr?list[_findNodeIndex(list,oldAttr)]=newAttr:list[list.length++]=newAttr,el){newAttr.ownerElement=el;var doc=el.ownerDocument;doc&&(oldAttr&&_onRemoveAttribute(doc,el,oldAttr),function(doc,el,newAttr){doc&&doc._inc++,newAttr.namespaceURI===NAMESPACE$2.XMLNS&&(el._nsMap[newAttr.prefix?newAttr.localName:""]=newAttr.value)}(doc,el,newAttr))}}function _removeNamedNode(el,list,attr){var i=_findNodeIndex(list,attr);if(!(i>=0))throw DOMException(NOT_FOUND_ERR,new Error(el.tagName+"@"+attr));for(var lastIndex=list.length-1;i<lastIndex;)list[i]=list[++i];if(list.length=lastIndex,el){var doc=el.ownerDocument;doc&&(_onRemoveAttribute(doc,el,attr),attr.ownerElement=null)}}function DOMImplementation$1(){}function Node(){}function _xmlEncoder(c){return("<"==c?"&lt;":">"==c&&"&gt;")||"&"==c&&"&amp;"||'"'==c&&"&quot;"||"&#"+c.charCodeAt()+";"}function _visitNode(node,callback){if(callback(node))return!0;if(node=node.firstChild)do{if(_visitNode(node,callback))return!0}while(node=node.nextSibling)}function Document(){}function _onRemoveAttribute(doc,el,newAttr,remove){doc&&doc._inc++,newAttr.namespaceURI===NAMESPACE$2.XMLNS&&delete el._nsMap[newAttr.prefix?newAttr.localName:""]}function _onUpdateChild(doc,el,newChild){if(doc&&doc._inc){doc._inc++;var cs=el.childNodes;if(newChild)cs[cs.length++]=newChild;else{for(var child=el.firstChild,i=0;child;)cs[i++]=child,child=child.nextSibling;cs.length=i}}}function _removeChild(parentNode,child){var previous=child.previousSibling,next=child.nextSibling;return previous?previous.nextSibling=next:parentNode.firstChild=next,next?next.previousSibling=previous:parentNode.lastChild=previous,_onUpdateChild(parentNode.ownerDocument,parentNode),child}function _insertBefore(parentNode,newChild,nextChild){var cp=newChild.parentNode;if(cp&&cp.removeChild(newChild),newChild.nodeType===DOCUMENT_FRAGMENT_NODE){var newFirst=newChild.firstChild;if(null==newFirst)return newChild;var newLast=newChild.lastChild}else newFirst=newLast=newChild;var pre=nextChild?nextChild.previousSibling:parentNode.lastChild;newFirst.previousSibling=pre,newLast.nextSibling=nextChild,pre?pre.nextSibling=newFirst:parentNode.firstChild=newFirst,null==nextChild?parentNode.lastChild=newLast:nextChild.previousSibling=newLast;do{newFirst.parentNode=parentNode}while(newFirst!==newLast&&(newFirst=newFirst.nextSibling));return _onUpdateChild(parentNode.ownerDocument||parentNode,parentNode),newChild.nodeType==DOCUMENT_FRAGMENT_NODE&&(newChild.firstChild=newChild.lastChild=null),newChild}function Element(){this._nsMap={}}function Attr(){}function CharacterData(){}function Text(){}function Comment(){}function CDATASection(){}function DocumentType(){}function Notation(){}function Entity(){}function EntityReference(){}function DocumentFragment(){}function ProcessingInstruction(){}function XMLSerializer$1(){}function nodeSerializeToString(isHtml,nodeFilter){var buf=[],refNode=9==this.nodeType&&this.documentElement||this,prefix=refNode.prefix,uri=refNode.namespaceURI;if(uri&&null==prefix&&null==(prefix=refNode.lookupPrefix(uri)))var visibleNamespaces=[{namespace:uri,prefix:null}];return serializeToString(this,buf,isHtml,nodeFilter,visibleNamespaces),buf.join("")}function needNamespaceDefine(node,isHTML,visibleNamespaces){var prefix=node.prefix||"",uri=node.namespaceURI;if(!uri)return!1;if("xml"===prefix&&uri===NAMESPACE$2.XML||uri===NAMESPACE$2.XMLNS)return!1;for(var i=visibleNamespaces.length;i--;){var ns=visibleNamespaces[i];if(ns.prefix===prefix)return ns.namespace!==uri}return!0}function addSerializedAttribute(buf,qualifiedName,value){buf.push(" ",qualifiedName,'="',value.replace(/[<&"]/g,_xmlEncoder),'"')}function serializeToString(node,buf,isHTML,nodeFilter,visibleNamespaces){if(visibleNamespaces||(visibleNamespaces=[]),nodeFilter){if(!(node=nodeFilter(node)))return;if("string"==typeof node)return void buf.push(node)}switch(node.nodeType){case ELEMENT_NODE:var attrs=node.attributes,len=attrs.length,child=node.firstChild,nodeName=node.tagName,prefixedNodeName=nodeName;if(!(isHTML=NAMESPACE$2.isHTML(node.namespaceURI)||isHTML)&&!node.prefix&&node.namespaceURI){for(var defaultNS,ai=0;ai<attrs.length;ai++)if("xmlns"===attrs.item(ai).name){defaultNS=attrs.item(ai).value;break}if(!defaultNS)for(var nsi=visibleNamespaces.length-1;nsi>=0;nsi--){if(""===(namespace=visibleNamespaces[nsi]).prefix&&namespace.namespace===node.namespaceURI){defaultNS=namespace.namespace;break}}if(defaultNS!==node.namespaceURI)for(nsi=visibleNamespaces.length-1;nsi>=0;nsi--){var namespace;if((namespace=visibleNamespaces[nsi]).namespace===node.namespaceURI){namespace.prefix&&(prefixedNodeName=namespace.prefix+":"+nodeName);break}}}buf.push("<",prefixedNodeName);for(var i=0;i<len;i++){"xmlns"==(attr=attrs.item(i)).prefix?visibleNamespaces.push({prefix:attr.localName,namespace:attr.value}):"xmlns"==attr.nodeName&&visibleNamespaces.push({prefix:"",namespace:attr.value})}for(i=0;i<len;i++){var attr,prefix,uri;if(needNamespaceDefine(attr=attrs.item(i),0,visibleNamespaces))addSerializedAttribute(buf,(prefix=attr.prefix||"")?"xmlns:"+prefix:"xmlns",uri=attr.namespaceURI),visibleNamespaces.push({prefix:prefix,namespace:uri});serializeToString(attr,buf,isHTML,nodeFilter,visibleNamespaces)}if(nodeName===prefixedNodeName&&needNamespaceDefine(node,0,visibleNamespaces))addSerializedAttribute(buf,(prefix=node.prefix||"")?"xmlns:"+prefix:"xmlns",uri=node.namespaceURI),visibleNamespaces.push({prefix:prefix,namespace:uri});if(child||isHTML&&!/^(?:meta|link|img|br|hr|input)$/i.test(nodeName)){if(buf.push(">"),isHTML&&/^script$/i.test(nodeName))for(;child;)child.data?buf.push(child.data):serializeToString(child,buf,isHTML,nodeFilter,visibleNamespaces.slice()),child=child.nextSibling;else for(;child;)serializeToString(child,buf,isHTML,nodeFilter,visibleNamespaces.slice()),child=child.nextSibling;buf.push("</",prefixedNodeName,">")}else buf.push("/>");return;case DOCUMENT_NODE:case DOCUMENT_FRAGMENT_NODE:for(child=node.firstChild;child;)serializeToString(child,buf,isHTML,nodeFilter,visibleNamespaces.slice()),child=child.nextSibling;return;case ATTRIBUTE_NODE:return addSerializedAttribute(buf,node.name,node.value);case TEXT_NODE:return buf.push(node.data.replace(/[<&]/g,_xmlEncoder).replace(/]]>/g,"]]&gt;"));case CDATA_SECTION_NODE:return buf.push("<![CDATA[",node.data,"]]>");case COMMENT_NODE:return buf.push("\x3c!--",node.data,"--\x3e");case DOCUMENT_TYPE_NODE:var pubid=node.publicId,sysid=node.systemId;if(buf.push("<!DOCTYPE ",node.name),pubid)buf.push(" PUBLIC ",pubid),sysid&&"."!=sysid&&buf.push(" ",sysid),buf.push(">");else if(sysid&&"."!=sysid)buf.push(" SYSTEM ",sysid,">");else{var sub=node.internalSubset;sub&&buf.push(" [",sub,"]"),buf.push(">")}return;case PROCESSING_INSTRUCTION_NODE:return buf.push("<?",node.target," ",node.data,"?>");case ENTITY_REFERENCE_NODE:return buf.push("&",node.nodeName,";");default:buf.push("??",node.nodeName)}}function _importNode(doc,node,deep){var node2;switch(node.nodeType){case ELEMENT_NODE:(node2=node.cloneNode(!1)).ownerDocument=doc;case DOCUMENT_FRAGMENT_NODE:break;case ATTRIBUTE_NODE:deep=!0}if(node2||(node2=node.cloneNode(!1)),node2.ownerDocument=doc,node2.parentNode=null,deep)for(var child=node.firstChild;child;)node2.appendChild(_importNode(doc,child,deep)),child=child.nextSibling;return node2}function _cloneNode(doc,node,deep){var node2=new node.constructor;for(var n in node){var v=node[n];"object"!=typeof v&&v!=node2[n]&&(node2[n]=v)}switch(node.childNodes&&(node2.childNodes=new NodeList),node2.ownerDocument=doc,node2.nodeType){case ELEMENT_NODE:var attrs=node.attributes,attrs2=node2.attributes=new NamedNodeMap,len=attrs.length;attrs2._ownerElement=node2;for(var i=0;i<len;i++)node2.setAttributeNode(_cloneNode(doc,attrs.item(i),!0));break;case ATTRIBUTE_NODE:deep=!0}if(deep)for(var child=node.firstChild;child;)node2.appendChild(_cloneNode(doc,child,deep)),child=child.nextSibling;return node2}function __set__(object,key,value){object[key]=value}ExceptionCode.INVALID_STATE_ERR=(ExceptionMessage[11]="Invalid state",11),ExceptionCode.SYNTAX_ERR=(ExceptionMessage[12]="Syntax error",12),ExceptionCode.INVALID_MODIFICATION_ERR=(ExceptionMessage[13]="Invalid modification",13),ExceptionCode.NAMESPACE_ERR=(ExceptionMessage[14]="Invalid namespace",14),ExceptionCode.INVALID_ACCESS_ERR=(ExceptionMessage[15]="Invalid access",15),DOMException.prototype=Error.prototype,copy(ExceptionCode,DOMException),NodeList.prototype={length:0,item:function(index){return this[index]||null},toString:function(isHTML,nodeFilter){for(var buf=[],i=0;i<this.length;i++)serializeToString(this[i],buf,isHTML,nodeFilter);return buf.join("")}},LiveNodeList.prototype.item=function(i){return _updateLiveList(this),this[i]},_extends(LiveNodeList,NodeList),NamedNodeMap.prototype={length:0,item:NodeList.prototype.item,getNamedItem:function(key){for(var i=this.length;i--;){var attr=this[i];if(attr.nodeName==key)return attr}},setNamedItem:function(attr){var el=attr.ownerElement;if(el&&el!=this._ownerElement)throw new DOMException(INUSE_ATTRIBUTE_ERR);var oldAttr=this.getNamedItem(attr.nodeName);return _addNamedNode(this._ownerElement,this,attr,oldAttr),oldAttr},setNamedItemNS:function(attr){var oldAttr,el=attr.ownerElement;if(el&&el!=this._ownerElement)throw new DOMException(INUSE_ATTRIBUTE_ERR);return oldAttr=this.getNamedItemNS(attr.namespaceURI,attr.localName),_addNamedNode(this._ownerElement,this,attr,oldAttr),oldAttr},removeNamedItem:function(key){var attr=this.getNamedItem(key);return _removeNamedNode(this._ownerElement,this,attr),attr},removeNamedItemNS:function(namespaceURI,localName){var attr=this.getNamedItemNS(namespaceURI,localName);return _removeNamedNode(this._ownerElement,this,attr),attr},getNamedItemNS:function(namespaceURI,localName){for(var i=this.length;i--;){var node=this[i];if(node.localName==localName&&node.namespaceURI==namespaceURI)return node}return null}},DOMImplementation$1.prototype={hasFeature:function(feature,version){return!0},createDocument:function(namespaceURI,qualifiedName,doctype){var doc=new Document;if(doc.implementation=this,doc.childNodes=new NodeList,doc.doctype=doctype||null,doctype&&doc.appendChild(doctype),qualifiedName){var root=doc.createElementNS(namespaceURI,qualifiedName);doc.appendChild(root)}return doc},createDocumentType:function(qualifiedName,publicId,systemId){var node=new DocumentType;return node.name=qualifiedName,node.nodeName=qualifiedName,node.publicId=publicId||"",node.systemId=systemId||"",node}},Node.prototype={firstChild:null,lastChild:null,previousSibling:null,nextSibling:null,attributes:null,parentNode:null,childNodes:null,ownerDocument:null,nodeValue:null,namespaceURI:null,prefix:null,localName:null,insertBefore:function(newChild,refChild){return _insertBefore(this,newChild,refChild)},replaceChild:function(newChild,oldChild){this.insertBefore(newChild,oldChild),oldChild&&this.removeChild(oldChild)},removeChild:function(oldChild){return _removeChild(this,oldChild)},appendChild:function(newChild){return this.insertBefore(newChild,null)},hasChildNodes:function(){return null!=this.firstChild},cloneNode:function(deep){return _cloneNode(this.ownerDocument||this,this,deep)},normalize:function(){for(var child=this.firstChild;child;){var next=child.nextSibling;next&&next.nodeType==TEXT_NODE&&child.nodeType==TEXT_NODE?(this.removeChild(next),child.appendData(next.data)):(child.normalize(),child=next)}},isSupported:function(feature,version){return this.ownerDocument.implementation.hasFeature(feature,version)},hasAttributes:function(){return this.attributes.length>0},lookupPrefix:function(namespaceURI){for(var el=this;el;){var map=el._nsMap;if(map)for(var n in map)if(map[n]==namespaceURI)return n;el=el.nodeType==ATTRIBUTE_NODE?el.ownerDocument:el.parentNode}return null},lookupNamespaceURI:function(prefix){for(var el=this;el;){var map=el._nsMap;if(map&&prefix in map)return map[prefix];el=el.nodeType==ATTRIBUTE_NODE?el.ownerDocument:el.parentNode}return null},isDefaultNamespace:function(namespaceURI){return null==this.lookupPrefix(namespaceURI)}},copy(NodeType,Node),copy(NodeType,Node.prototype),Document.prototype={nodeName:"#document",nodeType:DOCUMENT_NODE,doctype:null,documentElement:null,_inc:1,insertBefore:function(newChild,refChild){if(newChild.nodeType==DOCUMENT_FRAGMENT_NODE){for(var child=newChild.firstChild;child;){var next=child.nextSibling;this.insertBefore(child,refChild),child=next}return newChild}return null==this.documentElement&&newChild.nodeType==ELEMENT_NODE&&(this.documentElement=newChild),_insertBefore(this,newChild,refChild),newChild.ownerDocument=this,newChild},removeChild:function(oldChild){return this.documentElement==oldChild&&(this.documentElement=null),_removeChild(this,oldChild)},importNode:function(importedNode,deep){return _importNode(this,importedNode,deep)},getElementById:function(id){var rtv=null;return _visitNode(this.documentElement,(function(node){if(node.nodeType==ELEMENT_NODE&&node.getAttribute("id")==id)return rtv=node,!0})),rtv},getElementsByClassName:function(classNames){var classNamesSet=toOrderedSet(classNames);return new LiveNodeList(this,(function(base){var ls=[];return classNamesSet.length>0&&_visitNode(base.documentElement,(function(node){if(node!==base&&node.nodeType===ELEMENT_NODE){var nodeClassNames=node.getAttribute("class");if(nodeClassNames){var matches=classNames===nodeClassNames;if(!matches){var nodeClassNamesSet=toOrderedSet(nodeClassNames);matches=classNamesSet.every((list=nodeClassNamesSet,function(element){return list&&-1!==list.indexOf(element)}))}matches&&ls.push(node)}}var list})),ls}))},createElement:function(tagName){var node=new Element;return node.ownerDocument=this,node.nodeName=tagName,node.tagName=tagName,node.localName=tagName,node.childNodes=new NodeList,(node.attributes=new NamedNodeMap)._ownerElement=node,node},createDocumentFragment:function(){var node=new DocumentFragment;return node.ownerDocument=this,node.childNodes=new NodeList,node},createTextNode:function(data){var node=new Text;return node.ownerDocument=this,node.appendData(data),node},createComment:function(data){var node=new Comment;return node.ownerDocument=this,node.appendData(data),node},createCDATASection:function(data){var node=new CDATASection;return node.ownerDocument=this,node.appendData(data),node},createProcessingInstruction:function(target,data){var node=new ProcessingInstruction;return node.ownerDocument=this,node.tagName=node.target=target,node.nodeValue=node.data=data,node},createAttribute:function(name){var node=new Attr;return node.ownerDocument=this,node.name=name,node.nodeName=name,node.localName=name,node.specified=!0,node},createEntityReference:function(name){var node=new EntityReference;return node.ownerDocument=this,node.nodeName=name,node},createElementNS:function(namespaceURI,qualifiedName){var node=new Element,pl=qualifiedName.split(":"),attrs=node.attributes=new NamedNodeMap;return node.childNodes=new NodeList,node.ownerDocument=this,node.nodeName=qualifiedName,node.tagName=qualifiedName,node.namespaceURI=namespaceURI,2==pl.length?(node.prefix=pl[0],node.localName=pl[1]):node.localName=qualifiedName,attrs._ownerElement=node,node},createAttributeNS:function(namespaceURI,qualifiedName){var node=new Attr,pl=qualifiedName.split(":");return node.ownerDocument=this,node.nodeName=qualifiedName,node.name=qualifiedName,node.namespaceURI=namespaceURI,node.specified=!0,2==pl.length?(node.prefix=pl[0],node.localName=pl[1]):node.localName=qualifiedName,node}},_extends(Document,Node),Element.prototype={nodeType:ELEMENT_NODE,hasAttribute:function(name){return null!=this.getAttributeNode(name)},getAttribute:function(name){var attr=this.getAttributeNode(name);return attr&&attr.value||""},getAttributeNode:function(name){return this.attributes.getNamedItem(name)},setAttribute:function(name,value){var attr=this.ownerDocument.createAttribute(name);attr.value=attr.nodeValue=""+value,this.setAttributeNode(attr)},removeAttribute:function(name){var attr=this.getAttributeNode(name);attr&&this.removeAttributeNode(attr)},appendChild:function(newChild){return newChild.nodeType===DOCUMENT_FRAGMENT_NODE?this.insertBefore(newChild,null):function(parentNode,newChild){var cp=newChild.parentNode;if(cp){var pre=parentNode.lastChild;cp.removeChild(newChild),pre=parentNode.lastChild}return pre=parentNode.lastChild,newChild.parentNode=parentNode,newChild.previousSibling=pre,newChild.nextSibling=null,pre?pre.nextSibling=newChild:parentNode.firstChild=newChild,parentNode.lastChild=newChild,_onUpdateChild(parentNode.ownerDocument,parentNode,newChild),newChild}(this,newChild)},setAttributeNode:function(newAttr){return this.attributes.setNamedItem(newAttr)},setAttributeNodeNS:function(newAttr){return this.attributes.setNamedItemNS(newAttr)},removeAttributeNode:function(oldAttr){return this.attributes.removeNamedItem(oldAttr.nodeName)},removeAttributeNS:function(namespaceURI,localName){var old=this.getAttributeNodeNS(namespaceURI,localName);old&&this.removeAttributeNode(old)},hasAttributeNS:function(namespaceURI,localName){return null!=this.getAttributeNodeNS(namespaceURI,localName)},getAttributeNS:function(namespaceURI,localName){var attr=this.getAttributeNodeNS(namespaceURI,localName);return attr&&attr.value||""},setAttributeNS:function(namespaceURI,qualifiedName,value){var attr=this.ownerDocument.createAttributeNS(namespaceURI,qualifiedName);attr.value=attr.nodeValue=""+value,this.setAttributeNode(attr)},getAttributeNodeNS:function(namespaceURI,localName){return this.attributes.getNamedItemNS(namespaceURI,localName)},getElementsByTagName:function(tagName){return new LiveNodeList(this,(function(base){var ls=[];return _visitNode(base,(function(node){node===base||node.nodeType!=ELEMENT_NODE||"*"!==tagName&&node.tagName!=tagName||ls.push(node)})),ls}))},getElementsByTagNameNS:function(namespaceURI,localName){return new LiveNodeList(this,(function(base){var ls=[];return _visitNode(base,(function(node){node===base||node.nodeType!==ELEMENT_NODE||"*"!==namespaceURI&&node.namespaceURI!==namespaceURI||"*"!==localName&&node.localName!=localName||ls.push(node)})),ls}))}},Document.prototype.getElementsByTagName=Element.prototype.getElementsByTagName,Document.prototype.getElementsByTagNameNS=Element.prototype.getElementsByTagNameNS,_extends(Element,Node),Attr.prototype.nodeType=ATTRIBUTE_NODE,_extends(Attr,Node),CharacterData.prototype={data:"",substringData:function(offset,count){return this.data.substring(offset,offset+count)},appendData:function(text){text=this.data+text,this.nodeValue=this.data=text,this.length=text.length},insertData:function(offset,text){this.replaceData(offset,0,text)},appendChild:function(newChild){throw new Error(ExceptionMessage[HIERARCHY_REQUEST_ERR])},deleteData:function(offset,count){this.replaceData(offset,count,"")},replaceData:function(offset,count,text){text=this.data.substring(0,offset)+text+this.data.substring(offset+count),this.nodeValue=this.data=text,this.length=text.length}},_extends(CharacterData,Node),Text.prototype={nodeName:"#text",nodeType:TEXT_NODE,splitText:function(offset){var text=this.data,newText=text.substring(offset);text=text.substring(0,offset),this.data=this.nodeValue=text,this.length=text.length;var newNode=this.ownerDocument.createTextNode(newText);return this.parentNode&&this.parentNode.insertBefore(newNode,this.nextSibling),newNode}},_extends(Text,CharacterData),Comment.prototype={nodeName:"#comment",nodeType:COMMENT_NODE},_extends(Comment,CharacterData),CDATASection.prototype={nodeName:"#cdata-section",nodeType:CDATA_SECTION_NODE},_extends(CDATASection,CharacterData),DocumentType.prototype.nodeType=DOCUMENT_TYPE_NODE,_extends(DocumentType,Node),Notation.prototype.nodeType=NOTATION_NODE,_extends(Notation,Node),Entity.prototype.nodeType=ENTITY_NODE,_extends(Entity,Node),EntityReference.prototype.nodeType=ENTITY_REFERENCE_NODE,_extends(EntityReference,Node),DocumentFragment.prototype.nodeName="#document-fragment",DocumentFragment.prototype.nodeType=DOCUMENT_FRAGMENT_NODE,_extends(DocumentFragment,Node),ProcessingInstruction.prototype.nodeType=PROCESSING_INSTRUCTION_NODE,_extends(ProcessingInstruction,Node),XMLSerializer$1.prototype.serializeToString=function(node,isHtml,nodeFilter){return nodeSerializeToString.call(node,isHtml,nodeFilter)},Node.prototype.toString=nodeSerializeToString;try{if(Object.defineProperty){var getTextContent=function getTextContent(node){switch(node.nodeType){case ELEMENT_NODE:case DOCUMENT_FRAGMENT_NODE:var buf=[];for(node=node.firstChild;node;)7!==node.nodeType&&8!==node.nodeType&&buf.push(getTextContent(node)),node=node.nextSibling;return buf.join("");default:return node.nodeValue}};Object.defineProperty(LiveNodeList.prototype,"length",{get:function(){return _updateLiveList(this),this.$$length}}),Object.defineProperty(Node.prototype,"textContent",{get:function(){return getTextContent(this)},set:function(data){switch(this.nodeType){case ELEMENT_NODE:case DOCUMENT_FRAGMENT_NODE:for(;this.firstChild;)this.removeChild(this.firstChild);(data||String(data))&&this.appendChild(this.ownerDocument.createTextNode(data));break;default:this.data=data,this.value=data,this.nodeValue=data}}}),__set__=function(object,key,value){object["$$"+key]=value}}}catch(e){}var dom={DocumentType:DocumentType,DOMException:DOMException,DOMImplementation:DOMImplementation$1,Element:Element,Node:Node,NodeList:NodeList,XMLSerializer:XMLSerializer$1},entities=createCommonjsModule((function(module,exports){var freeze=conventions.freeze;exports.XML_ENTITIES=freeze({amp:"&",apos:"'",gt:">",lt:"<",quot:'"'}),exports.HTML_ENTITIES=freeze({lt:"<",gt:">",amp:"&",quot:'"',apos:"'",Agrave:"À",Aacute:"Á",Acirc:"Â",Atilde:"Ã",Auml:"Ä",Aring:"Å",AElig:"Æ",Ccedil:"Ç",Egrave:"È",Eacute:"É",Ecirc:"Ê",Euml:"Ë",Igrave:"Ì",Iacute:"Í",Icirc:"Î",Iuml:"Ï",ETH:"Ð",Ntilde:"Ñ",Ograve:"Ò",Oacute:"Ó",Ocirc:"Ô",Otilde:"Õ",Ouml:"Ö",Oslash:"Ø",Ugrave:"Ù",Uacute:"Ú",Ucirc:"Û",Uuml:"Ü",Yacute:"Ý",THORN:"Þ",szlig:"ß",agrave:"à",aacute:"á",acirc:"â",atilde:"ã",auml:"ä",aring:"å",aelig:"æ",ccedil:"ç",egrave:"è",eacute:"é",ecirc:"ê",euml:"ë",igrave:"ì",iacute:"í",icirc:"î",iuml:"ï",eth:"ð",ntilde:"ñ",ograve:"ò",oacute:"ó",ocirc:"ô",otilde:"õ",ouml:"ö",oslash:"ø",ugrave:"ù",uacute:"ú",ucirc:"û",uuml:"ü",yacute:"ý",thorn:"þ",yuml:"ÿ",nbsp:" ",iexcl:"¡",cent:"¢",pound:"£",curren:"¤",yen:"¥",brvbar:"¦",sect:"§",uml:"¨",copy:"©",ordf:"ª",laquo:"«",not:"¬",shy:"­­",reg:"®",macr:"¯",deg:"°",plusmn:"±",sup2:"²",sup3:"³",acute:"´",micro:"µ",para:"¶",middot:"·",cedil:"¸",sup1:"¹",ordm:"º",raquo:"»",frac14:"¼",frac12:"½",frac34:"¾",iquest:"¿",times:"×",divide:"÷",forall:"∀",part:"∂",exist:"∃",empty:"∅",nabla:"∇",isin:"∈",notin:"∉",ni:"∋",prod:"∏",sum:"∑",minus:"−",lowast:"∗",radic:"√",prop:"∝",infin:"∞",ang:"∠",and:"∧",or:"∨",cap:"∩",cup:"∪",int:"∫",there4:"∴",sim:"∼",cong:"≅",asymp:"≈",ne:"≠",equiv:"≡",le:"≤",ge:"≥",sub:"⊂",sup:"⊃",nsub:"⊄",sube:"⊆",supe:"⊇",oplus:"⊕",otimes:"⊗",perp:"⊥",sdot:"⋅",Alpha:"Α",Beta:"Β",Gamma:"Γ",Delta:"Δ",Epsilon:"Ε",Zeta:"Ζ",Eta:"Η",Theta:"Θ",Iota:"Ι",Kappa:"Κ",Lambda:"Λ",Mu:"Μ",Nu:"Ν",Xi:"Ξ",Omicron:"Ο",Pi:"Π",Rho:"Ρ",Sigma:"Σ",Tau:"Τ",Upsilon:"Υ",Phi:"Φ",Chi:"Χ",Psi:"Ψ",Omega:"Ω",alpha:"α",beta:"β",gamma:"γ",delta:"δ",epsilon:"ε",zeta:"ζ",eta:"η",theta:"θ",iota:"ι",kappa:"κ",lambda:"λ",mu:"μ",nu:"ν",xi:"ξ",omicron:"ο",pi:"π",rho:"ρ",sigmaf:"ς",sigma:"σ",tau:"τ",upsilon:"υ",phi:"φ",chi:"χ",psi:"ψ",omega:"ω",thetasym:"ϑ",upsih:"ϒ",piv:"ϖ",OElig:"Œ",oelig:"œ",Scaron:"Š",scaron:"š",Yuml:"Ÿ",fnof:"ƒ",circ:"ˆ",tilde:"˜",ensp:" ",emsp:" ",thinsp:" ",zwnj:"‌",zwj:"‍",lrm:"‎",rlm:"‏",ndash:"–",mdash:"—",lsquo:"‘",rsquo:"’",sbquo:"‚",ldquo:"“",rdquo:"”",bdquo:"„",dagger:"†",Dagger:"‡",bull:"•",hellip:"…",permil:"‰",prime:"′",Prime:"″",lsaquo:"‹",rsaquo:"›",oline:"‾",euro:"€",trade:"™",larr:"←",uarr:"↑",rarr:"→",darr:"↓",harr:"↔",crarr:"↵",lceil:"⌈",rceil:"⌉",lfloor:"⌊",rfloor:"⌋",loz:"◊",spades:"♠",clubs:"♣",hearts:"♥",diams:"♦"}),exports.entityMap=exports.HTML_ENTITIES}));entities.XML_ENTITIES,entities.HTML_ENTITIES,entities.entityMap;var NAMESPACE$1=conventions.NAMESPACE,nameStartChar=/[A-Z_a-z\xC0-\xD6\xD8-\xF6\u00F8-\u02FF\u0370-\u037D\u037F-\u1FFF\u200C-\u200D\u2070-\u218F\u2C00-\u2FEF\u3001-\uD7FF\uF900-\uFDCF\uFDF0-\uFFFD]/,nameChar=new RegExp("[\\-\\.0-9"+nameStartChar.source.slice(1,-1)+"\\u00B7\\u0300-\\u036F\\u203F-\\u2040]"),tagNamePattern=new RegExp("^"+nameStartChar.source+nameChar.source+"*(?::"+nameStartChar.source+nameChar.source+"*)?$");function ParseError$1(message,locator){this.message=message,this.locator=locator,Error.captureStackTrace&&Error.captureStackTrace(this,ParseError$1)}function XMLReader$1(){}function copyLocator(f,t){return t.lineNumber=f.lineNumber,t.columnNumber=f.columnNumber,t}function parseElementStartPart(source,start,el,currentNSMap,entityReplacer,errorHandler){function addAttribute(qname,value,startIndex){el.attributeNames.hasOwnProperty(qname)&&errorHandler.fatalError("Attribute "+qname+" redefined"),el.addValue(qname,value,startIndex)}for(var attrName,p=++start,s=0;;){var c=source.charAt(p);switch(c){case"=":if(1===s)attrName=source.slice(start,p),s=3;else{if(2!==s)throw new Error("attribute equal must after attrName");s=3}break;case"'":case'"':if(3===s||1===s){if(1===s&&(errorHandler.warning('attribute value must after "="'),attrName=source.slice(start,p)),start=p+1,!((p=source.indexOf(c,start))>0))throw new Error("attribute value no end '"+c+"' match");addAttribute(attrName,value=source.slice(start,p).replace(/&#?\w+;/g,entityReplacer),start-1),s=5}else{if(4!=s)throw new Error('attribute value must after "="');addAttribute(attrName,value=source.slice(start,p).replace(/&#?\w+;/g,entityReplacer),start),errorHandler.warning('attribute "'+attrName+'" missed start quot('+c+")!!"),start=p+1,s=5}break;case"/":switch(s){case 0:el.setTagName(source.slice(start,p));case 5:case 6:case 7:s=7,el.closed=!0;case 4:case 1:case 2:break;default:throw new Error("attribute invalid close char('/')")}break;case"":return errorHandler.error("unexpected end of input"),0==s&&el.setTagName(source.slice(start,p)),p;case">":switch(s){case 0:el.setTagName(source.slice(start,p));case 5:case 6:case 7:break;case 4:case 1:"/"===(value=source.slice(start,p)).slice(-1)&&(el.closed=!0,value=value.slice(0,-1));case 2:2===s&&(value=attrName),4==s?(errorHandler.warning('attribute "'+value+'" missed quot(")!'),addAttribute(attrName,value.replace(/&#?\w+;/g,entityReplacer),start)):(NAMESPACE$1.isHTML(currentNSMap[""])&&value.match(/^(?:disabled|checked|selected)$/i)||errorHandler.warning('attribute "'+value+'" missed value!! "'+value+'" instead!!'),addAttribute(value,value,start));break;case 3:throw new Error("attribute value missed!!")}return p;case"":c=" ";default:if(c<=" ")switch(s){case 0:el.setTagName(source.slice(start,p)),s=6;break;case 1:attrName=source.slice(start,p),s=2;break;case 4:var value=source.slice(start,p).replace(/&#?\w+;/g,entityReplacer);errorHandler.warning('attribute "'+value+'" missed quot(")!!'),addAttribute(attrName,value,start);case 5:s=6}else switch(s){case 2:el.tagName,NAMESPACE$1.isHTML(currentNSMap[""])&&attrName.match(/^(?:disabled|checked|selected)$/i)||errorHandler.warning('attribute "'+attrName+'" missed value!! "'+attrName+'" instead2!!'),addAttribute(attrName,attrName,start),start=p,s=1;break;case 5:errorHandler.warning('attribute space is required"'+attrName+'"!!');case 6:s=1,start=p;break;case 3:s=4,start=p;break;case 7:throw new Error("elements closed character '/' and '>' must be connected to")}}p++}}function appendElement$1(el,domBuilder,currentNSMap){for(var tagName=el.tagName,localNSMap=null,i=el.length;i--;){var a=el[i],qName=a.qName,value=a.value;if((nsp=qName.indexOf(":"))>0)var prefix=a.prefix=qName.slice(0,nsp),localName=qName.slice(nsp+1),nsPrefix="xmlns"===prefix&&localName;else localName=qName,prefix=null,nsPrefix="xmlns"===qName&&"";a.localName=localName,!1!==nsPrefix&&(null==localNSMap&&(localNSMap={},_copy(currentNSMap,currentNSMap={})),currentNSMap[nsPrefix]=localNSMap[nsPrefix]=value,a.uri=NAMESPACE$1.XMLNS,domBuilder.startPrefixMapping(nsPrefix,value))}for(i=el.length;i--;){(prefix=(a=el[i]).prefix)&&("xml"===prefix&&(a.uri=NAMESPACE$1.XML),"xmlns"!==prefix&&(a.uri=currentNSMap[prefix||""]))}var nsp;(nsp=tagName.indexOf(":"))>0?(prefix=el.prefix=tagName.slice(0,nsp),localName=el.localName=tagName.slice(nsp+1)):(prefix=null,localName=el.localName=tagName);var ns=el.uri=currentNSMap[prefix||""];if(domBuilder.startElement(ns,localName,tagName,el),!el.closed)return el.currentNSMap=currentNSMap,el.localNSMap=localNSMap,!0;if(domBuilder.endElement(ns,localName,tagName),localNSMap)for(prefix in localNSMap)domBuilder.endPrefixMapping(prefix)}function parseHtmlSpecialContent(source,elStartEnd,tagName,entityReplacer,domBuilder){if(/^(?:script|textarea)$/i.test(tagName)){var elEndStart=source.indexOf("</"+tagName+">",elStartEnd),text=source.substring(elStartEnd+1,elEndStart);if(/[&<]/.test(text))return/^script$/i.test(tagName)?(domBuilder.characters(text,0,text.length),elEndStart):(text=text.replace(/&#?\w+;/g,entityReplacer),domBuilder.characters(text,0,text.length),elEndStart)}return elStartEnd+1}function fixSelfClosed(source,elStartEnd,tagName,closeMap){var pos=closeMap[tagName];return null==pos&&((pos=source.lastIndexOf("</"+tagName+">"))<elStartEnd&&(pos=source.lastIndexOf("</"+tagName)),closeMap[tagName]=pos),pos<elStartEnd}function _copy(source,target){for(var n in source)target[n]=source[n]}function parseDCC(source,start,domBuilder,errorHandler){if("-"===source.charAt(start+2))return"-"===source.charAt(start+3)?(end=source.indexOf("--\x3e",start+4))>start?(domBuilder.comment(source,start+4,end-start-4),end+3):(errorHandler.error("Unclosed comment"),-1):-1;if("CDATA["==source.substr(start+3,6)){var end=source.indexOf("]]>",start+9);return domBuilder.startCDATA(),domBuilder.characters(source,start+9,end-start-9),domBuilder.endCDATA(),end+3}var matchs=function(source,start){var match,buf=[],reg=/'[^']+'|"[^"]+"|[^\s<>\/=]+=?|(\/?\s*>|<)/g;reg.lastIndex=start,reg.exec(source);for(;match=reg.exec(source);)if(buf.push(match),match[1])return buf}(source,start),len=matchs.length;if(len>1&&/!doctype/i.test(matchs[0][0])){var name=matchs[1][0],pubid=!1,sysid=!1;len>3&&(/^public$/i.test(matchs[2][0])?(pubid=matchs[3][0],sysid=len>4&&matchs[4][0]):/^system$/i.test(matchs[2][0])&&(sysid=matchs[3][0]));var lastMatch=matchs[len-1];return domBuilder.startDTD(name,pubid,sysid),domBuilder.endDTD(),lastMatch.index+lastMatch[0].length}return-1}function parseInstruction(source,start,domBuilder){var end=source.indexOf("?>",start);if(end){var match=source.substring(start,end).match(/^<\?(\S*)\s*([\s\S]*?)\s*$/);return match?(match[0].length,domBuilder.processingInstruction(match[1],match[2]),end+2):-1}return-1}function ElementAttributes(){this.attributeNames={}}ParseError$1.prototype=new Error,ParseError$1.prototype.name=ParseError$1.name,XMLReader$1.prototype={parse:function(source,defaultNSMap,entityMap){var domBuilder=this.domBuilder;domBuilder.startDocument(),_copy(defaultNSMap,defaultNSMap={}),function(source,defaultNSMapCopy,entityMap,domBuilder,errorHandler){function fixedFromCharCode(code){if(code>65535){var surrogate1=55296+((code-=65536)>>10),surrogate2=56320+(1023&code);return String.fromCharCode(surrogate1,surrogate2)}return String.fromCharCode(code)}function entityReplacer(a){var k=a.slice(1,-1);return k in entityMap?entityMap[k]:"#"===k.charAt(0)?fixedFromCharCode(parseInt(k.substr(1).replace("x","0x"))):(errorHandler.error("entity not found:"+a),a)}function appendText(end){if(end>start){var xt=source.substring(start,end).replace(/&#?\w+;/g,entityReplacer);locator&&position(start),domBuilder.characters(xt,0,end-start),start=end}}function position(p,m){for(;p>=lineEnd&&(m=linePattern.exec(source));)lineStart=m.index,lineEnd=lineStart+m[0].length,locator.lineNumber++;locator.columnNumber=p-lineStart+1}var lineStart=0,lineEnd=0,linePattern=/.*(?:\r\n?|\n)|.*$/g,locator=domBuilder.locator,parseStack=[{currentNSMap:defaultNSMapCopy}],closeMap={},start=0;for(;;){try{var tagStart=source.indexOf("<",start);if(tagStart<0){if(!source.substr(start).match(/^\s*$/)){var doc=domBuilder.doc,text=doc.createTextNode(source.substr(start));doc.appendChild(text),domBuilder.currentElement=text}return}switch(tagStart>start&&appendText(tagStart),source.charAt(tagStart+1)){case"/":var end=source.indexOf(">",tagStart+3),tagName=source.substring(tagStart+2,end).replace(/[ \t\n\r]+$/g,""),config=parseStack.pop();end<0?(tagName=source.substring(tagStart+2).replace(/[\s<].*/,""),errorHandler.error("end tag name: "+tagName+" is not complete:"+config.tagName),end=tagStart+1+tagName.length):tagName.match(/\s</)&&(tagName=tagName.replace(/[\s<].*/,""),errorHandler.error("end tag name: "+tagName+" maybe not complete"),end=tagStart+1+tagName.length);var localNSMap=config.localNSMap,endMatch=config.tagName==tagName;if(endMatch||config.tagName&&config.tagName.toLowerCase()==tagName.toLowerCase()){if(domBuilder.endElement(config.uri,config.localName,tagName),localNSMap)for(var prefix in localNSMap)domBuilder.endPrefixMapping(prefix);endMatch||errorHandler.fatalError("end tag name: "+tagName+" is not match the current start tagName:"+config.tagName)}else parseStack.push(config);end++;break;case"?":locator&&position(tagStart),end=parseInstruction(source,tagStart,domBuilder);break;case"!":locator&&position(tagStart),end=parseDCC(source,tagStart,domBuilder,errorHandler);break;default:locator&&position(tagStart);var el=new ElementAttributes,currentNSMap=parseStack[parseStack.length-1].currentNSMap,len=(end=parseElementStartPart(source,tagStart,el,currentNSMap,entityReplacer,errorHandler),el.length);if(!el.closed&&fixSelfClosed(source,end,el.tagName,closeMap)&&(el.closed=!0,entityMap.nbsp||errorHandler.warning("unclosed xml attribute")),locator&&len){for(var locator2=copyLocator(locator,{}),i=0;i<len;i++){var a=el[i];position(a.offset),a.locator=copyLocator(locator,{})}domBuilder.locator=locator2,appendElement$1(el,domBuilder,currentNSMap)&&parseStack.push(el),domBuilder.locator=locator}else appendElement$1(el,domBuilder,currentNSMap)&&parseStack.push(el);NAMESPACE$1.isHTML(el.uri)&&!el.closed?end=parseHtmlSpecialContent(source,end,el.tagName,entityReplacer,domBuilder):end++}}catch(e){if(e instanceof ParseError$1)throw e;errorHandler.error("element parse error: "+e),end=-1}end>start?start=end:appendText(Math.max(tagStart,start)+1)}}(source,defaultNSMap,entityMap,domBuilder,this.errorHandler),domBuilder.endDocument()}},ElementAttributes.prototype={setTagName:function(tagName){if(!tagNamePattern.test(tagName))throw new Error("invalid tagName:"+tagName);this.tagName=tagName},addValue:function(qName,value,offset){if(!tagNamePattern.test(qName))throw new Error("invalid attribute:"+qName);this.attributeNames[qName]=this.length,this[this.length++]={qName:qName,value:value,offset:offset}},length:0,getLocalName:function(i){return this[i].localName},getLocator:function(i){return this[i].locator},getQName:function(i){return this[i].qName},getURI:function(i){return this[i].uri},getValue:function(i){return this[i].value}};var sax={XMLReader:XMLReader$1,ParseError:ParseError$1},DOMImplementation=dom.DOMImplementation,NAMESPACE=conventions.NAMESPACE,ParseError=sax.ParseError,XMLReader=sax.XMLReader;function DOMParser$1(options){this.options=options||{locator:{}}}function DOMHandler(){this.cdata=!1}function position(locator,node){node.lineNumber=locator.lineNumber,node.columnNumber=locator.columnNumber}function _locator(l){if(l)return"\n@"+(l.systemId||"")+"#[line:"+l.lineNumber+",col:"+l.columnNumber+"]"}function _toString(chars,start,length){return"string"==typeof chars?chars.substr(start,length):chars.length>=start+length||start?new java.lang.String(chars,start,length)+"":chars}function appendElement(hander,node){hander.currentElement?hander.currentElement.appendChild(node):hander.doc.appendChild(node)}DOMParser$1.prototype.parseFromString=function(source,mimeType){var options=this.options,sax=new XMLReader,domBuilder=options.domBuilder||new DOMHandler,errorHandler=options.errorHandler,locator=options.locator,defaultNSMap=options.xmlns||{},isHTML=/\/x?html?$/.test(mimeType),entityMap=isHTML?entities.HTML_ENTITIES:entities.XML_ENTITIES;return locator&&domBuilder.setDocumentLocator(locator),sax.errorHandler=function(errorImpl,domBuilder,locator){if(!errorImpl){if(domBuilder instanceof DOMHandler)return domBuilder;errorImpl=domBuilder}var errorHandler={},isCallback=errorImpl instanceof Function;function build(key){var fn=errorImpl[key];!fn&&isCallback&&(fn=2==errorImpl.length?function(msg){errorImpl(key,msg)}:errorImpl),errorHandler[key]=fn&&function(msg){fn("[xmldom "+key+"]\t"+msg+_locator(locator))}||function(){}}return locator=locator||{},build("warning"),build("error"),build("fatalError"),errorHandler}(errorHandler,domBuilder,locator),sax.domBuilder=options.domBuilder||domBuilder,isHTML&&(defaultNSMap[""]=NAMESPACE.HTML),defaultNSMap.xml=defaultNSMap.xml||NAMESPACE.XML,source&&"string"==typeof source?sax.parse(source,defaultNSMap,entityMap):sax.errorHandler.error("invalid doc source"),domBuilder.doc},DOMHandler.prototype={startDocument:function(){this.doc=(new DOMImplementation).createDocument(null,null,null),this.locator&&(this.doc.documentURI=this.locator.systemId)},startElement:function(namespaceURI,localName,qName,attrs){var doc=this.doc,el=doc.createElementNS(namespaceURI,qName||localName),len=attrs.length;appendElement(this,el),this.currentElement=el,this.locator&&position(this.locator,el);for(var i=0;i<len;i++){namespaceURI=attrs.getURI(i);var value=attrs.getValue(i),attr=(qName=attrs.getQName(i),doc.createAttributeNS(namespaceURI,qName));this.locator&&position(attrs.getLocator(i),attr),attr.value=attr.nodeValue=value,el.setAttributeNode(attr)}},endElement:function(namespaceURI,localName,qName){var current=this.currentElement;current.tagName,this.currentElement=current.parentNode},startPrefixMapping:function(prefix,uri){},endPrefixMapping:function(prefix){},processingInstruction:function(target,data){var ins=this.doc.createProcessingInstruction(target,data);this.locator&&position(this.locator,ins),appendElement(this,ins)},ignorableWhitespace:function(ch,start,length){},characters:function(chars,start,length){if(chars=_toString.apply(this,arguments)){if(this.cdata)var charNode=this.doc.createCDATASection(chars);else charNode=this.doc.createTextNode(chars);this.currentElement?this.currentElement.appendChild(charNode):/^\s*$/.test(chars)&&this.doc.appendChild(charNode),this.locator&&position(this.locator,charNode)}},skippedEntity:function(name){},endDocument:function(){this.doc.normalize()},setDocumentLocator:function(locator){(this.locator=locator)&&(locator.lineNumber=0)},comment:function(chars,start,length){chars=_toString.apply(this,arguments);var comm=this.doc.createComment(chars);this.locator&&position(this.locator,comm),appendElement(this,comm)},startCDATA:function(){this.cdata=!0},endCDATA:function(){this.cdata=!1},startDTD:function(name,publicId,systemId){var impl=this.doc.implementation;if(impl&&impl.createDocumentType){var dt=impl.createDocumentType(name,publicId,systemId);this.locator&&position(this.locator,dt),appendElement(this,dt),this.doc.doctype=dt}},warning:function(error){console.warn("[xmldom warning]\t"+error,_locator(this.locator))},error:function(_error){console.error("[xmldom error]\t"+_error,_locator(this.locator))},fatalError:function(error){throw new ParseError(error,this.locator)}},"endDTD,startEntity,endEntity,attributeDecl,elementDecl,externalEntityDecl,internalEntityDecl,resolveEntity,getExternalSubset,notationDecl,unparsedEntityDecl".replace(/\w+/g,(function(key){DOMHandler.prototype[key]=function(){return null}}));var DOMParser={__DOMHandler:DOMHandler,DOMParser:DOMParser$1,DOMImplementation:dom.DOMImplementation,XMLSerializer:dom.XMLSerializer}.DOMParser,isObject=function(obj){return!!obj&&"object"==typeof obj},merge=function merge(){for(var _len=arguments.length,objects=new Array(_len),_key=0;_key<_len;_key++)objects[_key]=arguments[_key];return objects.reduce((function(result,source){return"object"!=typeof source||Object.keys(source).forEach((function(key){Array.isArray(result[key])&&Array.isArray(source[key])?result[key]=result[key].concat(source[key]):isObject(result[key])&&isObject(source[key])?result[key]=merge(result[key],source[key]):result[key]=source[key]})),result}),{})},flatten=function(lists){return lists.reduce((function(x,y){return x.concat(y)}),[])},from=function(list){if(!list.length)return[];for(var result=[],i=0;i<list.length;i++)result.push(list[i]);return result},errors_INVALID_NUMBER_OF_PERIOD="INVALID_NUMBER_OF_PERIOD",errors_DASH_EMPTY_MANIFEST="DASH_EMPTY_MANIFEST",errors_DASH_INVALID_XML="DASH_INVALID_XML",errors_NO_BASE_URL="NO_BASE_URL",errors_SEGMENT_TIME_UNSPECIFIED="SEGMENT_TIME_UNSPECIFIED",errors_UNSUPPORTED_UTC_TIMING_SCHEME="UNSUPPORTED_UTC_TIMING_SCHEME",urlTypeToSegment=function(_ref){var _ref$baseUrl=_ref.baseUrl,baseUrl=void 0===_ref$baseUrl?"":_ref$baseUrl,_ref$source=_ref.source,source=void 0===_ref$source?"":_ref$source,_ref$range=_ref.range,range=void 0===_ref$range?"":_ref$range,_ref$indexRange=_ref.indexRange,indexRange=void 0===_ref$indexRange?"":_ref$indexRange,segment={uri:source,resolvedUri:resolveUrl$1(baseUrl||"",source)};if(range||indexRange){var ranges=(range||indexRange).split("-"),startRange=parseInt(ranges[0],10),endRange=parseInt(ranges[1],10);segment.byterange={length:endRange-startRange+1,offset:startRange}}return segment},parseEndNumber=function(endNumber){return endNumber&&"number"!=typeof endNumber&&(endNumber=parseInt(endNumber,10)),isNaN(endNumber)?null:endNumber},segmentRange={static:function(attributes){var duration=attributes.duration,_attributes$timescale=attributes.timescale,timescale=void 0===_attributes$timescale?1:_attributes$timescale,sourceDuration=attributes.sourceDuration,periodDuration=attributes.periodDuration,endNumber=parseEndNumber(attributes.endNumber),segmentDuration=duration/timescale;return"number"==typeof endNumber?{start:0,end:endNumber}:"number"==typeof periodDuration?{start:0,end:periodDuration/segmentDuration}:{start:0,end:sourceDuration/segmentDuration}},dynamic:function(attributes){var NOW=attributes.NOW,clientOffset=attributes.clientOffset,availabilityStartTime=attributes.availabilityStartTime,_attributes$timescale2=attributes.timescale,timescale=void 0===_attributes$timescale2?1:_attributes$timescale2,duration=attributes.duration,_attributes$start=attributes.start,start=void 0===_attributes$start?0:_attributes$start,_attributes$minimumUp=attributes.minimumUpdatePeriod,minimumUpdatePeriod=void 0===_attributes$minimumUp?0:_attributes$minimumUp,_attributes$timeShift=attributes.timeShiftBufferDepth,timeShiftBufferDepth=void 0===_attributes$timeShift?1/0:_attributes$timeShift,endNumber=parseEndNumber(attributes.endNumber),now=(NOW+clientOffset)/1e3,periodStartWC=availabilityStartTime+start,periodDuration=now+minimumUpdatePeriod-periodStartWC,segmentCount=Math.ceil(periodDuration*timescale/duration),availableStart=Math.floor((now-periodStartWC-timeShiftBufferDepth)*timescale/duration),availableEnd=Math.floor((now-periodStartWC)*timescale/duration);return{start:Math.max(0,availableStart),end:"number"==typeof endNumber?endNumber:Math.min(segmentCount,availableEnd)}}},parseByDuration=function(attributes){var type=attributes.type,duration=attributes.duration,_attributes$timescale4=attributes.timescale,timescale=void 0===_attributes$timescale4?1:_attributes$timescale4,periodDuration=attributes.periodDuration,sourceDuration=attributes.sourceDuration,_segmentRange$type=segmentRange[type](attributes),segments=function(start,end){for(var result=[],i=start;i<end;i++)result.push(i);return result}(_segmentRange$type.start,_segmentRange$type.end).map(function(attributes){return function(number,index){var duration=attributes.duration,_attributes$timescale3=attributes.timescale,timescale=void 0===_attributes$timescale3?1:_attributes$timescale3,periodIndex=attributes.periodIndex,_attributes$startNumb=attributes.startNumber;return{number:(void 0===_attributes$startNumb?1:_attributes$startNumb)+number,duration:duration/timescale,timeline:periodIndex,time:index*duration}}}(attributes));if("static"===type){var index=segments.length-1,sectionDuration="number"==typeof periodDuration?periodDuration:sourceDuration;segments[index].duration=sectionDuration-duration/timescale*index}return segments},segmentsFromBase=function(attributes){var baseUrl=attributes.baseUrl,_attributes$initializ=attributes.initialization,initialization=void 0===_attributes$initializ?{}:_attributes$initializ,sourceDuration=attributes.sourceDuration,_attributes$indexRang=attributes.indexRange,indexRange=void 0===_attributes$indexRang?"":_attributes$indexRang,duration=attributes.duration;if(!baseUrl)throw new Error(errors_NO_BASE_URL);var initSegment=urlTypeToSegment({baseUrl:baseUrl,source:initialization.sourceURL,range:initialization.range}),segment=urlTypeToSegment({baseUrl:baseUrl,source:baseUrl,indexRange:indexRange});if(segment.map=initSegment,duration){var segmentTimeInfo=parseByDuration(attributes);segmentTimeInfo.length&&(segment.duration=segmentTimeInfo[0].duration,segment.timeline=segmentTimeInfo[0].timeline)}else sourceDuration&&(segment.duration=sourceDuration,segment.timeline=0);return segment.number=0,[segment]},addSidxSegmentsToPlaylist=function(playlist,sidx,baseUrl){for(var initSegment=playlist.sidx.map?playlist.sidx.map:null,sourceDuration=playlist.sidx.duration,timeline=playlist.timeline||0,sidxByteRange=playlist.sidx.byterange,sidxEnd=sidxByteRange.offset+sidxByteRange.length,timescale=sidx.timescale,mediaReferences=sidx.references.filter((function(r){return 1!==r.referenceType})),segments=[],type=playlist.endList?"static":"dynamic",startIndex=sidxEnd+sidx.firstOffset,i=0;i<mediaReferences.length;i++){var reference=sidx.references[i],size=reference.referencedSize,duration=reference.subsegmentDuration,segment=segmentsFromBase({baseUrl:baseUrl,timescale:timescale,timeline:timeline,periodIndex:timeline,duration:duration,sourceDuration:sourceDuration,indexRange:startIndex+"-"+(startIndex+size-1),type:type})[0];initSegment&&(segment.map=initSegment),segments.push(segment),startIndex+=size}return playlist.segments=segments,playlist},generateSidxKey=function(sidx){return sidx&&sidx.uri+"-"+(byterange=sidx.byterange,endRange=byterange.offset+byterange.length-1,byterange.offset+"-"+endRange);var byterange,endRange},mergeDiscontiguousPlaylists=function(playlists){var o;return(o=playlists.reduce((function(acc,playlist){var _acc$name$segments,name=playlist.attributes.id+(playlist.attributes.lang||"");return acc[name]?(playlist.segments[0]&&(playlist.segments[0].discontinuity=!0),(_acc$name$segments=acc[name].segments).push.apply(_acc$name$segments,playlist.segments),playlist.attributes.contentProtection&&(acc[name].attributes.contentProtection=playlist.attributes.contentProtection)):acc[name]=playlist,acc}),{}),Object.keys(o).map((function(k){return o[k]}))).map((function(playlist){var l,key;return playlist.discontinuityStarts=(l=playlist.segments,key="discontinuity",l.reduce((function(a,e,i){return e[key]&&a.push(i),a}),[])),playlist}))},addSidxSegmentsToPlaylist$1=function(playlist,sidxMapping){var sidxKey=generateSidxKey(playlist.sidx),sidxMatch=sidxKey&&sidxMapping[sidxKey]&&sidxMapping[sidxKey].sidx;return sidxMatch&&addSidxSegmentsToPlaylist(playlist,sidxMatch,playlist.sidx.resolvedUri),playlist},addSidxSegmentsToPlaylists=function(playlists,sidxMapping){if(void 0===sidxMapping&&(sidxMapping={}),!Object.keys(sidxMapping).length)return playlists;for(var i in playlists)playlists[i]=addSidxSegmentsToPlaylist$1(playlists[i],sidxMapping);return playlists},formatVideoPlaylist=function(_ref3){var _attributes2,attributes=_ref3.attributes,segments=_ref3.segments,sidx=_ref3.sidx,playlist={attributes:(_attributes2={NAME:attributes.id,AUDIO:"audio",SUBTITLES:"subs",RESOLUTION:{width:attributes.width,height:attributes.height},CODECS:attributes.codecs,BANDWIDTH:attributes.bandwidth},_attributes2["PROGRAM-ID"]=1,_attributes2),uri:"",endList:"static"===attributes.type,timeline:attributes.periodIndex,resolvedUri:"",targetDuration:attributes.duration,segments:segments,mediaSequence:segments.length?segments[0].number:1};return attributes.contentProtection&&(playlist.contentProtection=attributes.contentProtection),sidx&&(playlist.sidx=sidx),playlist},videoOnly=function(_ref4){var attributes=_ref4.attributes;return"video/mp4"===attributes.mimeType||"video/webm"===attributes.mimeType||"video"===attributes.contentType},audioOnly=function(_ref5){var attributes=_ref5.attributes;return"audio/mp4"===attributes.mimeType||"audio/webm"===attributes.mimeType||"audio"===attributes.contentType},vttOnly=function(_ref6){var attributes=_ref6.attributes;return"text/vtt"===attributes.mimeType||"text"===attributes.contentType},toM3u8=function(dashPlaylists,locations,sidxMapping){var _mediaGroups;if(void 0===sidxMapping&&(sidxMapping={}),!dashPlaylists.length)return{};var _dashPlaylists$0$attr=dashPlaylists[0].attributes,duration=_dashPlaylists$0$attr.sourceDuration,type=_dashPlaylists$0$attr.type,suggestedPresentationDelay=_dashPlaylists$0$attr.suggestedPresentationDelay,minimumUpdatePeriod=_dashPlaylists$0$attr.minimumUpdatePeriod,videoPlaylists=mergeDiscontiguousPlaylists(dashPlaylists.filter(videoOnly)).map(formatVideoPlaylist),audioPlaylists=mergeDiscontiguousPlaylists(dashPlaylists.filter(audioOnly)),vttPlaylists=dashPlaylists.filter(vttOnly),captions=dashPlaylists.map((function(playlist){return playlist.attributes.captionServices})).filter(Boolean),manifest={allowCache:!0,discontinuityStarts:[],segments:[],endList:!0,mediaGroups:(_mediaGroups={AUDIO:{},VIDEO:{}},_mediaGroups["CLOSED-CAPTIONS"]={},_mediaGroups.SUBTITLES={},_mediaGroups),uri:"",duration:duration,playlists:addSidxSegmentsToPlaylists(videoPlaylists,sidxMapping)};minimumUpdatePeriod>=0&&(manifest.minimumUpdatePeriod=1e3*minimumUpdatePeriod),locations&&(manifest.locations=locations),"dynamic"===type&&(manifest.suggestedPresentationDelay=suggestedPresentationDelay);var isAudioOnly=0===manifest.playlists.length;return audioPlaylists.length&&(manifest.mediaGroups.AUDIO.audio=function(playlists,sidxMapping,isAudioOnly){var mainPlaylist;void 0===sidxMapping&&(sidxMapping={}),void 0===isAudioOnly&&(isAudioOnly=!1);var formattedPlaylists=playlists.reduce((function(a,playlist){var role=playlist.attributes.role&&playlist.attributes.role.value||"",language=playlist.attributes.lang||"",label=playlist.attributes.label||"main";if(language&&!playlist.attributes.label){var roleLabel=role?" ("+role+")":"";label=""+playlist.attributes.lang+roleLabel}a[label]||(a[label]={language:language,autoselect:!0,default:"main"===role,playlists:[],uri:""});var formatted=addSidxSegmentsToPlaylist$1(function(_ref,isAudioOnly){var _attributes,attributes=_ref.attributes,segments=_ref.segments,sidx=_ref.sidx,playlist={attributes:(_attributes={NAME:attributes.id,BANDWIDTH:attributes.bandwidth,CODECS:attributes.codecs},_attributes["PROGRAM-ID"]=1,_attributes),uri:"",endList:"static"===attributes.type,timeline:attributes.periodIndex,resolvedUri:"",targetDuration:attributes.duration,segments:segments,mediaSequence:segments.length?segments[0].number:1};return attributes.contentProtection&&(playlist.contentProtection=attributes.contentProtection),sidx&&(playlist.sidx=sidx),isAudioOnly&&(playlist.attributes.AUDIO="audio",playlist.attributes.SUBTITLES="subs"),playlist}(playlist,isAudioOnly),sidxMapping);return a[label].playlists.push(formatted),void 0===mainPlaylist&&"main"===role&&((mainPlaylist=playlist).default=!0),a}),{});return mainPlaylist||(formattedPlaylists[Object.keys(formattedPlaylists)[0]].default=!0),formattedPlaylists}(audioPlaylists,sidxMapping,isAudioOnly)),vttPlaylists.length&&(manifest.mediaGroups.SUBTITLES.subs=function(playlists,sidxMapping){return void 0===sidxMapping&&(sidxMapping={}),playlists.reduce((function(a,playlist){var label=playlist.attributes.lang||"text";return a[label]||(a[label]={language:label,default:!1,autoselect:!1,playlists:[],uri:""}),a[label].playlists.push(addSidxSegmentsToPlaylist$1(function(_ref2){var _m3u8Attributes,attributes=_ref2.attributes,segments=_ref2.segments;void 0===segments&&(segments=[{uri:attributes.baseUrl,timeline:attributes.periodIndex,resolvedUri:attributes.baseUrl||"",duration:attributes.sourceDuration,number:0}],attributes.duration=attributes.sourceDuration);var m3u8Attributes=((_m3u8Attributes={NAME:attributes.id,BANDWIDTH:attributes.bandwidth})["PROGRAM-ID"]=1,_m3u8Attributes);return attributes.codecs&&(m3u8Attributes.CODECS=attributes.codecs),{attributes:m3u8Attributes,uri:"",endList:"static"===attributes.type,timeline:attributes.periodIndex,resolvedUri:attributes.baseUrl||"",targetDuration:attributes.duration,segments:segments,mediaSequence:segments.length?segments[0].number:1}}(playlist),sidxMapping)),a}),{})}(vttPlaylists,sidxMapping)),captions.length&&(manifest.mediaGroups["CLOSED-CAPTIONS"].cc=captions.reduce((function(svcObj,svc){return svc?(svc.forEach((function(service){var channel=service.channel,language=service.language;svcObj[language]={autoselect:!1,default:!1,instreamId:channel,language:language},service.hasOwnProperty("aspectRatio")&&(svcObj[language].aspectRatio=service.aspectRatio),service.hasOwnProperty("easyReader")&&(svcObj[language].easyReader=service.easyReader),service.hasOwnProperty("3D")&&(svcObj[language]["3D"]=service["3D"])})),svcObj):svcObj}),{})),manifest},getLiveRValue=function(attributes,time,duration){var NOW=attributes.NOW,clientOffset=attributes.clientOffset,availabilityStartTime=attributes.availabilityStartTime,_attributes$timescale=attributes.timescale,timescale=void 0===_attributes$timescale?1:_attributes$timescale,_attributes$start=attributes.start,start=void 0===_attributes$start?0:_attributes$start,_attributes$minimumUp=attributes.minimumUpdatePeriod,periodDuration=(NOW+clientOffset)/1e3+(void 0===_attributes$minimumUp?0:_attributes$minimumUp)-(availabilityStartTime+start);return Math.ceil((periodDuration*timescale-time)/duration)},parseByTimeline=function(attributes,segmentTimeline){for(var type=attributes.type,_attributes$minimumUp2=attributes.minimumUpdatePeriod,minimumUpdatePeriod=void 0===_attributes$minimumUp2?0:_attributes$minimumUp2,_attributes$media=attributes.media,media=void 0===_attributes$media?"":_attributes$media,sourceDuration=attributes.sourceDuration,_attributes$timescale2=attributes.timescale,timescale=void 0===_attributes$timescale2?1:_attributes$timescale2,_attributes$startNumb=attributes.startNumber,startNumber=void 0===_attributes$startNumb?1:_attributes$startNumb,timeline=attributes.periodIndex,segments=[],time=-1,sIndex=0;sIndex<segmentTimeline.length;sIndex++){var S=segmentTimeline[sIndex],duration=S.d,repeat=S.r||0,segmentTime=S.t||0;time<0&&(time=segmentTime),segmentTime&&segmentTime>time&&(time=segmentTime);var count=void 0;if(repeat<0){var nextS=sIndex+1;count=nextS===segmentTimeline.length?"dynamic"===type&&minimumUpdatePeriod>0&&media.indexOf("$Number$")>0?getLiveRValue(attributes,time,duration):(sourceDuration*timescale-time)/duration:(segmentTimeline[nextS].t-time)/duration}else count=repeat+1;for(var end=startNumber+segments.length+count,number=startNumber+segments.length;number<end;)segments.push({number:number,duration:duration/timescale,time:time,timeline:timeline}),time+=duration,number++}return segments},identifierPattern=/\$([A-z]*)(?:(%0)([0-9]+)d)?\$/g,constructTemplateUrl=function(url,values){return url.replace(identifierPattern,function(values){return function(match,identifier,format,width){if("$$"===match)return"$";if(void 0===values[identifier])return match;var value=""+values[identifier];return"RepresentationID"===identifier?value:(width=format?parseInt(width,10):1,value.length>=width?value:""+new Array(width-value.length+1).join("0")+value)}}(values))},segmentsFromTemplate=function(attributes,segmentTimeline){var templateValues={RepresentationID:attributes.id,Bandwidth:attributes.bandwidth||0},_attributes$initializ=attributes.initialization,initialization=void 0===_attributes$initializ?{sourceURL:"",range:""}:_attributes$initializ,mapSegment=urlTypeToSegment({baseUrl:attributes.baseUrl,source:constructTemplateUrl(initialization.sourceURL,templateValues),range:initialization.range}),segments=function(attributes,segmentTimeline){return attributes.duration||segmentTimeline?attributes.duration?parseByDuration(attributes):parseByTimeline(attributes,segmentTimeline):[{number:attributes.startNumber||1,duration:attributes.sourceDuration,time:0,timeline:attributes.periodIndex}]}(attributes,segmentTimeline);return segments.map((function(segment){templateValues.Number=segment.number,templateValues.Time=segment.time;var uri=constructTemplateUrl(attributes.media||"",templateValues),timescale=attributes.timescale||1,presentationTimeOffset=attributes.presentationTimeOffset||0,presentationTime=attributes.periodStart+(segment.time-presentationTimeOffset)/timescale;return{uri:uri,timeline:segment.timeline,duration:segment.duration,resolvedUri:resolveUrl$1(attributes.baseUrl||"",uri),map:mapSegment,number:segment.number,presentationTime:presentationTime}}))},segmentsFromList=function(attributes,segmentTimeline){var duration=attributes.duration,_attributes$segmentUr=attributes.segmentUrls,segmentUrls=void 0===_attributes$segmentUr?[]:_attributes$segmentUr,periodStart=attributes.periodStart;if(!duration&&!segmentTimeline||duration&&segmentTimeline)throw new Error(errors_SEGMENT_TIME_UNSPECIFIED);var segmentTimeInfo,segmentUrlMap=segmentUrls.map((function(segmentUrlObject){return function(attributes,segmentUrl){var baseUrl=attributes.baseUrl,_attributes$initializ=attributes.initialization,initialization=void 0===_attributes$initializ?{}:_attributes$initializ,initSegment=urlTypeToSegment({baseUrl:baseUrl,source:initialization.sourceURL,range:initialization.range}),segment=urlTypeToSegment({baseUrl:baseUrl,source:segmentUrl.media,range:segmentUrl.mediaRange});return segment.map=initSegment,segment}(attributes,segmentUrlObject)}));return duration&&(segmentTimeInfo=parseByDuration(attributes)),segmentTimeline&&(segmentTimeInfo=parseByTimeline(attributes,segmentTimeline)),segmentTimeInfo.map((function(segmentTime,index){if(segmentUrlMap[index]){var segment=segmentUrlMap[index],timescale=attributes.timescale||1,presentationTimeOffset=attributes.presentationTimeOffset||0;return segment.timeline=segmentTime.timeline,segment.duration=segmentTime.duration,segment.number=segmentTime.number,segment.presentationTime=periodStart+(segmentTime.time-presentationTimeOffset)/timescale,segment}})).filter((function(segment){return segment}))},generateSegments=function(_ref){var segmentAttributes,segmentsFn,attributes=_ref.attributes,segmentInfo=_ref.segmentInfo;segmentInfo.template?(segmentsFn=segmentsFromTemplate,segmentAttributes=merge(attributes,segmentInfo.template)):segmentInfo.base?(segmentsFn=segmentsFromBase,segmentAttributes=merge(attributes,segmentInfo.base)):segmentInfo.list&&(segmentsFn=segmentsFromList,segmentAttributes=merge(attributes,segmentInfo.list));var segmentsInfo={attributes:attributes};if(!segmentsFn)return segmentsInfo;var segments=segmentsFn(segmentAttributes,segmentInfo.segmentTimeline);if(segmentAttributes.duration){var _segmentAttributes=segmentAttributes,duration=_segmentAttributes.duration,_segmentAttributes$ti=_segmentAttributes.timescale,timescale=void 0===_segmentAttributes$ti?1:_segmentAttributes$ti;segmentAttributes.duration=duration/timescale}else segments.length?segmentAttributes.duration=segments.reduce((function(max,segment){return Math.max(max,Math.ceil(segment.duration))}),0):segmentAttributes.duration=0;return segmentsInfo.attributes=segmentAttributes,segmentsInfo.segments=segments,segmentInfo.base&&segmentAttributes.indexRange&&(segmentsInfo.sidx=segments[0],segmentsInfo.segments=[]),segmentsInfo},findChildren=function(element,name){return from(element.childNodes).filter((function(_ref){return _ref.tagName===name}))},getContent=function(element){return element.textContent.trim()},parseDuration=function(str){var match=/P(?:(\d*)Y)?(?:(\d*)M)?(?:(\d*)D)?(?:T(?:(\d*)H)?(?:(\d*)M)?(?:([\d.]*)S)?)?/.exec(str);if(!match)return 0;var _match$slice=match.slice(1),year=_match$slice[0],month=_match$slice[1],day=_match$slice[2],hour=_match$slice[3],minute=_match$slice[4],second=_match$slice[5];return 31536e3*parseFloat(year||0)+2592e3*parseFloat(month||0)+86400*parseFloat(day||0)+3600*parseFloat(hour||0)+60*parseFloat(minute||0)+parseFloat(second||0)},parsers={mediaPresentationDuration:function(value){return parseDuration(value)},availabilityStartTime:function(value){return/^\d+-\d+-\d+T\d+:\d+:\d+(\.\d+)?$/.test(str=value)&&(str+="Z"),Date.parse(str)/1e3;var str},minimumUpdatePeriod:function(value){return parseDuration(value)},suggestedPresentationDelay:function(value){return parseDuration(value)},type:function(value){return value},timeShiftBufferDepth:function(value){return parseDuration(value)},start:function(value){return parseDuration(value)},width:function(value){return parseInt(value,10)},height:function(value){return parseInt(value,10)},bandwidth:function(value){return parseInt(value,10)},startNumber:function(value){return parseInt(value,10)},timescale:function(value){return parseInt(value,10)},presentationTimeOffset:function(value){return parseInt(value,10)},duration:function(value){var parsedValue=parseInt(value,10);return isNaN(parsedValue)?parseDuration(value):parsedValue},d:function(value){return parseInt(value,10)},t:function(value){return parseInt(value,10)},r:function(value){return parseInt(value,10)},DEFAULT:function(value){return value}},parseAttributes=function(el){return el&&el.attributes?from(el.attributes).reduce((function(a,e){var parseFn=parsers[e.name]||parsers.DEFAULT;return a[e.name]=parseFn(e.value),a}),{}):{}},keySystemsMap={"urn:uuid:1077efec-c0b2-4d02-ace3-3c1e52e2fb4b":"org.w3.clearkey","urn:uuid:edef8ba9-79d6-4ace-a3c8-27dcd51d21ed":"com.widevine.alpha","urn:uuid:9a04f079-9840-4286-ab92-e65be0885f95":"com.microsoft.playready","urn:uuid:f239e769-efa3-4850-9c16-a903c6932efb":"com.adobe.primetime"},buildBaseUrls=function(referenceUrls,baseUrlElements){return baseUrlElements.length?flatten(referenceUrls.map((function(reference){return baseUrlElements.map((function(baseUrlElement){return resolveUrl$1(reference,getContent(baseUrlElement))}))}))):referenceUrls},getSegmentInformation=function(adaptationSet){var segmentTemplate=findChildren(adaptationSet,"SegmentTemplate")[0],segmentList=findChildren(adaptationSet,"SegmentList")[0],segmentUrls=segmentList&&findChildren(segmentList,"SegmentURL").map((function(s){return merge({tag:"SegmentURL"},parseAttributes(s))})),segmentBase=findChildren(adaptationSet,"SegmentBase")[0],segmentTimelineParentNode=segmentList||segmentTemplate,segmentTimeline=segmentTimelineParentNode&&findChildren(segmentTimelineParentNode,"SegmentTimeline")[0],segmentInitializationParentNode=segmentList||segmentBase||segmentTemplate,segmentInitialization=segmentInitializationParentNode&&findChildren(segmentInitializationParentNode,"Initialization")[0],template=segmentTemplate&&parseAttributes(segmentTemplate);template&&segmentInitialization?template.initialization=segmentInitialization&&parseAttributes(segmentInitialization):template&&template.initialization&&(template.initialization={sourceURL:template.initialization});var segmentInfo={template:template,segmentTimeline:segmentTimeline&&findChildren(segmentTimeline,"S").map((function(s){return parseAttributes(s)})),list:segmentList&&merge(parseAttributes(segmentList),{segmentUrls:segmentUrls,initialization:parseAttributes(segmentInitialization)}),base:segmentBase&&merge(parseAttributes(segmentBase),{initialization:parseAttributes(segmentInitialization)})};return Object.keys(segmentInfo).forEach((function(key){segmentInfo[key]||delete segmentInfo[key]})),segmentInfo},toRepresentations=function(periodAttributes,periodBaseUrls,periodSegmentInfo){return function(adaptationSet){var service,adaptationSetAttributes=parseAttributes(adaptationSet),adaptationSetBaseUrls=buildBaseUrls(periodBaseUrls,findChildren(adaptationSet,"BaseURL")),role=findChildren(adaptationSet,"Role")[0],roleAttributes={role:parseAttributes(role)},attrs=merge(periodAttributes,adaptationSetAttributes,roleAttributes),accessibility=findChildren(adaptationSet,"Accessibility")[0],captionServices="urn:scte:dash:cc:cea-608:2015"===(service=parseAttributes(accessibility)).schemeIdUri?("string"!=typeof service.value?[]:service.value.split(";")).map((function(value){var channel,language;if(language=value,/^CC\d=/.test(value)){var _value$split=value.split("=");channel=_value$split[0],language=_value$split[1]}else/^CC\d$/.test(value)&&(channel=value);return{channel:channel,language:language}})):"urn:scte:dash:cc:cea-708:2015"===service.schemeIdUri?("string"!=typeof service.value?[]:service.value.split(";")).map((function(value){var flags={channel:void 0,language:void 0,aspectRatio:1,easyReader:0,"3D":0};if(/=/.test(value)){var _value$split2=value.split("="),channel=_value$split2[0],_value$split2$=_value$split2[1],opts=void 0===_value$split2$?"":_value$split2$;flags.channel=channel,flags.language=value,opts.split(",").forEach((function(opt){var _opt$split=opt.split(":"),name=_opt$split[0],val=_opt$split[1];"lang"===name?flags.language=val:"er"===name?flags.easyReader=Number(val):"war"===name?flags.aspectRatio=Number(val):"3D"===name&&(flags["3D"]=Number(val))}))}else flags.language=value;return flags.channel&&(flags.channel="SERVICE"+flags.channel),flags})):void 0;captionServices&&(attrs=merge(attrs,{captionServices:captionServices}));var label=findChildren(adaptationSet,"Label")[0];if(label&&label.childNodes.length){var labelVal=label.childNodes[0].nodeValue.trim();attrs=merge(attrs,{label:labelVal})}var contentProtection=findChildren(adaptationSet,"ContentProtection").reduce((function(acc,node){var attributes=parseAttributes(node),keySystem=keySystemsMap[attributes.schemeIdUri];if(keySystem){acc[keySystem]={attributes:attributes};var psshNode=findChildren(node,"cenc:pssh")[0];if(psshNode){var pssh=getContent(psshNode),psshBuffer=pssh&&decodeB64ToUint8Array(pssh);acc[keySystem].pssh=psshBuffer}}return acc}),{});Object.keys(contentProtection).length&&(attrs=merge(attrs,{contentProtection:contentProtection}));var segmentInfo=getSegmentInformation(adaptationSet),representations=findChildren(adaptationSet,"Representation"),adaptationSetSegmentInfo=merge(periodSegmentInfo,segmentInfo);return flatten(representations.map(function(adaptationSetAttributes,adaptationSetBaseUrls,adaptationSetSegmentInfo){return function(representation){var repBaseUrlElements=findChildren(representation,"BaseURL"),repBaseUrls=buildBaseUrls(adaptationSetBaseUrls,repBaseUrlElements),attributes=merge(adaptationSetAttributes,parseAttributes(representation)),representationSegmentInfo=getSegmentInformation(representation);return repBaseUrls.map((function(baseUrl){return{segmentInfo:merge(adaptationSetSegmentInfo,representationSegmentInfo),attributes:merge(attributes,{baseUrl:baseUrl})}}))}}(attrs,adaptationSetBaseUrls,adaptationSetSegmentInfo)))}},toAdaptationSets=function(mpdAttributes,mpdBaseUrls){return function(period,index){var periodBaseUrls=buildBaseUrls(mpdBaseUrls,findChildren(period.node,"BaseURL")),parsedPeriodId=parseInt(period.attributes.id,10),periodIndex=window.isNaN(parsedPeriodId)?index:parsedPeriodId,periodAttributes=merge(mpdAttributes,{periodIndex:periodIndex,periodStart:period.attributes.start});"number"==typeof period.attributes.duration&&(periodAttributes.periodDuration=period.attributes.duration);var adaptationSets=findChildren(period.node,"AdaptationSet"),periodSegmentInfo=getSegmentInformation(period.node);return flatten(adaptationSets.map(toRepresentations(periodAttributes,periodBaseUrls,periodSegmentInfo)))}},stringToMpdXml=function(manifestString){if(""===manifestString)throw new Error(errors_DASH_EMPTY_MANIFEST);var xml,mpd,parser=new DOMParser;try{mpd=(xml=parser.parseFromString(manifestString,"application/xml"))&&"MPD"===xml.documentElement.tagName?xml.documentElement:null}catch(e){}if(!mpd||mpd&&mpd.getElementsByTagName("parsererror").length>0)throw new Error(errors_DASH_INVALID_XML);return mpd},parse=function(manifestString,options){void 0===options&&(options={});var parsedManifestInfo=function(mpd,options){void 0===options&&(options={});var _options=options,_options$manifestUri=_options.manifestUri,manifestUri=void 0===_options$manifestUri?"":_options$manifestUri,_options$NOW=_options.NOW,NOW=void 0===_options$NOW?Date.now():_options$NOW,_options$clientOffset=_options.clientOffset,clientOffset=void 0===_options$clientOffset?0:_options$clientOffset,periodNodes=findChildren(mpd,"Period");if(!periodNodes.length)throw new Error(errors_INVALID_NUMBER_OF_PERIOD);var locations=findChildren(mpd,"Location"),mpdAttributes=parseAttributes(mpd),mpdBaseUrls=buildBaseUrls([manifestUri],findChildren(mpd,"BaseURL"));mpdAttributes.type=mpdAttributes.type||"static",mpdAttributes.sourceDuration=mpdAttributes.mediaPresentationDuration||0,mpdAttributes.NOW=NOW,mpdAttributes.clientOffset=clientOffset,locations.length&&(mpdAttributes.locations=locations.map(getContent));var periods=[];return periodNodes.forEach((function(node,index){var attributes=parseAttributes(node),priorPeriod=periods[index-1];attributes.start=function(_ref){var attributes=_ref.attributes,priorPeriodAttributes=_ref.priorPeriodAttributes,mpdType=_ref.mpdType;return"number"==typeof attributes.start?attributes.start:priorPeriodAttributes&&"number"==typeof priorPeriodAttributes.start&&"number"==typeof priorPeriodAttributes.duration?priorPeriodAttributes.start+priorPeriodAttributes.duration:priorPeriodAttributes||"static"!==mpdType?null:0}({attributes:attributes,priorPeriodAttributes:priorPeriod?priorPeriod.attributes:null,mpdType:mpdAttributes.type}),periods.push({node:node,attributes:attributes})})),{locations:mpdAttributes.locations,representationInfo:flatten(periods.map(toAdaptationSets(mpdAttributes,mpdBaseUrls)))}}(stringToMpdXml(manifestString),options),playlists=parsedManifestInfo.representationInfo.map(generateSegments);return toM3u8(playlists,parsedManifestInfo.locations,options.sidxMapping)},parseUTCTiming=function(manifestString){return function(mpd){var UTCTimingNode=findChildren(mpd,"UTCTiming")[0];if(!UTCTimingNode)return null;var attributes=parseAttributes(UTCTimingNode);switch(attributes.schemeIdUri){case"urn:mpeg:dash:utc:http-head:2014":case"urn:mpeg:dash:utc:http-head:2012":attributes.method="HEAD";break;case"urn:mpeg:dash:utc:http-xsdate:2014":case"urn:mpeg:dash:utc:http-iso:2014":case"urn:mpeg:dash:utc:http-xsdate:2012":case"urn:mpeg:dash:utc:http-iso:2012":attributes.method="GET";break;case"urn:mpeg:dash:utc:direct:2014":case"urn:mpeg:dash:utc:direct:2012":attributes.method="DIRECT",attributes.value=Date.parse(attributes.value);break;default:throw new Error(errors_UNSUPPORTED_UTC_TIMING_SCHEME)}return attributes}(stringToMpdXml(manifestString))},MAX_UINT32=Math.pow(2,32),parseSidx_1=function(data){var view=new DataView(data.buffer,data.byteOffset,data.byteLength),result={version:data[0],flags:new Uint8Array(data.subarray(1,4)),references:[],referenceId:view.getUint32(4),timescale:view.getUint32(8)},i=12;0===result.version?(result.earliestPresentationTime=view.getUint32(i),result.firstOffset=view.getUint32(i+4),i+=8):(result.earliestPresentationTime=view.getUint32(i)*MAX_UINT32+view.getUint32(i+4),result.firstOffset=view.getUint32(i+8)*MAX_UINT32+view.getUint32(i+12),i+=16),i+=2;var referenceCount=view.getUint16(i);for(i+=2;referenceCount>0;i+=12,referenceCount--)result.references.push({referenceType:(128&data[i])>>>7,referencedSize:2147483647&view.getUint32(i),subsegmentDuration:view.getUint32(i+4),startsWithSap:!!(128&data[i+8]),sapType:(112&data[i+8])>>>4,sapDeltaTime:268435455&view.getUint32(i+8)});return result},toUint8=function(bytes){return bytes instanceof Uint8Array?bytes:(Array.isArray(bytes)||(obj=bytes,ArrayBuffer.isView(obj))||bytes instanceof ArrayBuffer||(bytes="number"!=typeof bytes||"number"==typeof bytes&&bytes!=bytes?0:[bytes]),new Uint8Array(bytes&&bytes.buffer||bytes,bytes&&bytes.byteOffset||0,bytes&&bytes.byteLength||0));var obj},BigInt=window.BigInt||Number,BYTE_TABLE=[BigInt("0x1"),BigInt("0x100"),BigInt("0x10000"),BigInt("0x1000000"),BigInt("0x100000000"),BigInt("0x10000000000"),BigInt("0x1000000000000"),BigInt("0x100000000000000"),BigInt("0x10000000000000000")],bytesToNumber=function(bytes,_temp){var _ref=void 0===_temp?{}:_temp,_ref$signed=_ref.signed,signed=void 0!==_ref$signed&&_ref$signed,_ref$le=_ref.le,le=void 0!==_ref$le&&_ref$le;bytes=toUint8(bytes);var fn=le?"reduce":"reduceRight",number=(bytes[fn]?bytes[fn]:Array.prototype[fn]).call(bytes,(function(total,_byte,i){var exponent=le?i:Math.abs(i+1-bytes.length);return total+BigInt(_byte)*BYTE_TABLE[exponent]}),BigInt(0));if(signed){var max=BYTE_TABLE[bytes.length]/BigInt(2)-BigInt(1);(number=BigInt(number))>max&&(number-=max,number-=max,number-=BigInt(2))}return Number(number)},numberToBytes=function(number,_temp2){var _ref2$le=(void 0===_temp2?{}:_temp2).le,le=void 0!==_ref2$le&&_ref2$le;("bigint"!=typeof number&&"number"!=typeof number||"number"==typeof number&&number!=number)&&(number=0),number=BigInt(number);for(var x,byteCount=(x=number,Math.ceil(function(x){return x.toString(2).length}(x)/8)),bytes=new Uint8Array(new ArrayBuffer(byteCount)),i=0;i<byteCount;i++){var byteIndex=le?i:Math.abs(i+1-bytes.length);bytes[byteIndex]=Number(number/BYTE_TABLE[i]&BigInt(255)),number<0&&(bytes[byteIndex]=Math.abs(~bytes[byteIndex]),bytes[byteIndex]-=0===i?1:2)}return bytes},stringToBytes=function(string,stringIsBytes){if("string"!=typeof string&&string&&"function"==typeof string.toString&&(string=string.toString()),"string"!=typeof string)return new Uint8Array;stringIsBytes||(string=unescape(encodeURIComponent(string)));for(var view=new Uint8Array(string.length),i=0;i<string.length;i++)view[i]=string.charCodeAt(i);return view},bytesMatch=function(a,b,_temp3){var _ref3=void 0===_temp3?{}:_temp3,_ref3$offset=_ref3.offset,offset=void 0===_ref3$offset?0:_ref3$offset,_ref3$mask=_ref3.mask,mask=void 0===_ref3$mask?[]:_ref3$mask;a=toUint8(a);var fn=(b=toUint8(b)).every?b.every:Array.prototype.every;return b.length&&a.length-offset>=b.length&&fn.call(b,(function(bByte,i){return bByte===(mask[i]?mask[i]&a[offset+i]:a[offset+i])}))},ID3=toUint8([73,68,51]),getId3Offset=function getId3Offset(bytes,offset){return void 0===offset&&(offset=0),(bytes=toUint8(bytes)).length-offset<10||!bytesMatch(bytes,ID3,{offset:offset})?offset:(offset+=function(bytes,offset){void 0===offset&&(offset=0);var flags=(bytes=toUint8(bytes))[offset+5],returnSize=bytes[offset+6]<<21|bytes[offset+7]<<14|bytes[offset+8]<<7|bytes[offset+9];return(16&flags)>>4?returnSize+20:returnSize+10}(bytes,offset),getId3Offset(bytes,offset))},normalizePath$1=function(path){return"string"==typeof path?stringToBytes(path):path},findBox=function findBox(bytes,paths,complete){void 0===complete&&(complete=!1),paths=function(paths){return Array.isArray(paths)?paths.map((function(p){return normalizePath$1(p)})):[normalizePath$1(paths)]}(paths),bytes=toUint8(bytes);var results=[];if(!paths.length)return results;for(var i=0;i<bytes.length;){var size=(bytes[i]<<24|bytes[i+1]<<16|bytes[i+2]<<8|bytes[i+3])>>>0,type=bytes.subarray(i+4,i+8);if(0===size)break;var end=i+size;if(end>bytes.length){if(complete)break;end=bytes.length}var data=bytes.subarray(i+8,end);bytesMatch(type,paths[0])&&(1===paths.length?results.push(data):results.push.apply(results,findBox(data,paths.slice(1),complete))),i=end}return results},EBML_TAGS={EBML:toUint8([26,69,223,163]),DocType:toUint8([66,130]),Segment:toUint8([24,83,128,103]),SegmentInfo:toUint8([21,73,169,102]),Tracks:toUint8([22,84,174,107]),Track:toUint8([174]),TrackNumber:toUint8([215]),DefaultDuration:toUint8([35,227,131]),TrackEntry:toUint8([174]),TrackType:toUint8([131]),FlagDefault:toUint8([136]),CodecID:toUint8([134]),CodecPrivate:toUint8([99,162]),VideoTrack:toUint8([224]),AudioTrack:toUint8([225]),Cluster:toUint8([31,67,182,117]),Timestamp:toUint8([231]),TimestampScale:toUint8([42,215,177]),BlockGroup:toUint8([160]),BlockDuration:toUint8([155]),Block:toUint8([161]),SimpleBlock:toUint8([163])},LENGTH_TABLE=[128,64,32,16,8,4,2,1],getvint=function(bytes,offset,removeLength,signed){void 0===removeLength&&(removeLength=!0),void 0===signed&&(signed=!1);var length=function(_byte){for(var len=1,i=0;i<LENGTH_TABLE.length&&!(_byte&LENGTH_TABLE[i]);i++)len++;return len}(bytes[offset]),valueBytes=bytes.subarray(offset,offset+length);return removeLength&&((valueBytes=Array.prototype.slice.call(bytes,offset,offset+length))[0]^=LENGTH_TABLE[length-1]),{length:length,value:bytesToNumber(valueBytes,{signed:signed}),bytes:valueBytes}},normalizePath=function normalizePath(path){return"string"==typeof path?path.match(/.{1,2}/g).map((function(p){return normalizePath(p)})):"number"==typeof path?numberToBytes(path):path},getInfinityDataSize=function getInfinityDataSize(id,bytes,offset){if(offset>=bytes.length)return bytes.length;var innerid=getvint(bytes,offset,!1);if(bytesMatch(id.bytes,innerid.bytes))return offset;var dataHeader=getvint(bytes,offset+innerid.length);return getInfinityDataSize(id,bytes,offset+dataHeader.length+dataHeader.value+innerid.length)},findEbml=function findEbml(bytes,paths){paths=function(paths){return Array.isArray(paths)?paths.map((function(p){return normalizePath(p)})):[normalizePath(paths)]}(paths),bytes=toUint8(bytes);var results=[];if(!paths.length)return results;for(var i=0;i<bytes.length;){var id=getvint(bytes,i,!1),dataHeader=getvint(bytes,i+id.length),dataStart=i+id.length+dataHeader.length;127===dataHeader.value&&(dataHeader.value=getInfinityDataSize(id,bytes,dataStart),dataHeader.value!==bytes.length&&(dataHeader.value-=dataStart));var dataEnd=dataStart+dataHeader.value>bytes.length?bytes.length:dataStart+dataHeader.value,data=bytes.subarray(dataStart,dataEnd);bytesMatch(paths[0],id.bytes)&&(1===paths.length?results.push(data):results=results.concat(findEbml(data,paths.slice(1)))),i+=id.length+dataHeader.length+data.length}return results},NAL_TYPE_ONE=toUint8([0,0,0,1]),NAL_TYPE_TWO=toUint8([0,0,1]),EMULATION_PREVENTION=toUint8([0,0,3]),discardEmulationPreventionBytes=function(bytes){for(var positions=[],i=1;i<bytes.length-2;)bytesMatch(bytes.subarray(i,i+3),EMULATION_PREVENTION)&&(positions.push(i+2),i++),i++;if(0===positions.length)return bytes;var newLength=bytes.length-positions.length,newData=new Uint8Array(newLength),sourceIndex=0;for(i=0;i<newLength;sourceIndex++,i++)sourceIndex===positions[0]&&(sourceIndex++,positions.shift()),newData[i]=bytes[sourceIndex];return newData},findNal=function(bytes,dataType,types,nalLimit){void 0===nalLimit&&(nalLimit=1/0),bytes=toUint8(bytes),types=[].concat(types);for(var nalStart,i=0,nalsFound=0;i<bytes.length&&(nalsFound<nalLimit||nalStart);){var nalOffset=void 0;if(bytesMatch(bytes.subarray(i),NAL_TYPE_ONE)?nalOffset=4:bytesMatch(bytes.subarray(i),NAL_TYPE_TWO)&&(nalOffset=3),nalOffset){if(nalsFound++,nalStart)return discardEmulationPreventionBytes(bytes.subarray(nalStart,i));var nalType=void 0;"h264"===dataType?nalType=31&bytes[i+nalOffset]:"h265"===dataType&&(nalType=bytes[i+nalOffset]>>1&63),-1!==types.indexOf(nalType)&&(nalStart=i+nalOffset),i+=nalOffset+("h264"===dataType?1:2)}else i++}return bytes.subarray(0,0)},CONSTANTS={webm:toUint8([119,101,98,109]),matroska:toUint8([109,97,116,114,111,115,107,97]),flac:toUint8([102,76,97,67]),ogg:toUint8([79,103,103,83]),ac3:toUint8([11,119]),riff:toUint8([82,73,70,70]),avi:toUint8([65,86,73]),wav:toUint8([87,65,86,69]),"3gp":toUint8([102,116,121,112,51,103]),mp4:toUint8([102,116,121,112]),fmp4:toUint8([115,116,121,112]),mov:toUint8([102,116,121,112,113,116]),moov:toUint8([109,111,111,118]),moof:toUint8([109,111,111,102])},_isLikely={aac:function(bytes){var offset=getId3Offset(bytes);return bytesMatch(bytes,[255,16],{offset:offset,mask:[255,22]})},mp3:function(bytes){var offset=getId3Offset(bytes);return bytesMatch(bytes,[255,2],{offset:offset,mask:[255,6]})},webm:function(bytes){var docType=findEbml(bytes,[EBML_TAGS.EBML,EBML_TAGS.DocType])[0];return bytesMatch(docType,CONSTANTS.webm)},mkv:function(bytes){var docType=findEbml(bytes,[EBML_TAGS.EBML,EBML_TAGS.DocType])[0];return bytesMatch(docType,CONSTANTS.matroska)},mp4:function(bytes){return!_isLikely["3gp"](bytes)&&!_isLikely.mov(bytes)&&(!(!bytesMatch(bytes,CONSTANTS.mp4,{offset:4})&&!bytesMatch(bytes,CONSTANTS.fmp4,{offset:4}))||(!(!bytesMatch(bytes,CONSTANTS.moof,{offset:4})&&!bytesMatch(bytes,CONSTANTS.moov,{offset:4}))||void 0))},mov:function(bytes){return bytesMatch(bytes,CONSTANTS.mov,{offset:4})},"3gp":function(bytes){return bytesMatch(bytes,CONSTANTS["3gp"],{offset:4})},ac3:function(bytes){var offset=getId3Offset(bytes);return bytesMatch(bytes,CONSTANTS.ac3,{offset:offset})},ts:function(bytes){if(bytes.length<189&&bytes.length>=1)return 71===bytes[0];for(var i=0;i+188<bytes.length&&i<188;){if(71===bytes[i]&&71===bytes[i+188])return!0;i+=1}return!1},flac:function(bytes){var offset=getId3Offset(bytes);return bytesMatch(bytes,CONSTANTS.flac,{offset:offset})},ogg:function(bytes){return bytesMatch(bytes,CONSTANTS.ogg)},avi:function(bytes){return bytesMatch(bytes,CONSTANTS.riff)&&bytesMatch(bytes,CONSTANTS.avi,{offset:8})},wav:function(bytes){return bytesMatch(bytes,CONSTANTS.riff)&&bytesMatch(bytes,CONSTANTS.wav,{offset:8})},h264:function(bytes){return function(bytes,type,nalLimit){return findNal(bytes,"h264",type,nalLimit)}(bytes,7,3).length},h265:function(bytes){return function(bytes,type,nalLimit){return findNal(bytes,"h265",type,nalLimit)}(bytes,[32,33],3).length}},isLikelyTypes=Object.keys(_isLikely).filter((function(t){return"ts"!==t&&"h264"!==t&&"h265"!==t})).concat(["ts","h264","h265"]);isLikelyTypes.forEach((function(type){var isLikelyFn=_isLikely[type];_isLikely[type]=function(bytes){return isLikelyFn(toUint8(bytes))}}));var secondsToVideoTs,secondsToAudioTs,videoTsToSeconds,audioTsToSeconds,isLikely=_isLikely,detectContainerForBytes=function(bytes){bytes=toUint8(bytes);for(var i=0;i<isLikelyTypes.length;i++){var type=isLikelyTypes[i];if(isLikely[type](bytes))return type}return""};secondsToVideoTs=function(seconds){return 9e4*seconds},secondsToAudioTs=function(seconds,sampleRate){return seconds*sampleRate},videoTsToSeconds=function(timestamp){return timestamp/9e4},audioTsToSeconds=function(timestamp,sampleRate){return timestamp/sampleRate};var clock_1=9e4,resolveUrl=function(baseUrl,relativeUrl){if(/^[a-z]+:/i.test(relativeUrl))return relativeUrl;/^data:/.test(baseUrl)&&(baseUrl=window.location&&window.location.href||"");var nativeURL="function"==typeof window.URL,protocolLess=/^\/\//.test(baseUrl),removeLocation=!window.location&&!/\/\//i.test(baseUrl);if(nativeURL?baseUrl=new window.URL(baseUrl,window.location||"http://example.com"):/\/\//i.test(baseUrl)||(baseUrl=urlToolkit.buildAbsoluteURL(window.location&&window.location.href||"",baseUrl)),nativeURL){var newUrl=new URL(relativeUrl,baseUrl);return removeLocation?newUrl.href.slice("http://example.com".length):protocolLess?newUrl.href.slice(newUrl.protocol.length):newUrl.href}return urlToolkit.buildAbsoluteURL(baseUrl,relativeUrl)},resolveManifestRedirect=function(handleManifestRedirect,url,req){return handleManifestRedirect&&req&&req.responseURL&&url!==req.responseURL?req.responseURL:url},logger=function(source){return videojs.log.debug?videojs.log.debug.bind(videojs,"VHS:",source+" >"):function(){}},filterRanges=function(timeRanges,predicate){var i,results=[];if(timeRanges&&timeRanges.length)for(i=0;i<timeRanges.length;i++)predicate(timeRanges.start(i),timeRanges.end(i))&&results.push([timeRanges.start(i),timeRanges.end(i)]);return videojs.createTimeRanges(results)},findRange=function(buffered,time){return filterRanges(buffered,(function(start,end){return start-.1<=time&&end+.1>=time}))},findNextRange=function(timeRanges,time){return filterRanges(timeRanges,(function(start){return start-.03333333333333333>=time}))},printableRange=function(range){var strArr=[];if(!range||!range.length)return"";for(var i=0;i<range.length;i++)strArr.push(range.start(i)+" => "+range.end(i));return strArr.join(", ")},timeRangesToArray=function(timeRanges){for(var timeRangesList=[],i=0;i<timeRanges.length;i++)timeRangesList.push({start:timeRanges.start(i),end:timeRanges.end(i)});return timeRangesList},lastBufferedEnd=function(a){if(a&&a.length&&a.end)return a.end(a.length-1)},timeAheadOf=function(range,startTime){var time=0;if(!range||!range.length)return time;for(var i=0;i<range.length;i++){var start=range.start(i),end=range.end(i);startTime>end||(time+=startTime>start&&startTime<=end?end-startTime:end-start)}return time},createTimeRange=videojs.createTimeRange,segmentDurationWithParts=function(playlist,segment){if(!segment.preload)return segment.duration;var result=0;return(segment.parts||[]).forEach((function(p){result+=p.duration})),(segment.preloadHints||[]).forEach((function(p){"PART"===p.type&&(result+=playlist.partTargetDuration)})),result},getPartsAndSegments=function(playlist){return(playlist.segments||[]).reduce((function(acc,segment,si){return segment.parts?segment.parts.forEach((function(part,pi){acc.push({duration:part.duration,segmentIndex:si,partIndex:pi,part:part,segment:segment})})):acc.push({duration:segment.duration,segmentIndex:si,partIndex:null,segment:segment,part:null}),acc}),[])},getLastParts=function(media){var lastSegment=media.segments&&media.segments.length&&media.segments[media.segments.length-1];return lastSegment&&lastSegment.parts||[]},getKnownPartCount=function(_ref){var preloadSegment=_ref.preloadSegment;if(preloadSegment){var parts=preloadSegment.parts,partCount=(preloadSegment.preloadHints||[]).reduce((function(count,hint){return count+("PART"===hint.type?1:0)}),0);return partCount+=parts&&parts.length?parts.length:0}},liveEdgeDelay=function(master,media){if(media.endList)return 0;if(master&&master.suggestedPresentationDelay)return master.suggestedPresentationDelay;var hasParts=getLastParts(media).length>0;return hasParts&&media.serverControl&&media.serverControl.partHoldBack?media.serverControl.partHoldBack:hasParts&&media.partTargetDuration?3*media.partTargetDuration:media.serverControl&&media.serverControl.holdBack?media.serverControl.holdBack:media.targetDuration?3*media.targetDuration:0},intervalDuration=function(playlist,endSequence,expired){if(void 0===endSequence&&(endSequence=playlist.mediaSequence+playlist.segments.length),endSequence<playlist.mediaSequence)return 0;var backward=function(playlist,endSequence){var result=0,i=endSequence-playlist.mediaSequence,segment=playlist.segments[i];if(segment){if(void 0!==segment.start)return{result:segment.start,precise:!0};if(void 0!==segment.end)return{result:segment.end-segment.duration,precise:!0}}for(;i--;){if(void 0!==(segment=playlist.segments[i]).end)return{result:result+segment.end,precise:!0};if(result+=segmentDurationWithParts(playlist,segment),void 0!==segment.start)return{result:result+segment.start,precise:!0}}return{result:result,precise:!1}}(playlist,endSequence);if(backward.precise)return backward.result;var forward=function(playlist,endSequence){for(var segment,result=0,i=endSequence-playlist.mediaSequence;i<playlist.segments.length;i++){if(void 0!==(segment=playlist.segments[i]).start)return{result:segment.start-result,precise:!0};if(result+=segmentDurationWithParts(playlist,segment),void 0!==segment.end)return{result:segment.end-result,precise:!0}}return{result:-1,precise:!1}}(playlist,endSequence);return forward.precise?forward.result:backward.result+expired},duration=function(playlist,endSequence,expired){if(!playlist)return 0;if("number"!=typeof expired&&(expired=0),void 0===endSequence){if(playlist.totalDuration)return playlist.totalDuration;if(!playlist.endList)return window.Infinity}return intervalDuration(playlist,endSequence,expired)},sumDurations=function(_ref2){var defaultDuration=_ref2.defaultDuration,durationList=_ref2.durationList,startIndex=_ref2.startIndex,endIndex=_ref2.endIndex,durations=0;if(startIndex>endIndex){var _ref3=[endIndex,startIndex];startIndex=_ref3[0],endIndex=_ref3[1]}if(startIndex<0){for(var i=startIndex;i<Math.min(0,endIndex);i++)durations+=defaultDuration;startIndex=0}for(var _i=startIndex;_i<endIndex;_i++)durations+=durationList[_i].duration;return durations},playlistEnd=function(playlist,expired,useSafeLiveEnd,liveEdgePadding){if(!playlist||!playlist.segments)return null;if(playlist.endList)return duration(playlist);if(null===expired)return null;expired=expired||0;var lastSegmentEndTime=intervalDuration(playlist,playlist.mediaSequence+playlist.segments.length,expired);return useSafeLiveEnd&&(lastSegmentEndTime-=liveEdgePadding="number"==typeof liveEdgePadding?liveEdgePadding:liveEdgeDelay(null,playlist)),Math.max(0,lastSegmentEndTime)},isBlacklisted=function(playlist){return playlist.excludeUntil&&playlist.excludeUntil>Date.now()},isIncompatible=function(playlist){return playlist.excludeUntil&&playlist.excludeUntil===1/0},isEnabled=function(playlist){var blacklisted=isBlacklisted(playlist);return!playlist.disabled&&!blacklisted},hasAttribute=function(attr,playlist){return playlist.attributes&&playlist.attributes[attr]},isLowestEnabledRendition=function(master,media){if(1===master.playlists.length)return!0;var currentBandwidth=media.attributes.BANDWIDTH||Number.MAX_VALUE;return 0===master.playlists.filter((function(playlist){return!!isEnabled(playlist)&&(playlist.attributes.BANDWIDTH||0)<currentBandwidth})).length},playlistMatch=function(a,b){return!(!a&&!b||!a&&b||a&&!b)&&(a===b||(!(!a.id||!b.id||a.id!==b.id)||(!(!a.resolvedUri||!b.resolvedUri||a.resolvedUri!==b.resolvedUri)||!(!a.uri||!b.uri||a.uri!==b.uri))))},someAudioVariant=function(master,callback){var AUDIO=master&&master.mediaGroups&&master.mediaGroups.AUDIO||{},found=!1;for(var groupName in AUDIO){for(var label in AUDIO[groupName])if(found=callback(AUDIO[groupName][label]))break;if(found)break}return!!found},isAudioOnly=function(master){if(!master||!master.playlists||!master.playlists.length)return someAudioVariant(master,(function(variant){return variant.playlists&&variant.playlists.length||variant.uri}));for(var _loop=function(i){var playlist=master.playlists[i],CODECS=playlist.attributes&&playlist.attributes.CODECS;return CODECS&&CODECS.split(",").every((function(c){return isAudioCodec(c)}))||someAudioVariant(master,(function(variant){return playlistMatch(playlist,variant)}))?"continue":{v:!1}},i=0;i<master.playlists.length;i++){var _ret=_loop(i);if("continue"!==_ret&&"object"==typeof _ret)return _ret.v}return!0},Playlist={liveEdgeDelay:liveEdgeDelay,duration:duration,seekable:function(playlist,expired,liveEdgePadding){var seekableStart=expired||0,seekableEnd=playlistEnd(playlist,expired,!0,liveEdgePadding);return null===seekableEnd?createTimeRange():createTimeRange(seekableStart,seekableEnd)},getMediaInfoForTime:function(_ref4){for(var playlist=_ref4.playlist,currentTime=_ref4.currentTime,startingSegmentIndex=_ref4.startingSegmentIndex,startingPartIndex=_ref4.startingPartIndex,startTime=_ref4.startTime,experimentalExactManifestTimings=_ref4.experimentalExactManifestTimings,time=currentTime-startTime,partsAndSegments=getPartsAndSegments(playlist),startIndex=0,i=0;i<partsAndSegments.length;i++){var partAndSegment=partsAndSegments[i];if(startingSegmentIndex===partAndSegment.segmentIndex&&("number"!=typeof startingPartIndex||"number"!=typeof partAndSegment.partIndex||startingPartIndex===partAndSegment.partIndex)){startIndex=i;break}}if(time<0){if(startIndex>0)for(var _i2=startIndex-1;_i2>=0;_i2--){var _partAndSegment=partsAndSegments[_i2];if(time+=_partAndSegment.duration,experimentalExactManifestTimings){if(time<0)continue}else if(time+.03333333333333333<=0)continue;return{partIndex:_partAndSegment.partIndex,segmentIndex:_partAndSegment.segmentIndex,startTime:startTime-sumDurations({defaultDuration:playlist.targetDuration,durationList:partsAndSegments,startIndex:startIndex,endIndex:_i2})}}return{partIndex:partsAndSegments[0]&&partsAndSegments[0].partIndex||null,segmentIndex:partsAndSegments[0]&&partsAndSegments[0].segmentIndex||0,startTime:currentTime}}if(startIndex<0){for(var _i3=startIndex;_i3<0;_i3++)if((time-=playlist.targetDuration)<0)return{partIndex:partsAndSegments[0]&&partsAndSegments[0].partIndex||null,segmentIndex:partsAndSegments[0]&&partsAndSegments[0].segmentIndex||0,startTime:currentTime};startIndex=0}for(var _i4=startIndex;_i4<partsAndSegments.length;_i4++){var _partAndSegment2=partsAndSegments[_i4];if(time-=_partAndSegment2.duration,experimentalExactManifestTimings){if(time>0)continue}else if(time-.03333333333333333>=0)continue;return{partIndex:_partAndSegment2.partIndex,segmentIndex:_partAndSegment2.segmentIndex,startTime:startTime+sumDurations({defaultDuration:playlist.targetDuration,durationList:partsAndSegments,startIndex:startIndex,endIndex:_i4})}}return{segmentIndex:partsAndSegments[partsAndSegments.length-1].segmentIndex,partIndex:partsAndSegments[partsAndSegments.length-1].partIndex,startTime:currentTime}},isEnabled:isEnabled,isDisabled:function(playlist){return playlist.disabled},isBlacklisted:isBlacklisted,isIncompatible:isIncompatible,playlistEnd:playlistEnd,isAes:function(media){for(var i=0;i<media.segments.length;i++)if(media.segments[i].key)return!0;return!1},hasAttribute:hasAttribute,estimateSegmentRequestTime:function(segmentDuration,bandwidth,playlist,bytesReceived){return void 0===bytesReceived&&(bytesReceived=0),hasAttribute("BANDWIDTH",playlist)?(segmentDuration*playlist.attributes.BANDWIDTH-8*bytesReceived)/bandwidth:NaN},isLowestEnabledRendition:isLowestEnabledRendition,isAudioOnly:isAudioOnly,playlistMatch:playlistMatch,segmentDurationWithParts:segmentDurationWithParts},log=videojs.log,createPlaylistID=function(index,uri){return index+"-"+uri},forEachMediaGroup=function(master,callback){master.mediaGroups&&["AUDIO","SUBTITLES"].forEach((function(mediaType){if(master.mediaGroups[mediaType])for(var groupKey in master.mediaGroups[mediaType])for(var labelKey in master.mediaGroups[mediaType][groupKey]){var mediaProperties=master.mediaGroups[mediaType][groupKey][labelKey];callback(mediaProperties,mediaType,groupKey,labelKey)}}))},setupMediaPlaylist=function(_ref2){var playlist=_ref2.playlist,uri=_ref2.uri,id=_ref2.id;playlist.id=id,playlist.playlistErrors_=0,uri&&(playlist.uri=uri),playlist.attributes=playlist.attributes||{}},addPropertiesToMaster=function(master,uri){master.uri=uri;for(var i=0;i<master.playlists.length;i++)if(!master.playlists[i].uri){var phonyUri="placeholder-uri-"+i;master.playlists[i].uri=phonyUri}var audioOnlyMaster=isAudioOnly(master);forEachMediaGroup(master,(function(properties,mediaType,groupKey,labelKey){var groupId="placeholder-uri-"+mediaType+"-"+groupKey+"-"+labelKey;if(!properties.playlists||!properties.playlists.length){if(audioOnlyMaster&&"AUDIO"===mediaType&&!properties.uri)for(var _i=0;_i<master.playlists.length;_i++){var p=master.playlists[_i];if(p.attributes&&p.attributes.AUDIO&&p.attributes.AUDIO===groupKey)return}properties.playlists=[_extends_1({},properties)]}properties.playlists.forEach((function(p,i){var id=createPlaylistID(i,groupId);p.uri?p.resolvedUri=p.resolvedUri||resolveUrl(master.uri,p.uri):(p.uri=0===i?groupId:id,p.resolvedUri=p.uri),p.id=p.id||id,p.attributes=p.attributes||{},master.playlists[p.id]=p,master.playlists[p.uri]=p}))})),function(master){for(var i=master.playlists.length;i--;){var playlist=master.playlists[i];setupMediaPlaylist({playlist:playlist,id:createPlaylistID(i,playlist.uri)}),playlist.resolvedUri=resolveUrl(master.uri,playlist.uri),master.playlists[playlist.id]=playlist,master.playlists[playlist.uri]=playlist,playlist.attributes.BANDWIDTH||log.warn("Invalid playlist STREAM-INF detected. Missing BANDWIDTH attribute.")}}(master),function(master){forEachMediaGroup(master,(function(properties){properties.uri&&(properties.resolvedUri=resolveUrl(master.uri,properties.uri))}))}(master)},mergeOptions$2=videojs.mergeOptions,EventTarget$1=videojs.EventTarget,updateSegment=function(a,b){if(!a)return b;var result=mergeOptions$2(a,b);if(a.preloadHints&&!b.preloadHints&&delete result.preloadHints,a.parts&&!b.parts)delete result.parts;else if(a.parts&&b.parts)for(var i=0;i<b.parts.length;i++)a.parts&&a.parts[i]&&(result.parts[i]=mergeOptions$2(a.parts[i],b.parts[i]));return!a.skipped&&b.skipped&&(result.skipped=!1),a.preload&&!b.preload&&(result.preload=!1),result},resolveSegmentUris=function(segment,baseUri){!segment.resolvedUri&&segment.uri&&(segment.resolvedUri=resolveUrl(baseUri,segment.uri)),segment.key&&!segment.key.resolvedUri&&(segment.key.resolvedUri=resolveUrl(baseUri,segment.key.uri)),segment.map&&!segment.map.resolvedUri&&(segment.map.resolvedUri=resolveUrl(baseUri,segment.map.uri)),segment.map&&segment.map.key&&!segment.map.key.resolvedUri&&(segment.map.key.resolvedUri=resolveUrl(baseUri,segment.map.key.uri)),segment.parts&&segment.parts.length&&segment.parts.forEach((function(p){p.resolvedUri||(p.resolvedUri=resolveUrl(baseUri,p.uri))})),segment.preloadHints&&segment.preloadHints.length&&segment.preloadHints.forEach((function(p){p.resolvedUri||(p.resolvedUri=resolveUrl(baseUri,p.uri))}))},getAllSegments=function(media){var segments=media.segments||[],preloadSegment=media.preloadSegment;if(preloadSegment&&preloadSegment.parts&&preloadSegment.parts.length){if(preloadSegment.preloadHints)for(var i=0;i<preloadSegment.preloadHints.length;i++)if("MAP"===preloadSegment.preloadHints[i].type)return segments;preloadSegment.duration=media.targetDuration,preloadSegment.preload=!0,segments.push(preloadSegment)}return segments},isPlaylistUnchanged=function(a,b){return a===b||a.segments&&b.segments&&a.segments.length===b.segments.length&&a.endList===b.endList&&a.mediaSequence===b.mediaSequence&&a.preloadSegment===b.preloadSegment},updateMaster$1=function(master,newMedia,unchangedCheck){void 0===unchangedCheck&&(unchangedCheck=isPlaylistUnchanged);var result=mergeOptions$2(master,{}),oldMedia=result.playlists[newMedia.id];if(!oldMedia)return null;if(unchangedCheck(oldMedia,newMedia))return null;newMedia.segments=getAllSegments(newMedia);var mergedPlaylist=mergeOptions$2(oldMedia,newMedia);if(mergedPlaylist.preloadSegment&&!newMedia.preloadSegment&&delete mergedPlaylist.preloadSegment,oldMedia.segments){if(newMedia.skip){newMedia.segments=newMedia.segments||[];for(var i=0;i<newMedia.skip.skippedSegments;i++)newMedia.segments.unshift({skipped:!0})}mergedPlaylist.segments=function(original,update,offset){var oldSegments=original.slice(),newSegments=update.slice();offset=offset||0;for(var currentMap,result=[],newIndex=0;newIndex<newSegments.length;newIndex++){var oldSegment=oldSegments[newIndex+offset],newSegment=newSegments[newIndex];oldSegment?(currentMap=oldSegment.map||currentMap,result.push(updateSegment(oldSegment,newSegment))):(currentMap&&!newSegment.map&&(newSegment.map=currentMap),result.push(newSegment))}return result}(oldMedia.segments,newMedia.segments,newMedia.mediaSequence-oldMedia.mediaSequence)}mergedPlaylist.segments.forEach((function(segment){resolveSegmentUris(segment,mergedPlaylist.resolvedUri)}));for(var _i=0;_i<result.playlists.length;_i++)result.playlists[_i].id===newMedia.id&&(result.playlists[_i]=mergedPlaylist);return result.playlists[newMedia.id]=mergedPlaylist,result.playlists[newMedia.uri]=mergedPlaylist,forEachMediaGroup(master,(function(properties,mediaType,groupKey,labelKey){if(properties.playlists)for(var _i2=0;_i2<properties.playlists.length;_i2++)newMedia.id===properties.playlists[_i2].id&&(properties.playlists[_i2]=newMedia)})),result},refreshDelay=function(media,update){var segments=media.segments||[],lastSegment=segments[segments.length-1],lastPart=lastSegment&&lastSegment.parts&&lastSegment.parts[lastSegment.parts.length-1],lastDuration=lastPart&&lastPart.duration||lastSegment&&lastSegment.duration;return update&&lastDuration?1e3*lastDuration:500*(media.partTargetDuration||media.targetDuration||10)},PlaylistLoader=function(_EventTarget){function PlaylistLoader(src,vhs,options){var _this;if(void 0===options&&(options={}),_this=_EventTarget.call(this)||this,!src)throw new Error("A non-empty playlist URL or object is required");_this.logger_=logger("PlaylistLoader");var _options=options,_options$withCredenti=_options.withCredentials,withCredentials=void 0!==_options$withCredenti&&_options$withCredenti,_options$handleManife=_options.handleManifestRedirects,handleManifestRedirects=void 0!==_options$handleManife&&_options$handleManife;_this.src=src,_this.vhs_=vhs,_this.withCredentials=withCredentials,_this.handleManifestRedirects=handleManifestRedirects;var vhsOptions=vhs.options_;return _this.customTagParsers=vhsOptions&&vhsOptions.customTagParsers||[],_this.customTagMappers=vhsOptions&&vhsOptions.customTagMappers||[],_this.experimentalLLHLS=vhsOptions&&vhsOptions.experimentalLLHLS||!1,videojs.browser.IE_VERSION&&(_this.experimentalLLHLS=!1),_this.state="HAVE_NOTHING",_this.handleMediaupdatetimeout_=_this.handleMediaupdatetimeout_.bind(assertThisInitialized(_this)),_this.on("mediaupdatetimeout",_this.handleMediaupdatetimeout_),_this}inheritsLoose(PlaylistLoader,_EventTarget);var _proto=PlaylistLoader.prototype;return _proto.handleMediaupdatetimeout_=function(){var _this2=this;if("HAVE_METADATA"===this.state){var media=this.media(),uri=resolveUrl(this.master.uri,media.uri);this.experimentalLLHLS&&(uri=function(uri,media){if(media.endList||!media.serverControl)return uri;var parameters={};if(media.serverControl.canBlockReload){var preloadSegment=media.preloadSegment,nextMSN=media.mediaSequence+media.segments.length;if(preloadSegment){var parts=preloadSegment.parts||[],nextPart=getKnownPartCount(media)-1;nextPart>-1&&nextPart!==parts.length-1&&(parameters._HLS_part=nextPart),(nextPart>-1||parts.length)&&nextMSN--}parameters._HLS_msn=nextMSN}if(media.serverControl&&media.serverControl.canSkipUntil&&(parameters._HLS_skip=media.serverControl.canSkipDateranges?"v2":"YES"),Object.keys(parameters).length){var parsedUri=new window.URL(uri);["_HLS_skip","_HLS_msn","_HLS_part"].forEach((function(name){parameters.hasOwnProperty(name)&&parsedUri.searchParams.set(name,parameters[name])})),uri=parsedUri.toString()}return uri}(uri,media)),this.state="HAVE_CURRENT_METADATA",this.request=this.vhs_.xhr({uri:uri,withCredentials:this.withCredentials},(function(error,req){if(_this2.request)return error?_this2.playlistRequestError(_this2.request,_this2.media(),"HAVE_METADATA"):void _this2.haveMetadata({playlistString:_this2.request.responseText,url:_this2.media().uri,id:_this2.media().id})}))}},_proto.playlistRequestError=function(xhr,playlist,startingState){var uri=playlist.uri,id=playlist.id;this.request=null,startingState&&(this.state=startingState),this.error={playlist:this.master.playlists[id],status:xhr.status,message:"HLS playlist request error at URL: "+uri+".",responseText:xhr.responseText,code:xhr.status>=500?4:2},this.trigger("error")},_proto.parseManifest_=function(_ref){var _this3=this,url=_ref.url;return function(_ref){var onwarn=_ref.onwarn,oninfo=_ref.oninfo,manifestString=_ref.manifestString,_ref$customTagParsers=_ref.customTagParsers,customTagParsers=void 0===_ref$customTagParsers?[]:_ref$customTagParsers,_ref$customTagMappers=_ref.customTagMappers,customTagMappers=void 0===_ref$customTagMappers?[]:_ref$customTagMappers,experimentalLLHLS=_ref.experimentalLLHLS,parser=new Parser;onwarn&&parser.on("warn",onwarn),oninfo&&parser.on("info",oninfo),customTagParsers.forEach((function(customParser){return parser.addParser(customParser)})),customTagMappers.forEach((function(mapper){return parser.addTagMapper(mapper)})),parser.push(manifestString),parser.end();var manifest=parser.manifest;if(experimentalLLHLS||(["preloadSegment","skip","serverControl","renditionReports","partInf","partTargetDuration"].forEach((function(k){manifest.hasOwnProperty(k)&&delete manifest[k]})),manifest.segments&&manifest.segments.forEach((function(segment){["parts","preloadHints"].forEach((function(k){segment.hasOwnProperty(k)&&delete segment[k]}))}))),!manifest.targetDuration){var targetDuration=10;manifest.segments&&manifest.segments.length&&(targetDuration=manifest.segments.reduce((function(acc,s){return Math.max(acc,s.duration)}),0)),onwarn&&onwarn("manifest has no targetDuration defaulting to "+targetDuration),manifest.targetDuration=targetDuration}var parts=getLastParts(manifest);if(parts.length&&!manifest.partTargetDuration){var partTargetDuration=parts.reduce((function(acc,p){return Math.max(acc,p.duration)}),0);onwarn&&(onwarn("manifest has no partTargetDuration defaulting to "+partTargetDuration),log.error("LL-HLS manifest has parts but lacks required #EXT-X-PART-INF:PART-TARGET value. See https://datatracker.ietf.org/doc/html/draft-pantos-hls-rfc8216bis-09#section-4.4.3.7. Playback is not guaranteed.")),manifest.partTargetDuration=partTargetDuration}return manifest}({onwarn:function(_ref2){var message=_ref2.message;return _this3.logger_("m3u8-parser warn for "+url+": "+message)},oninfo:function(_ref3){var message=_ref3.message;return _this3.logger_("m3u8-parser info for "+url+": "+message)},manifestString:_ref.manifestString,customTagParsers:this.customTagParsers,customTagMappers:this.customTagMappers,experimentalLLHLS:this.experimentalLLHLS})},_proto.haveMetadata=function(_ref4){var playlistString=_ref4.playlistString,playlistObject=_ref4.playlistObject,url=_ref4.url,id=_ref4.id;this.request=null,this.state="HAVE_METADATA";var playlist=playlistObject||this.parseManifest_({url:url,manifestString:playlistString});playlist.lastRequest=Date.now(),setupMediaPlaylist({playlist:playlist,uri:url,id:id});var update=updateMaster$1(this.master,playlist);this.targetDuration=playlist.partTargetDuration||playlist.targetDuration,this.pendingMedia_=null,update?(this.master=update,this.media_=this.master.playlists[id]):this.trigger("playlistunchanged"),this.updateMediaUpdateTimeout_(refreshDelay(this.media(),!!update)),this.trigger("loadedplaylist")},_proto.dispose=function(){this.trigger("dispose"),this.stopRequest(),window.clearTimeout(this.mediaUpdateTimeout),window.clearTimeout(this.finalRenditionTimeout),this.off()},_proto.stopRequest=function(){if(this.request){var oldRequest=this.request;this.request=null,oldRequest.onreadystatechange=null,oldRequest.abort()}},_proto.media=function(playlist,shouldDelay){var _this4=this;if(!playlist)return this.media_;if("HAVE_NOTHING"===this.state)throw new Error("Cannot switch media playlist from "+this.state);if("string"==typeof playlist){if(!this.master.playlists[playlist])throw new Error("Unknown playlist URI: "+playlist);playlist=this.master.playlists[playlist]}if(window.clearTimeout(this.finalRenditionTimeout),shouldDelay){var delay=(playlist.partTargetDuration||playlist.targetDuration)/2*1e3||5e3;this.finalRenditionTimeout=window.setTimeout(this.media.bind(this,playlist,!1),delay)}else{var startingState=this.state,mediaChange=!this.media_||playlist.id!==this.media_.id,masterPlaylistRef=this.master.playlists[playlist.id];if(masterPlaylistRef&&masterPlaylistRef.endList||playlist.endList&&playlist.segments.length)return this.request&&(this.request.onreadystatechange=null,this.request.abort(),this.request=null),this.state="HAVE_METADATA",this.media_=playlist,void(mediaChange&&(this.trigger("mediachanging"),"HAVE_MASTER"===startingState?this.trigger("loadedmetadata"):this.trigger("mediachange")));if(this.updateMediaUpdateTimeout_(refreshDelay(playlist,!0)),mediaChange){if(this.state="SWITCHING_MEDIA",this.request){if(playlist.resolvedUri===this.request.url)return;this.request.onreadystatechange=null,this.request.abort(),this.request=null}this.media_&&this.trigger("mediachanging"),this.pendingMedia_=playlist,this.request=this.vhs_.xhr({uri:playlist.resolvedUri,withCredentials:this.withCredentials},(function(error,req){if(_this4.request){if(playlist.lastRequest=Date.now(),playlist.resolvedUri=resolveManifestRedirect(_this4.handleManifestRedirects,playlist.resolvedUri,req),error)return _this4.playlistRequestError(_this4.request,playlist,startingState);_this4.haveMetadata({playlistString:req.responseText,url:playlist.uri,id:playlist.id}),"HAVE_MASTER"===startingState?_this4.trigger("loadedmetadata"):_this4.trigger("mediachange")}}))}}},_proto.pause=function(){this.mediaUpdateTimeout&&(window.clearTimeout(this.mediaUpdateTimeout),this.mediaUpdateTimeout=null),this.stopRequest(),"HAVE_NOTHING"===this.state&&(this.started=!1),"SWITCHING_MEDIA"===this.state?this.media_?this.state="HAVE_METADATA":this.state="HAVE_MASTER":"HAVE_CURRENT_METADATA"===this.state&&(this.state="HAVE_METADATA")},_proto.load=function(shouldDelay){var _this5=this;this.mediaUpdateTimeout&&(window.clearTimeout(this.mediaUpdateTimeout),this.mediaUpdateTimeout=null);var media=this.media();if(shouldDelay){var delay=media?(media.partTargetDuration||media.targetDuration)/2*1e3:5e3;this.mediaUpdateTimeout=window.setTimeout((function(){_this5.mediaUpdateTimeout=null,_this5.load()}),delay)}else this.started?media&&!media.endList?this.trigger("mediaupdatetimeout"):this.trigger("loadedplaylist"):this.start()},_proto.updateMediaUpdateTimeout_=function(delay){var _this6=this;this.mediaUpdateTimeout&&(window.clearTimeout(this.mediaUpdateTimeout),this.mediaUpdateTimeout=null),this.media()&&!this.media().endList&&(this.mediaUpdateTimeout=window.setTimeout((function(){_this6.mediaUpdateTimeout=null,_this6.trigger("mediaupdatetimeout"),_this6.updateMediaUpdateTimeout_(delay)}),delay))},_proto.start=function(){var _this7=this;if(this.started=!0,"object"==typeof this.src)return this.src.uri||(this.src.uri=window.location.href),this.src.resolvedUri=this.src.uri,void setTimeout((function(){_this7.setupInitialPlaylist(_this7.src)}),0);this.request=this.vhs_.xhr({uri:this.src,withCredentials:this.withCredentials},(function(error,req){if(_this7.request){if(_this7.request=null,error)return _this7.error={status:req.status,message:"HLS playlist request error at URL: "+_this7.src+".",responseText:req.responseText,code:2},"HAVE_NOTHING"===_this7.state&&(_this7.started=!1),_this7.trigger("error");_this7.src=resolveManifestRedirect(_this7.handleManifestRedirects,_this7.src,req);var manifest=_this7.parseManifest_({manifestString:req.responseText,url:_this7.src});_this7.setupInitialPlaylist(manifest)}}))},_proto.srcUri=function(){return"string"==typeof this.src?this.src:this.src.uri},_proto.setupInitialPlaylist=function(manifest){if(this.state="HAVE_MASTER",manifest.playlists)return this.master=manifest,addPropertiesToMaster(this.master,this.srcUri()),manifest.playlists.forEach((function(playlist){playlist.segments=getAllSegments(playlist),playlist.segments.forEach((function(segment){resolveSegmentUris(segment,playlist.resolvedUri)}))})),this.trigger("loadedplaylist"),void(this.request||this.media(this.master.playlists[0]));var uri=this.srcUri()||window.location.href;this.master=function(media,uri){var id=createPlaylistID(0,uri),master={mediaGroups:{AUDIO:{},VIDEO:{},"CLOSED-CAPTIONS":{},SUBTITLES:{}},uri:window.location.href,resolvedUri:window.location.href,playlists:[{uri:uri,id:id,resolvedUri:uri,attributes:{}}]};return master.playlists[id]=master.playlists[0],master.playlists[uri]=master.playlists[0],master}(0,uri),this.haveMetadata({playlistObject:manifest,url:uri,id:this.master.playlists[0].id}),this.trigger("loadedmetadata")},PlaylistLoader}(EventTarget$1),videojsXHR=videojs.xhr,mergeOptions$1=videojs.mergeOptions,callbackWrapper=function(request,error,response,callback){var reqResponse="arraybuffer"===request.responseType?request.response:request.responseText;!error&&reqResponse&&(request.responseTime=Date.now(),request.roundTripTime=request.responseTime-request.requestTime,request.bytesReceived=reqResponse.byteLength||reqResponse.length,request.bandwidth||(request.bandwidth=Math.floor(request.bytesReceived/request.roundTripTime*8*1e3))),response.headers&&(request.responseHeaders=response.headers),error&&"ETIMEDOUT"===error.code&&(request.timedout=!0),error||request.aborted||200===response.statusCode||206===response.statusCode||0===response.statusCode||(error=new Error("XHR Failed with a response of: "+(request&&(reqResponse||request.responseText)))),callback(error,request)},xhrFactory=function(){var xhr=function XhrFunction(options,callback){options=mergeOptions$1({timeout:45e3},options);var beforeRequest=XhrFunction.beforeRequest||videojs.Vhs.xhr.beforeRequest;if(beforeRequest&&"function"==typeof beforeRequest){var newOptions=beforeRequest(options);newOptions&&(options=newOptions)}var request=(!0===videojs.Vhs.xhr.original?videojsXHR:videojs.Vhs.xhr)(options,(function(error,response){return callbackWrapper(request,error,response,callback)})),originalAbort=request.abort;return request.abort=function(){return request.aborted=!0,originalAbort.apply(request,arguments)},request.uri=options.uri,request.requestTime=Date.now(),request};return xhr.original=!0,xhr},segmentXhrHeaders=function(segment){var byterange,byterangeEnd,headers={};return segment.byterange&&(headers.Range=(byterange=segment.byterange,byterangeEnd=byterange.offset+byterange.length-1,"bytes="+byterange.offset+"-"+byterangeEnd)),headers},textRange=function(range,i){return range.start(i)+"-"+range.end(i)},formatHexString=function(e,i){var value=e.toString(16);return"00".substring(0,2-value.length)+value+(i%2?" ":"")},formatAsciiString=function(e){return e>=32&&e<126?String.fromCharCode(e):"."},createTransferableMessage=function(message){var transferable={};return Object.keys(message).forEach((function(key){var value=message[key];ArrayBuffer.isView(value)?transferable[key]={bytes:value.buffer,byteOffset:value.byteOffset,byteLength:value.byteLength}:transferable[key]=value})),transferable},initSegmentId=function(initSegment){var byterange=initSegment.byterange||{length:1/0,offset:0};return[byterange.length,byterange.offset,initSegment.resolvedUri].join(",")},segmentKeyId=function(key){return key.resolvedUri},hexDump=function(data){for(var bytes=Array.prototype.slice.call(data),result="",j=0;j<bytes.length/16;j++)result+=bytes.slice(16*j,16*j+16).map(formatHexString).join("")+" "+bytes.slice(16*j,16*j+16).map(formatAsciiString).join("")+"\n";return result},utils=Object.freeze({__proto__:null,createTransferableMessage:createTransferableMessage,initSegmentId:initSegmentId,segmentKeyId:segmentKeyId,hexDump:hexDump,tagDump:function(_ref){var bytes=_ref.bytes;return hexDump(bytes)},textRanges:function(ranges){var i,result="";for(i=0;i<ranges.length;i++)result+=textRange(ranges,i)+" ";return result}}),getProgramTime=function(_ref){var playlist=_ref.playlist,_ref$time=_ref.time,time=void 0===_ref$time?void 0:_ref$time,callback=_ref.callback;if(!callback)throw new Error("getProgramTime: callback must be provided");if(!playlist||void 0===time)return callback({message:"getProgramTime: playlist and time must be provided"});var matchedSegment=function(time,playlist){if(!playlist||!playlist.segments||0===playlist.segments.length)return null;for(var segment,segmentEnd=0,i=0;i<playlist.segments.length&&!(time<=(segmentEnd=(segment=playlist.segments[i]).videoTimingInfo?segment.videoTimingInfo.transmuxedPresentationEnd:segmentEnd+segment.duration));i++);var lastSegment=playlist.segments[playlist.segments.length-1];if(lastSegment.videoTimingInfo&&lastSegment.videoTimingInfo.transmuxedPresentationEnd<time)return null;if(time>segmentEnd){if(time>segmentEnd+.25*lastSegment.duration)return null;segment=lastSegment}return{segment:segment,estimatedStart:segment.videoTimingInfo?segment.videoTimingInfo.transmuxedPresentationStart:segmentEnd-segment.duration,type:segment.videoTimingInfo?"accurate":"estimate"}}(time,playlist);if(!matchedSegment)return callback({message:"valid programTime was not found"});if("estimate"===matchedSegment.type)return callback({message:"Accurate programTime could not be determined. Please seek to e.seekTime and try again",seekTime:matchedSegment.estimatedStart});var programTimeObject={mediaSeconds:time},programTime=function(playerTime,segment){if(!segment.dateTimeObject)return null;var transmuxerPrependedSeconds=segment.videoTimingInfo.transmuxerPrependedSeconds,offsetFromSegmentStart=playerTime-(segment.videoTimingInfo.transmuxedPresentationStart+transmuxerPrependedSeconds);return new Date(segment.dateTimeObject.getTime()+1e3*offsetFromSegmentStart)}(time,matchedSegment.segment);return programTime&&(programTimeObject.programDateTime=programTime.toISOString()),callback(null,programTimeObject)},seekToProgramTime=function seekToProgramTime(_ref2){var programTime=_ref2.programTime,playlist=_ref2.playlist,_ref2$retryCount=_ref2.retryCount,retryCount=void 0===_ref2$retryCount?2:_ref2$retryCount,seekTo=_ref2.seekTo,_ref2$pauseAfterSeek=_ref2.pauseAfterSeek,pauseAfterSeek=void 0===_ref2$pauseAfterSeek||_ref2$pauseAfterSeek,tech=_ref2.tech,callback=_ref2.callback;if(!callback)throw new Error("seekToProgramTime: callback must be provided");if(void 0===programTime||!playlist||!seekTo)return callback({message:"seekToProgramTime: programTime, seekTo and playlist must be provided"});if(!playlist.endList&&!tech.hasStarted_)return callback({message:"player must be playing a live stream to start buffering"});if(!function(playlist){if(!playlist.segments||0===playlist.segments.length)return!1;for(var i=0;i<playlist.segments.length;i++)if(!playlist.segments[i].dateTimeObject)return!1;return!0}(playlist))return callback({message:"programDateTime tags must be provided in the manifest "+playlist.resolvedUri});var matchedSegment=function(programTime,playlist){var dateTimeObject;try{dateTimeObject=new Date(programTime)}catch(e){return null}if(!playlist||!playlist.segments||0===playlist.segments.length)return null;var segment=playlist.segments[0];if(dateTimeObject<segment.dateTimeObject)return null;for(var i=0;i<playlist.segments.length-1&&(segment=playlist.segments[i],!(dateTimeObject<playlist.segments[i+1].dateTimeObject));i++);var videoTimingInfo,lastSegment=playlist.segments[playlist.segments.length-1],lastSegmentStart=lastSegment.dateTimeObject,lastSegmentDuration=lastSegment.videoTimingInfo?(videoTimingInfo=lastSegment.videoTimingInfo).transmuxedPresentationEnd-videoTimingInfo.transmuxedPresentationStart-videoTimingInfo.transmuxerPrependedSeconds:lastSegment.duration+.25*lastSegment.duration;return dateTimeObject>new Date(lastSegmentStart.getTime()+1e3*lastSegmentDuration)?null:(dateTimeObject>lastSegmentStart&&(segment=lastSegment),{segment:segment,estimatedStart:segment.videoTimingInfo?segment.videoTimingInfo.transmuxedPresentationStart:Playlist.duration(playlist,playlist.mediaSequence+playlist.segments.indexOf(segment)),type:segment.videoTimingInfo?"accurate":"estimate"})}(programTime,playlist);if(!matchedSegment)return callback({message:programTime+" was not found in the stream"});var segment=matchedSegment.segment,mediaOffset=function(comparisonTimeStamp,programTime){var segmentDateTime,programDateTime;try{segmentDateTime=new Date(comparisonTimeStamp),programDateTime=new Date(programTime)}catch(e){}var segmentTimeEpoch=segmentDateTime.getTime();return(programDateTime.getTime()-segmentTimeEpoch)/1e3}(segment.dateTimeObject,programTime);if("estimate"===matchedSegment.type)return 0===retryCount?callback({message:programTime+" is not buffered yet. Try again"}):(seekTo(matchedSegment.estimatedStart+mediaOffset),void tech.one("seeked",(function(){seekToProgramTime({programTime:programTime,playlist:playlist,retryCount:retryCount-1,seekTo:seekTo,pauseAfterSeek:pauseAfterSeek,tech:tech,callback:callback})})));var seekToTime=segment.start+mediaOffset;tech.one("seeked",(function(){return callback(null,tech.currentTime())})),pauseAfterSeek&&tech.pause(),seekTo(seekToTime)},callbackOnCompleted=function(request,cb){if(4===request.readyState)return cb()},containerRequest=function(uri,xhr,cb){var id3Offset,bytes=[],finished=!1,endRequestAndCallback=function(err,req,type,_bytes){return req.abort(),finished=!0,cb(err,req,type,_bytes)},progressListener=function(error,request){if(!finished){if(error)return endRequestAndCallback(error,request,"",bytes);var newPart=request.responseText.substring(bytes&&bytes.byteLength||0,request.responseText.length);if(bytes=function(){for(var _len=arguments.length,buffers=new Array(_len),_key=0;_key<_len;_key++)buffers[_key]=arguments[_key];if((buffers=buffers.filter((function(b){return b&&(b.byteLength||b.length)&&"string"!=typeof b}))).length<=1)return toUint8(buffers[0]);var totalLen=buffers.reduce((function(total,buf,i){return total+(buf.byteLength||buf.length)}),0),tempBuffer=new Uint8Array(totalLen),offset=0;return buffers.forEach((function(buf){buf=toUint8(buf),tempBuffer.set(buf,offset),offset+=buf.byteLength})),tempBuffer}(bytes,stringToBytes(newPart,!0)),id3Offset=id3Offset||getId3Offset(bytes),bytes.length<10||id3Offset&&bytes.length<id3Offset+2)return callbackOnCompleted(request,(function(){return endRequestAndCallback(error,request,"",bytes)}));var type=detectContainerForBytes(bytes);return"ts"===type&&bytes.length<188||!type&&bytes.length<376?callbackOnCompleted(request,(function(){return endRequestAndCallback(error,request,"",bytes)})):endRequestAndCallback(null,request,type,bytes)}},options={uri:uri,beforeSend:function(request){request.overrideMimeType("text/plain; charset=x-user-defined"),request.addEventListener("progress",(function(_ref){return _ref.total,_ref.loaded,callbackWrapper(request,null,{statusCode:request.status},progressListener)}))}},request=xhr(options,(function(error,response){return callbackWrapper(request,error,response,progressListener)}));return request},EventTarget=videojs.EventTarget,mergeOptions=videojs.mergeOptions,dashPlaylistUnchanged=function(a,b){if(!isPlaylistUnchanged(a,b))return!1;if(a.sidx&&b.sidx&&(a.sidx.offset!==b.sidx.offset||a.sidx.length!==b.sidx.length))return!1;if(!a.sidx&&b.sidx||a.sidx&&!b.sidx)return!1;if(a.segments&&!b.segments||!a.segments&&b.segments)return!1;if(!a.segments&&!b.segments)return!0;for(var i=0;i<a.segments.length;i++){var aSegment=a.segments[i],bSegment=b.segments[i];if(aSegment.uri!==bSegment.uri)return!1;if(aSegment.byterange||bSegment.byterange){var aByterange=aSegment.byterange,bByterange=bSegment.byterange;if(aByterange&&!bByterange||!aByterange&&bByterange)return!1;if(aByterange.offset!==bByterange.offset||aByterange.length!==bByterange.length)return!1}}return!0},compareSidxEntry=function(playlists,oldSidxMapping){var a,b,newSidxMapping={};for(var id in playlists){var currentSidxInfo=playlists[id].sidx;if(currentSidxInfo){var key=generateSidxKey(currentSidxInfo);if(!oldSidxMapping[key])break;var savedSidxInfo=oldSidxMapping[key].sidxInfo;a=savedSidxInfo,b=currentSidxInfo,(Boolean(!a.map&&!b.map)||Boolean(a.map&&b.map&&a.map.byterange.offset===b.map.byterange.offset&&a.map.byterange.length===b.map.byterange.length))&&a.uri===b.uri&&a.byterange.offset===b.byterange.offset&&a.byterange.length===b.byterange.length&&(newSidxMapping[key]=oldSidxMapping[key])}}return newSidxMapping},DashPlaylistLoader=function(_EventTarget){function DashPlaylistLoader(srcUrlOrPlaylist,vhs,options,masterPlaylistLoader){var _this;void 0===options&&(options={}),(_this=_EventTarget.call(this)||this).masterPlaylistLoader_=masterPlaylistLoader||assertThisInitialized(_this),masterPlaylistLoader||(_this.isMaster_=!0);var _options=options,_options$withCredenti=_options.withCredentials,withCredentials=void 0!==_options$withCredenti&&_options$withCredenti,_options$handleManife=_options.handleManifestRedirects,handleManifestRedirects=void 0!==_options$handleManife&&_options$handleManife;if(_this.vhs_=vhs,_this.withCredentials=withCredentials,_this.handleManifestRedirects=handleManifestRedirects,!srcUrlOrPlaylist)throw new Error("A non-empty playlist URL or object is required");return _this.on("minimumUpdatePeriod",(function(){_this.refreshXml_()})),_this.on("mediaupdatetimeout",(function(){_this.refreshMedia_(_this.media().id)})),_this.state="HAVE_NOTHING",_this.loadedPlaylists_={},_this.logger_=logger("DashPlaylistLoader"),_this.isMaster_?(_this.masterPlaylistLoader_.srcUrl=srcUrlOrPlaylist,_this.masterPlaylistLoader_.sidxMapping_={}):_this.childPlaylist_=srcUrlOrPlaylist,_this}inheritsLoose(DashPlaylistLoader,_EventTarget);var _proto=DashPlaylistLoader.prototype;return _proto.requestErrored_=function(err,request,startingState){return!this.request||(this.request=null,err?(this.error="object"!=typeof err||err instanceof Error?{status:request.status,message:"DASH request error at URL: "+request.uri,response:request.response,code:2}:err,startingState&&(this.state=startingState),this.trigger("error"),!0):void 0)},_proto.addSidxSegments_=function(playlist,startingState,cb){var _this2=this,sidxKey=playlist.sidx&&generateSidxKey(playlist.sidx);if(playlist.sidx&&sidxKey&&!this.masterPlaylistLoader_.sidxMapping_[sidxKey]){var uri=resolveManifestRedirect(this.handleManifestRedirects,playlist.sidx.resolvedUri),fin=function(err,request){if(!_this2.requestErrored_(err,request,startingState)){var sidx,sidxMapping=_this2.masterPlaylistLoader_.sidxMapping_;try{sidx=parseSidx_1(toUint8(request.response).subarray(8))}catch(e){return void _this2.requestErrored_(e,request,startingState)}return sidxMapping[sidxKey]={sidxInfo:playlist.sidx,sidx:sidx},addSidxSegmentsToPlaylist(playlist,sidx,playlist.sidx.resolvedUri),cb(!0)}};this.request=containerRequest(uri,this.vhs_.xhr,(function(err,request,container,bytes){if(err)return fin(err,request);if(!container||"mp4"!==container)return fin({status:request.status,message:"Unsupported "+(container||"unknown")+" container type for sidx segment at URL: "+uri,response:"",playlist:playlist,internal:!0,blacklistDuration:1/0,code:2},request);var _playlist$sidx$bytera=playlist.sidx.byterange,offset=_playlist$sidx$bytera.offset,length=_playlist$sidx$bytera.length;if(bytes.length>=length+offset)return fin(err,{response:bytes.subarray(offset,offset+length),status:request.status,uri:request.uri});_this2.request=_this2.vhs_.xhr({uri:uri,responseType:"arraybuffer",headers:segmentXhrHeaders({byterange:playlist.sidx.byterange})},fin)}))}else this.mediaRequest_=window.setTimeout((function(){return cb(!1)}),0)},_proto.dispose=function(){this.trigger("dispose"),this.stopRequest(),this.loadedPlaylists_={},window.clearTimeout(this.minimumUpdatePeriodTimeout_),window.clearTimeout(this.mediaRequest_),window.clearTimeout(this.mediaUpdateTimeout),this.mediaUpdateTimeout=null,this.mediaRequest_=null,this.minimumUpdatePeriodTimeout_=null,this.masterPlaylistLoader_.createMupOnMedia_&&(this.off("loadedmetadata",this.masterPlaylistLoader_.createMupOnMedia_),this.masterPlaylistLoader_.createMupOnMedia_=null),this.off()},_proto.hasPendingRequest=function(){return this.request||this.mediaRequest_},_proto.stopRequest=function(){if(this.request){var oldRequest=this.request;this.request=null,oldRequest.onreadystatechange=null,oldRequest.abort()}},_proto.media=function(playlist){var _this3=this;if(!playlist)return this.media_;if("HAVE_NOTHING"===this.state)throw new Error("Cannot switch media playlist from "+this.state);var startingState=this.state;if("string"==typeof playlist){if(!this.masterPlaylistLoader_.master.playlists[playlist])throw new Error("Unknown playlist URI: "+playlist);playlist=this.masterPlaylistLoader_.master.playlists[playlist]}var mediaChange=!this.media_||playlist.id!==this.media_.id;if(mediaChange&&this.loadedPlaylists_[playlist.id]&&this.loadedPlaylists_[playlist.id].endList)return this.state="HAVE_METADATA",this.media_=playlist,void(mediaChange&&(this.trigger("mediachanging"),this.trigger("mediachange")));mediaChange&&(this.media_&&this.trigger("mediachanging"),this.addSidxSegments_(playlist,startingState,(function(sidxChanged){_this3.haveMetadata({startingState:startingState,playlist:playlist})})))},_proto.haveMetadata=function(_ref2){var startingState=_ref2.startingState,playlist=_ref2.playlist;this.state="HAVE_METADATA",this.loadedPlaylists_[playlist.id]=playlist,this.mediaRequest_=null,this.refreshMedia_(playlist.id),"HAVE_MASTER"===startingState?this.trigger("loadedmetadata"):this.trigger("mediachange")},_proto.pause=function(){this.masterPlaylistLoader_.createMupOnMedia_&&(this.off("loadedmetadata",this.masterPlaylistLoader_.createMupOnMedia_),this.masterPlaylistLoader_.createMupOnMedia_=null),this.stopRequest(),window.clearTimeout(this.mediaUpdateTimeout),this.mediaUpdateTimeout=null,this.isMaster_&&(window.clearTimeout(this.masterPlaylistLoader_.minimumUpdatePeriodTimeout_),this.masterPlaylistLoader_.minimumUpdatePeriodTimeout_=null),"HAVE_NOTHING"===this.state&&(this.started=!1)},_proto.load=function(isFinalRendition){var _this4=this;window.clearTimeout(this.mediaUpdateTimeout),this.mediaUpdateTimeout=null;var media=this.media();if(isFinalRendition){var delay=media?media.targetDuration/2*1e3:5e3;this.mediaUpdateTimeout=window.setTimeout((function(){return _this4.load()}),delay)}else this.started?media&&!media.endList?(this.isMaster_&&!this.minimumUpdatePeriodTimeout_&&(this.trigger("minimumUpdatePeriod"),this.updateMinimumUpdatePeriodTimeout_()),this.trigger("mediaupdatetimeout")):this.trigger("loadedplaylist"):this.start()},_proto.start=function(){var _this5=this;this.started=!0,this.isMaster_?this.requestMaster_((function(req,masterChanged){_this5.haveMaster_(),_this5.hasPendingRequest()||_this5.media_||_this5.media(_this5.masterPlaylistLoader_.master.playlists[0])})):this.mediaRequest_=window.setTimeout((function(){return _this5.haveMaster_()}),0)},_proto.requestMaster_=function(cb){var _this6=this;this.request=this.vhs_.xhr({uri:this.masterPlaylistLoader_.srcUrl,withCredentials:this.withCredentials},(function(error,req){if(!_this6.requestErrored_(error,req)){var masterChanged=req.responseText!==_this6.masterPlaylistLoader_.masterXml_;return _this6.masterPlaylistLoader_.masterXml_=req.responseText,req.responseHeaders&&req.responseHeaders.date?_this6.masterLoaded_=Date.parse(req.responseHeaders.date):_this6.masterLoaded_=Date.now(),_this6.masterPlaylistLoader_.srcUrl=resolveManifestRedirect(_this6.handleManifestRedirects,_this6.masterPlaylistLoader_.srcUrl,req),masterChanged?(_this6.handleMaster_(),void _this6.syncClientServerClock_((function(){return cb(req,masterChanged)}))):cb(req,masterChanged)}"HAVE_NOTHING"===_this6.state&&(_this6.started=!1)}))},_proto.syncClientServerClock_=function(done){var _this7=this,utcTiming=parseUTCTiming(this.masterPlaylistLoader_.masterXml_);return null===utcTiming?(this.masterPlaylistLoader_.clientOffset_=this.masterLoaded_-Date.now(),done()):"DIRECT"===utcTiming.method?(this.masterPlaylistLoader_.clientOffset_=utcTiming.value-Date.now(),done()):void(this.request=this.vhs_.xhr({uri:resolveUrl(this.masterPlaylistLoader_.srcUrl,utcTiming.value),method:utcTiming.method,withCredentials:this.withCredentials},(function(error,req){if(_this7.request){if(error)return _this7.masterPlaylistLoader_.clientOffset_=_this7.masterLoaded_-Date.now(),done();var serverTime;serverTime="HEAD"===utcTiming.method?req.responseHeaders&&req.responseHeaders.date?Date.parse(req.responseHeaders.date):_this7.masterLoaded_:Date.parse(req.responseText),_this7.masterPlaylistLoader_.clientOffset_=serverTime-Date.now(),done()}})))},_proto.haveMaster_=function(){this.state="HAVE_MASTER",this.isMaster_?this.trigger("loadedplaylist"):this.media_||this.media(this.childPlaylist_)},_proto.handleMaster_=function(){this.mediaRequest_=null;var _ref,masterXml,srcUrl,clientOffset,sidxMapping,master,newMaster=(_ref={masterXml:this.masterPlaylistLoader_.masterXml_,srcUrl:this.masterPlaylistLoader_.srcUrl,clientOffset:this.masterPlaylistLoader_.clientOffset_,sidxMapping:this.masterPlaylistLoader_.sidxMapping_},masterXml=_ref.masterXml,srcUrl=_ref.srcUrl,clientOffset=_ref.clientOffset,sidxMapping=_ref.sidxMapping,master=parse(masterXml,{manifestUri:srcUrl,clientOffset:clientOffset,sidxMapping:sidxMapping}),addPropertiesToMaster(master,srcUrl),master),oldMaster=this.masterPlaylistLoader_.master;oldMaster&&(newMaster=function(oldMaster,newMaster,sidxMapping){for(var noChanges=!0,update=mergeOptions(oldMaster,{duration:newMaster.duration,minimumUpdatePeriod:newMaster.minimumUpdatePeriod}),i=0;i<newMaster.playlists.length;i++){var playlist=newMaster.playlists[i];if(playlist.sidx){var sidxKey=generateSidxKey(playlist.sidx);sidxMapping&&sidxMapping[sidxKey]&&sidxMapping[sidxKey].sidx&&addSidxSegmentsToPlaylist(playlist,sidxMapping[sidxKey].sidx,playlist.sidx.resolvedUri)}var playlistUpdate=updateMaster$1(update,playlist,dashPlaylistUnchanged);playlistUpdate&&(update=playlistUpdate,noChanges=!1)}return forEachMediaGroup(newMaster,(function(properties,type,group,label){if(properties.playlists&&properties.playlists.length){var id=properties.playlists[0].id,_playlistUpdate=updateMaster$1(update,properties.playlists[0],dashPlaylistUnchanged);_playlistUpdate&&((update=_playlistUpdate).mediaGroups[type][group][label].playlists[0]=update.playlists[id],noChanges=!1)}})),newMaster.minimumUpdatePeriod!==oldMaster.minimumUpdatePeriod&&(noChanges=!1),noChanges?null:update}(oldMaster,newMaster,this.masterPlaylistLoader_.sidxMapping_)),this.masterPlaylistLoader_.master=newMaster||oldMaster;var location=this.masterPlaylistLoader_.master.locations&&this.masterPlaylistLoader_.master.locations[0];return location&&location!==this.masterPlaylistLoader_.srcUrl&&(this.masterPlaylistLoader_.srcUrl=location),(!oldMaster||newMaster&&newMaster.minimumUpdatePeriod!==oldMaster.minimumUpdatePeriod)&&this.updateMinimumUpdatePeriodTimeout_(),Boolean(newMaster)},_proto.updateMinimumUpdatePeriodTimeout_=function(){var mpl=this.masterPlaylistLoader_;mpl.createMupOnMedia_&&(mpl.off("loadedmetadata",mpl.createMupOnMedia_),mpl.createMupOnMedia_=null),mpl.minimumUpdatePeriodTimeout_&&(window.clearTimeout(mpl.minimumUpdatePeriodTimeout_),mpl.minimumUpdatePeriodTimeout_=null);var mup=mpl.master&&mpl.master.minimumUpdatePeriod;0===mup&&(mpl.media()?mup=1e3*mpl.media().targetDuration:(mpl.createMupOnMedia_=mpl.updateMinimumUpdatePeriodTimeout_,mpl.one("loadedmetadata",mpl.createMupOnMedia_))),"number"!=typeof mup||mup<=0?mup<0&&this.logger_("found invalid minimumUpdatePeriod of "+mup+", not setting a timeout"):this.createMUPTimeout_(mup)},_proto.createMUPTimeout_=function(mup){var mpl=this.masterPlaylistLoader_;mpl.minimumUpdatePeriodTimeout_=window.setTimeout((function(){mpl.minimumUpdatePeriodTimeout_=null,mpl.trigger("minimumUpdatePeriod"),mpl.createMUPTimeout_(mup)}),mup)},_proto.refreshXml_=function(){var _this8=this;this.requestMaster_((function(req,masterChanged){var master,oldSidxMapping,mediaGroupSidx;masterChanged&&(_this8.media_&&(_this8.media_=_this8.masterPlaylistLoader_.master.playlists[_this8.media_.id]),_this8.masterPlaylistLoader_.sidxMapping_=(master=_this8.masterPlaylistLoader_.master,oldSidxMapping=_this8.masterPlaylistLoader_.sidxMapping_,mediaGroupSidx=compareSidxEntry(master.playlists,oldSidxMapping),forEachMediaGroup(master,(function(properties,mediaType,groupKey,labelKey){if(properties.playlists&&properties.playlists.length){var playlists=properties.playlists;mediaGroupSidx=mergeOptions(mediaGroupSidx,compareSidxEntry(playlists,oldSidxMapping))}})),mediaGroupSidx),_this8.addSidxSegments_(_this8.media(),_this8.state,(function(sidxChanged){_this8.refreshMedia_(_this8.media().id)})))}))},_proto.refreshMedia_=function(mediaID){var _this9=this;if(!mediaID)throw new Error("refreshMedia_ must take a media id");this.media_&&this.isMaster_&&this.handleMaster_();var playlists=this.masterPlaylistLoader_.master.playlists,mediaChanged=!this.media_||this.media_!==playlists[mediaID];if(mediaChanged?this.media_=playlists[mediaID]:this.trigger("playlistunchanged"),!this.mediaUpdateTimeout){!function createMediaUpdateTimeout(){_this9.media().endList||(_this9.mediaUpdateTimeout=window.setTimeout((function(){_this9.trigger("mediaupdatetimeout"),createMediaUpdateTimeout()}),refreshDelay(_this9.media(),Boolean(mediaChanged))))}()}this.trigger("loadedplaylist")},DashPlaylistLoader}(EventTarget),Config={GOAL_BUFFER_LENGTH:30,MAX_GOAL_BUFFER_LENGTH:60,BACK_BUFFER_LENGTH:30,GOAL_BUFFER_LENGTH_RATE:1,INITIAL_BANDWIDTH:4194304,BANDWIDTH_VARIANCE:1.2,BUFFER_LOW_WATER_LINE:0,MAX_BUFFER_LOW_WATER_LINE:30,EXPERIMENTAL_MAX_BUFFER_LOW_WATER_LINE:16,BUFFER_LOW_WATER_LINE_RATE:1,BUFFER_HIGH_WATER_LINE:30},browserWorkerPolyFill=function(workerObj){return workerObj.on=workerObj.addEventListener,workerObj.off=workerObj.removeEventListener,workerObj},factory=function(code){return function(){var objectUrl=function(str){try{return URL.createObjectURL(new Blob([str],{type:"application/javascript"}))}catch(e){var blob=new BlobBuilder;return blob.append(str),URL.createObjectURL(blob.getBlob())}}(code),worker=browserWorkerPolyFill(new Worker(objectUrl));worker.objURL=objectUrl;var terminate=worker.terminate;return worker.on=worker.addEventListener,worker.off=worker.removeEventListener,worker.terminate=function(){return URL.revokeObjectURL(objectUrl),terminate.call(this)},worker}},transform=function(code){return"var browserWorkerPolyFill = "+browserWorkerPolyFill.toString()+";\nbrowserWorkerPolyFill(self);\n"+code},getWorkerString=function(fn){return fn.toString().replace(/^function.+?{/,"").slice(0,-1)},workerCode$1=transform(getWorkerString((function(){var Stream=function(){this.init=function(){var listeners={};this.on=function(type,listener){listeners[type]||(listeners[type]=[]),listeners[type]=listeners[type].concat(listener)},this.off=function(type,listener){var index;return!!listeners[type]&&(index=listeners[type].indexOf(listener),listeners[type]=listeners[type].slice(),listeners[type].splice(index,1),index>-1)},this.trigger=function(type){var callbacks,i,length,args;if(callbacks=listeners[type])if(2===arguments.length)for(length=callbacks.length,i=0;i<length;++i)callbacks[i].call(this,arguments[1]);else{for(args=[],i=arguments.length,i=1;i<arguments.length;++i)args.push(arguments[i]);for(length=callbacks.length,i=0;i<length;++i)callbacks[i].apply(this,args)}},this.dispose=function(){listeners={}}}};Stream.prototype.pipe=function(destination){return this.on("data",(function(data){destination.push(data)})),this.on("done",(function(flushSource){destination.flush(flushSource)})),this.on("partialdone",(function(flushSource){destination.partialFlush(flushSource)})),this.on("endedtimeline",(function(flushSource){destination.endTimeline(flushSource)})),this.on("reset",(function(flushSource){destination.reset(flushSource)})),destination},Stream.prototype.push=function(data){this.trigger("data",data)},Stream.prototype.flush=function(flushSource){this.trigger("done",flushSource)},Stream.prototype.partialFlush=function(flushSource){this.trigger("partialdone",flushSource)},Stream.prototype.endTimeline=function(flushSource){this.trigger("endedtimeline",flushSource)},Stream.prototype.reset=function(flushSource){this.trigger("reset",flushSource)};var box,dinf,esds,ftyp,mfhd,minf,moof,moov,mvex,mvhd,trak,tkhd,mdia,mdhd,hdlr,sdtp,stbl,stsd,traf,trex,trun$1,types,MAJOR_BRAND,MINOR_VERSION,AVC1_BRAND,VIDEO_HDLR,AUDIO_HDLR,HDLR_TYPES,VMHD,SMHD,DREF,STCO,STSC,STSZ,STTS,videoSample,audioSample,audioTrun,videoTrun,trunHeader,stream=Stream,UINT32_MAX=Math.pow(2,32)-1;!function(){var i;if(types={avc1:[],avcC:[],btrt:[],dinf:[],dref:[],esds:[],ftyp:[],hdlr:[],mdat:[],mdhd:[],mdia:[],mfhd:[],minf:[],moof:[],moov:[],mp4a:[],mvex:[],mvhd:[],pasp:[],sdtp:[],smhd:[],stbl:[],stco:[],stsc:[],stsd:[],stsz:[],stts:[],styp:[],tfdt:[],tfhd:[],traf:[],trak:[],trun:[],trex:[],tkhd:[],vmhd:[]},"undefined"!=typeof Uint8Array){for(i in types)types.hasOwnProperty(i)&&(types[i]=[i.charCodeAt(0),i.charCodeAt(1),i.charCodeAt(2),i.charCodeAt(3)]);MAJOR_BRAND=new Uint8Array(["i".charCodeAt(0),"s".charCodeAt(0),"o".charCodeAt(0),"m".charCodeAt(0)]),AVC1_BRAND=new Uint8Array(["a".charCodeAt(0),"v".charCodeAt(0),"c".charCodeAt(0),"1".charCodeAt(0)]),MINOR_VERSION=new Uint8Array([0,0,0,1]),VIDEO_HDLR=new Uint8Array([0,0,0,0,0,0,0,0,118,105,100,101,0,0,0,0,0,0,0,0,0,0,0,0,86,105,100,101,111,72,97,110,100,108,101,114,0]),AUDIO_HDLR=new Uint8Array([0,0,0,0,0,0,0,0,115,111,117,110,0,0,0,0,0,0,0,0,0,0,0,0,83,111,117,110,100,72,97,110,100,108,101,114,0]),HDLR_TYPES={video:VIDEO_HDLR,audio:AUDIO_HDLR},DREF=new Uint8Array([0,0,0,0,0,0,0,1,0,0,0,12,117,114,108,32,0,0,0,1]),SMHD=new Uint8Array([0,0,0,0,0,0,0,0]),STCO=new Uint8Array([0,0,0,0,0,0,0,0]),STSC=STCO,STSZ=new Uint8Array([0,0,0,0,0,0,0,0,0,0,0,0]),STTS=STCO,VMHD=new Uint8Array([0,0,0,1,0,0,0,0,0,0,0,0])}}(),box=function(type){var i,result,payload=[],size=0;for(i=1;i<arguments.length;i++)payload.push(arguments[i]);for(i=payload.length;i--;)size+=payload[i].byteLength;for(result=new Uint8Array(size+8),new DataView(result.buffer,result.byteOffset,result.byteLength).setUint32(0,result.byteLength),result.set(type,4),i=0,size=8;i<payload.length;i++)result.set(payload[i],size),size+=payload[i].byteLength;return result},dinf=function(){return box(types.dinf,box(types.dref,DREF))},esds=function(track){return box(types.esds,new Uint8Array([0,0,0,0,3,25,0,0,0,4,17,64,21,0,6,0,0,0,218,192,0,0,218,192,5,2,track.audioobjecttype<<3|track.samplingfrequencyindex>>>1,track.samplingfrequencyindex<<7|track.channelcount<<3,6,1,2]))},hdlr=function(type){return box(types.hdlr,HDLR_TYPES[type])},mdhd=function(track){var result=new Uint8Array([0,0,0,0,0,0,0,2,0,0,0,3,0,1,95,144,track.duration>>>24&255,track.duration>>>16&255,track.duration>>>8&255,255&track.duration,85,196,0,0]);return track.samplerate&&(result[12]=track.samplerate>>>24&255,result[13]=track.samplerate>>>16&255,result[14]=track.samplerate>>>8&255,result[15]=255&track.samplerate),box(types.mdhd,result)},mdia=function(track){return box(types.mdia,mdhd(track),hdlr(track.type),minf(track))},mfhd=function(sequenceNumber){return box(types.mfhd,new Uint8Array([0,0,0,0,(4278190080&sequenceNumber)>>24,(16711680&sequenceNumber)>>16,(65280&sequenceNumber)>>8,255&sequenceNumber]))},minf=function(track){return box(types.minf,"video"===track.type?box(types.vmhd,VMHD):box(types.smhd,SMHD),dinf(),stbl(track))},moof=function(sequenceNumber,tracks){for(var trackFragments=[],i=tracks.length;i--;)trackFragments[i]=traf(tracks[i]);return box.apply(null,[types.moof,mfhd(sequenceNumber)].concat(trackFragments))},moov=function(tracks){for(var i=tracks.length,boxes=[];i--;)boxes[i]=trak(tracks[i]);return box.apply(null,[types.moov,mvhd(4294967295)].concat(boxes).concat(mvex(tracks)))},mvex=function(tracks){for(var i=tracks.length,boxes=[];i--;)boxes[i]=trex(tracks[i]);return box.apply(null,[types.mvex].concat(boxes))},mvhd=function(duration){var bytes=new Uint8Array([0,0,0,0,0,0,0,1,0,0,0,2,0,1,95,144,(4278190080&duration)>>24,(16711680&duration)>>16,(65280&duration)>>8,255&duration,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255]);return box(types.mvhd,bytes)},sdtp=function(track){var flags,i,samples=track.samples||[],bytes=new Uint8Array(4+samples.length);for(i=0;i<samples.length;i++)flags=samples[i].flags,bytes[i+4]=flags.dependsOn<<4|flags.isDependedOn<<2|flags.hasRedundancy;return box(types.sdtp,bytes)},stbl=function(track){return box(types.stbl,stsd(track),box(types.stts,STTS),box(types.stsc,STSC),box(types.stsz,STSZ),box(types.stco,STCO))},stsd=function(track){return box(types.stsd,new Uint8Array([0,0,0,0,0,0,0,1]),"video"===track.type?videoSample(track):audioSample(track))},videoSample=function(track){var i,avc1Box,sps=track.sps||[],pps=track.pps||[],sequenceParameterSets=[],pictureParameterSets=[];for(i=0;i<sps.length;i++)sequenceParameterSets.push((65280&sps[i].byteLength)>>>8),sequenceParameterSets.push(255&sps[i].byteLength),sequenceParameterSets=sequenceParameterSets.concat(Array.prototype.slice.call(sps[i]));for(i=0;i<pps.length;i++)pictureParameterSets.push((65280&pps[i].byteLength)>>>8),pictureParameterSets.push(255&pps[i].byteLength),pictureParameterSets=pictureParameterSets.concat(Array.prototype.slice.call(pps[i]));if(avc1Box=[types.avc1,new Uint8Array([0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,(65280&track.width)>>8,255&track.width,(65280&track.height)>>8,255&track.height,0,72,0,0,0,72,0,0,0,0,0,0,0,1,19,118,105,100,101,111,106,115,45,99,111,110,116,114,105,98,45,104,108,115,0,0,0,0,0,0,0,0,0,0,0,0,0,24,17,17]),box(types.avcC,new Uint8Array([1,track.profileIdc,track.profileCompatibility,track.levelIdc,255].concat([sps.length],sequenceParameterSets,[pps.length],pictureParameterSets))),box(types.btrt,new Uint8Array([0,28,156,128,0,45,198,192,0,45,198,192]))],track.sarRatio){var hSpacing=track.sarRatio[0],vSpacing=track.sarRatio[1];avc1Box.push(box(types.pasp,new Uint8Array([(4278190080&hSpacing)>>24,(16711680&hSpacing)>>16,(65280&hSpacing)>>8,255&hSpacing,(4278190080&vSpacing)>>24,(16711680&vSpacing)>>16,(65280&vSpacing)>>8,255&vSpacing])))}return box.apply(null,avc1Box)},audioSample=function(track){return box(types.mp4a,new Uint8Array([0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,(65280&track.channelcount)>>8,255&track.channelcount,(65280&track.samplesize)>>8,255&track.samplesize,0,0,0,0,(65280&track.samplerate)>>8,255&track.samplerate,0,0]),esds(track))},tkhd=function(track){var result=new Uint8Array([0,0,0,7,0,0,0,0,0,0,0,0,(4278190080&track.id)>>24,(16711680&track.id)>>16,(65280&track.id)>>8,255&track.id,0,0,0,0,(4278190080&track.duration)>>24,(16711680&track.duration)>>16,(65280&track.duration)>>8,255&track.duration,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,64,0,0,0,(65280&track.width)>>8,255&track.width,0,0,(65280&track.height)>>8,255&track.height,0,0]);return box(types.tkhd,result)},traf=function(track){var trackFragmentHeader,trackFragmentDecodeTime,trackFragmentRun,sampleDependencyTable,upperWordBaseMediaDecodeTime,lowerWordBaseMediaDecodeTime;return trackFragmentHeader=box(types.tfhd,new Uint8Array([0,0,0,58,(4278190080&track.id)>>24,(16711680&track.id)>>16,(65280&track.id)>>8,255&track.id,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0])),upperWordBaseMediaDecodeTime=Math.floor(track.baseMediaDecodeTime/(UINT32_MAX+1)),lowerWordBaseMediaDecodeTime=Math.floor(track.baseMediaDecodeTime%(UINT32_MAX+1)),trackFragmentDecodeTime=box(types.tfdt,new Uint8Array([1,0,0,0,upperWordBaseMediaDecodeTime>>>24&255,upperWordBaseMediaDecodeTime>>>16&255,upperWordBaseMediaDecodeTime>>>8&255,255&upperWordBaseMediaDecodeTime,lowerWordBaseMediaDecodeTime>>>24&255,lowerWordBaseMediaDecodeTime>>>16&255,lowerWordBaseMediaDecodeTime>>>8&255,255&lowerWordBaseMediaDecodeTime])),92,"audio"===track.type?(trackFragmentRun=trun$1(track,92),box(types.traf,trackFragmentHeader,trackFragmentDecodeTime,trackFragmentRun)):(sampleDependencyTable=sdtp(track),trackFragmentRun=trun$1(track,sampleDependencyTable.length+92),box(types.traf,trackFragmentHeader,trackFragmentDecodeTime,trackFragmentRun,sampleDependencyTable))},trak=function(track){return track.duration=track.duration||4294967295,box(types.trak,tkhd(track),mdia(track))},trex=function(track){var result=new Uint8Array([0,0,0,0,(4278190080&track.id)>>24,(16711680&track.id)>>16,(65280&track.id)>>8,255&track.id,0,0,0,1,0,0,0,0,0,0,0,0,0,1,0,1]);return"video"!==track.type&&(result[result.length-1]=0),box(types.trex,result)},trunHeader=function(samples,offset){var durationPresent=0,sizePresent=0,flagsPresent=0,compositionTimeOffset=0;return samples.length&&(void 0!==samples[0].duration&&(durationPresent=1),void 0!==samples[0].size&&(sizePresent=2),void 0!==samples[0].flags&&(flagsPresent=4),void 0!==samples[0].compositionTimeOffset&&(compositionTimeOffset=8)),[0,0,durationPresent|sizePresent|flagsPresent|compositionTimeOffset,1,(4278190080&samples.length)>>>24,(16711680&samples.length)>>>16,(65280&samples.length)>>>8,255&samples.length,(4278190080&offset)>>>24,(16711680&offset)>>>16,(65280&offset)>>>8,255&offset]},videoTrun=function(track,offset){var bytesOffest,bytes,header,samples,sample,i;for(offset+=20+16*(samples=track.samples||[]).length,header=trunHeader(samples,offset),(bytes=new Uint8Array(header.length+16*samples.length)).set(header),bytesOffest=header.length,i=0;i<samples.length;i++)sample=samples[i],bytes[bytesOffest++]=(4278190080&sample.duration)>>>24,bytes[bytesOffest++]=(16711680&sample.duration)>>>16,bytes[bytesOffest++]=(65280&sample.duration)>>>8,bytes[bytesOffest++]=255&sample.duration,bytes[bytesOffest++]=(4278190080&sample.size)>>>24,bytes[bytesOffest++]=(16711680&sample.size)>>>16,bytes[bytesOffest++]=(65280&sample.size)>>>8,bytes[bytesOffest++]=255&sample.size,bytes[bytesOffest++]=sample.flags.isLeading<<2|sample.flags.dependsOn,bytes[bytesOffest++]=sample.flags.isDependedOn<<6|sample.flags.hasRedundancy<<4|sample.flags.paddingValue<<1|sample.flags.isNonSyncSample,bytes[bytesOffest++]=61440&sample.flags.degradationPriority,bytes[bytesOffest++]=15&sample.flags.degradationPriority,bytes[bytesOffest++]=(4278190080&sample.compositionTimeOffset)>>>24,bytes[bytesOffest++]=(16711680&sample.compositionTimeOffset)>>>16,bytes[bytesOffest++]=(65280&sample.compositionTimeOffset)>>>8,bytes[bytesOffest++]=255&sample.compositionTimeOffset;return box(types.trun,bytes)},audioTrun=function(track,offset){var bytes,bytesOffest,header,samples,sample,i;for(offset+=20+8*(samples=track.samples||[]).length,header=trunHeader(samples,offset),(bytes=new Uint8Array(header.length+8*samples.length)).set(header),bytesOffest=header.length,i=0;i<samples.length;i++)sample=samples[i],bytes[bytesOffest++]=(4278190080&sample.duration)>>>24,bytes[bytesOffest++]=(16711680&sample.duration)>>>16,bytes[bytesOffest++]=(65280&sample.duration)>>>8,bytes[bytesOffest++]=255&sample.duration,bytes[bytesOffest++]=(4278190080&sample.size)>>>24,bytes[bytesOffest++]=(16711680&sample.size)>>>16,bytes[bytesOffest++]=(65280&sample.size)>>>8,bytes[bytesOffest++]=255&sample.size;return box(types.trun,bytes)},trun$1=function(track,offset){return"audio"===track.type?audioTrun(track,offset):videoTrun(track,offset)};ftyp=function(){return box(types.ftyp,MAJOR_BRAND,MINOR_VERSION,MAJOR_BRAND,AVC1_BRAND)};var silence,secondsToVideoTs,secondsToAudioTs,videoTsToSeconds,audioTsToSeconds,audioTsToVideoTs,videoTsToAudioTs,metadataTsToSeconds,mp4Generator_mdat=function(data){return box(types.mdat,data)},mp4Generator_moof=moof,mp4Generator_initSegment=function(tracks){var result,fileType=ftyp(),movie=moov(tracks);return(result=new Uint8Array(fileType.byteLength+movie.byteLength)).set(fileType),result.set(movie,fileType.byteLength),result},sampleForFrame=function(frame,dataOffset){var sample={size:0,flags:{isLeading:0,dependsOn:1,isDependedOn:0,hasRedundancy:0,degradationPriority:0,isNonSyncSample:1}};return sample.dataOffset=dataOffset,sample.compositionTimeOffset=frame.pts-frame.dts,sample.duration=frame.duration,sample.size=4*frame.length,sample.size+=frame.byteLength,frame.keyFrame&&(sample.flags.dependsOn=2,sample.flags.isNonSyncSample=0),sample},frameUtils_groupNalsIntoFrames=function(nalUnits){var i,currentNal,currentFrame=[],frames=[];for(frames.byteLength=0,frames.nalCount=0,frames.duration=0,currentFrame.byteLength=0,i=0;i<nalUnits.length;i++)"access_unit_delimiter_rbsp"===(currentNal=nalUnits[i]).nalUnitType?(currentFrame.length&&(currentFrame.duration=currentNal.dts-currentFrame.dts,frames.byteLength+=currentFrame.byteLength,frames.nalCount+=currentFrame.length,frames.duration+=currentFrame.duration,frames.push(currentFrame)),(currentFrame=[currentNal]).byteLength=currentNal.data.byteLength,currentFrame.pts=currentNal.pts,currentFrame.dts=currentNal.dts):("slice_layer_without_partitioning_rbsp_idr"===currentNal.nalUnitType&&(currentFrame.keyFrame=!0),currentFrame.duration=currentNal.dts-currentFrame.dts,currentFrame.byteLength+=currentNal.data.byteLength,currentFrame.push(currentNal));return frames.length&&(!currentFrame.duration||currentFrame.duration<=0)&&(currentFrame.duration=frames[frames.length-1].duration),frames.byteLength+=currentFrame.byteLength,frames.nalCount+=currentFrame.length,frames.duration+=currentFrame.duration,frames.push(currentFrame),frames},frameUtils_groupFramesIntoGops=function(frames){var i,currentFrame,currentGop=[],gops=[];for(currentGop.byteLength=0,currentGop.nalCount=0,currentGop.duration=0,currentGop.pts=frames[0].pts,currentGop.dts=frames[0].dts,gops.byteLength=0,gops.nalCount=0,gops.duration=0,gops.pts=frames[0].pts,gops.dts=frames[0].dts,i=0;i<frames.length;i++)(currentFrame=frames[i]).keyFrame?(currentGop.length&&(gops.push(currentGop),gops.byteLength+=currentGop.byteLength,gops.nalCount+=currentGop.nalCount,gops.duration+=currentGop.duration),(currentGop=[currentFrame]).nalCount=currentFrame.length,currentGop.byteLength=currentFrame.byteLength,currentGop.pts=currentFrame.pts,currentGop.dts=currentFrame.dts,currentGop.duration=currentFrame.duration):(currentGop.duration+=currentFrame.duration,currentGop.nalCount+=currentFrame.length,currentGop.byteLength+=currentFrame.byteLength,currentGop.push(currentFrame));return gops.length&&currentGop.duration<=0&&(currentGop.duration=gops[gops.length-1].duration),gops.byteLength+=currentGop.byteLength,gops.nalCount+=currentGop.nalCount,gops.duration+=currentGop.duration,gops.push(currentGop),gops},frameUtils_extendFirstKeyFrame=function(gops){var currentGop;return!gops[0][0].keyFrame&&gops.length>1&&(currentGop=gops.shift(),gops.byteLength-=currentGop.byteLength,gops.nalCount-=currentGop.nalCount,gops[0][0].dts=currentGop.dts,gops[0][0].pts=currentGop.pts,gops[0][0].duration+=currentGop.duration),gops},frameUtils_generateSampleTable=function(gops,baseDataOffset){var h,i,sample,currentGop,currentFrame,dataOffset=baseDataOffset||0,samples=[];for(h=0;h<gops.length;h++)for(currentGop=gops[h],i=0;i<currentGop.length;i++)currentFrame=currentGop[i],dataOffset+=(sample=sampleForFrame(currentFrame,dataOffset)).size,samples.push(sample);return samples},frameUtils_concatenateNalData=function(gops){var h,i,j,currentGop,currentFrame,currentNal,dataOffset=0,nalsByteLength=gops.byteLength,numberOfNals=gops.nalCount,data=new Uint8Array(nalsByteLength+4*numberOfNals),view=new DataView(data.buffer);for(h=0;h<gops.length;h++)for(currentGop=gops[h],i=0;i<currentGop.length;i++)for(currentFrame=currentGop[i],j=0;j<currentFrame.length;j++)currentNal=currentFrame[j],view.setUint32(dataOffset,currentNal.data.byteLength),dataOffset+=4,data.set(currentNal.data,dataOffset),dataOffset+=currentNal.data.byteLength;return data},highPrefix=[33,16,5,32,164,27],lowPrefix=[33,65,108,84,1,2,4,8,168,2,4,8,17,191,252],zeroFill=function(count){for(var a=[];count--;)a.push(0);return a},silence_1=function(){if(!silence){var coneOfSilence={96e3:[highPrefix,[227,64],zeroFill(154),[56]],88200:[highPrefix,[231],zeroFill(170),[56]],64e3:[highPrefix,[248,192],zeroFill(240),[56]],48e3:[highPrefix,[255,192],zeroFill(268),[55,148,128],zeroFill(54),[112]],44100:[highPrefix,[255,192],zeroFill(268),[55,163,128],zeroFill(84),[112]],32e3:[highPrefix,[255,192],zeroFill(268),[55,234],zeroFill(226),[112]],24e3:[highPrefix,[255,192],zeroFill(268),[55,255,128],zeroFill(268),[111,112],zeroFill(126),[224]],16e3:[highPrefix,[255,192],zeroFill(268),[55,255,128],zeroFill(268),[111,255],zeroFill(269),[223,108],zeroFill(195),[1,192]],12e3:[lowPrefix,zeroFill(268),[3,127,248],zeroFill(268),[6,255,240],zeroFill(268),[13,255,224],zeroFill(268),[27,253,128],zeroFill(259),[56]],11025:[lowPrefix,zeroFill(268),[3,127,248],zeroFill(268),[6,255,240],zeroFill(268),[13,255,224],zeroFill(268),[27,255,192],zeroFill(268),[55,175,128],zeroFill(108),[112]],8e3:[lowPrefix,zeroFill(268),[3,121,16],zeroFill(47),[7]]};metaTable=coneOfSilence,silence=Object.keys(metaTable).reduce((function(obj,key){return obj[key]=new Uint8Array(metaTable[key].reduce((function(arr,part){return arr.concat(part)}),[])),obj}),{})}var metaTable;return silence};audioTsToVideoTs=function(timestamp,sampleRate){return secondsToVideoTs(audioTsToSeconds(timestamp,sampleRate))},videoTsToAudioTs=function(timestamp,sampleRate){return secondsToAudioTs(videoTsToSeconds(timestamp),sampleRate)},metadataTsToSeconds=function(timestamp,timelineStartPts,keepOriginalTimestamps){return videoTsToSeconds(keepOriginalTimestamps?timestamp:timestamp-timelineStartPts)};var clock_ONE_SECOND_IN_TS$0=9e4,clock_secondsToVideoTs$0=secondsToVideoTs=function(seconds){return 9e4*seconds},clock_videoTsToSeconds$0=(secondsToAudioTs=function(seconds,sampleRate){return seconds*sampleRate},videoTsToSeconds=function(timestamp){return timestamp/9e4}),clock_audioTsToVideoTs$0=(audioTsToSeconds=function(timestamp,sampleRate){return timestamp/sampleRate},audioTsToVideoTs),clock_videoTsToAudioTs$0=videoTsToAudioTs,clock_metadataTsToSeconds$0=metadataTsToSeconds,audioFrameUtils_prefixWithSilence=function(track,frames,audioAppendStartTs,videoBaseMediaDecodeTime){var baseMediaDecodeTimeTs,frameDuration,silentFrame,i,firstFrame,audioGapDuration=0,audioFillFrameCount=0,audioFillDuration=0;if(frames.length&&(baseMediaDecodeTimeTs=clock_audioTsToVideoTs$0(track.baseMediaDecodeTime,track.samplerate),frameDuration=Math.ceil(clock_ONE_SECOND_IN_TS$0/(track.samplerate/1024)),audioAppendStartTs&&videoBaseMediaDecodeTime&&(audioGapDuration=baseMediaDecodeTimeTs-Math.max(audioAppendStartTs,videoBaseMediaDecodeTime),audioFillDuration=(audioFillFrameCount=Math.floor(audioGapDuration/frameDuration))*frameDuration),!(audioFillFrameCount<1||audioFillDuration>clock_ONE_SECOND_IN_TS$0/2))){for((silentFrame=silence_1()[track.samplerate])||(silentFrame=frames[0].data),i=0;i<audioFillFrameCount;i++)firstFrame=frames[0],frames.splice(0,0,{data:silentFrame,dts:firstFrame.dts-frameDuration,pts:firstFrame.pts-frameDuration});return track.baseMediaDecodeTime-=Math.floor(clock_videoTsToAudioTs$0(audioFillDuration,track.samplerate)),audioFillDuration}},audioFrameUtils_trimAdtsFramesByEarliestDts=function(adtsFrames,track,earliestAllowedDts){return track.minSegmentDts>=earliestAllowedDts?adtsFrames:(track.minSegmentDts=1/0,adtsFrames.filter((function(currentFrame){return currentFrame.dts>=earliestAllowedDts&&(track.minSegmentDts=Math.min(track.minSegmentDts,currentFrame.dts),track.minSegmentPts=track.minSegmentDts,!0)})))},audioFrameUtils_generateSampleTable=function(frames){var i,currentFrame,samples=[];for(i=0;i<frames.length;i++)currentFrame=frames[i],samples.push({size:currentFrame.data.byteLength,duration:1024});return samples},audioFrameUtils_concatenateFrameData=function(frames){var i,currentFrame,dataOffset=0,data=new Uint8Array(function(array){var i,sum=0;for(i=0;i<array.length;i++)sum+=array[i].data.byteLength;return sum}(frames));for(i=0;i<frames.length;i++)currentFrame=frames[i],data.set(currentFrame.data,dataOffset),dataOffset+=currentFrame.data.byteLength;return data},ONE_SECOND_IN_TS$3=clock_ONE_SECOND_IN_TS$0,trackDecodeInfo_clearDtsInfo=function(track){delete track.minSegmentDts,delete track.maxSegmentDts,delete track.minSegmentPts,delete track.maxSegmentPts},trackDecodeInfo_calculateTrackBaseMediaDecodeTime=function(track,keepOriginalTimestamps){var baseMediaDecodeTime,minSegmentDts=track.minSegmentDts;return keepOriginalTimestamps||(minSegmentDts-=track.timelineStartInfo.dts),baseMediaDecodeTime=track.timelineStartInfo.baseMediaDecodeTime,baseMediaDecodeTime+=minSegmentDts,baseMediaDecodeTime=Math.max(0,baseMediaDecodeTime),"audio"===track.type&&(baseMediaDecodeTime*=track.samplerate/ONE_SECOND_IN_TS$3,baseMediaDecodeTime=Math.floor(baseMediaDecodeTime)),baseMediaDecodeTime},trackDecodeInfo_collectDtsInfo=function(track,data){"number"==typeof data.pts&&(void 0===track.timelineStartInfo.pts&&(track.timelineStartInfo.pts=data.pts),void 0===track.minSegmentPts?track.minSegmentPts=data.pts:track.minSegmentPts=Math.min(track.minSegmentPts,data.pts),void 0===track.maxSegmentPts?track.maxSegmentPts=data.pts:track.maxSegmentPts=Math.max(track.maxSegmentPts,data.pts)),"number"==typeof data.dts&&(void 0===track.timelineStartInfo.dts&&(track.timelineStartInfo.dts=data.dts),void 0===track.minSegmentDts?track.minSegmentDts=data.dts:track.minSegmentDts=Math.min(track.minSegmentDts,data.dts),void 0===track.maxSegmentDts?track.maxSegmentDts=data.dts:track.maxSegmentDts=Math.max(track.maxSegmentDts,data.dts))},captionPacketParser_parseSei=function(bytes){for(var i=0,result={payloadType:-1,payloadSize:0},payloadType=0,payloadSize=0;i<bytes.byteLength&&128!==bytes[i];){for(;255===bytes[i];)payloadType+=255,i++;for(payloadType+=bytes[i++];255===bytes[i];)payloadSize+=255,i++;if(payloadSize+=bytes[i++],!result.payload&&4===payloadType){if("GA94"===String.fromCharCode(bytes[i+3],bytes[i+4],bytes[i+5],bytes[i+6])){result.payloadType=payloadType,result.payloadSize=payloadSize,result.payload=bytes.subarray(i,i+payloadSize);break}result.payload=void 0}i+=payloadSize,payloadType=0,payloadSize=0}return result},captionPacketParser_parseUserData=function(sei){return 181!==sei.payload[0]||49!=(sei.payload[1]<<8|sei.payload[2])||"GA94"!==String.fromCharCode(sei.payload[3],sei.payload[4],sei.payload[5],sei.payload[6])||3!==sei.payload[7]?null:sei.payload.subarray(8,sei.payload.length-1)},captionPacketParser_parseCaptionPackets=function(pts,userData){var i,count,offset,data,results=[];if(!(64&userData[0]))return results;for(count=31&userData[0],i=0;i<count;i++)data={type:3&userData[(offset=3*i)+2],pts:pts},4&userData[offset+2]&&(data.ccData=userData[offset+3]<<8|userData[offset+4],results.push(data));return results},captionPacketParser_discardEmulationPreventionBytes=function(data){for(var newLength,newData,length=data.byteLength,emulationPreventionBytesPositions=[],i=1;i<length-2;)0===data[i]&&0===data[i+1]&&3===data[i+2]?(emulationPreventionBytesPositions.push(i+2),i+=2):i++;if(0===emulationPreventionBytesPositions.length)return data;newLength=length-emulationPreventionBytesPositions.length,newData=new Uint8Array(newLength);var sourceIndex=0;for(i=0;i<newLength;sourceIndex++,i++)sourceIndex===emulationPreventionBytesPositions[0]&&(sourceIndex++,emulationPreventionBytesPositions.shift()),newData[i]=data[sourceIndex];return newData},captionPacketParser_USER_DATA_REGISTERED_ITU_T_T35=4,CaptionStream$1=function CaptionStream(options){options=options||{},CaptionStream.prototype.init.call(this),this.parse708captions_="boolean"!=typeof options.parse708captions||options.parse708captions,this.captionPackets_=[],this.ccStreams_=[new Cea608Stream(0,0),new Cea608Stream(0,1),new Cea608Stream(1,0),new Cea608Stream(1,1)],this.parse708captions_&&(this.cc708Stream_=new Cea708Stream({captionServices:options.captionServices})),this.reset(),this.ccStreams_.forEach((function(cc){cc.on("data",this.trigger.bind(this,"data")),cc.on("partialdone",this.trigger.bind(this,"partialdone")),cc.on("done",this.trigger.bind(this,"done"))}),this),this.parse708captions_&&(this.cc708Stream_.on("data",this.trigger.bind(this,"data")),this.cc708Stream_.on("partialdone",this.trigger.bind(this,"partialdone")),this.cc708Stream_.on("done",this.trigger.bind(this,"done")))};(CaptionStream$1.prototype=new stream).push=function(event){var sei,userData,newCaptionPackets;if("sei_rbsp"===event.nalUnitType&&(sei=captionPacketParser_parseSei(event.escapedRBSP)).payload&&sei.payloadType===captionPacketParser_USER_DATA_REGISTERED_ITU_T_T35&&(userData=captionPacketParser_parseUserData(sei)))if(event.dts<this.latestDts_)this.ignoreNextEqualDts_=!0;else{if(event.dts===this.latestDts_&&this.ignoreNextEqualDts_)return this.numSameDts_--,void(this.numSameDts_||(this.ignoreNextEqualDts_=!1));newCaptionPackets=captionPacketParser_parseCaptionPackets(event.pts,userData),this.captionPackets_=this.captionPackets_.concat(newCaptionPackets),this.latestDts_!==event.dts&&(this.numSameDts_=0),this.numSameDts_++,this.latestDts_=event.dts}},CaptionStream$1.prototype.flushCCStreams=function(flushType){this.ccStreams_.forEach((function(cc){return"flush"===flushType?cc.flush():cc.partialFlush()}),this)},CaptionStream$1.prototype.flushStream=function(flushType){this.captionPackets_.length?(this.captionPackets_.forEach((function(elem,idx){elem.presortIndex=idx})),this.captionPackets_.sort((function(a,b){return a.pts===b.pts?a.presortIndex-b.presortIndex:a.pts-b.pts})),this.captionPackets_.forEach((function(packet){packet.type<2?this.dispatchCea608Packet(packet):this.dispatchCea708Packet(packet)}),this),this.captionPackets_.length=0,this.flushCCStreams(flushType)):this.flushCCStreams(flushType)},CaptionStream$1.prototype.flush=function(){return this.flushStream("flush")},CaptionStream$1.prototype.partialFlush=function(){return this.flushStream("partialFlush")},CaptionStream$1.prototype.reset=function(){this.latestDts_=null,this.ignoreNextEqualDts_=!1,this.numSameDts_=0,this.activeCea608Channel_=[null,null],this.ccStreams_.forEach((function(ccStream){ccStream.reset()}))},CaptionStream$1.prototype.dispatchCea608Packet=function(packet){this.setsTextOrXDSActive(packet)?this.activeCea608Channel_[packet.type]=null:this.setsChannel1Active(packet)?this.activeCea608Channel_[packet.type]=0:this.setsChannel2Active(packet)&&(this.activeCea608Channel_[packet.type]=1),null!==this.activeCea608Channel_[packet.type]&&this.ccStreams_[(packet.type<<1)+this.activeCea608Channel_[packet.type]].push(packet)},CaptionStream$1.prototype.setsChannel1Active=function(packet){return 4096==(30720&packet.ccData)},CaptionStream$1.prototype.setsChannel2Active=function(packet){return 6144==(30720&packet.ccData)},CaptionStream$1.prototype.setsTextOrXDSActive=function(packet){return 256==(28928&packet.ccData)||4138==(30974&packet.ccData)||6186==(30974&packet.ccData)},CaptionStream$1.prototype.dispatchCea708Packet=function(packet){this.parse708captions_&&this.cc708Stream_.push(packet)};var CHARACTER_TRANSLATION_708={127:9834,4128:32,4129:160,4133:8230,4138:352,4140:338,4144:9608,4145:8216,4146:8217,4147:8220,4148:8221,4149:8226,4153:8482,4154:353,4156:339,4157:8480,4159:376,4214:8539,4215:8540,4216:8541,4217:8542,4218:9168,4219:9124,4220:9123,4221:9135,4222:9126,4223:9121,4256:12600},within708TextBlock=function(b){return 32<=b&&b<=127||160<=b&&b<=255},Cea708Window=function(windowNum){this.windowNum=windowNum,this.reset()};Cea708Window.prototype.reset=function(){this.clearText(),this.pendingNewLine=!1,this.winAttr={},this.penAttr={},this.penLoc={},this.penColor={},this.visible=0,this.rowLock=0,this.columnLock=0,this.priority=0,this.relativePositioning=0,this.anchorVertical=0,this.anchorHorizontal=0,this.anchorPoint=0,this.rowCount=1,this.virtualRowCount=this.rowCount+1,this.columnCount=41,this.windowStyle=0,this.penStyle=0},Cea708Window.prototype.getText=function(){return this.rows.join("\n")},Cea708Window.prototype.clearText=function(){this.rows=[""],this.rowIdx=0},Cea708Window.prototype.newLine=function(pts){for(this.rows.length>=this.virtualRowCount&&"function"==typeof this.beforeRowOverflow&&this.beforeRowOverflow(pts),this.rows.length>0&&(this.rows.push(""),this.rowIdx++);this.rows.length>this.virtualRowCount;)this.rows.shift(),this.rowIdx--},Cea708Window.prototype.isEmpty=function(){return 0===this.rows.length||1===this.rows.length&&""===this.rows[0]},Cea708Window.prototype.addText=function(text){this.rows[this.rowIdx]+=text},Cea708Window.prototype.backspace=function(){if(!this.isEmpty()){var row=this.rows[this.rowIdx];this.rows[this.rowIdx]=row.substr(0,row.length-1)}};var Cea708Service=function(serviceNum,encoding,stream){this.serviceNum=serviceNum,this.text="",this.currentWindow=new Cea708Window(-1),this.windows=[],this.stream=stream,"string"==typeof encoding&&this.createTextDecoder(encoding)};Cea708Service.prototype.init=function(pts,beforeRowOverflow){this.startPts=pts;for(var win=0;win<8;win++)this.windows[win]=new Cea708Window(win),"function"==typeof beforeRowOverflow&&(this.windows[win].beforeRowOverflow=beforeRowOverflow)},Cea708Service.prototype.setCurrentWindow=function(windowNum){this.currentWindow=this.windows[windowNum]},Cea708Service.prototype.createTextDecoder=function(encoding){if("undefined"==typeof TextDecoder)this.stream.trigger("log",{level:"warn",message:"The `encoding` option is unsupported without TextDecoder support"});else try{this.textDecoder_=new TextDecoder(encoding)}catch(error){this.stream.trigger("log",{level:"warn",message:"TextDecoder could not be created with "+encoding+" encoding. "+error})}};var Cea708Stream=function Cea708Stream(options){options=options||{},Cea708Stream.prototype.init.call(this);var serviceProps,self=this,captionServices=options.captionServices||{},captionServiceEncodings={};Object.keys(captionServices).forEach((function(serviceName){serviceProps=captionServices[serviceName],/^SERVICE/.test(serviceName)&&(captionServiceEncodings[serviceName]=serviceProps.encoding)})),this.serviceEncodings=captionServiceEncodings,this.current708Packet=null,this.services={},this.push=function(packet){3===packet.type?(self.new708Packet(),self.add708Bytes(packet)):(null===self.current708Packet&&self.new708Packet(),self.add708Bytes(packet))}};Cea708Stream.prototype=new stream,Cea708Stream.prototype.new708Packet=function(){null!==this.current708Packet&&this.push708Packet(),this.current708Packet={data:[],ptsVals:[]}},Cea708Stream.prototype.add708Bytes=function(packet){var data=packet.ccData,byte0=data>>>8,byte1=255&data;this.current708Packet.ptsVals.push(packet.pts),this.current708Packet.data.push(byte0),this.current708Packet.data.push(byte1)},Cea708Stream.prototype.push708Packet=function(){var packet708=this.current708Packet,packetData=packet708.data,serviceNum=null,blockSize=null,i=0,b=packetData[i++];for(packet708.seq=b>>6,packet708.sizeCode=63&b;i<packetData.length;i++)blockSize=31&(b=packetData[i++]),7===(serviceNum=b>>5)&&blockSize>0&&(serviceNum=b=packetData[i++]),this.pushServiceBlock(serviceNum,i,blockSize),blockSize>0&&(i+=blockSize-1)},Cea708Stream.prototype.pushServiceBlock=function(serviceNum,start,size){var b,i=start,packetData=this.current708Packet.data,service=this.services[serviceNum];for(service||(service=this.initService(serviceNum,i));i<start+size&&i<packetData.length;i++)b=packetData[i],within708TextBlock(b)?i=this.handleText(i,service):24===b?i=this.multiByteCharacter(i,service):16===b?i=this.extendedCommands(i,service):128<=b&&b<=135?i=this.setCurrentWindow(i,service):152<=b&&b<=159?i=this.defineWindow(i,service):136===b?i=this.clearWindows(i,service):140===b?i=this.deleteWindows(i,service):137===b?i=this.displayWindows(i,service):138===b?i=this.hideWindows(i,service):139===b?i=this.toggleWindows(i,service):151===b?i=this.setWindowAttributes(i,service):144===b?i=this.setPenAttributes(i,service):145===b?i=this.setPenColor(i,service):146===b?i=this.setPenLocation(i,service):143===b?service=this.reset(i,service):8===b?service.currentWindow.backspace():12===b?service.currentWindow.clearText():13===b?service.currentWindow.pendingNewLine=!0:14===b?service.currentWindow.clearText():141===b&&i++},Cea708Stream.prototype.extendedCommands=function(i,service){var b=this.current708Packet.data[++i];return within708TextBlock(b)&&(i=this.handleText(i,service,{isExtended:!0})),i},Cea708Stream.prototype.getPts=function(byteIndex){return this.current708Packet.ptsVals[Math.floor(byteIndex/2)]},Cea708Stream.prototype.initService=function(serviceNum,i){var serviceName,encoding,self=this;return(serviceName="SERVICE"+serviceNum)in this.serviceEncodings&&(encoding=this.serviceEncodings[serviceName]),this.services[serviceNum]=new Cea708Service(serviceNum,encoding,self),this.services[serviceNum].init(this.getPts(i),(function(pts){self.flushDisplayed(pts,self.services[serviceNum])})),this.services[serviceNum]},Cea708Stream.prototype.handleText=function(i,service,options){var _char,charCodeArray,code,newCode,isExtended=options&&options.isExtended,isMultiByte=options&&options.isMultiByte,packetData=this.current708Packet.data,extended=isExtended?4096:0,currentByte=packetData[i],nextByte=packetData[i+1],win=service.currentWindow;return service.textDecoder_&&!isExtended?(isMultiByte?(charCodeArray=[currentByte,nextByte],i++):charCodeArray=[currentByte],_char=service.textDecoder_.decode(new Uint8Array(charCodeArray))):(newCode=CHARACTER_TRANSLATION_708[code=extended|currentByte]||code,_char=4096&code&&code===newCode?"":String.fromCharCode(newCode)),win.pendingNewLine&&!win.isEmpty()&&win.newLine(this.getPts(i)),win.pendingNewLine=!1,win.addText(_char),i},Cea708Stream.prototype.multiByteCharacter=function(i,service){var packetData=this.current708Packet.data,firstByte=packetData[i+1],secondByte=packetData[i+2];return within708TextBlock(firstByte)&&within708TextBlock(secondByte)&&(i=this.handleText(++i,service,{isMultiByte:!0})),i},Cea708Stream.prototype.setCurrentWindow=function(i,service){var windowNum=7&this.current708Packet.data[i];return service.setCurrentWindow(windowNum),i},Cea708Stream.prototype.defineWindow=function(i,service){var packetData=this.current708Packet.data,b=packetData[i],windowNum=7&b;service.setCurrentWindow(windowNum);var win=service.currentWindow;return b=packetData[++i],win.visible=(32&b)>>5,win.rowLock=(16&b)>>4,win.columnLock=(8&b)>>3,win.priority=7&b,b=packetData[++i],win.relativePositioning=(128&b)>>7,win.anchorVertical=127&b,b=packetData[++i],win.anchorHorizontal=b,b=packetData[++i],win.anchorPoint=(240&b)>>4,win.rowCount=15&b,b=packetData[++i],win.columnCount=63&b,b=packetData[++i],win.windowStyle=(56&b)>>3,win.penStyle=7&b,win.virtualRowCount=win.rowCount+1,i},Cea708Stream.prototype.setWindowAttributes=function(i,service){var packetData=this.current708Packet.data,b=packetData[i],winAttr=service.currentWindow.winAttr;return b=packetData[++i],winAttr.fillOpacity=(192&b)>>6,winAttr.fillRed=(48&b)>>4,winAttr.fillGreen=(12&b)>>2,winAttr.fillBlue=3&b,b=packetData[++i],winAttr.borderType=(192&b)>>6,winAttr.borderRed=(48&b)>>4,winAttr.borderGreen=(12&b)>>2,winAttr.borderBlue=3&b,b=packetData[++i],winAttr.borderType+=(128&b)>>5,winAttr.wordWrap=(64&b)>>6,winAttr.printDirection=(48&b)>>4,winAttr.scrollDirection=(12&b)>>2,winAttr.justify=3&b,b=packetData[++i],winAttr.effectSpeed=(240&b)>>4,winAttr.effectDirection=(12&b)>>2,winAttr.displayEffect=3&b,i},Cea708Stream.prototype.flushDisplayed=function(pts,service){for(var displayedText=[],winId=0;winId<8;winId++)service.windows[winId].visible&&!service.windows[winId].isEmpty()&&displayedText.push(service.windows[winId].getText());service.endPts=pts,service.text=displayedText.join("\n\n"),this.pushCaption(service),service.startPts=pts},Cea708Stream.prototype.pushCaption=function(service){""!==service.text&&(this.trigger("data",{startPts:service.startPts,endPts:service.endPts,text:service.text,stream:"cc708_"+service.serviceNum}),service.text="",service.startPts=service.endPts)},Cea708Stream.prototype.displayWindows=function(i,service){var b=this.current708Packet.data[++i],pts=this.getPts(i);this.flushDisplayed(pts,service);for(var winId=0;winId<8;winId++)b&1<<winId&&(service.windows[winId].visible=1);return i},Cea708Stream.prototype.hideWindows=function(i,service){var b=this.current708Packet.data[++i],pts=this.getPts(i);this.flushDisplayed(pts,service);for(var winId=0;winId<8;winId++)b&1<<winId&&(service.windows[winId].visible=0);return i},Cea708Stream.prototype.toggleWindows=function(i,service){var b=this.current708Packet.data[++i],pts=this.getPts(i);this.flushDisplayed(pts,service);for(var winId=0;winId<8;winId++)b&1<<winId&&(service.windows[winId].visible^=1);return i},Cea708Stream.prototype.clearWindows=function(i,service){var b=this.current708Packet.data[++i],pts=this.getPts(i);this.flushDisplayed(pts,service);for(var winId=0;winId<8;winId++)b&1<<winId&&service.windows[winId].clearText();return i},Cea708Stream.prototype.deleteWindows=function(i,service){var b=this.current708Packet.data[++i],pts=this.getPts(i);this.flushDisplayed(pts,service);for(var winId=0;winId<8;winId++)b&1<<winId&&service.windows[winId].reset();return i},Cea708Stream.prototype.setPenAttributes=function(i,service){var packetData=this.current708Packet.data,b=packetData[i],penAttr=service.currentWindow.penAttr;return b=packetData[++i],penAttr.textTag=(240&b)>>4,penAttr.offset=(12&b)>>2,penAttr.penSize=3&b,b=packetData[++i],penAttr.italics=(128&b)>>7,penAttr.underline=(64&b)>>6,penAttr.edgeType=(56&b)>>3,penAttr.fontStyle=7&b,i},Cea708Stream.prototype.setPenColor=function(i,service){var packetData=this.current708Packet.data,b=packetData[i],penColor=service.currentWindow.penColor;return b=packetData[++i],penColor.fgOpacity=(192&b)>>6,penColor.fgRed=(48&b)>>4,penColor.fgGreen=(12&b)>>2,penColor.fgBlue=3&b,b=packetData[++i],penColor.bgOpacity=(192&b)>>6,penColor.bgRed=(48&b)>>4,penColor.bgGreen=(12&b)>>2,penColor.bgBlue=3&b,b=packetData[++i],penColor.edgeRed=(48&b)>>4,penColor.edgeGreen=(12&b)>>2,penColor.edgeBlue=3&b,i},Cea708Stream.prototype.setPenLocation=function(i,service){var packetData=this.current708Packet.data,b=packetData[i],penLoc=service.currentWindow.penLoc;return service.currentWindow.pendingNewLine=!0,b=packetData[++i],penLoc.row=15&b,b=packetData[++i],penLoc.column=63&b,i},Cea708Stream.prototype.reset=function(i,service){var pts=this.getPts(i);return this.flushDisplayed(pts,service),this.initService(service.serviceNum,i)};var CHARACTER_TRANSLATION={42:225,92:233,94:237,95:243,96:250,123:231,124:247,125:209,126:241,127:9608,304:174,305:176,306:189,307:191,308:8482,309:162,310:163,311:9834,312:224,313:160,314:232,315:226,316:234,317:238,318:244,319:251,544:193,545:201,546:211,547:218,548:220,549:252,550:8216,551:161,552:42,553:39,554:8212,555:169,556:8480,557:8226,558:8220,559:8221,560:192,561:194,562:199,563:200,564:202,565:203,566:235,567:206,568:207,569:239,570:212,571:217,572:249,573:219,574:171,575:187,800:195,801:227,802:205,803:204,804:236,805:210,806:242,807:213,808:245,809:123,810:125,811:92,812:94,813:95,814:124,815:126,816:196,817:228,818:214,819:246,820:223,821:165,822:164,823:9474,824:197,825:229,826:216,827:248,828:9484,829:9488,830:9492,831:9496},getCharFromCode=function(code){return null===code?"":(code=CHARACTER_TRANSLATION[code]||code,String.fromCharCode(code))},ROWS=[4352,4384,4608,4640,5376,5408,5632,5664,5888,5920,4096,4864,4896,5120,5152],createDisplayBuffer=function(){for(var result=[],i=15;i--;)result.push("");return result},Cea608Stream=function Cea608Stream(field,dataChannel){Cea608Stream.prototype.init.call(this),this.field_=field||0,this.dataChannel_=dataChannel||0,this.name_="CC"+(1+(this.field_<<1|this.dataChannel_)),this.setConstants(),this.reset(),this.push=function(packet){var data,swap,char0,char1,text;if((data=32639&packet.ccData)!==this.lastControlCode_){if(4096==(61440&data)?this.lastControlCode_=data:data!==this.PADDING_&&(this.lastControlCode_=null),char0=data>>>8,char1=255&data,data!==this.PADDING_)if(data===this.RESUME_CAPTION_LOADING_)this.mode_="popOn";else if(data===this.END_OF_CAPTION_)this.mode_="popOn",this.clearFormatting(packet.pts),this.flushDisplayed(packet.pts),swap=this.displayed_,this.displayed_=this.nonDisplayed_,this.nonDisplayed_=swap,this.startPts_=packet.pts;else if(data===this.ROLL_UP_2_ROWS_)this.rollUpRows_=2,this.setRollUp(packet.pts);else if(data===this.ROLL_UP_3_ROWS_)this.rollUpRows_=3,this.setRollUp(packet.pts);else if(data===this.ROLL_UP_4_ROWS_)this.rollUpRows_=4,this.setRollUp(packet.pts);else if(data===this.CARRIAGE_RETURN_)this.clearFormatting(packet.pts),this.flushDisplayed(packet.pts),this.shiftRowsUp_(),this.startPts_=packet.pts;else if(data===this.BACKSPACE_)"popOn"===this.mode_?this.nonDisplayed_[this.row_]=this.nonDisplayed_[this.row_].slice(0,-1):this.displayed_[this.row_]=this.displayed_[this.row_].slice(0,-1);else if(data===this.ERASE_DISPLAYED_MEMORY_)this.flushDisplayed(packet.pts),this.displayed_=createDisplayBuffer();else if(data===this.ERASE_NON_DISPLAYED_MEMORY_)this.nonDisplayed_=createDisplayBuffer();else if(data===this.RESUME_DIRECT_CAPTIONING_)"paintOn"!==this.mode_&&(this.flushDisplayed(packet.pts),this.displayed_=createDisplayBuffer()),this.mode_="paintOn",this.startPts_=packet.pts;else if(this.isSpecialCharacter(char0,char1))text=getCharFromCode((char0=(3&char0)<<8)|char1),this[this.mode_](packet.pts,text),this.column_++;else if(this.isExtCharacter(char0,char1))"popOn"===this.mode_?this.nonDisplayed_[this.row_]=this.nonDisplayed_[this.row_].slice(0,-1):this.displayed_[this.row_]=this.displayed_[this.row_].slice(0,-1),text=getCharFromCode((char0=(3&char0)<<8)|char1),this[this.mode_](packet.pts,text),this.column_++;else if(this.isMidRowCode(char0,char1))this.clearFormatting(packet.pts),this[this.mode_](packet.pts," "),this.column_++,14==(14&char1)&&this.addFormatting(packet.pts,["i"]),1==(1&char1)&&this.addFormatting(packet.pts,["u"]);else if(this.isOffsetControlCode(char0,char1))this.column_+=3&char1;else if(this.isPAC(char0,char1)){var row=ROWS.indexOf(7968&data);"rollUp"===this.mode_&&(row-this.rollUpRows_+1<0&&(row=this.rollUpRows_-1),this.setRollUp(packet.pts,row)),row!==this.row_&&(this.clearFormatting(packet.pts),this.row_=row),1&char1&&-1===this.formatting_.indexOf("u")&&this.addFormatting(packet.pts,["u"]),16==(16&data)&&(this.column_=4*((14&data)>>1)),this.isColorPAC(char1)&&14==(14&char1)&&this.addFormatting(packet.pts,["i"])}else this.isNormalChar(char0)&&(0===char1&&(char1=null),text=getCharFromCode(char0),text+=getCharFromCode(char1),this[this.mode_](packet.pts,text),this.column_+=text.length)}else this.lastControlCode_=null}};Cea608Stream.prototype=new stream,Cea608Stream.prototype.flushDisplayed=function(pts){var content=this.displayed_.map((function(row,index){try{return row.trim()}catch(e){return this.trigger("log",{level:"warn",message:"Skipping a malformed 608 caption at index "+index+"."}),""}}),this).join("\n").replace(/^\n+|\n+$/g,"");content.length&&this.trigger("data",{startPts:this.startPts_,endPts:pts,text:content,stream:this.name_})},Cea608Stream.prototype.reset=function(){this.mode_="popOn",this.topRow_=0,this.startPts_=0,this.displayed_=createDisplayBuffer(),this.nonDisplayed_=createDisplayBuffer(),this.lastControlCode_=null,this.column_=0,this.row_=14,this.rollUpRows_=2,this.formatting_=[]},Cea608Stream.prototype.setConstants=function(){0===this.dataChannel_?(this.BASE_=16,this.EXT_=17,this.CONTROL_=(20|this.field_)<<8,this.OFFSET_=23):1===this.dataChannel_&&(this.BASE_=24,this.EXT_=25,this.CONTROL_=(28|this.field_)<<8,this.OFFSET_=31),this.PADDING_=0,this.RESUME_CAPTION_LOADING_=32|this.CONTROL_,this.END_OF_CAPTION_=47|this.CONTROL_,this.ROLL_UP_2_ROWS_=37|this.CONTROL_,this.ROLL_UP_3_ROWS_=38|this.CONTROL_,this.ROLL_UP_4_ROWS_=39|this.CONTROL_,this.CARRIAGE_RETURN_=45|this.CONTROL_,this.RESUME_DIRECT_CAPTIONING_=41|this.CONTROL_,this.BACKSPACE_=33|this.CONTROL_,this.ERASE_DISPLAYED_MEMORY_=44|this.CONTROL_,this.ERASE_NON_DISPLAYED_MEMORY_=46|this.CONTROL_},Cea608Stream.prototype.isSpecialCharacter=function(char0,char1){return char0===this.EXT_&&char1>=48&&char1<=63},Cea608Stream.prototype.isExtCharacter=function(char0,char1){return(char0===this.EXT_+1||char0===this.EXT_+2)&&char1>=32&&char1<=63},Cea608Stream.prototype.isMidRowCode=function(char0,char1){return char0===this.EXT_&&char1>=32&&char1<=47},Cea608Stream.prototype.isOffsetControlCode=function(char0,char1){return char0===this.OFFSET_&&char1>=33&&char1<=35},Cea608Stream.prototype.isPAC=function(char0,char1){return char0>=this.BASE_&&char0<this.BASE_+8&&char1>=64&&char1<=127},Cea608Stream.prototype.isColorPAC=function(char1){return char1>=64&&char1<=79||char1>=96&&char1<=127},Cea608Stream.prototype.isNormalChar=function(_char2){return _char2>=32&&_char2<=127},Cea608Stream.prototype.setRollUp=function(pts,newBaseRow){if("rollUp"!==this.mode_&&(this.row_=14,this.mode_="rollUp",this.flushDisplayed(pts),this.nonDisplayed_=createDisplayBuffer(),this.displayed_=createDisplayBuffer()),void 0!==newBaseRow&&newBaseRow!==this.row_)for(var i=0;i<this.rollUpRows_;i++)this.displayed_[newBaseRow-i]=this.displayed_[this.row_-i],this.displayed_[this.row_-i]="";void 0===newBaseRow&&(newBaseRow=this.row_),this.topRow_=newBaseRow-this.rollUpRows_+1},Cea608Stream.prototype.addFormatting=function(pts,format){this.formatting_=this.formatting_.concat(format);var text=format.reduce((function(text,format){return text+"<"+format+">"}),"");this[this.mode_](pts,text)},Cea608Stream.prototype.clearFormatting=function(pts){if(this.formatting_.length){var text=this.formatting_.reverse().reduce((function(text,format){return text+"</"+format+">"}),"");this.formatting_=[],this[this.mode_](pts,text)}},Cea608Stream.prototype.popOn=function(pts,text){var baseRow=this.nonDisplayed_[this.row_];baseRow+=text,this.nonDisplayed_[this.row_]=baseRow},Cea608Stream.prototype.rollUp=function(pts,text){var baseRow=this.displayed_[this.row_];baseRow+=text,this.displayed_[this.row_]=baseRow},Cea608Stream.prototype.shiftRowsUp_=function(){var i;for(i=0;i<this.topRow_;i++)this.displayed_[i]="";for(i=this.row_+1;i<15;i++)this.displayed_[i]="";for(i=this.topRow_;i<this.row_;i++)this.displayed_[i]=this.displayed_[i+1];this.displayed_[this.row_]=""},Cea608Stream.prototype.paintOn=function(pts,text){var baseRow=this.displayed_[this.row_];baseRow+=text,this.displayed_[this.row_]=baseRow};var captionStream={CaptionStream:CaptionStream$1,Cea608Stream:Cea608Stream,Cea708Stream:Cea708Stream},streamTypes={H264_STREAM_TYPE:27,ADTS_STREAM_TYPE:15,METADATA_STREAM_TYPE:21},handleRollover$1=function(value,reference){var direction=1;for(value>reference&&(direction=-1);Math.abs(reference-value)>4294967296;)value+=8589934592*direction;return value},TimestampRolloverStream$1=function TimestampRolloverStream(type){var lastDTS,referenceDTS;TimestampRolloverStream.prototype.init.call(this),this.type_=type||"shared",this.push=function(data){"shared"!==this.type_&&data.type!==this.type_||(void 0===referenceDTS&&(referenceDTS=data.dts),data.dts=handleRollover$1(data.dts,referenceDTS),data.pts=handleRollover$1(data.pts,referenceDTS),lastDTS=data.dts,this.trigger("data",data))},this.flush=function(){referenceDTS=lastDTS,this.trigger("done")},this.endTimeline=function(){this.flush(),this.trigger("endedtimeline")},this.discontinuity=function(){referenceDTS=void 0,lastDTS=void 0},this.reset=function(){this.discontinuity(),this.trigger("reset")}};TimestampRolloverStream$1.prototype=new stream;var _MetadataStream,timestampRolloverStream_TimestampRolloverStream=TimestampRolloverStream$1,timestampRolloverStream_handleRollover=handleRollover$1,percentEncode$1=function(bytes,start,end){var i,result="";for(i=start;i<end;i++)result+="%"+("00"+bytes[i].toString(16)).slice(-2);return result},parseUtf8=function(bytes,start,end){return decodeURIComponent(percentEncode$1(bytes,start,end))},parseSyncSafeInteger$1=function(data){return data[0]<<21|data[1]<<14|data[2]<<7|data[3]},tagParsers={TXXX:function(tag){var i;if(3===tag.data[0]){for(i=1;i<tag.data.length;i++)if(0===tag.data[i]){tag.description=parseUtf8(tag.data,1,i),tag.value=parseUtf8(tag.data,i+1,tag.data.length).replace(/\0*$/,"");break}tag.data=tag.value}},WXXX:function(tag){var i;if(3===tag.data[0])for(i=1;i<tag.data.length;i++)if(0===tag.data[i]){tag.description=parseUtf8(tag.data,1,i),tag.url=parseUtf8(tag.data,i+1,tag.data.length);break}},PRIV:function(tag){var i,bytes;for(i=0;i<tag.data.length;i++)if(0===tag.data[i]){tag.owner=(bytes=tag.data,unescape(percentEncode$1(bytes,0,i)));break}tag.privateData=tag.data.subarray(i+1),tag.data=tag.privateData}};_MetadataStream=function(options){var i,settings={descriptor:options&&options.descriptor},tagSize=0,buffer=[],bufferSize=0;if(_MetadataStream.prototype.init.call(this),this.dispatchType=streamTypes.METADATA_STREAM_TYPE.toString(16),settings.descriptor)for(i=0;i<settings.descriptor.length;i++)this.dispatchType+=("00"+settings.descriptor[i].toString(16)).slice(-2);this.push=function(chunk){var tag,frameStart,frameSize,frame,i;if("timed-metadata"===chunk.type)if(chunk.dataAlignmentIndicator&&(bufferSize=0,buffer.length=0),0===buffer.length&&(chunk.data.length<10||chunk.data[0]!=="I".charCodeAt(0)||chunk.data[1]!=="D".charCodeAt(0)||chunk.data[2]!=="3".charCodeAt(0)))this.trigger("log",{level:"warn",message:"Skipping unrecognized metadata packet"});else if(buffer.push(chunk),bufferSize+=chunk.data.byteLength,1===buffer.length&&(tagSize=parseSyncSafeInteger$1(chunk.data.subarray(6,10)),tagSize+=10),!(bufferSize<tagSize)){for(tag={data:new Uint8Array(tagSize),frames:[],pts:buffer[0].pts,dts:buffer[0].dts},i=0;i<tagSize;)tag.data.set(buffer[0].data.subarray(0,tagSize-i),i),i+=buffer[0].data.byteLength,bufferSize-=buffer[0].data.byteLength,buffer.shift();frameStart=10,64&tag.data[5]&&(frameStart+=4,frameStart+=parseSyncSafeInteger$1(tag.data.subarray(10,14)),tagSize-=parseSyncSafeInteger$1(tag.data.subarray(16,20)));do{if((frameSize=parseSyncSafeInteger$1(tag.data.subarray(frameStart+4,frameStart+8)))<1)return void this.trigger("log",{level:"warn",message:"Malformed ID3 frame encountered. Skipping metadata parsing."});if((frame={id:String.fromCharCode(tag.data[frameStart],tag.data[frameStart+1],tag.data[frameStart+2],tag.data[frameStart+3]),data:tag.data.subarray(frameStart+10,frameStart+frameSize+10)}).key=frame.id,tagParsers[frame.id]&&(tagParsers[frame.id](frame),"com.apple.streaming.transportStreamTimestamp"===frame.owner)){var d=frame.data,size=(1&d[3])<<30|d[4]<<22|d[5]<<14|d[6]<<6|d[7]>>>2;size*=4,size+=3&d[7],frame.timeStamp=size,void 0===tag.pts&&void 0===tag.dts&&(tag.pts=frame.timeStamp,tag.dts=frame.timeStamp),this.trigger("timestamp",frame)}tag.frames.push(frame),frameStart+=10,frameStart+=frameSize}while(frameStart<tagSize);this.trigger("data",tag)}}},_MetadataStream.prototype=new stream;var _TransportPacketStream,_TransportParseStream,_ElementaryStream,metadataStream=_MetadataStream,TimestampRolloverStream=timestampRolloverStream_TimestampRolloverStream;(_TransportPacketStream=function(){var buffer=new Uint8Array(188),bytesInBuffer=0;_TransportPacketStream.prototype.init.call(this),this.push=function(bytes){var everything,startIndex=0,endIndex=188;for(bytesInBuffer?((everything=new Uint8Array(bytes.byteLength+bytesInBuffer)).set(buffer.subarray(0,bytesInBuffer)),everything.set(bytes,bytesInBuffer),bytesInBuffer=0):everything=bytes;endIndex<everything.byteLength;)71!==everything[startIndex]||71!==everything[endIndex]?(startIndex++,endIndex++):(this.trigger("data",everything.subarray(startIndex,endIndex)),startIndex+=188,endIndex+=188);startIndex<everything.byteLength&&(buffer.set(everything.subarray(startIndex),0),bytesInBuffer=everything.byteLength-startIndex)},this.flush=function(){188===bytesInBuffer&&71===buffer[0]&&(this.trigger("data",buffer),bytesInBuffer=0),this.trigger("done")},this.endTimeline=function(){this.flush(),this.trigger("endedtimeline")},this.reset=function(){bytesInBuffer=0,this.trigger("reset")}}).prototype=new stream,_TransportParseStream=function(){var parsePsi,parsePat,parsePmt,self;_TransportParseStream.prototype.init.call(this),self=this,this.packetsWaitingForPmt=[],this.programMapTable=void 0,parsePsi=function(payload,psi){var offset=0;psi.payloadUnitStartIndicator&&(offset+=payload[offset]+1),"pat"===psi.type?parsePat(payload.subarray(offset),psi):parsePmt(payload.subarray(offset),psi)},parsePat=function(payload,pat){pat.section_number=payload[7],pat.last_section_number=payload[8],self.pmtPid=(31&payload[10])<<8|payload[11],pat.pmtPid=self.pmtPid},parsePmt=function(payload,pmt){var tableEnd,offset;if(1&payload[5]){for(self.programMapTable={video:null,audio:null,"timed-metadata":{}},tableEnd=3+((15&payload[1])<<8|payload[2])-4,offset=12+((15&payload[10])<<8|payload[11]);offset<tableEnd;){var streamType=payload[offset],pid=(31&payload[offset+1])<<8|payload[offset+2];streamType===streamTypes.H264_STREAM_TYPE&&null===self.programMapTable.video?self.programMapTable.video=pid:streamType===streamTypes.ADTS_STREAM_TYPE&&null===self.programMapTable.audio?self.programMapTable.audio=pid:streamType===streamTypes.METADATA_STREAM_TYPE&&(self.programMapTable["timed-metadata"][pid]=streamType),offset+=5+((15&payload[offset+3])<<8|payload[offset+4])}pmt.programMapTable=self.programMapTable}},this.push=function(packet){var result={},offset=4;if(result.payloadUnitStartIndicator=!!(64&packet[1]),result.pid=31&packet[1],result.pid<<=8,result.pid|=packet[2],(48&packet[3])>>>4>1&&(offset+=packet[offset]+1),0===result.pid)result.type="pat",parsePsi(packet.subarray(offset),result),this.trigger("data",result);else if(result.pid===this.pmtPid)for(result.type="pmt",parsePsi(packet.subarray(offset),result),this.trigger("data",result);this.packetsWaitingForPmt.length;)this.processPes_.apply(this,this.packetsWaitingForPmt.shift());else void 0===this.programMapTable?this.packetsWaitingForPmt.push([packet,offset,result]):this.processPes_(packet,offset,result)},this.processPes_=function(packet,offset,result){result.pid===this.programMapTable.video?result.streamType=streamTypes.H264_STREAM_TYPE:result.pid===this.programMapTable.audio?result.streamType=streamTypes.ADTS_STREAM_TYPE:result.streamType=this.programMapTable["timed-metadata"][result.pid],result.type="pes",result.data=packet.subarray(offset),this.trigger("data",result)}},_TransportParseStream.prototype=new stream,_TransportParseStream.STREAM_TYPES={h264:27,adts:15},_ElementaryStream=function(){var programMapTable,self=this,segmentHadPmt=!1,video={data:[],size:0},audio={data:[],size:0},timedMetadata={data:[],size:0},flushStream=function(stream,type,forceFlush){var packetFlushable,fragment,packetData=new Uint8Array(stream.size),event={type:type},i=0,offset=0;if(stream.data.length&&!(stream.size<9)){for(event.trackId=stream.data[0].pid,i=0;i<stream.data.length;i++)fragment=stream.data[i],packetData.set(fragment.data,offset),offset+=fragment.data.byteLength;var payload,pes,ptsDtsFlags,startPrefix;pes=event,startPrefix=(payload=packetData)[0]<<16|payload[1]<<8|payload[2],pes.data=new Uint8Array,1===startPrefix&&(pes.packetLength=6+(payload[4]<<8|payload[5]),pes.dataAlignmentIndicator=0!=(4&payload[6]),192&(ptsDtsFlags=payload[7])&&(pes.pts=(14&payload[9])<<27|(255&payload[10])<<20|(254&payload[11])<<12|(255&payload[12])<<5|(254&payload[13])>>>3,pes.pts*=4,pes.pts+=(6&payload[13])>>>1,pes.dts=pes.pts,64&ptsDtsFlags&&(pes.dts=(14&payload[14])<<27|(255&payload[15])<<20|(254&payload[16])<<12|(255&payload[17])<<5|(254&payload[18])>>>3,pes.dts*=4,pes.dts+=(6&payload[18])>>>1)),pes.data=payload.subarray(9+payload[8])),packetFlushable="video"===type||event.packetLength<=stream.size,(forceFlush||packetFlushable)&&(stream.size=0,stream.data.length=0),packetFlushable&&self.trigger("data",event)}};_ElementaryStream.prototype.init.call(this),this.push=function(data){({pat:function(){},pes:function(){var stream,streamType;switch(data.streamType){case streamTypes.H264_STREAM_TYPE:stream=video,streamType="video";break;case streamTypes.ADTS_STREAM_TYPE:stream=audio,streamType="audio";break;case streamTypes.METADATA_STREAM_TYPE:stream=timedMetadata,streamType="timed-metadata";break;default:return}data.payloadUnitStartIndicator&&flushStream(stream,streamType,!0),stream.data.push(data),stream.size+=data.data.byteLength},pmt:function(){var event={type:"metadata",tracks:[]};null!==(programMapTable=data.programMapTable).video&&event.tracks.push({timelineStartInfo:{baseMediaDecodeTime:0},id:+programMapTable.video,codec:"avc",type:"video"}),null!==programMapTable.audio&&event.tracks.push({timelineStartInfo:{baseMediaDecodeTime:0},id:+programMapTable.audio,codec:"adts",type:"audio"}),segmentHadPmt=!0,self.trigger("data",event)}})[data.type]()},this.reset=function(){video.size=0,video.data.length=0,audio.size=0,audio.data.length=0,this.trigger("reset")},this.flushStreams_=function(){flushStream(video,"video"),flushStream(audio,"audio"),flushStream(timedMetadata,"timed-metadata")},this.flush=function(){if(!segmentHadPmt&&programMapTable){var pmt={type:"metadata",tracks:[]};null!==programMapTable.video&&pmt.tracks.push({timelineStartInfo:{baseMediaDecodeTime:0},id:+programMapTable.video,codec:"avc",type:"video"}),null!==programMapTable.audio&&pmt.tracks.push({timelineStartInfo:{baseMediaDecodeTime:0},id:+programMapTable.audio,codec:"adts",type:"audio"}),self.trigger("data",pmt)}segmentHadPmt=!1,this.flushStreams_(),this.trigger("done")}},_ElementaryStream.prototype=new stream;var m2ts={PAT_PID:0,MP2T_PACKET_LENGTH:188,TransportPacketStream:_TransportPacketStream,TransportParseStream:_TransportParseStream,ElementaryStream:_ElementaryStream,TimestampRolloverStream:TimestampRolloverStream,CaptionStream:captionStream.CaptionStream,Cea608Stream:captionStream.Cea608Stream,Cea708Stream:captionStream.Cea708Stream,MetadataStream:metadataStream};for(var type in streamTypes)streamTypes.hasOwnProperty(type)&&(m2ts[type]=streamTypes[type]);var _AdtsStream,m2ts_1=m2ts,ONE_SECOND_IN_TS$2=clock_ONE_SECOND_IN_TS$0,ADTS_SAMPLING_FREQUENCIES$1=[96e3,88200,64e3,48e3,44100,32e3,24e3,22050,16e3,12e3,11025,8e3,7350];_AdtsStream=function(handlePartialSegments){var buffer,frameNum=0;_AdtsStream.prototype.init.call(this),this.skipWarn_=function(start,end){this.trigger("log",{level:"warn",message:"adts skiping bytes "+start+" to "+end+" in frame "+frameNum+" outside syncword"})},this.push=function(packet){var frameLength,protectionSkipBytes,oldBuffer,sampleCount,adtsFrameDuration,i=0;if(handlePartialSegments||(frameNum=0),"audio"===packet.type){var skip;for(buffer&&buffer.length?(oldBuffer=buffer,(buffer=new Uint8Array(oldBuffer.byteLength+packet.data.byteLength)).set(oldBuffer),buffer.set(packet.data,oldBuffer.byteLength)):buffer=packet.data;i+7<buffer.length;)if(255===buffer[i]&&240==(246&buffer[i+1])){if("number"==typeof skip&&(this.skipWarn_(skip,i),skip=null),protectionSkipBytes=2*(1&~buffer[i+1]),frameLength=(3&buffer[i+3])<<11|buffer[i+4]<<3|(224&buffer[i+5])>>5,adtsFrameDuration=(sampleCount=1024*(1+(3&buffer[i+6])))*ONE_SECOND_IN_TS$2/ADTS_SAMPLING_FREQUENCIES$1[(60&buffer[i+2])>>>2],buffer.byteLength-i<frameLength)break;this.trigger("data",{pts:packet.pts+frameNum*adtsFrameDuration,dts:packet.dts+frameNum*adtsFrameDuration,sampleCount:sampleCount,audioobjecttype:1+(buffer[i+2]>>>6&3),channelcount:(1&buffer[i+2])<<2|(192&buffer[i+3])>>>6,samplerate:ADTS_SAMPLING_FREQUENCIES$1[(60&buffer[i+2])>>>2],samplingfrequencyindex:(60&buffer[i+2])>>>2,samplesize:16,data:buffer.subarray(i+7+protectionSkipBytes,i+frameLength)}),frameNum++,i+=frameLength}else"number"!=typeof skip&&(skip=i),i++;"number"==typeof skip&&(this.skipWarn_(skip,i),skip=null),buffer=buffer.subarray(i)}},this.flush=function(){frameNum=0,this.trigger("done")},this.reset=function(){buffer=void 0,this.trigger("reset")},this.endTimeline=function(){buffer=void 0,this.trigger("endedtimeline")}},_AdtsStream.prototype=new stream;var ExpGolomb,adts=_AdtsStream;ExpGolomb=function(workingData){var workingBytesAvailable=workingData.byteLength,workingWord=0,workingBitsAvailable=0;this.length=function(){return 8*workingBytesAvailable},this.bitsAvailable=function(){return 8*workingBytesAvailable+workingBitsAvailable},this.loadWord=function(){var position=workingData.byteLength-workingBytesAvailable,workingBytes=new Uint8Array(4),availableBytes=Math.min(4,workingBytesAvailable);if(0===availableBytes)throw new Error("no bytes available");workingBytes.set(workingData.subarray(position,position+availableBytes)),workingWord=new DataView(workingBytes.buffer).getUint32(0),workingBitsAvailable=8*availableBytes,workingBytesAvailable-=availableBytes},this.skipBits=function(count){var skipBytes;workingBitsAvailable>count?(workingWord<<=count,workingBitsAvailable-=count):(count-=workingBitsAvailable,count-=8*(skipBytes=Math.floor(count/8)),workingBytesAvailable-=skipBytes,this.loadWord(),workingWord<<=count,workingBitsAvailable-=count)},this.readBits=function(size){var bits=Math.min(workingBitsAvailable,size),valu=workingWord>>>32-bits;return(workingBitsAvailable-=bits)>0?workingWord<<=bits:workingBytesAvailable>0&&this.loadWord(),(bits=size-bits)>0?valu<<bits|this.readBits(bits):valu},this.skipLeadingZeros=function(){var leadingZeroCount;for(leadingZeroCount=0;leadingZeroCount<workingBitsAvailable;++leadingZeroCount)if(0!=(workingWord&2147483648>>>leadingZeroCount))return workingWord<<=leadingZeroCount,workingBitsAvailable-=leadingZeroCount,leadingZeroCount;return this.loadWord(),leadingZeroCount+this.skipLeadingZeros()},this.skipUnsignedExpGolomb=function(){this.skipBits(1+this.skipLeadingZeros())},this.skipExpGolomb=function(){this.skipBits(1+this.skipLeadingZeros())},this.readUnsignedExpGolomb=function(){var clz=this.skipLeadingZeros();return this.readBits(clz+1)-1},this.readExpGolomb=function(){var valu=this.readUnsignedExpGolomb();return 1&valu?1+valu>>>1:-1*(valu>>>1)},this.readBoolean=function(){return 1===this.readBits(1)},this.readUnsignedByte=function(){return this.readBits(8)},this.loadWord()};var _H264Stream,_NalByteStream,PROFILES_WITH_OPTIONAL_SPS_DATA,expGolomb=ExpGolomb;_NalByteStream=function(){var i,buffer,syncPoint=0;_NalByteStream.prototype.init.call(this),this.push=function(data){var swapBuffer;buffer?((swapBuffer=new Uint8Array(buffer.byteLength+data.data.byteLength)).set(buffer),swapBuffer.set(data.data,buffer.byteLength),buffer=swapBuffer):buffer=data.data;for(var len=buffer.byteLength;syncPoint<len-3;syncPoint++)if(1===buffer[syncPoint+2]){i=syncPoint+5;break}for(;i<len;)switch(buffer[i]){case 0:if(0!==buffer[i-1]){i+=2;break}if(0!==buffer[i-2]){i++;break}syncPoint+3!==i-2&&this.trigger("data",buffer.subarray(syncPoint+3,i-2));do{i++}while(1!==buffer[i]&&i<len);syncPoint=i-2,i+=3;break;case 1:if(0!==buffer[i-1]||0!==buffer[i-2]){i+=3;break}this.trigger("data",buffer.subarray(syncPoint+3,i-2)),syncPoint=i-2,i+=3;break;default:i+=3}buffer=buffer.subarray(syncPoint),i-=syncPoint,syncPoint=0},this.reset=function(){buffer=null,syncPoint=0,this.trigger("reset")},this.flush=function(){buffer&&buffer.byteLength>3&&this.trigger("data",buffer.subarray(syncPoint+3)),buffer=null,syncPoint=0,this.trigger("done")},this.endTimeline=function(){this.flush(),this.trigger("endedtimeline")}},_NalByteStream.prototype=new stream,PROFILES_WITH_OPTIONAL_SPS_DATA={100:!0,110:!0,122:!0,244:!0,44:!0,83:!0,86:!0,118:!0,128:!0,138:!0,139:!0,134:!0},_H264Stream=function(){var self,trackId,currentPts,currentDts,discardEmulationPreventionBytes,readSequenceParameterSet,skipScalingList,nalByteStream=new _NalByteStream;_H264Stream.prototype.init.call(this),self=this,this.push=function(packet){"video"===packet.type&&(trackId=packet.trackId,currentPts=packet.pts,currentDts=packet.dts,nalByteStream.push(packet))},nalByteStream.on("data",(function(data){var event={trackId:trackId,pts:currentPts,dts:currentDts,data:data,nalUnitTypeCode:31&data[0]};switch(event.nalUnitTypeCode){case 5:event.nalUnitType="slice_layer_without_partitioning_rbsp_idr";break;case 6:event.nalUnitType="sei_rbsp",event.escapedRBSP=discardEmulationPreventionBytes(data.subarray(1));break;case 7:event.nalUnitType="seq_parameter_set_rbsp",event.escapedRBSP=discardEmulationPreventionBytes(data.subarray(1)),event.config=readSequenceParameterSet(event.escapedRBSP);break;case 8:event.nalUnitType="pic_parameter_set_rbsp";break;case 9:event.nalUnitType="access_unit_delimiter_rbsp"}self.trigger("data",event)})),nalByteStream.on("done",(function(){self.trigger("done")})),nalByteStream.on("partialdone",(function(){self.trigger("partialdone")})),nalByteStream.on("reset",(function(){self.trigger("reset")})),nalByteStream.on("endedtimeline",(function(){self.trigger("endedtimeline")})),this.flush=function(){nalByteStream.flush()},this.partialFlush=function(){nalByteStream.partialFlush()},this.reset=function(){nalByteStream.reset()},this.endTimeline=function(){nalByteStream.endTimeline()},skipScalingList=function(count,expGolombDecoder){var j,lastScale=8,nextScale=8;for(j=0;j<count;j++)0!==nextScale&&(nextScale=(lastScale+expGolombDecoder.readExpGolomb()+256)%256),lastScale=0===nextScale?lastScale:nextScale},discardEmulationPreventionBytes=function(data){for(var newLength,newData,length=data.byteLength,emulationPreventionBytesPositions=[],i=1;i<length-2;)0===data[i]&&0===data[i+1]&&3===data[i+2]?(emulationPreventionBytesPositions.push(i+2),i+=2):i++;if(0===emulationPreventionBytesPositions.length)return data;newLength=length-emulationPreventionBytesPositions.length,newData=new Uint8Array(newLength);var sourceIndex=0;for(i=0;i<newLength;sourceIndex++,i++)sourceIndex===emulationPreventionBytesPositions[0]&&(sourceIndex++,emulationPreventionBytesPositions.shift()),newData[i]=data[sourceIndex];return newData},readSequenceParameterSet=function(data){var expGolombDecoder,profileIdc,levelIdc,profileCompatibility,chromaFormatIdc,picOrderCntType,numRefFramesInPicOrderCntCycle,picWidthInMbsMinus1,picHeightInMapUnitsMinus1,frameMbsOnlyFlag,scalingListCount,i,frameCropLeftOffset=0,frameCropRightOffset=0,frameCropTopOffset=0,frameCropBottomOffset=0,sarRatio=[1,1];if(profileIdc=(expGolombDecoder=new expGolomb(data)).readUnsignedByte(),profileCompatibility=expGolombDecoder.readUnsignedByte(),levelIdc=expGolombDecoder.readUnsignedByte(),expGolombDecoder.skipUnsignedExpGolomb(),PROFILES_WITH_OPTIONAL_SPS_DATA[profileIdc]&&(3===(chromaFormatIdc=expGolombDecoder.readUnsignedExpGolomb())&&expGolombDecoder.skipBits(1),expGolombDecoder.skipUnsignedExpGolomb(),expGolombDecoder.skipUnsignedExpGolomb(),expGolombDecoder.skipBits(1),expGolombDecoder.readBoolean()))for(scalingListCount=3!==chromaFormatIdc?8:12,i=0;i<scalingListCount;i++)expGolombDecoder.readBoolean()&&skipScalingList(i<6?16:64,expGolombDecoder);if(expGolombDecoder.skipUnsignedExpGolomb(),0===(picOrderCntType=expGolombDecoder.readUnsignedExpGolomb()))expGolombDecoder.readUnsignedExpGolomb();else if(1===picOrderCntType)for(expGolombDecoder.skipBits(1),expGolombDecoder.skipExpGolomb(),expGolombDecoder.skipExpGolomb(),numRefFramesInPicOrderCntCycle=expGolombDecoder.readUnsignedExpGolomb(),i=0;i<numRefFramesInPicOrderCntCycle;i++)expGolombDecoder.skipExpGolomb();if(expGolombDecoder.skipUnsignedExpGolomb(),expGolombDecoder.skipBits(1),picWidthInMbsMinus1=expGolombDecoder.readUnsignedExpGolomb(),picHeightInMapUnitsMinus1=expGolombDecoder.readUnsignedExpGolomb(),0===(frameMbsOnlyFlag=expGolombDecoder.readBits(1))&&expGolombDecoder.skipBits(1),expGolombDecoder.skipBits(1),expGolombDecoder.readBoolean()&&(frameCropLeftOffset=expGolombDecoder.readUnsignedExpGolomb(),frameCropRightOffset=expGolombDecoder.readUnsignedExpGolomb(),frameCropTopOffset=expGolombDecoder.readUnsignedExpGolomb(),frameCropBottomOffset=expGolombDecoder.readUnsignedExpGolomb()),expGolombDecoder.readBoolean()&&expGolombDecoder.readBoolean()){switch(expGolombDecoder.readUnsignedByte()){case 1:sarRatio=[1,1];break;case 2:sarRatio=[12,11];break;case 3:sarRatio=[10,11];break;case 4:sarRatio=[16,11];break;case 5:sarRatio=[40,33];break;case 6:sarRatio=[24,11];break;case 7:sarRatio=[20,11];break;case 8:sarRatio=[32,11];break;case 9:sarRatio=[80,33];break;case 10:sarRatio=[18,11];break;case 11:sarRatio=[15,11];break;case 12:sarRatio=[64,33];break;case 13:sarRatio=[160,99];break;case 14:sarRatio=[4,3];break;case 15:sarRatio=[3,2];break;case 16:sarRatio=[2,1];break;case 255:sarRatio=[expGolombDecoder.readUnsignedByte()<<8|expGolombDecoder.readUnsignedByte(),expGolombDecoder.readUnsignedByte()<<8|expGolombDecoder.readUnsignedByte()]}sarRatio&&(sarRatio[0],sarRatio[1])}return{profileIdc:profileIdc,levelIdc:levelIdc,profileCompatibility:profileCompatibility,width:16*(picWidthInMbsMinus1+1)-2*frameCropLeftOffset-2*frameCropRightOffset,height:(2-frameMbsOnlyFlag)*(picHeightInMapUnitsMinus1+1)*16-2*frameCropTopOffset-2*frameCropBottomOffset,sarRatio:sarRatio}}},_H264Stream.prototype=new stream;var _AacStream,h264={H264Stream:_H264Stream,NalByteStream:_NalByteStream},ADTS_SAMPLING_FREQUENCIES=[96e3,88200,64e3,48e3,44100,32e3,24e3,22050,16e3,12e3,11025,8e3,7350],parseId3TagSize=function(header,byteIndex){var returnSize=header[byteIndex+6]<<21|header[byteIndex+7]<<14|header[byteIndex+8]<<7|header[byteIndex+9];return returnSize=returnSize>=0?returnSize:0,(16&header[byteIndex+5])>>4?returnSize+20:returnSize+10},getId3Offset=function getId3Offset(data,offset){return data.length-offset<10||data[offset]!=="I".charCodeAt(0)||data[offset+1]!=="D".charCodeAt(0)||data[offset+2]!=="3".charCodeAt(0)?offset:getId3Offset(data,offset+=parseId3TagSize(data,offset))},parseSyncSafeInteger=function(data){return data[0]<<21|data[1]<<14|data[2]<<7|data[3]},utils={isLikelyAacData:function(data){var offset=getId3Offset(data,0);return data.length>=offset+2&&255==(255&data[offset])&&240==(240&data[offset+1])&&16==(22&data[offset+1])},parseId3TagSize:parseId3TagSize,parseAdtsSize:function(header,byteIndex){var lowThree=(224&header[byteIndex+5])>>5,middle=header[byteIndex+4]<<3;return 6144&header[byteIndex+3]|middle|lowThree},parseType:function(header,byteIndex){return header[byteIndex]==="I".charCodeAt(0)&&header[byteIndex+1]==="D".charCodeAt(0)&&header[byteIndex+2]==="3".charCodeAt(0)?"timed-metadata":!0&header[byteIndex]&&240==(240&header[byteIndex+1])?"audio":null},parseSampleRate:function(packet){for(var i=0;i+5<packet.length;){if(255===packet[i]&&240==(246&packet[i+1]))return ADTS_SAMPLING_FREQUENCIES[(60&packet[i+2])>>>2];i++}return null},parseAacTimestamp:function(packet){var frameStart,frameSize,frame;frameStart=10,64&packet[5]&&(frameStart+=4,frameStart+=parseSyncSafeInteger(packet.subarray(10,14)));do{if((frameSize=parseSyncSafeInteger(packet.subarray(frameStart+4,frameStart+8)))<1)return null;if("PRIV"===String.fromCharCode(packet[frameStart],packet[frameStart+1],packet[frameStart+2],packet[frameStart+3])){frame=packet.subarray(frameStart+10,frameStart+frameSize+10);for(var i=0;i<frame.byteLength;i++)if(0===frame[i]){var owner=unescape(function(bytes,start,end){var i,result="";for(i=start;i<end;i++)result+="%"+("00"+bytes[i].toString(16)).slice(-2);return result}(frame,0,i));if("com.apple.streaming.transportStreamTimestamp"===owner){var d=frame.subarray(i+1),size=(1&d[3])<<30|d[4]<<22|d[5]<<14|d[6]<<6|d[7]>>>2;return size*=4,size+=3&d[7]}break}}frameStart+=10,frameStart+=frameSize}while(frameStart<packet.byteLength);return null}};(_AacStream=function(){var everything=new Uint8Array,timeStamp=0;_AacStream.prototype.init.call(this),this.setTimestamp=function(timestamp){timeStamp=timestamp},this.push=function(bytes){var bytesLeft,chunk,packet,tempLength,frameSize=0,byteIndex=0;for(everything.length?(tempLength=everything.length,(everything=new Uint8Array(bytes.byteLength+tempLength)).set(everything.subarray(0,tempLength)),everything.set(bytes,tempLength)):everything=bytes;everything.length-byteIndex>=3;)if(everything[byteIndex]!=="I".charCodeAt(0)||everything[byteIndex+1]!=="D".charCodeAt(0)||everything[byteIndex+2]!=="3".charCodeAt(0))if(255!=(255&everything[byteIndex])||240!=(240&everything[byteIndex+1]))byteIndex++;else{if(everything.length-byteIndex<7)break;if(byteIndex+(frameSize=utils.parseAdtsSize(everything,byteIndex))>everything.length)break;packet={type:"audio",data:everything.subarray(byteIndex,byteIndex+frameSize),pts:timeStamp,dts:timeStamp},this.trigger("data",packet),byteIndex+=frameSize}else{if(everything.length-byteIndex<10)break;if(byteIndex+(frameSize=utils.parseId3TagSize(everything,byteIndex))>everything.length)break;chunk={type:"timed-metadata",data:everything.subarray(byteIndex,byteIndex+frameSize)},this.trigger("data",chunk),byteIndex+=frameSize}bytesLeft=everything.length-byteIndex,everything=bytesLeft>0?everything.subarray(byteIndex):new Uint8Array},this.reset=function(){everything=new Uint8Array,this.trigger("reset")},this.endTimeline=function(){everything=new Uint8Array,this.trigger("endedtimeline")}}).prototype=new stream;var _VideoSegmentStream,_AudioSegmentStream,_Transmuxer,_CoalesceStream,aac=_AacStream,audioProperties=["audioobjecttype","channelcount","samplerate","samplingfrequencyindex","samplesize"],videoProperties=["width","height","profileIdc","levelIdc","profileCompatibility","sarRatio"],H264Stream=h264.H264Stream,isLikelyAacData=utils.isLikelyAacData,ONE_SECOND_IN_TS$1=clock_ONE_SECOND_IN_TS$0,retriggerForStream=function(key,event){event.stream=key,this.trigger("log",event)},addPipelineLogRetriggers=function(transmuxer,pipeline){for(var keys=Object.keys(pipeline),i=0;i<keys.length;i++){var key=keys[i];"headOfPipeline"!==key&&pipeline[key].on&&pipeline[key].on("log",retriggerForStream.bind(transmuxer,key))}},arrayEquals=function(a,b){var i;if(a.length!==b.length)return!1;for(i=0;i<a.length;i++)if(a[i]!==b[i])return!1;return!0},generateSegmentTimingInfo=function(baseMediaDecodeTime,startDts,startPts,endDts,endPts,prependedContentDuration){return{start:{dts:baseMediaDecodeTime,pts:baseMediaDecodeTime+(startPts-startDts)},end:{dts:baseMediaDecodeTime+(endDts-startDts),pts:baseMediaDecodeTime+(endPts-startPts)},prependedContentDuration:prependedContentDuration,baseMediaDecodeTime:baseMediaDecodeTime}};_AudioSegmentStream=function(track,options){var sequenceNumber,adtsFrames=[],earliestAllowedDts=0,audioAppendStartTs=0,videoBaseMediaDecodeTime=1/0;sequenceNumber=(options=options||{}).firstSequenceNumber||0,_AudioSegmentStream.prototype.init.call(this),this.push=function(data){trackDecodeInfo_collectDtsInfo(track,data),track&&audioProperties.forEach((function(prop){track[prop]=data[prop]})),adtsFrames.push(data)},this.setEarliestDts=function(earliestDts){earliestAllowedDts=earliestDts},this.setVideoBaseMediaDecodeTime=function(baseMediaDecodeTime){videoBaseMediaDecodeTime=baseMediaDecodeTime},this.setAudioAppendStart=function(timestamp){audioAppendStartTs=timestamp},this.flush=function(){var frames,moof,mdat,boxes,frameDuration,segmentDuration,videoClockCyclesOfSilencePrefixed;0!==adtsFrames.length?(frames=audioFrameUtils_trimAdtsFramesByEarliestDts(adtsFrames,track,earliestAllowedDts),track.baseMediaDecodeTime=trackDecodeInfo_calculateTrackBaseMediaDecodeTime(track,options.keepOriginalTimestamps),videoClockCyclesOfSilencePrefixed=audioFrameUtils_prefixWithSilence(track,frames,audioAppendStartTs,videoBaseMediaDecodeTime),track.samples=audioFrameUtils_generateSampleTable(frames),mdat=mp4Generator_mdat(audioFrameUtils_concatenateFrameData(frames)),adtsFrames=[],moof=mp4Generator_moof(sequenceNumber,[track]),boxes=new Uint8Array(moof.byteLength+mdat.byteLength),sequenceNumber++,boxes.set(moof),boxes.set(mdat,moof.byteLength),trackDecodeInfo_clearDtsInfo(track),frameDuration=Math.ceil(1024*ONE_SECOND_IN_TS$1/track.samplerate),frames.length&&(segmentDuration=frames.length*frameDuration,this.trigger("segmentTimingInfo",generateSegmentTimingInfo(clock_audioTsToVideoTs$0(track.baseMediaDecodeTime,track.samplerate),frames[0].dts,frames[0].pts,frames[0].dts+segmentDuration,frames[0].pts+segmentDuration,videoClockCyclesOfSilencePrefixed||0)),this.trigger("timingInfo",{start:frames[0].pts,end:frames[0].pts+segmentDuration})),this.trigger("data",{track:track,boxes:boxes}),this.trigger("done","AudioSegmentStream")):this.trigger("done","AudioSegmentStream")},this.reset=function(){trackDecodeInfo_clearDtsInfo(track),adtsFrames=[],this.trigger("reset")}},_AudioSegmentStream.prototype=new stream,_VideoSegmentStream=function(track,options){var sequenceNumber,config,pps,nalUnits=[],gopsToAlignWith=[];sequenceNumber=(options=options||{}).firstSequenceNumber||0,_VideoSegmentStream.prototype.init.call(this),delete track.minPTS,this.gopCache_=[],this.push=function(nalUnit){trackDecodeInfo_collectDtsInfo(track,nalUnit),"seq_parameter_set_rbsp"!==nalUnit.nalUnitType||config||(config=nalUnit.config,track.sps=[nalUnit.data],videoProperties.forEach((function(prop){track[prop]=config[prop]}),this)),"pic_parameter_set_rbsp"!==nalUnit.nalUnitType||pps||(pps=nalUnit.data,track.pps=[nalUnit.data]),nalUnits.push(nalUnit)},this.flush=function(){for(var frames,gopForFusion,gops,moof,mdat,boxes,firstGop,lastGop,prependedContentDuration=0;nalUnits.length&&"access_unit_delimiter_rbsp"!==nalUnits[0].nalUnitType;)nalUnits.shift();if(0===nalUnits.length)return this.resetStream_(),void this.trigger("done","VideoSegmentStream");if(frames=frameUtils_groupNalsIntoFrames(nalUnits),(gops=frameUtils_groupFramesIntoGops(frames))[0][0].keyFrame||((gopForFusion=this.getGopForFusion_(nalUnits[0],track))?(prependedContentDuration=gopForFusion.duration,gops.unshift(gopForFusion),gops.byteLength+=gopForFusion.byteLength,gops.nalCount+=gopForFusion.nalCount,gops.pts=gopForFusion.pts,gops.dts=gopForFusion.dts,gops.duration+=gopForFusion.duration):gops=frameUtils_extendFirstKeyFrame(gops)),gopsToAlignWith.length){var alignedGops;if(!(alignedGops=options.alignGopsAtEnd?this.alignGopsAtEnd_(gops):this.alignGopsAtStart_(gops)))return this.gopCache_.unshift({gop:gops.pop(),pps:track.pps,sps:track.sps}),this.gopCache_.length=Math.min(6,this.gopCache_.length),nalUnits=[],this.resetStream_(),void this.trigger("done","VideoSegmentStream");trackDecodeInfo_clearDtsInfo(track),gops=alignedGops}trackDecodeInfo_collectDtsInfo(track,gops),track.samples=frameUtils_generateSampleTable(gops),mdat=mp4Generator_mdat(frameUtils_concatenateNalData(gops)),track.baseMediaDecodeTime=trackDecodeInfo_calculateTrackBaseMediaDecodeTime(track,options.keepOriginalTimestamps),this.trigger("processedGopsInfo",gops.map((function(gop){return{pts:gop.pts,dts:gop.dts,byteLength:gop.byteLength}}))),firstGop=gops[0],lastGop=gops[gops.length-1],this.trigger("segmentTimingInfo",generateSegmentTimingInfo(track.baseMediaDecodeTime,firstGop.dts,firstGop.pts,lastGop.dts+lastGop.duration,lastGop.pts+lastGop.duration,prependedContentDuration)),this.trigger("timingInfo",{start:gops[0].pts,end:gops[gops.length-1].pts+gops[gops.length-1].duration}),this.gopCache_.unshift({gop:gops.pop(),pps:track.pps,sps:track.sps}),this.gopCache_.length=Math.min(6,this.gopCache_.length),nalUnits=[],this.trigger("baseMediaDecodeTime",track.baseMediaDecodeTime),this.trigger("timelineStartInfo",track.timelineStartInfo),moof=mp4Generator_moof(sequenceNumber,[track]),boxes=new Uint8Array(moof.byteLength+mdat.byteLength),sequenceNumber++,boxes.set(moof),boxes.set(mdat,moof.byteLength),this.trigger("data",{track:track,boxes:boxes}),this.resetStream_(),this.trigger("done","VideoSegmentStream")},this.reset=function(){this.resetStream_(),nalUnits=[],this.gopCache_.length=0,gopsToAlignWith.length=0,this.trigger("reset")},this.resetStream_=function(){trackDecodeInfo_clearDtsInfo(track),config=void 0,pps=void 0},this.getGopForFusion_=function(nalUnit){var dtsDistance,nearestGopObj,currentGop,currentGopObj,i,nearestDistance=1/0;for(i=0;i<this.gopCache_.length;i++)currentGop=(currentGopObj=this.gopCache_[i]).gop,track.pps&&arrayEquals(track.pps[0],currentGopObj.pps[0])&&track.sps&&arrayEquals(track.sps[0],currentGopObj.sps[0])&&(currentGop.dts<track.timelineStartInfo.dts||(dtsDistance=nalUnit.dts-currentGop.dts-currentGop.duration)>=-1e4&&dtsDistance<=45e3&&(!nearestGopObj||nearestDistance>dtsDistance)&&(nearestGopObj=currentGopObj,nearestDistance=dtsDistance));return nearestGopObj?nearestGopObj.gop:null},this.alignGopsAtStart_=function(gops){var alignIndex,gopIndex,align,gop,byteLength,nalCount,duration,alignedGops;for(byteLength=gops.byteLength,nalCount=gops.nalCount,duration=gops.duration,alignIndex=gopIndex=0;alignIndex<gopsToAlignWith.length&&gopIndex<gops.length&&(align=gopsToAlignWith[alignIndex],gop=gops[gopIndex],align.pts!==gop.pts);)gop.pts>align.pts?alignIndex++:(gopIndex++,byteLength-=gop.byteLength,nalCount-=gop.nalCount,duration-=gop.duration);return 0===gopIndex?gops:gopIndex===gops.length?null:((alignedGops=gops.slice(gopIndex)).byteLength=byteLength,alignedGops.duration=duration,alignedGops.nalCount=nalCount,alignedGops.pts=alignedGops[0].pts,alignedGops.dts=alignedGops[0].dts,alignedGops)},this.alignGopsAtEnd_=function(gops){var alignIndex,gopIndex,align,gop,alignEndIndex,matchFound,trimIndex;for(alignIndex=gopsToAlignWith.length-1,gopIndex=gops.length-1,alignEndIndex=null,matchFound=!1;alignIndex>=0&&gopIndex>=0;){if(align=gopsToAlignWith[alignIndex],gop=gops[gopIndex],align.pts===gop.pts){matchFound=!0;break}align.pts>gop.pts?alignIndex--:(alignIndex===gopsToAlignWith.length-1&&(alignEndIndex=gopIndex),gopIndex--)}if(!matchFound&&null===alignEndIndex)return null;if(0===(trimIndex=matchFound?gopIndex:alignEndIndex))return gops;var alignedGops=gops.slice(trimIndex),metadata=alignedGops.reduce((function(total,gop){return total.byteLength+=gop.byteLength,total.duration+=gop.duration,total.nalCount+=gop.nalCount,total}),{byteLength:0,duration:0,nalCount:0});return alignedGops.byteLength=metadata.byteLength,alignedGops.duration=metadata.duration,alignedGops.nalCount=metadata.nalCount,alignedGops.pts=alignedGops[0].pts,alignedGops.dts=alignedGops[0].dts,alignedGops},this.alignGopsWith=function(newGopsToAlignWith){gopsToAlignWith=newGopsToAlignWith}},_VideoSegmentStream.prototype=new stream,_CoalesceStream=function(options,metadataStream){this.numberOfTracks=0,this.metadataStream=metadataStream,void 0!==(options=options||{}).remux?this.remuxTracks=!!options.remux:this.remuxTracks=!0,"boolean"==typeof options.keepOriginalTimestamps?this.keepOriginalTimestamps=options.keepOriginalTimestamps:this.keepOriginalTimestamps=!1,this.pendingTracks=[],this.videoTrack=null,this.pendingBoxes=[],this.pendingCaptions=[],this.pendingMetadata=[],this.pendingBytes=0,this.emittedTracks=0,_CoalesceStream.prototype.init.call(this),this.push=function(output){return output.text?this.pendingCaptions.push(output):output.frames?this.pendingMetadata.push(output):(this.pendingTracks.push(output.track),this.pendingBytes+=output.boxes.byteLength,"video"===output.track.type&&(this.videoTrack=output.track,this.pendingBoxes.push(output.boxes)),void("audio"===output.track.type&&(this.audioTrack=output.track,this.pendingBoxes.unshift(output.boxes))))}},_CoalesceStream.prototype=new stream,_CoalesceStream.prototype.flush=function(flushSource){var caption,id3,initSegment,i,offset=0,event={captions:[],captionStreams:{},metadata:[],info:{}},timelineStartPts=0;if(this.pendingTracks.length<this.numberOfTracks){if("VideoSegmentStream"!==flushSource&&"AudioSegmentStream"!==flushSource)return;if(this.remuxTracks)return;if(0===this.pendingTracks.length)return this.emittedTracks++,void(this.emittedTracks>=this.numberOfTracks&&(this.trigger("done"),this.emittedTracks=0))}if(this.videoTrack?(timelineStartPts=this.videoTrack.timelineStartInfo.pts,videoProperties.forEach((function(prop){event.info[prop]=this.videoTrack[prop]}),this)):this.audioTrack&&(timelineStartPts=this.audioTrack.timelineStartInfo.pts,audioProperties.forEach((function(prop){event.info[prop]=this.audioTrack[prop]}),this)),this.videoTrack||this.audioTrack){for(1===this.pendingTracks.length?event.type=this.pendingTracks[0].type:event.type="combined",this.emittedTracks+=this.pendingTracks.length,initSegment=mp4Generator_initSegment(this.pendingTracks),event.initSegment=new Uint8Array(initSegment.byteLength),event.initSegment.set(initSegment),event.data=new Uint8Array(this.pendingBytes),i=0;i<this.pendingBoxes.length;i++)event.data.set(this.pendingBoxes[i],offset),offset+=this.pendingBoxes[i].byteLength;for(i=0;i<this.pendingCaptions.length;i++)(caption=this.pendingCaptions[i]).startTime=clock_metadataTsToSeconds$0(caption.startPts,timelineStartPts,this.keepOriginalTimestamps),caption.endTime=clock_metadataTsToSeconds$0(caption.endPts,timelineStartPts,this.keepOriginalTimestamps),event.captionStreams[caption.stream]=!0,event.captions.push(caption);for(i=0;i<this.pendingMetadata.length;i++)(id3=this.pendingMetadata[i]).cueTime=clock_metadataTsToSeconds$0(id3.pts,timelineStartPts,this.keepOriginalTimestamps),event.metadata.push(id3);for(event.metadata.dispatchType=this.metadataStream.dispatchType,this.pendingTracks.length=0,this.videoTrack=null,this.pendingBoxes.length=0,this.pendingCaptions.length=0,this.pendingBytes=0,this.pendingMetadata.length=0,this.trigger("data",event),i=0;i<event.captions.length;i++)caption=event.captions[i],this.trigger("caption",caption);for(i=0;i<event.metadata.length;i++)id3=event.metadata[i],this.trigger("id3Frame",id3)}this.emittedTracks>=this.numberOfTracks&&(this.trigger("done"),this.emittedTracks=0)},_CoalesceStream.prototype.setRemux=function(val){this.remuxTracks=val},_Transmuxer=function(options){var videoTrack,audioTrack,self=this,hasFlushed=!0;_Transmuxer.prototype.init.call(this),options=options||{},this.baseMediaDecodeTime=options.baseMediaDecodeTime||0,this.transmuxPipeline_={},this.setupAacPipeline=function(){var pipeline={};this.transmuxPipeline_=pipeline,pipeline.type="aac",pipeline.metadataStream=new m2ts_1.MetadataStream,pipeline.aacStream=new aac,pipeline.audioTimestampRolloverStream=new m2ts_1.TimestampRolloverStream("audio"),pipeline.timedMetadataTimestampRolloverStream=new m2ts_1.TimestampRolloverStream("timed-metadata"),pipeline.adtsStream=new adts,pipeline.coalesceStream=new _CoalesceStream(options,pipeline.metadataStream),pipeline.headOfPipeline=pipeline.aacStream,pipeline.aacStream.pipe(pipeline.audioTimestampRolloverStream).pipe(pipeline.adtsStream),pipeline.aacStream.pipe(pipeline.timedMetadataTimestampRolloverStream).pipe(pipeline.metadataStream).pipe(pipeline.coalesceStream),pipeline.metadataStream.on("timestamp",(function(frame){pipeline.aacStream.setTimestamp(frame.timeStamp)})),pipeline.aacStream.on("data",(function(data){"timed-metadata"!==data.type&&"audio"!==data.type||pipeline.audioSegmentStream||(audioTrack=audioTrack||{timelineStartInfo:{baseMediaDecodeTime:self.baseMediaDecodeTime},codec:"adts",type:"audio"},pipeline.coalesceStream.numberOfTracks++,pipeline.audioSegmentStream=new _AudioSegmentStream(audioTrack,options),pipeline.audioSegmentStream.on("log",self.getLogTrigger_("audioSegmentStream")),pipeline.audioSegmentStream.on("timingInfo",self.trigger.bind(self,"audioTimingInfo")),pipeline.adtsStream.pipe(pipeline.audioSegmentStream).pipe(pipeline.coalesceStream),self.trigger("trackinfo",{hasAudio:!!audioTrack,hasVideo:!!videoTrack}))})),pipeline.coalesceStream.on("data",this.trigger.bind(this,"data")),pipeline.coalesceStream.on("done",this.trigger.bind(this,"done")),addPipelineLogRetriggers(this,pipeline)},this.setupTsPipeline=function(){var pipeline={};this.transmuxPipeline_=pipeline,pipeline.type="ts",pipeline.metadataStream=new m2ts_1.MetadataStream,pipeline.packetStream=new m2ts_1.TransportPacketStream,pipeline.parseStream=new m2ts_1.TransportParseStream,pipeline.elementaryStream=new m2ts_1.ElementaryStream,pipeline.timestampRolloverStream=new m2ts_1.TimestampRolloverStream,pipeline.adtsStream=new adts,pipeline.h264Stream=new H264Stream,pipeline.captionStream=new m2ts_1.CaptionStream(options),pipeline.coalesceStream=new _CoalesceStream(options,pipeline.metadataStream),pipeline.headOfPipeline=pipeline.packetStream,pipeline.packetStream.pipe(pipeline.parseStream).pipe(pipeline.elementaryStream).pipe(pipeline.timestampRolloverStream),pipeline.timestampRolloverStream.pipe(pipeline.h264Stream),pipeline.timestampRolloverStream.pipe(pipeline.adtsStream),pipeline.timestampRolloverStream.pipe(pipeline.metadataStream).pipe(pipeline.coalesceStream),pipeline.h264Stream.pipe(pipeline.captionStream).pipe(pipeline.coalesceStream),pipeline.elementaryStream.on("data",(function(data){var i;if("metadata"===data.type){for(i=data.tracks.length;i--;)videoTrack||"video"!==data.tracks[i].type?audioTrack||"audio"!==data.tracks[i].type||((audioTrack=data.tracks[i]).timelineStartInfo.baseMediaDecodeTime=self.baseMediaDecodeTime):(videoTrack=data.tracks[i]).timelineStartInfo.baseMediaDecodeTime=self.baseMediaDecodeTime;videoTrack&&!pipeline.videoSegmentStream&&(pipeline.coalesceStream.numberOfTracks++,pipeline.videoSegmentStream=new _VideoSegmentStream(videoTrack,options),pipeline.videoSegmentStream.on("log",self.getLogTrigger_("videoSegmentStream")),pipeline.videoSegmentStream.on("timelineStartInfo",(function(timelineStartInfo){audioTrack&&!options.keepOriginalTimestamps&&(audioTrack.timelineStartInfo=timelineStartInfo,pipeline.audioSegmentStream.setEarliestDts(timelineStartInfo.dts-self.baseMediaDecodeTime))})),pipeline.videoSegmentStream.on("processedGopsInfo",self.trigger.bind(self,"gopInfo")),pipeline.videoSegmentStream.on("segmentTimingInfo",self.trigger.bind(self,"videoSegmentTimingInfo")),pipeline.videoSegmentStream.on("baseMediaDecodeTime",(function(baseMediaDecodeTime){audioTrack&&pipeline.audioSegmentStream.setVideoBaseMediaDecodeTime(baseMediaDecodeTime)})),pipeline.videoSegmentStream.on("timingInfo",self.trigger.bind(self,"videoTimingInfo")),pipeline.h264Stream.pipe(pipeline.videoSegmentStream).pipe(pipeline.coalesceStream)),audioTrack&&!pipeline.audioSegmentStream&&(pipeline.coalesceStream.numberOfTracks++,pipeline.audioSegmentStream=new _AudioSegmentStream(audioTrack,options),pipeline.audioSegmentStream.on("log",self.getLogTrigger_("audioSegmentStream")),pipeline.audioSegmentStream.on("timingInfo",self.trigger.bind(self,"audioTimingInfo")),pipeline.audioSegmentStream.on("segmentTimingInfo",self.trigger.bind(self,"audioSegmentTimingInfo")),pipeline.adtsStream.pipe(pipeline.audioSegmentStream).pipe(pipeline.coalesceStream)),self.trigger("trackinfo",{hasAudio:!!audioTrack,hasVideo:!!videoTrack})}})),pipeline.coalesceStream.on("data",this.trigger.bind(this,"data")),pipeline.coalesceStream.on("id3Frame",(function(id3Frame){id3Frame.dispatchType=pipeline.metadataStream.dispatchType,self.trigger("id3Frame",id3Frame)})),pipeline.coalesceStream.on("caption",this.trigger.bind(this,"caption")),pipeline.coalesceStream.on("done",this.trigger.bind(this,"done")),addPipelineLogRetriggers(this,pipeline)},this.setBaseMediaDecodeTime=function(baseMediaDecodeTime){var pipeline=this.transmuxPipeline_;options.keepOriginalTimestamps||(this.baseMediaDecodeTime=baseMediaDecodeTime),audioTrack&&(audioTrack.timelineStartInfo.dts=void 0,audioTrack.timelineStartInfo.pts=void 0,trackDecodeInfo_clearDtsInfo(audioTrack),pipeline.audioTimestampRolloverStream&&pipeline.audioTimestampRolloverStream.discontinuity()),videoTrack&&(pipeline.videoSegmentStream&&(pipeline.videoSegmentStream.gopCache_=[]),videoTrack.timelineStartInfo.dts=void 0,videoTrack.timelineStartInfo.pts=void 0,trackDecodeInfo_clearDtsInfo(videoTrack),pipeline.captionStream.reset()),pipeline.timestampRolloverStream&&pipeline.timestampRolloverStream.discontinuity()},this.setAudioAppendStart=function(timestamp){audioTrack&&this.transmuxPipeline_.audioSegmentStream.setAudioAppendStart(timestamp)},this.setRemux=function(val){var pipeline=this.transmuxPipeline_;options.remux=val,pipeline&&pipeline.coalesceStream&&pipeline.coalesceStream.setRemux(val)},this.alignGopsWith=function(gopsToAlignWith){videoTrack&&this.transmuxPipeline_.videoSegmentStream&&this.transmuxPipeline_.videoSegmentStream.alignGopsWith(gopsToAlignWith)},this.getLogTrigger_=function(key){var self=this;return function(event){event.stream=key,self.trigger("log",event)}},this.push=function(data){if(hasFlushed){var isAac=isLikelyAacData(data);isAac&&"aac"!==this.transmuxPipeline_.type?this.setupAacPipeline():isAac||"ts"===this.transmuxPipeline_.type||this.setupTsPipeline(),hasFlushed=!1}this.transmuxPipeline_.headOfPipeline.push(data)},this.flush=function(){hasFlushed=!0,this.transmuxPipeline_.headOfPipeline.flush()},this.endTimeline=function(){this.transmuxPipeline_.headOfPipeline.endTimeline()},this.reset=function(){this.transmuxPipeline_.headOfPipeline&&this.transmuxPipeline_.headOfPipeline.reset()},this.resetCaptions=function(){this.transmuxPipeline_.captionStream&&this.transmuxPipeline_.captionStream.reset()}},_Transmuxer.prototype=new stream;var startTime,getTracks,getTimescaleFromMediaHeader,transmuxer={Transmuxer:_Transmuxer,VideoSegmentStream:_VideoSegmentStream,AudioSegmentStream:_AudioSegmentStream,AUDIO_PROPERTIES:audioProperties,VIDEO_PROPERTIES:videoProperties,generateSegmentTimingInfo:generateSegmentTimingInfo},bin_toUnsigned=function(value){return value>>>0},parseType_1=function(buffer){var result="";return result+=String.fromCharCode(buffer[0]),result+=String.fromCharCode(buffer[1]),result+=String.fromCharCode(buffer[2]),result+=String.fromCharCode(buffer[3])},toUnsigned$2=bin_toUnsigned,findBox_1=function findBox(data,path){var i,size,type,end,subresults,results=[];if(!path.length)return null;for(i=0;i<data.byteLength;)size=toUnsigned$2(data[i]<<24|data[i+1]<<16|data[i+2]<<8|data[i+3]),type=parseType_1(data.subarray(i+4,i+8)),end=size>1?i+size:data.byteLength,type===path[0]&&(1===path.length?results.push(data.subarray(i+8,end)):(subresults=findBox(data.subarray(i+8,end),path.slice(1))).length&&(results=results.concat(subresults))),i=end;return results},toUnsigned$1=bin_toUnsigned,parseTfdt=function(data){var result={version:data[0],flags:new Uint8Array(data.subarray(1,4)),baseMediaDecodeTime:toUnsigned$1(data[4]<<24|data[5]<<16|data[6]<<8|data[7])};return 1===result.version&&(result.baseMediaDecodeTime*=Math.pow(2,32),result.baseMediaDecodeTime+=toUnsigned$1(data[8]<<24|data[9]<<16|data[10]<<8|data[11])),result},parseSampleFlags_1=function(flags){return{isLeading:(12&flags[0])>>>2,dependsOn:3&flags[0],isDependedOn:(192&flags[1])>>>6,hasRedundancy:(48&flags[1])>>>4,paddingValue:(14&flags[1])>>>1,isNonSyncSample:1&flags[1],degradationPriority:flags[2]<<8|flags[3]}},parseTrun=function(data){var sample,result={version:data[0],flags:new Uint8Array(data.subarray(1,4)),samples:[]},view=new DataView(data.buffer,data.byteOffset,data.byteLength),dataOffsetPresent=1&result.flags[2],firstSampleFlagsPresent=4&result.flags[2],sampleDurationPresent=1&result.flags[1],sampleSizePresent=2&result.flags[1],sampleFlagsPresent=4&result.flags[1],sampleCompositionTimeOffsetPresent=8&result.flags[1],sampleCount=view.getUint32(4),offset=8;for(dataOffsetPresent&&(result.dataOffset=view.getInt32(offset),offset+=4),firstSampleFlagsPresent&&sampleCount&&(sample={flags:parseSampleFlags_1(data.subarray(offset,offset+4))},offset+=4,sampleDurationPresent&&(sample.duration=view.getUint32(offset),offset+=4),sampleSizePresent&&(sample.size=view.getUint32(offset),offset+=4),sampleCompositionTimeOffsetPresent&&(1===result.version?sample.compositionTimeOffset=view.getInt32(offset):sample.compositionTimeOffset=view.getUint32(offset),offset+=4),result.samples.push(sample),sampleCount--);sampleCount--;)sample={},sampleDurationPresent&&(sample.duration=view.getUint32(offset),offset+=4),sampleSizePresent&&(sample.size=view.getUint32(offset),offset+=4),sampleFlagsPresent&&(sample.flags=parseSampleFlags_1(data.subarray(offset,offset+4)),offset+=4),sampleCompositionTimeOffsetPresent&&(1===result.version?sample.compositionTimeOffset=view.getInt32(offset):sample.compositionTimeOffset=view.getUint32(offset),offset+=4),result.samples.push(sample);return result},parseTfhd=function(data){var i,view=new DataView(data.buffer,data.byteOffset,data.byteLength),result={version:data[0],flags:new Uint8Array(data.subarray(1,4)),trackId:view.getUint32(4)},baseDataOffsetPresent=1&result.flags[2],sampleDescriptionIndexPresent=2&result.flags[2],defaultSampleDurationPresent=8&result.flags[2],defaultSampleSizePresent=16&result.flags[2],defaultSampleFlagsPresent=32&result.flags[2],durationIsEmpty=65536&result.flags[0],defaultBaseIsMoof=131072&result.flags[0];return i=8,baseDataOffsetPresent&&(i+=4,result.baseDataOffset=view.getUint32(12),i+=4),sampleDescriptionIndexPresent&&(result.sampleDescriptionIndex=view.getUint32(i),i+=4),defaultSampleDurationPresent&&(result.defaultSampleDuration=view.getUint32(i),i+=4),defaultSampleSizePresent&&(result.defaultSampleSize=view.getUint32(i),i+=4),defaultSampleFlagsPresent&&(result.defaultSampleFlags=view.getUint32(i)),durationIsEmpty&&(result.durationIsEmpty=!0),!baseDataOffsetPresent&&defaultBaseIsMoof&&(result.baseDataOffsetIsMoof=!0),result},discardEmulationPreventionBytes=captionPacketParser_discardEmulationPreventionBytes,CaptionStream=captionStream.CaptionStream,mapToSample=function(offset,samples){for(var approximateOffset=offset,i=0;i<samples.length;i++){var sample=samples[i];if(approximateOffset<sample.size)return sample;approximateOffset-=sample.size}return null},parseCaptionNals=function(segment,videoTrackId){var trafs=findBox_1(segment,["moof","traf"]),mdats=findBox_1(segment,["mdat"]),captionNals={},mdatTrafPairs=[];return mdats.forEach((function(mdat,index){var matchingTraf=trafs[index];mdatTrafPairs.push({mdat:mdat,traf:matchingTraf})})),mdatTrafPairs.forEach((function(pair){var samples,result,mdat=pair.mdat,traf=pair.traf,tfhd=findBox_1(traf,["tfhd"]),headerInfo=parseTfhd(tfhd[0]),trackId=headerInfo.trackId,tfdt=findBox_1(traf,["tfdt"]),baseMediaDecodeTime=tfdt.length>0?parseTfdt(tfdt[0]).baseMediaDecodeTime:0,truns=findBox_1(traf,["trun"]);videoTrackId===trackId&&truns.length>0&&(samples=function(truns,baseMediaDecodeTime,tfhd){var currentDts=baseMediaDecodeTime,defaultSampleDuration=tfhd.defaultSampleDuration||0,defaultSampleSize=tfhd.defaultSampleSize||0,trackId=tfhd.trackId,allSamples=[];return truns.forEach((function(trun){var samples=parseTrun(trun).samples;samples.forEach((function(sample){void 0===sample.duration&&(sample.duration=defaultSampleDuration),void 0===sample.size&&(sample.size=defaultSampleSize),sample.trackId=trackId,sample.dts=currentDts,void 0===sample.compositionTimeOffset&&(sample.compositionTimeOffset=0),sample.pts=currentDts+sample.compositionTimeOffset,currentDts+=sample.duration})),allSamples=allSamples.concat(samples)})),allSamples}(truns,baseMediaDecodeTime,headerInfo),result=function(avcStream,samples,trackId){var seiNal,i,length,lastMatchedSample,avcView=new DataView(avcStream.buffer,avcStream.byteOffset,avcStream.byteLength),result={logs:[],seiNals:[]};for(i=0;i+4<avcStream.length;i+=length)if(length=avcView.getUint32(i),i+=4,!(length<=0))switch(31&avcStream[i]){case 6:var data=avcStream.subarray(i+1,i+1+length),matchingSample=mapToSample(i,samples);if(seiNal={nalUnitType:"sei_rbsp",size:length,data:data,escapedRBSP:discardEmulationPreventionBytes(data),trackId:trackId},matchingSample)seiNal.pts=matchingSample.pts,seiNal.dts=matchingSample.dts,lastMatchedSample=matchingSample;else{if(!lastMatchedSample){result.logs.push({level:"warn",message:"We've encountered a nal unit without data at "+i+" for trackId "+trackId+". See mux.js#223."});break}seiNal.pts=lastMatchedSample.pts,seiNal.dts=lastMatchedSample.dts}result.seiNals.push(seiNal)}return result}(mdat,samples,trackId),captionNals[trackId]||(captionNals[trackId]={seiNals:[],logs:[]}),captionNals[trackId].seiNals=captionNals[trackId].seiNals.concat(result.seiNals),captionNals[trackId].logs=captionNals[trackId].logs.concat(result.logs))})),captionNals},captionParser=function(){var captionStream,segmentCache,trackId,timescale,parsedCaptions,parsingPartial,isInitialized=!1;this.isInitialized=function(){return isInitialized},this.init=function(options){captionStream=new CaptionStream,isInitialized=!0,parsingPartial=!!options&&options.isPartial,captionStream.on("data",(function(event){event.startTime=event.startPts/timescale,event.endTime=event.endPts/timescale,parsedCaptions.captions.push(event),parsedCaptions.captionStreams[event.stream]=!0})),captionStream.on("log",(function(log){parsedCaptions.logs.push(log)}))},this.isNewInit=function(videoTrackIds,timescales){return!(videoTrackIds&&0===videoTrackIds.length||timescales&&"object"==typeof timescales&&0===Object.keys(timescales).length)&&(trackId!==videoTrackIds[0]||timescale!==timescales[trackId])},this.parse=function(segment,videoTrackIds,timescales){var parsedData;if(!this.isInitialized())return null;if(!videoTrackIds||!timescales)return null;if(this.isNewInit(videoTrackIds,timescales))trackId=videoTrackIds[0],timescale=timescales[trackId];else if(null===trackId||!timescale)return segmentCache.push(segment),null;for(;segmentCache.length>0;){var cachedSegment=segmentCache.shift();this.parse(cachedSegment,videoTrackIds,timescales)}return parsedData=function(segment,trackId,timescale){if(null===trackId)return null;var trackNals=parseCaptionNals(segment,trackId)[trackId]||{};return{seiNals:trackNals.seiNals,logs:trackNals.logs,timescale:timescale}}(segment,trackId,timescale),parsedData&&parsedData.logs&&(parsedCaptions.logs=parsedCaptions.logs.concat(parsedData.logs)),null!==parsedData&&parsedData.seiNals?(this.pushNals(parsedData.seiNals),this.flushStream(),parsedCaptions):parsedCaptions.logs.length?{logs:parsedCaptions.logs,captions:[],captionStreams:[]}:null},this.pushNals=function(nals){if(!this.isInitialized()||!nals||0===nals.length)return null;nals.forEach((function(nal){captionStream.push(nal)}))},this.flushStream=function(){if(!this.isInitialized())return null;parsingPartial?captionStream.partialFlush():captionStream.flush()},this.clearParsedCaptions=function(){parsedCaptions.captions=[],parsedCaptions.captionStreams={},parsedCaptions.logs=[]},this.resetCaptionStream=function(){if(!this.isInitialized())return null;captionStream.reset()},this.clearAllCaptions=function(){this.clearParsedCaptions(),this.resetCaptionStream()},this.reset=function(){segmentCache=[],trackId=null,timescale=null,parsedCaptions?this.clearParsedCaptions():parsedCaptions={captions:[],captionStreams:{},logs:[]},this.resetCaptionStream()},this.reset()},toUnsigned=bin_toUnsigned,toHexString=function(value){return("00"+value.toString(16)).slice(-2)};startTime=function(timescale,fragment){var trafs,baseTimes,result;return trafs=findBox_1(fragment,["moof","traf"]),baseTimes=[].concat.apply([],trafs.map((function(traf){return findBox_1(traf,["tfhd"]).map((function(tfhd){var id,scale,baseTime;return id=toUnsigned(tfhd[4]<<24|tfhd[5]<<16|tfhd[6]<<8|tfhd[7]),scale=timescale[id]||9e4,baseTime=findBox_1(traf,["tfdt"]).map((function(tfdt){var version,result;return version=tfdt[0],result=toUnsigned(tfdt[4]<<24|tfdt[5]<<16|tfdt[6]<<8|tfdt[7]),1===version&&(result*=Math.pow(2,32),result+=toUnsigned(tfdt[8]<<24|tfdt[9]<<16|tfdt[10]<<8|tfdt[11])),result}))[0],(baseTime="number"!=typeof baseTime||isNaN(baseTime)?1/0:baseTime)/scale}))}))),result=Math.min.apply(null,baseTimes),isFinite(result)?result:0},getTimescaleFromMediaHeader=function(mdhd){var index=0===mdhd[0]?12:20;return toUnsigned(mdhd[index]<<24|mdhd[index+1]<<16|mdhd[index+2]<<8|mdhd[index+3])},getTracks=function(init){var traks=findBox_1(init,["moov","trak"]),tracks=[];return traks.forEach((function(trak){var view,tkhdVersion,track={},tkhd=findBox_1(trak,["tkhd"])[0];tkhd&&(tkhdVersion=(view=new DataView(tkhd.buffer,tkhd.byteOffset,tkhd.byteLength)).getUint8(0),track.id=0===tkhdVersion?view.getUint32(12):view.getUint32(20));var hdlr=findBox_1(trak,["mdia","hdlr"])[0];if(hdlr){var type=parseType_1(hdlr.subarray(8,12));track.type="vide"===type?"video":"soun"===type?"audio":type}var stsd=findBox_1(trak,["mdia","minf","stbl","stsd"])[0];if(stsd){var sampleDescriptions=stsd.subarray(8);track.codec=parseType_1(sampleDescriptions.subarray(4,8));var codecConfig,codecBox=findBox_1(sampleDescriptions,[track.codec])[0];codecBox&&(/^[asm]vc[1-9]$/i.test(track.codec)?(codecConfig=codecBox.subarray(78),"avcC"===parseType_1(codecConfig.subarray(4,8))&&codecConfig.length>11?(track.codec+=".",track.codec+=toHexString(codecConfig[9]),track.codec+=toHexString(codecConfig[10]),track.codec+=toHexString(codecConfig[11])):track.codec="avc1.4d400d"):/^mp4[a,v]$/i.test(track.codec)?(codecConfig=codecBox.subarray(28),"esds"===parseType_1(codecConfig.subarray(4,8))&&codecConfig.length>20&&0!==codecConfig[19]?(track.codec+="."+toHexString(codecConfig[19]),track.codec+="."+toHexString(codecConfig[20]>>>2&63).replace(/^0/,"")):track.codec="mp4a.40.2"):track.codec=track.codec.toLowerCase())}var mdhd=findBox_1(trak,["mdia","mdhd"])[0];mdhd&&(track.timescale=getTimescaleFromMediaHeader(mdhd)),tracks.push(track)})),tracks};var probe$2_startTime=startTime,probe$2_tracks=getTracks,parsePid=function(packet){var pid=31&packet[1];return pid<<=8,pid|=packet[2]},parsePayloadUnitStartIndicator=function(packet){return!!(64&packet[1])},parseAdaptionField=function(packet){var offset=0;return(48&packet[3])>>>4>1&&(offset+=packet[4]+1),offset},parseNalUnitType=function(type){switch(type){case 5:return"slice_layer_without_partitioning_rbsp_idr";case 6:return"sei_rbsp";case 7:return"seq_parameter_set_rbsp";case 8:return"pic_parameter_set_rbsp";case 9:return"access_unit_delimiter_rbsp";default:return null}},probe$1={parseType:function(packet,pmtPid){var pid=parsePid(packet);return 0===pid?"pat":pid===pmtPid?"pmt":pmtPid?"pes":null},parsePat:function(packet){var pusi=parsePayloadUnitStartIndicator(packet),offset=4+parseAdaptionField(packet);return pusi&&(offset+=packet[offset]+1),(31&packet[offset+10])<<8|packet[offset+11]},parsePmt:function(packet){var programMapTable={},pusi=parsePayloadUnitStartIndicator(packet),payloadOffset=4+parseAdaptionField(packet);if(pusi&&(payloadOffset+=packet[payloadOffset]+1),1&packet[payloadOffset+5]){var tableEnd;tableEnd=3+((15&packet[payloadOffset+1])<<8|packet[payloadOffset+2])-4;for(var offset=12+((15&packet[payloadOffset+10])<<8|packet[payloadOffset+11]);offset<tableEnd;){var i=payloadOffset+offset;programMapTable[(31&packet[i+1])<<8|packet[i+2]]=packet[i],offset+=5+((15&packet[i+3])<<8|packet[i+4])}return programMapTable}},parsePayloadUnitStartIndicator:parsePayloadUnitStartIndicator,parsePesType:function(packet,programMapTable){switch(programMapTable[parsePid(packet)]){case streamTypes.H264_STREAM_TYPE:return"video";case streamTypes.ADTS_STREAM_TYPE:return"audio";case streamTypes.METADATA_STREAM_TYPE:return"timed-metadata";default:return null}},parsePesTime:function(packet){if(!parsePayloadUnitStartIndicator(packet))return null;var offset=4+parseAdaptionField(packet);if(offset>=packet.byteLength)return null;var ptsDtsFlags,pes=null;return 192&(ptsDtsFlags=packet[offset+7])&&((pes={}).pts=(14&packet[offset+9])<<27|(255&packet[offset+10])<<20|(254&packet[offset+11])<<12|(255&packet[offset+12])<<5|(254&packet[offset+13])>>>3,pes.pts*=4,pes.pts+=(6&packet[offset+13])>>>1,pes.dts=pes.pts,64&ptsDtsFlags&&(pes.dts=(14&packet[offset+14])<<27|(255&packet[offset+15])<<20|(254&packet[offset+16])<<12|(255&packet[offset+17])<<5|(254&packet[offset+18])>>>3,pes.dts*=4,pes.dts+=(6&packet[offset+18])>>>1)),pes},videoPacketContainsKeyFrame:function(packet){for(var offset=4+parseAdaptionField(packet),frameBuffer=packet.subarray(offset),frameI=0,frameSyncPoint=0,foundKeyFrame=!1;frameSyncPoint<frameBuffer.byteLength-3;frameSyncPoint++)if(1===frameBuffer[frameSyncPoint+2]){frameI=frameSyncPoint+5;break}for(;frameI<frameBuffer.byteLength;)switch(frameBuffer[frameI]){case 0:if(0!==frameBuffer[frameI-1]){frameI+=2;break}if(0!==frameBuffer[frameI-2]){frameI++;break}frameSyncPoint+3!==frameI-2&&"slice_layer_without_partitioning_rbsp_idr"===parseNalUnitType(31&frameBuffer[frameSyncPoint+3])&&(foundKeyFrame=!0);do{frameI++}while(1!==frameBuffer[frameI]&&frameI<frameBuffer.length);frameSyncPoint=frameI-2,frameI+=3;break;case 1:if(0!==frameBuffer[frameI-1]||0!==frameBuffer[frameI-2]){frameI+=3;break}"slice_layer_without_partitioning_rbsp_idr"===parseNalUnitType(31&frameBuffer[frameSyncPoint+3])&&(foundKeyFrame=!0),frameSyncPoint=frameI-2,frameI+=3;break;default:frameI+=3}return frameBuffer=frameBuffer.subarray(frameSyncPoint),frameI-=frameSyncPoint,frameSyncPoint=0,frameBuffer&&frameBuffer.byteLength>3&&"slice_layer_without_partitioning_rbsp_idr"===parseNalUnitType(31&frameBuffer[frameSyncPoint+3])&&(foundKeyFrame=!0),foundKeyFrame}},handleRollover=timestampRolloverStream_handleRollover,probe={};probe.ts=probe$1,probe.aac=utils;var ONE_SECOND_IN_TS=clock_ONE_SECOND_IN_TS$0,parseAudioPes_=function(bytes,pmt,result){for(var packet,pesType,pusi,parsed,startIndex=0,endIndex=188,endLoop=!1;endIndex<=bytes.byteLength;)if(71!==bytes[startIndex]||71!==bytes[endIndex]&&endIndex!==bytes.byteLength)startIndex++,endIndex++;else{if(packet=bytes.subarray(startIndex,endIndex),"pes"===probe.ts.parseType(packet,pmt.pid))pesType=probe.ts.parsePesType(packet,pmt.table),pusi=probe.ts.parsePayloadUnitStartIndicator(packet),"audio"===pesType&&pusi&&(parsed=probe.ts.parsePesTime(packet))&&(parsed.type="audio",result.audio.push(parsed),endLoop=!0);if(endLoop)break;startIndex+=188,endIndex+=188}for(startIndex=(endIndex=bytes.byteLength)-188,endLoop=!1;startIndex>=0;)if(71!==bytes[startIndex]||71!==bytes[endIndex]&&endIndex!==bytes.byteLength)startIndex--,endIndex--;else{if(packet=bytes.subarray(startIndex,endIndex),"pes"===probe.ts.parseType(packet,pmt.pid))pesType=probe.ts.parsePesType(packet,pmt.table),pusi=probe.ts.parsePayloadUnitStartIndicator(packet),"audio"===pesType&&pusi&&(parsed=probe.ts.parsePesTime(packet))&&(parsed.type="audio",result.audio.push(parsed),endLoop=!0);if(endLoop)break;startIndex-=188,endIndex-=188}},parseVideoPes_=function(bytes,pmt,result){for(var packet,pesType,pusi,parsed,frame,i,pes,startIndex=0,endIndex=188,endLoop=!1,currentFrame={data:[],size:0};endIndex<bytes.byteLength;)if(71!==bytes[startIndex]||71!==bytes[endIndex])startIndex++,endIndex++;else{if(packet=bytes.subarray(startIndex,endIndex),"pes"===probe.ts.parseType(packet,pmt.pid))if(pesType=probe.ts.parsePesType(packet,pmt.table),pusi=probe.ts.parsePayloadUnitStartIndicator(packet),"video"===pesType&&(pusi&&!endLoop&&(parsed=probe.ts.parsePesTime(packet))&&(parsed.type="video",result.video.push(parsed),endLoop=!0),!result.firstKeyFrame)){if(pusi&&0!==currentFrame.size){for(frame=new Uint8Array(currentFrame.size),i=0;currentFrame.data.length;)pes=currentFrame.data.shift(),frame.set(pes,i),i+=pes.byteLength;if(probe.ts.videoPacketContainsKeyFrame(frame)){var firstKeyFrame=probe.ts.parsePesTime(frame);firstKeyFrame?(result.firstKeyFrame=firstKeyFrame,result.firstKeyFrame.type="video"):console.warn("Failed to extract PTS/DTS from PES at first keyframe. This could be an unusual TS segment, or else mux.js did not parse your TS segment correctly. If you know your TS segments do contain PTS/DTS on keyframes please file a bug report! You can try ffprobe to double check for yourself.")}currentFrame.size=0}currentFrame.data.push(packet),currentFrame.size+=packet.byteLength}if(endLoop&&result.firstKeyFrame)break;startIndex+=188,endIndex+=188}for(startIndex=(endIndex=bytes.byteLength)-188,endLoop=!1;startIndex>=0;)if(71!==bytes[startIndex]||71!==bytes[endIndex])startIndex--,endIndex--;else{if(packet=bytes.subarray(startIndex,endIndex),"pes"===probe.ts.parseType(packet,pmt.pid))pesType=probe.ts.parsePesType(packet,pmt.table),pusi=probe.ts.parsePayloadUnitStartIndicator(packet),"video"===pesType&&pusi&&(parsed=probe.ts.parsePesTime(packet))&&(parsed.type="video",result.video.push(parsed),endLoop=!0);if(endLoop)break;startIndex-=188,endIndex-=188}},inspectTs_=function(bytes){var pmt={pid:null,table:null},result={};for(var pid in function(bytes,pmt){for(var packet,startIndex=0,endIndex=188;endIndex<bytes.byteLength;)if(71!==bytes[startIndex]||71!==bytes[endIndex])startIndex++,endIndex++;else{switch(packet=bytes.subarray(startIndex,endIndex),probe.ts.parseType(packet,pmt.pid)){case"pat":pmt.pid=probe.ts.parsePat(packet);break;case"pmt":var table=probe.ts.parsePmt(packet);pmt.table=pmt.table||{},Object.keys(table).forEach((function(key){pmt.table[key]=table[key]}))}startIndex+=188,endIndex+=188}}(bytes,pmt),pmt.table){if(pmt.table.hasOwnProperty(pid))switch(pmt.table[pid]){case streamTypes.H264_STREAM_TYPE:result.video=[],parseVideoPes_(bytes,pmt,result),0===result.video.length&&delete result.video;break;case streamTypes.ADTS_STREAM_TYPE:result.audio=[],parseAudioPes_(bytes,pmt,result),0===result.audio.length&&delete result.audio}}return result},tsInspector_inspect=function(bytes,baseTimestamp){var result;return result=probe.aac.isLikelyAacData(bytes)?function(bytes){for(var packet,endLoop=!1,audioCount=0,sampleRate=null,timestamp=null,frameSize=0,byteIndex=0;bytes.length-byteIndex>=3;){switch(probe.aac.parseType(bytes,byteIndex)){case"timed-metadata":if(bytes.length-byteIndex<10){endLoop=!0;break}if((frameSize=probe.aac.parseId3TagSize(bytes,byteIndex))>bytes.length){endLoop=!0;break}null===timestamp&&(packet=bytes.subarray(byteIndex,byteIndex+frameSize),timestamp=probe.aac.parseAacTimestamp(packet)),byteIndex+=frameSize;break;case"audio":if(bytes.length-byteIndex<7){endLoop=!0;break}if((frameSize=probe.aac.parseAdtsSize(bytes,byteIndex))>bytes.length){endLoop=!0;break}null===sampleRate&&(packet=bytes.subarray(byteIndex,byteIndex+frameSize),sampleRate=probe.aac.parseSampleRate(packet)),audioCount++,byteIndex+=frameSize;break;default:byteIndex++}if(endLoop)return null}if(null===sampleRate||null===timestamp)return null;var audioTimescale=ONE_SECOND_IN_TS/sampleRate;return{audio:[{type:"audio",dts:timestamp,pts:timestamp},{type:"audio",dts:timestamp+1024*audioCount*audioTimescale,pts:timestamp+1024*audioCount*audioTimescale}]}}(bytes):inspectTs_(bytes),result&&(result.audio||result.video)?(function(segmentInfo,baseTimestamp){if(segmentInfo.audio&&segmentInfo.audio.length){var audioBaseTimestamp=baseTimestamp;(void 0===audioBaseTimestamp||isNaN(audioBaseTimestamp))&&(audioBaseTimestamp=segmentInfo.audio[0].dts),segmentInfo.audio.forEach((function(info){info.dts=handleRollover(info.dts,audioBaseTimestamp),info.pts=handleRollover(info.pts,audioBaseTimestamp),info.dtsTime=info.dts/ONE_SECOND_IN_TS,info.ptsTime=info.pts/ONE_SECOND_IN_TS}))}if(segmentInfo.video&&segmentInfo.video.length){var videoBaseTimestamp=baseTimestamp;if((void 0===videoBaseTimestamp||isNaN(videoBaseTimestamp))&&(videoBaseTimestamp=segmentInfo.video[0].dts),segmentInfo.video.forEach((function(info){info.dts=handleRollover(info.dts,videoBaseTimestamp),info.pts=handleRollover(info.pts,videoBaseTimestamp),info.dtsTime=info.dts/ONE_SECOND_IN_TS,info.ptsTime=info.pts/ONE_SECOND_IN_TS})),segmentInfo.firstKeyFrame){var frame=segmentInfo.firstKeyFrame;frame.dts=handleRollover(frame.dts,videoBaseTimestamp),frame.pts=handleRollover(frame.pts,videoBaseTimestamp),frame.dtsTime=frame.dts/ONE_SECOND_IN_TS,frame.ptsTime=frame.pts/ONE_SECOND_IN_TS}}}(result,baseTimestamp),result):null},MessageHandlers=function(){function MessageHandlers(self,options){this.options=options||{},this.self=self,this.init()}var _proto=MessageHandlers.prototype;return _proto.init=function(){this.transmuxer&&this.transmuxer.dispose(),this.transmuxer=new transmuxer.Transmuxer(this.options),function(self,transmuxer){transmuxer.on("data",(function(segment){var initArray=segment.initSegment;segment.initSegment={data:initArray.buffer,byteOffset:initArray.byteOffset,byteLength:initArray.byteLength};var typedArray=segment.data;segment.data=typedArray.buffer,self.postMessage({action:"data",segment:segment,byteOffset:typedArray.byteOffset,byteLength:typedArray.byteLength},[segment.data])})),transmuxer.on("done",(function(data){self.postMessage({action:"done"})})),transmuxer.on("gopInfo",(function(gopInfo){self.postMessage({action:"gopInfo",gopInfo:gopInfo})})),transmuxer.on("videoSegmentTimingInfo",(function(timingInfo){var videoSegmentTimingInfo={start:{decode:clock_videoTsToSeconds$0(timingInfo.start.dts),presentation:clock_videoTsToSeconds$0(timingInfo.start.pts)},end:{decode:clock_videoTsToSeconds$0(timingInfo.end.dts),presentation:clock_videoTsToSeconds$0(timingInfo.end.pts)},baseMediaDecodeTime:clock_videoTsToSeconds$0(timingInfo.baseMediaDecodeTime)};timingInfo.prependedContentDuration&&(videoSegmentTimingInfo.prependedContentDuration=clock_videoTsToSeconds$0(timingInfo.prependedContentDuration)),self.postMessage({action:"videoSegmentTimingInfo",videoSegmentTimingInfo:videoSegmentTimingInfo})})),transmuxer.on("audioSegmentTimingInfo",(function(timingInfo){var audioSegmentTimingInfo={start:{decode:clock_videoTsToSeconds$0(timingInfo.start.dts),presentation:clock_videoTsToSeconds$0(timingInfo.start.pts)},end:{decode:clock_videoTsToSeconds$0(timingInfo.end.dts),presentation:clock_videoTsToSeconds$0(timingInfo.end.pts)},baseMediaDecodeTime:clock_videoTsToSeconds$0(timingInfo.baseMediaDecodeTime)};timingInfo.prependedContentDuration&&(audioSegmentTimingInfo.prependedContentDuration=clock_videoTsToSeconds$0(timingInfo.prependedContentDuration)),self.postMessage({action:"audioSegmentTimingInfo",audioSegmentTimingInfo:audioSegmentTimingInfo})})),transmuxer.on("id3Frame",(function(id3Frame){self.postMessage({action:"id3Frame",id3Frame:id3Frame})})),transmuxer.on("caption",(function(caption){self.postMessage({action:"caption",caption:caption})})),transmuxer.on("trackinfo",(function(trackInfo){self.postMessage({action:"trackinfo",trackInfo:trackInfo})})),transmuxer.on("audioTimingInfo",(function(audioTimingInfo){self.postMessage({action:"audioTimingInfo",audioTimingInfo:{start:clock_videoTsToSeconds$0(audioTimingInfo.start),end:clock_videoTsToSeconds$0(audioTimingInfo.end)}})})),transmuxer.on("videoTimingInfo",(function(videoTimingInfo){self.postMessage({action:"videoTimingInfo",videoTimingInfo:{start:clock_videoTsToSeconds$0(videoTimingInfo.start),end:clock_videoTsToSeconds$0(videoTimingInfo.end)}})})),transmuxer.on("log",(function(log){self.postMessage({action:"log",log:log})}))}(this.self,this.transmuxer)},_proto.pushMp4Captions=function(data){this.captionParser||(this.captionParser=new captionParser,this.captionParser.init());var segment=new Uint8Array(data.data,data.byteOffset,data.byteLength),parsed=this.captionParser.parse(segment,data.trackIds,data.timescales);this.self.postMessage({action:"mp4Captions",captions:parsed&&parsed.captions||[],logs:parsed&&parsed.logs||[],data:segment.buffer},[segment.buffer])},_proto.probeMp4StartTime=function(_ref){var timescales=_ref.timescales,data=_ref.data,startTime=probe$2_startTime(timescales,data);this.self.postMessage({action:"probeMp4StartTime",startTime:startTime,data:data},[data.buffer])},_proto.probeMp4Tracks=function(_ref2){var data=_ref2.data,tracks=probe$2_tracks(data);this.self.postMessage({action:"probeMp4Tracks",tracks:tracks,data:data},[data.buffer])},_proto.probeTs=function(_ref3){var data=_ref3.data,baseStartTime=_ref3.baseStartTime,tsStartTime="number"!=typeof baseStartTime||isNaN(baseStartTime)?void 0:baseStartTime*clock_ONE_SECOND_IN_TS$0,timeInfo=tsInspector_inspect(data,tsStartTime),result=null;timeInfo&&((result={hasVideo:timeInfo.video&&2===timeInfo.video.length||!1,hasAudio:timeInfo.audio&&2===timeInfo.audio.length||!1}).hasVideo&&(result.videoStart=timeInfo.video[0].ptsTime),result.hasAudio&&(result.audioStart=timeInfo.audio[0].ptsTime)),this.self.postMessage({action:"probeTs",result:result,data:data},[data.buffer])},_proto.clearAllMp4Captions=function(){this.captionParser&&this.captionParser.clearAllCaptions()},_proto.clearParsedMp4Captions=function(){this.captionParser&&this.captionParser.clearParsedCaptions()},_proto.push=function(data){var segment=new Uint8Array(data.data,data.byteOffset,data.byteLength);this.transmuxer.push(segment)},_proto.reset=function(){this.transmuxer.reset()},_proto.setTimestampOffset=function(data){var timestampOffset=data.timestampOffset||0;this.transmuxer.setBaseMediaDecodeTime(Math.round(clock_secondsToVideoTs$0(timestampOffset)))},_proto.setAudioAppendStart=function(data){this.transmuxer.setAudioAppendStart(Math.ceil(clock_secondsToVideoTs$0(data.appendStart)))},_proto.setRemux=function(data){this.transmuxer.setRemux(data.remux)},_proto.flush=function(data){this.transmuxer.flush(),self.postMessage({action:"done",type:"transmuxed"})},_proto.endTimeline=function(){this.transmuxer.endTimeline(),self.postMessage({action:"endedtimeline",type:"transmuxed"})},_proto.alignGopsWith=function(data){this.transmuxer.alignGopsWith(data.gopsToAlignWith.slice())},MessageHandlers}();self.onmessage=function(event){"init"===event.data.action&&event.data.options?this.messageHandlers=new MessageHandlers(self,event.data.options):(this.messageHandlers||(this.messageHandlers=new MessageHandlers(self)),event.data&&event.data.action&&"init"!==event.data.action&&this.messageHandlers[event.data.action]&&this.messageHandlers[event.data.action](event.data))}}))),TransmuxWorker=factory(workerCode$1),processTransmux=function(options){var transmuxer=options.transmuxer,bytes=options.bytes,audioAppendStart=options.audioAppendStart,gopsToAlignWith=options.gopsToAlignWith,remux=options.remux,onData=options.onData,onTrackInfo=options.onTrackInfo,onAudioTimingInfo=options.onAudioTimingInfo,onVideoTimingInfo=options.onVideoTimingInfo,onVideoSegmentTimingInfo=options.onVideoSegmentTimingInfo,onAudioSegmentTimingInfo=options.onAudioSegmentTimingInfo,onId3=options.onId3,onCaptions=options.onCaptions,onDone=options.onDone,onEndedTimeline=options.onEndedTimeline,onTransmuxerLog=options.onTransmuxerLog,isEndOfTimeline=options.isEndOfTimeline,transmuxedData={buffer:[]},waitForEndedTimelineEvent=isEndOfTimeline;if(transmuxer.onmessage=function(event){transmuxer.currentTransmux===options&&("data"===event.data.action&&function(event,transmuxedData,callback){var _event$data$segment=event.data.segment,type=_event$data$segment.type,initSegment=_event$data$segment.initSegment,captions=_event$data$segment.captions,captionStreams=_event$data$segment.captionStreams,metadata=_event$data$segment.metadata,videoFrameDtsTime=_event$data$segment.videoFrameDtsTime,videoFramePtsTime=_event$data$segment.videoFramePtsTime;transmuxedData.buffer.push({captions:captions,captionStreams:captionStreams,metadata:metadata});var boxes=event.data.segment.boxes||{data:event.data.segment.data},result={type:type,data:new Uint8Array(boxes.data,boxes.data.byteOffset,boxes.data.byteLength),initSegment:new Uint8Array(initSegment.data,initSegment.byteOffset,initSegment.byteLength)};void 0!==videoFrameDtsTime&&(result.videoFrameDtsTime=videoFrameDtsTime),void 0!==videoFramePtsTime&&(result.videoFramePtsTime=videoFramePtsTime),callback(result)}(event,transmuxedData,onData),"trackinfo"===event.data.action&&onTrackInfo(event.data.trackInfo),"gopInfo"===event.data.action&&function(event,transmuxedData){transmuxedData.gopInfo=event.data.gopInfo}(event,transmuxedData),"audioTimingInfo"===event.data.action&&onAudioTimingInfo(event.data.audioTimingInfo),"videoTimingInfo"===event.data.action&&onVideoTimingInfo(event.data.videoTimingInfo),"videoSegmentTimingInfo"===event.data.action&&onVideoSegmentTimingInfo(event.data.videoSegmentTimingInfo),"audioSegmentTimingInfo"===event.data.action&&onAudioSegmentTimingInfo(event.data.audioSegmentTimingInfo),"id3Frame"===event.data.action&&onId3([event.data.id3Frame],event.data.id3Frame.dispatchType),"caption"===event.data.action&&onCaptions(event.data.caption),"endedtimeline"===event.data.action&&(waitForEndedTimelineEvent=!1,onEndedTimeline()),"log"===event.data.action&&onTransmuxerLog(event.data.log),"transmuxed"===event.data.type&&(waitForEndedTimelineEvent||(transmuxer.onmessage=null,function(_ref){var transmuxedData=_ref.transmuxedData,callback=_ref.callback;transmuxedData.buffer=[],callback(transmuxedData)}({transmuxedData:transmuxedData,callback:onDone}),dequeue(transmuxer))))},audioAppendStart&&transmuxer.postMessage({action:"setAudioAppendStart",appendStart:audioAppendStart}),Array.isArray(gopsToAlignWith)&&transmuxer.postMessage({action:"alignGopsWith",gopsToAlignWith:gopsToAlignWith}),void 0!==remux&&transmuxer.postMessage({action:"setRemux",remux:remux}),bytes.byteLength){var buffer=bytes instanceof ArrayBuffer?bytes:bytes.buffer,byteOffset=bytes instanceof ArrayBuffer?0:bytes.byteOffset;transmuxer.postMessage({action:"push",data:buffer,byteOffset:byteOffset,byteLength:bytes.byteLength},[buffer])}isEndOfTimeline&&transmuxer.postMessage({action:"endTimeline"}),transmuxer.postMessage({action:"flush"})},dequeue=function(transmuxer){transmuxer.currentTransmux=null,transmuxer.transmuxQueue.length&&(transmuxer.currentTransmux=transmuxer.transmuxQueue.shift(),"function"==typeof transmuxer.currentTransmux?transmuxer.currentTransmux():processTransmux(transmuxer.currentTransmux))},processAction=function(transmuxer,action){transmuxer.postMessage({action:action}),dequeue(transmuxer)},enqueueAction=function(action,transmuxer){if(!transmuxer.currentTransmux)return transmuxer.currentTransmux=action,void processAction(transmuxer,action);transmuxer.transmuxQueue.push(processAction.bind(null,transmuxer,action))},transmux=function(options){if(!options.transmuxer.currentTransmux)return options.transmuxer.currentTransmux=options,void processTransmux(options);options.transmuxer.transmuxQueue.push(options)},segmentTransmuxer_reset=function(transmuxer){enqueueAction("reset",transmuxer)},segmentTransmuxer_createTransmuxer=function(options){var transmuxer=new TransmuxWorker;transmuxer.currentTransmux=null,transmuxer.transmuxQueue=[];var term=transmuxer.terminate;return transmuxer.terminate=function(){return transmuxer.currentTransmux=null,transmuxer.transmuxQueue.length=0,term.call(transmuxer)},transmuxer.postMessage({action:"init",options:options}),transmuxer},workerCallback=function(options){var transmuxer=options.transmuxer,endAction=options.endAction||options.action,callback=options.callback,message=_extends_1({},options,{endAction:null,transmuxer:null,callback:null});if(transmuxer.addEventListener("message",(function listenForEndEvent(event){event.data.action===endAction&&(transmuxer.removeEventListener("message",listenForEndEvent),event.data.data&&(event.data.data=new Uint8Array(event.data.data,options.byteOffset||0,options.byteLength||event.data.data.byteLength),options.data&&(options.data=event.data.data)),callback(event.data))})),options.data){var isArrayBuffer=options.data instanceof ArrayBuffer;message.byteOffset=isArrayBuffer?0:options.data.byteOffset,message.byteLength=options.data.byteLength;var transfers=[isArrayBuffer?options.data:options.data.buffer];transmuxer.postMessage(message,transfers)}else transmuxer.postMessage(message)},REQUEST_ERRORS_FAILURE=2,REQUEST_ERRORS_TIMEOUT=-101,REQUEST_ERRORS_ABORTED=-102,abortAll=function(activeXhrs){activeXhrs.forEach((function(xhr){xhr.abort()}))},handleErrors=function(error,request){return request.timedout?{status:request.status,message:"HLS request timed-out at URL: "+request.uri,code:REQUEST_ERRORS_TIMEOUT,xhr:request}:request.aborted?{status:request.status,message:"HLS request aborted at URL: "+request.uri,code:REQUEST_ERRORS_ABORTED,xhr:request}:error?{status:request.status,message:"HLS request errored at URL: "+request.uri,code:REQUEST_ERRORS_FAILURE,xhr:request}:"arraybuffer"===request.responseType&&0===request.response.byteLength?{status:request.status,message:"Empty HLS response at URL: "+request.uri,code:REQUEST_ERRORS_FAILURE,xhr:request}:null},handleKeyResponse=function(segment,objects,finishProcessingFn){return function(error,request){var response=request.response,errorObj=handleErrors(error,request);if(errorObj)return finishProcessingFn(errorObj,segment);if(16!==response.byteLength)return finishProcessingFn({status:request.status,message:"Invalid HLS key at URL: "+request.uri,code:REQUEST_ERRORS_FAILURE,xhr:request},segment);for(var view=new DataView(response),bytes=new Uint32Array([view.getUint32(0),view.getUint32(4),view.getUint32(8),view.getUint32(12)]),i=0;i<objects.length;i++)objects[i].bytes=bytes;return finishProcessingFn(null,segment)}},parseInitSegment=function(segment,_callback){var type=detectContainerForBytes(segment.map.bytes);if("mp4"!==type){var uri=segment.map.resolvedUri||segment.map.uri;return _callback({internal:!0,message:"Found unsupported "+(type||"unknown")+" container for initialization segment at URL: "+uri,code:REQUEST_ERRORS_FAILURE})}workerCallback({action:"probeMp4Tracks",data:segment.map.bytes,transmuxer:segment.transmuxer,callback:function(_ref){var tracks=_ref.tracks,data=_ref.data;return segment.map.bytes=data,tracks.forEach((function(track){segment.map.tracks=segment.map.tracks||{},segment.map.tracks[track.type]||(segment.map.tracks[track.type]=track,"number"==typeof track.id&&track.timescale&&(segment.map.timescales=segment.map.timescales||{},segment.map.timescales[track.id]=track.timescale))})),_callback(null)}})},handleSegmentResponse=function(_ref3){var segment=_ref3.segment,finishProcessingFn=_ref3.finishProcessingFn,responseType=_ref3.responseType;return function(error,request){var errorObj=handleErrors(error,request);if(errorObj)return finishProcessingFn(errorObj,segment);var newBytes="arraybuffer"!==responseType&&request.responseText?function(string){for(var view=new Uint8Array(new ArrayBuffer(string.length)),i=0;i<string.length;i++)view[i]=string.charCodeAt(i);return view.buffer}(request.responseText.substring(segment.lastReachedChar||0)):request.response;return segment.stats=function(request){return{bandwidth:request.bandwidth,bytesReceived:request.bytesReceived||0,roundTripTime:request.roundTripTime||0}}(request),segment.key?segment.encryptedBytes=new Uint8Array(newBytes):segment.bytes=new Uint8Array(newBytes),finishProcessingFn(null,segment)}},transmuxAndNotify=function(_ref4){var segment=_ref4.segment,bytes=_ref4.bytes,trackInfoFn=_ref4.trackInfoFn,timingInfoFn=_ref4.timingInfoFn,videoSegmentTimingInfoFn=_ref4.videoSegmentTimingInfoFn,audioSegmentTimingInfoFn=_ref4.audioSegmentTimingInfoFn,id3Fn=_ref4.id3Fn,captionsFn=_ref4.captionsFn,isEndOfTimeline=_ref4.isEndOfTimeline,endedTimelineFn=_ref4.endedTimelineFn,dataFn=_ref4.dataFn,doneFn=_ref4.doneFn,onTransmuxerLog=_ref4.onTransmuxerLog,fmp4Tracks=segment.map&&segment.map.tracks||{},isMuxed=Boolean(fmp4Tracks.audio&&fmp4Tracks.video),audioStartFn=timingInfoFn.bind(null,segment,"audio","start"),audioEndFn=timingInfoFn.bind(null,segment,"audio","end"),videoStartFn=timingInfoFn.bind(null,segment,"video","start"),videoEndFn=timingInfoFn.bind(null,segment,"video","end");workerCallback({action:"probeTs",transmuxer:segment.transmuxer,data:bytes,baseStartTime:segment.baseStartTime,callback:function(data){segment.bytes=bytes=data.data;var probeResult=data.result;probeResult&&(trackInfoFn(segment,{hasAudio:probeResult.hasAudio,hasVideo:probeResult.hasVideo,isMuxed:isMuxed}),trackInfoFn=null,probeResult.hasAudio&&!isMuxed&&audioStartFn(probeResult.audioStart),probeResult.hasVideo&&videoStartFn(probeResult.videoStart),audioStartFn=null,videoStartFn=null),transmux({bytes:bytes,transmuxer:segment.transmuxer,audioAppendStart:segment.audioAppendStart,gopsToAlignWith:segment.gopsToAlignWith,remux:isMuxed,onData:function(result){result.type="combined"===result.type?"video":result.type,dataFn(segment,result)},onTrackInfo:function(trackInfo){trackInfoFn&&(isMuxed&&(trackInfo.isMuxed=!0),trackInfoFn(segment,trackInfo))},onAudioTimingInfo:function(audioTimingInfo){audioStartFn&&void 0!==audioTimingInfo.start&&(audioStartFn(audioTimingInfo.start),audioStartFn=null),audioEndFn&&void 0!==audioTimingInfo.end&&audioEndFn(audioTimingInfo.end)},onVideoTimingInfo:function(videoTimingInfo){videoStartFn&&void 0!==videoTimingInfo.start&&(videoStartFn(videoTimingInfo.start),videoStartFn=null),videoEndFn&&void 0!==videoTimingInfo.end&&videoEndFn(videoTimingInfo.end)},onVideoSegmentTimingInfo:function(videoSegmentTimingInfo){videoSegmentTimingInfoFn(videoSegmentTimingInfo)},onAudioSegmentTimingInfo:function(audioSegmentTimingInfo){audioSegmentTimingInfoFn(audioSegmentTimingInfo)},onId3:function(id3Frames,dispatchType){id3Fn(segment,id3Frames,dispatchType)},onCaptions:function(captions){captionsFn(segment,[captions])},isEndOfTimeline:isEndOfTimeline,onEndedTimeline:function(){endedTimelineFn()},onTransmuxerLog:onTransmuxerLog,onDone:function(result){doneFn&&(result.type="combined"===result.type?"video":result.type,doneFn(null,segment,result))}})}})},handleSegmentBytes=function(_ref5){var segment=_ref5.segment,bytes=_ref5.bytes,trackInfoFn=_ref5.trackInfoFn,timingInfoFn=_ref5.timingInfoFn,videoSegmentTimingInfoFn=_ref5.videoSegmentTimingInfoFn,audioSegmentTimingInfoFn=_ref5.audioSegmentTimingInfoFn,id3Fn=_ref5.id3Fn,captionsFn=_ref5.captionsFn,isEndOfTimeline=_ref5.isEndOfTimeline,endedTimelineFn=_ref5.endedTimelineFn,dataFn=_ref5.dataFn,doneFn=_ref5.doneFn,onTransmuxerLog=_ref5.onTransmuxerLog,bytesAsUint8Array=new Uint8Array(bytes);if(function(bytes){return findBox(bytes,["moof"]).length>0}(bytesAsUint8Array)){segment.isFmp4=!0;var tracks=segment.map.tracks,trackInfo={isFmp4:!0,hasVideo:!!tracks.video,hasAudio:!!tracks.audio};tracks.audio&&tracks.audio.codec&&"enca"!==tracks.audio.codec&&(trackInfo.audioCodec=tracks.audio.codec),tracks.video&&tracks.video.codec&&"encv"!==tracks.video.codec&&(trackInfo.videoCodec=tracks.video.codec),tracks.video&&tracks.audio&&(trackInfo.isMuxed=!0),trackInfoFn(segment,trackInfo);var finishLoading=function(captions){dataFn(segment,{data:bytesAsUint8Array,type:trackInfo.hasAudio&&!trackInfo.isMuxed?"audio":"video"}),captions&&captions.length&&captionsFn(segment,captions),doneFn(null,segment,{})};workerCallback({action:"probeMp4StartTime",timescales:segment.map.timescales,data:bytesAsUint8Array,transmuxer:segment.transmuxer,callback:function(_ref6){var data=_ref6.data,startTime=_ref6.startTime;bytes=data.buffer,segment.bytes=bytesAsUint8Array=data,trackInfo.hasAudio&&!trackInfo.isMuxed&&timingInfoFn(segment,"audio","start",startTime),trackInfo.hasVideo&&timingInfoFn(segment,"video","start",startTime),tracks.video&&data.byteLength&&segment.transmuxer?workerCallback({action:"pushMp4Captions",endAction:"mp4Captions",transmuxer:segment.transmuxer,data:bytesAsUint8Array,timescales:segment.map.timescales,trackIds:[tracks.video.id],callback:function(message){bytes=message.data.buffer,segment.bytes=bytesAsUint8Array=message.data,message.logs.forEach((function(log){onTransmuxerLog(videojs.mergeOptions(log,{stream:"mp4CaptionParser"}))})),finishLoading(message.captions)}}):finishLoading()}})}else if(segment.transmuxer){if(void 0===segment.container&&(segment.container=detectContainerForBytes(bytesAsUint8Array)),"ts"!==segment.container&&"aac"!==segment.container)return trackInfoFn(segment,{hasAudio:!1,hasVideo:!1}),void doneFn(null,segment,{});transmuxAndNotify({segment:segment,bytes:bytes,trackInfoFn:trackInfoFn,timingInfoFn:timingInfoFn,videoSegmentTimingInfoFn:videoSegmentTimingInfoFn,audioSegmentTimingInfoFn:audioSegmentTimingInfoFn,id3Fn:id3Fn,captionsFn:captionsFn,isEndOfTimeline:isEndOfTimeline,endedTimelineFn:endedTimelineFn,dataFn:dataFn,doneFn:doneFn,onTransmuxerLog:onTransmuxerLog})}else doneFn(null,segment,{})},decrypt=function(_ref7,callback){var keyBytes,id=_ref7.id,key=_ref7.key,encryptedBytes=_ref7.encryptedBytes,decryptionWorker=_ref7.decryptionWorker;decryptionWorker.addEventListener("message",(function decryptionHandler(event){if(event.data.source===id){decryptionWorker.removeEventListener("message",decryptionHandler);var decrypted=event.data.decrypted;callback(new Uint8Array(decrypted.bytes,decrypted.byteOffset,decrypted.byteLength))}})),keyBytes=key.bytes.slice?key.bytes.slice():new Uint32Array(Array.prototype.slice.call(key.bytes)),decryptionWorker.postMessage(createTransferableMessage({source:id,encrypted:encryptedBytes,key:keyBytes,iv:key.iv}),[encryptedBytes.buffer,keyBytes.buffer])},waitForCompletion=function(_ref9){var activeXhrs=_ref9.activeXhrs,decryptionWorker=_ref9.decryptionWorker,trackInfoFn=_ref9.trackInfoFn,timingInfoFn=_ref9.timingInfoFn,videoSegmentTimingInfoFn=_ref9.videoSegmentTimingInfoFn,audioSegmentTimingInfoFn=_ref9.audioSegmentTimingInfoFn,id3Fn=_ref9.id3Fn,captionsFn=_ref9.captionsFn,isEndOfTimeline=_ref9.isEndOfTimeline,endedTimelineFn=_ref9.endedTimelineFn,dataFn=_ref9.dataFn,doneFn=_ref9.doneFn,onTransmuxerLog=_ref9.onTransmuxerLog,count=0,didError=!1;return function(error,segment){if(!didError){if(error)return didError=!0,abortAll(activeXhrs),doneFn(error,segment);if((count+=1)===activeXhrs.length){var segmentFinish=function(){if(segment.encryptedBytes)return function(_ref8){var decryptionWorker=_ref8.decryptionWorker,segment=_ref8.segment,trackInfoFn=_ref8.trackInfoFn,timingInfoFn=_ref8.timingInfoFn,videoSegmentTimingInfoFn=_ref8.videoSegmentTimingInfoFn,audioSegmentTimingInfoFn=_ref8.audioSegmentTimingInfoFn,id3Fn=_ref8.id3Fn,captionsFn=_ref8.captionsFn,isEndOfTimeline=_ref8.isEndOfTimeline,endedTimelineFn=_ref8.endedTimelineFn,dataFn=_ref8.dataFn,doneFn=_ref8.doneFn,onTransmuxerLog=_ref8.onTransmuxerLog;decrypt({id:segment.requestId,key:segment.key,encryptedBytes:segment.encryptedBytes,decryptionWorker:decryptionWorker},(function(decryptedBytes){segment.bytes=decryptedBytes,handleSegmentBytes({segment:segment,bytes:segment.bytes,trackInfoFn:trackInfoFn,timingInfoFn:timingInfoFn,videoSegmentTimingInfoFn:videoSegmentTimingInfoFn,audioSegmentTimingInfoFn:audioSegmentTimingInfoFn,id3Fn:id3Fn,captionsFn:captionsFn,isEndOfTimeline:isEndOfTimeline,endedTimelineFn:endedTimelineFn,dataFn:dataFn,doneFn:doneFn,onTransmuxerLog:onTransmuxerLog})}))}({decryptionWorker:decryptionWorker,segment:segment,trackInfoFn:trackInfoFn,timingInfoFn:timingInfoFn,videoSegmentTimingInfoFn:videoSegmentTimingInfoFn,audioSegmentTimingInfoFn:audioSegmentTimingInfoFn,id3Fn:id3Fn,captionsFn:captionsFn,isEndOfTimeline:isEndOfTimeline,endedTimelineFn:endedTimelineFn,dataFn:dataFn,doneFn:doneFn,onTransmuxerLog:onTransmuxerLog});handleSegmentBytes({segment:segment,bytes:segment.bytes,trackInfoFn:trackInfoFn,timingInfoFn:timingInfoFn,videoSegmentTimingInfoFn:videoSegmentTimingInfoFn,audioSegmentTimingInfoFn:audioSegmentTimingInfoFn,id3Fn:id3Fn,captionsFn:captionsFn,isEndOfTimeline:isEndOfTimeline,endedTimelineFn:endedTimelineFn,dataFn:dataFn,doneFn:doneFn,onTransmuxerLog:onTransmuxerLog})};if(segment.endOfAllRequests=Date.now(),segment.map&&segment.map.encryptedBytes&&!segment.map.bytes)return decrypt({decryptionWorker:decryptionWorker,id:segment.requestId+"-init",encryptedBytes:segment.map.encryptedBytes,key:segment.map.key},(function(decryptedBytes){segment.map.bytes=decryptedBytes,parseInitSegment(segment,(function(parseError){if(parseError)return abortAll(activeXhrs),doneFn(parseError,segment);segmentFinish()}))}));segmentFinish()}}}},handleProgress=function(_ref11){var segment=_ref11.segment,progressFn=_ref11.progressFn;return _ref11.trackInfoFn,_ref11.timingInfoFn,_ref11.videoSegmentTimingInfoFn,_ref11.audioSegmentTimingInfoFn,_ref11.id3Fn,_ref11.captionsFn,_ref11.isEndOfTimeline,_ref11.endedTimelineFn,_ref11.dataFn,function(event){if(!event.target.aborted)return segment.stats=videojs.mergeOptions(segment.stats,function(progressEvent){var request=progressEvent.target,stats={bandwidth:1/0,bytesReceived:0,roundTripTime:Date.now()-request.requestTime||0};return stats.bytesReceived=progressEvent.loaded,stats.bandwidth=Math.floor(stats.bytesReceived/stats.roundTripTime*8*1e3),stats}(event)),!segment.stats.firstBytesReceivedAt&&segment.stats.bytesReceived&&(segment.stats.firstBytesReceivedAt=Date.now()),progressFn(event,segment)}},mediaSegmentRequest=function(_ref12){var xhr=_ref12.xhr,xhrOptions=_ref12.xhrOptions,decryptionWorker=_ref12.decryptionWorker,segment=_ref12.segment,abortFn=_ref12.abortFn,progressFn=_ref12.progressFn,trackInfoFn=_ref12.trackInfoFn,timingInfoFn=_ref12.timingInfoFn,videoSegmentTimingInfoFn=_ref12.videoSegmentTimingInfoFn,audioSegmentTimingInfoFn=_ref12.audioSegmentTimingInfoFn,id3Fn=_ref12.id3Fn,captionsFn=_ref12.captionsFn,isEndOfTimeline=_ref12.isEndOfTimeline,endedTimelineFn=_ref12.endedTimelineFn,dataFn=_ref12.dataFn,doneFn=_ref12.doneFn,onTransmuxerLog=_ref12.onTransmuxerLog,activeXhrs=[],finishProcessingFn=waitForCompletion({activeXhrs:activeXhrs,decryptionWorker:decryptionWorker,trackInfoFn:trackInfoFn,timingInfoFn:timingInfoFn,videoSegmentTimingInfoFn:videoSegmentTimingInfoFn,audioSegmentTimingInfoFn:audioSegmentTimingInfoFn,id3Fn:id3Fn,captionsFn:captionsFn,isEndOfTimeline:isEndOfTimeline,endedTimelineFn:endedTimelineFn,dataFn:dataFn,doneFn:doneFn,onTransmuxerLog:onTransmuxerLog});if(segment.key&&!segment.key.bytes){var objects=[segment.key];segment.map&&!segment.map.bytes&&segment.map.key&&segment.map.key.resolvedUri===segment.key.resolvedUri&&objects.push(segment.map.key);var keyXhr=xhr(videojs.mergeOptions(xhrOptions,{uri:segment.key.resolvedUri,responseType:"arraybuffer"}),handleKeyResponse(segment,objects,finishProcessingFn));activeXhrs.push(keyXhr)}if(segment.map&&!segment.map.bytes){if(segment.map.key&&(!segment.key||segment.key.resolvedUri!==segment.map.key.resolvedUri)){var mapKeyXhr=xhr(videojs.mergeOptions(xhrOptions,{uri:segment.map.key.resolvedUri,responseType:"arraybuffer"}),handleKeyResponse(segment,[segment.map.key],finishProcessingFn));activeXhrs.push(mapKeyXhr)}var initSegmentOptions=videojs.mergeOptions(xhrOptions,{uri:segment.map.resolvedUri,responseType:"arraybuffer",headers:segmentXhrHeaders(segment.map)}),initSegmentRequestCallback=function(_ref2){var segment=_ref2.segment,finishProcessingFn=_ref2.finishProcessingFn;return function(error,request){var errorObj=handleErrors(error,request);if(errorObj)return finishProcessingFn(errorObj,segment);var bytes=new Uint8Array(request.response);if(segment.map.key)return segment.map.encryptedBytes=bytes,finishProcessingFn(null,segment);segment.map.bytes=bytes,parseInitSegment(segment,(function(parseError){if(parseError)return parseError.xhr=request,parseError.status=request.status,finishProcessingFn(parseError,segment);finishProcessingFn(null,segment)}))}}({segment:segment,finishProcessingFn:finishProcessingFn}),initSegmentXhr=xhr(initSegmentOptions,initSegmentRequestCallback);activeXhrs.push(initSegmentXhr)}var segmentRequestOptions=videojs.mergeOptions(xhrOptions,{uri:segment.part&&segment.part.resolvedUri||segment.resolvedUri,responseType:"arraybuffer",headers:segmentXhrHeaders(segment)}),segmentXhr=xhr(segmentRequestOptions,handleSegmentResponse({segment:segment,finishProcessingFn:finishProcessingFn,responseType:segmentRequestOptions.responseType}));segmentXhr.addEventListener("progress",handleProgress({segment:segment,progressFn:progressFn,trackInfoFn:trackInfoFn,timingInfoFn:timingInfoFn,videoSegmentTimingInfoFn:videoSegmentTimingInfoFn,audioSegmentTimingInfoFn:audioSegmentTimingInfoFn,id3Fn:id3Fn,captionsFn:captionsFn,isEndOfTimeline:isEndOfTimeline,endedTimelineFn:endedTimelineFn,dataFn:dataFn})),activeXhrs.push(segmentXhr);var loadendState={};return activeXhrs.forEach((function(activeXhr){activeXhr.addEventListener("loadend",function(_ref10){var loadendState=_ref10.loadendState,abortFn=_ref10.abortFn;return function(event){event.target.aborted&&abortFn&&!loadendState.calledAbortFn&&(abortFn(),loadendState.calledAbortFn=!0)}}({loadendState:loadendState,abortFn:abortFn}))})),function(){return abortAll(activeXhrs)}},logFn$1=logger("CodecUtils"),isMaat=function(master,media){var mediaAttributes=media.attributes||{};return master&&master.mediaGroups&&master.mediaGroups.AUDIO&&mediaAttributes.AUDIO&&master.mediaGroups.AUDIO[mediaAttributes.AUDIO]},unwrapCodecList=function(codecList){var codecs={};return codecList.forEach((function(_ref){var mediaType=_ref.mediaType,type=_ref.type,details=_ref.details;codecs[mediaType]=codecs[mediaType]||[],codecs[mediaType].push(translateLegacyCodec(""+type+details))})),Object.keys(codecs).forEach((function(mediaType){if(codecs[mediaType].length>1)return logFn$1("multiple "+mediaType+" codecs found as attributes: "+codecs[mediaType].join(", ")+". Setting playlist codecs to null so that we wait for mux.js to probe segments for real codecs."),void(codecs[mediaType]=null);codecs[mediaType]=codecs[mediaType][0]})),codecs},codecCount=function(codecObj){var count=0;return codecObj.audio&&count++,codecObj.video&&count++,count},codecsForPlaylist=function(master,media){var mediaAttributes=media.attributes||{},codecInfo=unwrapCodecList(function(media){var mediaAttributes=media.attributes||{};if(mediaAttributes.CODECS)return parseCodecs(mediaAttributes.CODECS)}(media)||[]);if(isMaat(master,media)&&!codecInfo.audio&&!function(master,media){if(!isMaat(master,media))return!0;var mediaAttributes=media.attributes||{},audioGroup=master.mediaGroups.AUDIO[mediaAttributes.AUDIO];for(var groupId in audioGroup)if(!audioGroup[groupId].uri&&!audioGroup[groupId].playlists)return!0;return!1}(master,media)){var defaultCodecs=unwrapCodecList(function(master,audioGroupId){if(!master.mediaGroups.AUDIO||!audioGroupId)return null;var audioGroup=master.mediaGroups.AUDIO[audioGroupId];if(!audioGroup)return null;for(var name in audioGroup){var audioType=audioGroup[name];if(audioType.default&&audioType.playlists)return parseCodecs(audioType.playlists[0].attributes.CODECS)}return null}(master,mediaAttributes.AUDIO)||[]);defaultCodecs.audio&&(codecInfo.audio=defaultCodecs.audio)}return codecInfo},logFn=logger("PlaylistSelector"),representationToString=function(representation){if(representation&&representation.playlist){var playlist=representation.playlist;return JSON.stringify({id:playlist.id,bandwidth:representation.bandwidth,width:representation.width,height:representation.height,codecs:playlist.attributes&&playlist.attributes.CODECS||""})}},safeGetComputedStyle=function(el,property){if(!el)return"";var result=window.getComputedStyle(el);return result?result[property]:""},stableSort=function(array,sortFn){var newArray=array.slice();array.sort((function(left,right){var cmp=sortFn(left,right);return 0===cmp?newArray.indexOf(left)-newArray.indexOf(right):cmp}))},comparePlaylistBandwidth=function(left,right){var leftBandwidth,rightBandwidth;return left.attributes.BANDWIDTH&&(leftBandwidth=left.attributes.BANDWIDTH),leftBandwidth=leftBandwidth||window.Number.MAX_VALUE,right.attributes.BANDWIDTH&&(rightBandwidth=right.attributes.BANDWIDTH),leftBandwidth-(rightBandwidth=rightBandwidth||window.Number.MAX_VALUE)},simpleSelector=function(master,playerBandwidth,playerWidth,playerHeight,limitRenditionByPlayerDimensions,masterPlaylistController){if(master){var options={bandwidth:playerBandwidth,width:playerWidth,height:playerHeight,limitRenditionByPlayerDimensions:limitRenditionByPlayerDimensions},playlists=master.playlists;Playlist.isAudioOnly(master)&&(playlists=masterPlaylistController.getAudioTrackPlaylists_(),options.audioOnly=!0);var sortedPlaylistReps=playlists.map((function(playlist){var width=playlist.attributes&&playlist.attributes.RESOLUTION&&playlist.attributes.RESOLUTION.width,height=playlist.attributes&&playlist.attributes.RESOLUTION&&playlist.attributes.RESOLUTION.height;return{bandwidth:playlist.attributes&&playlist.attributes.BANDWIDTH||window.Number.MAX_VALUE,width:width,height:height,playlist:playlist}}));stableSort(sortedPlaylistReps,(function(left,right){return left.bandwidth-right.bandwidth}));var enabledPlaylistReps=(sortedPlaylistReps=sortedPlaylistReps.filter((function(rep){return!Playlist.isIncompatible(rep.playlist)}))).filter((function(rep){return Playlist.isEnabled(rep.playlist)}));enabledPlaylistReps.length||(enabledPlaylistReps=sortedPlaylistReps.filter((function(rep){return!Playlist.isDisabled(rep.playlist)})));var bandwidthPlaylistReps=enabledPlaylistReps.filter((function(rep){return rep.bandwidth*Config.BANDWIDTH_VARIANCE<playerBandwidth})),highestRemainingBandwidthRep=bandwidthPlaylistReps[bandwidthPlaylistReps.length-1],bandwidthBestRep=bandwidthPlaylistReps.filter((function(rep){return rep.bandwidth===highestRemainingBandwidthRep.bandwidth}))[0];if(!1===limitRenditionByPlayerDimensions){var _chosenRep=bandwidthBestRep||enabledPlaylistReps[0]||sortedPlaylistReps[0];if(_chosenRep&&_chosenRep.playlist){var type="sortedPlaylistReps";return bandwidthBestRep&&(type="bandwidthBestRep"),enabledPlaylistReps[0]&&(type="enabledPlaylistReps"),logFn("choosing "+representationToString(_chosenRep)+" using "+type+" with options",options),_chosenRep.playlist}return logFn("could not choose a playlist with options",options),null}var haveResolution=bandwidthPlaylistReps.filter((function(rep){return rep.width&&rep.height}));stableSort(haveResolution,(function(left,right){return left.width-right.width}));var resolutionBestRepList=haveResolution.filter((function(rep){return rep.width===playerWidth&&rep.height===playerHeight}));highestRemainingBandwidthRep=resolutionBestRepList[resolutionBestRepList.length-1];var resolutionPlusOneList,resolutionPlusOneSmallest,resolutionPlusOneRep,leastPixelDiffRep,resolutionBestRep=resolutionBestRepList.filter((function(rep){return rep.bandwidth===highestRemainingBandwidthRep.bandwidth}))[0];if(resolutionBestRep||(resolutionPlusOneSmallest=(resolutionPlusOneList=haveResolution.filter((function(rep){return rep.width>playerWidth||rep.height>playerHeight}))).filter((function(rep){return rep.width===resolutionPlusOneList[0].width&&rep.height===resolutionPlusOneList[0].height})),highestRemainingBandwidthRep=resolutionPlusOneSmallest[resolutionPlusOneSmallest.length-1],resolutionPlusOneRep=resolutionPlusOneSmallest.filter((function(rep){return rep.bandwidth===highestRemainingBandwidthRep.bandwidth}))[0]),masterPlaylistController.experimentalLeastPixelDiffSelector){var leastPixelDiffList=haveResolution.map((function(rep){return rep.pixelDiff=Math.abs(rep.width-playerWidth)+Math.abs(rep.height-playerHeight),rep}));stableSort(leastPixelDiffList,(function(left,right){return left.pixelDiff===right.pixelDiff?right.bandwidth-left.bandwidth:left.pixelDiff-right.pixelDiff})),leastPixelDiffRep=leastPixelDiffList[0]}var chosenRep=leastPixelDiffRep||resolutionPlusOneRep||resolutionBestRep||bandwidthBestRep||enabledPlaylistReps[0]||sortedPlaylistReps[0];if(chosenRep&&chosenRep.playlist){var _type="sortedPlaylistReps";return leastPixelDiffRep?_type="leastPixelDiffRep":resolutionPlusOneRep?_type="resolutionPlusOneRep":resolutionBestRep?_type="resolutionBestRep":bandwidthBestRep?_type="bandwidthBestRep":enabledPlaylistReps[0]&&(_type="enabledPlaylistReps"),logFn("choosing "+representationToString(chosenRep)+" using "+_type+" with options",options),chosenRep.playlist}return logFn("could not choose a playlist with options",options),null}},lastBandwidthSelector=function(){var pixelRatio=this.useDevicePixelRatio&&window.devicePixelRatio||1;return simpleSelector(this.playlists.master,this.systemBandwidth,parseInt(safeGetComputedStyle(this.tech_.el(),"width"),10)*pixelRatio,parseInt(safeGetComputedStyle(this.tech_.el(),"height"),10)*pixelRatio,this.limitRenditionByPlayerDimensions,this.masterPlaylistController_)},addMetadata=function(_ref2){var inbandTextTracks=_ref2.inbandTextTracks,metadataArray=_ref2.metadataArray,timestampOffset=_ref2.timestampOffset,videoDuration=_ref2.videoDuration;if(metadataArray){var Cue=window.WebKitDataCue||window.VTTCue,metadataTrack=inbandTextTracks.metadataTrack_;if(metadataTrack&&(metadataArray.forEach((function(metadata){var time=metadata.cueTime+timestampOffset;!("number"!=typeof time||window.isNaN(time)||time<0)&&time<1/0&&metadata.frames.forEach((function(frame){var cue=new Cue(time,time,frame.value||frame.url||frame.data||"");cue.frame=frame,cue.value=frame,function(cue){Object.defineProperties(cue.frame,{id:{get:function(){return videojs.log.warn("cue.frame.id is deprecated. Use cue.value.key instead."),cue.value.key}},value:{get:function(){return videojs.log.warn("cue.frame.value is deprecated. Use cue.value.data instead."),cue.value.data}},privateData:{get:function(){return videojs.log.warn("cue.frame.privateData is deprecated. Use cue.value.data instead."),cue.value.data}}})}(cue),metadataTrack.addCue(cue)}))})),metadataTrack.cues&&metadataTrack.cues.length)){for(var cues=metadataTrack.cues,cuesArray=[],i=0;i<cues.length;i++)cues[i]&&cuesArray.push(cues[i]);var cuesGroupedByStartTime=cuesArray.reduce((function(obj,cue){var timeSlot=obj[cue.startTime]||[];return timeSlot.push(cue),obj[cue.startTime]=timeSlot,obj}),{}),sortedStartTimes=Object.keys(cuesGroupedByStartTime).sort((function(a,b){return Number(a)-Number(b)}));sortedStartTimes.forEach((function(startTime,idx){var cueGroup=cuesGroupedByStartTime[startTime],nextTime=Number(sortedStartTimes[idx+1])||videoDuration;cueGroup.forEach((function(cue){cue.endTime=nextTime}))}))}}},removeCuesFromTrack=function(start,end,track){var i,cue;if(track&&track.cues)for(i=track.cues.length;i--;)(cue=track.cues[i]).startTime>=start&&cue.endTime<=end&&track.removeCue(cue)},finite=function(num){return"number"==typeof num&&isFinite(num)},segmentInfoString=function(segmentInfo){var startOfSegment=segmentInfo.startOfSegment,duration=segmentInfo.duration,segment=segmentInfo.segment,part=segmentInfo.part,_segmentInfo$playlist=segmentInfo.playlist,seq=_segmentInfo$playlist.mediaSequence,id=_segmentInfo$playlist.id,_segmentInfo$playlist2=_segmentInfo$playlist.segments,segments=void 0===_segmentInfo$playlist2?[]:_segmentInfo$playlist2,index=segmentInfo.mediaIndex,partIndex=segmentInfo.partIndex,timeline=segmentInfo.timeline,segmentLen=segments.length-1,selection="mediaIndex/partIndex increment";segmentInfo.getMediaInfoForTime?selection="getMediaInfoForTime ("+segmentInfo.getMediaInfoForTime+")":segmentInfo.isSyncRequest&&(selection="getSyncSegmentCandidate (isSyncRequest)"),segmentInfo.independent&&(selection+=" with independent "+segmentInfo.independent);var hasPartIndex="number"==typeof partIndex,name=segmentInfo.segment.uri?"segment":"pre-segment",zeroBasedPartCount=hasPartIndex?getKnownPartCount({preloadSegment:segment})-1:0;return name+" ["+(seq+index)+"/"+(seq+segmentLen)+"]"+(hasPartIndex?" part ["+partIndex+"/"+zeroBasedPartCount+"]":"")+" segment start/end ["+segment.start+" => "+segment.end+"]"+(hasPartIndex?" part start/end ["+part.start+" => "+part.end+"]":"")+" startOfSegment ["+startOfSegment+"] duration ["+duration+"] timeline ["+timeline+"] selected by ["+selection+"] playlist ["+id+"]"},timingInfoPropertyForMedia=function(mediaType){return mediaType+"TimingInfo"},shouldWaitForTimelineChange=function(_ref2){var timelineChangeController=_ref2.timelineChangeController,currentTimeline=_ref2.currentTimeline,segmentTimeline=_ref2.segmentTimeline,loaderType=_ref2.loaderType,audioDisabled=_ref2.audioDisabled;if(currentTimeline===segmentTimeline)return!1;if("audio"===loaderType){var lastMainTimelineChange=timelineChangeController.lastTimelineChange({type:"main"});return!lastMainTimelineChange||lastMainTimelineChange.to!==segmentTimeline}if("main"===loaderType&&audioDisabled){var pendingAudioTimelineChange=timelineChangeController.pendingTimelineChange({type:"audio"});return!pendingAudioTimelineChange||pendingAudioTimelineChange.to!==segmentTimeline}return!1},segmentTooLong=function(_ref3){var segmentDuration=_ref3.segmentDuration,maxDuration=_ref3.maxDuration;return!!segmentDuration&&Math.round(segmentDuration)>maxDuration+.03333333333333333},getTroublesomeSegmentDurationMessage=function(segmentInfo,sourceType){if("hls"!==sourceType)return null;var audioTimingInfo,videoTimingInfo,audioDuration,videoDuration,segmentDuration=(audioTimingInfo=segmentInfo.audioTimingInfo,videoTimingInfo=segmentInfo.videoTimingInfo,audioDuration=audioTimingInfo&&"number"==typeof audioTimingInfo.start&&"number"==typeof audioTimingInfo.end?audioTimingInfo.end-audioTimingInfo.start:0,videoDuration=videoTimingInfo&&"number"==typeof videoTimingInfo.start&&"number"==typeof videoTimingInfo.end?videoTimingInfo.end-videoTimingInfo.start:0,Math.max(audioDuration,videoDuration));if(!segmentDuration)return null;var targetDuration=segmentInfo.playlist.targetDuration,isSegmentWayTooLong=segmentTooLong({segmentDuration:segmentDuration,maxDuration:2*targetDuration}),isSegmentSlightlyTooLong=segmentTooLong({segmentDuration:segmentDuration,maxDuration:targetDuration}),segmentTooLongMessage="Segment with index "+segmentInfo.mediaIndex+" from playlist "+segmentInfo.playlist.id+" has a duration of "+segmentDuration+" when the reported duration is "+segmentInfo.duration+" and the target duration is "+targetDuration+". For HLS content, a duration in excess of the target duration may result in playback issues. See the HLS specification section on EXT-X-TARGETDURATION for more details: https://tools.ietf.org/html/draft-pantos-http-live-streaming-23#section-4.3.3.1";return isSegmentWayTooLong||isSegmentSlightlyTooLong?{severity:isSegmentWayTooLong?"warn":"info",message:segmentTooLongMessage}:null},SegmentLoader=function(_videojs$EventTarget){function SegmentLoader(settings,options){var _this;if(_this=_videojs$EventTarget.call(this)||this,!settings)throw new TypeError("Initialization settings are required");if("function"!=typeof settings.currentTime)throw new TypeError("No currentTime getter specified");if(!settings.mediaSource)throw new TypeError("No MediaSource specified");return _this.bandwidth=settings.bandwidth,_this.throughput={rate:0,count:0},_this.roundTrip=NaN,_this.resetStats_(),_this.mediaIndex=null,_this.partIndex=null,_this.hasPlayed_=settings.hasPlayed,_this.currentTime_=settings.currentTime,_this.seekable_=settings.seekable,_this.seeking_=settings.seeking,_this.duration_=settings.duration,_this.mediaSource_=settings.mediaSource,_this.vhs_=settings.vhs,_this.loaderType_=settings.loaderType,_this.currentMediaInfo_=void 0,_this.startingMediaInfo_=void 0,_this.segmentMetadataTrack_=settings.segmentMetadataTrack,_this.goalBufferLength_=settings.goalBufferLength,_this.sourceType_=settings.sourceType,_this.sourceUpdater_=settings.sourceUpdater,_this.inbandTextTracks_=settings.inbandTextTracks,_this.state_="INIT",_this.timelineChangeController_=settings.timelineChangeController,_this.shouldSaveSegmentTimingInfo_=!0,_this.parse708captions_=settings.parse708captions,_this.captionServices_=settings.captionServices,_this.experimentalExactManifestTimings=settings.experimentalExactManifestTimings,_this.checkBufferTimeout_=null,_this.error_=void 0,_this.currentTimeline_=-1,_this.pendingSegment_=null,_this.xhrOptions_=null,_this.pendingSegments_=[],_this.audioDisabled_=!1,_this.isPendingTimestampOffset_=!1,_this.gopBuffer_=[],_this.timeMapping_=0,_this.safeAppend_=videojs.browser.IE_VERSION>=11,_this.appendInitSegment_={audio:!0,video:!0},_this.playlistOfLastInitSegment_={audio:null,video:null},_this.callQueue_=[],_this.loadQueue_=[],_this.metadataQueue_={id3:[],caption:[]},_this.waitingOnRemove_=!1,_this.quotaExceededErrorRetryTimeout_=null,_this.activeInitSegmentId_=null,_this.initSegments_={},_this.cacheEncryptionKeys_=settings.cacheEncryptionKeys,_this.keyCache_={},_this.decrypter_=settings.decrypter,_this.syncController_=settings.syncController,_this.syncPoint_={segmentIndex:0,time:0},_this.transmuxer_=_this.createTransmuxer_(),_this.triggerSyncInfoUpdate_=function(){return _this.trigger("syncinfoupdate")},_this.syncController_.on("syncinfoupdate",_this.triggerSyncInfoUpdate_),_this.mediaSource_.addEventListener("sourceopen",(function(){_this.isEndOfStream_()||(_this.ended_=!1)})),_this.fetchAtBuffer_=!1,_this.logger_=logger("SegmentLoader["+_this.loaderType_+"]"),Object.defineProperty(assertThisInitialized(_this),"state",{get:function(){return this.state_},set:function(newState){newState!==this.state_&&(this.logger_(this.state_+" -> "+newState),this.state_=newState,this.trigger("statechange"))}}),_this.sourceUpdater_.on("ready",(function(){_this.hasEnoughInfoToAppend_()&&_this.processCallQueue_()})),"main"===_this.loaderType_&&_this.timelineChangeController_.on("pendingtimelinechange",(function(){_this.hasEnoughInfoToAppend_()&&_this.processCallQueue_()})),"audio"===_this.loaderType_&&_this.timelineChangeController_.on("timelinechange",(function(){_this.hasEnoughInfoToLoad_()&&_this.processLoadQueue_(),_this.hasEnoughInfoToAppend_()&&_this.processCallQueue_()})),_this}inheritsLoose(SegmentLoader,_videojs$EventTarget);var _proto=SegmentLoader.prototype;return _proto.createTransmuxer_=function(){return segmentTransmuxer_createTransmuxer({remux:!1,alignGopsAtEnd:this.safeAppend_,keepOriginalTimestamps:!0,parse708captions:this.parse708captions_,captionServices:this.captionServices_})},_proto.resetStats_=function(){this.mediaBytesTransferred=0,this.mediaRequests=0,this.mediaRequestsAborted=0,this.mediaRequestsTimedout=0,this.mediaRequestsErrored=0,this.mediaTransferDuration=0,this.mediaSecondsLoaded=0,this.mediaAppends=0},_proto.dispose=function(){this.trigger("dispose"),this.state="DISPOSED",this.pause(),this.abort_(),this.transmuxer_&&this.transmuxer_.terminate(),this.resetStats_(),this.checkBufferTimeout_&&window.clearTimeout(this.checkBufferTimeout_),this.syncController_&&this.triggerSyncInfoUpdate_&&this.syncController_.off("syncinfoupdate",this.triggerSyncInfoUpdate_),this.off()},_proto.setAudio=function(enable){this.audioDisabled_=!enable,enable?this.appendInitSegment_.audio=!0:this.sourceUpdater_.removeAudio(0,this.duration_())},_proto.abort=function(){"WAITING"===this.state?(this.abort_(),this.state="READY",this.paused()||this.monitorBuffer_()):this.pendingSegment_&&(this.pendingSegment_=null)},_proto.abort_=function(){this.pendingSegment_&&this.pendingSegment_.abortRequests&&this.pendingSegment_.abortRequests(),this.pendingSegment_=null,this.callQueue_=[],this.loadQueue_=[],this.metadataQueue_.id3=[],this.metadataQueue_.caption=[],this.timelineChangeController_.clearPendingTimelineChange(this.loaderType_),this.waitingOnRemove_=!1,window.clearTimeout(this.quotaExceededErrorRetryTimeout_),this.quotaExceededErrorRetryTimeout_=null},_proto.checkForAbort_=function(requestId){return"APPENDING"!==this.state||this.pendingSegment_?!this.pendingSegment_||this.pendingSegment_.requestId!==requestId:(this.state="READY",!0)},_proto.error=function(_error){return void 0!==_error&&(this.logger_("error occurred:",_error),this.error_=_error),this.pendingSegment_=null,this.error_},_proto.endOfStream=function(){this.ended_=!0,this.transmuxer_&&segmentTransmuxer_reset(this.transmuxer_),this.gopBuffer_.length=0,this.pause(),this.trigger("ended")},_proto.buffered_=function(){var trackInfo=this.getMediaInfo_();if(!this.sourceUpdater_||!trackInfo)return videojs.createTimeRanges();if("main"===this.loaderType_){var hasAudio=trackInfo.hasAudio,hasVideo=trackInfo.hasVideo,isMuxed=trackInfo.isMuxed;if(hasVideo&&hasAudio&&!this.audioDisabled_&&!isMuxed)return this.sourceUpdater_.buffered();if(hasVideo)return this.sourceUpdater_.videoBuffered()}return this.sourceUpdater_.audioBuffered()},_proto.initSegmentForMap=function(map,set){if(void 0===set&&(set=!1),!map)return null;var id=initSegmentId(map),storedMap=this.initSegments_[id];return set&&!storedMap&&map.bytes&&(this.initSegments_[id]=storedMap={resolvedUri:map.resolvedUri,byterange:map.byterange,bytes:map.bytes,tracks:map.tracks,timescales:map.timescales}),storedMap||map},_proto.segmentKey=function(key,set){if(void 0===set&&(set=!1),!key)return null;var id=segmentKeyId(key),storedKey=this.keyCache_[id];this.cacheEncryptionKeys_&&set&&!storedKey&&key.bytes&&(this.keyCache_[id]=storedKey={resolvedUri:key.resolvedUri,bytes:key.bytes});var result={resolvedUri:(storedKey||key).resolvedUri};return storedKey&&(result.bytes=storedKey.bytes),result},_proto.couldBeginLoading_=function(){return this.playlist_&&!this.paused()},_proto.load=function(){if(this.monitorBuffer_(),this.playlist_)return"INIT"===this.state&&this.couldBeginLoading_()?this.init_():void(!this.couldBeginLoading_()||"READY"!==this.state&&"INIT"!==this.state||(this.state="READY"))},_proto.init_=function(){return this.state="READY",this.resetEverything(),this.monitorBuffer_()},_proto.playlist=function(newPlaylist,options){if(void 0===options&&(options={}),newPlaylist){var oldPlaylist=this.playlist_,segmentInfo=this.pendingSegment_;this.playlist_=newPlaylist,this.xhrOptions_=options,"INIT"===this.state&&(newPlaylist.syncInfo={mediaSequence:newPlaylist.mediaSequence,time:0},"main"===this.loaderType_&&this.syncController_.setDateTimeMappingForStart(newPlaylist));var oldId=null;if(oldPlaylist&&(oldPlaylist.id?oldId=oldPlaylist.id:oldPlaylist.uri&&(oldId=oldPlaylist.uri)),this.logger_("playlist update ["+oldId+" => "+(newPlaylist.id||newPlaylist.uri)+"]"),this.trigger("syncinfoupdate"),"INIT"===this.state&&this.couldBeginLoading_())return this.init_();if(!oldPlaylist||oldPlaylist.uri!==newPlaylist.uri)return null!==this.mediaIndex&&(newPlaylist.endList?this.resyncLoader():this.resetLoader()),this.currentMediaInfo_=void 0,void this.trigger("playlistupdate");var mediaSequenceDiff=newPlaylist.mediaSequence-oldPlaylist.mediaSequence;if(this.logger_("live window shift ["+mediaSequenceDiff+"]"),null!==this.mediaIndex)if(this.mediaIndex-=mediaSequenceDiff,this.mediaIndex<0)this.mediaIndex=null,this.partIndex=null;else{var segment=this.playlist_.segments[this.mediaIndex];if(this.partIndex&&(!segment.parts||!segment.parts.length||!segment.parts[this.partIndex])){var mediaIndex=this.mediaIndex;this.logger_("currently processing part (index "+this.partIndex+") no longer exists."),this.resetLoader(),this.mediaIndex=mediaIndex}}segmentInfo&&(segmentInfo.mediaIndex-=mediaSequenceDiff,segmentInfo.mediaIndex<0?(segmentInfo.mediaIndex=null,segmentInfo.partIndex=null):(segmentInfo.mediaIndex>=0&&(segmentInfo.segment=newPlaylist.segments[segmentInfo.mediaIndex]),segmentInfo.partIndex>=0&&segmentInfo.segment.parts&&(segmentInfo.part=segmentInfo.segment.parts[segmentInfo.partIndex]))),this.syncController_.saveExpiredSegmentInfo(oldPlaylist,newPlaylist)}},_proto.pause=function(){this.checkBufferTimeout_&&(window.clearTimeout(this.checkBufferTimeout_),this.checkBufferTimeout_=null)},_proto.paused=function(){return null===this.checkBufferTimeout_},_proto.resetEverything=function(done){this.ended_=!1,this.appendInitSegment_={audio:!0,video:!0},this.resetLoader(),this.remove(0,1/0,done),this.transmuxer_&&(this.transmuxer_.postMessage({action:"clearAllMp4Captions"}),this.transmuxer_.postMessage({action:"reset"}))},_proto.resetLoader=function(){this.fetchAtBuffer_=!1,this.resyncLoader()},_proto.resyncLoader=function(){this.transmuxer_&&segmentTransmuxer_reset(this.transmuxer_),this.mediaIndex=null,this.partIndex=null,this.syncPoint_=null,this.isPendingTimestampOffset_=!1,this.callQueue_=[],this.loadQueue_=[],this.metadataQueue_.id3=[],this.metadataQueue_.caption=[],this.abort(),this.transmuxer_&&this.transmuxer_.postMessage({action:"clearParsedMp4Captions"})},_proto.remove=function(start,end,done,force){if(void 0===done&&(done=function(){}),void 0===force&&(force=!1),end===1/0&&(end=this.duration_()),end<=start)this.logger_("skipping remove because end ${end} is <= start ${start}");else if(this.sourceUpdater_&&this.getMediaInfo_()){var removesRemaining=1,removeFinished=function(){0===--removesRemaining&&done()};for(var track in!force&&this.audioDisabled_||(removesRemaining++,this.sourceUpdater_.removeAudio(start,end,removeFinished)),(force||"main"===this.loaderType_)&&(this.gopBuffer_=function(buffer,start,end,mapping){for(var startPts=Math.ceil((start-mapping)*clock_1),endPts=Math.ceil((end-mapping)*clock_1),updatedBuffer=buffer.slice(),i=buffer.length;i--&&!(buffer[i].pts<=endPts););if(-1===i)return updatedBuffer;for(var j=i+1;j--&&!(buffer[j].pts<=startPts););return j=Math.max(j,0),updatedBuffer.splice(j,i-j+1),updatedBuffer}(this.gopBuffer_,start,end,this.timeMapping_),removesRemaining++,this.sourceUpdater_.removeVideo(start,end,removeFinished)),this.inbandTextTracks_)removeCuesFromTrack(start,end,this.inbandTextTracks_[track]);removeCuesFromTrack(start,end,this.segmentMetadataTrack_),removeFinished()}else this.logger_("skipping remove because no source updater or starting media info")},_proto.monitorBuffer_=function(){this.checkBufferTimeout_&&window.clearTimeout(this.checkBufferTimeout_),this.checkBufferTimeout_=window.setTimeout(this.monitorBufferTick_.bind(this),1)},_proto.monitorBufferTick_=function(){"READY"===this.state&&this.fillBuffer_(),this.checkBufferTimeout_&&window.clearTimeout(this.checkBufferTimeout_),this.checkBufferTimeout_=window.setTimeout(this.monitorBufferTick_.bind(this),500)},_proto.fillBuffer_=function(){if(!this.sourceUpdater_.updating()){var segmentInfo=this.chooseNextRequest_();segmentInfo&&("number"==typeof segmentInfo.timestampOffset&&(this.isPendingTimestampOffset_=!1,this.timelineChangeController_.pendingTimelineChange({type:this.loaderType_,from:this.currentTimeline_,to:segmentInfo.timeline})),this.loadSegment_(segmentInfo))}},_proto.isEndOfStream_=function(mediaIndex,playlist,partIndex){if(void 0===mediaIndex&&(mediaIndex=this.mediaIndex),void 0===playlist&&(playlist=this.playlist_),void 0===partIndex&&(partIndex=this.partIndex),!playlist||!this.mediaSource_)return!1;var segment="number"==typeof mediaIndex&&playlist.segments[mediaIndex],appendedLastSegment=mediaIndex+1===playlist.segments.length,appendedLastPart=!segment||!segment.parts||partIndex+1===segment.parts.length;return playlist.endList&&"open"===this.mediaSource_.readyState&&appendedLastSegment&&appendedLastPart},_proto.chooseNextRequest_=function(){var buffered=this.buffered_(),bufferedEnd=lastBufferedEnd(buffered)||0,bufferedTime=timeAheadOf(buffered,this.currentTime_()),preloaded=!this.hasPlayed_()&&bufferedTime>=1,haveEnoughBuffer=bufferedTime>=this.goalBufferLength_(),segments=this.playlist_.segments;if(!segments.length||preloaded||haveEnoughBuffer)return null;this.syncPoint_=this.syncPoint_||this.syncController_.getSyncPoint(this.playlist_,this.duration_(),this.currentTimeline_,this.currentTime_());var next={partIndex:null,mediaIndex:null,startOfSegment:null,playlist:this.playlist_,isSyncRequest:Boolean(!this.syncPoint_)};if(next.isSyncRequest)next.mediaIndex=function(currentTimeline,segments,targetTime){segments=segments||[];for(var timelineSegments=[],time=0,i=0;i<segments.length;i++){var segment=segments[i];if(currentTimeline===segment.timeline&&(timelineSegments.push(i),(time+=segment.duration)>targetTime))return i}return 0===timelineSegments.length?0:timelineSegments[timelineSegments.length-1]}(this.currentTimeline_,segments,bufferedEnd);else if(null!==this.mediaIndex){var segment=segments[this.mediaIndex],partIndex="number"==typeof this.partIndex?this.partIndex:-1;next.startOfSegment=segment.end?segment.end:bufferedEnd,segment.parts&&segment.parts[partIndex+1]?(next.mediaIndex=this.mediaIndex,next.partIndex=partIndex+1):next.mediaIndex=this.mediaIndex+1}else{var _Playlist$getMediaInf=Playlist.getMediaInfoForTime({experimentalExactManifestTimings:this.experimentalExactManifestTimings,playlist:this.playlist_,currentTime:this.fetchAtBuffer_?bufferedEnd:this.currentTime_(),startingPartIndex:this.syncPoint_.partIndex,startingSegmentIndex:this.syncPoint_.segmentIndex,startTime:this.syncPoint_.time}),segmentIndex=_Playlist$getMediaInf.segmentIndex,startTime=_Playlist$getMediaInf.startTime,_partIndex=_Playlist$getMediaInf.partIndex;next.getMediaInfoForTime=this.fetchAtBuffer_?"bufferedEnd "+bufferedEnd:"currentTime "+this.currentTime_(),next.mediaIndex=segmentIndex,next.startOfSegment=startTime,next.partIndex=_partIndex}var nextSegment=segments[next.mediaIndex],nextPart=nextSegment&&"number"==typeof next.partIndex&&nextSegment.parts&&nextSegment.parts[next.partIndex];if(!nextSegment||"number"==typeof next.partIndex&&!nextPart)return null;if("number"!=typeof next.partIndex&&nextSegment.parts&&(next.partIndex=0,nextPart=nextSegment.parts[0]),!bufferedTime&&nextPart&&!nextPart.independent)if(0===next.partIndex){var lastSegment=segments[next.mediaIndex-1],lastSegmentLastPart=lastSegment.parts&&lastSegment.parts.length&&lastSegment.parts[lastSegment.parts.length-1];lastSegmentLastPart&&lastSegmentLastPart.independent&&(next.mediaIndex-=1,next.partIndex=lastSegment.parts.length-1,next.independent="previous segment")}else nextSegment.parts[next.partIndex-1].independent&&(next.partIndex-=1,next.independent="previous part");var ended=this.mediaSource_&&"ended"===this.mediaSource_.readyState;return next.mediaIndex>=segments.length-1&&ended&&!this.seeking_()?null:this.generateSegmentInfo_(next)},_proto.generateSegmentInfo_=function(options){var independent=options.independent,playlist=options.playlist,mediaIndex=options.mediaIndex,startOfSegment=options.startOfSegment,isSyncRequest=options.isSyncRequest,partIndex=options.partIndex,forceTimestampOffset=options.forceTimestampOffset,getMediaInfoForTime=options.getMediaInfoForTime,segment=playlist.segments[mediaIndex],part="number"==typeof partIndex&&segment.parts[partIndex],segmentInfo={requestId:"segment-loader-"+Math.random(),uri:part&&part.resolvedUri||segment.resolvedUri,mediaIndex:mediaIndex,partIndex:part?partIndex:null,isSyncRequest:isSyncRequest,startOfSegment:startOfSegment,playlist:playlist,bytes:null,encryptedBytes:null,timestampOffset:null,timeline:segment.timeline,duration:part&&part.duration||segment.duration,segment:segment,part:part,byteLength:0,transmuxer:this.transmuxer_,getMediaInfoForTime:getMediaInfoForTime,independent:independent},overrideCheck=void 0!==forceTimestampOffset?forceTimestampOffset:this.isPendingTimestampOffset_;segmentInfo.timestampOffset=this.timestampOffsetForSegment_({segmentTimeline:segment.timeline,currentTimeline:this.currentTimeline_,startOfSegment:startOfSegment,buffered:this.buffered_(),overrideCheck:overrideCheck});var audioBufferedEnd=lastBufferedEnd(this.sourceUpdater_.audioBuffered());return"number"==typeof audioBufferedEnd&&(segmentInfo.audioAppendStart=audioBufferedEnd-this.sourceUpdater_.audioTimestampOffset()),this.sourceUpdater_.videoBuffered().length&&(segmentInfo.gopsToAlignWith=function(buffer,currentTime,mapping){if(null==currentTime||!buffer.length)return[];var i,currentTimePts=Math.ceil((currentTime-mapping+3)*clock_1);for(i=0;i<buffer.length&&!(buffer[i].pts>currentTimePts);i++);return buffer.slice(i)}(this.gopBuffer_,this.currentTime_()-this.sourceUpdater_.videoTimestampOffset(),this.timeMapping_)),segmentInfo},_proto.timestampOffsetForSegment_=function(options){return segmentTimeline=(_ref=options).segmentTimeline,currentTimeline=_ref.currentTimeline,startOfSegment=_ref.startOfSegment,buffered=_ref.buffered,_ref.overrideCheck||segmentTimeline!==currentTimeline?segmentTimeline<currentTimeline?startOfSegment:buffered.length?buffered.end(buffered.length-1):startOfSegment:null;var _ref,segmentTimeline,currentTimeline,startOfSegment,buffered},_proto.earlyAbortWhenNeeded_=function(stats){if(!this.vhs_.tech_.paused()&&this.xhrOptions_.timeout&&this.playlist_.attributes.BANDWIDTH&&!(Date.now()-(stats.firstBytesReceivedAt||Date.now())<1e3)){var currentTime=this.currentTime_(),measuredBandwidth=stats.bandwidth,segmentDuration=this.pendingSegment_.duration,requestTimeRemaining=Playlist.estimateSegmentRequestTime(segmentDuration,measuredBandwidth,this.playlist_,stats.bytesReceived),timeUntilRebuffer$1=function(buffered,currentTime,playbackRate){return void 0===playbackRate&&(playbackRate=1),((buffered.length?buffered.end(buffered.length-1):0)-currentTime)/playbackRate}(this.buffered_(),currentTime,this.vhs_.tech_.playbackRate())-1;if(!(requestTimeRemaining<=timeUntilRebuffer$1)){var switchCandidate=function(settings){var master=settings.master,currentTime=settings.currentTime,bandwidth=settings.bandwidth,duration=settings.duration,segmentDuration=settings.segmentDuration,timeUntilRebuffer=settings.timeUntilRebuffer,currentTimeline=settings.currentTimeline,syncController=settings.syncController,compatiblePlaylists=master.playlists.filter((function(playlist){return!Playlist.isIncompatible(playlist)})),enabledPlaylists=compatiblePlaylists.filter(Playlist.isEnabled);enabledPlaylists.length||(enabledPlaylists=compatiblePlaylists.filter((function(playlist){return!Playlist.isDisabled(playlist)})));var rebufferingEstimates=enabledPlaylists.filter(Playlist.hasAttribute.bind(null,"BANDWIDTH")).map((function(playlist){var numRequests=syncController.getSyncPoint(playlist,duration,currentTimeline,currentTime)?1:2;return{playlist:playlist,rebufferingImpact:Playlist.estimateSegmentRequestTime(segmentDuration,bandwidth,playlist)*numRequests-timeUntilRebuffer}})),noRebufferingPlaylists=rebufferingEstimates.filter((function(estimate){return estimate.rebufferingImpact<=0}));return stableSort(noRebufferingPlaylists,(function(a,b){return comparePlaylistBandwidth(b.playlist,a.playlist)})),noRebufferingPlaylists.length?noRebufferingPlaylists[0]:(stableSort(rebufferingEstimates,(function(a,b){return a.rebufferingImpact-b.rebufferingImpact})),rebufferingEstimates[0]||null)}({master:this.vhs_.playlists.master,currentTime:currentTime,bandwidth:measuredBandwidth,duration:this.duration_(),segmentDuration:segmentDuration,timeUntilRebuffer:timeUntilRebuffer$1,currentTimeline:this.currentTimeline_,syncController:this.syncController_});if(switchCandidate){var timeSavedBySwitching=requestTimeRemaining-timeUntilRebuffer$1-switchCandidate.rebufferingImpact,minimumTimeSaving=.5;timeUntilRebuffer$1<=.03333333333333333&&(minimumTimeSaving=1),!switchCandidate.playlist||switchCandidate.playlist.uri===this.playlist_.uri||timeSavedBySwitching<minimumTimeSaving||(this.bandwidth=switchCandidate.playlist.attributes.BANDWIDTH*Config.BANDWIDTH_VARIANCE+1,this.trigger("earlyabort"))}}}},_proto.handleAbort_=function(segmentInfo){this.logger_("Aborting "+segmentInfoString(segmentInfo)),this.mediaRequestsAborted+=1},_proto.handleProgress_=function(event,simpleSegment){this.earlyAbortWhenNeeded_(simpleSegment.stats),this.checkForAbort_(simpleSegment.requestId)||this.trigger("progress")},_proto.handleTrackInfo_=function(simpleSegment,trackInfo){this.earlyAbortWhenNeeded_(simpleSegment.stats),this.checkForAbort_(simpleSegment.requestId)||this.checkForIllegalMediaSwitch(trackInfo)||(trackInfo=trackInfo||{},function(a,b){if(!a&&!b||!a&&b||a&&!b)return!1;if(a===b)return!0;var akeys=Object.keys(a).sort(),bkeys=Object.keys(b).sort();if(akeys.length!==bkeys.length)return!1;for(var i=0;i<akeys.length;i++){var key=akeys[i];if(key!==bkeys[i])return!1;if(a[key]!==b[key])return!1}return!0}(this.currentMediaInfo_,trackInfo)||(this.appendInitSegment_={audio:!0,video:!0},this.startingMediaInfo_=trackInfo,this.currentMediaInfo_=trackInfo,this.logger_("trackinfo update",trackInfo),this.trigger("trackinfo")),this.checkForAbort_(simpleSegment.requestId)||(this.pendingSegment_.trackInfo=trackInfo,this.hasEnoughInfoToAppend_()&&this.processCallQueue_()))},_proto.handleTimingInfo_=function(simpleSegment,mediaType,timeType,time){if(this.earlyAbortWhenNeeded_(simpleSegment.stats),!this.checkForAbort_(simpleSegment.requestId)){var segmentInfo=this.pendingSegment_,timingInfoProperty=timingInfoPropertyForMedia(mediaType);segmentInfo[timingInfoProperty]=segmentInfo[timingInfoProperty]||{},segmentInfo[timingInfoProperty][timeType]=time,this.logger_("timinginfo: "+mediaType+" - "+timeType+" - "+time),this.hasEnoughInfoToAppend_()&&this.processCallQueue_()}},_proto.handleCaptions_=function(simpleSegment,captionData){var _this2=this;if(this.earlyAbortWhenNeeded_(simpleSegment.stats),!this.checkForAbort_(simpleSegment.requestId))if(0!==captionData.length)if(this.pendingSegment_.hasAppendedData_){var timestampOffset=null===this.sourceUpdater_.videoTimestampOffset()?this.sourceUpdater_.audioTimestampOffset():this.sourceUpdater_.videoTimestampOffset(),captionTracks={};captionData.forEach((function(caption){captionTracks[caption.stream]=captionTracks[caption.stream]||{startTime:1/0,captions:[],endTime:0};var captionTrack=captionTracks[caption.stream];captionTrack.startTime=Math.min(captionTrack.startTime,caption.startTime+timestampOffset),captionTrack.endTime=Math.max(captionTrack.endTime,caption.endTime+timestampOffset),captionTrack.captions.push(caption)})),Object.keys(captionTracks).forEach((function(trackName){var _captionTracks$trackN=captionTracks[trackName],startTime=_captionTracks$trackN.startTime,endTime=_captionTracks$trackN.endTime,captions=_captionTracks$trackN.captions,inbandTextTracks=_this2.inbandTextTracks_;_this2.logger_("adding cues from "+startTime+" -> "+endTime+" for "+trackName),function(inbandTextTracks,tech,captionStream){if(!inbandTextTracks[captionStream]){tech.trigger({type:"usage",name:"vhs-608"}),tech.trigger({type:"usage",name:"hls-608"});var instreamId=captionStream;/^cc708_/.test(captionStream)&&(instreamId="SERVICE"+captionStream.split("_")[1]);var track=tech.textTracks().getTrackById(instreamId);if(track)inbandTextTracks[captionStream]=track;else{var label=captionStream,language=captionStream,def=!1,captionService=(tech.options_.vhs&&tech.options_.vhs.captionServices||{})[instreamId];captionService&&(label=captionService.label,language=captionService.language,def=captionService.default),inbandTextTracks[captionStream]=tech.addRemoteTextTrack({kind:"captions",id:instreamId,default:def,label:label,language:language},!1).track}}}(inbandTextTracks,_this2.vhs_.tech_,trackName),removeCuesFromTrack(startTime,endTime,inbandTextTracks[trackName]),function(_ref){var inbandTextTracks=_ref.inbandTextTracks,captionArray=_ref.captionArray,timestampOffset=_ref.timestampOffset;if(captionArray){var Cue=window.WebKitDataCue||window.VTTCue;captionArray.forEach((function(caption){var track=caption.stream;inbandTextTracks[track].addCue(new Cue(caption.startTime+timestampOffset,caption.endTime+timestampOffset,caption.text))}))}}({captionArray:captions,inbandTextTracks:inbandTextTracks,timestampOffset:timestampOffset})})),this.transmuxer_&&this.transmuxer_.postMessage({action:"clearParsedMp4Captions"})}else this.metadataQueue_.caption.push(this.handleCaptions_.bind(this,simpleSegment,captionData));else this.logger_("SegmentLoader received no captions from a caption event")},_proto.handleId3_=function(simpleSegment,id3Frames,dispatchType){if(this.earlyAbortWhenNeeded_(simpleSegment.stats),!this.checkForAbort_(simpleSegment.requestId))if(this.pendingSegment_.hasAppendedData_){var timestampOffset=null===this.sourceUpdater_.videoTimestampOffset()?this.sourceUpdater_.audioTimestampOffset():this.sourceUpdater_.videoTimestampOffset();!function(inbandTextTracks,dispatchType,tech){inbandTextTracks.metadataTrack_||(inbandTextTracks.metadataTrack_=tech.addRemoteTextTrack({kind:"metadata",label:"Timed Metadata"},!1).track,inbandTextTracks.metadataTrack_.inBandMetadataTrackDispatchType=dispatchType)}(this.inbandTextTracks_,dispatchType,this.vhs_.tech_),addMetadata({inbandTextTracks:this.inbandTextTracks_,metadataArray:id3Frames,timestampOffset:timestampOffset,videoDuration:this.duration_()})}else this.metadataQueue_.id3.push(this.handleId3_.bind(this,simpleSegment,id3Frames,dispatchType))},_proto.processMetadataQueue_=function(){this.metadataQueue_.id3.forEach((function(fn){return fn()})),this.metadataQueue_.caption.forEach((function(fn){return fn()})),this.metadataQueue_.id3=[],this.metadataQueue_.caption=[]},_proto.processCallQueue_=function(){var callQueue=this.callQueue_;this.callQueue_=[],callQueue.forEach((function(fun){return fun()}))},_proto.processLoadQueue_=function(){var loadQueue=this.loadQueue_;this.loadQueue_=[],loadQueue.forEach((function(fun){return fun()}))},_proto.hasEnoughInfoToLoad_=function(){if("audio"!==this.loaderType_)return!0;var segmentInfo=this.pendingSegment_;return!!segmentInfo&&(!this.getCurrentMediaInfo_()||!shouldWaitForTimelineChange({timelineChangeController:this.timelineChangeController_,currentTimeline:this.currentTimeline_,segmentTimeline:segmentInfo.timeline,loaderType:this.loaderType_,audioDisabled:this.audioDisabled_}))},_proto.getCurrentMediaInfo_=function(segmentInfo){return void 0===segmentInfo&&(segmentInfo=this.pendingSegment_),segmentInfo&&segmentInfo.trackInfo||this.currentMediaInfo_},_proto.getMediaInfo_=function(segmentInfo){return void 0===segmentInfo&&(segmentInfo=this.pendingSegment_),this.getCurrentMediaInfo_(segmentInfo)||this.startingMediaInfo_},_proto.hasEnoughInfoToAppend_=function(){if(!this.sourceUpdater_.ready())return!1;if(this.waitingOnRemove_||this.quotaExceededErrorRetryTimeout_)return!1;var segmentInfo=this.pendingSegment_,trackInfo=this.getCurrentMediaInfo_();if(!segmentInfo||!trackInfo)return!1;var hasAudio=trackInfo.hasAudio,hasVideo=trackInfo.hasVideo,isMuxed=trackInfo.isMuxed;return!(hasVideo&&!segmentInfo.videoTimingInfo)&&(!(hasAudio&&!this.audioDisabled_&&!isMuxed&&!segmentInfo.audioTimingInfo)&&!shouldWaitForTimelineChange({timelineChangeController:this.timelineChangeController_,currentTimeline:this.currentTimeline_,segmentTimeline:segmentInfo.timeline,loaderType:this.loaderType_,audioDisabled:this.audioDisabled_}))},_proto.handleData_=function(simpleSegment,result){if(this.earlyAbortWhenNeeded_(simpleSegment.stats),!this.checkForAbort_(simpleSegment.requestId))if(!this.callQueue_.length&&this.hasEnoughInfoToAppend_()){var segmentInfo=this.pendingSegment_;if(this.setTimeMapping_(segmentInfo.timeline),this.updateMediaSecondsLoaded_(segmentInfo.part||segmentInfo.segment),"closed"!==this.mediaSource_.readyState){if(simpleSegment.map&&(simpleSegment.map=this.initSegmentForMap(simpleSegment.map,!0),segmentInfo.segment.map=simpleSegment.map),simpleSegment.key&&this.segmentKey(simpleSegment.key,!0),segmentInfo.isFmp4=simpleSegment.isFmp4,segmentInfo.timingInfo=segmentInfo.timingInfo||{},segmentInfo.isFmp4)this.trigger("fmp4"),segmentInfo.timingInfo.start=segmentInfo[timingInfoPropertyForMedia(result.type)].start;else{var firstVideoFrameTimeForData,trackInfo=this.getCurrentMediaInfo_(),useVideoTimingInfo="main"===this.loaderType_&&trackInfo&&trackInfo.hasVideo;useVideoTimingInfo&&(firstVideoFrameTimeForData=segmentInfo.videoTimingInfo.start),segmentInfo.timingInfo.start=this.trueSegmentStart_({currentStart:segmentInfo.timingInfo.start,playlist:segmentInfo.playlist,mediaIndex:segmentInfo.mediaIndex,currentVideoTimestampOffset:this.sourceUpdater_.videoTimestampOffset(),useVideoTimingInfo:useVideoTimingInfo,firstVideoFrameTimeForData:firstVideoFrameTimeForData,videoTimingInfo:segmentInfo.videoTimingInfo,audioTimingInfo:segmentInfo.audioTimingInfo})}if(this.updateAppendInitSegmentStatus(segmentInfo,result.type),this.updateSourceBufferTimestampOffset_(segmentInfo),segmentInfo.isSyncRequest){this.updateTimingInfoEnd_(segmentInfo),this.syncController_.saveSegmentTimingInfo({segmentInfo:segmentInfo,shouldSaveTimelineMapping:"main"===this.loaderType_});var next=this.chooseNextRequest_();if(next.mediaIndex!==segmentInfo.mediaIndex||next.partIndex!==segmentInfo.partIndex)return void this.logger_("sync segment was incorrect, not appending");this.logger_("sync segment was correct, appending")}segmentInfo.hasAppendedData_=!0,this.processMetadataQueue_(),this.appendData_(segmentInfo,result)}}else this.callQueue_.push(this.handleData_.bind(this,simpleSegment,result))},_proto.updateAppendInitSegmentStatus=function(segmentInfo,type){"main"!==this.loaderType_||"number"!=typeof segmentInfo.timestampOffset||segmentInfo.changedTimestampOffset||(this.appendInitSegment_={audio:!0,video:!0}),this.playlistOfLastInitSegment_[type]!==segmentInfo.playlist&&(this.appendInitSegment_[type]=!0)},_proto.getInitSegmentAndUpdateState_=function(_ref4){var type=_ref4.type,initSegment=_ref4.initSegment,map=_ref4.map,playlist=_ref4.playlist;if(map){var id=initSegmentId(map);if(this.activeInitSegmentId_===id)return null;initSegment=this.initSegmentForMap(map,!0).bytes,this.activeInitSegmentId_=id}return initSegment&&this.appendInitSegment_[type]?(this.playlistOfLastInitSegment_[type]=playlist,this.appendInitSegment_[type]=!1,this.activeInitSegmentId_=null,initSegment):null},_proto.handleQuotaExceededError_=function(_ref5,error){var _this3=this,segmentInfo=_ref5.segmentInfo,type=_ref5.type,bytes=_ref5.bytes,audioBuffered=this.sourceUpdater_.audioBuffered(),videoBuffered=this.sourceUpdater_.videoBuffered();audioBuffered.length>1&&this.logger_("On QUOTA_EXCEEDED_ERR, found gaps in the audio buffer: "+timeRangesToArray(audioBuffered).join(", ")),videoBuffered.length>1&&this.logger_("On QUOTA_EXCEEDED_ERR, found gaps in the video buffer: "+timeRangesToArray(videoBuffered).join(", "));var audioBufferStart=audioBuffered.length?audioBuffered.start(0):0,audioBufferEnd=audioBuffered.length?audioBuffered.end(audioBuffered.length-1):0,videoBufferStart=videoBuffered.length?videoBuffered.start(0):0,videoBufferEnd=videoBuffered.length?videoBuffered.end(videoBuffered.length-1):0;if(audioBufferEnd-audioBufferStart<=1&&videoBufferEnd-videoBufferStart<=1)return this.logger_("On QUOTA_EXCEEDED_ERR, single segment too large to append to buffer, triggering an error. Appended byte length: "+bytes.byteLength+", audio buffer: "+timeRangesToArray(audioBuffered).join(", ")+", video buffer: "+timeRangesToArray(videoBuffered).join(", ")+", "),this.error({message:"Quota exceeded error with append of a single segment of content",excludeUntil:1/0}),void this.trigger("error");this.waitingOnRemove_=!0,this.callQueue_.push(this.appendToSourceBuffer_.bind(this,{segmentInfo:segmentInfo,type:type,bytes:bytes}));var timeToRemoveUntil=this.currentTime_()-1;this.logger_("On QUOTA_EXCEEDED_ERR, removing audio/video from 0 to "+timeToRemoveUntil),this.remove(0,timeToRemoveUntil,(function(){_this3.logger_("On QUOTA_EXCEEDED_ERR, retrying append in 1s"),_this3.waitingOnRemove_=!1,_this3.quotaExceededErrorRetryTimeout_=window.setTimeout((function(){_this3.logger_("On QUOTA_EXCEEDED_ERR, re-processing call queue"),_this3.quotaExceededErrorRetryTimeout_=null,_this3.processCallQueue_()}),1e3)}),!0)},_proto.handleAppendError_=function(_ref6,error){var segmentInfo=_ref6.segmentInfo,type=_ref6.type,bytes=_ref6.bytes;error&&(22!==error.code?(this.logger_("Received non QUOTA_EXCEEDED_ERR on append",error),this.error(type+" append of "+bytes.length+"b failed for segment #"+segmentInfo.mediaIndex+" in playlist "+segmentInfo.playlist.id),this.trigger("appenderror")):this.handleQuotaExceededError_({segmentInfo:segmentInfo,type:type,bytes:bytes}))},_proto.appendToSourceBuffer_=function(_ref7){var segmentObj,tempBuffer,offset,segmentInfo=_ref7.segmentInfo,type=_ref7.type,initSegment=_ref7.initSegment,data=_ref7.data,bytes=_ref7.bytes;if(!bytes){var segments=[data],byteLength=data.byteLength;initSegment&&(segments.unshift(initSegment),byteLength+=initSegment.byteLength),offset=0,(segmentObj={bytes:byteLength,segments:segments}).bytes&&(tempBuffer=new Uint8Array(segmentObj.bytes),segmentObj.segments.forEach((function(segment){tempBuffer.set(segment,offset),offset+=segment.byteLength}))),bytes=tempBuffer}this.sourceUpdater_.appendBuffer({segmentInfo:segmentInfo,type:type,bytes:bytes},this.handleAppendError_.bind(this,{segmentInfo:segmentInfo,type:type,bytes:bytes}))},_proto.handleSegmentTimingInfo_=function(type,requestId,segmentTimingInfo){if(this.pendingSegment_&&requestId===this.pendingSegment_.requestId){var segment=this.pendingSegment_.segment,timingInfoProperty=type+"TimingInfo";segment[timingInfoProperty]||(segment[timingInfoProperty]={}),segment[timingInfoProperty].transmuxerPrependedSeconds=segmentTimingInfo.prependedContentDuration||0,segment[timingInfoProperty].transmuxedPresentationStart=segmentTimingInfo.start.presentation,segment[timingInfoProperty].transmuxedDecodeStart=segmentTimingInfo.start.decode,segment[timingInfoProperty].transmuxedPresentationEnd=segmentTimingInfo.end.presentation,segment[timingInfoProperty].transmuxedDecodeEnd=segmentTimingInfo.end.decode,segment[timingInfoProperty].baseMediaDecodeTime=segmentTimingInfo.baseMediaDecodeTime}},_proto.appendData_=function(segmentInfo,result){var type=result.type,data=result.data;if(data&&data.byteLength&&("audio"!==type||!this.audioDisabled_)){var initSegment=this.getInitSegmentAndUpdateState_({type:type,initSegment:result.initSegment,playlist:segmentInfo.playlist,map:segmentInfo.isFmp4?segmentInfo.segment.map:null});this.appendToSourceBuffer_({segmentInfo:segmentInfo,type:type,initSegment:initSegment,data:data})}},_proto.loadSegment_=function(segmentInfo){var _this4=this;this.state="WAITING",this.pendingSegment_=segmentInfo,this.trimBackBuffer_(segmentInfo),"number"==typeof segmentInfo.timestampOffset&&this.transmuxer_&&this.transmuxer_.postMessage({action:"clearAllMp4Captions"}),this.hasEnoughInfoToLoad_()?this.updateTransmuxerAndRequestSegment_(segmentInfo):this.loadQueue_.push((function(){var options=_extends_1({},segmentInfo,{forceTimestampOffset:!0});_extends_1(segmentInfo,_this4.generateSegmentInfo_(options)),_this4.isPendingTimestampOffset_=!1,_this4.updateTransmuxerAndRequestSegment_(segmentInfo)}))},_proto.updateTransmuxerAndRequestSegment_=function(segmentInfo){var _this5=this;this.shouldUpdateTransmuxerTimestampOffset_(segmentInfo.timestampOffset)&&(this.gopBuffer_.length=0,segmentInfo.gopsToAlignWith=[],this.timeMapping_=0,this.transmuxer_.postMessage({action:"reset"}),this.transmuxer_.postMessage({action:"setTimestampOffset",timestampOffset:segmentInfo.timestampOffset}));var simpleSegment=this.createSimplifiedSegmentObj_(segmentInfo),isEndOfStream=this.isEndOfStream_(segmentInfo.mediaIndex,segmentInfo.playlist,segmentInfo.partIndex),isWalkingForward=null!==this.mediaIndex,isDiscontinuity=segmentInfo.timeline!==this.currentTimeline_&&segmentInfo.timeline>0,isEndOfTimeline=isEndOfStream||isWalkingForward&&isDiscontinuity;this.logger_("Requesting "+segmentInfoString(segmentInfo)),simpleSegment.map&&!simpleSegment.map.bytes&&(this.logger_("going to request init segment."),this.appendInitSegment_={video:!0,audio:!0}),segmentInfo.abortRequests=mediaSegmentRequest({xhr:this.vhs_.xhr,xhrOptions:this.xhrOptions_,decryptionWorker:this.decrypter_,segment:simpleSegment,abortFn:this.handleAbort_.bind(this,segmentInfo),progressFn:this.handleProgress_.bind(this),trackInfoFn:this.handleTrackInfo_.bind(this),timingInfoFn:this.handleTimingInfo_.bind(this),videoSegmentTimingInfoFn:this.handleSegmentTimingInfo_.bind(this,"video",segmentInfo.requestId),audioSegmentTimingInfoFn:this.handleSegmentTimingInfo_.bind(this,"audio",segmentInfo.requestId),captionsFn:this.handleCaptions_.bind(this),isEndOfTimeline:isEndOfTimeline,endedTimelineFn:function(){_this5.logger_("received endedtimeline callback")},id3Fn:this.handleId3_.bind(this),dataFn:this.handleData_.bind(this),doneFn:this.segmentRequestFinished_.bind(this),onTransmuxerLog:function(_ref8){var message=_ref8.message,level=_ref8.level,stream=_ref8.stream;_this5.logger_(segmentInfoString(segmentInfo)+" logged from transmuxer stream "+stream+" as a "+level+": "+message)}})},_proto.trimBackBuffer_=function(segmentInfo){var removeToTime=function(seekable,currentTime,targetDuration){var trimTime=currentTime-Config.BACK_BUFFER_LENGTH;seekable.length&&(trimTime=Math.max(trimTime,seekable.start(0)));var maxTrimTime=currentTime-targetDuration;return Math.min(maxTrimTime,trimTime)}(this.seekable_(),this.currentTime_(),this.playlist_.targetDuration||10);removeToTime>0&&this.remove(0,removeToTime)},_proto.createSimplifiedSegmentObj_=function(segmentInfo){var segment=segmentInfo.segment,part=segmentInfo.part,simpleSegment={resolvedUri:part?part.resolvedUri:segment.resolvedUri,byterange:part?part.byterange:segment.byterange,requestId:segmentInfo.requestId,transmuxer:segmentInfo.transmuxer,audioAppendStart:segmentInfo.audioAppendStart,gopsToAlignWith:segmentInfo.gopsToAlignWith,part:segmentInfo.part},previousSegment=segmentInfo.playlist.segments[segmentInfo.mediaIndex-1];if(previousSegment&&previousSegment.timeline===segment.timeline&&(previousSegment.videoTimingInfo?simpleSegment.baseStartTime=previousSegment.videoTimingInfo.transmuxedDecodeEnd:previousSegment.audioTimingInfo&&(simpleSegment.baseStartTime=previousSegment.audioTimingInfo.transmuxedDecodeEnd)),segment.key){var iv=segment.key.iv||new Uint32Array([0,0,0,segmentInfo.mediaIndex+segmentInfo.playlist.mediaSequence]);simpleSegment.key=this.segmentKey(segment.key),simpleSegment.key.iv=iv}return segment.map&&(simpleSegment.map=this.initSegmentForMap(segment.map)),simpleSegment},_proto.saveTransferStats_=function(stats){this.mediaRequests+=1,stats&&(this.mediaBytesTransferred+=stats.bytesReceived,this.mediaTransferDuration+=stats.roundTripTime)},_proto.saveBandwidthRelatedStats_=function(duration,stats){this.pendingSegment_.byteLength=stats.bytesReceived,duration<.016666666666666666?this.logger_("Ignoring segment's bandwidth because its duration of "+duration+" is less than the min to record 0.016666666666666666"):(this.bandwidth=stats.bandwidth,this.roundTrip=stats.roundTripTime)},_proto.handleTimeout_=function(){this.mediaRequestsTimedout+=1,this.bandwidth=1,this.roundTrip=NaN,this.trigger("bandwidthupdate")},_proto.segmentRequestFinished_=function(error,simpleSegment,result){if(this.callQueue_.length)this.callQueue_.push(this.segmentRequestFinished_.bind(this,error,simpleSegment,result));else if(this.saveTransferStats_(simpleSegment.stats),this.pendingSegment_&&simpleSegment.requestId===this.pendingSegment_.requestId){if(error){if(this.pendingSegment_=null,this.state="READY",error.code===REQUEST_ERRORS_ABORTED)return;return this.pause(),error.code===REQUEST_ERRORS_TIMEOUT?void this.handleTimeout_():(this.mediaRequestsErrored+=1,this.error(error),void this.trigger("error"))}var segmentInfo=this.pendingSegment_;this.saveBandwidthRelatedStats_(segmentInfo.duration,simpleSegment.stats),segmentInfo.endOfAllRequests=simpleSegment.endOfAllRequests,result.gopInfo&&(this.gopBuffer_=function(buffer,gops,replace){if(!gops.length)return buffer;if(replace)return gops.slice();for(var start=gops[0].pts,i=0;i<buffer.length&&!(buffer[i].pts>=start);i++);return buffer.slice(0,i).concat(gops)}(this.gopBuffer_,result.gopInfo,this.safeAppend_)),this.state="APPENDING",this.trigger("appending"),this.waitForAppendsToComplete_(segmentInfo)}},_proto.setTimeMapping_=function(timeline){var timelineMapping=this.syncController_.mappingForTimeline(timeline);null!==timelineMapping&&(this.timeMapping_=timelineMapping)},_proto.updateMediaSecondsLoaded_=function(segment){"number"==typeof segment.start&&"number"==typeof segment.end?this.mediaSecondsLoaded+=segment.end-segment.start:this.mediaSecondsLoaded+=segment.duration},_proto.shouldUpdateTransmuxerTimestampOffset_=function(timestampOffset){return null!==timestampOffset&&("main"===this.loaderType_&&timestampOffset!==this.sourceUpdater_.videoTimestampOffset()||!this.audioDisabled_&&timestampOffset!==this.sourceUpdater_.audioTimestampOffset())},_proto.trueSegmentStart_=function(_ref9){var currentStart=_ref9.currentStart,playlist=_ref9.playlist,mediaIndex=_ref9.mediaIndex,firstVideoFrameTimeForData=_ref9.firstVideoFrameTimeForData,currentVideoTimestampOffset=_ref9.currentVideoTimestampOffset,useVideoTimingInfo=_ref9.useVideoTimingInfo,videoTimingInfo=_ref9.videoTimingInfo,audioTimingInfo=_ref9.audioTimingInfo;if(void 0!==currentStart)return currentStart;if(!useVideoTimingInfo)return audioTimingInfo.start;var previousSegment=playlist.segments[mediaIndex-1];return 0!==mediaIndex&&previousSegment&&void 0!==previousSegment.start&&previousSegment.end===firstVideoFrameTimeForData+currentVideoTimestampOffset?videoTimingInfo.start:firstVideoFrameTimeForData},_proto.waitForAppendsToComplete_=function(segmentInfo){var trackInfo=this.getCurrentMediaInfo_(segmentInfo);if(!trackInfo)return this.error({message:"No starting media returned, likely due to an unsupported media format.",blacklistDuration:1/0}),void this.trigger("error");var hasAudio=trackInfo.hasAudio,hasVideo=trackInfo.hasVideo,isMuxed=trackInfo.isMuxed,waitForVideo="main"===this.loaderType_&&hasVideo,waitForAudio=!this.audioDisabled_&&hasAudio&&!isMuxed;if(segmentInfo.waitingOnAppends=0,!segmentInfo.hasAppendedData_)return segmentInfo.timingInfo||"number"!=typeof segmentInfo.timestampOffset||(this.isPendingTimestampOffset_=!0),segmentInfo.timingInfo={start:0},segmentInfo.waitingOnAppends++,this.isPendingTimestampOffset_||(this.updateSourceBufferTimestampOffset_(segmentInfo),this.processMetadataQueue_()),void this.checkAppendsDone_(segmentInfo);waitForVideo&&segmentInfo.waitingOnAppends++,waitForAudio&&segmentInfo.waitingOnAppends++,waitForVideo&&this.sourceUpdater_.videoQueueCallback(this.checkAppendsDone_.bind(this,segmentInfo)),waitForAudio&&this.sourceUpdater_.audioQueueCallback(this.checkAppendsDone_.bind(this,segmentInfo))},_proto.checkAppendsDone_=function(segmentInfo){this.checkForAbort_(segmentInfo.requestId)||(segmentInfo.waitingOnAppends--,0===segmentInfo.waitingOnAppends&&this.handleAppendsDone_())},_proto.checkForIllegalMediaSwitch=function(trackInfo){var illegalMediaSwitchError=function(loaderType,startingMedia,trackInfo){return"main"===loaderType&&startingMedia&&trackInfo?trackInfo.hasAudio||trackInfo.hasVideo?startingMedia.hasVideo&&!trackInfo.hasVideo?"Only audio found in segment when we expected video. We can't switch to audio only from a stream that had video. To get rid of this message, please add codec information to the manifest.":!startingMedia.hasVideo&&trackInfo.hasVideo?"Video found in segment when we expected only audio. We can't switch to a stream with video from an audio only stream. To get rid of this message, please add codec information to the manifest.":null:"Neither audio nor video found in segment.":null}(this.loaderType_,this.getCurrentMediaInfo_(),trackInfo);return!!illegalMediaSwitchError&&(this.error({message:illegalMediaSwitchError,blacklistDuration:1/0}),this.trigger("error"),!0)},_proto.updateSourceBufferTimestampOffset_=function(segmentInfo){if(null!==segmentInfo.timestampOffset&&"number"==typeof segmentInfo.timingInfo.start&&!segmentInfo.changedTimestampOffset&&"main"===this.loaderType_){var didChange=!1;segmentInfo.timestampOffset-=segmentInfo.timingInfo.start,segmentInfo.changedTimestampOffset=!0,segmentInfo.timestampOffset!==this.sourceUpdater_.videoTimestampOffset()&&(this.sourceUpdater_.videoTimestampOffset(segmentInfo.timestampOffset),didChange=!0),segmentInfo.timestampOffset!==this.sourceUpdater_.audioTimestampOffset()&&(this.sourceUpdater_.audioTimestampOffset(segmentInfo.timestampOffset),didChange=!0),didChange&&this.trigger("timestampoffset")}},_proto.updateTimingInfoEnd_=function(segmentInfo){segmentInfo.timingInfo=segmentInfo.timingInfo||{};var trackInfo=this.getMediaInfo_(),prioritizedTimingInfo="main"===this.loaderType_&&trackInfo&&trackInfo.hasVideo&&segmentInfo.videoTimingInfo?segmentInfo.videoTimingInfo:segmentInfo.audioTimingInfo;prioritizedTimingInfo&&(segmentInfo.timingInfo.end="number"==typeof prioritizedTimingInfo.end?prioritizedTimingInfo.end:prioritizedTimingInfo.start+segmentInfo.duration)},_proto.handleAppendsDone_=function(){if(this.pendingSegment_&&this.trigger("appendsdone"),!this.pendingSegment_)return this.state="READY",void(this.paused()||this.monitorBuffer_());var segmentInfo=this.pendingSegment_;this.updateTimingInfoEnd_(segmentInfo),this.shouldSaveSegmentTimingInfo_&&this.syncController_.saveSegmentTimingInfo({segmentInfo:segmentInfo,shouldSaveTimelineMapping:"main"===this.loaderType_});var segmentDurationMessage=getTroublesomeSegmentDurationMessage(segmentInfo,this.sourceType_);if(segmentDurationMessage&&("warn"===segmentDurationMessage.severity?videojs.log.warn(segmentDurationMessage.message):this.logger_(segmentDurationMessage.message)),this.recordThroughput_(segmentInfo),this.pendingSegment_=null,this.state="READY",!segmentInfo.isSyncRequest||(this.trigger("syncinfoupdate"),segmentInfo.hasAppendedData_)){this.logger_("Appended "+segmentInfoString(segmentInfo)),this.addSegmentMetadataCue_(segmentInfo),this.fetchAtBuffer_=!0,this.currentTimeline_!==segmentInfo.timeline&&(this.timelineChangeController_.lastTimelineChange({type:this.loaderType_,from:this.currentTimeline_,to:segmentInfo.timeline}),"main"!==this.loaderType_||this.audioDisabled_||this.timelineChangeController_.lastTimelineChange({type:"audio",from:this.currentTimeline_,to:segmentInfo.timeline})),this.currentTimeline_=segmentInfo.timeline,this.trigger("syncinfoupdate");var segment=segmentInfo.segment,part=segmentInfo.part,badSegmentGuess=segment.end&&this.currentTime_()-segment.end>3*segmentInfo.playlist.targetDuration,badPartGuess=part&&part.end&&this.currentTime_()-part.end>3*segmentInfo.playlist.partTargetDuration;if(badSegmentGuess||badPartGuess)return this.logger_("bad "+(badSegmentGuess?"segment":"part")+" "+segmentInfoString(segmentInfo)),void this.resetEverything();null!==this.mediaIndex&&this.trigger("bandwidthupdate"),this.trigger("progress"),this.mediaIndex=segmentInfo.mediaIndex,this.partIndex=segmentInfo.partIndex,this.isEndOfStream_(segmentInfo.mediaIndex,segmentInfo.playlist,segmentInfo.partIndex)&&this.endOfStream(),this.trigger("appended"),segmentInfo.hasAppendedData_&&this.mediaAppends++,this.paused()||this.monitorBuffer_()}else this.logger_("Throwing away un-appended sync request "+segmentInfoString(segmentInfo))},_proto.recordThroughput_=function(segmentInfo){if(segmentInfo.duration<.016666666666666666)this.logger_("Ignoring segment's throughput because its duration of "+segmentInfo.duration+" is less than the min to record 0.016666666666666666");else{var rate=this.throughput.rate,segmentProcessingTime=Date.now()-segmentInfo.endOfAllRequests+1,segmentProcessingThroughput=Math.floor(segmentInfo.byteLength/segmentProcessingTime*8*1e3);this.throughput.rate+=(segmentProcessingThroughput-rate)/++this.throughput.count}},_proto.addSegmentMetadataCue_=function(segmentInfo){if(this.segmentMetadataTrack_){var segment=segmentInfo.segment,start=segment.start,end=segment.end;if(finite(start)&&finite(end)){removeCuesFromTrack(start,end,this.segmentMetadataTrack_);var Cue=window.WebKitDataCue||window.VTTCue,value={custom:segment.custom,dateTimeObject:segment.dateTimeObject,dateTimeString:segment.dateTimeString,bandwidth:segmentInfo.playlist.attributes.BANDWIDTH,resolution:segmentInfo.playlist.attributes.RESOLUTION,codecs:segmentInfo.playlist.attributes.CODECS,byteLength:segmentInfo.byteLength,uri:segmentInfo.uri,timeline:segmentInfo.timeline,playlist:segmentInfo.playlist.id,start:start,end:end},cue=new Cue(start,end,JSON.stringify(value));cue.value=value,this.segmentMetadataTrack_.addCue(cue)}}},SegmentLoader}(videojs.EventTarget);function noop(){}var Vhs$1,toTitleCase=function(string){return"string"!=typeof string?string:string.replace(/./,(function(w){return w.toUpperCase()}))},bufferTypes=["video","audio"],_updating=function(type,sourceUpdater){var sourceBuffer=sourceUpdater[type+"Buffer"];return sourceBuffer&&sourceBuffer.updating||sourceUpdater.queuePending[type]},shiftQueue=function shiftQueue(type,sourceUpdater){if(0!==sourceUpdater.queue.length){var queueIndex=0,queueEntry=sourceUpdater.queue[queueIndex];if("mediaSource"!==queueEntry.type){if("mediaSource"!==type&&sourceUpdater.ready()&&"closed"!==sourceUpdater.mediaSource.readyState&&!_updating(type,sourceUpdater)){if(queueEntry.type!==type){if(queueIndex=function(type,queue){for(var i=0;i<queue.length;i++){var queueEntry=queue[i];if("mediaSource"===queueEntry.type)return null;if(queueEntry.type===type)return i}return null}(type,sourceUpdater.queue),null===queueIndex)return;queueEntry=sourceUpdater.queue[queueIndex]}return sourceUpdater.queue.splice(queueIndex,1),sourceUpdater.queuePending[type]=queueEntry,queueEntry.action(type,sourceUpdater),queueEntry.doneFn?void 0:(sourceUpdater.queuePending[type]=null,void shiftQueue(type,sourceUpdater))}}else sourceUpdater.updating()||"closed"===sourceUpdater.mediaSource.readyState||(sourceUpdater.queue.shift(),queueEntry.action(sourceUpdater),queueEntry.doneFn&&queueEntry.doneFn(),shiftQueue("audio",sourceUpdater),shiftQueue("video",sourceUpdater))}},cleanupBuffer=function(type,sourceUpdater){var buffer=sourceUpdater[type+"Buffer"],titleType=toTitleCase(type);buffer&&(buffer.removeEventListener("updateend",sourceUpdater["on"+titleType+"UpdateEnd_"]),buffer.removeEventListener("error",sourceUpdater["on"+titleType+"Error_"]),sourceUpdater.codecs[type]=null,sourceUpdater[type+"Buffer"]=null)},inSourceBuffers=function(mediaSource,sourceBuffer){return mediaSource&&sourceBuffer&&-1!==Array.prototype.indexOf.call(mediaSource.sourceBuffers,sourceBuffer)},actions_appendBuffer=function(bytes,segmentInfo,onError){return function(type,sourceUpdater){var sourceBuffer=sourceUpdater[type+"Buffer"];if(inSourceBuffers(sourceUpdater.mediaSource,sourceBuffer)){sourceUpdater.logger_("Appending segment "+segmentInfo.mediaIndex+"'s "+bytes.length+" bytes to "+type+"Buffer");try{sourceBuffer.appendBuffer(bytes)}catch(e){sourceUpdater.logger_("Error with code "+e.code+" "+(22===e.code?"(QUOTA_EXCEEDED_ERR) ":"")+"when appending segment "+segmentInfo.mediaIndex+" to "+type+"Buffer"),sourceUpdater.queuePending[type]=null,onError(e)}}}},actions_remove=function(start,end){return function(type,sourceUpdater){var sourceBuffer=sourceUpdater[type+"Buffer"];if(inSourceBuffers(sourceUpdater.mediaSource,sourceBuffer)){sourceUpdater.logger_("Removing "+start+" to "+end+" from "+type+"Buffer");try{sourceBuffer.remove(start,end)}catch(e){sourceUpdater.logger_("Remove "+start+" to "+end+" from "+type+"Buffer failed")}}}},actions_timestampOffset=function(offset){return function(type,sourceUpdater){var sourceBuffer=sourceUpdater[type+"Buffer"];inSourceBuffers(sourceUpdater.mediaSource,sourceBuffer)&&(sourceUpdater.logger_("Setting "+type+"timestampOffset to "+offset),sourceBuffer.timestampOffset=offset)}},actions_callback=function(_callback){return function(type,sourceUpdater){_callback()}},actions_endOfStream=function(error){return function(sourceUpdater){if("open"===sourceUpdater.mediaSource.readyState){sourceUpdater.logger_("Calling mediaSource endOfStream("+(error||"")+")");try{sourceUpdater.mediaSource.endOfStream(error)}catch(e){videojs.log.warn("Failed to call media source endOfStream",e)}}}},actions_duration=function(_duration){return function(sourceUpdater){sourceUpdater.logger_("Setting mediaSource duration to "+_duration);try{sourceUpdater.mediaSource.duration=_duration}catch(e){videojs.log.warn("Failed to set media source duration",e)}}},actions_abort=function(){return function(type,sourceUpdater){if("open"===sourceUpdater.mediaSource.readyState){var sourceBuffer=sourceUpdater[type+"Buffer"];if(inSourceBuffers(sourceUpdater.mediaSource,sourceBuffer)){sourceUpdater.logger_("calling abort on "+type+"Buffer");try{sourceBuffer.abort()}catch(e){videojs.log.warn("Failed to abort on "+type+"Buffer",e)}}}}},actions_addSourceBuffer=function(type,codec){return function(sourceUpdater){var titleType=toTitleCase(type),mime=getMimeForCodec(codec);sourceUpdater.logger_("Adding "+type+"Buffer with codec "+codec+" to mediaSource");var sourceBuffer=sourceUpdater.mediaSource.addSourceBuffer(mime);sourceBuffer.addEventListener("updateend",sourceUpdater["on"+titleType+"UpdateEnd_"]),sourceBuffer.addEventListener("error",sourceUpdater["on"+titleType+"Error_"]),sourceUpdater.codecs[type]=codec,sourceUpdater[type+"Buffer"]=sourceBuffer}},actions_removeSourceBuffer=function(type){return function(sourceUpdater){var sourceBuffer=sourceUpdater[type+"Buffer"];if(cleanupBuffer(type,sourceUpdater),inSourceBuffers(sourceUpdater.mediaSource,sourceBuffer)){sourceUpdater.logger_("Removing "+type+"Buffer with codec "+sourceUpdater.codecs[type]+" from mediaSource");try{sourceUpdater.mediaSource.removeSourceBuffer(sourceBuffer)}catch(e){videojs.log.warn("Failed to removeSourceBuffer "+type+"Buffer",e)}}}},actions_changeType=function(codec){return function(type,sourceUpdater){var sourceBuffer=sourceUpdater[type+"Buffer"],mime=getMimeForCodec(codec);inSourceBuffers(sourceUpdater.mediaSource,sourceBuffer)&&sourceUpdater.codecs[type]!==codec&&(sourceUpdater.logger_("changing "+type+"Buffer codec from "+sourceUpdater.codecs[type]+" to "+codec),sourceBuffer.changeType(mime),sourceUpdater.codecs[type]=codec)}},pushQueue=function(_ref){var type=_ref.type,sourceUpdater=_ref.sourceUpdater,action=_ref.action,doneFn=_ref.doneFn,name=_ref.name;sourceUpdater.queue.push({type:type,action:action,doneFn:doneFn,name:name}),shiftQueue(type,sourceUpdater)},onUpdateend=function(type,sourceUpdater){return function(e){if(sourceUpdater.queuePending[type]){var doneFn=sourceUpdater.queuePending[type].doneFn;sourceUpdater.queuePending[type]=null,doneFn&&doneFn(sourceUpdater[type+"Error_"])}shiftQueue(type,sourceUpdater)}},SourceUpdater=function(_videojs$EventTarget){function SourceUpdater(mediaSource){var _this;return(_this=_videojs$EventTarget.call(this)||this).mediaSource=mediaSource,_this.sourceopenListener_=function(){return shiftQueue("mediaSource",assertThisInitialized(_this))},_this.mediaSource.addEventListener("sourceopen",_this.sourceopenListener_),_this.logger_=logger("SourceUpdater"),_this.audioTimestampOffset_=0,_this.videoTimestampOffset_=0,_this.queue=[],_this.queuePending={audio:null,video:null},_this.delayedAudioAppendQueue_=[],_this.videoAppendQueued_=!1,_this.codecs={},_this.onVideoUpdateEnd_=onUpdateend("video",assertThisInitialized(_this)),_this.onAudioUpdateEnd_=onUpdateend("audio",assertThisInitialized(_this)),_this.onVideoError_=function(e){_this.videoError_=e},_this.onAudioError_=function(e){_this.audioError_=e},_this.createdSourceBuffers_=!1,_this.initializedEme_=!1,_this.triggeredReady_=!1,_this}inheritsLoose(SourceUpdater,_videojs$EventTarget);var _proto=SourceUpdater.prototype;return _proto.initializedEme=function(){this.initializedEme_=!0,this.triggerReady()},_proto.hasCreatedSourceBuffers=function(){return this.createdSourceBuffers_},_proto.hasInitializedAnyEme=function(){return this.initializedEme_},_proto.ready=function(){return this.hasCreatedSourceBuffers()&&this.hasInitializedAnyEme()},_proto.createSourceBuffers=function(codecs){this.hasCreatedSourceBuffers()||(this.addOrChangeSourceBuffers(codecs),this.createdSourceBuffers_=!0,this.trigger("createdsourcebuffers"),this.triggerReady())},_proto.triggerReady=function(){this.ready()&&!this.triggeredReady_&&(this.triggeredReady_=!0,this.trigger("ready"))},_proto.addSourceBuffer=function(type,codec){pushQueue({type:"mediaSource",sourceUpdater:this,action:actions_addSourceBuffer(type,codec),name:"addSourceBuffer"})},_proto.abort=function(type){pushQueue({type:type,sourceUpdater:this,action:actions_abort(type),name:"abort"})},_proto.removeSourceBuffer=function(type){this.canRemoveSourceBuffer()?pushQueue({type:"mediaSource",sourceUpdater:this,action:actions_removeSourceBuffer(type),name:"removeSourceBuffer"}):videojs.log.error("removeSourceBuffer is not supported!")},_proto.canRemoveSourceBuffer=function(){return!videojs.browser.IE_VERSION&&!videojs.browser.IS_FIREFOX&&window.MediaSource&&window.MediaSource.prototype&&"function"==typeof window.MediaSource.prototype.removeSourceBuffer},SourceUpdater.canChangeType=function(){return window.SourceBuffer&&window.SourceBuffer.prototype&&"function"==typeof window.SourceBuffer.prototype.changeType},_proto.canChangeType=function(){return this.constructor.canChangeType()},_proto.changeType=function(type,codec){this.canChangeType()?pushQueue({type:type,sourceUpdater:this,action:actions_changeType(codec),name:"changeType"}):videojs.log.error("changeType is not supported!")},_proto.addOrChangeSourceBuffers=function(codecs){var _this2=this;if(!codecs||"object"!=typeof codecs||0===Object.keys(codecs).length)throw new Error("Cannot addOrChangeSourceBuffers to undefined codecs");Object.keys(codecs).forEach((function(type){var codec=codecs[type];if(!_this2.hasCreatedSourceBuffers())return _this2.addSourceBuffer(type,codec);_this2.canChangeType()&&_this2.changeType(type,codec)}))},_proto.appendBuffer=function(options,doneFn){var _this3=this,segmentInfo=options.segmentInfo,type=options.type,bytes=options.bytes;if(this.processedAppend_=!0,"audio"===type&&this.videoBuffer&&!this.videoAppendQueued_)return this.delayedAudioAppendQueue_.push([options,doneFn]),void this.logger_("delayed audio append of "+bytes.length+" until video append");if(pushQueue({type:type,sourceUpdater:this,action:actions_appendBuffer(bytes,segmentInfo||{mediaIndex:-1},doneFn),doneFn:doneFn,name:"appendBuffer"}),"video"===type){if(this.videoAppendQueued_=!0,!this.delayedAudioAppendQueue_.length)return;var queue=this.delayedAudioAppendQueue_.slice();this.logger_("queuing delayed audio "+queue.length+" appendBuffers"),this.delayedAudioAppendQueue_.length=0,queue.forEach((function(que){_this3.appendBuffer.apply(_this3,que)}))}},_proto.audioBuffered=function(){return inSourceBuffers(this.mediaSource,this.audioBuffer)&&this.audioBuffer.buffered?this.audioBuffer.buffered:videojs.createTimeRange()},_proto.videoBuffered=function(){return inSourceBuffers(this.mediaSource,this.videoBuffer)&&this.videoBuffer.buffered?this.videoBuffer.buffered:videojs.createTimeRange()},_proto.buffered=function(){var video=inSourceBuffers(this.mediaSource,this.videoBuffer)?this.videoBuffer:null,audio=inSourceBuffers(this.mediaSource,this.audioBuffer)?this.audioBuffer:null;return audio&&!video?this.audioBuffered():video&&!audio?this.videoBuffered():function(bufferA,bufferB){var start=null,end=null,arity=0,extents=[],ranges=[];if(!(bufferA&&bufferA.length&&bufferB&&bufferB.length))return videojs.createTimeRange();for(var count=bufferA.length;count--;)extents.push({time:bufferA.start(count),type:"start"}),extents.push({time:bufferA.end(count),type:"end"});for(count=bufferB.length;count--;)extents.push({time:bufferB.start(count),type:"start"}),extents.push({time:bufferB.end(count),type:"end"});for(extents.sort((function(a,b){return a.time-b.time})),count=0;count<extents.length;count++)"start"===extents[count].type?2==++arity&&(start=extents[count].time):"end"===extents[count].type&&1==--arity&&(end=extents[count].time),null!==start&&null!==end&&(ranges.push([start,end]),start=null,end=null);return videojs.createTimeRanges(ranges)}(this.audioBuffered(),this.videoBuffered())},_proto.setDuration=function(duration,doneFn){void 0===doneFn&&(doneFn=noop),pushQueue({type:"mediaSource",sourceUpdater:this,action:actions_duration(duration),name:"duration",doneFn:doneFn})},_proto.endOfStream=function(error,doneFn){void 0===error&&(error=null),void 0===doneFn&&(doneFn=noop),"string"!=typeof error&&(error=void 0),pushQueue({type:"mediaSource",sourceUpdater:this,action:actions_endOfStream(error),name:"endOfStream",doneFn:doneFn})},_proto.removeAudio=function(start,end,done){void 0===done&&(done=noop),this.audioBuffered().length&&0!==this.audioBuffered().end(0)?pushQueue({type:"audio",sourceUpdater:this,action:actions_remove(start,end),doneFn:done,name:"remove"}):done()},_proto.removeVideo=function(start,end,done){void 0===done&&(done=noop),this.videoBuffered().length&&0!==this.videoBuffered().end(0)?pushQueue({type:"video",sourceUpdater:this,action:actions_remove(start,end),doneFn:done,name:"remove"}):done()},_proto.updating=function(){return!(!_updating("audio",this)&&!_updating("video",this))},_proto.audioTimestampOffset=function(offset){return void 0!==offset&&this.audioBuffer&&this.audioTimestampOffset_!==offset&&(pushQueue({type:"audio",sourceUpdater:this,action:actions_timestampOffset(offset),name:"timestampOffset"}),this.audioTimestampOffset_=offset),this.audioTimestampOffset_},_proto.videoTimestampOffset=function(offset){return void 0!==offset&&this.videoBuffer&&this.videoTimestampOffset!==offset&&(pushQueue({type:"video",sourceUpdater:this,action:actions_timestampOffset(offset),name:"timestampOffset"}),this.videoTimestampOffset_=offset),this.videoTimestampOffset_},_proto.audioQueueCallback=function(callback){this.audioBuffer&&pushQueue({type:"audio",sourceUpdater:this,action:actions_callback(callback),name:"callback"})},_proto.videoQueueCallback=function(callback){this.videoBuffer&&pushQueue({type:"video",sourceUpdater:this,action:actions_callback(callback),name:"callback"})},_proto.dispose=function(){var _this4=this;this.trigger("dispose"),bufferTypes.forEach((function(type){_this4.abort(type),_this4.canRemoveSourceBuffer()?_this4.removeSourceBuffer(type):_this4[type+"QueueCallback"]((function(){return cleanupBuffer(type,_this4)}))})),this.videoAppendQueued_=!1,this.delayedAudioAppendQueue_.length=0,this.sourceopenListener_&&this.mediaSource.removeEventListener("sourceopen",this.sourceopenListener_),this.off()},SourceUpdater}(videojs.EventTarget),uint8ToUtf8=function(uintArray){return decodeURIComponent(escape(String.fromCharCode.apply(null,uintArray)))},VTT_LINE_TERMINATORS=new Uint8Array("\n\n".split("").map((function(_char3){return _char3.charCodeAt(0)}))),VTTSegmentLoader=function(_SegmentLoader){function VTTSegmentLoader(settings,options){var _this;return void 0===options&&(options={}),(_this=_SegmentLoader.call(this,settings,options)||this).mediaSource_=null,_this.subtitlesTrack_=null,_this.loaderType_="subtitle",_this.featuresNativeTextTracks_=settings.featuresNativeTextTracks,_this.shouldSaveSegmentTimingInfo_=!1,_this}inheritsLoose(VTTSegmentLoader,_SegmentLoader);var _proto=VTTSegmentLoader.prototype;return _proto.createTransmuxer_=function(){return null},_proto.buffered_=function(){if(!this.subtitlesTrack_||!this.subtitlesTrack_.cues||!this.subtitlesTrack_.cues.length)return videojs.createTimeRanges();var cues=this.subtitlesTrack_.cues,start=cues[0].startTime,end=cues[cues.length-1].startTime;return videojs.createTimeRanges([[start,end]])},_proto.initSegmentForMap=function(map,set){if(void 0===set&&(set=!1),!map)return null;var id=initSegmentId(map),storedMap=this.initSegments_[id];if(set&&!storedMap&&map.bytes){var combinedByteLength=VTT_LINE_TERMINATORS.byteLength+map.bytes.byteLength,combinedSegment=new Uint8Array(combinedByteLength);combinedSegment.set(map.bytes),combinedSegment.set(VTT_LINE_TERMINATORS,map.bytes.byteLength),this.initSegments_[id]=storedMap={resolvedUri:map.resolvedUri,byterange:map.byterange,bytes:combinedSegment}}return storedMap||map},_proto.couldBeginLoading_=function(){return this.playlist_&&this.subtitlesTrack_&&!this.paused()},_proto.init_=function(){return this.state="READY",this.resetEverything(),this.monitorBuffer_()},_proto.track=function(_track){return void 0===_track||(this.subtitlesTrack_=_track,"INIT"===this.state&&this.couldBeginLoading_()&&this.init_()),this.subtitlesTrack_},_proto.remove=function(start,end){removeCuesFromTrack(start,end,this.subtitlesTrack_)},_proto.fillBuffer_=function(){var _this2=this,segmentInfo=this.chooseNextRequest_();if(segmentInfo){if(null===this.syncController_.timestampOffsetForTimeline(segmentInfo.timeline)){return this.syncController_.one("timestampoffset",(function(){_this2.state="READY",_this2.paused()||_this2.monitorBuffer_()})),void(this.state="WAITING_ON_TIMELINE")}this.loadSegment_(segmentInfo)}},_proto.timestampOffsetForSegment_=function(){return null},_proto.chooseNextRequest_=function(){return this.skipEmptySegments_(_SegmentLoader.prototype.chooseNextRequest_.call(this))},_proto.skipEmptySegments_=function(segmentInfo){for(;segmentInfo&&segmentInfo.segment.empty;){if(segmentInfo.mediaIndex+1>=segmentInfo.playlist.segments.length){segmentInfo=null;break}segmentInfo=this.generateSegmentInfo_({playlist:segmentInfo.playlist,mediaIndex:segmentInfo.mediaIndex+1,startOfSegment:segmentInfo.startOfSegment+segmentInfo.duration,isSyncRequest:segmentInfo.isSyncRequest})}return segmentInfo},_proto.stopForError=function(error){this.error(error),this.state="READY",this.pause(),this.trigger("error")},_proto.segmentRequestFinished_=function(error,simpleSegment,result){var _this3=this;if(this.subtitlesTrack_){if(this.saveTransferStats_(simpleSegment.stats),!this.pendingSegment_)return this.state="READY",void(this.mediaRequestsAborted+=1);if(error)return error.code===REQUEST_ERRORS_TIMEOUT&&this.handleTimeout_(),error.code===REQUEST_ERRORS_ABORTED?this.mediaRequestsAborted+=1:this.mediaRequestsErrored+=1,void this.stopForError(error);var segmentInfo=this.pendingSegment_;this.saveBandwidthRelatedStats_(segmentInfo.duration,simpleSegment.stats),this.state="APPENDING",this.trigger("appending");var segment=segmentInfo.segment;if(segment.map&&(segment.map.bytes=simpleSegment.map.bytes),segmentInfo.bytes=simpleSegment.bytes,"function"!=typeof window.WebVTT&&this.subtitlesTrack_&&this.subtitlesTrack_.tech_){var loadHandler,errorHandler=function(){_this3.subtitlesTrack_.tech_.off("vttjsloaded",loadHandler),_this3.stopForError({message:"Error loading vtt.js"})};return loadHandler=function(){_this3.subtitlesTrack_.tech_.off("vttjserror",errorHandler),_this3.segmentRequestFinished_(error,simpleSegment,result)},this.state="WAITING_ON_VTTJS",this.subtitlesTrack_.tech_.one("vttjsloaded",loadHandler),void this.subtitlesTrack_.tech_.one("vttjserror",errorHandler)}segment.requested=!0;try{this.parseVTTCues_(segmentInfo)}catch(e){return void this.stopForError({message:e.message})}if(this.updateTimeMapping_(segmentInfo,this.syncController_.timelines[segmentInfo.timeline],this.playlist_),segmentInfo.cues.length?segmentInfo.timingInfo={start:segmentInfo.cues[0].startTime,end:segmentInfo.cues[segmentInfo.cues.length-1].endTime}:segmentInfo.timingInfo={start:segmentInfo.startOfSegment,end:segmentInfo.startOfSegment+segmentInfo.duration},segmentInfo.isSyncRequest)return this.trigger("syncinfoupdate"),this.pendingSegment_=null,void(this.state="READY");segmentInfo.byteLength=segmentInfo.bytes.byteLength,this.mediaSecondsLoaded+=segment.duration,segmentInfo.cues.forEach((function(cue){_this3.subtitlesTrack_.addCue(_this3.featuresNativeTextTracks_?new window.VTTCue(cue.startTime,cue.endTime,cue.text):cue)})),function(track){var cues=track.cues;if(cues)for(var i=0;i<cues.length;i++){for(var duplicates=[],occurrences=0,j=0;j<cues.length;j++)cues[i].startTime===cues[j].startTime&&cues[i].endTime===cues[j].endTime&&cues[i].text===cues[j].text&&++occurrences>1&&duplicates.push(cues[j]);duplicates.length&&duplicates.forEach((function(dupe){return track.removeCue(dupe)}))}}(this.subtitlesTrack_),this.handleAppendsDone_()}else this.state="READY"},_proto.handleData_=function(){},_proto.updateTimingInfoEnd_=function(){},_proto.parseVTTCues_=function(segmentInfo){var decoder,decodeBytesToString=!1;"function"==typeof window.TextDecoder?decoder=new window.TextDecoder("utf8"):(decoder=window.WebVTT.StringDecoder(),decodeBytesToString=!0);var parser=new window.WebVTT.Parser(window,window.vttjs,decoder);if(segmentInfo.cues=[],segmentInfo.timestampmap={MPEGTS:0,LOCAL:0},parser.oncue=segmentInfo.cues.push.bind(segmentInfo.cues),parser.ontimestampmap=function(map){segmentInfo.timestampmap=map},parser.onparsingerror=function(error){videojs.log.warn("Error encountered when parsing cues: "+error.message)},segmentInfo.segment.map){var mapData=segmentInfo.segment.map.bytes;decodeBytesToString&&(mapData=uint8ToUtf8(mapData)),parser.parse(mapData)}var segmentData=segmentInfo.bytes;decodeBytesToString&&(segmentData=uint8ToUtf8(segmentData)),parser.parse(segmentData),parser.flush()},_proto.updateTimeMapping_=function(segmentInfo,mappingObj,playlist){var segment=segmentInfo.segment;if(mappingObj)if(segmentInfo.cues.length){var timestampmap=segmentInfo.timestampmap,diff=timestampmap.MPEGTS/clock_1-timestampmap.LOCAL+mappingObj.mapping;if(segmentInfo.cues.forEach((function(cue){cue.startTime+=diff,cue.endTime+=diff})),!playlist.syncInfo){var firstStart=segmentInfo.cues[0].startTime,lastStart=segmentInfo.cues[segmentInfo.cues.length-1].startTime;playlist.syncInfo={mediaSequence:playlist.mediaSequence+segmentInfo.mediaIndex,time:Math.min(firstStart,lastStart-segment.duration)}}}else segment.empty=!0},VTTSegmentLoader}(SegmentLoader),findAdCue=function(track,mediaTime){for(var cues=track.cues,i=0;i<cues.length;i++){var cue=cues[i];if(mediaTime>=cue.adStartTime&&mediaTime<=cue.adEndTime)return cue}return null},syncPointStrategies=[{name:"VOD",run:function(syncController,playlist,duration,currentTimeline,currentTime){if(duration!==1/0){return{time:0,segmentIndex:0,partIndex:null}}return null}},{name:"ProgramDateTime",run:function(syncController,playlist,duration,currentTimeline,currentTime){if(!Object.keys(syncController.timelineToDatetimeMappings).length)return null;var syncPoint=null,lastDistance=null,partsAndSegments=getPartsAndSegments(playlist);currentTime=currentTime||0;for(var i=0;i<partsAndSegments.length;i++){var partAndSegment=partsAndSegments[playlist.endList||0===currentTime?i:partsAndSegments.length-(i+1)],segment=partAndSegment.segment,datetimeMapping=syncController.timelineToDatetimeMappings[segment.timeline];if(datetimeMapping&&segment.dateTimeObject){var start=segment.dateTimeObject.getTime()/1e3+datetimeMapping;if(segment.parts&&"number"==typeof partAndSegment.partIndex)for(var z=0;z<partAndSegment.partIndex;z++)start+=segment.parts[z].duration;var distance=Math.abs(currentTime-start);if(null!==lastDistance&&(0===distance||lastDistance<distance))break;lastDistance=distance,syncPoint={time:start,segmentIndex:partAndSegment.segmentIndex,partIndex:partAndSegment.partIndex}}}return syncPoint}},{name:"Segment",run:function(syncController,playlist,duration,currentTimeline,currentTime){var syncPoint=null,lastDistance=null;currentTime=currentTime||0;for(var partsAndSegments=getPartsAndSegments(playlist),i=0;i<partsAndSegments.length;i++){var partAndSegment=partsAndSegments[playlist.endList||0===currentTime?i:partsAndSegments.length-(i+1)],segment=partAndSegment.segment,start=partAndSegment.part&&partAndSegment.part.start||segment&&segment.start;if(segment.timeline===currentTimeline&&void 0!==start){var distance=Math.abs(currentTime-start);if(null!==lastDistance&&lastDistance<distance)break;(!syncPoint||null===lastDistance||lastDistance>=distance)&&(lastDistance=distance,syncPoint={time:start,segmentIndex:partAndSegment.segmentIndex,partIndex:partAndSegment.partIndex})}}return syncPoint}},{name:"Discontinuity",run:function(syncController,playlist,duration,currentTimeline,currentTime){var syncPoint=null;if(currentTime=currentTime||0,playlist.discontinuityStarts&&playlist.discontinuityStarts.length)for(var lastDistance=null,i=0;i<playlist.discontinuityStarts.length;i++){var segmentIndex=playlist.discontinuityStarts[i],discontinuity=playlist.discontinuitySequence+i+1,discontinuitySync=syncController.discontinuities[discontinuity];if(discontinuitySync){var distance=Math.abs(currentTime-discontinuitySync.time);if(null!==lastDistance&&lastDistance<distance)break;(!syncPoint||null===lastDistance||lastDistance>=distance)&&(lastDistance=distance,syncPoint={time:discontinuitySync.time,segmentIndex:segmentIndex,partIndex:null})}}return syncPoint}},{name:"Playlist",run:function(syncController,playlist,duration,currentTimeline,currentTime){return playlist.syncInfo?{time:playlist.syncInfo.time,segmentIndex:playlist.syncInfo.mediaSequence-playlist.mediaSequence,partIndex:null}:null}}],SyncController=function(_videojs$EventTarget){function SyncController(options){var _this;return(_this=_videojs$EventTarget.call(this)||this).timelines=[],_this.discontinuities=[],_this.timelineToDatetimeMappings={},_this.logger_=logger("SyncController"),_this}inheritsLoose(SyncController,_videojs$EventTarget);var _proto=SyncController.prototype;return _proto.getSyncPoint=function(playlist,duration,currentTimeline,currentTime){var syncPoints=this.runStrategies_(playlist,duration,currentTimeline,currentTime);return syncPoints.length?this.selectSyncPoint_(syncPoints,{key:"time",value:currentTime}):null},_proto.getExpiredTime=function(playlist,duration){if(!playlist||!playlist.segments)return null;var syncPoints=this.runStrategies_(playlist,duration,playlist.discontinuitySequence,0);if(!syncPoints.length)return null;var syncPoint=this.selectSyncPoint_(syncPoints,{key:"segmentIndex",value:0});return syncPoint.segmentIndex>0&&(syncPoint.time*=-1),Math.abs(syncPoint.time+sumDurations({defaultDuration:playlist.targetDuration,durationList:playlist.segments,startIndex:syncPoint.segmentIndex,endIndex:0}))},_proto.runStrategies_=function(playlist,duration,currentTimeline,currentTime){for(var syncPoints=[],i=0;i<syncPointStrategies.length;i++){var strategy=syncPointStrategies[i],syncPoint=strategy.run(this,playlist,duration,currentTimeline,currentTime);syncPoint&&(syncPoint.strategy=strategy.name,syncPoints.push({strategy:strategy.name,syncPoint:syncPoint}))}return syncPoints},_proto.selectSyncPoint_=function(syncPoints,target){for(var bestSyncPoint=syncPoints[0].syncPoint,bestDistance=Math.abs(syncPoints[0].syncPoint[target.key]-target.value),bestStrategy=syncPoints[0].strategy,i=1;i<syncPoints.length;i++){var newDistance=Math.abs(syncPoints[i].syncPoint[target.key]-target.value);newDistance<bestDistance&&(bestDistance=newDistance,bestSyncPoint=syncPoints[i].syncPoint,bestStrategy=syncPoints[i].strategy)}return this.logger_("syncPoint for ["+target.key+": "+target.value+"] chosen with strategy ["+bestStrategy+"]: [time:"+bestSyncPoint.time+", segmentIndex:"+bestSyncPoint.segmentIndex+("number"==typeof bestSyncPoint.partIndex?",partIndex:"+bestSyncPoint.partIndex:"")+"]"),bestSyncPoint},_proto.saveExpiredSegmentInfo=function(oldPlaylist,newPlaylist){var mediaSequenceDiff=newPlaylist.mediaSequence-oldPlaylist.mediaSequence;if(mediaSequenceDiff>86400)videojs.log.warn("Not saving expired segment info. Media sequence gap "+mediaSequenceDiff+" is too large.");else for(var i=mediaSequenceDiff-1;i>=0;i--){var lastRemovedSegment=oldPlaylist.segments[i];if(lastRemovedSegment&&void 0!==lastRemovedSegment.start){newPlaylist.syncInfo={mediaSequence:oldPlaylist.mediaSequence+i,time:lastRemovedSegment.start},this.logger_("playlist refresh sync: [time:"+newPlaylist.syncInfo.time+", mediaSequence: "+newPlaylist.syncInfo.mediaSequence+"]"),this.trigger("syncinfoupdate");break}}},_proto.setDateTimeMappingForStart=function(playlist){if(this.timelineToDatetimeMappings={},playlist.segments&&playlist.segments.length&&playlist.segments[0].dateTimeObject){var firstSegment=playlist.segments[0],playlistTimestamp=firstSegment.dateTimeObject.getTime()/1e3;this.timelineToDatetimeMappings[firstSegment.timeline]=-playlistTimestamp}},_proto.saveSegmentTimingInfo=function(_ref){var segmentInfo=_ref.segmentInfo,shouldSaveTimelineMapping=_ref.shouldSaveTimelineMapping,didCalculateSegmentTimeMapping=this.calculateSegmentTimeMapping_(segmentInfo,segmentInfo.timingInfo,shouldSaveTimelineMapping),segment=segmentInfo.segment;didCalculateSegmentTimeMapping&&(this.saveDiscontinuitySyncInfo_(segmentInfo),segmentInfo.playlist.syncInfo||(segmentInfo.playlist.syncInfo={mediaSequence:segmentInfo.playlist.mediaSequence+segmentInfo.mediaIndex,time:segment.start}));var dateTime=segment.dateTimeObject;segment.discontinuity&&shouldSaveTimelineMapping&&dateTime&&(this.timelineToDatetimeMappings[segment.timeline]=-dateTime.getTime()/1e3)},_proto.timestampOffsetForTimeline=function(timeline){return void 0===this.timelines[timeline]?null:this.timelines[timeline].time},_proto.mappingForTimeline=function(timeline){return void 0===this.timelines[timeline]?null:this.timelines[timeline].mapping},_proto.calculateSegmentTimeMapping_=function(segmentInfo,timingInfo,shouldSaveTimelineMapping){var start,end,segment=segmentInfo.segment,part=segmentInfo.part,mappingObj=this.timelines[segmentInfo.timeline];if("number"==typeof segmentInfo.timestampOffset)mappingObj={time:segmentInfo.startOfSegment,mapping:segmentInfo.startOfSegment-timingInfo.start},shouldSaveTimelineMapping&&(this.timelines[segmentInfo.timeline]=mappingObj,this.trigger("timestampoffset"),this.logger_("time mapping for timeline "+segmentInfo.timeline+": [time: "+mappingObj.time+"] [mapping: "+mappingObj.mapping+"]")),start=segmentInfo.startOfSegment,end=timingInfo.end+mappingObj.mapping;else{if(!mappingObj)return!1;start=timingInfo.start+mappingObj.mapping,end=timingInfo.end+mappingObj.mapping}return part&&(part.start=start,part.end=end),(!segment.start||start<segment.start)&&(segment.start=start),segment.end=end,!0},_proto.saveDiscontinuitySyncInfo_=function(segmentInfo){var playlist=segmentInfo.playlist,segment=segmentInfo.segment;if(segment.discontinuity)this.discontinuities[segment.timeline]={time:segment.start,accuracy:0};else if(playlist.discontinuityStarts&&playlist.discontinuityStarts.length)for(var i=0;i<playlist.discontinuityStarts.length;i++){var segmentIndex=playlist.discontinuityStarts[i],discontinuity=playlist.discontinuitySequence+i+1,mediaIndexDiff=segmentIndex-segmentInfo.mediaIndex,accuracy=Math.abs(mediaIndexDiff);if(!this.discontinuities[discontinuity]||this.discontinuities[discontinuity].accuracy>accuracy){var time=void 0;time=mediaIndexDiff<0?segment.start-sumDurations({defaultDuration:playlist.targetDuration,durationList:playlist.segments,startIndex:segmentInfo.mediaIndex,endIndex:segmentIndex}):segment.end+sumDurations({defaultDuration:playlist.targetDuration,durationList:playlist.segments,startIndex:segmentInfo.mediaIndex+1,endIndex:segmentIndex}),this.discontinuities[discontinuity]={time:time,accuracy:accuracy}}}},_proto.dispose=function(){this.trigger("dispose"),this.off()},SyncController}(videojs.EventTarget),TimelineChangeController=function(_videojs$EventTarget){function TimelineChangeController(){var _this;return(_this=_videojs$EventTarget.call(this)||this).pendingTimelineChanges_={},_this.lastTimelineChanges_={},_this}inheritsLoose(TimelineChangeController,_videojs$EventTarget);var _proto=TimelineChangeController.prototype;return _proto.clearPendingTimelineChange=function(type){this.pendingTimelineChanges_[type]=null,this.trigger("pendingtimelinechange")},_proto.pendingTimelineChange=function(_ref){var type=_ref.type,from=_ref.from,to=_ref.to;return"number"==typeof from&&"number"==typeof to&&(this.pendingTimelineChanges_[type]={type:type,from:from,to:to},this.trigger("pendingtimelinechange")),this.pendingTimelineChanges_[type]},_proto.lastTimelineChange=function(_ref2){var type=_ref2.type,from=_ref2.from,to=_ref2.to;return"number"==typeof from&&"number"==typeof to&&(this.lastTimelineChanges_[type]={type:type,from:from,to:to},delete this.pendingTimelineChanges_[type],this.trigger("timelinechange")),this.lastTimelineChanges_[type]},_proto.dispose=function(){this.trigger("dispose"),this.pendingTimelineChanges_={},this.lastTimelineChanges_={},this.off()},TimelineChangeController}(videojs.EventTarget),workerCode=transform(getWorkerString((function(){function createCommonjsModule(fn,basedir,module){return fn(module={path:basedir,exports:{},require:function(path,base){return function(){throw new Error("Dynamic requires are not currently supported by @rollup/plugin-commonjs")}(null==base&&module.path)}},module.exports),module.exports}var createClass=createCommonjsModule((function(module){function _defineProperties(target,props){for(var i=0;i<props.length;i++){var descriptor=props[i];descriptor.enumerable=descriptor.enumerable||!1,descriptor.configurable=!0,"value"in descriptor&&(descriptor.writable=!0),Object.defineProperty(target,descriptor.key,descriptor)}}module.exports=function(Constructor,protoProps,staticProps){return protoProps&&_defineProperties(Constructor.prototype,protoProps),staticProps&&_defineProperties(Constructor,staticProps),Constructor},module.exports.default=module.exports,module.exports.__esModule=!0})),setPrototypeOf=createCommonjsModule((function(module){function _setPrototypeOf(o,p){return module.exports=_setPrototypeOf=Object.setPrototypeOf||function(o,p){return o.__proto__=p,o},module.exports.default=module.exports,module.exports.__esModule=!0,_setPrototypeOf(o,p)}module.exports=_setPrototypeOf,module.exports.default=module.exports,module.exports.__esModule=!0})),inheritsLoose=createCommonjsModule((function(module){module.exports=function(subClass,superClass){subClass.prototype=Object.create(superClass.prototype),subClass.prototype.constructor=subClass,setPrototypeOf(subClass,superClass)},module.exports.default=module.exports,module.exports.__esModule=!0})),Stream=function(){function Stream(){this.listeners={}}var _proto=Stream.prototype;return _proto.on=function(type,listener){this.listeners[type]||(this.listeners[type]=[]),this.listeners[type].push(listener)},_proto.off=function(type,listener){if(!this.listeners[type])return!1;var index=this.listeners[type].indexOf(listener);return this.listeners[type]=this.listeners[type].slice(0),this.listeners[type].splice(index,1),index>-1},_proto.trigger=function(type){var callbacks=this.listeners[type];if(callbacks)if(2===arguments.length)for(var length=callbacks.length,i=0;i<length;++i)callbacks[i].call(this,arguments[1]);else for(var args=Array.prototype.slice.call(arguments,1),_length=callbacks.length,_i=0;_i<_length;++_i)callbacks[_i].apply(this,args)},_proto.dispose=function(){this.listeners={}},_proto.pipe=function(destination){this.on("data",(function(data){destination.push(data)}))},Stream}();
/*! @name aes-decrypter @version 3.1.2 @license Apache-2.0 */
var aesTables=null,AES=function(){function AES(key){var i,j,tmp;aesTables||(aesTables=function(){var i,x,xInv,x2,x4,s,tEnc,tDec,tables=[[[],[],[],[],[]],[[],[],[],[],[]]],encTable=tables[0],decTable=tables[1],sbox=encTable[4],sboxInv=decTable[4],d=[],th=[];for(i=0;i<256;i++)th[(d[i]=i<<1^283*(i>>7))^i]=i;for(x=xInv=0;!sbox[x];x^=x2||1,xInv=th[xInv]||1)for(s=(s=xInv^xInv<<1^xInv<<2^xInv<<3^xInv<<4)>>8^255&s^99,sbox[x]=s,sboxInv[s]=x,tDec=16843009*d[x4=d[x2=d[x]]]^65537*x4^257*x2^16843008*x,tEnc=257*d[s]^16843008*s,i=0;i<4;i++)encTable[i][x]=tEnc=tEnc<<24^tEnc>>>8,decTable[i][s]=tDec=tDec<<24^tDec>>>8;for(i=0;i<5;i++)encTable[i]=encTable[i].slice(0),decTable[i]=decTable[i].slice(0);return tables}()),this._tables=[[aesTables[0][0].slice(),aesTables[0][1].slice(),aesTables[0][2].slice(),aesTables[0][3].slice(),aesTables[0][4].slice()],[aesTables[1][0].slice(),aesTables[1][1].slice(),aesTables[1][2].slice(),aesTables[1][3].slice(),aesTables[1][4].slice()]];var sbox=this._tables[0][4],decTable=this._tables[1],keyLen=key.length,rcon=1;if(4!==keyLen&&6!==keyLen&&8!==keyLen)throw new Error("Invalid aes key size");var encKey=key.slice(0),decKey=[];for(this._key=[encKey,decKey],i=keyLen;i<4*keyLen+28;i++)tmp=encKey[i-1],(i%keyLen==0||8===keyLen&&i%keyLen==4)&&(tmp=sbox[tmp>>>24]<<24^sbox[tmp>>16&255]<<16^sbox[tmp>>8&255]<<8^sbox[255&tmp],i%keyLen==0&&(tmp=tmp<<8^tmp>>>24^rcon<<24,rcon=rcon<<1^283*(rcon>>7))),encKey[i]=encKey[i-keyLen]^tmp;for(j=0;i;j++,i--)tmp=encKey[3&j?i:i-4],decKey[j]=i<=4||j<4?tmp:decTable[0][sbox[tmp>>>24]]^decTable[1][sbox[tmp>>16&255]]^decTable[2][sbox[tmp>>8&255]]^decTable[3][sbox[255&tmp]]}return AES.prototype.decrypt=function(encrypted0,encrypted1,encrypted2,encrypted3,out,offset){var a2,b2,c2,i,key=this._key[1],a=encrypted0^key[0],b=encrypted3^key[1],c=encrypted2^key[2],d=encrypted1^key[3],nInnerRounds=key.length/4-2,kIndex=4,table=this._tables[1],table0=table[0],table1=table[1],table2=table[2],table3=table[3],sbox=table[4];for(i=0;i<nInnerRounds;i++)a2=table0[a>>>24]^table1[b>>16&255]^table2[c>>8&255]^table3[255&d]^key[kIndex],b2=table0[b>>>24]^table1[c>>16&255]^table2[d>>8&255]^table3[255&a]^key[kIndex+1],c2=table0[c>>>24]^table1[d>>16&255]^table2[a>>8&255]^table3[255&b]^key[kIndex+2],d=table0[d>>>24]^table1[a>>16&255]^table2[b>>8&255]^table3[255&c]^key[kIndex+3],kIndex+=4,a=a2,b=b2,c=c2;for(i=0;i<4;i++)out[(3&-i)+offset]=sbox[a>>>24]<<24^sbox[b>>16&255]<<16^sbox[c>>8&255]<<8^sbox[255&d]^key[kIndex++],a2=a,a=b,b=c,c=d,d=a2},AES}(),AsyncStream=function(_Stream){function AsyncStream(){var _this;return(_this=_Stream.call(this,Stream)||this).jobs=[],_this.delay=1,_this.timeout_=null,_this}inheritsLoose(AsyncStream,_Stream);var _proto=AsyncStream.prototype;return _proto.processJob_=function(){this.jobs.shift()(),this.jobs.length?this.timeout_=setTimeout(this.processJob_.bind(this),this.delay):this.timeout_=null},_proto.push=function(job){this.jobs.push(job),this.timeout_||(this.timeout_=setTimeout(this.processJob_.bind(this),this.delay))},AsyncStream}(Stream),ntoh=function(word){return word<<24|(65280&word)<<8|(16711680&word)>>8|word>>>24},Decrypter=function(){function Decrypter(encrypted,key,initVector,done){var step=Decrypter.STEP,encrypted32=new Int32Array(encrypted.buffer),decrypted=new Uint8Array(encrypted.byteLength),i=0;for(this.asyncStream_=new AsyncStream,this.asyncStream_.push(this.decryptChunk_(encrypted32.subarray(i,i+step),key,initVector,decrypted)),i=step;i<encrypted32.length;i+=step)initVector=new Uint32Array([ntoh(encrypted32[i-4]),ntoh(encrypted32[i-3]),ntoh(encrypted32[i-2]),ntoh(encrypted32[i-1])]),this.asyncStream_.push(this.decryptChunk_(encrypted32.subarray(i,i+step),key,initVector,decrypted));this.asyncStream_.push((function(){
/*! @name pkcs7 @version 1.0.4 @license Apache-2.0 */
var padded;done(null,(padded=decrypted).subarray(0,padded.byteLength-padded[padded.byteLength-1]))}))}return Decrypter.prototype.decryptChunk_=function(encrypted,key,initVector,decrypted){return function(){var bytes=function(encrypted,key,initVector){var init0,init1,init2,init3,encrypted0,encrypted1,encrypted2,encrypted3,wordIx,encrypted32=new Int32Array(encrypted.buffer,encrypted.byteOffset,encrypted.byteLength>>2),decipher=new AES(Array.prototype.slice.call(key)),decrypted=new Uint8Array(encrypted.byteLength),decrypted32=new Int32Array(decrypted.buffer);for(init0=initVector[0],init1=initVector[1],init2=initVector[2],init3=initVector[3],wordIx=0;wordIx<encrypted32.length;wordIx+=4)encrypted0=ntoh(encrypted32[wordIx]),encrypted1=ntoh(encrypted32[wordIx+1]),encrypted2=ntoh(encrypted32[wordIx+2]),encrypted3=ntoh(encrypted32[wordIx+3]),decipher.decrypt(encrypted0,encrypted1,encrypted2,encrypted3,decrypted32,wordIx),decrypted32[wordIx]=ntoh(decrypted32[wordIx]^init0),decrypted32[wordIx+1]=ntoh(decrypted32[wordIx+1]^init1),decrypted32[wordIx+2]=ntoh(decrypted32[wordIx+2]^init2),decrypted32[wordIx+3]=ntoh(decrypted32[wordIx+3]^init3),init0=encrypted0,init1=encrypted1,init2=encrypted2,init3=encrypted3;return decrypted}(encrypted,key,initVector);decrypted.set(bytes,encrypted.byteOffset)}},createClass(Decrypter,null,[{key:"STEP",get:function(){return 32e3}}]),Decrypter}();self.onmessage=function(event){var data=event.data,encrypted=new Uint8Array(data.encrypted.bytes,data.encrypted.byteOffset,data.encrypted.byteLength),key=new Uint32Array(data.key.bytes,data.key.byteOffset,data.key.byteLength/4),iv=new Uint32Array(data.iv.bytes,data.iv.byteOffset,data.iv.byteLength/4);new Decrypter(encrypted,key,iv,(function(err,bytes){var message,transferable;self.postMessage((message={source:data.source,decrypted:bytes},transferable={},Object.keys(message).forEach((function(key){var value=message[key];ArrayBuffer.isView(value)?transferable[key]={bytes:value.buffer,byteOffset:value.byteOffset,byteLength:value.byteLength}:transferable[key]=value})),transferable),[bytes.buffer])}))}}))),Decrypter=factory(workerCode),audioTrackKind_=function(properties){var kind=properties.default?"main":"alternative";return properties.characteristics&&properties.characteristics.indexOf("public.accessibility.describes-video")>=0&&(kind="main-desc"),kind},stopLoaders=function(segmentLoader,mediaType){segmentLoader.abort(),segmentLoader.pause(),mediaType&&mediaType.activePlaylistLoader&&(mediaType.activePlaylistLoader.pause(),mediaType.activePlaylistLoader=null)},startLoaders=function(playlistLoader,mediaType){mediaType.activePlaylistLoader=playlistLoader,playlistLoader.load()},onError={AUDIO:function(type,settings){return function(){var segmentLoader=settings.segmentLoaders[type],mediaType=settings.mediaTypes[type],blacklistCurrentPlaylist=settings.blacklistCurrentPlaylist;stopLoaders(segmentLoader,mediaType);var activeTrack=mediaType.activeTrack(),activeGroup=mediaType.activeGroup(),id=(activeGroup.filter((function(group){return group.default}))[0]||activeGroup[0]).id,defaultTrack=mediaType.tracks[id];if(activeTrack!==defaultTrack){for(var trackId in videojs.log.warn("Problem encountered loading the alternate audio track.Switching back to default."),mediaType.tracks)mediaType.tracks[trackId].enabled=mediaType.tracks[trackId]===defaultTrack;mediaType.onTrackChanged()}else blacklistCurrentPlaylist({message:"Problem encountered loading the default audio track."})}},SUBTITLES:function(type,settings){return function(){var segmentLoader=settings.segmentLoaders[type],mediaType=settings.mediaTypes[type];videojs.log.warn("Problem encountered loading the subtitle track.Disabling subtitle track."),stopLoaders(segmentLoader,mediaType);var track=mediaType.activeTrack();track&&(track.mode="disabled"),mediaType.onTrackChanged()}}},setupListeners={AUDIO:function(type,playlistLoader,settings){if(playlistLoader){var tech=settings.tech,requestOptions=settings.requestOptions,segmentLoader=settings.segmentLoaders[type];playlistLoader.on("loadedmetadata",(function(){var media=playlistLoader.media();segmentLoader.playlist(media,requestOptions),(!tech.paused()||media.endList&&"none"!==tech.preload())&&segmentLoader.load()})),playlistLoader.on("loadedplaylist",(function(){segmentLoader.playlist(playlistLoader.media(),requestOptions),tech.paused()||segmentLoader.load()})),playlistLoader.on("error",onError[type](type,settings))}},SUBTITLES:function(type,playlistLoader,settings){var tech=settings.tech,requestOptions=settings.requestOptions,segmentLoader=settings.segmentLoaders[type],mediaType=settings.mediaTypes[type];playlistLoader.on("loadedmetadata",(function(){var media=playlistLoader.media();segmentLoader.playlist(media,requestOptions),segmentLoader.track(mediaType.activeTrack()),(!tech.paused()||media.endList&&"none"!==tech.preload())&&segmentLoader.load()})),playlistLoader.on("loadedplaylist",(function(){segmentLoader.playlist(playlistLoader.media(),requestOptions),tech.paused()||segmentLoader.load()})),playlistLoader.on("error",onError[type](type,settings))}},initialize={AUDIO:function(type,settings){var vhs=settings.vhs,sourceType=settings.sourceType,segmentLoader=settings.segmentLoaders[type],requestOptions=settings.requestOptions,mediaGroups=settings.master.mediaGroups,_settings$mediaTypes$=settings.mediaTypes[type],groups=_settings$mediaTypes$.groups,tracks=_settings$mediaTypes$.tracks,logger_=_settings$mediaTypes$.logger_,masterPlaylistLoader=settings.masterPlaylistLoader,audioOnlyMaster=isAudioOnly(masterPlaylistLoader.master);for(var groupId in mediaGroups[type]&&0!==Object.keys(mediaGroups[type]).length||(mediaGroups[type]={main:{default:{default:!0}}},audioOnlyMaster&&(mediaGroups[type].main.default.playlists=masterPlaylistLoader.master.playlists)),mediaGroups[type])for(var variantLabel in groups[groupId]||(groups[groupId]=[]),mediaGroups[type][groupId]){var properties=mediaGroups[type][groupId][variantLabel],playlistLoader=void 0;if(audioOnlyMaster?(logger_("AUDIO group '"+groupId+"' label '"+variantLabel+"' is a master playlist"),properties.isMasterPlaylist=!0,playlistLoader=null):playlistLoader="vhs-json"===sourceType&&properties.playlists?new PlaylistLoader(properties.playlists[0],vhs,requestOptions):properties.resolvedUri?new PlaylistLoader(properties.resolvedUri,vhs,requestOptions):properties.playlists&&"dash"===sourceType?new DashPlaylistLoader(properties.playlists[0],vhs,requestOptions,masterPlaylistLoader):null,properties=videojs.mergeOptions({id:variantLabel,playlistLoader:playlistLoader},properties),setupListeners[type](type,properties.playlistLoader,settings),groups[groupId].push(properties),void 0===tracks[variantLabel]){var track=new videojs.AudioTrack({id:variantLabel,kind:audioTrackKind_(properties),enabled:!1,language:properties.language,default:properties.default,label:variantLabel});tracks[variantLabel]=track}}segmentLoader.on("error",onError[type](type,settings))},SUBTITLES:function(type,settings){var tech=settings.tech,vhs=settings.vhs,sourceType=settings.sourceType,segmentLoader=settings.segmentLoaders[type],requestOptions=settings.requestOptions,mediaGroups=settings.master.mediaGroups,_settings$mediaTypes$2=settings.mediaTypes[type],groups=_settings$mediaTypes$2.groups,tracks=_settings$mediaTypes$2.tracks,masterPlaylistLoader=settings.masterPlaylistLoader;for(var groupId in mediaGroups[type])for(var variantLabel in groups[groupId]||(groups[groupId]=[]),mediaGroups[type][groupId])if(!mediaGroups[type][groupId][variantLabel].forced){var properties=mediaGroups[type][groupId][variantLabel],playlistLoader=void 0;if("hls"===sourceType)playlistLoader=new PlaylistLoader(properties.resolvedUri,vhs,requestOptions);else if("dash"===sourceType){if(!properties.playlists.filter((function(p){return p.excludeUntil!==1/0})).length)return;playlistLoader=new DashPlaylistLoader(properties.playlists[0],vhs,requestOptions,masterPlaylistLoader)}else"vhs-json"===sourceType&&(playlistLoader=new PlaylistLoader(properties.playlists?properties.playlists[0]:properties.resolvedUri,vhs,requestOptions));if(properties=videojs.mergeOptions({id:variantLabel,playlistLoader:playlistLoader},properties),setupListeners[type](type,properties.playlistLoader,settings),groups[groupId].push(properties),void 0===tracks[variantLabel]){var track=tech.addRemoteTextTrack({id:variantLabel,kind:"subtitles",default:properties.default&&properties.autoselect,language:properties.language,label:variantLabel},!1).track;tracks[variantLabel]=track}}segmentLoader.on("error",onError[type](type,settings))},"CLOSED-CAPTIONS":function(type,settings){var tech=settings.tech,mediaGroups=settings.master.mediaGroups,_settings$mediaTypes$3=settings.mediaTypes[type],groups=_settings$mediaTypes$3.groups,tracks=_settings$mediaTypes$3.tracks;for(var groupId in mediaGroups[type])for(var variantLabel in groups[groupId]||(groups[groupId]=[]),mediaGroups[type][groupId]){var properties=mediaGroups[type][groupId][variantLabel];if(/^(?:CC|SERVICE)/.test(properties.instreamId)){var captionServices=tech.options_.vhs&&tech.options_.vhs.captionServices||{},newProps={label:variantLabel,language:properties.language,instreamId:properties.instreamId,default:properties.default&&properties.autoselect};if(captionServices[newProps.instreamId]&&(newProps=videojs.mergeOptions(newProps,captionServices[newProps.instreamId])),void 0===newProps.default&&delete newProps.default,groups[groupId].push(videojs.mergeOptions({id:variantLabel},properties)),void 0===tracks[variantLabel]){var track=tech.addRemoteTextTrack({id:newProps.instreamId,kind:"captions",default:newProps.default,language:newProps.language,label:newProps.label},!1).track;tracks[variantLabel]=track}}}}},groupMatch=function groupMatch(list,media){for(var i=0;i<list.length;i++){if(playlistMatch(media,list[i]))return!0;if(list[i].playlists&&groupMatch(list[i].playlists,media))return!0}return!1},activeTrack={AUDIO:function(type,settings){return function(){var tracks=settings.mediaTypes[type].tracks;for(var id in tracks)if(tracks[id].enabled)return tracks[id];return null}},SUBTITLES:function(type,settings){return function(){var tracks=settings.mediaTypes[type].tracks;for(var id in tracks)if("showing"===tracks[id].mode||"hidden"===tracks[id].mode)return tracks[id];return null}}},setupMediaGroups=function(settings){["AUDIO","SUBTITLES","CLOSED-CAPTIONS"].forEach((function(type){initialize[type](type,settings)}));var mediaTypes=settings.mediaTypes,masterPlaylistLoader=settings.masterPlaylistLoader,tech=settings.tech,vhs=settings.vhs,_settings$segmentLoad3=settings.segmentLoaders,audioSegmentLoader=_settings$segmentLoad3.AUDIO,mainSegmentLoader=_settings$segmentLoad3.main;["AUDIO","SUBTITLES"].forEach((function(type){mediaTypes[type].activeGroup=function(type,settings){return function(track){var masterPlaylistLoader=settings.masterPlaylistLoader,groups=settings.mediaTypes[type].groups,media=masterPlaylistLoader.media();if(!media)return null;var variants=null;media.attributes[type]&&(variants=groups[media.attributes[type]]);var groupKeys=Object.keys(groups);if(!variants)if("AUDIO"===type&&groupKeys.length>1&&isAudioOnly(settings.master))for(var i=0;i<groupKeys.length;i++){var groupPropertyList=groups[groupKeys[i]];if(groupMatch(groupPropertyList,media)){variants=groupPropertyList;break}}else groups.main?variants=groups.main:1===groupKeys.length&&(variants=groups[groupKeys[0]]);return void 0===track?variants:null!==track&&variants&&variants.filter((function(props){return props.id===track.id}))[0]||null}}(type,settings),mediaTypes[type].activeTrack=activeTrack[type](type,settings),mediaTypes[type].onGroupChanged=function(type,settings){return function(){var _settings$segmentLoad=settings.segmentLoaders,segmentLoader=_settings$segmentLoad[type],mainSegmentLoader=_settings$segmentLoad.main,mediaType=settings.mediaTypes[type],activeTrack=mediaType.activeTrack(),activeGroup=mediaType.getActiveGroup(),previousActiveLoader=mediaType.activePlaylistLoader,lastGroup=mediaType.lastGroup_;activeGroup&&lastGroup&&activeGroup.id===lastGroup.id||(mediaType.lastGroup_=activeGroup,mediaType.lastTrack_=activeTrack,stopLoaders(segmentLoader,mediaType),activeGroup&&!activeGroup.isMasterPlaylist&&(activeGroup.playlistLoader?(segmentLoader.resyncLoader(),startLoaders(activeGroup.playlistLoader,mediaType)):previousActiveLoader&&mainSegmentLoader.resetEverything()))}}(type,settings),mediaTypes[type].onGroupChanging=function(type,settings){return function(){var segmentLoader=settings.segmentLoaders[type];settings.mediaTypes[type].lastGroup_=null,segmentLoader.abort(),segmentLoader.pause()}}(type,settings),mediaTypes[type].onTrackChanged=function(type,settings){return function(){var masterPlaylistLoader=settings.masterPlaylistLoader,_settings$segmentLoad2=settings.segmentLoaders,segmentLoader=_settings$segmentLoad2[type],mainSegmentLoader=_settings$segmentLoad2.main,mediaType=settings.mediaTypes[type],activeTrack=mediaType.activeTrack(),activeGroup=mediaType.getActiveGroup(),previousActiveLoader=mediaType.activePlaylistLoader,lastTrack=mediaType.lastTrack_;if((!lastTrack||!activeTrack||lastTrack.id!==activeTrack.id)&&(mediaType.lastGroup_=activeGroup,mediaType.lastTrack_=activeTrack,stopLoaders(segmentLoader,mediaType),activeGroup)){if(activeGroup.isMasterPlaylist){if(!activeTrack||!lastTrack||activeTrack.id===lastTrack.id)return;var mpc=settings.vhs.masterPlaylistController_,newPlaylist=mpc.selectPlaylist();if(mpc.media()===newPlaylist)return;return mediaType.logger_("track change. Switching master audio from "+lastTrack.id+" to "+activeTrack.id),masterPlaylistLoader.pause(),mainSegmentLoader.resetEverything(),void mpc.fastQualityChange_(newPlaylist)}if("AUDIO"===type){if(!activeGroup.playlistLoader)return mainSegmentLoader.setAudio(!0),void mainSegmentLoader.resetEverything();segmentLoader.setAudio(!0),mainSegmentLoader.setAudio(!1)}previousActiveLoader!==activeGroup.playlistLoader?(segmentLoader.track&&segmentLoader.track(activeTrack),segmentLoader.resetEverything(),startLoaders(activeGroup.playlistLoader,mediaType)):startLoaders(activeGroup.playlistLoader,mediaType)}}}(type,settings),mediaTypes[type].getActiveGroup=function(type,_ref){var mediaTypes=_ref.mediaTypes;return function(){var activeTrack_=mediaTypes[type].activeTrack();return activeTrack_?mediaTypes[type].activeGroup(activeTrack_):null}}(type,settings)}));var audioGroup=mediaTypes.AUDIO.activeGroup();if(audioGroup){var groupId=(audioGroup.filter((function(group){return group.default}))[0]||audioGroup[0]).id;mediaTypes.AUDIO.tracks[groupId].enabled=!0,mediaTypes.AUDIO.onGroupChanged(),mediaTypes.AUDIO.onTrackChanged(),mediaTypes.AUDIO.getActiveGroup().playlistLoader?(mainSegmentLoader.setAudio(!1),audioSegmentLoader.setAudio(!0)):mainSegmentLoader.setAudio(!0)}masterPlaylistLoader.on("mediachange",(function(){["AUDIO","SUBTITLES"].forEach((function(type){return mediaTypes[type].onGroupChanged()}))})),masterPlaylistLoader.on("mediachanging",(function(){["AUDIO","SUBTITLES"].forEach((function(type){return mediaTypes[type].onGroupChanging()}))}));var onAudioTrackChanged=function(){mediaTypes.AUDIO.onTrackChanged(),tech.trigger({type:"usage",name:"vhs-audio-change"}),tech.trigger({type:"usage",name:"hls-audio-change"})};for(var id in tech.audioTracks().addEventListener("change",onAudioTrackChanged),tech.remoteTextTracks().addEventListener("change",mediaTypes.SUBTITLES.onTrackChanged),vhs.on("dispose",(function(){tech.audioTracks().removeEventListener("change",onAudioTrackChanged),tech.remoteTextTracks().removeEventListener("change",mediaTypes.SUBTITLES.onTrackChanged)})),tech.clearTracks("audio"),mediaTypes.AUDIO.tracks)tech.audioTracks().addTrack(mediaTypes.AUDIO.tracks[id])},loaderStats=["mediaRequests","mediaRequestsAborted","mediaRequestsTimedout","mediaRequestsErrored","mediaTransferDuration","mediaBytesTransferred","mediaAppends"],sumLoaderStat=function(stat){return this.audioSegmentLoader_[stat]+this.mainSegmentLoader_[stat]},MasterPlaylistController=function(_videojs$EventTarget){function MasterPlaylistController(options){var _this;_this=_videojs$EventTarget.call(this)||this;var src=options.src,handleManifestRedirects=options.handleManifestRedirects,withCredentials=options.withCredentials,tech=options.tech,bandwidth=options.bandwidth,externVhs=options.externVhs,useCueTags=options.useCueTags,blacklistDuration=options.blacklistDuration,enableLowInitialPlaylist=options.enableLowInitialPlaylist,sourceType=options.sourceType,cacheEncryptionKeys=options.cacheEncryptionKeys,experimentalBufferBasedABR=options.experimentalBufferBasedABR,experimentalLeastPixelDiffSelector=options.experimentalLeastPixelDiffSelector,captionServices=options.captionServices;if(!src)throw new Error("A non-empty playlist URL or JSON manifest string is required");var maxPlaylistRetries=options.maxPlaylistRetries;null==maxPlaylistRetries&&(maxPlaylistRetries=1/0),Vhs$1=externVhs,_this.experimentalBufferBasedABR=Boolean(experimentalBufferBasedABR),_this.experimentalLeastPixelDiffSelector=Boolean(experimentalLeastPixelDiffSelector),_this.withCredentials=withCredentials,_this.tech_=tech,_this.vhs_=tech.vhs,_this.sourceType_=sourceType,_this.useCueTags_=useCueTags,_this.blacklistDuration=blacklistDuration,_this.maxPlaylistRetries=maxPlaylistRetries,_this.enableLowInitialPlaylist=enableLowInitialPlaylist,_this.useCueTags_&&(_this.cueTagsTrack_=_this.tech_.addTextTrack("metadata","ad-cues"),_this.cueTagsTrack_.inBandMetadataTrackDispatchType=""),_this.requestOptions_={withCredentials:withCredentials,handleManifestRedirects:handleManifestRedirects,maxPlaylistRetries:maxPlaylistRetries,timeout:null},_this.on("error",_this.pauseLoading),_this.mediaTypes_=function(){var mediaTypes={};return["AUDIO","SUBTITLES","CLOSED-CAPTIONS"].forEach((function(type){mediaTypes[type]={groups:{},tracks:{},activePlaylistLoader:null,activeGroup:noop,activeTrack:noop,getActiveGroup:noop,onGroupChanged:noop,onTrackChanged:noop,lastTrack_:null,logger_:logger("MediaGroups["+type+"]")}})),mediaTypes}(),_this.mediaSource=new window.MediaSource,_this.handleDurationChange_=_this.handleDurationChange_.bind(assertThisInitialized(_this)),_this.handleSourceOpen_=_this.handleSourceOpen_.bind(assertThisInitialized(_this)),_this.handleSourceEnded_=_this.handleSourceEnded_.bind(assertThisInitialized(_this)),_this.mediaSource.addEventListener("durationchange",_this.handleDurationChange_),_this.mediaSource.addEventListener("sourceopen",_this.handleSourceOpen_),_this.mediaSource.addEventListener("sourceended",_this.handleSourceEnded_),_this.seekable_=videojs.createTimeRanges(),_this.hasPlayed_=!1,_this.syncController_=new SyncController(options),_this.segmentMetadataTrack_=tech.addRemoteTextTrack({kind:"metadata",label:"segment-metadata"},!1).track,_this.decrypter_=new Decrypter,_this.sourceUpdater_=new SourceUpdater(_this.mediaSource),_this.inbandTextTracks_={},_this.timelineChangeController_=new TimelineChangeController;var segmentLoaderSettings={vhs:_this.vhs_,parse708captions:options.parse708captions,captionServices:captionServices,mediaSource:_this.mediaSource,currentTime:_this.tech_.currentTime.bind(_this.tech_),seekable:function(){return _this.seekable()},seeking:function(){return _this.tech_.seeking()},duration:function(){return _this.duration()},hasPlayed:function(){return _this.hasPlayed_},goalBufferLength:function(){return _this.goalBufferLength()},bandwidth:bandwidth,syncController:_this.syncController_,decrypter:_this.decrypter_,sourceType:_this.sourceType_,inbandTextTracks:_this.inbandTextTracks_,cacheEncryptionKeys:cacheEncryptionKeys,sourceUpdater:_this.sourceUpdater_,timelineChangeController:_this.timelineChangeController_,experimentalExactManifestTimings:options.experimentalExactManifestTimings};_this.masterPlaylistLoader_="dash"===_this.sourceType_?new DashPlaylistLoader(src,_this.vhs_,_this.requestOptions_):new PlaylistLoader(src,_this.vhs_,_this.requestOptions_),_this.setupMasterPlaylistLoaderListeners_(),_this.mainSegmentLoader_=new SegmentLoader(videojs.mergeOptions(segmentLoaderSettings,{segmentMetadataTrack:_this.segmentMetadataTrack_,loaderType:"main"}),options),_this.audioSegmentLoader_=new SegmentLoader(videojs.mergeOptions(segmentLoaderSettings,{loaderType:"audio"}),options),_this.subtitleSegmentLoader_=new VTTSegmentLoader(videojs.mergeOptions(segmentLoaderSettings,{loaderType:"vtt",featuresNativeTextTracks:_this.tech_.featuresNativeTextTracks}),options),_this.setupSegmentLoaderListeners_(),_this.experimentalBufferBasedABR&&(_this.masterPlaylistLoader_.one("loadedplaylist",(function(){return _this.startABRTimer_()})),_this.tech_.on("pause",(function(){return _this.stopABRTimer_()})),_this.tech_.on("play",(function(){return _this.startABRTimer_()}))),loaderStats.forEach((function(stat){_this[stat+"_"]=sumLoaderStat.bind(assertThisInitialized(_this),stat)})),_this.logger_=logger("MPC"),_this.triggeredFmp4Usage=!1,"none"===_this.tech_.preload()?(_this.loadOnPlay_=function(){_this.loadOnPlay_=null,_this.masterPlaylistLoader_.load()},_this.tech_.one("play",_this.loadOnPlay_)):_this.masterPlaylistLoader_.load(),_this.timeToLoadedData__=-1,_this.mainAppendsToLoadedData__=-1,_this.audioAppendsToLoadedData__=-1;var event="none"===_this.tech_.preload()?"play":"loadstart";return _this.tech_.one(event,(function(){var timeToLoadedDataStart=Date.now();_this.tech_.one("loadeddata",(function(){_this.timeToLoadedData__=Date.now()-timeToLoadedDataStart,_this.mainAppendsToLoadedData__=_this.mainSegmentLoader_.mediaAppends,_this.audioAppendsToLoadedData__=_this.audioSegmentLoader_.mediaAppends}))})),_this}inheritsLoose(MasterPlaylistController,_videojs$EventTarget);var _proto=MasterPlaylistController.prototype;return _proto.mainAppendsToLoadedData_=function(){return this.mainAppendsToLoadedData__},_proto.audioAppendsToLoadedData_=function(){return this.audioAppendsToLoadedData__},_proto.appendsToLoadedData_=function(){var main=this.mainAppendsToLoadedData_(),audio=this.audioAppendsToLoadedData_();return-1===main||-1===audio?-1:main+audio},_proto.timeToLoadedData_=function(){return this.timeToLoadedData__},_proto.checkABR_=function(){var nextPlaylist=this.selectPlaylist();nextPlaylist&&this.shouldSwitchToMedia_(nextPlaylist)&&this.switchMedia_(nextPlaylist,"abr")},_proto.switchMedia_=function(playlist,cause,delay){var oldMedia=this.media(),oldId=oldMedia&&(oldMedia.id||oldMedia.uri),newId=playlist.id||playlist.uri;oldId&&oldId!==newId&&(this.logger_("switch media "+oldId+" -> "+newId+" from "+cause),this.tech_.trigger({type:"usage",name:"vhs-rendition-change-"+cause})),this.masterPlaylistLoader_.media(playlist,delay)},_proto.startABRTimer_=function(){var _this2=this;this.stopABRTimer_(),this.abrTimer_=window.setInterval((function(){return _this2.checkABR_()}),250)},_proto.stopABRTimer_=function(){this.tech_.scrubbing&&this.tech_.scrubbing()||(window.clearInterval(this.abrTimer_),this.abrTimer_=null)},_proto.getAudioTrackPlaylists_=function(){var master=this.master(),defaultPlaylists=master&&master.playlists||[];if(!master||!master.mediaGroups||!master.mediaGroups.AUDIO)return defaultPlaylists;var track,AUDIO=master.mediaGroups.AUDIO,groupKeys=Object.keys(AUDIO);if(Object.keys(this.mediaTypes_.AUDIO.groups).length)track=this.mediaTypes_.AUDIO.activeTrack();else{var defaultGroup=AUDIO.main||groupKeys.length&&AUDIO[groupKeys[0]];for(var label in defaultGroup)if(defaultGroup[label].default){track={label:label};break}}if(!track)return defaultPlaylists;var playlists=[];for(var group in AUDIO)if(AUDIO[group][track.label]){var properties=AUDIO[group][track.label];if(properties.playlists&&properties.playlists.length)playlists.push.apply(playlists,properties.playlists);else if(properties.uri)playlists.push(properties);else if(master.playlists.length)for(var i=0;i<master.playlists.length;i++){var playlist=master.playlists[i];playlist.attributes&&playlist.attributes.AUDIO&&playlist.attributes.AUDIO===group&&playlists.push(playlist)}}return playlists.length?playlists:defaultPlaylists},_proto.setupMasterPlaylistLoaderListeners_=function(){var _this3=this;this.masterPlaylistLoader_.on("loadedmetadata",(function(){var media=_this3.masterPlaylistLoader_.media(),requestTimeout=1.5*media.targetDuration*1e3;isLowestEnabledRendition(_this3.masterPlaylistLoader_.master,_this3.masterPlaylistLoader_.media())?_this3.requestOptions_.timeout=0:_this3.requestOptions_.timeout=requestTimeout,media.endList&&"none"!==_this3.tech_.preload()&&(_this3.mainSegmentLoader_.playlist(media,_this3.requestOptions_),_this3.mainSegmentLoader_.load()),setupMediaGroups({sourceType:_this3.sourceType_,segmentLoaders:{AUDIO:_this3.audioSegmentLoader_,SUBTITLES:_this3.subtitleSegmentLoader_,main:_this3.mainSegmentLoader_},tech:_this3.tech_,requestOptions:_this3.requestOptions_,masterPlaylistLoader:_this3.masterPlaylistLoader_,vhs:_this3.vhs_,master:_this3.master(),mediaTypes:_this3.mediaTypes_,blacklistCurrentPlaylist:_this3.blacklistCurrentPlaylist.bind(_this3)}),_this3.triggerPresenceUsage_(_this3.master(),media),_this3.setupFirstPlay(),!_this3.mediaTypes_.AUDIO.activePlaylistLoader||_this3.mediaTypes_.AUDIO.activePlaylistLoader.media()?_this3.trigger("selectedinitialmedia"):_this3.mediaTypes_.AUDIO.activePlaylistLoader.one("loadedmetadata",(function(){_this3.trigger("selectedinitialmedia")}))})),this.masterPlaylistLoader_.on("loadedplaylist",(function(){_this3.loadOnPlay_&&_this3.tech_.off("play",_this3.loadOnPlay_);var updatedPlaylist=_this3.masterPlaylistLoader_.media();if(!updatedPlaylist){var selectedMedia;if(_this3.excludeUnsupportedVariants_(),_this3.enableLowInitialPlaylist&&(selectedMedia=_this3.selectInitialPlaylist()),selectedMedia||(selectedMedia=_this3.selectPlaylist()),!selectedMedia||!_this3.shouldSwitchToMedia_(selectedMedia))return;if(_this3.initialMedia_=selectedMedia,_this3.switchMedia_(_this3.initialMedia_,"initial"),!("vhs-json"===_this3.sourceType_&&_this3.initialMedia_.segments))return;updatedPlaylist=_this3.initialMedia_}_this3.handleUpdatedMediaPlaylist(updatedPlaylist)})),this.masterPlaylistLoader_.on("error",(function(){_this3.blacklistCurrentPlaylist(_this3.masterPlaylistLoader_.error)})),this.masterPlaylistLoader_.on("mediachanging",(function(){_this3.mainSegmentLoader_.abort(),_this3.mainSegmentLoader_.pause()})),this.masterPlaylistLoader_.on("mediachange",(function(){var media=_this3.masterPlaylistLoader_.media(),requestTimeout=1.5*media.targetDuration*1e3;isLowestEnabledRendition(_this3.masterPlaylistLoader_.master,_this3.masterPlaylistLoader_.media())?_this3.requestOptions_.timeout=0:_this3.requestOptions_.timeout=requestTimeout,_this3.mainSegmentLoader_.playlist(media,_this3.requestOptions_),_this3.mainSegmentLoader_.load(),_this3.tech_.trigger({type:"mediachange",bubbles:!0})})),this.masterPlaylistLoader_.on("playlistunchanged",(function(){var updatedPlaylist=_this3.masterPlaylistLoader_.media();"playlist-unchanged"!==updatedPlaylist.lastExcludeReason_&&(_this3.stuckAtPlaylistEnd_(updatedPlaylist)&&(_this3.blacklistCurrentPlaylist({message:"Playlist no longer updating.",reason:"playlist-unchanged"}),_this3.tech_.trigger("playliststuck")))})),this.masterPlaylistLoader_.on("renditiondisabled",(function(){_this3.tech_.trigger({type:"usage",name:"vhs-rendition-disabled"}),_this3.tech_.trigger({type:"usage",name:"hls-rendition-disabled"})})),this.masterPlaylistLoader_.on("renditionenabled",(function(){_this3.tech_.trigger({type:"usage",name:"vhs-rendition-enabled"}),_this3.tech_.trigger({type:"usage",name:"hls-rendition-enabled"})}))},_proto.handleUpdatedMediaPlaylist=function(updatedPlaylist){this.useCueTags_&&this.updateAdCues_(updatedPlaylist),this.mainSegmentLoader_.playlist(updatedPlaylist,this.requestOptions_),this.updateDuration(!updatedPlaylist.endList),this.tech_.paused()||(this.mainSegmentLoader_.load(),this.audioSegmentLoader_&&this.audioSegmentLoader_.load())},_proto.triggerPresenceUsage_=function(master,media){var mediaGroups=master.mediaGroups||{},defaultDemuxed=!0,audioGroupKeys=Object.keys(mediaGroups.AUDIO);for(var mediaGroup in mediaGroups.AUDIO)for(var label in mediaGroups.AUDIO[mediaGroup]){mediaGroups.AUDIO[mediaGroup][label].uri||(defaultDemuxed=!1)}defaultDemuxed&&(this.tech_.trigger({type:"usage",name:"vhs-demuxed"}),this.tech_.trigger({type:"usage",name:"hls-demuxed"})),Object.keys(mediaGroups.SUBTITLES).length&&(this.tech_.trigger({type:"usage",name:"vhs-webvtt"}),this.tech_.trigger({type:"usage",name:"hls-webvtt"})),Vhs$1.Playlist.isAes(media)&&(this.tech_.trigger({type:"usage",name:"vhs-aes"}),this.tech_.trigger({type:"usage",name:"hls-aes"})),audioGroupKeys.length&&Object.keys(mediaGroups.AUDIO[audioGroupKeys[0]]).length>1&&(this.tech_.trigger({type:"usage",name:"vhs-alternate-audio"}),this.tech_.trigger({type:"usage",name:"hls-alternate-audio"})),this.useCueTags_&&(this.tech_.trigger({type:"usage",name:"vhs-playlist-cue-tags"}),this.tech_.trigger({type:"usage",name:"hls-playlist-cue-tags"}))},_proto.shouldSwitchToMedia_=function(nextPlaylist){var currentPlaylist=this.masterPlaylistLoader_.media()||this.masterPlaylistLoader_.pendingMedia_,currentTime=this.tech_.currentTime(),bufferLowWaterLine=this.bufferLowWaterLine(),bufferHighWaterLine=this.bufferHighWaterLine();return function(_ref){var currentPlaylist=_ref.currentPlaylist,buffered=_ref.buffered,currentTime=_ref.currentTime,nextPlaylist=_ref.nextPlaylist,bufferLowWaterLine=_ref.bufferLowWaterLine,bufferHighWaterLine=_ref.bufferHighWaterLine,duration=_ref.duration,experimentalBufferBasedABR=_ref.experimentalBufferBasedABR,log=_ref.log;if(!nextPlaylist)return videojs.log.warn("We received no playlist to switch to. Please check your stream."),!1;var sharedLogLine="allowing switch "+(currentPlaylist&&currentPlaylist.id||"null")+" -> "+nextPlaylist.id;if(!currentPlaylist)return log(sharedLogLine+" as current playlist is not set"),!0;if(nextPlaylist.id===currentPlaylist.id)return!1;var isBuffered=Boolean(findRange(buffered,currentTime).length);if(!currentPlaylist.endList)return isBuffered||"number"!=typeof currentPlaylist.partTargetDuration?(log(sharedLogLine+" as current playlist is live"),!0):(log("not "+sharedLogLine+" as current playlist is live llhls, but currentTime isn't in buffered."),!1);var forwardBuffer=timeAheadOf(buffered,currentTime),maxBufferLowWaterLine=experimentalBufferBasedABR?Config.EXPERIMENTAL_MAX_BUFFER_LOW_WATER_LINE:Config.MAX_BUFFER_LOW_WATER_LINE;if(duration<maxBufferLowWaterLine)return log(sharedLogLine+" as duration < max low water line ("+duration+" < "+maxBufferLowWaterLine+")"),!0;var nextBandwidth=nextPlaylist.attributes.BANDWIDTH,currBandwidth=currentPlaylist.attributes.BANDWIDTH;if(nextBandwidth<currBandwidth&&(!experimentalBufferBasedABR||forwardBuffer<bufferHighWaterLine)){var logLine=sharedLogLine+" as next bandwidth < current bandwidth ("+nextBandwidth+" < "+currBandwidth+")";return experimentalBufferBasedABR&&(logLine+=" and forwardBuffer < bufferHighWaterLine ("+forwardBuffer+" < "+bufferHighWaterLine+")"),log(logLine),!0}if((!experimentalBufferBasedABR||nextBandwidth>currBandwidth)&&forwardBuffer>=bufferLowWaterLine){var _logLine=sharedLogLine+" as forwardBuffer >= bufferLowWaterLine ("+forwardBuffer+" >= "+bufferLowWaterLine+")";return experimentalBufferBasedABR&&(_logLine+=" and next bandwidth > current bandwidth ("+nextBandwidth+" > "+currBandwidth+")"),log(_logLine),!0}return log("not "+sharedLogLine+" as no switching criteria met"),!1}({buffered:this.tech_.buffered(),currentTime:currentTime,currentPlaylist:currentPlaylist,nextPlaylist:nextPlaylist,bufferLowWaterLine:bufferLowWaterLine,bufferHighWaterLine:bufferHighWaterLine,duration:this.duration(),experimentalBufferBasedABR:this.experimentalBufferBasedABR,log:this.logger_})},_proto.setupSegmentLoaderListeners_=function(){var _this4=this;this.experimentalBufferBasedABR||(this.mainSegmentLoader_.on("bandwidthupdate",(function(){var nextPlaylist=_this4.selectPlaylist();_this4.shouldSwitchToMedia_(nextPlaylist)&&_this4.switchMedia_(nextPlaylist,"bandwidthupdate"),_this4.tech_.trigger("bandwidthupdate")})),this.mainSegmentLoader_.on("progress",(function(){_this4.trigger("progress")}))),this.mainSegmentLoader_.on("error",(function(){_this4.blacklistCurrentPlaylist(_this4.mainSegmentLoader_.error())})),this.mainSegmentLoader_.on("appenderror",(function(){_this4.error=_this4.mainSegmentLoader_.error_,_this4.trigger("error")})),this.mainSegmentLoader_.on("syncinfoupdate",(function(){_this4.onSyncInfoUpdate_()})),this.mainSegmentLoader_.on("timestampoffset",(function(){_this4.tech_.trigger({type:"usage",name:"vhs-timestamp-offset"}),_this4.tech_.trigger({type:"usage",name:"hls-timestamp-offset"})})),this.audioSegmentLoader_.on("syncinfoupdate",(function(){_this4.onSyncInfoUpdate_()})),this.audioSegmentLoader_.on("appenderror",(function(){_this4.error=_this4.audioSegmentLoader_.error_,_this4.trigger("error")})),this.mainSegmentLoader_.on("ended",(function(){_this4.logger_("main segment loader ended"),_this4.onEndOfStream()})),this.mainSegmentLoader_.on("earlyabort",(function(event){_this4.experimentalBufferBasedABR||(_this4.delegateLoaders_("all",["abort"]),_this4.blacklistCurrentPlaylist({message:"Aborted early because there isn't enough bandwidth to complete the request without rebuffering."},120))}));var updateCodecs=function(){if(!_this4.sourceUpdater_.hasCreatedSourceBuffers())return _this4.tryToCreateSourceBuffers_();var codecs=_this4.getCodecsOrExclude_();codecs&&_this4.sourceUpdater_.addOrChangeSourceBuffers(codecs)};this.mainSegmentLoader_.on("trackinfo",updateCodecs),this.audioSegmentLoader_.on("trackinfo",updateCodecs),this.mainSegmentLoader_.on("fmp4",(function(){_this4.triggeredFmp4Usage||(_this4.tech_.trigger({type:"usage",name:"vhs-fmp4"}),_this4.tech_.trigger({type:"usage",name:"hls-fmp4"}),_this4.triggeredFmp4Usage=!0)})),this.audioSegmentLoader_.on("fmp4",(function(){_this4.triggeredFmp4Usage||(_this4.tech_.trigger({type:"usage",name:"vhs-fmp4"}),_this4.tech_.trigger({type:"usage",name:"hls-fmp4"}),_this4.triggeredFmp4Usage=!0)})),this.audioSegmentLoader_.on("ended",(function(){_this4.logger_("audioSegmentLoader ended"),_this4.onEndOfStream()}))},_proto.mediaSecondsLoaded_=function(){return Math.max(this.audioSegmentLoader_.mediaSecondsLoaded+this.mainSegmentLoader_.mediaSecondsLoaded)},_proto.load=function(){this.mainSegmentLoader_.load(),this.mediaTypes_.AUDIO.activePlaylistLoader&&this.audioSegmentLoader_.load(),this.mediaTypes_.SUBTITLES.activePlaylistLoader&&this.subtitleSegmentLoader_.load()},_proto.smoothQualityChange_=function(media){void 0===media&&(media=this.selectPlaylist()),this.fastQualityChange_(media)},_proto.fastQualityChange_=function(media){var _this5=this;void 0===media&&(media=this.selectPlaylist()),media!==this.masterPlaylistLoader_.media()?(this.switchMedia_(media,"fast-quality"),this.mainSegmentLoader_.resetEverything((function(){videojs.browser.IE_VERSION||videojs.browser.IS_EDGE?_this5.tech_.setCurrentTime(_this5.tech_.currentTime()+.04):_this5.tech_.setCurrentTime(_this5.tech_.currentTime())}))):this.logger_("skipping fastQualityChange because new media is same as old")},_proto.play=function(){if(!this.setupFirstPlay()){this.tech_.ended()&&this.tech_.setCurrentTime(0),this.hasPlayed_&&this.load();var seekable=this.tech_.seekable();return this.tech_.duration()===1/0&&this.tech_.currentTime()<seekable.start(0)?this.tech_.setCurrentTime(seekable.end(seekable.length-1)):void 0}},_proto.setupFirstPlay=function(){var _this6=this,media=this.masterPlaylistLoader_.media();if(!media||this.tech_.paused()||this.hasPlayed_)return!1;if(!media.endList){var seekable=this.seekable();if(!seekable.length)return!1;if(videojs.browser.IE_VERSION&&0===this.tech_.readyState())return this.tech_.one("loadedmetadata",(function(){_this6.trigger("firstplay"),_this6.tech_.setCurrentTime(seekable.end(0)),_this6.hasPlayed_=!0})),!1;this.trigger("firstplay"),this.tech_.setCurrentTime(seekable.end(0))}return this.hasPlayed_=!0,this.load(),!0},_proto.handleSourceOpen_=function(){if(this.tryToCreateSourceBuffers_(),this.tech_.autoplay()){var playPromise=this.tech_.play();void 0!==playPromise&&"function"==typeof playPromise.then&&playPromise.then(null,(function(e){}))}this.trigger("sourceopen")},_proto.handleSourceEnded_=function(){if(this.inbandTextTracks_.metadataTrack_){var cues=this.inbandTextTracks_.metadataTrack_.cues;if(cues&&cues.length){var duration=this.duration();cues[cues.length-1].endTime=isNaN(duration)||Math.abs(duration)===1/0?Number.MAX_VALUE:duration}}},_proto.handleDurationChange_=function(){this.tech_.trigger("durationchange")},_proto.onEndOfStream=function(){var isEndOfStream=this.mainSegmentLoader_.ended_;if(this.mediaTypes_.AUDIO.activePlaylistLoader){var mainMediaInfo=this.mainSegmentLoader_.getCurrentMediaInfo_();isEndOfStream=!mainMediaInfo||mainMediaInfo.hasVideo?isEndOfStream&&this.audioSegmentLoader_.ended_:this.audioSegmentLoader_.ended_}isEndOfStream&&(this.stopABRTimer_(),this.sourceUpdater_.endOfStream())},_proto.stuckAtPlaylistEnd_=function(playlist){if(!this.seekable().length)return!1;var expired=this.syncController_.getExpiredTime(playlist,this.duration());if(null===expired)return!1;var absolutePlaylistEnd=Vhs$1.Playlist.playlistEnd(playlist,expired),currentTime=this.tech_.currentTime(),buffered=this.tech_.buffered();if(!buffered.length)return absolutePlaylistEnd-currentTime<=.1;var bufferedEnd=buffered.end(buffered.length-1);return bufferedEnd-currentTime<=.1&&absolutePlaylistEnd-bufferedEnd<=.1},_proto.blacklistCurrentPlaylist=function(error,blacklistDuration){void 0===error&&(error={});var currentPlaylist=error.playlist||this.masterPlaylistLoader_.media();if(blacklistDuration=blacklistDuration||error.blacklistDuration||this.blacklistDuration,!currentPlaylist)return this.error=error,void("open"!==this.mediaSource.readyState?this.trigger("error"):this.sourceUpdater_.endOfStream("network"));currentPlaylist.playlistErrors_++;var excludeUntil,playlists=this.masterPlaylistLoader_.master.playlists,enabledPlaylists=playlists.filter(isEnabled),isFinalRendition=1===enabledPlaylists.length&&enabledPlaylists[0]===currentPlaylist;if(1===playlists.length&&blacklistDuration!==1/0)return videojs.log.warn("Problem encountered with playlist "+currentPlaylist.id+". Trying again since it is the only playlist."),this.tech_.trigger("retryplaylist"),this.masterPlaylistLoader_.load(isFinalRendition);if(isFinalRendition){var reincluded=!1;playlists.forEach((function(playlist){if(playlist!==currentPlaylist){var excludeUntil=playlist.excludeUntil;void 0!==excludeUntil&&excludeUntil!==1/0&&(reincluded=!0,delete playlist.excludeUntil)}})),reincluded&&(videojs.log.warn("Removing other playlists from the exclusion list because the last rendition is about to be excluded."),this.tech_.trigger("retryplaylist"))}excludeUntil=currentPlaylist.playlistErrors_>this.maxPlaylistRetries?1/0:Date.now()+1e3*blacklistDuration,currentPlaylist.excludeUntil=excludeUntil,error.reason&&(currentPlaylist.lastExcludeReason_=error.reason),this.tech_.trigger("blacklistplaylist"),this.tech_.trigger({type:"usage",name:"vhs-rendition-blacklisted"}),this.tech_.trigger({type:"usage",name:"hls-rendition-blacklisted"});var nextPlaylist=this.selectPlaylist();if(!nextPlaylist)return this.error="Playback cannot continue. No available working or supported playlists.",void this.trigger("error");var logFn=error.internal?this.logger_:videojs.log.warn,errorMessage=error.message?" "+error.message:"";logFn((error.internal?"Internal problem":"Problem")+" encountered with playlist "+currentPlaylist.id+"."+errorMessage+" Switching to playlist "+nextPlaylist.id+"."),nextPlaylist.attributes.AUDIO!==currentPlaylist.attributes.AUDIO&&this.delegateLoaders_("audio",["abort","pause"]),nextPlaylist.attributes.SUBTITLES!==currentPlaylist.attributes.SUBTITLES&&this.delegateLoaders_("subtitle",["abort","pause"]),this.delegateLoaders_("main",["abort","pause"]);var delayDuration=nextPlaylist.targetDuration/2*1e3||5e3,shouldDelay="number"==typeof nextPlaylist.lastRequest&&Date.now()-nextPlaylist.lastRequest<=delayDuration;return this.switchMedia_(nextPlaylist,"exclude",isFinalRendition||shouldDelay)},_proto.pauseLoading=function(){this.delegateLoaders_("all",["abort","pause"]),this.stopABRTimer_()},_proto.delegateLoaders_=function(filter,fnNames){var _this7=this,loaders=[],dontFilterPlaylist="all"===filter;(dontFilterPlaylist||"main"===filter)&&loaders.push(this.masterPlaylistLoader_);var mediaTypes=[];(dontFilterPlaylist||"audio"===filter)&&mediaTypes.push("AUDIO"),(dontFilterPlaylist||"subtitle"===filter)&&(mediaTypes.push("CLOSED-CAPTIONS"),mediaTypes.push("SUBTITLES")),mediaTypes.forEach((function(mediaType){var loader=_this7.mediaTypes_[mediaType]&&_this7.mediaTypes_[mediaType].activePlaylistLoader;loader&&loaders.push(loader)})),["main","audio","subtitle"].forEach((function(name){var loader=_this7[name+"SegmentLoader_"];!loader||filter!==name&&"all"!==filter||loaders.push(loader)})),loaders.forEach((function(loader){return fnNames.forEach((function(fnName){"function"==typeof loader[fnName]&&loader[fnName]()}))}))},_proto.setCurrentTime=function(currentTime){var buffered=findRange(this.tech_.buffered(),currentTime);return this.masterPlaylistLoader_&&this.masterPlaylistLoader_.media()&&this.masterPlaylistLoader_.media().segments?buffered&&buffered.length?currentTime:(this.mainSegmentLoader_.resetEverything(),this.mainSegmentLoader_.abort(),this.mediaTypes_.AUDIO.activePlaylistLoader&&(this.audioSegmentLoader_.resetEverything(),this.audioSegmentLoader_.abort()),this.mediaTypes_.SUBTITLES.activePlaylistLoader&&(this.subtitleSegmentLoader_.resetEverything(),this.subtitleSegmentLoader_.abort()),void this.load()):0},_proto.duration=function(){if(!this.masterPlaylistLoader_)return 0;var media=this.masterPlaylistLoader_.media();return media?media.endList?this.mediaSource?this.mediaSource.duration:Vhs$1.Playlist.duration(media):1/0:0},_proto.seekable=function(){return this.seekable_},_proto.onSyncInfoUpdate_=function(){var audioSeekable;if(this.masterPlaylistLoader_&&!this.sourceUpdater_.hasCreatedSourceBuffers()){var media=this.masterPlaylistLoader_.media();if(media){var expired=this.syncController_.getExpiredTime(media,this.duration());if(null!==expired){var master=this.masterPlaylistLoader_.master,mainSeekable=Vhs$1.Playlist.seekable(media,expired,Vhs$1.Playlist.liveEdgeDelay(master,media));if(0!==mainSeekable.length){if(this.mediaTypes_.AUDIO.activePlaylistLoader){if(media=this.mediaTypes_.AUDIO.activePlaylistLoader.media(),null===(expired=this.syncController_.getExpiredTime(media,this.duration())))return;if(0===(audioSeekable=Vhs$1.Playlist.seekable(media,expired,Vhs$1.Playlist.liveEdgeDelay(master,media))).length)return}var oldEnd,oldStart;this.seekable_&&this.seekable_.length&&(oldEnd=this.seekable_.end(0),oldStart=this.seekable_.start(0)),audioSeekable?audioSeekable.start(0)>mainSeekable.end(0)||mainSeekable.start(0)>audioSeekable.end(0)?this.seekable_=mainSeekable:this.seekable_=videojs.createTimeRanges([[audioSeekable.start(0)>mainSeekable.start(0)?audioSeekable.start(0):mainSeekable.start(0),audioSeekable.end(0)<mainSeekable.end(0)?audioSeekable.end(0):mainSeekable.end(0)]]):this.seekable_=mainSeekable,this.seekable_&&this.seekable_.length&&this.seekable_.end(0)===oldEnd&&this.seekable_.start(0)===oldStart||(this.logger_("seekable updated ["+printableRange(this.seekable_)+"]"),this.tech_.trigger("seekablechanged"))}}}}},_proto.updateDuration=function(isLive){if(this.updateDuration_&&(this.mediaSource.removeEventListener("sourceopen",this.updateDuration_),this.updateDuration_=null),"open"!==this.mediaSource.readyState)return this.updateDuration_=this.updateDuration.bind(this,isLive),void this.mediaSource.addEventListener("sourceopen",this.updateDuration_);if(isLive){var seekable=this.seekable();if(!seekable.length)return;(isNaN(this.mediaSource.duration)||this.mediaSource.duration<seekable.end(seekable.length-1))&&this.sourceUpdater_.setDuration(seekable.end(seekable.length-1))}else{var buffered=this.tech_.buffered(),duration=Vhs$1.Playlist.duration(this.masterPlaylistLoader_.media());buffered.length>0&&(duration=Math.max(duration,buffered.end(buffered.length-1))),this.mediaSource.duration!==duration&&this.sourceUpdater_.setDuration(duration)}},_proto.dispose=function(){var _this8=this;this.trigger("dispose"),this.decrypter_.terminate(),this.masterPlaylistLoader_.dispose(),this.mainSegmentLoader_.dispose(),this.loadOnPlay_&&this.tech_.off("play",this.loadOnPlay_),["AUDIO","SUBTITLES"].forEach((function(type){var groups=_this8.mediaTypes_[type].groups;for(var id in groups)groups[id].forEach((function(group){group.playlistLoader&&group.playlistLoader.dispose()}))})),this.audioSegmentLoader_.dispose(),this.subtitleSegmentLoader_.dispose(),this.sourceUpdater_.dispose(),this.timelineChangeController_.dispose(),this.stopABRTimer_(),this.updateDuration_&&this.mediaSource.removeEventListener("sourceopen",this.updateDuration_),this.mediaSource.removeEventListener("durationchange",this.handleDurationChange_),this.mediaSource.removeEventListener("sourceopen",this.handleSourceOpen_),this.mediaSource.removeEventListener("sourceended",this.handleSourceEnded_),this.off()},_proto.master=function(){return this.masterPlaylistLoader_.master},_proto.media=function(){return this.masterPlaylistLoader_.media()||this.initialMedia_},_proto.areMediaTypesKnown_=function(){var usingAudioLoader=!!this.mediaTypes_.AUDIO.activePlaylistLoader,hasMainMediaInfo=!!this.mainSegmentLoader_.getCurrentMediaInfo_(),hasAudioMediaInfo=!usingAudioLoader||!!this.audioSegmentLoader_.getCurrentMediaInfo_();return!(!hasMainMediaInfo||!hasAudioMediaInfo)},_proto.getCodecsOrExclude_=function(){var _this9=this,media={main:this.mainSegmentLoader_.getCurrentMediaInfo_()||{},audio:this.audioSegmentLoader_.getCurrentMediaInfo_()||{}};media.video=media.main;var playlistCodecs=codecsForPlaylist(this.master(),this.media()),codecs={},usingAudioLoader=!!this.mediaTypes_.AUDIO.activePlaylistLoader;if(media.main.hasVideo&&(codecs.video=playlistCodecs.video||media.main.videoCodec||"avc1.4d400d"),media.main.isMuxed&&(codecs.video+=","+(playlistCodecs.audio||media.main.audioCodec||"mp4a.40.2")),(media.main.hasAudio&&!media.main.isMuxed||media.audio.hasAudio||usingAudioLoader)&&(codecs.audio=playlistCodecs.audio||media.main.audioCodec||media.audio.audioCodec||"mp4a.40.2",media.audio.isFmp4=media.main.hasAudio&&!media.main.isMuxed?media.main.isFmp4:media.audio.isFmp4),codecs.audio||codecs.video){var unsupportedAudio,unsupportedCodecs={};if(["video","audio"].forEach((function(type){if(codecs.hasOwnProperty(type)&&(isFmp4=media[type].isFmp4,codec=codecs[type],!(isFmp4?browserSupportsCodec(codec):muxerSupportsCodec(codec)))){var supporter=media[type].isFmp4?"browser":"muxer";unsupportedCodecs[supporter]=unsupportedCodecs[supporter]||[],unsupportedCodecs[supporter].push(codecs[type]),"audio"===type&&(unsupportedAudio=supporter)}var isFmp4,codec})),usingAudioLoader&&unsupportedAudio&&this.media().attributes.AUDIO){var audioGroup=this.media().attributes.AUDIO;this.master().playlists.forEach((function(variant){(variant.attributes&&variant.attributes.AUDIO)===audioGroup&&variant!==_this9.media()&&(variant.excludeUntil=1/0)})),this.logger_("excluding audio group "+audioGroup+" as "+unsupportedAudio+' does not support codec(s): "'+codecs.audio+'"')}if(!Object.keys(unsupportedCodecs).length){if(this.sourceUpdater_.hasCreatedSourceBuffers()&&!this.sourceUpdater_.canChangeType()){var switchMessages=[];if(["video","audio"].forEach((function(type){var newCodec=(parseCodecs(_this9.sourceUpdater_.codecs[type]||"")[0]||{}).type,oldCodec=(parseCodecs(codecs[type]||"")[0]||{}).type;newCodec&&oldCodec&&newCodec.toLowerCase()!==oldCodec.toLowerCase()&&switchMessages.push('"'+_this9.sourceUpdater_.codecs[type]+'" -> "'+codecs[type]+'"')})),switchMessages.length)return void this.blacklistCurrentPlaylist({playlist:this.media(),message:"Codec switching not supported: "+switchMessages.join(", ")+".",blacklistDuration:1/0,internal:!0})}return codecs}var message=Object.keys(unsupportedCodecs).reduce((function(acc,supporter){return acc&&(acc+=", "),acc+=supporter+' does not support codec(s): "'+unsupportedCodecs[supporter].join(",")+'"'}),"")+".";this.blacklistCurrentPlaylist({playlist:this.media(),internal:!0,message:message,blacklistDuration:1/0})}else this.blacklistCurrentPlaylist({playlist:this.media(),message:"Could not determine codecs for playlist.",blacklistDuration:1/0})},_proto.tryToCreateSourceBuffers_=function(){if("open"===this.mediaSource.readyState&&!this.sourceUpdater_.hasCreatedSourceBuffers()&&this.areMediaTypesKnown_()){var codecs=this.getCodecsOrExclude_();if(codecs){this.sourceUpdater_.createSourceBuffers(codecs);var codecString=[codecs.video,codecs.audio].filter(Boolean).join(",");this.excludeIncompatibleVariants_(codecString)}}},_proto.excludeUnsupportedVariants_=function(){var _this10=this,playlists=this.master().playlists,ids=[];Object.keys(playlists).forEach((function(key){var variant=playlists[key];if(-1===ids.indexOf(variant.id)){ids.push(variant.id);var codecs=codecsForPlaylist(_this10.master,variant),unsupported=[];!codecs.audio||muxerSupportsCodec(codecs.audio)||browserSupportsCodec(codecs.audio)||unsupported.push("audio codec "+codecs.audio),!codecs.video||muxerSupportsCodec(codecs.video)||browserSupportsCodec(codecs.video)||unsupported.push("video codec "+codecs.video),codecs.text&&"stpp.ttml.im1t"===codecs.text&&unsupported.push("text codec "+codecs.text),unsupported.length&&(variant.excludeUntil=1/0,_this10.logger_("excluding "+variant.id+" for unsupported: "+unsupported.join(", ")))}}))},_proto.excludeIncompatibleVariants_=function(codecString){var _this11=this,ids=[],playlists=this.master().playlists,codecs=unwrapCodecList(parseCodecs(codecString)),codecCount_=codecCount(codecs),videoDetails=codecs.video&&parseCodecs(codecs.video)[0]||null,audioDetails=codecs.audio&&parseCodecs(codecs.audio)[0]||null;Object.keys(playlists).forEach((function(key){var variant=playlists[key];if(-1===ids.indexOf(variant.id)&&variant.excludeUntil!==1/0){ids.push(variant.id);var blacklistReasons=[],variantCodecs=codecsForPlaylist(_this11.masterPlaylistLoader_.master,variant),variantCodecCount=codecCount(variantCodecs);if(variantCodecs.audio||variantCodecs.video){if(variantCodecCount!==codecCount_&&blacklistReasons.push('codec count "'+variantCodecCount+'" !== "'+codecCount_+'"'),!_this11.sourceUpdater_.canChangeType()){var variantVideoDetails=variantCodecs.video&&parseCodecs(variantCodecs.video)[0]||null,variantAudioDetails=variantCodecs.audio&&parseCodecs(variantCodecs.audio)[0]||null;variantVideoDetails&&videoDetails&&variantVideoDetails.type.toLowerCase()!==videoDetails.type.toLowerCase()&&blacklistReasons.push('video codec "'+variantVideoDetails.type+'" !== "'+videoDetails.type+'"'),variantAudioDetails&&audioDetails&&variantAudioDetails.type.toLowerCase()!==audioDetails.type.toLowerCase()&&blacklistReasons.push('audio codec "'+variantAudioDetails.type+'" !== "'+audioDetails.type+'"')}blacklistReasons.length&&(variant.excludeUntil=1/0,_this11.logger_("blacklisting "+variant.id+": "+blacklistReasons.join(" && ")))}}}))},_proto.updateAdCues_=function(media){var offset=0,seekable=this.seekable();seekable.length&&(offset=seekable.start(0)),function(media,track,offset){if(void 0===offset&&(offset=0),media.segments)for(var cue,mediaTime=offset,i=0;i<media.segments.length;i++){var segment=media.segments[i];if(cue||(cue=findAdCue(track,mediaTime+segment.duration/2)),cue){if("cueIn"in segment){cue.endTime=mediaTime,cue.adEndTime=mediaTime,mediaTime+=segment.duration,cue=null;continue}if(mediaTime<cue.endTime){mediaTime+=segment.duration;continue}cue.endTime+=segment.duration}else if("cueOut"in segment&&((cue=new window.VTTCue(mediaTime,mediaTime+segment.duration,segment.cueOut)).adStartTime=mediaTime,cue.adEndTime=mediaTime+parseFloat(segment.cueOut),track.addCue(cue)),"cueOutCont"in segment){var _segment$cueOutCont$s=segment.cueOutCont.split("/").map(parseFloat),adOffset=_segment$cueOutCont$s[0],adTotal=_segment$cueOutCont$s[1];(cue=new window.VTTCue(mediaTime,mediaTime+segment.duration,"")).adStartTime=mediaTime-adOffset,cue.adEndTime=cue.adStartTime+adTotal,track.addCue(cue)}mediaTime+=segment.duration}}(media,this.cueTagsTrack_,offset)},_proto.goalBufferLength=function(){var currentTime=this.tech_.currentTime(),initial=Config.GOAL_BUFFER_LENGTH,rate=Config.GOAL_BUFFER_LENGTH_RATE,max=Math.max(initial,Config.MAX_GOAL_BUFFER_LENGTH);return Math.min(initial+currentTime*rate,max)},_proto.bufferLowWaterLine=function(){var currentTime=this.tech_.currentTime(),initial=Config.BUFFER_LOW_WATER_LINE,rate=Config.BUFFER_LOW_WATER_LINE_RATE,max=Math.max(initial,Config.MAX_BUFFER_LOW_WATER_LINE),newMax=Math.max(initial,Config.EXPERIMENTAL_MAX_BUFFER_LOW_WATER_LINE);return Math.min(initial+currentTime*rate,this.experimentalBufferBasedABR?newMax:max)},_proto.bufferHighWaterLine=function(){return Config.BUFFER_HIGH_WATER_LINE},MasterPlaylistController}(videojs.EventTarget),Representation=function(vhsHandler,playlist,id){var loader,playlistID,changePlaylistFn,mpc=vhsHandler.masterPlaylistController_,qualityChangeFunction=mpc[(vhsHandler.options_.smoothQualityChange?"smooth":"fast")+"QualityChange_"].bind(mpc);if(playlist.attributes){var resolution=playlist.attributes.RESOLUTION;this.width=resolution&&resolution.width,this.height=resolution&&resolution.height,this.bandwidth=playlist.attributes.BANDWIDTH}this.codecs=codecsForPlaylist(mpc.master(),playlist),this.playlist=playlist,this.id=id,this.enabled=(loader=vhsHandler.playlists,playlistID=playlist.id,changePlaylistFn=qualityChangeFunction,function(enable){var playlist=loader.master.playlists[playlistID],incompatible=isIncompatible(playlist),currentlyEnabled=isEnabled(playlist);return void 0===enable?currentlyEnabled:(enable?delete playlist.disabled:playlist.disabled=!0,enable===currentlyEnabled||incompatible||(changePlaylistFn(),enable?loader.trigger("renditionenabled"):loader.trigger("renditiondisabled")),enable)})},timerCancelEvents=["seeking","seeked","pause","playing","error"],PlaybackWatcher=function(){function PlaybackWatcher(options){var _this=this;this.masterPlaylistController_=options.masterPlaylistController,this.tech_=options.tech,this.seekable=options.seekable,this.allowSeeksWithinUnsafeLiveWindow=options.allowSeeksWithinUnsafeLiveWindow,this.liveRangeSafeTimeDelta=options.liveRangeSafeTimeDelta,this.media=options.media,this.consecutiveUpdates=0,this.lastRecordedTime=null,this.timer_=null,this.checkCurrentTimeTimeout_=null,this.logger_=logger("PlaybackWatcher"),this.logger_("initialize");var playHandler=function(){return _this.monitorCurrentTime_()},canPlayHandler=function(){return _this.monitorCurrentTime_()},waitingHandler=function(){return _this.techWaiting_()},cancelTimerHandler=function(){return _this.cancelTimer_()},mpc=this.masterPlaylistController_,loaderTypes=["main","subtitle","audio"],loaderChecks={};loaderTypes.forEach((function(type){loaderChecks[type]={reset:function(){return _this.resetSegmentDownloads_(type)},updateend:function(){return _this.checkSegmentDownloads_(type)}},mpc[type+"SegmentLoader_"].on("appendsdone",loaderChecks[type].updateend),mpc[type+"SegmentLoader_"].on("playlistupdate",loaderChecks[type].reset),_this.tech_.on(["seeked","seeking"],loaderChecks[type].reset)}));var setSeekingHandlers=function(fn){["main","audio"].forEach((function(type){mpc[type+"SegmentLoader_"][fn]("appended",_this.seekingAppendCheck_)}))};this.seekingAppendCheck_=function(){_this.fixesBadSeeks_()&&(_this.consecutiveUpdates=0,_this.lastRecordedTime=_this.tech_.currentTime(),setSeekingHandlers("off"))},this.clearSeekingAppendCheck_=function(){return setSeekingHandlers("off")},this.watchForBadSeeking_=function(){_this.clearSeekingAppendCheck_(),setSeekingHandlers("on")},this.tech_.on("seeked",this.clearSeekingAppendCheck_),this.tech_.on("seeking",this.watchForBadSeeking_),this.tech_.on("waiting",waitingHandler),this.tech_.on(timerCancelEvents,cancelTimerHandler),this.tech_.on("canplay",canPlayHandler),this.tech_.one("play",playHandler),this.dispose=function(){_this.clearSeekingAppendCheck_(),_this.logger_("dispose"),_this.tech_.off("waiting",waitingHandler),_this.tech_.off(timerCancelEvents,cancelTimerHandler),_this.tech_.off("canplay",canPlayHandler),_this.tech_.off("play",playHandler),_this.tech_.off("seeking",_this.watchForBadSeeking_),_this.tech_.off("seeked",_this.clearSeekingAppendCheck_),loaderTypes.forEach((function(type){mpc[type+"SegmentLoader_"].off("appendsdone",loaderChecks[type].updateend),mpc[type+"SegmentLoader_"].off("playlistupdate",loaderChecks[type].reset),_this.tech_.off(["seeked","seeking"],loaderChecks[type].reset)})),_this.checkCurrentTimeTimeout_&&window.clearTimeout(_this.checkCurrentTimeTimeout_),_this.cancelTimer_()}}var _proto=PlaybackWatcher.prototype;return _proto.monitorCurrentTime_=function(){this.checkCurrentTime_(),this.checkCurrentTimeTimeout_&&window.clearTimeout(this.checkCurrentTimeTimeout_),this.checkCurrentTimeTimeout_=window.setTimeout(this.monitorCurrentTime_.bind(this),250)},_proto.resetSegmentDownloads_=function(type){var loader=this.masterPlaylistController_[type+"SegmentLoader_"];this[type+"StalledDownloads_"]>0&&this.logger_("resetting possible stalled download count for "+type+" loader"),this[type+"StalledDownloads_"]=0,this[type+"Buffered_"]=loader.buffered_()},_proto.checkSegmentDownloads_=function(type){var mpc=this.masterPlaylistController_,loader=mpc[type+"SegmentLoader_"],buffered=loader.buffered_(),isBufferedDifferent=function(a,b){if(a===b)return!1;if(!a&&b||!b&&a)return!0;if(a.length!==b.length)return!0;for(var i=0;i<a.length;i++)if(a.start(i)!==b.start(i)||a.end(i)!==b.end(i))return!0;return!1}(this[type+"Buffered_"],buffered);this[type+"Buffered_"]=buffered,isBufferedDifferent?this.resetSegmentDownloads_(type):(this[type+"StalledDownloads_"]++,this.logger_("found #"+this[type+"StalledDownloads_"]+" "+type+" appends that did not increase buffer (possible stalled download)",{playlistId:loader.playlist_&&loader.playlist_.id,buffered:timeRangesToArray(buffered)}),this[type+"StalledDownloads_"]<10||(this.logger_(type+" loader stalled download exclusion"),this.resetSegmentDownloads_(type),this.tech_.trigger({type:"usage",name:"vhs-"+type+"-download-exclusion"}),"subtitle"!==type&&mpc.blacklistCurrentPlaylist({message:"Excessive "+type+" segment downloading detected."},1/0)))},_proto.checkCurrentTime_=function(){if(!this.tech_.paused()&&!this.tech_.seeking()){var currentTime=this.tech_.currentTime(),buffered=this.tech_.buffered();if(this.lastRecordedTime===currentTime&&(!buffered.length||currentTime+.1>=buffered.end(buffered.length-1)))return this.techWaiting_();this.consecutiveUpdates>=5&&currentTime===this.lastRecordedTime?(this.consecutiveUpdates++,this.waiting_()):currentTime===this.lastRecordedTime?this.consecutiveUpdates++:(this.consecutiveUpdates=0,this.lastRecordedTime=currentTime)}},_proto.cancelTimer_=function(){this.consecutiveUpdates=0,this.timer_&&(this.logger_("cancelTimer_"),clearTimeout(this.timer_)),this.timer_=null},_proto.fixesBadSeeks_=function(){if(!this.tech_.seeking())return!1;var seekTo,seekable=this.seekable(),currentTime=this.tech_.currentTime();this.afterSeekableWindow_(seekable,currentTime,this.media(),this.allowSeeksWithinUnsafeLiveWindow)&&(seekTo=seekable.end(seekable.length-1));if(this.beforeSeekableWindow_(seekable,currentTime)){var seekableStart=seekable.start(0);seekTo=seekableStart+(seekableStart===seekable.end(0)?0:.1)}if(void 0!==seekTo)return this.logger_("Trying to seek outside of seekable at time "+currentTime+" with seekable range "+printableRange(seekable)+". Seeking to "+seekTo+"."),this.tech_.setCurrentTime(seekTo),!0;for(var sourceUpdater=this.masterPlaylistController_.sourceUpdater_,buffered=this.tech_.buffered(),audioBuffered=sourceUpdater.audioBuffer?sourceUpdater.audioBuffered():null,videoBuffered=sourceUpdater.videoBuffer?sourceUpdater.videoBuffered():null,media=this.media(),minAppendedDuration=media.partTargetDuration?media.partTargetDuration:2*(media.targetDuration-.03333333333333333),bufferedToCheck=[audioBuffered,videoBuffered],i=0;i<bufferedToCheck.length;i++){if(bufferedToCheck[i])if(timeAheadOf(bufferedToCheck[i],currentTime)<minAppendedDuration)return!1}var nextRange=findNextRange(buffered,currentTime);return 0!==nextRange.length&&(seekTo=nextRange.start(0)+.1,this.logger_("Buffered region starts ("+nextRange.start(0)+")  just beyond seek point ("+currentTime+"). Seeking to "+seekTo+"."),this.tech_.setCurrentTime(seekTo),!0)},_proto.waiting_=function(){if(!this.techWaiting_()){var currentTime=this.tech_.currentTime(),buffered=this.tech_.buffered(),currentRange=findRange(buffered,currentTime);return currentRange.length&&currentTime+3<=currentRange.end(0)?(this.cancelTimer_(),this.tech_.setCurrentTime(currentTime),this.logger_("Stopped at "+currentTime+" while inside a buffered region ["+currentRange.start(0)+" -> "+currentRange.end(0)+"]. Attempting to resume playback by seeking to the current time."),this.tech_.trigger({type:"usage",name:"vhs-unknown-waiting"}),void this.tech_.trigger({type:"usage",name:"hls-unknown-waiting"})):void 0}},_proto.techWaiting_=function(){var seekable=this.seekable(),currentTime=this.tech_.currentTime();if(this.tech_.seeking()||null!==this.timer_)return!0;if(this.beforeSeekableWindow_(seekable,currentTime)){var livePoint=seekable.end(seekable.length-1);return this.logger_("Fell out of live window at time "+currentTime+". Seeking to live point (seekable end) "+livePoint),this.cancelTimer_(),this.tech_.setCurrentTime(livePoint),this.tech_.trigger({type:"usage",name:"vhs-live-resync"}),this.tech_.trigger({type:"usage",name:"hls-live-resync"}),!0}var sourceUpdater=this.tech_.vhs.masterPlaylistController_.sourceUpdater_,buffered=this.tech_.buffered();if(this.videoUnderflow_({audioBuffered:sourceUpdater.audioBuffered(),videoBuffered:sourceUpdater.videoBuffered(),currentTime:currentTime}))return this.cancelTimer_(),this.tech_.setCurrentTime(currentTime),this.tech_.trigger({type:"usage",name:"vhs-video-underflow"}),this.tech_.trigger({type:"usage",name:"hls-video-underflow"}),!0;var nextRange=findNextRange(buffered,currentTime);if(nextRange.length>0){var difference=nextRange.start(0)-currentTime;return this.logger_("Stopped at "+currentTime+", setting timer for "+difference+", seeking to "+nextRange.start(0)),this.cancelTimer_(),this.timer_=setTimeout(this.skipTheGap_.bind(this),1e3*difference,currentTime),!0}return!1},_proto.afterSeekableWindow_=function(seekable,currentTime,playlist,allowSeeksWithinUnsafeLiveWindow){if(void 0===allowSeeksWithinUnsafeLiveWindow&&(allowSeeksWithinUnsafeLiveWindow=!1),!seekable.length)return!1;var allowedEnd=seekable.end(seekable.length-1)+.1;return!playlist.endList&&allowSeeksWithinUnsafeLiveWindow&&(allowedEnd=seekable.end(seekable.length-1)+3*playlist.targetDuration),currentTime>allowedEnd},_proto.beforeSeekableWindow_=function(seekable,currentTime){return!!(seekable.length&&seekable.start(0)>0&&currentTime<seekable.start(0)-this.liveRangeSafeTimeDelta)},_proto.videoUnderflow_=function(_ref){var videoBuffered=_ref.videoBuffered,audioBuffered=_ref.audioBuffered,currentTime=_ref.currentTime;if(videoBuffered){var gap;if(videoBuffered.length&&audioBuffered.length){var lastVideoRange=findRange(videoBuffered,currentTime-3),videoRange=findRange(videoBuffered,currentTime),audioRange=findRange(audioBuffered,currentTime);audioRange.length&&!videoRange.length&&lastVideoRange.length&&(gap={start:lastVideoRange.end(0),end:audioRange.end(0)})}else{findNextRange(videoBuffered,currentTime).length||(gap=this.gapFromVideoUnderflow_(videoBuffered,currentTime))}return!!gap&&(this.logger_("Encountered a gap in video from "+gap.start+" to "+gap.end+". Seeking to current time "+currentTime),!0)}},_proto.skipTheGap_=function(scheduledCurrentTime){var buffered=this.tech_.buffered(),currentTime=this.tech_.currentTime(),nextRange=findNextRange(buffered,currentTime);this.cancelTimer_(),0!==nextRange.length&&currentTime===scheduledCurrentTime&&(this.logger_("skipTheGap_:","currentTime:",currentTime,"scheduled currentTime:",scheduledCurrentTime,"nextRange start:",nextRange.start(0)),this.tech_.setCurrentTime(nextRange.start(0)+.03333333333333333),this.tech_.trigger({type:"usage",name:"vhs-gap-skip"}),this.tech_.trigger({type:"usage",name:"hls-gap-skip"}))},_proto.gapFromVideoUnderflow_=function(buffered,currentTime){for(var gaps=function(buffered){if(buffered.length<2)return videojs.createTimeRanges();for(var ranges=[],i=1;i<buffered.length;i++){var start=buffered.end(i-1),end=buffered.start(i);ranges.push([start,end])}return videojs.createTimeRanges(ranges)}(buffered),i=0;i<gaps.length;i++){var start=gaps.start(i),end=gaps.end(i);if(currentTime-start<4&&currentTime-start>2)return{start:start,end:end}}return null},PlaybackWatcher}(),defaultOptions={errorInterval:30,getSource:function(next){return next(this.tech({IWillNotUseThisInPlugins:!0}).currentSource_||this.currentSource())}},initPlugin=function initPlugin(player,options){var lastCalled=0,seekTo=0,localOptions=videojs.mergeOptions(defaultOptions,options);player.ready((function(){player.trigger({type:"usage",name:"vhs-error-reload-initialized"}),player.trigger({type:"usage",name:"hls-error-reload-initialized"})}));var loadedMetadataHandler=function(){seekTo&&player.currentTime(seekTo)},setSource=function(sourceObj){null!=sourceObj&&(seekTo=player.duration()!==1/0&&player.currentTime()||0,player.one("loadedmetadata",loadedMetadataHandler),player.src(sourceObj),player.trigger({type:"usage",name:"vhs-error-reload"}),player.trigger({type:"usage",name:"hls-error-reload"}),player.play())},errorHandler=function(){return Date.now()-lastCalled<1e3*localOptions.errorInterval?(player.trigger({type:"usage",name:"vhs-error-reload-canceled"}),void player.trigger({type:"usage",name:"hls-error-reload-canceled"})):localOptions.getSource&&"function"==typeof localOptions.getSource?(lastCalled=Date.now(),localOptions.getSource.call(player,setSource)):void videojs.log.error("ERROR: reloadSourceOnError - The option getSource must be a function!")},cleanupEvents=function cleanupEvents(){player.off("loadedmetadata",loadedMetadataHandler),player.off("error",errorHandler),player.off("dispose",cleanupEvents)};player.on("error",errorHandler),player.on("dispose",cleanupEvents),player.reloadSourceOnError=function(newOptions){cleanupEvents(),initPlugin(player,newOptions)}},Vhs={PlaylistLoader:PlaylistLoader,Playlist:Playlist,utils:utils,STANDARD_PLAYLIST_SELECTOR:lastBandwidthSelector,INITIAL_PLAYLIST_SELECTOR:function(){var _this=this,playlists=this.playlists.master.playlists.filter(Playlist.isEnabled);return stableSort(playlists,(function(a,b){return comparePlaylistBandwidth(a,b)})),playlists.filter((function(playlist){return!!codecsForPlaylist(_this.playlists.master,playlist).video}))[0]||null},lastBandwidthSelector:lastBandwidthSelector,movingAverageBandwidthSelector:function(decay){var average=-1,lastSystemBandwidth=-1;if(decay<0||decay>1)throw new Error("Moving average bandwidth decay must be between 0 and 1.");return function(){var pixelRatio=this.useDevicePixelRatio&&window.devicePixelRatio||1;return average<0&&(average=this.systemBandwidth,lastSystemBandwidth=this.systemBandwidth),this.systemBandwidth>0&&this.systemBandwidth!==lastSystemBandwidth&&(average=decay*this.systemBandwidth+(1-decay)*average,lastSystemBandwidth=this.systemBandwidth),simpleSelector(this.playlists.master,average,parseInt(safeGetComputedStyle(this.tech_.el(),"width"),10)*pixelRatio,parseInt(safeGetComputedStyle(this.tech_.el(),"height"),10)*pixelRatio,this.limitRenditionByPlayerDimensions,this.masterPlaylistController_)}},comparePlaylistBandwidth:comparePlaylistBandwidth,comparePlaylistResolution:function(left,right){var leftWidth,rightWidth;return left.attributes.RESOLUTION&&left.attributes.RESOLUTION.width&&(leftWidth=left.attributes.RESOLUTION.width),leftWidth=leftWidth||window.Number.MAX_VALUE,right.attributes.RESOLUTION&&right.attributes.RESOLUTION.width&&(rightWidth=right.attributes.RESOLUTION.width),leftWidth===(rightWidth=rightWidth||window.Number.MAX_VALUE)&&left.attributes.BANDWIDTH&&right.attributes.BANDWIDTH?left.attributes.BANDWIDTH-right.attributes.BANDWIDTH:leftWidth-rightWidth},xhr:xhrFactory()};Object.keys(Config).forEach((function(prop){Object.defineProperty(Vhs,prop,{get:function(){return videojs.log.warn("using Vhs."+prop+" is UNSAFE be sure you know what you are doing"),Config[prop]},set:function(value){videojs.log.warn("using Vhs."+prop+" is UNSAFE be sure you know what you are doing"),"number"!=typeof value||value<0?videojs.log.warn("value of Vhs."+prop+" must be greater than or equal to 0"):Config[prop]=value}})}));var handleVhsMediaChange=function(qualityLevels,playlistLoader){for(var newPlaylist=playlistLoader.media(),selectedIndex=-1,i=0;i<qualityLevels.length;i++)if(qualityLevels[i].id===newPlaylist.id){selectedIndex=i;break}qualityLevels.selectedIndex_=selectedIndex,qualityLevels.trigger({selectedIndex:selectedIndex,type:"change"})};Vhs.canPlaySource=function(){return videojs.log.warn("HLS is no longer a tech. Please remove it from your player's techOrder.")};var waitForKeySessionCreation=function(_ref){var player=_ref.player,sourceKeySystems=_ref.sourceKeySystems,audioMedia=_ref.audioMedia,mainPlaylists=_ref.mainPlaylists;if(!player.eme.initializeMediaKeys)return Promise.resolve();var keySystemsOptionsArr=function(playlists,keySystems){return playlists.reduce((function(keySystemsArr,playlist){if(!playlist.contentProtection)return keySystemsArr;var keySystemsOptions=keySystems.reduce((function(keySystemsObj,keySystem){var keySystemOptions=playlist.contentProtection[keySystem];return keySystemOptions&&keySystemOptions.pssh&&(keySystemsObj[keySystem]={pssh:keySystemOptions.pssh}),keySystemsObj}),{});return Object.keys(keySystemsOptions).length&&keySystemsArr.push(keySystemsOptions),keySystemsArr}),[])}(audioMedia?mainPlaylists.concat([audioMedia]):mainPlaylists,Object.keys(sourceKeySystems)),initializationFinishedPromises=[],keySessionCreatedPromises=[];return keySystemsOptionsArr.forEach((function(keySystemsOptions){keySessionCreatedPromises.push(new Promise((function(resolve,reject){player.tech_.one("keysessioncreated",resolve)}))),initializationFinishedPromises.push(new Promise((function(resolve,reject){player.eme.initializeMediaKeys({keySystems:keySystemsOptions},(function(err){err?reject(err):resolve()}))})))})),Promise.race([Promise.all(initializationFinishedPromises),Promise.race(keySessionCreatedPromises)])},setupEmeOptions=function(_ref2){var player=_ref2.player,sourceOptions=function(keySystemOptions,mainPlaylist,audioPlaylist){if(!keySystemOptions)return keySystemOptions;var codecs={};mainPlaylist&&mainPlaylist.attributes&&mainPlaylist.attributes.CODECS&&(codecs=unwrapCodecList(parseCodecs(mainPlaylist.attributes.CODECS))),audioPlaylist&&audioPlaylist.attributes&&audioPlaylist.attributes.CODECS&&(codecs.audio=audioPlaylist.attributes.CODECS);var videoContentType=getMimeForCodec(codecs.video),audioContentType=getMimeForCodec(codecs.audio),keySystemContentTypes={};for(var keySystem in keySystemOptions)keySystemContentTypes[keySystem]={},audioContentType&&(keySystemContentTypes[keySystem].audioContentType=audioContentType),videoContentType&&(keySystemContentTypes[keySystem].videoContentType=videoContentType),mainPlaylist.contentProtection&&mainPlaylist.contentProtection[keySystem]&&mainPlaylist.contentProtection[keySystem].pssh&&(keySystemContentTypes[keySystem].pssh=mainPlaylist.contentProtection[keySystem].pssh),"string"==typeof keySystemOptions[keySystem]&&(keySystemContentTypes[keySystem].url=keySystemOptions[keySystem]);return videojs.mergeOptions(keySystemOptions,keySystemContentTypes)}(_ref2.sourceKeySystems,_ref2.media,_ref2.audioMedia);return!!sourceOptions&&(player.currentSource().keySystems=sourceOptions,!(sourceOptions&&!player.eme)||(videojs.log.warn("DRM encrypted source cannot be decrypted without a DRM plugin"),!1))},getVhsLocalStorage=function(){if(!window.localStorage)return null;var storedObject=window.localStorage.getItem("videojs-vhs");if(!storedObject)return null;try{return JSON.parse(storedObject)}catch(e){return null}};Vhs.supportsNativeHls=function(){if(!document||!document.createElement)return!1;var video=document.createElement("video");if(!videojs.getTech("Html5").isSupported())return!1;return["application/vnd.apple.mpegurl","audio/mpegurl","audio/x-mpegurl","application/x-mpegurl","video/x-mpegurl","video/mpegurl","application/mpegurl"].some((function(canItPlay){return/maybe|probably/i.test(video.canPlayType(canItPlay))}))}(),Vhs.supportsNativeDash=!!(document&&document.createElement&&videojs.getTech("Html5").isSupported())&&/maybe|probably/i.test(document.createElement("video").canPlayType("application/dash+xml")),Vhs.supportsTypeNatively=function(type){return"hls"===type?Vhs.supportsNativeHls:"dash"===type&&Vhs.supportsNativeDash},Vhs.isSupported=function(){return videojs.log.warn("HLS is no longer a tech. Please remove it from your player's techOrder.")};var VhsHandler=function(_Component){function VhsHandler(source,tech,options){var _this;if(_this=_Component.call(this,tech,videojs.mergeOptions(options.hls,options.vhs))||this,options.hls&&Object.keys(options.hls).length&&videojs.log.warn("Using hls options is deprecated. Use vhs instead."),"number"==typeof options.initialBandwidth&&(_this.options_.bandwidth=options.initialBandwidth),_this.logger_=logger("VhsHandler"),tech.options_&&tech.options_.playerId){var _player=videojs(tech.options_.playerId);_player.hasOwnProperty("hls")||Object.defineProperty(_player,"hls",{get:function(){return videojs.log.warn("player.hls is deprecated. Use player.tech().vhs instead."),tech.trigger({type:"usage",name:"hls-player-access"}),assertThisInitialized(_this)},configurable:!0}),_player.hasOwnProperty("vhs")||Object.defineProperty(_player,"vhs",{get:function(){return videojs.log.warn("player.vhs is deprecated. Use player.tech().vhs instead."),tech.trigger({type:"usage",name:"vhs-player-access"}),assertThisInitialized(_this)},configurable:!0}),_player.hasOwnProperty("dash")||Object.defineProperty(_player,"dash",{get:function(){return videojs.log.warn("player.dash is deprecated. Use player.tech().vhs instead."),assertThisInitialized(_this)},configurable:!0}),_this.player_=_player}if(_this.tech_=tech,_this.source_=source,_this.stats={},_this.ignoreNextSeekingEvent_=!1,_this.setOptions_(),_this.options_.overrideNative&&tech.overrideNativeAudioTracks&&tech.overrideNativeVideoTracks)tech.overrideNativeAudioTracks(!0),tech.overrideNativeVideoTracks(!0);else if(_this.options_.overrideNative&&(tech.featuresNativeVideoTracks||tech.featuresNativeAudioTracks))throw new Error("Overriding native HLS requires emulated tracks. See https://git.io/vMpjB");return _this.on(document,["fullscreenchange","webkitfullscreenchange","mozfullscreenchange","MSFullscreenChange"],(function(event){var fullscreenElement=document.fullscreenElement||document.webkitFullscreenElement||document.mozFullScreenElement||document.msFullscreenElement;fullscreenElement&&fullscreenElement.contains(_this.tech_.el())?_this.masterPlaylistController_.fastQualityChange_():_this.masterPlaylistController_.checkABR_()})),_this.on(_this.tech_,"seeking",(function(){this.ignoreNextSeekingEvent_?this.ignoreNextSeekingEvent_=!1:this.setCurrentTime(this.tech_.currentTime())})),_this.on(_this.tech_,"error",(function(){this.tech_.error()&&this.masterPlaylistController_&&this.masterPlaylistController_.pauseLoading()})),_this.on(_this.tech_,"play",_this.play),_this}inheritsLoose(VhsHandler,_Component);var _proto=VhsHandler.prototype;return _proto.setOptions_=function(){var _this2=this;if(this.options_.withCredentials=this.options_.withCredentials||!1,this.options_.handleManifestRedirects=!1!==this.options_.handleManifestRedirects,this.options_.limitRenditionByPlayerDimensions=!1!==this.options_.limitRenditionByPlayerDimensions,this.options_.useDevicePixelRatio=this.options_.useDevicePixelRatio||!1,this.options_.smoothQualityChange=this.options_.smoothQualityChange||!1,this.options_.useBandwidthFromLocalStorage=void 0!==this.source_.useBandwidthFromLocalStorage?this.source_.useBandwidthFromLocalStorage:this.options_.useBandwidthFromLocalStorage||!1,this.options_.useNetworkInformationApi=this.options_.useNetworkInformationApi||!1,this.options_.customTagParsers=this.options_.customTagParsers||[],this.options_.customTagMappers=this.options_.customTagMappers||[],this.options_.cacheEncryptionKeys=this.options_.cacheEncryptionKeys||!1,"number"!=typeof this.options_.blacklistDuration&&(this.options_.blacklistDuration=300),"number"!=typeof this.options_.bandwidth&&this.options_.useBandwidthFromLocalStorage){var storedObject=getVhsLocalStorage();storedObject&&storedObject.bandwidth&&(this.options_.bandwidth=storedObject.bandwidth,this.tech_.trigger({type:"usage",name:"vhs-bandwidth-from-local-storage"}),this.tech_.trigger({type:"usage",name:"hls-bandwidth-from-local-storage"})),storedObject&&storedObject.throughput&&(this.options_.throughput=storedObject.throughput,this.tech_.trigger({type:"usage",name:"vhs-throughput-from-local-storage"}),this.tech_.trigger({type:"usage",name:"hls-throughput-from-local-storage"}))}"number"!=typeof this.options_.bandwidth&&(this.options_.bandwidth=Config.INITIAL_BANDWIDTH),this.options_.enableLowInitialPlaylist=this.options_.enableLowInitialPlaylist&&this.options_.bandwidth===Config.INITIAL_BANDWIDTH,["withCredentials","useDevicePixelRatio","limitRenditionByPlayerDimensions","bandwidth","smoothQualityChange","customTagParsers","customTagMappers","handleManifestRedirects","cacheEncryptionKeys","playlistSelector","initialPlaylistSelector","experimentalBufferBasedABR","liveRangeSafeTimeDelta","experimentalLLHLS","useNetworkInformationApi","experimentalExactManifestTimings","experimentalLeastPixelDiffSelector"].forEach((function(option){void 0!==_this2.source_[option]&&(_this2.options_[option]=_this2.source_[option])})),this.limitRenditionByPlayerDimensions=this.options_.limitRenditionByPlayerDimensions,this.useDevicePixelRatio=this.options_.useDevicePixelRatio},_proto.src=function(_src,type){var _this3=this;if(_src){var dataUri;this.setOptions_(),this.options_.src=0===(dataUri=this.source_.src).toLowerCase().indexOf("data:application/vnd.videojs.vhs+json,")?JSON.parse(dataUri.substring(dataUri.indexOf(",")+1)):dataUri,this.options_.tech=this.tech_,this.options_.externVhs=Vhs,this.options_.sourceType=simpleTypeFromSourceType(type),this.options_.seekTo=function(time){_this3.tech_.setCurrentTime(time)},this.options_.smoothQualityChange&&videojs.log.warn("smoothQualityChange is deprecated and will be removed in the next major version"),this.masterPlaylistController_=new MasterPlaylistController(this.options_);var playbackWatcherOptions=videojs.mergeOptions({liveRangeSafeTimeDelta:.1},this.options_,{seekable:function(){return _this3.seekable()},media:function(){return _this3.masterPlaylistController_.media()},masterPlaylistController:this.masterPlaylistController_});this.playbackWatcher_=new PlaybackWatcher(playbackWatcherOptions),this.masterPlaylistController_.on("error",(function(){var player=videojs.players[_this3.tech_.options_.playerId],error=_this3.masterPlaylistController_.error;"object"!=typeof error||error.code?"string"==typeof error&&(error={message:error,code:3}):error.code=3,player.error(error)}));var defaultSelector=this.options_.experimentalBufferBasedABR?Vhs.movingAverageBandwidthSelector(.55):Vhs.STANDARD_PLAYLIST_SELECTOR;this.masterPlaylistController_.selectPlaylist=this.selectPlaylist?this.selectPlaylist.bind(this):defaultSelector.bind(this),this.masterPlaylistController_.selectInitialPlaylist=Vhs.INITIAL_PLAYLIST_SELECTOR.bind(this),this.playlists=this.masterPlaylistController_.masterPlaylistLoader_,this.mediaSource=this.masterPlaylistController_.mediaSource,Object.defineProperties(this,{selectPlaylist:{get:function(){return this.masterPlaylistController_.selectPlaylist},set:function(selectPlaylist){this.masterPlaylistController_.selectPlaylist=selectPlaylist.bind(this)}},throughput:{get:function(){return this.masterPlaylistController_.mainSegmentLoader_.throughput.rate},set:function(throughput){this.masterPlaylistController_.mainSegmentLoader_.throughput.rate=throughput,this.masterPlaylistController_.mainSegmentLoader_.throughput.count=1}},bandwidth:{get:function(){var playerBandwidthEst=this.masterPlaylistController_.mainSegmentLoader_.bandwidth,networkInformation=window.navigator.connection||window.navigator.mozConnection||window.navigator.webkitConnection;if(this.options_.useNetworkInformationApi&&networkInformation){var networkInfoBandwidthEstBitsPerSec=1e3*networkInformation.downlink*1e3;playerBandwidthEst=networkInfoBandwidthEstBitsPerSec>=1e7&&playerBandwidthEst>=1e7?Math.max(playerBandwidthEst,networkInfoBandwidthEstBitsPerSec):networkInfoBandwidthEstBitsPerSec}return playerBandwidthEst},set:function(bandwidth){this.masterPlaylistController_.mainSegmentLoader_.bandwidth=bandwidth,this.masterPlaylistController_.mainSegmentLoader_.throughput={rate:0,count:0}}},systemBandwidth:{get:function(){var invThroughput,invBandwidth=1/(this.bandwidth||1);return invThroughput=this.throughput>0?1/this.throughput:0,Math.floor(1/(invBandwidth+invThroughput))},set:function(){videojs.log.error('The "systemBandwidth" property is read-only')}}}),this.options_.bandwidth&&(this.bandwidth=this.options_.bandwidth),this.options_.throughput&&(this.throughput=this.options_.throughput),Object.defineProperties(this.stats,{bandwidth:{get:function(){return _this3.bandwidth||0},enumerable:!0},mediaRequests:{get:function(){return _this3.masterPlaylistController_.mediaRequests_()||0},enumerable:!0},mediaRequestsAborted:{get:function(){return _this3.masterPlaylistController_.mediaRequestsAborted_()||0},enumerable:!0},mediaRequestsTimedout:{get:function(){return _this3.masterPlaylistController_.mediaRequestsTimedout_()||0},enumerable:!0},mediaRequestsErrored:{get:function(){return _this3.masterPlaylistController_.mediaRequestsErrored_()||0},enumerable:!0},mediaTransferDuration:{get:function(){return _this3.masterPlaylistController_.mediaTransferDuration_()||0},enumerable:!0},mediaBytesTransferred:{get:function(){return _this3.masterPlaylistController_.mediaBytesTransferred_()||0},enumerable:!0},mediaSecondsLoaded:{get:function(){return _this3.masterPlaylistController_.mediaSecondsLoaded_()||0},enumerable:!0},mediaAppends:{get:function(){return _this3.masterPlaylistController_.mediaAppends_()||0},enumerable:!0},mainAppendsToLoadedData:{get:function(){return _this3.masterPlaylistController_.mainAppendsToLoadedData_()||0},enumerable:!0},audioAppendsToLoadedData:{get:function(){return _this3.masterPlaylistController_.audioAppendsToLoadedData_()||0},enumerable:!0},appendsToLoadedData:{get:function(){return _this3.masterPlaylistController_.appendsToLoadedData_()||0},enumerable:!0},timeToLoadedData:{get:function(){return _this3.masterPlaylistController_.timeToLoadedData_()||0},enumerable:!0},buffered:{get:function(){return timeRangesToArray(_this3.tech_.buffered())},enumerable:!0},currentTime:{get:function(){return _this3.tech_.currentTime()},enumerable:!0},currentSource:{get:function(){return _this3.tech_.currentSource_},enumerable:!0},currentTech:{get:function(){return _this3.tech_.name_},enumerable:!0},duration:{get:function(){return _this3.tech_.duration()},enumerable:!0},master:{get:function(){return _this3.playlists.master},enumerable:!0},playerDimensions:{get:function(){return _this3.tech_.currentDimensions()},enumerable:!0},seekable:{get:function(){return timeRangesToArray(_this3.tech_.seekable())},enumerable:!0},timestamp:{get:function(){return Date.now()},enumerable:!0},videoPlaybackQuality:{get:function(){return _this3.tech_.getVideoPlaybackQuality()},enumerable:!0}}),this.tech_.one("canplay",this.masterPlaylistController_.setupFirstPlay.bind(this.masterPlaylistController_)),this.tech_.on("bandwidthupdate",(function(){_this3.options_.useBandwidthFromLocalStorage&&function(options){if(!window.localStorage)return!1;var objectToStore=getVhsLocalStorage();objectToStore=objectToStore?videojs.mergeOptions(objectToStore,options):options;try{window.localStorage.setItem("videojs-vhs",JSON.stringify(objectToStore))}catch(e){return!1}}({bandwidth:_this3.bandwidth,throughput:Math.round(_this3.throughput)})})),this.masterPlaylistController_.on("selectedinitialmedia",(function(){var vhsHandler;(vhsHandler=_this3).representations=function(){var master=vhsHandler.masterPlaylistController_.master(),playlists=isAudioOnly(master)?vhsHandler.masterPlaylistController_.getAudioTrackPlaylists_():master.playlists;return playlists?playlists.filter((function(media){return!isIncompatible(media)})).map((function(e,i){return new Representation(vhsHandler,e,e.id)})):[]}})),this.masterPlaylistController_.sourceUpdater_.on("createdsourcebuffers",(function(){_this3.setupEme_()})),this.on(this.masterPlaylistController_,"progress",(function(){this.tech_.trigger("progress")})),this.on(this.masterPlaylistController_,"firstplay",(function(){this.ignoreNextSeekingEvent_=!0})),this.setupQualityLevels_(),this.tech_.el()&&(this.mediaSourceUrl_=window.URL.createObjectURL(this.masterPlaylistController_.mediaSource),this.tech_.src(this.mediaSourceUrl_))}},_proto.setupEme_=function(){var _this4=this,audioPlaylistLoader=this.masterPlaylistController_.mediaTypes_.AUDIO.activePlaylistLoader,didSetupEmeOptions=setupEmeOptions({player:this.player_,sourceKeySystems:this.source_.keySystems,media:this.playlists.media(),audioMedia:audioPlaylistLoader&&audioPlaylistLoader.media()});this.player_.tech_.on("keystatuschange",(function(e){"output-restricted"===e.status&&_this4.masterPlaylistController_.blacklistCurrentPlaylist({playlist:_this4.masterPlaylistController_.media(),message:"DRM keystatus changed to "+e.status+". Playlist will fail to play. Check for HDCP content.",blacklistDuration:1/0})})),11!==videojs.browser.IE_VERSION&&didSetupEmeOptions?(this.logger_("waiting for EME key session creation"),waitForKeySessionCreation({player:this.player_,sourceKeySystems:this.source_.keySystems,audioMedia:audioPlaylistLoader&&audioPlaylistLoader.media(),mainPlaylists:this.playlists.master.playlists}).then((function(){_this4.logger_("created EME key session"),_this4.masterPlaylistController_.sourceUpdater_.initializedEme()})).catch((function(err){_this4.logger_("error while creating EME key session",err),_this4.player_.error({message:"Failed to initialize media keys for EME",code:3})}))):this.masterPlaylistController_.sourceUpdater_.initializedEme()},_proto.setupQualityLevels_=function(){var _this5=this,player=videojs.players[this.tech_.options_.playerId];player&&player.qualityLevels&&!this.qualityLevels_&&(this.qualityLevels_=player.qualityLevels(),this.masterPlaylistController_.on("selectedinitialmedia",(function(){var qualityLevels,vhs;qualityLevels=_this5.qualityLevels_,(vhs=_this5).representations().forEach((function(rep){qualityLevels.addQualityLevel(rep)})),handleVhsMediaChange(qualityLevels,vhs.playlists)})),this.playlists.on("mediachange",(function(){handleVhsMediaChange(_this5.qualityLevels_,_this5.playlists)})))},VhsHandler.version=function(){return{"@videojs/http-streaming":"2.12.0","mux.js":"5.14.1","mpd-parser":"0.19.2","m3u8-parser":"4.7.0","aes-decrypter":"3.1.2"}},_proto.version=function(){return this.constructor.version()},_proto.canChangeType=function(){return SourceUpdater.canChangeType()},_proto.play=function(){this.masterPlaylistController_.play()},_proto.setCurrentTime=function(currentTime){this.masterPlaylistController_.setCurrentTime(currentTime)},_proto.duration=function(){return this.masterPlaylistController_.duration()},_proto.seekable=function(){return this.masterPlaylistController_.seekable()},_proto.dispose=function(){this.playbackWatcher_&&this.playbackWatcher_.dispose(),this.masterPlaylistController_&&this.masterPlaylistController_.dispose(),this.qualityLevels_&&this.qualityLevels_.dispose(),this.player_&&(delete this.player_.vhs,delete this.player_.dash,delete this.player_.hls),this.tech_&&this.tech_.vhs&&delete this.tech_.vhs,this.tech_&&delete this.tech_.hls,this.mediaSourceUrl_&&window.URL.revokeObjectURL&&(window.URL.revokeObjectURL(this.mediaSourceUrl_),this.mediaSourceUrl_=null),_Component.prototype.dispose.call(this)},_proto.convertToProgramTime=function(time,callback){return getProgramTime({playlist:this.masterPlaylistController_.media(),time:time,callback:callback})},_proto.seekToProgramTime=function(programTime,callback,pauseAfterSeek,retryCount){return void 0===pauseAfterSeek&&(pauseAfterSeek=!0),void 0===retryCount&&(retryCount=2),seekToProgramTime({programTime:programTime,playlist:this.masterPlaylistController_.media(),retryCount:retryCount,pauseAfterSeek:pauseAfterSeek,seekTo:this.options_.seekTo,tech:this.options_.tech,callback:callback})},VhsHandler}(videojs.getComponent("Component")),VhsSourceHandler={name:"videojs-http-streaming",VERSION:"2.12.0",canHandleSource:function(srcObj,options){void 0===options&&(options={});var localOptions=videojs.mergeOptions(videojs.options,options);return VhsSourceHandler.canPlayType(srcObj.type,localOptions)},handleSource:function(source,tech,options){void 0===options&&(options={});var localOptions=videojs.mergeOptions(videojs.options,options);return tech.vhs=new VhsHandler(source,tech,localOptions),videojs.hasOwnProperty("hls")||Object.defineProperty(tech,"hls",{get:function(){return videojs.log.warn("player.tech().hls is deprecated. Use player.tech().vhs instead."),tech.vhs},configurable:!0}),tech.vhs.xhr=xhrFactory(),tech.vhs.src(source.src,source.type),tech.vhs},canPlayType:function(type,options){void 0===options&&(options={});var _videojs$mergeOptions2=videojs.mergeOptions(videojs.options,options).vhs.overrideNative,overrideNative=void 0===_videojs$mergeOptions2?!videojs.browser.IS_ANY_SAFARI:_videojs$mergeOptions2,supportedType=simpleTypeFromSourceType(type);return supportedType&&(!Vhs.supportsTypeNatively(supportedType)||overrideNative)?"maybe":""}};(browserSupportsCodec("avc1.4d400d,mp4a.40.2")&&videojs.getTech("Html5").registerSourceHandler(VhsSourceHandler,0),videojs.VhsHandler=VhsHandler,Object.defineProperty(videojs,"HlsHandler",{get:function(){return videojs.log.warn("videojs.HlsHandler is deprecated. Use videojs.VhsHandler instead."),VhsHandler},configurable:!0}),videojs.VhsSourceHandler=VhsSourceHandler,Object.defineProperty(videojs,"HlsSourceHandler",{get:function(){return videojs.log.warn("videojs.HlsSourceHandler is deprecated. Use videojs.VhsSourceHandler instead."),VhsSourceHandler},configurable:!0}),videojs.Vhs=Vhs,Object.defineProperty(videojs,"Hls",{get:function(){return videojs.log.warn("videojs.Hls is deprecated. Use videojs.Vhs instead."),Vhs},configurable:!0}),videojs.use||(videojs.registerComponent("Hls",Vhs),videojs.registerComponent("Vhs",Vhs)),videojs.options.vhs=videojs.options.vhs||{},videojs.options.hls=videojs.options.hls||{},videojs.getPlugin&&videojs.getPlugin("reloadSourceOnError"))||(videojs.registerPlugin||videojs.plugin)("reloadSourceOnError",(function(options){initPlugin(this,options)}));return videojs}));

//# sourceMappingURL=video-lazy.min.js.map