<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'tiny_premium', language 'en'.
 *
 * @package     tiny_premium
 * @category    string
 * @copyright   2023 David Woloszyn <david.woloszyn@moodle.com>
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accessibilitycheckerinfo'] = 'The TinyMCE Premium Accessibility Checker will override the default Accessibility Checker for users who have access to it.';
$string['apikey'] = 'API key';
$string['apikey_desc'] = 'Your API key is available on your <a href="https://www.tiny.cloud">Tiny Cloud</a> account page if you have purchased a subscription, or if you are on a free trial.';
$string['emptyapikeywarning'] = 'Enabled TinyMCE Premium plugins will not be available until an API key is added.';
$string['pluginname'] = 'TinyMCE Premium';
$string['pluginnotfound'] = 'Tiny Premium plugin {$a} not found.';
$string['premium:use'] = 'Use TinyMCE Premium';
$string['premium:usea11ychecker'] = 'Use TinyMCE Premium Accessibility Checker';
$string['premium:useadvtable'] = 'Use TinyMCE Premium Advanced Table';
$string['premium:useautocorrect'] = 'Use TinyMCE Premium Spelling Autocorrect';
$string['premium:usecasechange'] = 'Use TinyMCE Premium Case Change';
$string['premium:usechecklist'] = 'Use TinyMCE Premium Checklist';
$string['premium:useeditimage'] = 'Use TinyMCE Premium Enhanced Image Editing';
$string['premium:useexport'] = 'Use TinyMCE Premium Export';
$string['premium:usefootnotes'] = 'Use TinyMCE Premium Footnotes';
$string['premium:useformatpainter'] = 'Use TinyMCE Premium Format Painter';
$string['premium:uselinkchecker'] = 'Use TinyMCE Premium Link Checker';
$string['premium:usemath'] = 'Use TinyMCE Premium Math Tool';
$string['premium:usepageembed'] = 'Use TinyMCE Premium Page Embed';
$string['premium:usepermanentpen'] = 'Use TinyMCE Premium Permanent Pen';
$string['premium:usepowerpaste'] = 'Use TinyMCE Premium Powerpaste';
$string['premium:usetableofcontents'] = 'Use TinyMCE Premium Table of Contents';
$string['premium:usetinymcespellchecker'] = 'Use TinyMCE Premium Spell Checker Pro';
$string['premium:usetypography'] = 'Use TinyMCE Premium Advanced Typography';
$string['premiumplugin:a11ychecker'] = 'Accessibility Checker';
$string['premiumplugin:advtable'] = 'Advanced Table';
$string['premiumplugin:autocorrect'] = 'Spelling Autocorrect';
$string['premiumplugin:casechange'] = 'Case Change';
$string['premiumplugin:checklist'] = 'Checklist';
$string['premiumplugin:editimage'] = 'Enhanced Image Editing';
$string['premiumplugin:export'] = 'Export';
$string['premiumplugin:footnotes'] = 'Footnotes';
$string['premiumplugin:formatpainter'] = 'Format Painter';
$string['premiumplugin:linkchecker'] = 'Link Checker';
$string['premiumplugin:math'] = 'Math Tool';
$string['premiumplugin:pageembed'] = 'Page Embed';
$string['premiumplugin:permanentpen'] = 'Permanent Pen';
$string['premiumplugin:powerpaste'] = 'Powerpaste';
$string['premiumplugin:tableofcontents'] = 'Table of Contents';
$string['premiumplugin:tinymcespellchecker'] = 'Spell Checker Pro';
$string['premiumplugin:typography'] = 'Advanced Typography';
$string['premiumplugins'] = 'Premium plugins';
$string['premiumplugins_desc'] = 'Access to TinyMCE Premium plugins requires an API key. Not all listed plugins may be available with your TinyMCE Premium subscription. You can check available plugins on your <a href="https://www.tiny.cloud">Tiny Cloud</a> account page.';
$string['privacy:metadata'] = 'The Tiny Premium plugin for TinyMCE does not store any personal data.';

// Deprecated since Moodle 4.5.
$string['helplinktext'] = 'Premium plugins';

// Deprecated since Moodle 5.0.
$string['premium:accesspremium'] = 'Access TinyMCE Premium features';
